import API from './api.js';
import { IServerOptions } from './configuration.js';
import type { Logger } from '../logger.js';
export declare const enum TypeScriptVersionSource {
    Bundled = "bundled",
    UserSetting = "user-setting",
    Workspace = "workspace"
}
export declare class TypeScriptVersion {
    readonly source: TypeScriptVersionSource;
    readonly path: string;
    private readonly _pathLabel?;
    private readonly logger?;
    private _api;
    constructor(source: TypeScriptVersionSource, path: string, _pathLabel?: string | undefined, logger?: Logger | undefined);
    get tscPath(): string;
    get tsServerPath(): string;
    get pathLabel(): string;
    get isValid(): boolean;
    get version(): API | null;
    get versionString(): string | null;
    private getTypeScriptVersion;
}
export declare const MODULE_FOLDERS: string[];
export declare class TypeScriptVersionProvider {
    private configuration?;
    private logger?;
    constructor(configuration?: IServerOptions | undefined, logger?: Logger | undefined);
    getUserSettingVersion(): TypeScriptVersion | null;
    getWorkspaceVersion(workspaceFolders: string[]): TypeScriptVersion | null;
    bundledVersion(): TypeScriptVersion | null;
}
//# sourceMappingURL=versionProvider.d.ts.map