// generated by Fast Light User Interface Designer (fluid) version 1.0308

#include "PartUI.h"
// PartUI.cc
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2014-2022, Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is derivative of ZynAddSubFX original code.


#include <FL/fl_ask.H>
    #include <iostream>
    #include "Misc/Config.h"
    #include "Misc/SynthEngine.h"
#include "MasterUI.h"
#include "Misc/FormatFuncs.h"
    using func::asString;
#include "Misc/TextMsgBuffer.h"

    namespace { // Implementation details...
        TextMsgBuffer& textMsgBuffer = TextMsgBuffer::instance();
    }

void PartUI_::showparameters(int /* kititem */,int /* engine */) {
  ;
}

void PartKitItem::cb_mutedcheck_i(Fl_Check_Button2* o, void*) {
  //
          send_data(0, PART::control::kitItemMute, o->value(), TOPLEVEL::type::Integer, n, UNUSED, TOPLEVEL::insert::kitGroup);
}
void PartKitItem::cb_mutedcheck(Fl_Check_Button2* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_mutedcheck_i(o,v);
}

void PartKitItem::cb_labelbutton_i(Fl_Button* o, void*) {
  //
          string tmp = input_text(synth, "Kit item name:", part->kit[n].Pname);
          if (tmp != "" && tmp != part->kit[n].Pname)
          {
              send_data(TOPLEVEL::action::lowPrio, PART::control::instrumentName, 0, TOPLEVEL::type::Integer, n, UNUSED, TOPLEVEL::insert::kitGroup, UNUSED, textMsgBuffer.push(tmp));
              o->copy_label(tmp.c_str());
          };
}
void PartKitItem::cb_labelbutton(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_labelbutton_i(o,v);
}

void PartKitItem::cb_minkcounter_i(Fl_Counter* o, void*) {
  //
          int tmp = o->value();
          int other = maxkcounter->value();
          if (tmp >= other)
          {
              tmp = other;
              o->value(tmp);
          }

          send_data(0, PART::control::minNote, tmp, TOPLEVEL::type::Integer, n, UNUSED, TOPLEVEL::insert::kitGroup);
}
void PartKitItem::cb_minkcounter(Fl_Counter* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_minkcounter_i(o,v);
}

void PartKitItem::cb_setmin_i(Fl_Button*, void*) {
  //
          int last = part->getLastNote();
          if (last <= 0)
              return;
          int tmp;
          int other = maxkcounter->value();
          if (last >= other)
              tmp = other;
          else
              tmp = last;
          minkcounter->value(tmp);

          send_data(0, PART::control::minToLastKey, tmp, TOPLEVEL::type::Integer, n, UNUSED, TOPLEVEL::insert::kitGroup);
}
void PartKitItem::cb_setmin(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_setmin_i(o,v);
}

void PartKitItem::cb_setmax_i(Fl_Button*, void*) {
  //
          int last = part->getLastNote();
          if (last <= 0)
              return;
          int tmp;
          int other = minkcounter->value();
          if (last <= other)
              tmp = other;
          else
              tmp = last;
          maxkcounter->value(tmp);

          send_data(0, PART::control::maxToLastKey, tmp, TOPLEVEL::type::Integer, n, UNUSED, TOPLEVEL::insert::kitGroup);
}
void PartKitItem::cb_setmax(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_setmax_i(o,v);
}

void PartKitItem::cb_setfull_i(Fl_Button* o, void*) {
  //
          minkcounter->value(0);
          maxkcounter->value(127);

          send_data(0, PART::control::resetMinMaxKey, o->value(), TOPLEVEL::type::Integer, n, UNUSED, TOPLEVEL::insert::kitGroup);
}
void PartKitItem::cb_setfull(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_setfull_i(o,v);
}

void PartKitItem::cb_maxkcounter_i(Fl_Counter* o, void*) {
  //
          int tmp = o->value();
          int other = minkcounter->value();
          if (tmp <= other)
          {
              tmp = other;
              o->value(tmp);
          }
          send_data(0, PART::control::maxNote, tmp, TOPLEVEL::type::Integer, n, UNUSED, TOPLEVEL::insert::kitGroup);
}
void PartKitItem::cb_maxkcounter(Fl_Counter* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_maxkcounter_i(o,v);
}

void PartKitItem::cb_adeditbutton_i(Fl_Button*, void*) {
  //
          partui->showparameters(n,0);
          if ((Fl::event_button() == 3))
              synth->getGuiMaster()->partui->instrumentkitlist->hide();
}
void PartKitItem::cb_adeditbutton(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_adeditbutton_i(o,v);
}

void PartKitItem::cb_adcheck_i(Fl_Check_Button2* o, void*) {
  //

          send_data(TOPLEVEL::action::forceUpdate, PART::control::enableAdd, o->value(), TOPLEVEL::type::Integer, n, UNUSED, TOPLEVEL::insert::kitGroup);
}
void PartKitItem::cb_adcheck(Fl_Check_Button2* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_adcheck_i(o,v);
}

void PartKitItem::cb_subeditbutton_i(Fl_Button*, void*) {
  //
          partui->showparameters(n,1);
          if ((Fl::event_button() == 3))
              synth->getGuiMaster()->partui->instrumentkitlist->hide();
}
void PartKitItem::cb_subeditbutton(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_subeditbutton_i(o,v);
}

void PartKitItem::cb_subcheck_i(Fl_Check_Button2* o, void*) {
  //

          send_data(TOPLEVEL::action::forceUpdate, PART::control::enableSub, o->value(), TOPLEVEL::type::Integer, n, UNUSED, TOPLEVEL::insert::kitGroup);
}
void PartKitItem::cb_subcheck(Fl_Check_Button2* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_subcheck_i(o,v);
}

void PartKitItem::cb_padeditbutton_i(Fl_Button*, void*) {
  //
          partui->showparameters(n,2);
          if ((Fl::event_button() == 3))
              synth->getGuiMaster()->partui->instrumentkitlist->hide();
}
void PartKitItem::cb_padeditbutton(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_padeditbutton_i(o,v);
}

void PartKitItem::cb_padcheck_i(Fl_Check_Button2* o, void*) {
  //

          send_data(TOPLEVEL::action::forceUpdate, PART::control::enablePad, o->value(), TOPLEVEL::type::Integer, n, UNUSED, TOPLEVEL::insert::kitGroup);
}
void PartKitItem::cb_padcheck(Fl_Check_Button2* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_padcheck_i(o,v);
}

void PartKitItem::cb_sendtoeffect_i(Fl_Choice* o, void*) {
  //
          send_data(0, PART::control::kitEffectNum, o->value(), TOPLEVEL::type::Integer, n, UNUSED, TOPLEVEL::insert::kitGroup);
}
void PartKitItem::cb_sendtoeffect(Fl_Choice* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_sendtoeffect_i(o,v);
}

void PartKitItem::cb_enabledcheck_i(Fl_Check_Button2* o, void*) {
  //
        int answer = 1;
        if (o->value() == 0)
            answer = (choice(synth, "", "Yes", "No", "Delete the item?\nThis action can't be reversed and will erase the 'undo' list.") > 1);
        if (answer != 0)
        {
            if (o->value() == 0)
                clearLine();
            else
                partkititemgroup->activate();
            o->redraw();
            partui->showparameters(n, -1); // use to delete the ui, if it is not to item 0
        }
        else
            o->value(1);
        send_data(0, PART::control::enableKitLine, o->value(), TOPLEVEL::type::Integer, n, UNUSED, TOPLEVEL::insert::kitGroup);
}
void PartKitItem::cb_enabledcheck(Fl_Check_Button2* o, void* v) {
  ((PartKitItem*)(o->parent()->user_data()))->cb_enabledcheck_i(o,v);
}

Fl_Group* PartKitItem::make_window() {
  { partkititem = new Fl_Group(0, 0, 670, 20);
    partkititem->box(FL_NO_BOX);
    partkititem->color(FL_BACKGROUND_COLOR);
    partkititem->selection_color(FL_BACKGROUND_COLOR);
    partkititem->labeltype(FL_NO_LABEL);
    partkititem->labelfont(0);
    partkititem->labelsize(14);
    partkititem->labelcolor(FL_FOREGROUND_COLOR);
    partkititem->user_data((void*)(this));
    partkititem->align(Fl_Align(FL_ALIGN_TOP));
    partkititem->when(FL_WHEN_RELEASE);
    { Fl_Group* o = partkititemgroup = new Fl_Group(55, 4, 605, 20);
      { Fl_Check_Button2* o = mutedcheck = new Fl_Check_Button2(60, 4, 15, 15);
        mutedcheck->box(FL_THIN_UP_BOX);
        mutedcheck->down_box(FL_DOWN_BOX);
        mutedcheck->color((Fl_Color)237);
        mutedcheck->selection_color(FL_FOREGROUND_COLOR);
        mutedcheck->labeltype(FL_NORMAL_LABEL);
        mutedcheck->labelfont(1);
        mutedcheck->labelsize(11);
        mutedcheck->labelcolor(FL_FOREGROUND_COLOR);
        mutedcheck->callback((Fl_Callback*)cb_mutedcheck);
        mutedcheck->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        mutedcheck->when(FL_WHEN_RELEASE);
        o->value(part->kit[n].Pmuted);
      } // Fl_Check_Button2* mutedcheck
      { Fl_Button* o = labelbutton = new Fl_Button(90, 4, 130, 15, "Bass Drum");
        labelbutton->box(FL_THIN_DOWN_BOX);
        labelbutton->down_box(FL_FLAT_BOX);
        labelbutton->color(FL_BACKGROUND2_COLOR);
        labelbutton->labelfont(1);
        labelbutton->labelsize(10);
        labelbutton->callback((Fl_Callback*)cb_labelbutton);
        labelbutton->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        o->copy_label(part->kit[n].Pname.c_str());
      } // Fl_Button* labelbutton
      { Fl_Counter* o = minkcounter = new Fl_Counter(225, 4, 55, 15);
        minkcounter->type(1);
        minkcounter->minimum(0);
        minkcounter->maximum(128);
        minkcounter->step(1);
        minkcounter->textfont(1);
        minkcounter->textsize(12);
        minkcounter->callback((Fl_Callback*)cb_minkcounter);
        o->value(part->kit[n].Pminkey);
      } // Fl_Counter* minkcounter
      { setmin = new Fl_Button(285, 7, 15, 12, "m");
        setmin->tooltip("set the minimum key to the last pressed key");
        setmin->box(FL_THIN_UP_BOX);
        setmin->labelsize(10);
        setmin->callback((Fl_Callback*)cb_setmin);
      } // Fl_Button* setmin
      { setmax = new Fl_Button(315, 7, 15, 12, "M");
        setmax->tooltip("set the maximum key to the last pressed key");
        setmax->box(FL_THIN_UP_BOX);
        setmax->labelsize(10);
        setmax->callback((Fl_Callback*)cb_setmax);
      } // Fl_Button* setmax
      { setfull = new Fl_Button(300, 7, 15, 12, "R");
        setfull->tooltip("reset the minimum key to 0 and maximum key to 127");
        setfull->box(FL_THIN_UP_BOX);
        setfull->labelfont(1);
        setfull->labelsize(10);
        setfull->callback((Fl_Callback*)cb_setfull);
      } // Fl_Button* setfull
      { Fl_Counter* o = maxkcounter = new Fl_Counter(335, 4, 55, 15);
        maxkcounter->type(1);
        maxkcounter->minimum(0);
        maxkcounter->maximum(128);
        maxkcounter->step(1);
        maxkcounter->textfont(1);
        maxkcounter->textsize(12);
        maxkcounter->callback((Fl_Callback*)cb_maxkcounter);
        o->value(part->kit[n].Pmaxkey);
      } // Fl_Counter* maxkcounter
      { Fl_Button* o = adeditbutton = new Fl_Button(422, 4, 40, 15, "edit");
        adeditbutton->box(FL_THIN_UP_BOX);
        adeditbutton->labelsize(11);
        adeditbutton->callback((Fl_Callback*)cb_adeditbutton);
        if (part->kit[n].Padenabled==0) o->deactivate();
      } // Fl_Button* adeditbutton
      { Fl_Check_Button2* o = adcheck = new Fl_Check_Button2(400, 4, 15, 15);
        adcheck->box(FL_THIN_UP_BOX);
        adcheck->down_box(FL_DOWN_BOX);
        adcheck->color((Fl_Color)237);
        adcheck->selection_color(FL_FOREGROUND_COLOR);
        adcheck->labeltype(FL_NORMAL_LABEL);
        adcheck->labelfont(1);
        adcheck->labelsize(11);
        adcheck->labelcolor(FL_FOREGROUND_COLOR);
        adcheck->callback((Fl_Callback*)cb_adcheck);
        adcheck->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        adcheck->when(FL_WHEN_RELEASE);
        o->value(part->kit[n].Padenabled);
      } // Fl_Check_Button2* adcheck
      { Fl_Button* o = subeditbutton = new Fl_Button(490, 4, 40, 15, "edit");
        subeditbutton->box(FL_THIN_UP_BOX);
        subeditbutton->labelsize(11);
        subeditbutton->callback((Fl_Callback*)cb_subeditbutton);
        if (part->kit[n].Psubenabled==0) o->deactivate();
      } // Fl_Button* subeditbutton
      { Fl_Check_Button2* o = subcheck = new Fl_Check_Button2(470, 4, 15, 15);
        subcheck->box(FL_THIN_UP_BOX);
        subcheck->down_box(FL_DOWN_BOX);
        subcheck->color((Fl_Color)237);
        subcheck->selection_color(FL_FOREGROUND_COLOR);
        subcheck->labeltype(FL_NORMAL_LABEL);
        subcheck->labelfont(1);
        subcheck->labelsize(11);
        subcheck->labelcolor(FL_FOREGROUND_COLOR);
        subcheck->callback((Fl_Callback*)cb_subcheck);
        subcheck->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        subcheck->when(FL_WHEN_RELEASE);
        o->value(part->kit[n].Psubenabled);
      } // Fl_Check_Button2* subcheck
      { Fl_Button* o = padeditbutton = new Fl_Button(560, 4, 40, 15, "edit");
        padeditbutton->box(FL_THIN_UP_BOX);
        padeditbutton->labelsize(11);
        padeditbutton->callback((Fl_Callback*)cb_padeditbutton);
        if (part->kit[n].Ppadenabled==0) o->deactivate();
      } // Fl_Button* padeditbutton
      { Fl_Check_Button2* o = padcheck = new Fl_Check_Button2(540, 4, 15, 15);
        padcheck->box(FL_THIN_UP_BOX);
        padcheck->down_box(FL_DOWN_BOX);
        padcheck->color((Fl_Color)237);
        padcheck->selection_color(FL_FOREGROUND_COLOR);
        padcheck->labeltype(FL_NORMAL_LABEL);
        padcheck->labelfont(1);
        padcheck->labelsize(11);
        padcheck->labelcolor(FL_FOREGROUND_COLOR);
        padcheck->callback((Fl_Callback*)cb_padcheck);
        padcheck->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        padcheck->when(FL_WHEN_RELEASE);
        o->value(part->kit[n].Ppadenabled);
      } // Fl_Check_Button2* padcheck
      { Fl_Choice* o = sendtoeffect = new Fl_Choice(615, 4, 45, 15);
        sendtoeffect->down_box(FL_BORDER_BOX);
        sendtoeffect->labelsize(10);
        sendtoeffect->textfont(1);
        sendtoeffect->textsize(10);
        sendtoeffect->callback((Fl_Callback*)cb_sendtoeffect);
        sendtoeffect->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->add("OFF"); char nrstr[10]; for (int i = 0; i < NUM_PART_EFX; i++) {sprintf(nrstr,"FX%d",i+1);o->add(nrstr);};
        o->value(part->kit[n].Psendtoparteffect+1);if (part->kit[n].Psendtoparteffect==127) o->value(0);
      } // Fl_Choice* sendtoeffect
      if (part->kit[n].Penabled == 0) o->deactivate();
      partkititemgroup->end();
    } // Fl_Group* partkititemgroup
    { Fl_Check_Button2* o = enabledcheck = new Fl_Check_Button2(30, 4, 20, 15, "01");
      enabledcheck->box(FL_NO_BOX);
      enabledcheck->down_box(FL_DOWN_BOX);
      enabledcheck->color(FL_BACKGROUND_COLOR);
      enabledcheck->selection_color(FL_FOREGROUND_COLOR);
      enabledcheck->labeltype(FL_EMBOSSED_LABEL);
      enabledcheck->labelfont(1);
      enabledcheck->labelsize(12);
      enabledcheck->labelcolor(FL_FOREGROUND_COLOR);
      enabledcheck->callback((Fl_Callback*)cb_enabledcheck);
      enabledcheck->align(Fl_Align(FL_ALIGN_LEFT));
      enabledcheck->when(FL_WHEN_RELEASE);
      snprintf(label,10,"%d",(n&15)+1);o->label(label);
      o->value(part->kit[n].Penabled);
      if (n==0) o->hide();
      if (o->value() == 0) labelbutton->color(FL_WHITE);
    } // Fl_Check_Button2* enabledcheck
    partkititem->end();
  } // Fl_Group* partkititem
  return partkititem;
}

void PartKitItem::send_data(int action, int control, float value, int type, int kititem , int engine , int insert , int parameter , int miscmsg ) {
  //
          type |= TOPLEVEL::type::Write;
          collect_data(synth, value, action, type, control, synth->getRuntime().currentPart, kititem, engine, insert, parameter, UNUSED, miscmsg);
}

PartKitItem::PartKitItem(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  //
      n=0;part=NULL;
}

void PartKitItem::clearLine() {
  //
      partkititemgroup->deactivate();
      mutedcheck->value(0);
      labelbutton->copy_label("");
      minkcounter->value(0);
      maxkcounter->value(127);
      adcheck->value(0);
      adeditbutton->deactivate();
      subcheck->value(0);
      subeditbutton->deactivate();
      padcheck->value(0);
      padeditbutton->deactivate();
      sendtoeffect->value(1);
}

void PartKitItem::init(Part *part_, int n_, int npart_, PartUI_ *partui_) {
  //
      synth = part_->getSynthEngine();
      part = part_;
      n = n_;
      npart = npart_;
      partui = partui_;
      make_window();
      end();
}

void PartKitItem::itemRtext(float dScale) {
  //
      int size = int(10 * dScale);
      int size11 = int(11 * dScale);
      int size12 = int(12 * dScale);
  
      enabledcheck->labelsize(size12);
      mutedcheck->labelsize(size11);
      labelbutton->labelsize(size);
      minkcounter->textsize(size12);
      setmin->labelsize(size);
      setmax->labelsize(size);
      setfull->labelsize(size);
      maxkcounter->textsize(size12);
      adeditbutton->labelsize(size11);
      adcheck->labelsize(size11);
      subeditbutton->labelsize(size11);
      subcheck->labelsize(size11);
      padeditbutton->labelsize(size11);
      padcheck->labelsize(size11);
      sendtoeffect->labelsize(size);
           sendtoeffect->textsize(size);
}

PartKitItem::~PartKitItem() {
  //
      partkititem->hide();
}

void PartUI::cb_instrumentkitlist_i(Fl_Double_Window*, void*) {
  //
    saveWin(synth, instrumentkitlist->w(), instrumentkitlist->h(), instrumentkitlist->x(), instrumentkitlist->y(), false, "Part-kit");
    instrumentkitlist->hide();
    kitSeen = false;
}
void PartUI::cb_instrumentkitlist(Fl_Double_Window* o, void* v) {
  ((PartUI*)(o->user_data()))->cb_instrumentkitlist_i(o,v);
}

void PartUI::cb_kitMode_i(Fl_Choice* o, void*) {
  //
        int tmp = o->value();
        partKitOn = tmp > 0;
        if (partKitOn)
            kitlist->activate();
        else
            kitlist->deactivate();

        send_data(0, PART::control::kitMode, tmp, TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_kitMode(Fl_Choice* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_kitMode_i(o,v);
}

void PartUI::cb_drumMode_i(Fl_Check_Button2* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, PART::control::drumMode, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_drumMode(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_drumMode_i(o,v);
}

void PartUI::cb_kitClose_i(Fl_Button*, void*) {
  //
        saveWin(synth, instrumentkitlist->w(), instrumentkitlist->h(), instrumentkitlist->x(), instrumentkitlist->y(), false, "Part-kit");
        instrumentkitlist->hide();
        kitSeen = false;
        if ((Fl::event_button() == 3))
        synth->getGuiMaster()->partui->instrumenteditwindow->show();
}
void PartUI::cb_kitClose(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_kitClose_i(o,v);
}

void PartUI::cb_instrumenteditwindow_i(Fl_Double_Window*, void*) {
  editClose->do_callback();
}
void PartUI::cb_instrumenteditwindow(Fl_Double_Window* o, void* v) {
  ((PartUI*)(o->user_data()))->cb_instrumenteditwindow_i(o,v);
}

void PartUI::cb_adsynenabledcheck_i(Fl_Check_Button2* o, void*) {
  //

            send_data(TOPLEVEL::action::forceUpdate, PART::control::enableAdd, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_adsynenabledcheck(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->parent()->parent()->user_data()))->cb_adsynenabledcheck_i(o,v);
}

void PartUI::cb_adeditbutton1_i(Fl_Button*, void*) {
  //
            showparameters(0,0);
            //checkEngines();
            seteditname();
            if ((Fl::event_button() == 3))
            {
                instrumenteditwindow->hide();};
}
void PartUI::cb_adeditbutton1(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->parent()->user_data()))->cb_adeditbutton1_i(o,v);
}

void PartUI::cb_subsynenabledcheck_i(Fl_Check_Button2* o, void*) {
  //

            send_data(TOPLEVEL::action::forceUpdate, PART::control::enableSub, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_subsynenabledcheck(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->parent()->parent()->user_data()))->cb_subsynenabledcheck_i(o,v);
}

void PartUI::cb_subeditbutton1_i(Fl_Button*, void*) {
  //
            showparameters(0,1);
            //checkEngines();
            seteditname();
            if ((Fl::event_button() == 3))
            {
                instrumenteditwindow->hide();};
}
void PartUI::cb_subeditbutton1(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->parent()->user_data()))->cb_subeditbutton1_i(o,v);
}

void PartUI::cb_padsynenabledcheck_i(Fl_Check_Button2* o, void*) {
  //

            send_data(TOPLEVEL::action::forceUpdate, PART::control::enablePad, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_padsynenabledcheck(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->parent()->parent()->user_data()))->cb_padsynenabledcheck_i(o,v);
}

void PartUI::cb_padeditbutton1_i(Fl_Button*, void*) {
  //
            showparameters(0,2);
            //checkEngines();
            seteditname();
            if ((Fl::event_button() == 3))
            {
                instrumenteditwindow->hide();};
}
void PartUI::cb_padeditbutton1(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->parent()->user_data()))->cb_padeditbutton1_i(o,v);
}

void PartUI::cb_kitedit_i(Fl_Button*, void*) {
  //
          Showkit();
          if ((Fl::event_button() == 3))
          {
              instrumenteditwindow->hide();};
}
void PartUI::cb_kitedit(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_kitedit_i(o,v);
}

void PartUI::cb_effects_i(Fl_Button*, void*) {
  //
          Showefx();
          if ((Fl::event_button() == 3))
          {
              instrumenteditwindow->hide();};
}
void PartUI::cb_effects(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_effects_i(o,v);
}

void PartUI::cb_editAT_i(Fl_Button*, void*) {
  //
                ShowAT();
                atSeen = 2;
                if ((Fl::event_button() == 3))
                    instrumenteditwindow->hide();
}
void PartUI::cb_editAT(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_editAT_i(o,v);
}

void PartUI::cb_A_C_default_i(Fl_Button*, void*) {
  //
            int param = 0;
            if (Fl::event_state(FL_CTRL))
            param = 1;
            send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate, PART::control::defaultInstrumentCopyright, 0, TOPLEVEL::type::Integer, npart, 255, 255, 255, param);
}
void PartUI::cb_A_C_default(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_A_C_default_i(o,v);
}

void PartUI::cb_copyright_i(Fl_Input* o, void*) {
  //
           send_data(TOPLEVEL::action::lowPrio, PART::control::instrumentCopyright, 0, TOPLEVEL::type::Integer, npart, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(string(o->value())));
}
void PartUI::cb_copyright(Fl_Input* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_copyright_i(o,v);
}

void PartUI::cb_commentField_i(Fl_Input* o, void*) {
  //
          send_data(TOPLEVEL::action::lowPrio, PART::control::instrumentComments, 0, TOPLEVEL::type::Integer, npart, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(string(o->value())));
}
void PartUI::cb_commentField(Fl_Input* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_commentField_i(o,v);
}

void PartUI::cb_instrumentType_i(Fl_Choice* o, void*) {
  //
              send_data(TOPLEVEL::action::lowPrio, PART::control::instrumentType, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_instrumentType(Fl_Choice* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_instrumentType_i(o,v);
}

void PartUI::cb_humanise_i(mwheel_val_slider_rev* o, void*) {
  //

        send_data(0, PART::control::humanise, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_humanise(mwheel_val_slider_rev* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_humanise_i(o,v);
}

void PartUI::cb_velocityhumanise_i(mwheel_val_slider_rev* o, void*) {
  //

        send_data(0, PART::control::humanvelocity, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_velocityhumanise(mwheel_val_slider_rev* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_velocityhumanise_i(o,v);
}

void PartUI::cb_instrumentReset_i(Fl_Button*, void*) {
  //
         if (!fetchData(0, PART::control::enable, npart))
         {
             alert(synth, "Selected part is disabled");
             return;
         }

         if (Fl::event_state(FL_CTRL))
         {
             if (choice(synth, "", "Yes", "No", "Set entire part " + std::to_string(npart + 1) + " controls to default values ?") > 1)
                 send_data(TOPLEVEL::action::forceUpdate, MAIN::control::defaultPart, npart, TOPLEVEL::type::Integer, TOPLEVEL::section::main);
             return;
         }
         if (choice(synth, "", "Yes", "No", "Set part " + std::to_string(npart + 1) + " instrument to 'Simple Sound' ?") > 1)
                send_data(TOPLEVEL::action::forceUpdate, MAIN::control::defaultInstrument, npart, TOPLEVEL::type::Integer, TOPLEVEL::section::main);
}
void PartUI::cb_instrumentReset(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_instrumentReset_i(o,v);
}

void PartUI::cb_editClose_i(Fl_Button*, void*) {
  //
                  saveWin(synth, instrumenteditwindow->w(), instrumenteditwindow->h(), instrumenteditwindow->x(),instrumenteditwindow->y(), false, "Part-edit");
                  editSeen = false;
                  lasteditW = 0;
                  instrumenteditwindow->hide();
}
void PartUI::cb_editClose(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_editClose_i(o,v);
}

void PartUI::cb_partfx_i(Fl_Double_Window*, void*) {
  //
    saveWin(synth, partfx->w(), partfx->h(),  partfx->x(),  partfx->y(), false, "Part-effects");
    partfx->hide();
}
void PartUI::cb_partfx(Fl_Double_Window* o, void* v) {
  ((PartUI*)(o->user_data()))->cb_partfx_i(o,v);
}

void PartUI::cb_inseffnocounter_i(WidgetSpinner* o, void*) {
  //
                ninseff = o->value() - 1;
                setEffNum();
                send_data(0, PART::control::effectNumber, ninseff, TOPLEVEL::type::Integer, npart, UNUSED, ninseff, TOPLEVEL::insert::partEffectSelect);
}
void PartUI::cb_inseffnocounter(WidgetSpinner* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_inseffnocounter_i(o,v);
}

void PartUI::cb_insefftype_i(Fl_Choice* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, PART::control::effectType, o->value(), TOPLEVEL::type::Integer, npart, UNUSED, ninseff, TOPLEVEL::insert::partEffectSelect);
}
void PartUI::cb_insefftype(Fl_Choice* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_insefftype_i(o,v);
}

void PartUI::cb_sendtochoice_i(Fl_Choice* o, void*) {
  //
        send_data(0, PART::control::effectDestination, o->value(), TOPLEVEL::type::Integer, npart, UNUSED, ninseff, TOPLEVEL::insert::partEffectSelect);
}
void PartUI::cb_sendtochoice(Fl_Choice* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_sendtochoice_i(o,v);
}

void PartUI::cb_effCopy_i(Fl_Button*, void*) {
  //
        synth->getGuiMaster()->getPresetsUi()->copy(part->partefx[ninseff]);
}
void PartUI::cb_effCopy(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_effCopy_i(o,v);
}

void PartUI::cb_effPaste_i(Fl_Button*, void*) {
  //
        synth->getGuiMaster()->getPresetsUi()->paste(part->partefx[ninseff], inseffectui);
        synth->getRuntime().effectChange = npart | (ninseff << 8); // temporary fix;
}
void PartUI::cb_effPaste(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_effPaste_i(o,v);
}

void PartUI::cb_bypasseff_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, PART::control::effectBypass, o->value(), TOPLEVEL::type::Integer, npart, UNUSED, ninseff, TOPLEVEL::insert::partEffectSelect);
}
void PartUI::cb_bypasseff(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_bypasseff_i(o,v);
}

void PartUI::cb_effClose_i(Fl_Button*, void*) {
  //
        saveWin(synth, partfx->w(), partfx->h(),  partfx->x(),  partfx->y(), false, "Part-effects");
        if(inseffectui->filterwindow != NULL)
            inseffectui->filterwindow->hide();
        fxSeen = false;
        partfx->hide();
        if ((Fl::event_button() == 3))
            synth->getGuiMaster()->partui->instrumenteditwindow->show();
}
void PartUI::cb_effClose(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_effClose_i(o,v);
}

void PartUI::cb_modulation_i(WidgetPDial* o, void*) {
  //
        send_data(0, PART::control::midiModWheel, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_modulation(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_modulation_i(o,v);
}

void PartUI::cb_expression_i(WidgetPDial* o, void*) {
  //
        send_data(0, PART::control::midiExpression,  o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_expression(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_expression_i(o,v);
}

void PartUI::cb_filterq_i(WidgetPDial* o, void*) {
  //
        send_data(0, PART::control::midiFilterQ, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_filterq(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_filterq_i(o,v);
}

void PartUI::cb_filtercutoff_i(WidgetPDial* o, void*) {
  //
        send_data(0, PART::control::midiFilterCutoff, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_filtercutoff(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_filtercutoff_i(o,v);
}

void PartUI::cb_masterbandwidth_i(WidgetPDial* o, void*) {
  //
        send_data(0, PART::control::midiBandwidth, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_masterbandwidth(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_masterbandwidth_i(o,v);
}

void PartUI::cb_ctlmidiclose_i(Fl_Button*, void*) {
  //
                saveWin(synth,  ctlmidi->w(),  ctlmidi->h(), ctlmidi->x(), ctlmidi->y(), false, "Part-ctlmidi");
                ctlmidiSeen = false;
                ctlmidi->hide();
}
void PartUI::cb_ctlmidiclose(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_ctlmidiclose_i(o,v);
}

void PartUI::cb_ctlwindow_i(Fl_Double_Window*, void*) {
  ctlclose->do_callback();
}
void PartUI::cb_ctlwindow(Fl_Double_Window* o, void* v) {
  ((PartUI*)(o->user_data()))->cb_ctlwindow_i(o,v);
}

void PartUI::cb_volrng_i(WidgetPDial* o, void*) {
  //
        send_data(0, PART::control::volumeRange, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_volrng(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_volrng_i(o,v);
}

void PartUI::cb_vol_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, PART::control::volumeEnable, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_vol(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_vol_i(o,v);
}

void PartUI::cb_panwidth_i(WidgetPDial* o, void*) {
  //
        send_data(0, PART::control::panningWidth, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_panwidth(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_panwidth_i(o,v);
}

void PartUI::cb_modwh_i(WidgetPDial* o, void*) {
  //
        send_data(0, PART::control::modWheelDepth, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_modwh(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_modwh_i(o,v);
}

void PartUI::cb_expmwh_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, PART::control::exponentialModWheel, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_expmwh(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_expmwh_i(o,v);
}

void PartUI::cb_bwdpth_i(WidgetPDial* o, void*) {
  //
        send_data(0, PART::control::bandwidthDepth, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_bwdpth(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_bwdpth_i(o,v);
}

void PartUI::cb_expbw_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, 134, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_expbw(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_expbw_i(o,v);
}

void PartUI::cb_expr_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, 135, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_expr(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_expr_i(o,v);
}

void PartUI::cb_fmamp_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, PART::control::FMamplitudeEnable, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_fmamp(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_fmamp_i(o,v);
}

void PartUI::cb_sustain_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, PART::control::sustainPedalEnable, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_sustain(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_sustain_i(o,v);
}

void PartUI::cb_breath_i(Fl_Check_Button2* o, void*) {
  //
        send_data(0, 141, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_breath(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_breath_i(o,v);
}

void PartUI::cb_pwheelbrng_i(Fl_Counter* o, void*) {
  //
        send_data(0, PART::control::pitchWheelRange, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_pwheelbrng(Fl_Counter* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_pwheelbrng_i(o,v);
}

void PartUI::cb_filtq_i(WidgetPDial* o, void*) {
  //
        send_data(0, PART::control::filterQdepth, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_filtq(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_filtq_i(o,v);
}

void PartUI::cb_fltcut_i(WidgetPDial* o, void*) {
  //
        send_data(0, PART::control::filterCutoffDepth, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_fltcut(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_fltcut_i(o,v);
}

void PartUI::cb_cfdpth_i(WidgetPDial* o, void*) {
  //
          send_data(0, PART::control::resonanceCenterFrequencyDepth, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_cfdpth(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_cfdpth_i(o,v);
}

void PartUI::cb_rbwdpth_i(WidgetPDial* o, void*) {
  //
          send_data(0, PART::control::resonanceBandwidthDepth, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_rbwdpth(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_rbwdpth_i(o,v);
}

void PartUI::cb_prtime_i(WidgetPDial* o, void*) {
  //
          send_data(0, PART::control::portamentoTime, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_prtime(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_prtime_i(o,v);
}

void PartUI::cb_timedu_i(WidgetPDial* o, void*) {
  //
          send_data(0, PART::control::portamentoTimeStretch, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_timedu(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_timedu_i(o,v);
}

void PartUI::cb_thresh_i(Fl_Counter* o, void*) {
  //
          send_data(0, PART::control::portamentoThreshold, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_thresh(Fl_Counter* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_thresh_i(o,v);
}

void PartUI::cb_thtype_i(Fl_Check_Button2* o, void*) {
  //
          send_data(0, PART::control::portamentoThresholdType, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_thtype(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_thtype_i(o,v);
}

void PartUI::cb_propta_i(WidgetPDial* o, void*) {
  //
          send_data(0, PART::control::proportionalPortamentoRate, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_propta(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_propta_i(o,v);
}

void PartUI::cb_proptb_i(WidgetPDial* o, void*) {
  //
          send_data(0, PART::control::proportionalPortamentoDepth, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_proptb(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_proptb_i(o,v);
}

void PartUI::cb_rcv_i(Fl_Check_Button2* o, void*) {
  //
          send_data(0, PART::control::receivePortamento, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_rcv(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_rcv_i(o,v);
}

void PartUI::cb_proprt_i(Fl_Check_Button2* o, void*) {
  //
          if (o->value())
          {
              propta->activate();
              proptb->activate();
          }
          else
          {
              propta->deactivate();
              proptb->deactivate();
          }
          send_data(0, PART::control::enableProportionalPortamento, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_proprt(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_proprt_i(o,v);
}

void PartUI::cb_resetallctl_i(Fl_Button* o, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, PART::control::resetAllControllers, o->value(), TOPLEVEL::type::Integer, npart);
}
void PartUI::cb_resetallctl(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_resetallctl_i(o,v);
}

void PartUI::cb_aftertouch_i(Fl_Button*, void*) {
  //;
                ShowAT();
                atSeen = 1;
                if ((Fl::event_button() == 3))
                    ctlwindow->hide();
}
void PartUI::cb_aftertouch(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_aftertouch_i(o,v);
}

void PartUI::cb_ctlclose_i(Fl_Button*, void*) {
  //;
        saveWin(synth, ctlwindow->w(), ctlwindow->h(), ctlwindow->x(), ctlwindow->y(), false, "Part-controllers");
        ctlSeen = false;
        lastctlW = 0;
        ctlwindow->hide();
}
void PartUI::cb_ctlclose(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_ctlclose_i(o,v);
}

void PartUI::cb_aftertouchcontrol_i(Fl_Double_Window*, void*) {
  //
    saveWin(synth, aftertouchcontrol->w(), aftertouchcontrol->h(), aftertouchcontrol->x(), aftertouchcontrol->y(), false, "Part-aftertouch");
    aftertouchcontrol->hide();
}
void PartUI::cb_aftertouchcontrol(Fl_Double_Window* o, void* v) {
  ((PartUI*)(o->user_data()))->cb_aftertouchcontrol_i(o,v);
}

void PartUI::cb_channeloff_i(Fl_Button*, void*) {
  //
                channelfiltercutoff->value(0);
                channelfilterCminus->value(0);
                channelfilterCminus->deactivate();
                channelfilterQ->value(0);
                channelfilterQminus->value(0);
                channelfilterQminus->deactivate();
                channelpitchbend->value(0);
                channelpitchBminus->value(0);
                channelpitchBminus->deactivate();
                channelmodulation->value(0);
                channelvolume->value(0);
                setATchannel(PART::aftertouchType::off, true);
}
void PartUI::cb_channeloff(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_channeloff_i(o,v);
}

void PartUI::cb_channelfiltercutoff_i(Fl_Check_Button2* o, void*) {
  //
                if (o->value())
                    channelfilterCminus->activate();
                else
                {
                    channelfilterCminus->value(0);
                    channelfilterCminus->deactivate();
                }
                setATchannel(PART::aftertouchType::filterCutoff, o->value());
}
void PartUI::cb_channelfiltercutoff(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_channelfiltercutoff_i(o,v);
}

void PartUI::cb_channelfilterCminus_i(Fl_Check_Button2* o, void*) {
  //
                setATchannel(PART::aftertouchType::filterCutoffDown, o->value());
}
void PartUI::cb_channelfilterCminus(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_channelfilterCminus_i(o,v);
}

void PartUI::cb_channelfilterQ_i(Fl_Check_Button2* o, void*) {
  //
                if (o->value())
                    channelfilterQminus->activate();
                else
                {
                    channelfilterQminus->value(0);
                    channelfilterQminus->deactivate();
                }
                setATchannel(PART::aftertouchType::filterQ, o->value());
}
void PartUI::cb_channelfilterQ(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_channelfilterQ_i(o,v);
}

void PartUI::cb_channelfilterQminus_i(Fl_Check_Button2* o, void*) {
  //
                setATchannel(PART::aftertouchType::filterQdown, o->value());
}
void PartUI::cb_channelfilterQminus(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_channelfilterQminus_i(o,v);
}

void PartUI::cb_channelpitchbend_i(Fl_Check_Button2* o, void*) {
  //
                if (o->value())
                    channelpitchBminus->activate();
                else
                {
                    channelpitchBminus->value(0);
                    channelpitchBminus->deactivate();
                }
                setATchannel(PART::aftertouchType::pitchBend, o->value());
}
void PartUI::cb_channelpitchbend(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_channelpitchbend_i(o,v);
}

void PartUI::cb_channelpitchBminus_i(Fl_Check_Button2* o, void*) {
  //
                setATchannel(PART::aftertouchType::pitchBendDown, o->value());
}
void PartUI::cb_channelpitchBminus(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_channelpitchBminus_i(o,v);
}

void PartUI::cb_channelmodulation_i(Fl_Check_Button2* o, void*) {
  //
                setATchannel(PART::aftertouchType::modulation, o->value());
}
void PartUI::cb_channelmodulation(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_channelmodulation_i(o,v);
}

void PartUI::cb_channelvolume_i(Fl_Check_Button2* o, void*) {
  //
                setATchannel(PART::aftertouchType::volume, o->value());
}
void PartUI::cb_channelvolume(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_channelvolume_i(o,v);
}

void PartUI::cb_polyoff_i(Fl_Button*, void*) {
  //
                polyfiltercutoff->value(0);
                polyfilterCminus->value(0);
                polyfilterCminus->deactivate();
                polyfilterQ->value(0);
                polyfilterQminus->value(0);
                polyfilterQminus->deactivate();
                polypitchbend->value(0);
                polypitchBminus->value(0);
                polypitchBminus->deactivate();
                polymodulation->value(0);
                setATkey(PART::aftertouchType::off, true);
}
void PartUI::cb_polyoff(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_polyoff_i(o,v);
}

void PartUI::cb_polyfiltercutoff_i(Fl_Check_Button2* o, void*) {
  //
                if (o->value())
                    polyfilterCminus->activate();
                else
                {
                    polyfilterCminus->value(0);
                    polyfilterCminus->deactivate();
                }
                setATkey(PART::aftertouchType::filterCutoff, o->value());
}
void PartUI::cb_polyfiltercutoff(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_polyfiltercutoff_i(o,v);
}

void PartUI::cb_polyfilterCminus_i(Fl_Check_Button2* o, void*) {
  //
                setATkey(PART::aftertouchType::filterCutoffDown, o->value());
}
void PartUI::cb_polyfilterCminus(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_polyfilterCminus_i(o,v);
}

void PartUI::cb_polyfilterQ_i(Fl_Check_Button2* o, void*) {
  //
                if (o->value())
                    polyfilterQminus->activate();
                else
                {
                    polyfilterQminus->value(0);
                    polyfilterQminus->deactivate();
                }
                setATkey(PART::aftertouchType::filterQ, o->value());
}
void PartUI::cb_polyfilterQ(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_polyfilterQ_i(o,v);
}

void PartUI::cb_polyfilterQminus_i(Fl_Check_Button2* o, void*) {
  //
                setATkey(PART::aftertouchType::filterQdown, o->value());
}
void PartUI::cb_polyfilterQminus(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_polyfilterQminus_i(o,v);
}

void PartUI::cb_polypitchbend_i(Fl_Check_Button2* o, void*) {
  //
                if (o->value())
                    polypitchBminus->activate();
                else
                {
                    polypitchBminus->value(0);
                    polypitchBminus->deactivate();
                }
                setATkey(PART::aftertouchType::pitchBend, o->value());
}
void PartUI::cb_polypitchbend(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_polypitchbend_i(o,v);
}

void PartUI::cb_polypitchBminus_i(Fl_Check_Button2* o, void*) {
  //
                setATkey(PART::aftertouchType::pitchBendDown, o->value());
}
void PartUI::cb_polypitchBminus(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_polypitchBminus_i(o,v);
}

void PartUI::cb_polymodulation_i(Fl_Check_Button2* o, void*) {
  //
                setATkey(PART::aftertouchType::modulation, o->value());
}
void PartUI::cb_polymodulation(Fl_Check_Button2* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_polymodulation_i(o,v);
}

void PartUI::cb_atClose_i(Fl_Button*, void*) {
  //
        saveWin(synth, aftertouchcontrol->w(), aftertouchcontrol->h(), aftertouchcontrol->x(), aftertouchcontrol->y(), false, "Part-aftertouch");
        if ((Fl::event_button() == 3))
        {
            if (atSeen > 1)
                instrumenteditwindow->show();
            else
                ctlwindow->show();
        }
        atSeen = 0;
        aftertouchcontrol->hide();
}
void PartUI::cb_atClose(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_atClose_i(o,v);
}

Fl_Double_Window* PartUI::make_window() {
  { Fl_Double_Window* o = instrumentkitlist = new Fl_Double_Window(670, 370, "Instrument Kit");
    instrumentkitlist->callback((Fl_Callback*)cb_instrumentkitlist, (void*)(this));
    { kitlist = new Fl_Group(4, 20, 662, 324);
      kitlist->box(FL_THIN_UP_FRAME);
      { kitpack = new Fl_Pack(0, 21, 670, 322);
        for (int i=0;i<NUM_KIT_ITEMS;i++){partkititem[i]=new PartKitItem(0,0,670,20,"");partkititem[i]->init(part, i, npart, this);}
        kitpack->end();
      } // Fl_Pack* kitpack
      kitlist->end();
    } // Fl_Group* kitlist
    { kitnum = new Fl_Box(10, 0, 25, 15, "No.");
      kitnum->labelfont(1);
      kitnum->labelsize(11);
      kitnum->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* kitnum
    { kitmute = new Fl_Box(55, 0, 25, 15, "Mute");
      kitmute->labelfont(1);
      kitmute->labelsize(11);
      kitmute->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* kitmute
    { kitID = new Fl_Box(137, 0, 40, 15, "Name");
      kitID->labelfont(1);
      kitID->labelsize(11);
      kitID->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* kitID
    { kitminkey = new Fl_Box(235, 0, 40, 15, "Min key");
      kitminkey->labelfont(1);
      kitminkey->labelsize(11);
      kitminkey->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* kitminkey
    { kitmaxkey = new Fl_Box(345, 0, 40, 15, "Max key");
      kitmaxkey->labelfont(1);
      kitmaxkey->labelsize(11);
      kitmaxkey->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* kitmaxkey
    { kitadd = new Fl_Box(410, 0, 50, 15, "ADsynth");
      kitadd->labelfont(1);
      kitadd->labelsize(11);
      kitadd->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* kitadd
    { kitsub = new Fl_Box(470, 0, 60, 15, "SUBsynth");
      kitsub->labelfont(1);
      kitsub->labelsize(11);
      kitsub->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* kitsub
    { kitpad = new Fl_Box(540, 0, 60, 15, "PADsynth");
      kitpad->labelfont(1);
      kitpad->labelsize(11);
      kitpad->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* kitpad
    { kitfxnum = new Fl_Box(620, 0, 30, 15, "FX.r.");
      kitfxnum->labelfont(1);
      kitfxnum->labelsize(11);
      kitfxnum->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* kitfxnum
    { Fl_Choice* o = kitMode = new Fl_Choice(41, 348, 88, 19, "Mode");
      kitMode->tooltip("Single = only 1st item in defined note range sounds");
      kitMode->down_box(FL_BORDER_BOX);
      kitMode->labelsize(11);
      kitMode->textfont(1);
      kitMode->textsize(11);
      kitMode->callback((Fl_Callback*)cb_kitMode);
      o->add("Off");o->add("Multi");o->add("Single");o->add("Crossfade");
      if (part->Pkitfade) {o->value(3);} else {o->value(part->Pkitmode);}
      partKitOn = o->value() > 0;
      if (!partKitOn) kitlist->deactivate();
    } // Fl_Choice* kitMode
    { Fl_Check_Button2* o = drumMode = new Fl_Check_Button2(285, 350, 15, 15, "Drum mode");
      drumMode->tooltip("Disables microtonal tuning");
      drumMode->box(FL_NO_BOX);
      drumMode->down_box(FL_DOWN_BOX);
      drumMode->color(FL_BACKGROUND_COLOR);
      drumMode->selection_color(FL_FOREGROUND_COLOR);
      drumMode->labeltype(FL_NORMAL_LABEL);
      drumMode->labelfont(0);
      drumMode->labelsize(11);
      drumMode->labelcolor(FL_FOREGROUND_COLOR);
      drumMode->callback((Fl_Callback*)cb_drumMode);
      drumMode->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      drumMode->when(FL_WHEN_RELEASE);
      o->value(part->Pdrummode);
    } // Fl_Check_Button2* drumMode
    { kitClose = new Fl_Button(569, 348, 63, 20, "Close");
      kitClose->tooltip("Right click: also reopen previous");
      kitClose->box(FL_THIN_UP_BOX);
      kitClose->callback((Fl_Callback*)cb_kitClose);
    } // Fl_Button* kitClose
    o->copy_label(synth->getGuiMaster()->setPartWindowTitle("Kit List").c_str());
    kitDW = o->w(); kitDH = o->h();
    o->size_range(kitDW, kitDH, 0, 0, 0, 0, 1);
    instrumentkitlist->end();
    instrumentkitlist->resizable(instrumentkitlist);
  } // Fl_Double_Window* instrumentkitlist
  { Fl_Double_Window* o = instrumenteditwindow = new Fl_Double_Window(395, 385, "Instrument Edit");
    instrumenteditwindow->callback((Fl_Callback*)cb_instrumenteditwindow, (void*)(this));
    { Fl_Group* o = new Fl_Group(0, 222, 395, 100);
      o->box(FL_ENGRAVED_BOX);
      { ADD = new Fl_Group(5, 246, 94, 72, "ADDsynth");
        ADD->box(FL_ENGRAVED_FRAME);
        ADD->labelfont(1);
        { Fl_Check_Button2* o = adsynenabledcheck = new Fl_Check_Button2(12, 252, 80, 24, "Enabled");
          adsynenabledcheck->tooltip("enable/disable ADsynth");
          adsynenabledcheck->box(FL_PLASTIC_UP_BOX);
          adsynenabledcheck->down_box(FL_DOWN_BOX);
          adsynenabledcheck->color((Fl_Color)228);
          adsynenabledcheck->selection_color(FL_FOREGROUND_COLOR);
          adsynenabledcheck->labeltype(FL_NORMAL_LABEL);
          adsynenabledcheck->labelfont(1);
          adsynenabledcheck->labelsize(11);
          adsynenabledcheck->labelcolor(FL_FOREGROUND_COLOR);
          adsynenabledcheck->callback((Fl_Callback*)cb_adsynenabledcheck);
          adsynenabledcheck->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
          adsynenabledcheck->when(FL_WHEN_RELEASE);
          o->value(part->kit[0].Padenabled);
        } // Fl_Check_Button2* adsynenabledcheck
        { Fl_Box* o = addbox = new Fl_Box(8, 226, 84, 18);
          addbox->box(FL_FLAT_BOX);
          if (adsynenabledcheck->value() != 0 && engine != 0) o->color(ADD_COLOUR); else o->color(FL_BACKGROUND_COLOR);
        } // Fl_Box* addbox
        { Fl_Button* o = adeditbutton = new Fl_Button(12, 280, 80, 32, "Edit");
          adeditbutton->tooltip("Right click: also close this");
          adeditbutton->box(FL_PLASTIC_UP_BOX);
          adeditbutton->color((Fl_Color)222);
          adeditbutton->selection_color((Fl_Color)220);
          adeditbutton->labelfont(1);
          adeditbutton->callback((Fl_Callback*)cb_adeditbutton1);
          adeditbutton->align(Fl_Align(FL_ALIGN_WRAP));
          if (part->kit[0].Padenabled==0) o->deactivate();
        } // Fl_Button* adeditbutton
        ADD->end();
      } // Fl_Group* ADD
      { SUB = new Fl_Group(100, 246, 94, 72, "SUBsynth");
        SUB->box(FL_ENGRAVED_FRAME);
        SUB->labelfont(1);
        { Fl_Check_Button2* o = subsynenabledcheck = new Fl_Check_Button2(107, 252, 80, 24, "Enabled");
          subsynenabledcheck->tooltip("enable/disable SUBsynth");
          subsynenabledcheck->box(FL_PLASTIC_UP_BOX);
          subsynenabledcheck->down_box(FL_DOWN_BOX);
          subsynenabledcheck->color((Fl_Color)228);
          subsynenabledcheck->selection_color(FL_FOREGROUND_COLOR);
          subsynenabledcheck->labeltype(FL_NORMAL_LABEL);
          subsynenabledcheck->labelfont(1);
          subsynenabledcheck->labelsize(11);
          subsynenabledcheck->labelcolor(FL_FOREGROUND_COLOR);
          subsynenabledcheck->callback((Fl_Callback*)cb_subsynenabledcheck);
          subsynenabledcheck->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
          subsynenabledcheck->when(FL_WHEN_RELEASE);
          o->value(part->kit[0].Psubenabled);
        } // Fl_Check_Button2* subsynenabledcheck
        { Fl_Box* o = subbox = new Fl_Box(103, 226, 84, 18);
          subbox->box(FL_FLAT_BOX);
          if (subsynenabledcheck->value() != 0 && engine != 0) o->color(SUB_COLOUR); else o->color(FL_BACKGROUND_COLOR);
        } // Fl_Box* subbox
        { Fl_Button* o = subeditbutton = new Fl_Button(107, 280, 80, 32, "Edit");
          subeditbutton->tooltip("Right click: also close this");
          subeditbutton->box(FL_PLASTIC_UP_BOX);
          subeditbutton->color((Fl_Color)222);
          subeditbutton->selection_color((Fl_Color)220);
          subeditbutton->labelfont(1);
          subeditbutton->callback((Fl_Callback*)cb_subeditbutton1);
          subeditbutton->align(Fl_Align(FL_ALIGN_WRAP));
          if (part->kit[0].Psubenabled==0) o->deactivate();
        } // Fl_Button* subeditbutton
        SUB->end();
      } // Fl_Group* SUB
      { PAD = new Fl_Group(195, 246, 94, 72, "PADsynth");
        PAD->box(FL_ENGRAVED_FRAME);
        PAD->labelfont(1);
        { Fl_Check_Button2* o = padsynenabledcheck = new Fl_Check_Button2(202, 252, 80, 24, "Enabled");
          padsynenabledcheck->tooltip("enable/disable PADsynth");
          padsynenabledcheck->box(FL_PLASTIC_UP_BOX);
          padsynenabledcheck->down_box(FL_DOWN_BOX);
          padsynenabledcheck->color((Fl_Color)228);
          padsynenabledcheck->selection_color(FL_FOREGROUND_COLOR);
          padsynenabledcheck->labeltype(FL_NORMAL_LABEL);
          padsynenabledcheck->labelfont(1);
          padsynenabledcheck->labelsize(11);
          padsynenabledcheck->labelcolor(FL_FOREGROUND_COLOR);
          padsynenabledcheck->callback((Fl_Callback*)cb_padsynenabledcheck);
          padsynenabledcheck->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
          padsynenabledcheck->when(FL_WHEN_RELEASE);
          o->value(part->kit[0].Ppadenabled);
        } // Fl_Check_Button2* padsynenabledcheck
        { Fl_Box* o = padbox = new Fl_Box(198, 226, 84, 18);
          padbox->box(FL_FLAT_BOX);
          if (padsynenabledcheck->value() != 0 && engine != 0) o->color(PAD_COLOUR); else o->color(FL_BACKGROUND_COLOR);
        } // Fl_Box* padbox
        { Fl_Button* o = padeditbutton = new Fl_Button(202, 280, 80, 32, "Edit");
          padeditbutton->tooltip("Right click: also close this");
          padeditbutton->box(FL_PLASTIC_UP_BOX);
          padeditbutton->color((Fl_Color)222);
          padeditbutton->selection_color((Fl_Color)220);
          padeditbutton->labelfont(1);
          padeditbutton->callback((Fl_Callback*)cb_padeditbutton1);
          padeditbutton->align(Fl_Align(FL_ALIGN_WRAP));
          if (part->kit[0].Ppadenabled==0) o->deactivate();
        } // Fl_Button* padeditbutton
        PAD->end();
      } // Fl_Group* PAD
      { kitedit = new Fl_Button(295, 227, 94, 28, "Kit Edit");
        kitedit->tooltip("Right click: also close this");
        kitedit->box(FL_PLASTIC_UP_BOX);
        kitedit->color((Fl_Color)230);
        kitedit->selection_color((Fl_Color)220);
        kitedit->labelfont(1);
        kitedit->callback((Fl_Callback*)cb_kitedit);
        kitedit->align(Fl_Align(FL_ALIGN_WRAP));
      } // Fl_Button* kitedit
      { effects = new Fl_Button(295, 258, 94, 28, "Effects");
        effects->tooltip("Right click: also close this");
        effects->box(FL_PLASTIC_UP_BOX);
        effects->color((Fl_Color)230);
        effects->labelfont(1);
        effects->callback((Fl_Callback*)cb_effects);
      } // Fl_Button* effects
      { editAT = new Fl_Button(295, 290, 94, 28, "Aftertouch");
        editAT->box(FL_PLASTIC_UP_BOX);
        editAT->color((Fl_Color)230);
        editAT->labelfont(1);
        editAT->callback((Fl_Callback*)cb_editAT);
      } // Fl_Button* editAT
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(0, 2, 395, 216);
      o->box(FL_ENGRAVED_FRAME);
      { A_C_display = new Fl_Text_Display(171, 44, 148, 4, "Author and Copyright");
        A_C_display->box(FL_NO_BOX);
        A_C_display->labelsize(12);
      } // Fl_Text_Display* A_C_display
      { A_C_default = new Fl_Button(327, 25, 63, 20, "Default");
        A_C_default->tooltip("Load default author & copyright\n + Ctrl: save current text as default");
        A_C_default->labelsize(12);
        A_C_default->callback((Fl_Callback*)cb_A_C_default);
      } // Fl_Button* A_C_default
      { Fl_Input* o = copyright = new Fl_Input(5, 49, 385, 55);
        copyright->type(4);
        copyright->color((Fl_Color)26);
        copyright->labelsize(12);
        copyright->callback((Fl_Callback*)cb_copyright);
        copyright->align(Fl_Align(FL_ALIGN_TOP_RIGHT));
        o->maximum_size(MAX_INFO_TEXT_SIZE);
        o->value(part->info.Pauthor.c_str());
      } // Fl_Input* copyright
      { Fl_Input* o = commentField = new Fl_Input(5, 123, 385, 91, "Comments");
        commentField->type(4);
        commentField->color((Fl_Color)26);
        commentField->labelsize(12);
        commentField->callback((Fl_Callback*)cb_commentField);
        commentField->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->maximum_size(MAX_INFO_TEXT_SIZE);
        o->value(part->info.Pcomments.c_str());
      } // Fl_Input* commentField
      { Fl_Choice* o = instrumentType = new Fl_Choice(5, 25, 155, 20, "Type:");
        instrumentType->down_box(FL_BORDER_BOX);
        instrumentType->labelfont(1);
        instrumentType->labelsize(11);
        instrumentType->textfont(1);
        instrumentType->textsize(11);
        instrumentType->callback((Fl_Callback*)cb_instrumentType);
        instrumentType->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        fillInstrumentType();
        o->value(part->info.Ptype);
      } // Fl_Choice* instrumentType
      o->end();
    } // Fl_Group* o
    { humaniseBox = new Fl_Box(0, 324, 272, 58);
      humaniseBox->box(FL_ENGRAVED_FRAME);
      humaniseBox->labelfont(1);
      humaniseBox->align(Fl_Align(FL_ALIGN_RIGHT));
    } // Fl_Box* humaniseBox
    { humanise_display = new Fl_Text_Display(102, 342, 78, 7, "Humanise");
      humanise_display->box(FL_NO_BOX);
      humanise_display->labelfont(1);
    } // Fl_Text_Display* humanise_display
    { mwheel_val_slider_rev* o = humanise = new mwheel_val_slider_rev(12, 342, 202, 16, "Detune");
      humanise->tooltip("Random detune of whole part in cents");
      humanise->type(5);
      humanise->box(FL_THIN_DOWN_BOX);
      humanise->color(FL_BACKGROUND_COLOR);
      humanise->selection_color(FL_BACKGROUND_COLOR);
      humanise->labeltype(FL_NORMAL_LABEL);
      humanise->labelfont(0);
      humanise->labelsize(12);
      humanise->labelcolor(FL_FOREGROUND_COLOR);
      humanise->maximum(50);
      humanise->step(1);
      humanise->callback((Fl_Callback*)cb_humanise);
      humanise->align(Fl_Align(FL_ALIGN_RIGHT));
      humanise->when(FL_WHEN_CHANGED);
      o->setValueType(VC_PartHumaniseDetune);//o->useCustomTip(true);
    } // mwheel_val_slider_rev* humanise
    { mwheel_val_slider_rev* o = velocityhumanise = new mwheel_val_slider_rev(12, 362, 202, 16, "Velocity");
      velocityhumanise->tooltip("Random velocity attenuation of whole part");
      velocityhumanise->type(5);
      velocityhumanise->box(FL_THIN_DOWN_BOX);
      velocityhumanise->color(FL_BACKGROUND_COLOR);
      velocityhumanise->selection_color(FL_BACKGROUND_COLOR);
      velocityhumanise->labeltype(FL_NORMAL_LABEL);
      velocityhumanise->labelfont(0);
      velocityhumanise->labelsize(12);
      velocityhumanise->labelcolor(FL_FOREGROUND_COLOR);
      velocityhumanise->maximum(50);
      velocityhumanise->step(1);
      velocityhumanise->callback((Fl_Callback*)cb_velocityhumanise);
      velocityhumanise->align(Fl_Align(FL_ALIGN_RIGHT));
      velocityhumanise->when(FL_WHEN_CHANGED);
      o->setValueType(VC_PartHumaniseVelocity);o->useCustomTip(true);
    } // mwheel_val_slider_rev* velocityhumanise
    { instrumentReset = new Fl_Button(282, 327, 100, 26, "Reset");
      instrumentReset->tooltip("Revert to default instrument\n +Ctrl, clear entire part");
      instrumentReset->box(FL_PLASTIC_UP_BOX);
      instrumentReset->color((Fl_Color)1);
      instrumentReset->labelfont(1);
      instrumentReset->callback((Fl_Callback*)cb_instrumentReset);
    } // Fl_Button* instrumentReset
    { editClose = new Fl_Button(282, 358, 100, 24, "Close");
      editClose->box(FL_THIN_UP_BOX);
      editClose->labelfont(1);
      editClose->callback((Fl_Callback*)cb_editClose);
    } // Fl_Button* editClose
    { originalname = new Fl_Text_Display(200, 108, 1, 15, "Derived From");
      originalname->box(FL_NO_BOX);
      originalname->labelfont(1);
      originalname->labelsize(12);
      originalname->textsize(11);
      originalname->align(Fl_Align(FL_ALIGN_LEFT));
      originalname->hide();
    } // Fl_Text_Display* originalname
    { originaltext = new Fl_Text_Display(198, 108, 1, 15, "text");
      originaltext->box(FL_NO_BOX);
      originaltext->labelfont(1);
      originaltext->labelsize(12);
      originaltext->labelcolor((Fl_Color)4);
      originaltext->textsize(11);
      originaltext->align(Fl_Align(FL_ALIGN_RIGHT));
      originaltext->hide();
    } // Fl_Text_Display* originaltext
    seteditname();
    o->copy_label(synth->getGuiMaster()->setPartWindowTitle("Instrument Edit").c_str());
    editDW = 395; editDH = 385;
    o->size_range(editDW, editDH, 0, 0, 0, 0, 1);
    instrumenteditwindow->end();
    instrumenteditwindow->resizable(instrumenteditwindow);
  } // Fl_Double_Window* instrumenteditwindow
  { Fl_Double_Window* o = partfx = new Fl_Double_Window(385, 160, "Part\'s Insert Effects");
    partfx->callback((Fl_Callback*)cb_partfx, (void*)(this));
    { WidgetSpinner* o = inseffnocounter = new WidgetSpinner(20, 8, 35, 22);
      inseffnocounter->tooltip("Effect No.");
      inseffnocounter->box(FL_NO_BOX);
      inseffnocounter->color(FL_BACKGROUND_COLOR);
      inseffnocounter->selection_color(FL_BACKGROUND_COLOR);
      inseffnocounter->labeltype(FL_NORMAL_LABEL);
      inseffnocounter->labelfont(0);
      inseffnocounter->labelsize(12);
      inseffnocounter->labelcolor(FL_FOREGROUND_COLOR);
      inseffnocounter->maximum(3);
      inseffnocounter->textsize(12);
      inseffnocounter->callback((Fl_Callback*)cb_inseffnocounter);
      inseffnocounter->align(Fl_Align(FL_ALIGN_LEFT));
      inseffnocounter->when(FL_WHEN_RELEASE);
      o->value(ninseff+1);
    } // WidgetSpinner* inseffnocounter
    { Fl_Choice* o = insefftype = new Fl_Choice(86, 8, 92, 22);
      insefftype->tooltip("Effect Type");
      insefftype->box(FL_UP_BOX);
      insefftype->down_box(FL_BORDER_BOX);
      insefftype->labelsize(11);
      insefftype->textfont(1);
      insefftype->textsize(12);
      insefftype->callback((Fl_Callback*)cb_insefftype);
      o->add("No Effect");o->add("Reverb");o->add("Echo");o->add("Chorus");o->add("Phaser");o->add("AlienWah");o->add("Distortion");o->add("EQ");o->add("DynFilter");
      o->value(part->partefx[ninseff]->geteffect());
    } // Fl_Choice* insefftype
    { inseffectuigroup = new Fl_Group(3, 37, 380, 96);
      inseffectuigroup->box(FL_FLAT_BOX);
      inseffectuigroup->color((Fl_Color)48);
      { EffUI* o = inseffectui = new EffUI(5, 38, 379, 95);
        inseffectui->box(FL_NO_BOX);
        inseffectui->color(FL_BACKGROUND_COLOR);
        inseffectui->selection_color(FL_BACKGROUND_COLOR);
        inseffectui->labeltype(FL_NORMAL_LABEL);
        inseffectui->labelfont(0);
        inseffectui->labelsize(14);
        inseffectui->labelcolor(FL_FOREGROUND_COLOR);
        inseffectui->align(Fl_Align(FL_ALIGN_TOP));
        inseffectui->when(FL_WHEN_RELEASE);
        o->init(part->partefx[ninseff], npart, ninseff);
        inseffectui->end();
      } // EffUI* inseffectui
      inseffectuigroup->end();
    } // Fl_Group* inseffectuigroup
    { Fl_Choice* o = sendtochoice = new Fl_Choice(225, 8, 102, 22, "To");
      sendtochoice->down_box(FL_BORDER_BOX);
      sendtochoice->labelfont(1);
      sendtochoice->labelsize(12);
      sendtochoice->textfont(1);
      sendtochoice->textsize(12);
      sendtochoice->callback((Fl_Callback*)cb_sendtochoice);
      o->add("Next Effect");o->add("Part Out");o->add("Dry Out");
      int x = part->Pefxroute[ninseff]; if (x == 127) x = 1;
      o->value(x);
    } // Fl_Choice* sendtochoice
    { effCopy = new Fl_Button(346, 3, 25, 15, "C");
      effCopy->box(FL_THIN_UP_BOX);
      effCopy->color((Fl_Color)179);
      effCopy->labelfont(1);
      effCopy->labelsize(11);
      effCopy->labelcolor(FL_BACKGROUND2_COLOR);
      effCopy->callback((Fl_Callback*)cb_effCopy);
    } // Fl_Button* effCopy
    { effPaste = new Fl_Button(346, 19, 25, 15, "P");
      effPaste->box(FL_THIN_UP_BOX);
      effPaste->color((Fl_Color)179);
      effPaste->labelfont(1);
      effPaste->labelsize(11);
      effPaste->labelcolor(FL_BACKGROUND2_COLOR);
      effPaste->callback((Fl_Callback*)cb_effPaste);
    } // Fl_Button* effPaste
    { Fl_Check_Button2* o = bypasseff = new Fl_Check_Button2(20, 135, 63, 21, "Bypass");
      bypasseff->tooltip("if the effect is not used (is bypassed)");
      bypasseff->box(FL_THIN_UP_BOX);
      bypasseff->down_box(FL_DOWN_BOX);
      bypasseff->color((Fl_Color)237);
      bypasseff->selection_color(FL_FOREGROUND_COLOR);
      bypasseff->labeltype(FL_NORMAL_LABEL);
      bypasseff->labelfont(0);
      bypasseff->labelsize(12);
      bypasseff->labelcolor(FL_FOREGROUND_COLOR);
      bypasseff->callback((Fl_Callback*)cb_bypasseff);
      bypasseff->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      bypasseff->when(FL_WHEN_RELEASE);
      int x=part->Pefxbypass[ninseff];o->value(x);
    } // Fl_Check_Button2* bypasseff
    { effClose = new Fl_Button(307, 136, 60, 20, "Close");
      effClose->tooltip("Right click: also reopen previous");
      effClose->box(FL_THIN_UP_BOX);
      effClose->callback((Fl_Callback*)cb_effClose);
    } // Fl_Button* effClose
    o->copy_label(synth->getGuiMaster()->setPartWindowTitle("Part Effects").c_str());
    fxDW = o->w(); fxDH = o->h();
    o->size_range(fxDW, fxDH, 0, 0, 0, 0, 1);
    partfx->end();
    partfx->resizable(partfx);
  } // Fl_Double_Window* partfx
// ctlmidi, ctlwindow, aftertouch control MUST be that order
  { Fl_Double_Window* o = ctlmidi = new Fl_Double_Window(365, 60, "MIDI Controls");
    ctlmidi->user_data((void*)(this));
    { WidgetPDial* o = modulation = new WidgetPDial(20, 10, 30, 30, "Modulation");
      modulation->tooltip("Modulation Wheel");
      modulation->box(FL_OVAL_BOX);
      modulation->color(FL_BACKGROUND_COLOR);
      modulation->selection_color(FL_INACTIVE_COLOR);
      modulation->labeltype(FL_NORMAL_LABEL);
      modulation->labelfont(0);
      modulation->labelsize(10);
      modulation->labelcolor(FL_FOREGROUND_COLOR);
      modulation->maximum(127);
      modulation->step(1);
      modulation->callback((Fl_Callback*)cb_modulation);
      modulation->align(Fl_Align(FL_ALIGN_BOTTOM));
      modulation->when(FL_WHEN_CHANGED);
      o->value(part->ctl->modwheel.data);
    } // WidgetPDial* modulation
    { WidgetPDial* o = expression = new WidgetPDial(80, 10, 30, 30, "Expression");
      expression->tooltip("Expression");
      expression->box(FL_OVAL_BOX);
      expression->color(FL_BACKGROUND_COLOR);
      expression->selection_color(FL_INACTIVE_COLOR);
      expression->labeltype(FL_NORMAL_LABEL);
      expression->labelfont(0);
      expression->labelsize(10);
      expression->labelcolor(FL_FOREGROUND_COLOR);
      expression->maximum(127);
      expression->step(1);
      expression->callback((Fl_Callback*)cb_expression);
      expression->align(Fl_Align(FL_ALIGN_BOTTOM));
      expression->when(FL_WHEN_CHANGED);
      o->value(part->ctl->expression.data);
    } // WidgetPDial* expression
    { WidgetPDial* o = filterq = new WidgetPDial(140, 10, 30, 30, "Filter Q");
      filterq->tooltip("Filter Q");
      filterq->box(FL_OVAL_BOX);
      filterq->color(FL_BACKGROUND_COLOR);
      filterq->selection_color(FL_INACTIVE_COLOR);
      filterq->labeltype(FL_NORMAL_LABEL);
      filterq->labelfont(0);
      filterq->labelsize(10);
      filterq->labelcolor(FL_FOREGROUND_COLOR);
      filterq->maximum(127);
      filterq->step(1);
      filterq->callback((Fl_Callback*)cb_filterq);
      filterq->align(Fl_Align(FL_ALIGN_BOTTOM));
      filterq->when(FL_WHEN_CHANGED);
      o->value(part->ctl->filterq.data);
    } // WidgetPDial* filterq
    { WidgetPDial* o = filtercutoff = new WidgetPDial(200, 10, 30, 30, "Filter Cutoff");
      filtercutoff->tooltip("Filter Cutoff");
      filtercutoff->box(FL_OVAL_BOX);
      filtercutoff->color(FL_BACKGROUND_COLOR);
      filtercutoff->selection_color(FL_INACTIVE_COLOR);
      filtercutoff->labeltype(FL_NORMAL_LABEL);
      filtercutoff->labelfont(0);
      filtercutoff->labelsize(10);
      filtercutoff->labelcolor(FL_FOREGROUND_COLOR);
      filtercutoff->maximum(127);
      filtercutoff->step(1);
      filtercutoff->callback((Fl_Callback*)cb_filtercutoff);
      filtercutoff->align(Fl_Align(FL_ALIGN_BOTTOM));
      filtercutoff->when(FL_WHEN_CHANGED);
      o->value(part->ctl->filtercutoff.data);
    } // WidgetPDial* filtercutoff
    { WidgetPDial* o = masterbandwidth = new WidgetPDial(260, 10, 30, 30, "Bandwidth");
      masterbandwidth->tooltip("Master Bandwidth");
      masterbandwidth->box(FL_OVAL_BOX);
      masterbandwidth->color(FL_BACKGROUND_COLOR);
      masterbandwidth->selection_color(FL_INACTIVE_COLOR);
      masterbandwidth->labeltype(FL_NORMAL_LABEL);
      masterbandwidth->labelfont(0);
      masterbandwidth->labelsize(10);
      masterbandwidth->labelcolor(FL_FOREGROUND_COLOR);
      masterbandwidth->maximum(127);
      masterbandwidth->step(1);
      masterbandwidth->callback((Fl_Callback*)cb_masterbandwidth);
      masterbandwidth->align(Fl_Align(FL_ALIGN_BOTTOM));
      masterbandwidth->when(FL_WHEN_CHANGED);
      o->value(part->ctl->bandwidth.data);
    } // WidgetPDial* masterbandwidth
    { ctlmidiclose = new Fl_Button(309, 35, 50, 20, "Close");
      ctlmidiclose->box(FL_THIN_UP_BOX);
      ctlmidiclose->callback((Fl_Callback*)cb_ctlmidiclose);
    } // Fl_Button* ctlmidiclose
    o->copy_label(synth->getGuiMaster()->setPartWindowTitle("MIDI Controls").c_str());
    midiDW = o->w(); midiDH = o->h();
    o->size_range(midiDW, midiDH, 0, 0, 0, 0, 1);
    ctlmidi->end();
    ctlmidi->resizable(ctlmidi);
  } // Fl_Double_Window* ctlmidi
  { Fl_Double_Window* o = ctlwindow = new Fl_Double_Window(505, 130, "Controllers");
    ctlwindow->callback((Fl_Callback*)cb_ctlwindow, (void*)(this));
    { WidgetPDial* o = volrng = new WidgetPDial(132, 55, 30, 30, "Vol Rng");
      volrng->tooltip("Volume Range");
      volrng->box(FL_OVAL_BOX);
      volrng->color(FL_BACKGROUND_COLOR);
      volrng->selection_color(FL_INACTIVE_COLOR);
      volrng->labeltype(FL_NORMAL_LABEL);
      volrng->labelfont(0);
      volrng->labelsize(10);
      volrng->labelcolor(FL_FOREGROUND_COLOR);
      volrng->minimum(64);
      volrng->maximum(127);
      volrng->step(1);
      volrng->callback((Fl_Callback*)cb_volrng);
      volrng->align(Fl_Align(FL_ALIGN_BOTTOM));
      volrng->when(FL_WHEN_CHANGED);
      o->value(part->ctl->volume.data);
    } // WidgetPDial* volrng
    { Fl_Check_Button2* o = vol = new Fl_Check_Button2(175, 81, 45, 18, "Vol");
      vol->tooltip("Volume enable");
      vol->box(FL_THIN_UP_BOX);
      vol->down_box(FL_DOWN_BOX);
      vol->color(FL_BACKGROUND_COLOR);
      vol->selection_color(FL_FOREGROUND_COLOR);
      vol->labeltype(FL_NORMAL_LABEL);
      vol->labelfont(0);
      vol->labelsize(10);
      vol->labelcolor(FL_FOREGROUND_COLOR);
      vol->callback((Fl_Callback*)cb_vol);
      vol->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      vol->when(FL_WHEN_RELEASE);
      o->value(part->ctl->volume.receive);
    } // Fl_Check_Button2* vol
    { WidgetPDial* o = panwidth = new WidgetPDial(10, 55, 30, 30, "PanWdth");
      panwidth->tooltip("Panning Width");
      panwidth->box(FL_OVAL_BOX);
      panwidth->color(FL_BACKGROUND_COLOR);
      panwidth->selection_color(FL_INACTIVE_COLOR);
      panwidth->labeltype(FL_NORMAL_LABEL);
      panwidth->labelfont(0);
      panwidth->labelsize(10);
      panwidth->labelcolor(FL_FOREGROUND_COLOR);
      panwidth->maximum(64);
      panwidth->step(1);
      panwidth->callback((Fl_Callback*)cb_panwidth);
      panwidth->align(Fl_Align(FL_ALIGN_BOTTOM));
      panwidth->when(FL_WHEN_CHANGED);
      o->value(part->ctl->panning.depth);
    } // WidgetPDial* panwidth
    { WidgetPDial* o = modwh = new WidgetPDial(50, 10, 30, 30, "ModWh");
      modwh->tooltip("Modulation Wheel depth");
      modwh->box(FL_OVAL_BOX);
      modwh->color(FL_BACKGROUND_COLOR);
      modwh->selection_color(FL_INACTIVE_COLOR);
      modwh->labeltype(FL_NORMAL_LABEL);
      modwh->labelfont(0);
      modwh->labelsize(10);
      modwh->labelcolor(FL_FOREGROUND_COLOR);
      modwh->maximum(127);
      modwh->step(1);
      modwh->callback((Fl_Callback*)cb_modwh);
      modwh->align(Fl_Align(FL_ALIGN_BOTTOM));
      modwh->when(FL_WHEN_CHANGED);
      o->value(part->ctl->modwheel.depth);
    } // WidgetPDial* modwh
    { Fl_Check_Button2* o = expmwh = new Fl_Check_Button2(10, 15, 40, 25, "Exp MWh");
      expmwh->tooltip("Exponential modulation wheel");
      expmwh->box(FL_NO_BOX);
      expmwh->down_box(FL_DOWN_BOX);
      expmwh->color(FL_BACKGROUND_COLOR);
      expmwh->selection_color(FL_FOREGROUND_COLOR);
      expmwh->labeltype(FL_NORMAL_LABEL);
      expmwh->labelfont(0);
      expmwh->labelsize(10);
      expmwh->labelcolor(FL_FOREGROUND_COLOR);
      expmwh->callback((Fl_Callback*)cb_expmwh);
      expmwh->align(Fl_Align(132|FL_ALIGN_INSIDE));
      expmwh->when(FL_WHEN_RELEASE);
      o->value(part->ctl->modwheel.exponential);
    } // Fl_Check_Button2* expmwh
    { WidgetPDial* o = bwdpth = new WidgetPDial(132, 10, 30, 30, "BwDpth");
      bwdpth->tooltip("BandWidth depth");
      bwdpth->box(FL_OVAL_BOX);
      bwdpth->color(FL_BACKGROUND_COLOR);
      bwdpth->selection_color(FL_INACTIVE_COLOR);
      bwdpth->labeltype(FL_NORMAL_LABEL);
      bwdpth->labelfont(0);
      bwdpth->labelsize(10);
      bwdpth->labelcolor(FL_FOREGROUND_COLOR);
      bwdpth->maximum(127);
      bwdpth->step(1);
      bwdpth->callback((Fl_Callback*)cb_bwdpth);
      bwdpth->align(Fl_Align(FL_ALIGN_BOTTOM));
      bwdpth->when(FL_WHEN_CHANGED);
      o->value(part->ctl->bandwidth.depth);
    } // WidgetPDial* bwdpth
    { Fl_Check_Button2* o = expbw = new Fl_Check_Button2(92, 15, 35, 25, "Exp BW");
      expbw->tooltip("Exponential BandWidth Controller");
      expbw->box(FL_NO_BOX);
      expbw->down_box(FL_DOWN_BOX);
      expbw->color(FL_BACKGROUND_COLOR);
      expbw->selection_color(FL_FOREGROUND_COLOR);
      expbw->labeltype(FL_NORMAL_LABEL);
      expbw->labelfont(0);
      expbw->labelsize(10);
      expbw->labelcolor(FL_FOREGROUND_COLOR);
      expbw->callback((Fl_Callback*)cb_expbw);
      expbw->align(Fl_Align(132|FL_ALIGN_INSIDE));
      expbw->when(FL_WHEN_RELEASE);
      o->value(part->ctl->bandwidth.exponential);
    } // Fl_Check_Button2* expbw
    { Fl_Check_Button2* o = expr = new Fl_Check_Button2(175, 59, 45, 18, "Expr");
      expr->tooltip("Expression enable");
      expr->box(FL_THIN_UP_BOX);
      expr->down_box(FL_DOWN_BOX);
      expr->color(FL_BACKGROUND_COLOR);
      expr->selection_color(FL_FOREGROUND_COLOR);
      expr->labeltype(FL_NORMAL_LABEL);
      expr->labelfont(0);
      expr->labelsize(10);
      expr->labelcolor(FL_FOREGROUND_COLOR);
      expr->callback((Fl_Callback*)cb_expr);
      expr->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      expr->when(FL_WHEN_RELEASE);
      o->value(part->ctl->expression.receive);
    } // Fl_Check_Button2* expr
    { Fl_Check_Button2* o = fmamp = new Fl_Check_Button2(225, 59, 60, 18, "FMamp");
      fmamp->tooltip("FM amplitude enable");
      fmamp->box(FL_THIN_UP_BOX);
      fmamp->down_box(FL_DOWN_BOX);
      fmamp->color(FL_BACKGROUND_COLOR);
      fmamp->selection_color(FL_FOREGROUND_COLOR);
      fmamp->labeltype(FL_NORMAL_LABEL);
      fmamp->labelfont(0);
      fmamp->labelsize(10);
      fmamp->labelcolor(FL_FOREGROUND_COLOR);
      fmamp->callback((Fl_Callback*)cb_fmamp);
      fmamp->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      fmamp->when(FL_WHEN_RELEASE);
      o->value(part->ctl->fmamp.receive);
    } // Fl_Check_Button2* fmamp
    { Fl_Check_Button2* o = sustain = new Fl_Check_Button2(225, 81, 60, 18, "Sustain");
      sustain->tooltip("Sustain pedal enable");
      sustain->box(FL_THIN_UP_BOX);
      sustain->down_box(FL_DOWN_BOX);
      sustain->color(FL_BACKGROUND_COLOR);
      sustain->selection_color(FL_FOREGROUND_COLOR);
      sustain->labeltype(FL_NORMAL_LABEL);
      sustain->labelfont(0);
      sustain->labelsize(10);
      sustain->labelcolor(FL_FOREGROUND_COLOR);
      sustain->callback((Fl_Callback*)cb_sustain);
      sustain->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      sustain->when(FL_WHEN_RELEASE);
      o->value(part->ctl->sustain.receive);
    } // Fl_Check_Button2* sustain
    { Fl_Check_Button2* o = breath = new Fl_Check_Button2(225, 38, 60, 18, "Breath");
      breath->tooltip("Breath Control enable");
      breath->box(FL_THIN_UP_BOX);
      breath->down_box(FL_DOWN_BOX);
      breath->color(FL_BACKGROUND_COLOR);
      breath->selection_color(FL_FOREGROUND_COLOR);
      breath->labeltype(FL_NORMAL_LABEL);
      breath->labelfont(0);
      breath->labelsize(10);
      breath->labelcolor(FL_FOREGROUND_COLOR);
      breath->callback((Fl_Callback*)cb_breath);
      breath->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      breath->when(FL_WHEN_RELEASE);
      o->value(part->PbreathControl == 2);
    } // Fl_Check_Button2* breath
    { Fl_Counter* o = pwheelbrng = new Fl_Counter(174, 15, 110, 20, "PWheel Rng (cents)");
      pwheelbrng->tooltip("Pitch Wheel Bend Range (cents)");
      pwheelbrng->color((Fl_Color)237);
      pwheelbrng->selection_color(FL_FOREGROUND_COLOR);
      pwheelbrng->labelsize(10);
      pwheelbrng->minimum(-6400);
      pwheelbrng->maximum(6400);
      pwheelbrng->step(1);
      pwheelbrng->callback((Fl_Callback*)cb_pwheelbrng);
      pwheelbrng->align(Fl_Align(FL_ALIGN_TOP));
      o->value(part->ctl->pitchwheel.bendrange);
      o->lstep(100);
    } // Fl_Counter* pwheelbrng
    { WidgetPDial* o = filtq = new WidgetPDial(50, 55, 30, 30, "FltQ");
      filtq->tooltip("Filter Q depth");
      filtq->box(FL_OVAL_BOX);
      filtq->color(FL_BACKGROUND_COLOR);
      filtq->selection_color(FL_INACTIVE_COLOR);
      filtq->labeltype(FL_NORMAL_LABEL);
      filtq->labelfont(0);
      filtq->labelsize(10);
      filtq->labelcolor(FL_FOREGROUND_COLOR);
      filtq->maximum(127);
      filtq->step(1);
      filtq->callback((Fl_Callback*)cb_filtq);
      filtq->align(Fl_Align(FL_ALIGN_BOTTOM));
      filtq->when(FL_WHEN_CHANGED);
      o->value(part->ctl->filterq.depth);
    } // WidgetPDial* filtq
    { WidgetPDial* o = fltcut = new WidgetPDial(90, 55, 30, 30, "FltCut");
      fltcut->tooltip("Filter Cutoff depth");
      fltcut->box(FL_OVAL_BOX);
      fltcut->color(FL_BACKGROUND_COLOR);
      fltcut->selection_color(FL_INACTIVE_COLOR);
      fltcut->labeltype(FL_NORMAL_LABEL);
      fltcut->labelfont(0);
      fltcut->labelsize(10);
      fltcut->labelcolor(FL_FOREGROUND_COLOR);
      fltcut->maximum(127);
      fltcut->step(1);
      fltcut->callback((Fl_Callback*)cb_fltcut);
      fltcut->align(Fl_Align(FL_ALIGN_BOTTOM));
      fltcut->when(FL_WHEN_CHANGED);
      o->value(part->ctl->filtercutoff.depth);
    } // WidgetPDial* fltcut
    { ctlresonance = new Fl_Group(290, 15, 45, 85, "Resonance");
      ctlresonance->box(FL_ENGRAVED_BOX);
      ctlresonance->labelfont(1);
      ctlresonance->labelsize(10);
      ctlresonance->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      { WidgetPDial* o = cfdpth = new WidgetPDial(300, 20, 25, 25, "CFdpth");
        cfdpth->tooltip("Center Frequency controller Depth");
        cfdpth->box(FL_OVAL_BOX);
        cfdpth->color(FL_BACKGROUND_COLOR);
        cfdpth->selection_color(FL_INACTIVE_COLOR);
        cfdpth->labeltype(FL_NORMAL_LABEL);
        cfdpth->labelfont(0);
        cfdpth->labelsize(10);
        cfdpth->labelcolor(FL_FOREGROUND_COLOR);
        cfdpth->maximum(127);
        cfdpth->step(1);
        cfdpth->callback((Fl_Callback*)cb_cfdpth);
        cfdpth->align(Fl_Align(FL_ALIGN_BOTTOM));
        cfdpth->when(FL_WHEN_CHANGED);
        o->value(part->ctl->resonancecenter.depth);
      } // WidgetPDial* cfdpth
      { WidgetPDial* o = rbwdpth = new WidgetPDial(300, 60, 25, 25, "BWdpth");
        rbwdpth->tooltip("BandWidth controller depth");
        rbwdpth->box(FL_OVAL_BOX);
        rbwdpth->color(FL_BACKGROUND_COLOR);
        rbwdpth->selection_color(FL_INACTIVE_COLOR);
        rbwdpth->labeltype(FL_NORMAL_LABEL);
        rbwdpth->labelfont(0);
        rbwdpth->labelsize(10);
        rbwdpth->labelcolor(FL_FOREGROUND_COLOR);
        rbwdpth->maximum(127);
        rbwdpth->step(1);
        rbwdpth->callback((Fl_Callback*)cb_rbwdpth);
        rbwdpth->align(Fl_Align(FL_ALIGN_BOTTOM));
        rbwdpth->when(FL_WHEN_CHANGED);
        o->value(part->ctl->resonancebandwidth.depth);
      } // WidgetPDial* rbwdpth
      ctlresonance->end();
    } // Fl_Group* ctlresonance
    { ctlportamento = new Fl_Group(340, 15, 160, 85, "Portamento");
      ctlportamento->box(FL_ENGRAVED_FRAME);
      ctlportamento->labelfont(1);
      ctlportamento->labelsize(10);
      { ctlx100 = new Fl_Box(400, 50, 55, 15, "x100 cnt.");
        ctlx100->labelsize(10);
        ctlx100->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
      } // Fl_Box* ctlx100
      { WidgetPDial* o = prtime = new WidgetPDial(345, 60, 25, 25, "time");
        prtime->tooltip("Portamento time");
        prtime->box(FL_OVAL_BOX);
        prtime->color(FL_BACKGROUND_COLOR);
        prtime->selection_color(FL_INACTIVE_COLOR);
        prtime->labeltype(FL_NORMAL_LABEL);
        prtime->labelfont(0);
        prtime->labelsize(10);
        prtime->labelcolor(FL_FOREGROUND_COLOR);
        prtime->maximum(127);
        prtime->step(1);
        prtime->callback((Fl_Callback*)cb_prtime);
        prtime->align(Fl_Align(FL_ALIGN_BOTTOM));
        prtime->when(FL_WHEN_CHANGED);
        o->value(part->ctl->portamento.time);
      } // WidgetPDial* prtime
      { WidgetPDial* o = timedu = new WidgetPDial(375, 60, 25, 25, "t.dn/up");
        timedu->tooltip("Portamento time stretch (up/down)");
        timedu->box(FL_OVAL_BOX);
        timedu->color(FL_BACKGROUND_COLOR);
        timedu->selection_color(FL_INACTIVE_COLOR);
        timedu->labeltype(FL_NORMAL_LABEL);
        timedu->labelfont(0);
        timedu->labelsize(10);
        timedu->labelcolor(FL_FOREGROUND_COLOR);
        timedu->maximum(127);
        timedu->step(1);
        timedu->callback((Fl_Callback*)cb_timedu);
        timedu->align(Fl_Align(FL_ALIGN_BOTTOM));
        timedu->when(FL_WHEN_CHANGED);
        o->value(part->ctl->portamento.updowntimestretch);
      } // WidgetPDial* timedu
      { Fl_Counter* o = thresh = new Fl_Counter(400, 20, 50, 20, "Thresh");
        thresh->tooltip("Minimum or max. difference of the notes in order to do the portamento (x 100 \
cents)");
        thresh->type(1);
        thresh->color((Fl_Color)237);
        thresh->selection_color(FL_FOREGROUND_COLOR);
        thresh->labelsize(10);
        thresh->minimum(0);
        thresh->maximum(127);
        thresh->step(1);
        thresh->callback((Fl_Callback*)cb_thresh);
        o->value(part->ctl->portamento.pitchthresh);
      } // Fl_Counter* thresh
      { Fl_Check_Button2* o = thtype = new Fl_Check_Button2(425, 68, 15, 15, "th.type");
        thtype->tooltip("Threshold type (min/max)");
        thtype->box(FL_NO_BOX);
        thtype->down_box(FL_DOWN_BOX);
        thtype->color(FL_BACKGROUND_COLOR);
        thtype->selection_color(FL_FOREGROUND_COLOR);
        thtype->labeltype(FL_NORMAL_LABEL);
        thtype->labelfont(0);
        thtype->labelsize(10);
        thtype->labelcolor(FL_FOREGROUND_COLOR);
        thtype->callback((Fl_Callback*)cb_thtype);
        thtype->align(Fl_Align(FL_ALIGN_BOTTOM));
        thtype->when(FL_WHEN_RELEASE);
        o->value(part->ctl->portamento.pitchthreshtype);
      } // Fl_Check_Button2* thtype
      { WidgetPDial* o = propta = new WidgetPDial(463, 20, 25, 25, "Prp.Rate");
        propta->tooltip("Distance required to double change from nonpropotinal portamento time");
        propta->box(FL_OVAL_BOX);
        propta->color(FL_BACKGROUND_COLOR);
        propta->selection_color(FL_INACTIVE_COLOR);
        propta->labeltype(FL_NORMAL_LABEL);
        propta->labelfont(0);
        propta->labelsize(10);
        propta->labelcolor(FL_FOREGROUND_COLOR);
        propta->maximum(127);
        propta->step(1);
        propta->callback((Fl_Callback*)cb_propta);
        propta->align(Fl_Align(FL_ALIGN_BOTTOM));
        propta->when(FL_WHEN_CHANGED);
        o->value(part->ctl->portamento.propRate);
      } // WidgetPDial* propta
      { WidgetPDial* o = proptb = new WidgetPDial(463, 60, 25, 25, "Prp.Dpth");
        proptb->tooltip("The difference from nonproportinal portamento");
        proptb->box(FL_OVAL_BOX);
        proptb->color(FL_BACKGROUND_COLOR);
        proptb->selection_color(FL_INACTIVE_COLOR);
        proptb->labeltype(FL_NORMAL_LABEL);
        proptb->labelfont(0);
        proptb->labelsize(10);
        proptb->labelcolor(FL_FOREGROUND_COLOR);
        proptb->maximum(127);
        proptb->step(1);
        proptb->callback((Fl_Callback*)cb_proptb);
        proptb->align(Fl_Align(FL_ALIGN_BOTTOM));
        proptb->when(FL_WHEN_CHANGED);
        o->value(part->ctl->portamento.propDepth);
      } // WidgetPDial* proptb
      { Fl_Check_Button2* o = rcv = new Fl_Check_Button2(345, 20, 40, 18, "Rcv");
        rcv->tooltip("Receive Portamento Controllers");
        rcv->box(FL_THIN_UP_BOX);
        rcv->down_box(FL_DOWN_BOX);
        rcv->color(FL_BACKGROUND_COLOR);
        rcv->selection_color(FL_FOREGROUND_COLOR);
        rcv->labeltype(FL_NORMAL_LABEL);
        rcv->labelfont(0);
        rcv->labelsize(10);
        rcv->labelcolor(FL_FOREGROUND_COLOR);
        rcv->callback((Fl_Callback*)cb_rcv);
        rcv->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        rcv->when(FL_WHEN_RELEASE);
        o->value(part->ctl->portamento.receive);
      } // Fl_Check_Button2* rcv
      { Fl_Check_Button2* o = proprt = new Fl_Check_Button2(345, 40, 50, 18, "Proprt.");
        proprt->tooltip("Enable Proportinal Portamento (over fixed Portamento)");
        proprt->box(FL_THIN_UP_BOX);
        proprt->down_box(FL_DOWN_BOX);
        proprt->color(FL_BACKGROUND_COLOR);
        proprt->selection_color(FL_FOREGROUND_COLOR);
        proprt->labeltype(FL_NORMAL_LABEL);
        proprt->labelfont(0);
        proprt->labelsize(9);
        proprt->labelcolor(FL_FOREGROUND_COLOR);
        proprt->callback((Fl_Callback*)cb_proprt);
        proprt->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        proprt->when(FL_WHEN_RELEASE);
        o->value(part->ctl->portamento.proportional);
        if (o->value()){propta->activate();proptb->activate();}
        else {propta->deactivate();proptb->deactivate();}
      } // Fl_Check_Button2* proprt
      ctlportamento->end();
    } // Fl_Group* ctlportamento
    { resetallctl = new Fl_Button(5, 105, 210, 20, "Reset all controllers");
      resetallctl->box(FL_THIN_UP_BOX);
      resetallctl->callback((Fl_Callback*)cb_resetallctl);
    } // Fl_Button* resetallctl
    { aftertouch = new Fl_Button(245, 105, 130, 20, "Aftertouch");
      aftertouch->box(FL_PLASTIC_THIN_UP_BOX);
      aftertouch->color((Fl_Color)230);
      aftertouch->callback((Fl_Callback*)cb_aftertouch);
    } // Fl_Button* aftertouch
    { ctlclose = new Fl_Button(405, 105, 95, 20, "Close");
      ctlclose->box(FL_THIN_UP_BOX);
      ctlclose->callback((Fl_Callback*)cb_ctlclose);
    } // Fl_Button* ctlclose
    o->copy_label(synth->getGuiMaster()->setPartWindowTitle("Controllers").c_str());
    ctlDW = o->w(); ctlDH = o->h();
    o->size_range(ctlDW, ctlDH, 0, 0, 0, 0, 1);
    ctlwindow->end();
    ctlwindow->resizable(ctlwindow);
  } // Fl_Double_Window* ctlwindow
  { Fl_Double_Window* o = aftertouchcontrol = new Fl_Double_Window(485, 180, "Aftertouch");
    aftertouchcontrol->callback((Fl_Callback*)cb_aftertouchcontrol, (void*)(this));
    { Fl_Box* o = new Fl_Box(9, 5, 228, 171);
      o->box(FL_ENGRAVED_FRAME);
    } // Fl_Box* o
    { Fl_Box* o = new Fl_Box(241, 5, 234, 143);
      o->box(FL_ENGRAVED_FRAME);
    } // Fl_Box* o
    { ATchan = new Fl_Box(95, 13, 35, 17, "Channel");
      ATchan->labelfont(1);
    } // Fl_Box* ATchan
    { channeloff = new Fl_Button(55, 40, 48, 20, "Off");
      channeloff->callback((Fl_Callback*)cb_channeloff);
    } // Fl_Button* channeloff
    { channelfiltercutoff = new Fl_Check_Button2(25, 65, 70, 15, "Filter Cutoff");
      channelfiltercutoff->tooltip("Between current MIDI setting and max.");
      channelfiltercutoff->box(FL_NO_BOX);
      channelfiltercutoff->down_box(FL_DOWN_BOX);
      channelfiltercutoff->color(FL_BACKGROUND_COLOR);
      channelfiltercutoff->selection_color(FL_FOREGROUND_COLOR);
      channelfiltercutoff->labeltype(FL_NORMAL_LABEL);
      channelfiltercutoff->labelfont(0);
      channelfiltercutoff->labelsize(14);
      channelfiltercutoff->labelcolor(FL_FOREGROUND_COLOR);
      channelfiltercutoff->callback((Fl_Callback*)cb_channelfiltercutoff);
      channelfiltercutoff->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      channelfiltercutoff->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* channelfiltercutoff
    { channelfilterCminus = new Fl_Check_Button2(150, 65, 70, 15, "Down");
      channelfilterCminus->tooltip("Between current MIDI setting and zero");
      channelfilterCminus->box(FL_NO_BOX);
      channelfilterCminus->down_box(FL_DOWN_BOX);
      channelfilterCminus->color(FL_BACKGROUND_COLOR);
      channelfilterCminus->selection_color(FL_FOREGROUND_COLOR);
      channelfilterCminus->labeltype(FL_NORMAL_LABEL);
      channelfilterCminus->labelfont(0);
      channelfilterCminus->labelsize(14);
      channelfilterCminus->labelcolor(FL_FOREGROUND_COLOR);
      channelfilterCminus->callback((Fl_Callback*)cb_channelfilterCminus);
      channelfilterCminus->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      channelfilterCminus->when(FL_WHEN_RELEASE);
      channelfilterCminus->deactivate();
    } // Fl_Check_Button2* channelfilterCminus
    { channelfilterQ = new Fl_Check_Button2(25, 85, 70, 15, "Filter Q");
      channelfilterQ->tooltip("Between current MIDI setting and max.");
      channelfilterQ->box(FL_NO_BOX);
      channelfilterQ->down_box(FL_DOWN_BOX);
      channelfilterQ->color(FL_BACKGROUND_COLOR);
      channelfilterQ->selection_color(FL_FOREGROUND_COLOR);
      channelfilterQ->labeltype(FL_NORMAL_LABEL);
      channelfilterQ->labelfont(0);
      channelfilterQ->labelsize(14);
      channelfilterQ->labelcolor(FL_FOREGROUND_COLOR);
      channelfilterQ->callback((Fl_Callback*)cb_channelfilterQ);
      channelfilterQ->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      channelfilterQ->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* channelfilterQ
    { channelfilterQminus = new Fl_Check_Button2(150, 85, 70, 15, "Down");
      channelfilterQminus->tooltip("Between current MIDI setting and zero");
      channelfilterQminus->box(FL_NO_BOX);
      channelfilterQminus->down_box(FL_DOWN_BOX);
      channelfilterQminus->color(FL_BACKGROUND_COLOR);
      channelfilterQminus->selection_color(FL_FOREGROUND_COLOR);
      channelfilterQminus->labeltype(FL_NORMAL_LABEL);
      channelfilterQminus->labelfont(0);
      channelfilterQminus->labelsize(14);
      channelfilterQminus->labelcolor(FL_FOREGROUND_COLOR);
      channelfilterQminus->callback((Fl_Callback*)cb_channelfilterQminus);
      channelfilterQminus->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      channelfilterQminus->when(FL_WHEN_RELEASE);
      channelfilterQminus->deactivate();
    } // Fl_Check_Button2* channelfilterQminus
    { channelpitchbend = new Fl_Check_Button2(25, 105, 70, 15, "Pitch Bend");
      channelpitchbend->tooltip("Between current pitch wheel position and max.");
      channelpitchbend->box(FL_NO_BOX);
      channelpitchbend->down_box(FL_DOWN_BOX);
      channelpitchbend->color(FL_BACKGROUND_COLOR);
      channelpitchbend->selection_color(FL_FOREGROUND_COLOR);
      channelpitchbend->labeltype(FL_NORMAL_LABEL);
      channelpitchbend->labelfont(0);
      channelpitchbend->labelsize(14);
      channelpitchbend->labelcolor(FL_FOREGROUND_COLOR);
      channelpitchbend->callback((Fl_Callback*)cb_channelpitchbend);
      channelpitchbend->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      channelpitchbend->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* channelpitchbend
    { channelpitchBminus = new Fl_Check_Button2(150, 105, 70, 15, "Down");
      channelpitchBminus->tooltip("Between current pitch wheel position and min.");
      channelpitchBminus->box(FL_NO_BOX);
      channelpitchBminus->down_box(FL_DOWN_BOX);
      channelpitchBminus->color(FL_BACKGROUND_COLOR);
      channelpitchBminus->selection_color(FL_FOREGROUND_COLOR);
      channelpitchBminus->labeltype(FL_NORMAL_LABEL);
      channelpitchBminus->labelfont(0);
      channelpitchBminus->labelsize(14);
      channelpitchBminus->labelcolor(FL_FOREGROUND_COLOR);
      channelpitchBminus->callback((Fl_Callback*)cb_channelpitchBminus);
      channelpitchBminus->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      channelpitchBminus->when(FL_WHEN_RELEASE);
      channelpitchBminus->deactivate();
    } // Fl_Check_Button2* channelpitchBminus
    { channelmodulation = new Fl_Check_Button2(25, 125, 70, 15, "Modulation");
      channelmodulation->tooltip("Between zero and Add/Pad frequency LFO depth");
      channelmodulation->box(FL_NO_BOX);
      channelmodulation->down_box(FL_DOWN_BOX);
      channelmodulation->color(FL_BACKGROUND_COLOR);
      channelmodulation->selection_color(FL_FOREGROUND_COLOR);
      channelmodulation->labeltype(FL_NORMAL_LABEL);
      channelmodulation->labelfont(0);
      channelmodulation->labelsize(14);
      channelmodulation->labelcolor(FL_FOREGROUND_COLOR);
      channelmodulation->callback((Fl_Callback*)cb_channelmodulation);
      channelmodulation->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      channelmodulation->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* channelmodulation
    { channelvolume = new Fl_Check_Button2(25, 145, 70, 15, "Volume");
      channelvolume->tooltip("Between current part volume and max.");
      channelvolume->box(FL_NO_BOX);
      channelvolume->down_box(FL_DOWN_BOX);
      channelvolume->color(FL_BACKGROUND_COLOR);
      channelvolume->selection_color(FL_FOREGROUND_COLOR);
      channelvolume->labeltype(FL_NORMAL_LABEL);
      channelvolume->labelfont(0);
      channelvolume->labelsize(14);
      channelvolume->labelcolor(FL_FOREGROUND_COLOR);
      channelvolume->callback((Fl_Callback*)cb_channelvolume);
      channelvolume->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      channelvolume->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* channelvolume
    { ATkey = new Fl_Box(328, 13, 35, 17, "Key");
      ATkey->labelfont(1);
    } // Fl_Box* ATkey
    { polyoff = new Fl_Button(300, 40, 48, 20, "Off");
      polyoff->callback((Fl_Callback*)cb_polyoff);
    } // Fl_Button* polyoff
    { polyfiltercutoff = new Fl_Check_Button2(270, 65, 70, 15, "Filter Cutoff");
      polyfiltercutoff->tooltip("Between current MIDI setting and max.");
      polyfiltercutoff->box(FL_NO_BOX);
      polyfiltercutoff->down_box(FL_DOWN_BOX);
      polyfiltercutoff->color(FL_BACKGROUND_COLOR);
      polyfiltercutoff->selection_color(FL_FOREGROUND_COLOR);
      polyfiltercutoff->labeltype(FL_NORMAL_LABEL);
      polyfiltercutoff->labelfont(0);
      polyfiltercutoff->labelsize(14);
      polyfiltercutoff->labelcolor(FL_FOREGROUND_COLOR);
      polyfiltercutoff->callback((Fl_Callback*)cb_polyfiltercutoff);
      polyfiltercutoff->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      polyfiltercutoff->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* polyfiltercutoff
    { polyfilterCminus = new Fl_Check_Button2(395, 65, 70, 15, "Down");
      polyfilterCminus->tooltip("Between current MIDI setting and zero");
      polyfilterCminus->box(FL_NO_BOX);
      polyfilterCminus->down_box(FL_DOWN_BOX);
      polyfilterCminus->color(FL_BACKGROUND_COLOR);
      polyfilterCminus->selection_color(FL_FOREGROUND_COLOR);
      polyfilterCminus->labeltype(FL_NORMAL_LABEL);
      polyfilterCminus->labelfont(0);
      polyfilterCminus->labelsize(14);
      polyfilterCminus->labelcolor(FL_FOREGROUND_COLOR);
      polyfilterCminus->callback((Fl_Callback*)cb_polyfilterCminus);
      polyfilterCminus->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      polyfilterCminus->when(FL_WHEN_RELEASE);
      polyfilterCminus->deactivate();
    } // Fl_Check_Button2* polyfilterCminus
    { polyfilterQ = new Fl_Check_Button2(270, 85, 70, 15, "Filter Q");
      polyfilterQ->tooltip("Between current MIDI setting and max.");
      polyfilterQ->box(FL_NO_BOX);
      polyfilterQ->down_box(FL_DOWN_BOX);
      polyfilterQ->color(FL_BACKGROUND_COLOR);
      polyfilterQ->selection_color(FL_FOREGROUND_COLOR);
      polyfilterQ->labeltype(FL_NORMAL_LABEL);
      polyfilterQ->labelfont(0);
      polyfilterQ->labelsize(14);
      polyfilterQ->labelcolor(FL_FOREGROUND_COLOR);
      polyfilterQ->callback((Fl_Callback*)cb_polyfilterQ);
      polyfilterQ->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      polyfilterQ->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* polyfilterQ
    { polyfilterQminus = new Fl_Check_Button2(395, 85, 70, 15, "Down");
      polyfilterQminus->tooltip("Between current MIDI setting and zero");
      polyfilterQminus->box(FL_NO_BOX);
      polyfilterQminus->down_box(FL_DOWN_BOX);
      polyfilterQminus->color(FL_BACKGROUND_COLOR);
      polyfilterQminus->selection_color(FL_FOREGROUND_COLOR);
      polyfilterQminus->labeltype(FL_NORMAL_LABEL);
      polyfilterQminus->labelfont(0);
      polyfilterQminus->labelsize(14);
      polyfilterQminus->labelcolor(FL_FOREGROUND_COLOR);
      polyfilterQminus->callback((Fl_Callback*)cb_polyfilterQminus);
      polyfilterQminus->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      polyfilterQminus->when(FL_WHEN_RELEASE);
      polyfilterQminus->deactivate();
    } // Fl_Check_Button2* polyfilterQminus
    { polypitchbend = new Fl_Check_Button2(270, 105, 70, 15, "Pitch Bend");
      polypitchbend->tooltip("Between current pitch wheel position and max.");
      polypitchbend->box(FL_NO_BOX);
      polypitchbend->down_box(FL_DOWN_BOX);
      polypitchbend->color(FL_BACKGROUND_COLOR);
      polypitchbend->selection_color(FL_FOREGROUND_COLOR);
      polypitchbend->labeltype(FL_NORMAL_LABEL);
      polypitchbend->labelfont(0);
      polypitchbend->labelsize(14);
      polypitchbend->labelcolor(FL_FOREGROUND_COLOR);
      polypitchbend->callback((Fl_Callback*)cb_polypitchbend);
      polypitchbend->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      polypitchbend->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* polypitchbend
    { polypitchBminus = new Fl_Check_Button2(395, 105, 70, 15, "Down");
      polypitchBminus->tooltip("Between current pitch wheel position and min.");
      polypitchBminus->box(FL_NO_BOX);
      polypitchBminus->down_box(FL_DOWN_BOX);
      polypitchBminus->color(FL_BACKGROUND_COLOR);
      polypitchBminus->selection_color(FL_FOREGROUND_COLOR);
      polypitchBminus->labeltype(FL_NORMAL_LABEL);
      polypitchBminus->labelfont(0);
      polypitchBminus->labelsize(14);
      polypitchBminus->labelcolor(FL_FOREGROUND_COLOR);
      polypitchBminus->callback((Fl_Callback*)cb_polypitchBminus);
      polypitchBminus->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      polypitchBminus->when(FL_WHEN_RELEASE);
      polypitchBminus->deactivate();
    } // Fl_Check_Button2* polypitchBminus
    { polymodulation = new Fl_Check_Button2(270, 125, 70, 15, "Modulation");
      polymodulation->tooltip("Between zero and Add/Pad frequency LFO depth");
      polymodulation->box(FL_NO_BOX);
      polymodulation->down_box(FL_DOWN_BOX);
      polymodulation->color(FL_BACKGROUND_COLOR);
      polymodulation->selection_color(FL_FOREGROUND_COLOR);
      polymodulation->labeltype(FL_NORMAL_LABEL);
      polymodulation->labelfont(0);
      polymodulation->labelsize(14);
      polymodulation->labelcolor(FL_FOREGROUND_COLOR);
      polymodulation->callback((Fl_Callback*)cb_polymodulation);
      polymodulation->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      polymodulation->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* polymodulation
    { atClose = new Fl_Button(420, 154, 50, 20, "Close");
      atClose->box(FL_THIN_UP_BOX);
      atClose->callback((Fl_Callback*)cb_atClose);
    } // Fl_Button* atClose
    o->copy_label(synth->getGuiMaster()->setPartWindowTitle("Aftertouch").c_str());
    atDW = o->w(); atDH = o->h();
    o->size_range(atDW, atDH, 0, 0, 0, 0, 1);
    aftertouchcontrol->end();
    aftertouchcontrol->resizable(aftertouchcontrol);
  } // Fl_Double_Window* aftertouchcontrol
  return aftertouchcontrol;
}

int PartUI::handle(int event) {
  //
          int ret = Fl_Group::handle(event);
          return 0;
  
          /*
           * I don't know why we need to do this but it screws up
           * MasterUi if it is either active or fully removed.
          */
  
          switch(event)
          {
              case FL_FOCUS:
              case FL_UNFOCUS:
                  ret = 1;
                  break;
              case FL_SHORTCUT:           // in case widget that isn't ours has focus
              case FL_KEYDOWN:            // keyboard key pushed
              //case FL_KEYUP:              // keyboard key released
              {
                  if (lastkey != Fl::event_key())
                      lastkey = Fl::event_key();
                  break;
              }
              case FL_KEYUP:
              {
                  if (lastkey == Fl::event_key())
                      lastkey = -1;
                  break;
              }
          }
          return(ret);
}

void PartUI::send_data(int action, int control, float value, int type, int npart, int kititem , int engine , int insert , int parameter , int miscmsg ) {
  //
          type |= TOPLEVEL::type::Write;
          collect_data(synth, value, action, type, control, npart, kititem, engine, insert, parameter, UNUSED, miscmsg);
}

float PartUI::fetchData(float value, int control, int part, int kititem , int engine , int insert , int parameter , int offset , int miscmsg , int request ) {
  //
          return collect_readData(synth, value, control, part, kititem, engine, insert, parameter, offset, miscmsg, request);
}

void PartUI::returns_update(CommandBlock *getData) {
  //
      float value = getData->data.value;
      unsigned char control = getData->data.control;
      unsigned char newpart = getData->data.part;
      unsigned char kititem = getData->data.kit;
      unsigned char engine = getData->data.engine;
      unsigned char insert = getData->data.insert;
      unsigned char parameter = getData->data.parameter;
      unsigned char miscmsg = getData->data.miscmsg;
      bool valBool = _SYS_::F2B(value);
      bool fromUs = ((getData->data.source & TOPLEVEL::action::noAction) == TOPLEVEL::action::fromGUI);
      int valInt = lrint(value);
      string text;
      if (miscmsg != NO_MSG)
          text = textMsgBuffer.fetch(miscmsg);
  
      if (npart != newpart)
          return;
      bool sameEff = (engine == ninseff);
      bool kitType = (insert == TOPLEVEL::insert::kitGroup);
      if (!kitType)
          kititem = 0;
      switch(control)
      {
          case PART::control::enableAdd:
              partkititem[kititem]->adcheck->value(valBool);
              if (valBool)
              {
                  partkititem[kititem]->adeditbutton->activate();
                  if (kititem == 0)
                  {
                      adsynenabledcheck->value(1);
                      adeditbutton->activate();
                  }
              }
              else
              {
                  partkititem[kititem]->adeditbutton->deactivate();
                  if (kititem == 0)
                  {
                      adsynenabledcheck->value(0);
                      adeditbutton->deactivate();
                  }
              }
              break;
          case PART::control::enableSub:
              partkititem[kititem]->subcheck->value(valBool);
              if (valBool)
              {
                  partkititem[kititem]->subeditbutton->activate();
                  if (kititem == 0)
                  {
                      subsynenabledcheck->value(1);
                      subeditbutton->activate();
                  }
              }
              else
              {
                  partkititem[kititem]->subeditbutton->deactivate();
                  if (kititem == 0)
                  {
                      subsynenabledcheck->value(0);
                      subeditbutton->deactivate();
                  }
              }
              break;
          case PART::control::enablePad:
              partkititem[kititem]->padcheck->value(valBool);
              if (valBool)
              {
                  partkititem[kititem]->padeditbutton->activate();
                  if (kititem ==0)
                  {
                      padsynenabledcheck->value(1);
                      padeditbutton->activate();
                  }
              }
              else
              {
                  partkititem[kititem]->padeditbutton->deactivate();
                  if (kititem ==0)
                  {
                      padsynenabledcheck->value(0);
                      padeditbutton->deactivate();
                  }
              }
              break;
          case PART::control::enableKitLine:
              partkititem[kititem]->enabledcheck->value(valBool);
              if (valBool)
                  partkititem[kititem]->partkititemgroup->activate();
              else
                  partkititem[kititem]->clearLine();
              break;
          case PART::control::channelATset:
              channelATselection = valInt;
              fetchChannel();
              if (parameter != UNUSED)
              {
                  keyATselection = parameter;
                  fetchKey();
              }
              break;
          case PART::control::keyATset:
              keyATselection = valInt;
              fetchKey();
              if (parameter != UNUSED)
              {
                  channelATselection = parameter;
                  fetchChannel();
              }
              break;
  
          case PART::control::kitItemMute:
              partkititem[kititem]->mutedcheck->value(valBool);
              break;
          case PART::control::minNote:
          case PART::control::minToLastKey: // this will have been modified for last key press
              partkititem[kititem]->minkcounter->value(valInt);;
              break;
  
          case PART::control::maxNote:
          case PART::control::maxToLastKey: // this will have been modified for last key press
              partkititem[kititem]->maxkcounter->value(valInt);
              break;
  
          case PART::control::resetMinMaxKey:
              partkititem[kititem]->minkcounter->value(0);
              partkititem[kititem]->maxkcounter->value(127);
              break;
  
          case PART::control::kitEffectNum:
              partkititem[kititem]->sendtoeffect->value(valInt);
              break;
  
          case PART::control::humanise:
              humanise->value(valInt);
              break;
  
          case PART::control::humanvelocity:
              velocityhumanise->value(valInt);
              break;
  
  
          case PART::control::drumMode:
              drumMode->value(valBool);
              break;
  
          case PART::control::kitMode:
              kitMode->value(valInt);
              partKitOn =  (kitMode->value() > 0);
              if (partKitOn > 0)
                  kitlist->activate();
              else
                  kitlist->deactivate();
              break;
  
          case PART::control::effectNumber:
              if (!fromUs)
              {
                  ninseff = valInt;
                  inseffnocounter->value(ninseff + 1);
                  setEffNum();
              }
              if (sameEff)
                  inseffectui->UpdatePresetColour(parameter, insefftype->value());
              else
                  lastfxW = 0;
              break;
  
          case PART::control::effectType:
              if (sameEff)
              {
                  insefftype->value(valInt);
                  part->partefx[engine]->geteffect();
                  inseffectui->UpdatePresetColour(parameter, insefftype->value());
                  inseffectui->refresh(part->partefx[engine], npart, engine);
                  fxRtext();
              }
              break;
  
          case PART::control::effectDestination:
              if (sameEff)
                  sendtochoice->value(valInt);
              break;
  
          case PART::control::effectBypass:
              if (sameEff)
                  bypasseff->value(valBool);
              break;
  
  // controllers
          case PART::control::volumeRange:
              volrng->value(valInt);
              break;
  
          case PART::control::volumeEnable:
              vol->value(valInt);
              break;
  
          case PART::control::panningWidth:
              panwidth->value(valInt);
              break;
  
          case PART::control::modWheelDepth:
              modwh->value(valInt);
              break;
  
          case PART::control::exponentialModWheel:
              expmwh->value(valInt);
              break;
  
          case PART::control::bandwidthDepth:
              bwdpth->value(valInt);
              break;
  
          case PART::control::exponentialBandwidth:
              expbw->value(valInt);
              break;
  
          case PART::control::expressionEnable:
              expr->value(valInt);
              break;
  
          case PART::control::FMamplitudeEnable:
              fmamp->value(valInt);
              break;
  
          case PART::control::sustainPedalEnable:
              sustain->value(valInt);
              break;
  
          case PART::control::pitchWheelRange:
              pwheelbrng->value(valInt);
              break;
  
          case PART::control::filterQdepth:
              filtq->value(valInt);
              break;
  
          case PART::control::filterCutoffDepth:
              fltcut->value(valInt);
              break;
  
          case PART::control::breathControlEnable:
              breath->value(valBool);
              break;
  
          case PART::control::resonanceCenterFrequencyDepth:
              cfdpth->value(valInt);
              break;
  
          case PART::control::resonanceBandwidthDepth:
              rbwdpth->value(valInt);
              break;
  
          case PART::control::portamentoTime:
              prtime->value(valInt);
              break;
  
          case PART::control::portamentoTimeStretch:
              timedu->value(valInt);
              break;
  
          case PART::control::portamentoThreshold:
              thresh->value(valInt);
              break;
  
          case PART::control::portamentoThresholdType:
              thtype->value(valInt);
              break;
  
          case PART::control::enableProportionalPortamento:
              proprt->value(valInt);
              if (value != 0)
              {
                  propta->activate();
                  proptb->activate();
              }
              else
              {
                  propta->deactivate();
                  proptb->deactivate();
              }
              break;
  
          case PART::control::proportionalPortamentoRate:
              propta->value(valInt);
              break;
  
          case PART::control::proportionalPortamentoDepth:
              proptb->value(valInt);
              break;
  
          case PART::control::receivePortamento:
              rcv->value(valInt);
              break;
  
          case PART::control::midiModWheel:
              modulation->value(value);
              break;
          case PART::control::midiExpression:
              expression->value(value);
              break;
          case PART::control::midiFilterQ:
              filterq->value(value);
              break;
          case PART::control::midiFilterCutoff:
              filtercutoff->value(value);
              break;
          case PART::control::midiBandwidth:
              masterbandwidth->value(value);
              break;
  
          case PART::control::instrumentCopyright:
              copyright->value(text.c_str());
              break;
          case PART::control::instrumentComments:
              commentField->value(text.c_str());
              break;
          case PART::control::instrumentName:
              partkititem[kititem]->labelbutton->copy_label(text.c_str());
              break;
          case PART::control::instrumentType:
              instrumentType->value(value);
              break;
          case PART::control::defaultInstrumentCopyright:
              if (parameter == 0)
                  copyright->value(text.c_str());
              break;
          case PART::control::resetAllControllers:
              controllersrefresh();
              break;
          default:
              break;
      }
      if (control == PART::control::enableAdd || control == PART::control::enableSub || control == PART::control::enablePad)
      checkEngines();
}

PartUI::PartUI(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  //
      part = NULL;
      adnoteui = NULL;
      subnoteui = NULL;
      padnoteui = NULL;
      editSeen = false;
      fxSeen = false;
      kitSeen = false;
      ctlSeen = false;
      ctlmidiSeen = false;
      atSeen = false;
      lastfxW = 0;
      lastkitW = 0;
      lastmidiW = 0;
      lastatW = 0;
      lastkititem = -1;
}

void PartUI::rebuild(int npart_) {
  //
          if (adnoteui != NULL)
          {
              delete adnoteui;
              adnoteui = NULL;
          }
          if (subnoteui != NULL)
          {
              delete subnoteui;
              subnoteui = NULL;
          }
          if (padnoteui != NULL)
          {
              delete padnoteui;
              padnoteui = NULL;
          }
          npart = npart_;
          part = synth->part[npart];
          lastkey = -1;
  
          if (part->kit[0].adpars)
              adnoteui = new ADnoteUI(part->kit[0].adpars, npart, 0);
          if (part->kit[0].subpars)
              subnoteui = new SUBnoteUI(part->kit[0].subpars, npart, 0);
          if (part->kit[0].padpars)
              padnoteui = new PADnoteUI(part->kit[0].padpars);
  
          checkEngines();
          editrefresh();
          effectsrefresh();
          kitrefresh();
          controllersrefresh();
          ctlmidirefresh();
          ATrefresh();
}

void PartUI::fillInstrumentType() {
  //
  
          int i = 0;
          string entry = type_list[i];
          while (entry != "@end")
          {
              instrumentType->add(entry.c_str());
              ++ i;
              entry = type_list[i];
          }
}

void PartUI::editrefresh() {
  //
          instrumenteditwindow->copy_label(synth->getGuiMaster()->setPartWindowTitle("Instrument Edit").c_str());
          setinstrumentlabel();
          instrumenteditwindow->redraw();
          fillInstrumentType();
          copyright->value(part->info.Pauthor.c_str());
          commentField->value(part->info.Pcomments.c_str());
          string name = part->Poriginal;
          if (!name.empty() && part->Pname != name)
          {
              originaltext->copy_label(name.c_str());
              originalname->show();
              originaltext->show();
          }
          else
          {
              originalname->hide();
              originaltext->hide();
          }
          instrumentType->value(part->info.Ptype);
          humanise->value(fetchData(0, PART::control::humanise, npart));
          velocityhumanise->value(fetchData(0, PART::control::humanvelocity, npart));
}

void PartUI::effectsrefresh() {
  //
          partfx->copy_label(synth->getGuiMaster()->setPartWindowTitle("Part Effects").c_str());
          setEffNum();
          bool res = fetchData(0, EFFECT::control::changed, npart,  (TOPLEVEL::insert::none | 128) + insefftype->value(), inseffnocounter->value() - 1);
          inseffectui->UpdatePresetColour(res, insefftype->value());
          fxRtext();
}

void PartUI::kitrefresh() {
  //
          instrumentkitlist->copy_label(synth->getGuiMaster()->setPartWindowTitle("Kit List").c_str());
          drumMode->value(part->Pdrummode);
          kitMode->value(part->Pkitmode);
          if (kitMode->value())
          {
              partKitOn = true;
              kitlist->activate();
          }
          else
          {
              partKitOn = false;
              kitlist->deactivate();
          }
          lastkititem = -1;
          for (int i = 0; i < NUM_KIT_ITEMS; ++i)
          {
              if (part->kit[i].Penabled)
              {
                  partkititem[i]->enabledcheck->value(1);
                  partkititem[i]->partkititemgroup->activate();
                  partkititem[i]->mutedcheck->value(!part->kit[i].Penabled);
  
                  partkititem[i]->adcheck->value(part->kit[i].Padenabled);
                  if (partkititem[i]->adcheck->value())
                      partkititem[i]->adeditbutton->activate();
                  else
                      partkititem[i]->adeditbutton->deactivate();
                  partkititem[i]->subcheck->value(part->kit[i].Psubenabled);
                  if (partkititem[i]->subcheck->value())
                      partkititem[i]->subeditbutton->activate();
                  else
                      partkititem[i]->subeditbutton->deactivate();
                  partkititem[i]->padcheck->value(part->kit[i].Ppadenabled);
                  if (partkititem[i]->padcheck->value())
                      partkititem[i]->padeditbutton->activate();
                  else
                      partkititem[i]->padeditbutton->deactivate();
              }
              else
              {
                  partkititem[i]->enabledcheck->value(0);
                  partkititem[i]->partkititemgroup->deactivate();
                  partkititem[i]->mutedcheck->value(0);
                  partkititem[i]->adcheck->value(0);
                  partkititem[i]->adeditbutton->deactivate();
                  partkititem[i]->subcheck->value(0);
                  partkititem[i]->subeditbutton->deactivate();
                  partkititem[i]->padcheck->value(0);
                  partkititem[i]->padeditbutton->deactivate();
              }
              partkititem[i]->labelbutton->copy_label(part->kit[i].Pname.c_str());
              partkititem[i]->minkcounter->value(part->kit[i].Pminkey);
              partkititem[i]->maxkcounter->value(part->kit[i].Pmaxkey);
              int effnum = part->kit[i].Psendtoparteffect + 1;
              if (effnum > 3)
                  effnum = 0;
              partkititem[i]->sendtoeffect->value(effnum);
          }
}

void PartUI::controllersrefresh() {
  //
      ctlwindow->copy_label(synth->getGuiMaster()->setPartWindowTitle("Controllers").c_str());
      expmwh->value(part->ctl->modwheel.exponential);
      modwh->value(part->ctl->modwheel.depth);
      expbw->value(part->ctl->bandwidth.exponential);
      bwdpth->value(part->ctl->bandwidth.depth);
      pwheelbrng->value(part->ctl->pitchwheel.bendrange);
      panwidth->value(part->ctl->panning.depth);
      filtq->value(part->ctl->filterq.depth);
      fltcut->value(part->ctl->filtercutoff.depth);
      volrng->value(part->ctl->volume.data);
      expr->value(part->ctl->expression.receive);
      fmamp->value(part->ctl->fmamp.receive);
      vol->value(part->ctl->volume.receive);
      sustain->value(part->ctl->sustain.receive);
  
      cfdpth->value(part->ctl->resonancecenter.depth);
      rbwdpth->value(part->ctl->resonancebandwidth.depth);
  
      rcv->value(part->ctl->portamento.receive);
      thresh->value(part->ctl->portamento.pitchthresh);
      propta->value(part->ctl->portamento.propRate);
      proprt->value(part->ctl->portamento.proportional);
      if (proprt->value())
      {
          propta->activate();
          proptb->activate();
      }
      else
      {
          propta->deactivate();
          proptb->deactivate();
      }
      prtime->value(part->ctl->portamento.time);
      timedu->value(part->ctl->portamento.updowntimestretch);
      thtype->value(part->ctl->portamento.pitchthreshtype);
      proptb->value(part->ctl->portamento.propDepth);
}

void PartUI::ctlmidirefresh() {
  //
          ctlmidi->copy_label(synth->getGuiMaster()->setPartWindowTitle("MIDI Controls").c_str());
          modulation->value(part->ctl->modwheel.data);
          expression->value(part->ctl->expression.data);
          filterq->value(part->ctl->filterq.data);
          filtercutoff->value(part->ctl->filtercutoff.data);
          masterbandwidth->value(part->ctl->bandwidth.data);
}

void PartUI::ATrefresh() {
  //
      aftertouchcontrol->copy_label(synth->getGuiMaster()->setPartWindowTitle("Aftertouch").c_str());
  
  
      channelATselection = int(fetchData(0, PART::control::channelATset, npart));
      fetchChannel();
      keyATselection = int(fetchData(0, PART::control::keyATset, npart));
      fetchKey();
}

void PartUI::fetchChannel() {
  //
              channelfiltercutoff->value(0); // clear settings first
              channelfilterCminus->value(0);
              channelfilterCminus->deactivate();
              channelfilterQ->value(0);
              channelfilterQminus->value(0);
              channelfilterQminus->deactivate();
              channelpitchbend->value(0);
              channelpitchBminus->value(0);
              channelpitchBminus->deactivate();
              channelmodulation->value(0);
              channelvolume->value(0);
  
  
      if (channelATselection & PART::aftertouchType::filterCutoff)
      {
           channelfiltercutoff->value(1);
           channelfilterCminus->activate();
           if (channelATselection & PART::aftertouchType::filterCutoffDown)
               channelfilterCminus->value(1);
      }
      if (channelATselection & PART::aftertouchType::filterQ)
      {
           channelfilterQ->value(1);
           channelfilterQminus->activate();
           if (channelATselection & PART::aftertouchType::filterQdown)
               channelfilterQminus->value(1);
      }
      if (channelATselection & PART::aftertouchType::pitchBend)
      {
          channelpitchbend->value(1);
           channelpitchBminus->activate();
          if (channelATselection & PART::aftertouchType::pitchBendDown)
              channelpitchBminus->value(1);
      }
      if (channelATselection & PART::aftertouchType::modulation)
          channelmodulation->value(1);
      if (channelATselection & PART::aftertouchType::volume)
          channelvolume->value(1);
}

void PartUI::fetchKey() {
  //
              polyfiltercutoff->value(0); // clear settings first
              polyfilterCminus->value(0);
              polyfilterCminus->deactivate();
              polyfilterQ->value(0);
              polyfilterQminus->value(0);
              polyfilterQminus->deactivate();
              polypitchbend->value(0);
              polypitchBminus->value(0);
              polypitchBminus->deactivate();
              polymodulation->value(0);
  
      if (keyATselection & PART::aftertouchType::filterCutoff)
      {
           polyfiltercutoff->value(1);
           polyfilterCminus->activate();
           if (keyATselection & PART::aftertouchType::filterCutoffDown)
               polyfilterCminus->value(1);
      }
      if (keyATselection & PART::aftertouchType::filterQ)
      {
           polyfilterQ->value(1);
           polyfilterQminus->activate();
           if (keyATselection & PART::aftertouchType::filterQdown)
               polyfilterQminus->value(1);
      }
      if (keyATselection & PART::aftertouchType::pitchBend)
      {
          polypitchbend->value(1);
           polypitchBminus->activate();
          if (keyATselection & PART::aftertouchType::pitchBendDown)
              polypitchBminus->value(1);
      }
      if (keyATselection & PART::aftertouchType::modulation)
          polymodulation->value(1);
}

void PartUI::setATchannel(int type, int state) {
  //
          if (type == PART::aftertouchType::off)
              channelATselection = 0;
          else
          {
              if (state > 0)
              {
                  channelATselection |= type;
                  if (keyATselection & type)
                  {
                      keyATselection &= ~type;
                      fetchKey();
                  }
  
              }
              else
              {
                  channelATselection &= ~type;
                  if (type == PART::aftertouchType::filterCutoff)
                      channelATselection &= ~PART::aftertouchType::filterCutoffDown;
                  else if (type == PART::aftertouchType::filterQ)
                      channelATselection &= ~PART::aftertouchType::filterQdown;
                  else if (type == PART::aftertouchType::pitchBend)
                      channelATselection &= ~PART::aftertouchType::pitchBendDown;
              }
          }
          send_data(0, PART::channelATset, channelATselection, TOPLEVEL::type::Integer, npart);
}

void PartUI::setATkey(int type, int state) {
  //
          if (type == PART::aftertouchType::off)
              keyATselection = 0;
          else
          {
              if (state > 0)
              {
                  keyATselection |= type;
                  if (channelATselection & type)
                  {
                      channelATselection &= ~type;
                      fetchChannel();
                  }
              }
              else
              {
                  keyATselection &= ~type;
                  if (type == PART::aftertouchType::filterCutoff)
                      keyATselection &= ~PART::aftertouchType::filterCutoffDown;
                  else if (type == PART::aftertouchType::filterQ)
                      keyATselection &= ~PART::aftertouchType::filterQdown;
                  else if (type == PART::aftertouchType::pitchBend)
                      keyATselection &= ~PART::aftertouchType::pitchBendDown;
              }
          }
          send_data(0, PART::keyATset, keyATselection, TOPLEVEL::type::Integer, npart);
}

void PartUI::init(Part *part_,int npart_,BankUI *bankui_) {
  //
      synth = part_->getSynthEngine();
      bankui = bankui_;
      part = part_;
      npart = npart_;
      plgroup = &synth->getGuiMaster()->panelgroup;
      ninseff = 0;
      make_window();
      end();
}

void PartUI::checkEngines(string instrumentName ) {
  //
      engine = 0;
      if (instrumentName == "")
          instrumentName = part->Pname;
      partname = instrumentName;
  
      if (part->kit[0].Padenabled)
      {
          engine |= 1;
          adsynenabledcheck->value(1);
          adeditbutton->activate();
          addbox->color(ADD_COLOUR);
      }
      else
      {
          adsynenabledcheck->value(0);
          adeditbutton->deactivate();
          addbox->color(FL_BACKGROUND_COLOR);
      }
      ADD->damage(1);
      if (part->kit[0].Psubenabled)
      {
          engine |= 2;
          subsynenabledcheck->value(1);
          subeditbutton->activate();
          subbox->color(SUB_COLOUR);
      }
      else
      {
          subsynenabledcheck->value(0);
          subeditbutton->deactivate();
          subbox->color(FL_BACKGROUND_COLOR);
      }
      SUB->damage(1);
      if (part->kit[0].Ppadenabled)
      {
          engine |= 4;
          padsynenabledcheck->value(1);
          padeditbutton->activate();
          padbox->color(PAD_COLOUR);
      }
      else
      {
          padsynenabledcheck->value(0);
          padeditbutton->deactivate();
          padbox->color(FL_BACKGROUND_COLOR);
      }
      PAD->damage(1);
      for (int i = 1; i < NUM_KIT_ITEMS; ++i)
      {
          if (part->kit[i].Penabled)
          { // nested so we don't access non existent
              if (part->kit[i].Pmuted == 0)
              {
                  engine |= part->kit[i].Padenabled;
                  engine |= (part->kit[i].Psubenabled << 1);
                  engine |= (part->kit[i].Ppadenabled << 2);
              }
          }
      }
      synth->getGuiMaster()->updateEngines(engine, instrumentName);
}

void PartUI::showparameters(int kititem, int engine) {
  //
      string tname;
      kitname = part->kit[kititem].Pname;
      if (engine == -1)
      {   // this is used if I want to clear the engine from the part
          if (kititem == lastkititem)
              kititem = -1;
          else
              kititem = lastkititem;
      }
      checkEngines();
  
      if (kititem != lastkititem)
      {
          if (adnoteui != NULL)
              delete adnoteui;
          if (subnoteui != NULL)
              delete subnoteui;
          if (padnoteui != NULL)
              delete padnoteui;
          adnoteui = NULL;
          subnoteui = NULL;
          padnoteui = NULL;
          lastkititem = kititem;
          if (kititem >= NUM_KIT_ITEMS)
              return; // bad kit item
          if (kititem < 0)
              return;
  
          if (part->kit[kititem].adpars)
              adnoteui = new ADnoteUI(part->kit[kititem].adpars, npart, lastkititem);
  
          if (part->kit[kititem].subpars)
              subnoteui = new SUBnoteUI(part->kit[kititem].subpars, npart, lastkititem);
  
          if (part->kit[kititem].padpars)
              padnoteui = new PADnoteUI(part->kit[kititem].padpars);
      }
  
      if (engine == 0 && adnoteui != NULL)
          adnoteui->ShowGlobal();
      if (engine == 1 && subnoteui != NULL)
          subnoteui->Showsub();
      if (engine == 2 && padnoteui != NULL)
          padnoteui->Showpad();
}

void PartUI::setinstrumentlabel(string text ) {
  //
      engine = 0;
  
      for (int i = 0; i < NUM_KIT_ITEMS; ++i)
      {
          if (part->kit[i].Padenabled)
              engine |= 1;
          if (part->kit[i].Psubenabled)
              engine |= 2;
          if (part->kit[i].Ppadenabled)
              engine |= 4;
      }
      if (engine & 1)
          synth->getGuiMaster()->instrumentaddbox->color(ADD_COLOUR);
      else
          synth->getGuiMaster()->instrumentaddbox->color(BASE_COLOUR);
  
      if (engine & 2)
          synth->getGuiMaster()->instrumentsubbox->color(SUB_COLOUR);
      else
          synth->getGuiMaster()->instrumentsubbox->color(BASE_COLOUR);
  
      if (engine & 4)
          synth->getGuiMaster()->instrumentpadbox->color(PAD_COLOUR);
      else
          synth->getGuiMaster()->instrumentpadbox->color(BASE_COLOUR);
  
      if (part->PyoshiType)
          synth->getGuiMaster()->instrumentlabel->labelcolor(YOSHI_COLOUR);
      else
          synth->getGuiMaster()->instrumentlabel->labelcolor(FL_BLACK);
      if (text == "")
          text = part->Pname.c_str();
      partname = text;
      synth->getGuiMaster()->instrumentlabel->copy_label(text.c_str());
}

void PartUI::setEffNum() {
  //
          insefftype->value(part->partefx[ninseff]->geteffect());
          inseffectui->refresh(part->partefx[ninseff], npart, ninseff);
          int x = part->Pefxroute[ninseff];
          if (x == 127)
              x = 1;
          bypasseff->value(part->Pefxbypass[ninseff]);
          sendtochoice->value(x);
}

void PartUI::seteditname() {
  //
      instrumenteditwindow->copy_label(synth->getGuiMaster()->setPartWindowTitle("Edit").c_str());
}

void PartUI::Showedit() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Part-edit");
  
      if (fetchW < editDW || fetchH < editDH)
      {
          fetchW = editDW;
          fetchH = editDH;
      }
      checkSane(fetchX, fetchY, fetchW, fetchH, editDW, editDH);
  
      instrumenteditwindow->resize(fetchX, fetchY, fetchW, fetchH);
      lasteditW = 0;
      instrumenteditwindow->show();
      editSeen = true;
}

void PartUI::Showctl() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Part-controllers");
  
      if (fetchW < ctlDW || fetchH < ctlDH)
      {
          fetchW = ctlDW;
          fetchH = ctlDH;
      }
      checkSane(fetchX, fetchY, fetchW, fetchH, ctlDW, ctlDH);
  
      ctlwindow->resize(fetchX, fetchY, fetchW, fetchH);
      lastctlW = 0;
      ctlwindow->show();
      ctlSeen = true;
}

void PartUI::ShowAT() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Part-aftertouch");
  
      if (fetchW < atDW || fetchH < atDH)
      {
          fetchW = atDW;
          fetchH = atDH;
      }
      checkSane(fetchX, fetchY, fetchW, fetchH, atDW, atDH);
  
      aftertouchcontrol->resize(fetchX, fetchY, fetchW, fetchH);
      aftertouchcontrol->show();
}

void PartUI::Showctlmidi() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Part-ctlmidi");
  
      if (fetchW < midiDW || fetchH < midiDH)
      {
          fetchW = midiDW;
          fetchH = midiDH;
      }
      checkSane(fetchX, fetchY, fetchW, fetchH, midiDW, midiDH, true);
  
      ctlmidi->resize(fetchX, fetchY, fetchW, fetchH);
      ctlmidi->show();
      ctlmidiSeen = true;
}

void PartUI::Showefx() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Part-effects");
  
      if (fetchW < fxDW || fetchH < fxDH)
      {
          fetchW = fxDW;
          fetchH = fxDH;
      }
      checkSane(fetchX, fetchY, fetchW, fetchH, fxDW, fxDH);
  
      partfx->resize(fetchX, fetchY, fetchW, fetchH);
      partfx->show();
      fxSeen = true;
}

void PartUI::Showkit() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Part-kit");
  
      if (fetchW < kitDW || fetchH < kitDH)
      {
          fetchW = kitDW;
          fetchH = kitDH;
      }
      checkSane(fetchX, fetchY, fetchW, fetchH, kitDW, kitDH);
  
      instrumentkitlist->resize(fetchX, fetchY, fetchW, fetchH);
      instrumentkitlist->show();
      kitSeen = true;
}

void PartUI::wincheck() {
  //
      if (instrumenteditwindow->visible())
          editRtext();
  
      if (partfx->visible())
      {
          if (insefftype->value() == 8) // dynfilter
          {
              if(inseffectui->filterwindow != NULL)
              {
                  if(inseffectui->filterwindow->visible())
                      inseffectui->filtRtext();
              }
          }
          if ( partfx->w() != lastfxW)
          {
              fxRtext();
              lastfxW = partfx->w();
          }
      }
  
  
      if (instrumentkitlist->visible() && instrumentkitlist->w() != lastkitW)
      {
          kitRtext();
          lastkitW = instrumentkitlist->w();
      }
      if (ctlwindow->visible())
          ctlRtext();
  
      if (ctlmidi->visible() && ctlmidi->w() != lastmidiW)
      {
          ctlmidiRtext();
          lastmidiW = ctlmidi->w();
      }
      if (aftertouchcontrol->visible() && aftertouchcontrol->w() != lastatW)
      {
          ATRtext();
          lastatW = aftertouchcontrol->w();
      }
  
      if (adnoteui)
          adnoteui->wincheck();
      if (subnoteui)
          subnoteui->subRtext();
      if (padnoteui)
          padnoteui->padRtext();
}

void PartUI::editRtext() {
  //
      if (lasteditW == instrumenteditwindow->w())
          return;
      lasteditW = instrumenteditwindow->w();
  
      float dScale = instrumenteditwindow->w() / float(editDW);
      if (dScale < 0.2f)
          dScale = 0.2f;
  
      int size = int(10 * dScale);
      int size11 = int(11 * dScale);
      int size12 = int(12 * dScale);
      int size14 = int(14 * dScale);
      int boxY = int(227 * dScale);
      int boxWidth = int(89 * dScale);
      int boxHeight = int(18 * dScale);
  
      ADD->labelsize(size14);
      addbox->resize(int(8 * dScale), boxY, boxWidth, boxHeight);
      adsynenabledcheck->labelsize(size11);
      adeditbutton->labelsize(size14);
  
      SUB->labelsize(size14);
      subbox->resize(int(103 * dScale), boxY, boxWidth, boxHeight);
      subsynenabledcheck->labelsize(size11);
      subeditbutton->labelsize(size14);
  
      PAD->labelsize(size14);
      padbox->resize(int(198 * dScale), boxY, boxWidth, boxHeight);
      padsynenabledcheck->labelsize(size11);
      padeditbutton->labelsize(size14);
  
      kitedit->labelsize(size14);
      effects->labelsize(size14);
      editAT->labelsize(size14);
  
      A_C_display->labelsize(size12);
      A_C_default->labelsize(size12);
      copyright->labelsize(size12);
          copyright->textsize(size14);
      commentField->labelsize(size12);
          commentField->textsize(size14);
      originalname->labelsize(size12);
      originaltext->labelsize(size12);
      instrumentType->labelsize(size11);
          instrumentType->textsize(size11);
  
      humanise->labelsize(size12);
          humanise->textsize(size);
      velocityhumanise->labelsize(size12);
          velocityhumanise->textsize(size);
  
      instrumentReset->labelsize(size14);
      editClose->labelsize(size14);
  ;
      humanise_display->labelsize(size14);
  
      instrumenteditwindow->redraw();
}

void PartUI::ctlRtext() {
  //
      if (lastctlW == ctlwindow->w())
          return;
      lastctlW = ctlwindow->w();
  
      float dScale =  ctlwindow->w() / float(ctlDW);
      if (dScale < 0.2f)
          dScale = 0.2f;
  
      int size = int(dScale * 10);
      int size14 = int(dScale * 14);
  
      volrng->labelsize(size);
      vol->labelsize(size);
      panwidth->labelsize(size);
      modwh->labelsize(size);
      expmwh->labelsize(size);
      bwdpth->labelsize(size);
      expbw->labelsize(size);
      expr->labelsize(size);
      fmamp->labelsize(size);
      sustain->labelsize(size);
      breath->labelsize(size);
      pwheelbrng->labelsize(size);
      pwheelbrng->textsize(size14);
      filtq->labelsize(size);
      fltcut->labelsize(size);
  
      ctlresonance->labelsize(size);
      cfdpth->labelsize(size);
      rbwdpth->labelsize(size);
  
      ctlportamento->labelsize(size);
      ctlx100->labelsize(size);
      prtime->labelsize(size);
      timedu->labelsize(size);
      thresh->labelsize(size);
      thresh->textsize(size14);
      thtype->labelsize(size);
      propta->labelsize(size);
      proptb->labelsize(size);
      rcv->labelsize(size);
      proprt->labelsize(size);
  
      resetallctl->labelsize(size14);
      aftertouch->labelsize(size14);
      ctlclose->labelsize(size14);
      ctlwindow->redraw();
}

void PartUI::ATRtext() {
  //
      float dScale =  aftertouchcontrol->w() / float(atDW);
      if (dScale < 0.2f)
          dScale = 0.2f;
  
      int size14 = int(dScale * 14);
  
      ATchan->labelsize(size14);
      channeloff->labelsize(size14);
      channelfiltercutoff->labelsize(size14);
      channelfilterCminus->labelsize(size14);
      channelfilterQ->labelsize(size14);
      channelfilterQminus->labelsize(size14);
      channelpitchbend->labelsize(size14);
      channelpitchBminus->labelsize(size14);
      channelmodulation->labelsize(size14);
      channelvolume->labelsize(size14);
  
      ATkey->labelsize(size14);
      polyoff->labelsize(size14);
      polyfiltercutoff->labelsize(size14);
      polyfilterCminus->labelsize(size14);
      polyfilterQ->labelsize(size14);
      polyfilterQminus->labelsize(size14);
      polypitchbend->labelsize(size14);
      polypitchBminus->labelsize(size14);
      polymodulation->labelsize(size14);
  
      atClose->labelsize(size14);
  
      aftertouchcontrol->redraw();
}

void PartUI::ctlmidiRtext() {
  //
      float dScale = ctlmidi->w() / float(midiDW);
      if (dScale < 0.2f)
          dScale = 0.2f;
  
      int size = int(dScale * 10);
  
      modulation->labelsize(size);
      expression->labelsize(size);
      filterq->labelsize(size);
      filtercutoff->labelsize(size);
      masterbandwidth->labelsize(size);
      ctlmidiclose->labelsize(int(dScale * 14)-1);
  
      ctlmidi->redraw();
}

void PartUI::fxRtext() {
  //
      float dScale =  partfx->w() / float(fxDW);
      if (dScale < 0.2f)
          dScale = 0.2f;
  
      int size12 = int(12 * dScale);
      inseffnocounter->labelsize(size12);
          inseffnocounter->textsize(size12);
      insefftype->labelsize(size12);
          insefftype->textsize(size12);
      sendtochoice->labelsize(size12);
          sendtochoice->textsize(size12);
  
      effCopy->labelsize(size12);
      effPaste->labelsize(size12);
      bypasseff->labelsize(size12);
      effClose->labelsize(int(14 * dScale));
  
      inseffectui->effRtext(dScale, insefftype->value());
  
      partfx->redraw();
}

void PartUI::kitRtext(bool force ) {
  //
      if (force)
      {
          int fetchW, fetchH, fetchX, fetchY, fetchO;
          loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Part-kit");
          instrumentkitlist->resize(fetchX, fetchY, fetchW, fetchH);
          //kitSeen = true;
      };
  
      float dW = instrumentkitlist->w() / float(kitDW);
      float dH = instrumentkitlist->h() / float(kitDH);
  
      float dScale = dW;
      if (dScale < 0.2f)
          dScale = 0.2f;
  
      int size11 = int(11 * dScale);
  
      kitnum->labelsize(size11);
      kitmute->labelsize(size11);
      kitID->labelsize(size11);
      kitminkey->labelsize(size11);
      kitmaxkey->labelsize(size11);
      kitadd->labelsize(size11);
      kitsub->labelsize(size11);
      kitpad->labelsize(size11);
      kitfxnum->labelsize(size11);
      kitMode->labelsize(size11);
          kitMode->textsize(size11);
  
      drumMode->labelsize(size11);
      kitClose->labelsize(int(12 * dScale));
  
  
     kitpack->resize(0, int(21.0f * dH), int(670.0f * dW), int(322.0f * dH));
  
     for (int i = 0; i < NUM_KIT_ITEMS; ++i)
     {
         partkititem[i]->size(int(670.0f * dW), int(20.0f * dH));
         partkititem[i]->partkititemgroup->size(int(605.0f * dW), int(20.0f * dH));
         partkititem[i]->itemRtext(dScale);
     }
  
      instrumentkitlist->redraw();
}

PartUI::~PartUI() {
  //
      if (adnoteui)
      {
          adnoteui->ADnoteGlobalParameters->hide();
          delete adnoteui;
      }
      if (subnoteui)
      {
          //subnoteui->hide();
          delete subnoteui;
      }
      if (padnoteui)
      {
          //padnoteui->hide();
          delete padnoteui;
      }
      if (atSeen > 0)
          saveWin(synth, aftertouchcontrol->w(), aftertouchcontrol->h(), aftertouchcontrol->x(), aftertouchcontrol->y(), true, "Part-aftertouch");
      aftertouchcontrol->hide();
      delete aftertouchcontrol;
  
      if (ctlSeen)
          saveWin(synth, ctlwindow->w(), ctlwindow->h(), ctlwindow->x(), ctlwindow->y(), true, "Part-controllers");
      ctlwindow->hide();
      delete ctlwindow;
  
      if (ctlmidiSeen)
          saveWin(synth, ctlmidi->w(), ctlmidi->h(), ctlmidi->x(), ctlmidi->y(), ctlmidi->visible(), "Part-ctlmidi");
      ctlmidi->hide();
      lastctlW = 0;
      delete ctlmidi;
  
      if (kitSeen)
          saveWin(synth, instrumentkitlist->w(), instrumentkitlist->h(), instrumentkitlist->x(), instrumentkitlist->y(), true, "Part-kit");
      instrumentkitlist->hide();
      delete instrumentkitlist;
  
      if (fxSeen)
          saveWin(synth,  partfx->w(), partfx->h(),  partfx->x(),  partfx->y(),  partfx->visible(), "Part-effects");
      partfx->hide();
      delete partfx;
  
      if (editSeen)
          saveWin(synth, instrumenteditwindow->w(), instrumenteditwindow->h(), instrumenteditwindow->x(),instrumenteditwindow->y(), true, "Part-edit");
      instrumenteditwindow->hide();
      lasteditW = 0;
  
      delete instrumenteditwindow;
}
