// content/common/navigation_params.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/common/navigation_params.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "content/common/navigation_params.mojom-params-data.h"
#include "content/common/navigation_params.mojom-shared-message-ids.h"

#include "content/common/navigation_params.mojom-import-headers.h"


#ifndef CONTENT_COMMON_NAVIGATION_PARAMS_MOJOM_JUMBO_H_
#define CONTENT_COMMON_NAVIGATION_PARAMS_MOJOM_JUMBO_H_
#include "content/common/frame_messages.h"
#include "content/common/resource_messages.h"
#include "third_party/blink/common/feature_policy/feature_policy_mojom_traits.h"
#endif
namespace content {
namespace mojom {
InitiatorCSPInfo::InitiatorCSPInfo()
    : should_check_main_world_csp(::network::mojom::CSPDisposition::CHECK),
      initiator_csp(),
      initiator_self_source() {}

InitiatorCSPInfo::InitiatorCSPInfo(
    ::network::mojom::CSPDisposition should_check_main_world_csp_in,
    std::vector<::network::mojom::ContentSecurityPolicyPtr> initiator_csp_in,
    ::network::mojom::CSPSourcePtr initiator_self_source_in)
    : should_check_main_world_csp(std::move(should_check_main_world_csp_in)),
      initiator_csp(std::move(initiator_csp_in)),
      initiator_self_source(std::move(initiator_self_source_in)) {}

InitiatorCSPInfo::~InitiatorCSPInfo() = default;

void InitiatorCSPInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("should_check_main_world_csp", base::trace_event::ValueToString(this->should_check_main_world_csp));
  value->BeginArray("initiator_csp");
  for (const auto& item0 : this->initiator_csp) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  if (this->initiator_self_source.is_null()) {
    value->SetString("initiator_self_source", "nullptr");
  } else {
    value->BeginDictionary("initiator_self_source");
    this->initiator_self_source->AsValueInto(value);
    value->EndDictionary();
  }
}

bool InitiatorCSPInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BeginNavigationParams::BeginNavigationParams()
    : initiator_routing_id(-2),
      headers(),
      load_flags(0),
      skip_service_worker(false),
      request_context_type(::blink::mojom::RequestContextType::UNSPECIFIED),
      request_destination(::network::mojom::RequestDestination::kEmpty),
      mixed_content_context_type(),
      is_form_submission(false),
      was_initiated_by_link_click(false),
      searchable_form_url(),
      searchable_form_encoding(),
      client_side_redirect_url(),
      devtools_initiator(),
      force_ignore_site_for_cookies(false),
      trust_token_params(),
      impression(),
      before_unload_start(),
      before_unload_end() {}

BeginNavigationParams::BeginNavigationParams(
    int32_t initiator_routing_id_in,
    const std::string& headers_in,
    int32_t load_flags_in,
    bool skip_service_worker_in,
    ::blink::mojom::RequestContextType request_context_type_in,
    ::network::mojom::RequestDestination request_destination_in,
    ::blink::WebMixedContentContextType mixed_content_context_type_in,
    bool is_form_submission_in,
    bool was_initiated_by_link_click_in,
    const ::GURL& searchable_form_url_in,
    const std::string& searchable_form_encoding_in,
    const ::GURL& client_side_redirect_url_in,
    base::Optional<::base::Value> devtools_initiator_in,
    bool force_ignore_site_for_cookies_in,
    ::network::mojom::TrustTokenParamsPtr trust_token_params_in,
    const base::Optional<::content::Impression>& impression_in,
    ::base::TimeTicks before_unload_start_in,
    ::base::TimeTicks before_unload_end_in)
    : initiator_routing_id(std::move(initiator_routing_id_in)),
      headers(std::move(headers_in)),
      load_flags(std::move(load_flags_in)),
      skip_service_worker(std::move(skip_service_worker_in)),
      request_context_type(std::move(request_context_type_in)),
      request_destination(std::move(request_destination_in)),
      mixed_content_context_type(std::move(mixed_content_context_type_in)),
      is_form_submission(std::move(is_form_submission_in)),
      was_initiated_by_link_click(std::move(was_initiated_by_link_click_in)),
      searchable_form_url(std::move(searchable_form_url_in)),
      searchable_form_encoding(std::move(searchable_form_encoding_in)),
      client_side_redirect_url(std::move(client_side_redirect_url_in)),
      devtools_initiator(std::move(devtools_initiator_in)),
      force_ignore_site_for_cookies(std::move(force_ignore_site_for_cookies_in)),
      trust_token_params(std::move(trust_token_params_in)),
      impression(std::move(impression_in)),
      before_unload_start(std::move(before_unload_start_in)),
      before_unload_end(std::move(before_unload_end_in)) {}

BeginNavigationParams::~BeginNavigationParams() = default;

void BeginNavigationParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("initiator_routing_id", this->initiator_routing_id);
  value->SetString("headers", this->headers);
  value->SetInteger("load_flags", this->load_flags);
  value->SetBoolean("skip_service_worker", this->skip_service_worker);
  value->SetString("request_context_type", base::trace_event::ValueToString(this->request_context_type));
  value->SetString("request_destination", base::trace_event::ValueToString(this->request_destination));
  value->SetInteger("mixed_content_context_type", static_cast<int>(this->mixed_content_context_type));
  value->SetBoolean("is_form_submission", this->is_form_submission);
  value->SetBoolean("was_initiated_by_link_click", this->was_initiated_by_link_click);
  value->SetString("searchable_form_url", base::trace_event::ValueToString(this->searchable_form_url, "<value of type const ::GURL&>"));
  value->SetString("searchable_form_encoding", this->searchable_form_encoding);
  value->SetString("client_side_redirect_url", base::trace_event::ValueToString(this->client_side_redirect_url, "<value of type const ::GURL&>"));
  value->SetString("devtools_initiator", base::trace_event::ValueToString(this->devtools_initiator, "<value of type base::Optional<::base::Value>>"));
  value->SetBoolean("force_ignore_site_for_cookies", this->force_ignore_site_for_cookies);
  if (this->trust_token_params.is_null()) {
    value->SetString("trust_token_params", "nullptr");
  } else {
    value->BeginDictionary("trust_token_params");
    this->trust_token_params->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("impression", base::trace_event::ValueToString(this->impression, "<value of type const base::Optional<::content::Impression>&>"));
  value->SetString("before_unload_start", base::trace_event::ValueToString(this->before_unload_start, "<value of type ::base::TimeTicks>"));
  value->SetString("before_unload_end", base::trace_event::ValueToString(this->before_unload_end, "<value of type ::base::TimeTicks>"));
}

bool BeginNavigationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CommonNavigationParams::CommonNavigationParams()
    : url(),
      initiator_origin(),
      referrer(),
      transition(),
      navigation_type(NavigationType::DIFFERENT_DOCUMENT),
      download_policy(),
      should_replace_current_entry(false),
      base_url_for_data_url(),
      history_url_for_data_url(),
      previews_state(0),
      navigation_start(),
      method("GET"),
      post_data(),
      source_location(),
      started_from_context_menu(false),
      has_user_gesture(false),
      text_fragment_token(false),
      initiator_csp_info(),
      initiator_origin_trial_features(),
      href_translate(),
      is_history_navigation_in_new_child_frame(false),
      input_start() {}

CommonNavigationParams::CommonNavigationParams(
    const ::GURL& url_in,
    const base::Optional<::url::Origin>& initiator_origin_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    ::ui::PageTransition transition_in,
    NavigationType navigation_type_in,
    const ::content::NavigationDownloadPolicy& download_policy_in,
    bool should_replace_current_entry_in,
    const ::GURL& base_url_for_data_url_in,
    const ::GURL& history_url_for_data_url_in,
    int32_t previews_state_in,
    ::base::TimeTicks navigation_start_in,
    const std::string& method_in,
    ::scoped_refptr<::network::ResourceRequestBody> post_data_in,
    ::network::mojom::SourceLocationPtr source_location_in,
    bool started_from_context_menu_in,
    bool has_user_gesture_in,
    bool text_fragment_token_in,
    InitiatorCSPInfoPtr initiator_csp_info_in,
    std::vector<int32_t> initiator_origin_trial_features_in,
    const std::string& href_translate_in,
    bool is_history_navigation_in_new_child_frame_in,
    ::base::TimeTicks input_start_in)
    : url(std::move(url_in)),
      initiator_origin(std::move(initiator_origin_in)),
      referrer(std::move(referrer_in)),
      transition(std::move(transition_in)),
      navigation_type(std::move(navigation_type_in)),
      download_policy(std::move(download_policy_in)),
      should_replace_current_entry(std::move(should_replace_current_entry_in)),
      base_url_for_data_url(std::move(base_url_for_data_url_in)),
      history_url_for_data_url(std::move(history_url_for_data_url_in)),
      previews_state(std::move(previews_state_in)),
      navigation_start(std::move(navigation_start_in)),
      method(std::move(method_in)),
      post_data(std::move(post_data_in)),
      source_location(std::move(source_location_in)),
      started_from_context_menu(std::move(started_from_context_menu_in)),
      has_user_gesture(std::move(has_user_gesture_in)),
      text_fragment_token(std::move(text_fragment_token_in)),
      initiator_csp_info(std::move(initiator_csp_info_in)),
      initiator_origin_trial_features(std::move(initiator_origin_trial_features_in)),
      href_translate(std::move(href_translate_in)),
      is_history_navigation_in_new_child_frame(std::move(is_history_navigation_in_new_child_frame_in)),
      input_start(std::move(input_start_in)) {}

CommonNavigationParams::~CommonNavigationParams() = default;

void CommonNavigationParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("url", base::trace_event::ValueToString(this->url, "<value of type const ::GURL&>"));
  value->SetString("initiator_origin", base::trace_event::ValueToString(this->initiator_origin, "<value of type const base::Optional<::url::Origin>&>"));
  if (this->referrer.is_null()) {
    value->SetString("referrer", "nullptr");
  } else {
    value->BeginDictionary("referrer");
    this->referrer->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetInteger("transition", static_cast<int>(this->transition));
  value->SetString("navigation_type", base::trace_event::ValueToString(this->navigation_type));
  value->SetString("download_policy", base::trace_event::ValueToString(this->download_policy, "<value of type const ::content::NavigationDownloadPolicy&>"));
  value->SetBoolean("should_replace_current_entry", this->should_replace_current_entry);
  value->SetString("base_url_for_data_url", base::trace_event::ValueToString(this->base_url_for_data_url, "<value of type const ::GURL&>"));
  value->SetString("history_url_for_data_url", base::trace_event::ValueToString(this->history_url_for_data_url, "<value of type const ::GURL&>"));
  value->SetInteger("previews_state", this->previews_state);
  value->SetString("navigation_start", base::trace_event::ValueToString(this->navigation_start, "<value of type ::base::TimeTicks>"));
  value->SetString("method", this->method);
  value->SetString("post_data", base::trace_event::ValueToString(this->post_data, "<value of type ::scoped_refptr<::network::ResourceRequestBody>>"));
  if (this->source_location.is_null()) {
    value->SetString("source_location", "nullptr");
  } else {
    value->BeginDictionary("source_location");
    this->source_location->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("started_from_context_menu", this->started_from_context_menu);
  value->SetBoolean("has_user_gesture", this->has_user_gesture);
  value->SetBoolean("text_fragment_token", this->text_fragment_token);
  if (this->initiator_csp_info.is_null()) {
    value->SetString("initiator_csp_info", "nullptr");
  } else {
    value->BeginDictionary("initiator_csp_info");
    this->initiator_csp_info->AsValueInto(value);
    value->EndDictionary();
  }
  value->BeginArray("initiator_origin_trial_features");
  for (const auto& item0 : this->initiator_origin_trial_features) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->SetString("href_translate", this->href_translate);
  value->SetBoolean("is_history_navigation_in_new_child_frame", this->is_history_navigation_in_new_child_frame);
  value->SetString("input_start", base::trace_event::ValueToString(this->input_start, "<value of type ::base::TimeTicks>"));
}

bool CommonNavigationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NavigationTiming::NavigationTiming()
    : redirect_start(),
      redirect_end(),
      fetch_start() {}

NavigationTiming::NavigationTiming(
    ::base::TimeTicks redirect_start_in,
    ::base::TimeTicks redirect_end_in,
    ::base::TimeTicks fetch_start_in)
    : redirect_start(std::move(redirect_start_in)),
      redirect_end(std::move(redirect_end_in)),
      fetch_start(std::move(fetch_start_in)) {}

NavigationTiming::~NavigationTiming() = default;

void NavigationTiming::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("redirect_start", base::trace_event::ValueToString(this->redirect_start, "<value of type ::base::TimeTicks>"));
  value->SetString("redirect_end", base::trace_event::ValueToString(this->redirect_end, "<value of type ::base::TimeTicks>"));
  value->SetString("fetch_start", base::trace_event::ValueToString(this->fetch_start, "<value of type ::base::TimeTicks>"));
}

bool NavigationTiming::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OldPageInfo::OldPageInfo()
    : routing_id_for_old_main_frame(-1),
      new_lifecycle_state_for_old_page() {}

OldPageInfo::OldPageInfo(
    int32_t routing_id_for_old_main_frame_in,
    ::blink::mojom::PageLifecycleStatePtr new_lifecycle_state_for_old_page_in)
    : routing_id_for_old_main_frame(std::move(routing_id_for_old_main_frame_in)),
      new_lifecycle_state_for_old_page(std::move(new_lifecycle_state_for_old_page_in)) {}

OldPageInfo::~OldPageInfo() = default;
size_t OldPageInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->routing_id_for_old_main_frame);
  seed = mojo::internal::Hash(seed, this->new_lifecycle_state_for_old_page);
  return seed;
}

void OldPageInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("routing_id_for_old_main_frame", this->routing_id_for_old_main_frame);
  if (this->new_lifecycle_state_for_old_page.is_null()) {
    value->SetString("new_lifecycle_state_for_old_page", "nullptr");
  } else {
    value->BeginDictionary("new_lifecycle_state_for_old_page");
    this->new_lifecycle_state_for_old_page->AsValueInto(value);
    value->EndDictionary();
  }
}

bool OldPageInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CommitNavigationParams::CommitNavigationParams()
    : origin_to_commit(),
      is_overriding_user_agent(false),
      redirects(),
      redirect_response(),
      redirect_infos(),
      post_content_type(),
      original_url(),
      original_method(),
      can_load_local_resources(false),
      page_state(),
      nav_entry_id(0),
      subframe_unique_names(),
      intended_as_new_entry(false),
      pending_history_list_offset(-1),
      current_history_list_offset(-1),
      current_history_list_length(0),
      was_discarded(false),
      is_view_source(false),
      should_clear_history_list(false),
      navigation_timing(),
      appcache_host_id(),
      was_activated(::content::mojom::WasActivatedOption::kUnknown),
      navigation_token(),
      prefetched_signed_exchanges(),
      is_browser_initiated(false),
      ip_address_space(::network::mojom::IPAddressSpace::kUnknown),
      web_bundle_physical_url(),
      web_bundle_claimed_url(),
      document_ukm_source_id(),
      frame_policy(),
      force_enabled_origin_trials(),
      origin_isolated(false),
      enabled_client_hints(),
      is_cross_browsing_instance(false),
      forced_content_security_policies(),
      old_page_info() {}

CommitNavigationParams::CommitNavigationParams(
    const base::Optional<::url::Origin>& origin_to_commit_in,
    bool is_overriding_user_agent_in,
    std::vector<::GURL> redirects_in,
    std::vector<::network::mojom::URLResponseHeadPtr> redirect_response_in,
    std::vector<::net::RedirectInfo> redirect_infos_in,
    const std::string& post_content_type_in,
    const ::GURL& original_url_in,
    const std::string& original_method_in,
    bool can_load_local_resources_in,
    const ::content::PageState& page_state_in,
    int32_t nav_entry_id_in,
    const base::flat_map<std::string, bool>& subframe_unique_names_in,
    bool intended_as_new_entry_in,
    int32_t pending_history_list_offset_in,
    int32_t current_history_list_offset_in,
    int32_t current_history_list_length_in,
    bool was_discarded_in,
    bool is_view_source_in,
    bool should_clear_history_list_in,
    NavigationTimingPtr navigation_timing_in,
    const base::Optional<::base::UnguessableToken>& appcache_host_id_in,
    ::content::mojom::WasActivatedOption was_activated_in,
    const ::base::UnguessableToken& navigation_token_in,
    std::vector<::content::mojom::PrefetchedSignedExchangeInfoPtr> prefetched_signed_exchanges_in,
    bool is_browser_initiated_in,
    ::network::mojom::IPAddressSpace ip_address_space_in,
    const ::GURL& web_bundle_physical_url_in,
    const ::GURL& web_bundle_claimed_url_in,
    int64_t document_ukm_source_id_in,
    const base::Optional<::blink::FramePolicy>& frame_policy_in,
    std::vector<std::string> force_enabled_origin_trials_in,
    bool origin_isolated_in,
    std::vector<::network::mojom::WebClientHintsType> enabled_client_hints_in,
    bool is_cross_browsing_instance_in,
    std::vector<std::string> forced_content_security_policies_in,
    OldPageInfoPtr old_page_info_in)
    : origin_to_commit(std::move(origin_to_commit_in)),
      is_overriding_user_agent(std::move(is_overriding_user_agent_in)),
      redirects(std::move(redirects_in)),
      redirect_response(std::move(redirect_response_in)),
      redirect_infos(std::move(redirect_infos_in)),
      post_content_type(std::move(post_content_type_in)),
      original_url(std::move(original_url_in)),
      original_method(std::move(original_method_in)),
      can_load_local_resources(std::move(can_load_local_resources_in)),
      page_state(std::move(page_state_in)),
      nav_entry_id(std::move(nav_entry_id_in)),
      subframe_unique_names(std::move(subframe_unique_names_in)),
      intended_as_new_entry(std::move(intended_as_new_entry_in)),
      pending_history_list_offset(std::move(pending_history_list_offset_in)),
      current_history_list_offset(std::move(current_history_list_offset_in)),
      current_history_list_length(std::move(current_history_list_length_in)),
      was_discarded(std::move(was_discarded_in)),
      is_view_source(std::move(is_view_source_in)),
      should_clear_history_list(std::move(should_clear_history_list_in)),
      navigation_timing(std::move(navigation_timing_in)),
      appcache_host_id(std::move(appcache_host_id_in)),
      was_activated(std::move(was_activated_in)),
      navigation_token(std::move(navigation_token_in)),
      prefetched_signed_exchanges(std::move(prefetched_signed_exchanges_in)),
      is_browser_initiated(std::move(is_browser_initiated_in)),
      ip_address_space(std::move(ip_address_space_in)),
      web_bundle_physical_url(std::move(web_bundle_physical_url_in)),
      web_bundle_claimed_url(std::move(web_bundle_claimed_url_in)),
      document_ukm_source_id(std::move(document_ukm_source_id_in)),
      frame_policy(std::move(frame_policy_in)),
      force_enabled_origin_trials(std::move(force_enabled_origin_trials_in)),
      origin_isolated(std::move(origin_isolated_in)),
      enabled_client_hints(std::move(enabled_client_hints_in)),
      is_cross_browsing_instance(std::move(is_cross_browsing_instance_in)),
      forced_content_security_policies(std::move(forced_content_security_policies_in)),
      old_page_info(std::move(old_page_info_in)) {}

CommitNavigationParams::~CommitNavigationParams() = default;

void CommitNavigationParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("origin_to_commit", base::trace_event::ValueToString(this->origin_to_commit, "<value of type const base::Optional<::url::Origin>&>"));
  value->SetBoolean("is_overriding_user_agent", this->is_overriding_user_agent);
  value->BeginArray("redirects");
  for (const auto& item0 : this->redirects) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::GURL&>"));
  }
  value->EndArray();
  value->BeginArray("redirect_response");
  for (const auto& item0 : this->redirect_response) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->BeginArray("redirect_infos");
  for (const auto& item0 : this->redirect_infos) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::net::RedirectInfo&>"));
  }
  value->EndArray();
  value->SetString("post_content_type", this->post_content_type);
  value->SetString("original_url", base::trace_event::ValueToString(this->original_url, "<value of type const ::GURL&>"));
  value->SetString("original_method", this->original_method);
  value->SetBoolean("can_load_local_resources", this->can_load_local_resources);
  value->SetString("page_state", base::trace_event::ValueToString(this->page_state, "<value of type const ::content::PageState&>"));
  value->SetInteger("nav_entry_id", this->nav_entry_id);
  value->BeginDictionary("subframe_unique_names");
  for (const auto& item0 : this->subframe_unique_names) {
    value->SetBooleanWithCopiedName(base::trace_event::ValueToString(item0.first, "<value of type const std::string&>"), item0.second);
  }
  value->EndDictionary();
  value->SetBoolean("intended_as_new_entry", this->intended_as_new_entry);
  value->SetInteger("pending_history_list_offset", this->pending_history_list_offset);
  value->SetInteger("current_history_list_offset", this->current_history_list_offset);
  value->SetInteger("current_history_list_length", this->current_history_list_length);
  value->SetBoolean("was_discarded", this->was_discarded);
  value->SetBoolean("is_view_source", this->is_view_source);
  value->SetBoolean("should_clear_history_list", this->should_clear_history_list);
  if (this->navigation_timing.is_null()) {
    value->SetString("navigation_timing", "nullptr");
  } else {
    value->BeginDictionary("navigation_timing");
    this->navigation_timing->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("appcache_host_id", base::trace_event::ValueToString(this->appcache_host_id, "<value of type const base::Optional<::base::UnguessableToken>&>"));
  value->SetString("was_activated", base::trace_event::ValueToString(this->was_activated));
  value->SetString("navigation_token", base::trace_event::ValueToString(this->navigation_token, "<value of type const ::base::UnguessableToken&>"));
  value->BeginArray("prefetched_signed_exchanges");
  for (const auto& item0 : this->prefetched_signed_exchanges) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->SetBoolean("is_browser_initiated", this->is_browser_initiated);
  value->SetString("ip_address_space", base::trace_event::ValueToString(this->ip_address_space));
  value->SetString("web_bundle_physical_url", base::trace_event::ValueToString(this->web_bundle_physical_url, "<value of type const ::GURL&>"));
  value->SetString("web_bundle_claimed_url", base::trace_event::ValueToString(this->web_bundle_claimed_url, "<value of type const ::GURL&>"));
  value->SetString("document_ukm_source_id", base::NumberToString(this->document_ukm_source_id));
  value->SetString("frame_policy", base::trace_event::ValueToString(this->frame_policy, "<value of type const base::Optional<::blink::FramePolicy>&>"));
  value->BeginArray("force_enabled_origin_trials");
  for (const auto& item0 : this->force_enabled_origin_trials) {
    value->AppendString(item0);
  }
  value->EndArray();
  value->SetBoolean("origin_isolated", this->origin_isolated);
  value->BeginArray("enabled_client_hints");
  for (const auto& item0 : this->enabled_client_hints) {
    value->AppendString(base::trace_event::ValueToString(item0));
  }
  value->EndArray();
  value->SetBoolean("is_cross_browsing_instance", this->is_cross_browsing_instance);
  value->BeginArray("forced_content_security_policies");
  for (const auto& item0 : this->forced_content_security_policies) {
    value->AppendString(item0);
  }
  value->EndArray();
  if (this->old_page_info.is_null()) {
    value->SetString("old_page_info", "nullptr");
  } else {
    value->BeginDictionary("old_page_info");
    this->old_page_info->AsValueInto(value);
    value->EndDictionary();
  }
}

bool CommitNavigationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace content

namespace mojo {


// static
bool StructTraits<::content::mojom::InitiatorCSPInfo::DataView, ::content::mojom::InitiatorCSPInfoPtr>::Read(
    ::content::mojom::InitiatorCSPInfo::DataView input,
    ::content::mojom::InitiatorCSPInfoPtr* output) {
  bool success = true;
  ::content::mojom::InitiatorCSPInfoPtr result(::content::mojom::InitiatorCSPInfo::New());
  
      if (success && !input.ReadShouldCheckMainWorldCsp(&result->should_check_main_world_csp))
        success = false;
      if (success && !input.ReadInitiatorCsp(&result->initiator_csp))
        success = false;
      if (success && !input.ReadInitiatorSelfSource(&result->initiator_self_source))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::BeginNavigationParams::DataView, ::content::mojom::BeginNavigationParamsPtr>::Read(
    ::content::mojom::BeginNavigationParams::DataView input,
    ::content::mojom::BeginNavigationParamsPtr* output) {
  bool success = true;
  ::content::mojom::BeginNavigationParamsPtr result(::content::mojom::BeginNavigationParams::New());
  
      if (success)
        result->initiator_routing_id = input.initiator_routing_id();
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success)
        result->load_flags = input.load_flags();
      if (success)
        result->skip_service_worker = input.skip_service_worker();
      if (success && !input.ReadRequestContextType(&result->request_context_type))
        success = false;
      if (success && !input.ReadRequestDestination(&result->request_destination))
        success = false;
      if (success && !input.ReadMixedContentContextType(&result->mixed_content_context_type))
        success = false;
      if (success)
        result->is_form_submission = input.is_form_submission();
      if (success)
        result->was_initiated_by_link_click = input.was_initiated_by_link_click();
      if (success && !input.ReadSearchableFormUrl(&result->searchable_form_url))
        success = false;
      if (success && !input.ReadSearchableFormEncoding(&result->searchable_form_encoding))
        success = false;
      if (success && !input.ReadClientSideRedirectUrl(&result->client_side_redirect_url))
        success = false;
      if (success && !input.ReadDevtoolsInitiator(&result->devtools_initiator))
        success = false;
      if (success)
        result->force_ignore_site_for_cookies = input.force_ignore_site_for_cookies();
      if (success && !input.ReadTrustTokenParams(&result->trust_token_params))
        success = false;
      if (success && !input.ReadImpression(&result->impression))
        success = false;
      if (success && !input.ReadBeforeUnloadStart(&result->before_unload_start))
        success = false;
      if (success && !input.ReadBeforeUnloadEnd(&result->before_unload_end))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CommonNavigationParams::DataView, ::content::mojom::CommonNavigationParamsPtr>::Read(
    ::content::mojom::CommonNavigationParams::DataView input,
    ::content::mojom::CommonNavigationParamsPtr* output) {
  bool success = true;
  ::content::mojom::CommonNavigationParamsPtr result(::content::mojom::CommonNavigationParams::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadInitiatorOrigin(&result->initiator_origin))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadTransition(&result->transition))
        success = false;
      if (success && !input.ReadNavigationType(&result->navigation_type))
        success = false;
      if (success && !input.ReadDownloadPolicy(&result->download_policy))
        success = false;
      if (success)
        result->should_replace_current_entry = input.should_replace_current_entry();
      if (success && !input.ReadBaseUrlForDataUrl(&result->base_url_for_data_url))
        success = false;
      if (success && !input.ReadHistoryUrlForDataUrl(&result->history_url_for_data_url))
        success = false;
      if (success)
        result->previews_state = input.previews_state();
      if (success && !input.ReadNavigationStart(&result->navigation_start))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success && !input.ReadPostData(&result->post_data))
        success = false;
      if (success && !input.ReadSourceLocation(&result->source_location))
        success = false;
      if (success)
        result->started_from_context_menu = input.started_from_context_menu();
      if (success)
        result->has_user_gesture = input.has_user_gesture();
      if (success)
        result->text_fragment_token = input.text_fragment_token();
      if (success && !input.ReadInitiatorCspInfo(&result->initiator_csp_info))
        success = false;
      if (success && !input.ReadInitiatorOriginTrialFeatures(&result->initiator_origin_trial_features))
        success = false;
      if (success && !input.ReadHrefTranslate(&result->href_translate))
        success = false;
      if (success)
        result->is_history_navigation_in_new_child_frame = input.is_history_navigation_in_new_child_frame();
      if (success && !input.ReadInputStart(&result->input_start))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::NavigationTiming::DataView, ::content::mojom::NavigationTimingPtr>::Read(
    ::content::mojom::NavigationTiming::DataView input,
    ::content::mojom::NavigationTimingPtr* output) {
  bool success = true;
  ::content::mojom::NavigationTimingPtr result(::content::mojom::NavigationTiming::New());
  
      if (success && !input.ReadRedirectStart(&result->redirect_start))
        success = false;
      if (success && !input.ReadRedirectEnd(&result->redirect_end))
        success = false;
      if (success && !input.ReadFetchStart(&result->fetch_start))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::OldPageInfo::DataView, ::content::mojom::OldPageInfoPtr>::Read(
    ::content::mojom::OldPageInfo::DataView input,
    ::content::mojom::OldPageInfoPtr* output) {
  bool success = true;
  ::content::mojom::OldPageInfoPtr result(::content::mojom::OldPageInfo::New());
  
      if (success)
        result->routing_id_for_old_main_frame = input.routing_id_for_old_main_frame();
      if (success && !input.ReadNewLifecycleStateForOldPage(&result->new_lifecycle_state_for_old_page))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::content::mojom::CommitNavigationParams::DataView, ::content::mojom::CommitNavigationParamsPtr>::Read(
    ::content::mojom::CommitNavigationParams::DataView input,
    ::content::mojom::CommitNavigationParamsPtr* output) {
  bool success = true;
  ::content::mojom::CommitNavigationParamsPtr result(::content::mojom::CommitNavigationParams::New());
  
      if (success && !input.ReadOriginToCommit(&result->origin_to_commit))
        success = false;
      if (success)
        result->is_overriding_user_agent = input.is_overriding_user_agent();
      if (success && !input.ReadRedirects(&result->redirects))
        success = false;
      if (success && !input.ReadRedirectResponse(&result->redirect_response))
        success = false;
      if (success && !input.ReadRedirectInfos(&result->redirect_infos))
        success = false;
      if (success && !input.ReadPostContentType(&result->post_content_type))
        success = false;
      if (success && !input.ReadOriginalUrl(&result->original_url))
        success = false;
      if (success && !input.ReadOriginalMethod(&result->original_method))
        success = false;
      if (success)
        result->can_load_local_resources = input.can_load_local_resources();
      if (success && !input.ReadPageState(&result->page_state))
        success = false;
      if (success)
        result->nav_entry_id = input.nav_entry_id();
      if (success && !input.ReadSubframeUniqueNames(&result->subframe_unique_names))
        success = false;
      if (success)
        result->intended_as_new_entry = input.intended_as_new_entry();
      if (success)
        result->pending_history_list_offset = input.pending_history_list_offset();
      if (success)
        result->current_history_list_offset = input.current_history_list_offset();
      if (success)
        result->current_history_list_length = input.current_history_list_length();
      if (success)
        result->was_discarded = input.was_discarded();
      if (success)
        result->is_view_source = input.is_view_source();
      if (success)
        result->should_clear_history_list = input.should_clear_history_list();
      if (success && !input.ReadNavigationTiming(&result->navigation_timing))
        success = false;
      if (success && !input.ReadAppcacheHostId(&result->appcache_host_id))
        success = false;
      if (success && !input.ReadWasActivated(&result->was_activated))
        success = false;
      if (success && !input.ReadNavigationToken(&result->navigation_token))
        success = false;
      if (success && !input.ReadPrefetchedSignedExchanges(&result->prefetched_signed_exchanges))
        success = false;
      if (success)
        result->is_browser_initiated = input.is_browser_initiated();
      if (success && !input.ReadIpAddressSpace(&result->ip_address_space))
        success = false;
      if (success && !input.ReadWebBundlePhysicalUrl(&result->web_bundle_physical_url))
        success = false;
      if (success && !input.ReadWebBundleClaimedUrl(&result->web_bundle_claimed_url))
        success = false;
      if (success)
        result->document_ukm_source_id = input.document_ukm_source_id();
      if (success && !input.ReadFramePolicy(&result->frame_policy))
        success = false;
      if (success && !input.ReadForceEnabledOriginTrials(&result->force_enabled_origin_trials))
        success = false;
      if (success)
        result->origin_isolated = input.origin_isolated();
      if (success && !input.ReadEnabledClientHints(&result->enabled_client_hints))
        success = false;
      if (success)
        result->is_cross_browsing_instance = input.is_cross_browsing_instance();
      if (success && !input.ReadForcedContentSecurityPolicies(&result->forced_content_security_policies))
        success = false;
      if (success && !input.ReadOldPageInfo(&result->old_page_info))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif