// media/mojo/mojom/video_encoder_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/video_encoder_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/video_encoder_info.mojom-params-data.h"
#include "media/mojo/mojom/video_encoder_info.mojom-shared-message-ids.h"

#include "media/mojo/mojom/video_encoder_info.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
ScalingSettings::ScalingSettings()
    : min_qp(),
      max_qp() {}

ScalingSettings::ScalingSettings(
    uint8_t min_qp_in,
    uint8_t max_qp_in)
    : min_qp(std::move(min_qp_in)),
      max_qp(std::move(max_qp_in)) {}

ScalingSettings::~ScalingSettings() = default;

void ScalingSettings::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("min_qp", this->min_qp);
  value->SetInteger("max_qp", this->max_qp);
}

bool ScalingSettings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResolutionBitrateLimit::ResolutionBitrateLimit()
    : frame_size(),
      min_start_bitrate_bps(),
      min_bitrate_bps(),
      max_bitrate_bps() {}

ResolutionBitrateLimit::ResolutionBitrateLimit(
    const ::gfx::Size& frame_size_in,
    int32_t min_start_bitrate_bps_in,
    int32_t min_bitrate_bps_in,
    int32_t max_bitrate_bps_in)
    : frame_size(std::move(frame_size_in)),
      min_start_bitrate_bps(std::move(min_start_bitrate_bps_in)),
      min_bitrate_bps(std::move(min_bitrate_bps_in)),
      max_bitrate_bps(std::move(max_bitrate_bps_in)) {}

ResolutionBitrateLimit::~ResolutionBitrateLimit() = default;

void ResolutionBitrateLimit::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("frame_size", base::trace_event::ValueToString(this->frame_size, "<value of type const ::gfx::Size&>"));
  value->SetInteger("min_start_bitrate_bps", this->min_start_bitrate_bps);
  value->SetInteger("min_bitrate_bps", this->min_bitrate_bps);
  value->SetInteger("max_bitrate_bps", this->max_bitrate_bps);
}

bool ResolutionBitrateLimit::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoEncoderInfo::VideoEncoderInfo()
    : implementation_name(),
      supports_native_handle(),
      has_trusted_rate_controller(),
      is_hardware_accelerated(),
      supports_simulcast(),
      scaling_settings(),
      fps_allocation(),
      resolution_bitrate_limits() {}

VideoEncoderInfo::VideoEncoderInfo(
    const std::string& implementation_name_in,
    bool supports_native_handle_in,
    bool has_trusted_rate_controller_in,
    bool is_hardware_accelerated_in,
    bool supports_simulcast_in,
    const base::Optional<::media::ScalingSettings>& scaling_settings_in,
    std::vector<std::vector<uint8_t>> fps_allocation_in,
    std::vector<::media::ResolutionBitrateLimit> resolution_bitrate_limits_in)
    : implementation_name(std::move(implementation_name_in)),
      supports_native_handle(std::move(supports_native_handle_in)),
      has_trusted_rate_controller(std::move(has_trusted_rate_controller_in)),
      is_hardware_accelerated(std::move(is_hardware_accelerated_in)),
      supports_simulcast(std::move(supports_simulcast_in)),
      scaling_settings(std::move(scaling_settings_in)),
      fps_allocation(std::move(fps_allocation_in)),
      resolution_bitrate_limits(std::move(resolution_bitrate_limits_in)) {}

VideoEncoderInfo::~VideoEncoderInfo() = default;

void VideoEncoderInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("implementation_name", this->implementation_name);
  value->SetBoolean("supports_native_handle", this->supports_native_handle);
  value->SetBoolean("has_trusted_rate_controller", this->has_trusted_rate_controller);
  value->SetBoolean("is_hardware_accelerated", this->is_hardware_accelerated);
  value->SetBoolean("supports_simulcast", this->supports_simulcast);
  value->SetString("scaling_settings", base::trace_event::ValueToString(this->scaling_settings, "<value of type const base::Optional<::media::ScalingSettings>&>"));
  value->BeginArray("fps_allocation");
  for (const auto& item0 : this->fps_allocation) {
    value->BeginArray();
    for (const auto& item1 : item0) {
      value->AppendInteger(item1);
    }
    value->EndArray();
  }
  value->EndArray();
  value->BeginArray("resolution_bitrate_limits");
  for (const auto& item0 : this->resolution_bitrate_limits) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::media::ResolutionBitrateLimit&>"));
  }
  value->EndArray();
}

bool VideoEncoderInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::ScalingSettings::DataView, ::media::mojom::ScalingSettingsPtr>::Read(
    ::media::mojom::ScalingSettings::DataView input,
    ::media::mojom::ScalingSettingsPtr* output) {
  bool success = true;
  ::media::mojom::ScalingSettingsPtr result(::media::mojom::ScalingSettings::New());
  
      if (success)
        result->min_qp = input.min_qp();
      if (success)
        result->max_qp = input.max_qp();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::ResolutionBitrateLimit::DataView, ::media::mojom::ResolutionBitrateLimitPtr>::Read(
    ::media::mojom::ResolutionBitrateLimit::DataView input,
    ::media::mojom::ResolutionBitrateLimitPtr* output) {
  bool success = true;
  ::media::mojom::ResolutionBitrateLimitPtr result(::media::mojom::ResolutionBitrateLimit::New());
  
      if (success && !input.ReadFrameSize(&result->frame_size))
        success = false;
      if (success)
        result->min_start_bitrate_bps = input.min_start_bitrate_bps();
      if (success)
        result->min_bitrate_bps = input.min_bitrate_bps();
      if (success)
        result->max_bitrate_bps = input.max_bitrate_bps();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoEncoderInfo::DataView, ::media::mojom::VideoEncoderInfoPtr>::Read(
    ::media::mojom::VideoEncoderInfo::DataView input,
    ::media::mojom::VideoEncoderInfoPtr* output) {
  bool success = true;
  ::media::mojom::VideoEncoderInfoPtr result(::media::mojom::VideoEncoderInfo::New());
  
      if (success && !input.ReadImplementationName(&result->implementation_name))
        success = false;
      if (success)
        result->supports_native_handle = input.supports_native_handle();
      if (success)
        result->has_trusted_rate_controller = input.has_trusted_rate_controller();
      if (success)
        result->is_hardware_accelerated = input.is_hardware_accelerated();
      if (success)
        result->supports_simulcast = input.supports_simulcast();
      if (success && !input.ReadScalingSettings(&result->scaling_settings))
        success = false;
      if (success && !input.ReadFpsAllocation(&result->fps_allocation))
        success = false;
      if (success && !input.ReadResolutionBitrateLimits(&result->resolution_bitrate_limits))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif