// qtwebengine/browser/qtwebchannel.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "qtwebengine/browser/qtwebchannel.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "qtwebengine/browser/qtwebchannel.mojom-params-data.h"
#include "qtwebengine/browser/qtwebchannel.mojom-shared-message-ids.h"

#include "qtwebengine/browser/qtwebchannel.mojom-import-headers.h"


#ifndef QTWEBENGINE_BROWSER_QTWEBCHANNEL_MOJOM_JUMBO_H_
#define QTWEBENGINE_BROWSER_QTWEBCHANNEL_MOJOM_JUMBO_H_
#endif
namespace qtwebchannel {
namespace mojom {
const char WebChannelTransportRender::Name_[] = "qtwebchannel.mojom.WebChannelTransportRender";

WebChannelTransportRenderProxy::WebChannelTransportRenderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebChannelTransportRenderProxy::SetWorldId(
    uint32_t in_worldId) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "qtwebchannel::mojom::WebChannelTransportRender::SetWorldId", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("worldId", base::NumberToString(in_worldId));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebChannelTransportRender_SetWorldId_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::qtwebchannel::mojom::internal::WebChannelTransportRender_SetWorldId_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->worldId = in_worldId;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebChannelTransportRender::Name_);
  message.set_method_name("SetWorldId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebChannelTransportRenderProxy::ResetWorldId(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "qtwebchannel::mojom::WebChannelTransportRender::ResetWorldId");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebChannelTransportRender_ResetWorldId_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::qtwebchannel::mojom::internal::WebChannelTransportRender_ResetWorldId_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebChannelTransportRender::Name_);
  message.set_method_name("ResetWorldId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebChannelTransportRenderProxy::DispatchWebChannelMessage(
    const std::vector<uint8_t>& in_binaryJson, uint32_t in_worldId) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "qtwebchannel::mojom::WebChannelTransportRender::DispatchWebChannelMessage", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("binaryJson");
      for (const auto& item0 : in_binaryJson) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      raw_value->SetString("worldId", base::NumberToString(in_worldId));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebChannelTransportRender_DispatchWebChannelMessage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::qtwebchannel::mojom::internal::WebChannelTransportRender_DispatchWebChannelMessage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->binaryJson)::BaseType::BufferWriter
      binaryJson_writer;
  const mojo::internal::ContainerValidateParams binaryJson_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_binaryJson, buffer, &binaryJson_writer, &binaryJson_validate_params,
      &serialization_context);
  params->binaryJson.Set(
      binaryJson_writer.is_null() ? nullptr : binaryJson_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->binaryJson.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null binaryJson in WebChannelTransportRender.DispatchWebChannelMessage request");
  params->worldId = in_worldId;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebChannelTransportRender::Name_);
  message.set_method_name("DispatchWebChannelMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebChannelTransportRenderStubDispatch::Accept(
    WebChannelTransportRender* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWebChannelTransportRender_SetWorldId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebchannel::mojom::WebChannelTransportRender::SetWorldId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebchannel::mojom::WebChannelTransportRender::SetWorldId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebChannelTransportRender_SetWorldId_Params_Data* params =
          reinterpret_cast<internal::WebChannelTransportRender_SetWorldId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_worldId{};
      WebChannelTransportRender_SetWorldId_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_worldId = input_data_view.worldId();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebChannelTransportRender::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWorldId(
std::move(p_worldId));
      return true;
    }
    case internal::kWebChannelTransportRender_ResetWorldId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebchannel::mojom::WebChannelTransportRender::ResetWorldId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebchannel::mojom::WebChannelTransportRender::ResetWorldId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebChannelTransportRender_ResetWorldId_Params_Data* params =
          reinterpret_cast<internal::WebChannelTransportRender_ResetWorldId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebChannelTransportRender_ResetWorldId_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebChannelTransportRender::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetWorldId();
      return true;
    }
    case internal::kWebChannelTransportRender_DispatchWebChannelMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebchannel::mojom::WebChannelTransportRender::DispatchWebChannelMessage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebchannel::mojom::WebChannelTransportRender::DispatchWebChannelMessage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebChannelTransportRender_DispatchWebChannelMessage_Params_Data* params =
          reinterpret_cast<internal::WebChannelTransportRender_DispatchWebChannelMessage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_binaryJson{};
      uint32_t p_worldId{};
      WebChannelTransportRender_DispatchWebChannelMessage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadBinaryJson(&p_binaryJson))
        success = false;
      if (success)
        p_worldId = input_data_view.worldId();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebChannelTransportRender::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchWebChannelMessage(
std::move(p_binaryJson), 
std::move(p_worldId));
      return true;
    }
  }
  return false;
}

// static
bool WebChannelTransportRenderStubDispatch::AcceptWithResponder(
    WebChannelTransportRender* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebChannelTransportRender_SetWorldId_Name: {
      break;
    }
    case internal::kWebChannelTransportRender_ResetWorldId_Name: {
      break;
    }
    case internal::kWebChannelTransportRender_DispatchWebChannelMessage_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebChannelTransportRenderValidationInfo[] = {
    {internal::kWebChannelTransportRender_SetWorldId_Name,
     {&internal::WebChannelTransportRender_SetWorldId_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebChannelTransportRender_ResetWorldId_Name,
     {&internal::WebChannelTransportRender_ResetWorldId_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebChannelTransportRender_DispatchWebChannelMessage_Name,
     {&internal::WebChannelTransportRender_DispatchWebChannelMessage_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebChannelTransportRenderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebchannel::mojom::WebChannelTransportRender::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebChannelTransportRenderValidationInfo);
}

const char WebChannelTransportHost::Name_[] = "qtwebchannel.mojom.WebChannelTransportHost";

WebChannelTransportHostProxy::WebChannelTransportHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebChannelTransportHostProxy::DispatchWebChannelMessage(
    const std::vector<uint8_t>& in_binaryJson) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "qtwebchannel::mojom::WebChannelTransportHost::DispatchWebChannelMessage", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("binaryJson");
      for (const auto& item0 : in_binaryJson) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWebChannelTransportHost_DispatchWebChannelMessage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::qtwebchannel::mojom::internal::WebChannelTransportHost_DispatchWebChannelMessage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->binaryJson)::BaseType::BufferWriter
      binaryJson_writer;
  const mojo::internal::ContainerValidateParams binaryJson_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_binaryJson, buffer, &binaryJson_writer, &binaryJson_validate_params,
      &serialization_context);
  params->binaryJson.Set(
      binaryJson_writer.is_null() ? nullptr : binaryJson_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->binaryJson.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null binaryJson in WebChannelTransportHost.DispatchWebChannelMessage request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebChannelTransportHost::Name_);
  message.set_method_name("DispatchWebChannelMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebChannelTransportHostStubDispatch::Accept(
    WebChannelTransportHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWebChannelTransportHost_DispatchWebChannelMessage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebchannel::mojom::WebChannelTransportHost::DispatchWebChannelMessage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebchannel::mojom::WebChannelTransportHost::DispatchWebChannelMessage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebChannelTransportHost_DispatchWebChannelMessage_Params_Data* params =
          reinterpret_cast<internal::WebChannelTransportHost_DispatchWebChannelMessage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<uint8_t> p_binaryJson{};
      WebChannelTransportHost_DispatchWebChannelMessage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadBinaryJson(&p_binaryJson))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebChannelTransportHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchWebChannelMessage(
std::move(p_binaryJson));
      return true;
    }
  }
  return false;
}

// static
bool WebChannelTransportHostStubDispatch::AcceptWithResponder(
    WebChannelTransportHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebChannelTransportHost_DispatchWebChannelMessage_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebChannelTransportHostValidationInfo[] = {
    {internal::kWebChannelTransportHost_DispatchWebChannelMessage_Name,
     {&internal::WebChannelTransportHost_DispatchWebChannelMessage_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebChannelTransportHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebchannel::mojom::WebChannelTransportHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebChannelTransportHostValidationInfo);
}

}  // namespace mojom
}  // namespace qtwebchannel

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif