// services/network/public/mojom/url_response_head.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/url_response_head.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "services/network/public/mojom/url_response_head.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool URLResponseHead_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLResponseHead_Data* object = static_cast<const URLResponseHead_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 240 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->headers, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams mime_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->charset, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams charset_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->charset, validation_context,
                                         &charset_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::CTPolicyCompliance_Data
        ::Validate(object->ct_policy_compliance, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->appcache_manifest_url, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->appcache_manifest_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->load_timing, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->load_timing, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->raw_request_response_info, validation_context))
    return false;


  if (!::network::mojom::internal::ConnectionInfo_Data
        ::Validate(object->connection_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alpn_negotiated_protocol, 19, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams alpn_negotiated_protocol_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->alpn_negotiated_protocol, validation_context,
                                         &alpn_negotiated_protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_endpoint, 20, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_endpoint, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxy_server, 22, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->proxy_server, validation_context))
    return false;


  if (!::network::mojom::internal::FetchResponseSource_Data
        ::Validate(object->service_worker_response_source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_list_via_service_worker, 26, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams url_list_via_service_worker_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->url_list_via_service_worker, validation_context,
                                         &url_list_via_service_worker_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::FetchResponseType_Data
        ::Validate(object->response_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_storage_cache_name, 29, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cache_storage_cache_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->cache_storage_cache_name, validation_context,
                                         &cache_storage_cache_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->ssl_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cors_exposed_header_names, 32, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cors_exposed_header_names_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->cors_exposed_header_names, validation_context,
                                         &cors_exposed_header_names_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->auth_challenge_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_start, 45, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_start, 46, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_start, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->parsed_headers, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->origin_policy, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->recursive_prefetch_token, validation_context))
    return false;

  return true;
}

URLResponseHead_Data::URLResponseHead_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network