// skia/public/mojom/bitmap.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "skia/public/mojom/bitmap.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "skia/public/mojom/bitmap.mojom-params-data.h"
#include "skia/public/mojom/bitmap.mojom-shared-message-ids.h"

#include "skia/public/mojom/bitmap.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SKIA_PUBLIC_MOJOM_BITMAP_MOJOM_BLINK_JUMBO_H_
#define SKIA_PUBLIC_MOJOM_BITMAP_MOJOM_BLINK_JUMBO_H_
#endif
namespace skia {
namespace mojom {
namespace blink {
Bitmap::Bitmap()
    : image_info(),
      row_bytes(),
      pixel_data() {}

Bitmap::Bitmap(
    const ::SkImageInfo& image_info_in,
    uint64_t row_bytes_in,
    ::mojo_base::BigBuffer pixel_data_in)
    : image_info(std::move(image_info_in)),
      row_bytes(std::move(row_bytes_in)),
      pixel_data(std::move(pixel_data_in)) {}

Bitmap::~Bitmap() = default;

void Bitmap::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("image_info", base::trace_event::ValueToString(this->image_info, "<value of type const ::SkImageInfo&>"));
  value->SetString("row_bytes", base::NumberToString(this->row_bytes));
  value->SetString("pixel_data", base::trace_event::ValueToString(this->pixel_data, "<value of type ::mojo_base::BigBuffer>"));
}

bool Bitmap::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InlineBitmap::InlineBitmap()
    : image_info(),
      row_bytes(),
      pixel_data() {}

InlineBitmap::InlineBitmap(
    const ::SkImageInfo& image_info_in,
    uint64_t row_bytes_in,
    WTF::Vector<uint8_t> pixel_data_in)
    : image_info(std::move(image_info_in)),
      row_bytes(std::move(row_bytes_in)),
      pixel_data(std::move(pixel_data_in)) {}

InlineBitmap::~InlineBitmap() = default;

void InlineBitmap::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("image_info", base::trace_event::ValueToString(this->image_info, "<value of type const ::SkImageInfo&>"));
  value->SetString("row_bytes", base::NumberToString(this->row_bytes));
  value->BeginArray("pixel_data");
  for (const auto& item0 : this->pixel_data) {
    value->AppendInteger(item0);
  }
  value->EndArray();
}

bool InlineBitmap::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace skia

namespace mojo {


// static
bool StructTraits<::skia::mojom::blink::Bitmap::DataView, ::skia::mojom::blink::BitmapPtr>::Read(
    ::skia::mojom::blink::Bitmap::DataView input,
    ::skia::mojom::blink::BitmapPtr* output) {
  bool success = true;
  ::skia::mojom::blink::BitmapPtr result(::skia::mojom::blink::Bitmap::New());
  
      if (success && !input.ReadImageInfo(&result->image_info))
        success = false;
      if (success)
        result->row_bytes = input.row_bytes();
      if (success && !input.ReadPixelData(&result->pixel_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::skia::mojom::blink::InlineBitmap::DataView, ::skia::mojom::blink::InlineBitmapPtr>::Read(
    ::skia::mojom::blink::InlineBitmap::DataView input,
    ::skia::mojom::blink::InlineBitmapPtr* output) {
  bool success = true;
  ::skia::mojom::blink::InlineBitmapPtr result(::skia::mojom::blink::InlineBitmap::New());
  
      if (success && !input.ReadImageInfo(&result->image_info))
        success = false;
      if (success)
        result->row_bytes = input.row_bytes();
      if (success && !input.ReadPixelData(&result->pixel_data))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif