// third_party/blink/public/mojom/devtools/inspector_issue.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-params-data.h"
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
AffectedCookie::AffectedCookie()
    : name(),
      path(),
      domain() {}

AffectedCookie::AffectedCookie(
    const WTF::String& name_in,
    const WTF::String& path_in,
    const WTF::String& domain_in)
    : name(std::move(name_in)),
      path(std::move(path_in)),
      domain(std::move(domain_in)) {}

AffectedCookie::~AffectedCookie() = default;
size_t AffectedCookie::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->name);
  seed = mojo::internal::WTFHash(seed, this->path);
  seed = mojo::internal::WTFHash(seed, this->domain);
  return seed;
}

void AffectedCookie::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("name", this->name.Utf8());
  value->SetString("path", this->path.Utf8());
  value->SetString("domain", this->domain.Utf8());
}

bool AffectedCookie::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AffectedRequest::AffectedRequest()
    : request_id(),
      url() {}

AffectedRequest::AffectedRequest(
    const WTF::String& request_id_in,
    const WTF::String& url_in)
    : request_id(std::move(request_id_in)),
      url(std::move(url_in)) {}

AffectedRequest::~AffectedRequest() = default;

void AffectedRequest::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("request_id", this->request_id.Utf8());
  value->SetString("url", this->url.Utf8());
}

bool AffectedRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AffectedFrame::AffectedFrame()
    : frame_id() {}

AffectedFrame::AffectedFrame(
    const WTF::String& frame_id_in)
    : frame_id(std::move(frame_id_in)) {}

AffectedFrame::~AffectedFrame() = default;
size_t AffectedFrame::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->frame_id);
  return seed;
}

void AffectedFrame::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("frame_id", this->frame_id.Utf8());
}

bool AffectedFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BlockedByResponseIssueDetails::BlockedByResponseIssueDetails()
    : request(),
      parentFrame(),
      blockedFrame(),
      reason() {}

BlockedByResponseIssueDetails::BlockedByResponseIssueDetails(
    AffectedRequestPtr request_in,
    AffectedFramePtr parentFrame_in,
    AffectedFramePtr blockedFrame_in,
    ::network::mojom::blink::BlockedByResponseReason reason_in)
    : request(std::move(request_in)),
      parentFrame(std::move(parentFrame_in)),
      blockedFrame(std::move(blockedFrame_in)),
      reason(std::move(reason_in)) {}

BlockedByResponseIssueDetails::~BlockedByResponseIssueDetails() = default;

void BlockedByResponseIssueDetails::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->request.is_null()) {
    value->SetString("request", "nullptr");
  } else {
    value->BeginDictionary("request");
    this->request->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->parentFrame.is_null()) {
    value->SetString("parentFrame", "nullptr");
  } else {
    value->BeginDictionary("parentFrame");
    this->parentFrame->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->blockedFrame.is_null()) {
    value->SetString("blockedFrame", "nullptr");
  } else {
    value->BeginDictionary("blockedFrame");
    this->blockedFrame->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("reason", base::trace_event::ValueToString(this->reason));
}

bool BlockedByResponseIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MixedContentIssueDetails::MixedContentIssueDetails()
    : request_context(),
      resolution_status(),
      insecure_url(),
      main_resource_url(),
      request(),
      frame() {}

MixedContentIssueDetails::MixedContentIssueDetails(
    ::blink::mojom::blink::RequestContextType request_context_in,
    MixedContentResolutionStatus resolution_status_in,
    const WTF::String& insecure_url_in,
    const WTF::String& main_resource_url_in,
    AffectedRequestPtr request_in,
    AffectedFramePtr frame_in)
    : request_context(std::move(request_context_in)),
      resolution_status(std::move(resolution_status_in)),
      insecure_url(std::move(insecure_url_in)),
      main_resource_url(std::move(main_resource_url_in)),
      request(std::move(request_in)),
      frame(std::move(frame_in)) {}

MixedContentIssueDetails::~MixedContentIssueDetails() = default;

void MixedContentIssueDetails::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("request_context", base::trace_event::ValueToString(this->request_context));
  value->SetString("resolution_status", base::trace_event::ValueToString(this->resolution_status));
  value->SetString("insecure_url", this->insecure_url.Utf8());
  value->SetString("main_resource_url", this->main_resource_url.Utf8());
  if (this->request.is_null()) {
    value->SetString("request", "nullptr");
  } else {
    value->BeginDictionary("request");
    this->request->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->frame.is_null()) {
    value->SetString("frame", "nullptr");
  } else {
    value->BeginDictionary("frame");
    this->frame->AsValueInto(value);
    value->EndDictionary();
  }
}

bool MixedContentIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetails()
    : blocked_url(),
      violated_directive(),
      content_security_policy_violation_type(),
      frame_ancestor(),
      source_location(),
      violating_node_id(0) {}

ContentSecurityPolicyIssueDetails::ContentSecurityPolicyIssueDetails(
    const base::Optional<::blink::KURL>& blocked_url_in,
    const WTF::String& violated_directive_in,
    ContentSecurityPolicyViolationType content_security_policy_violation_type_in,
    AffectedFramePtr frame_ancestor_in,
    ::network::mojom::blink::SourceLocationPtr source_location_in,
    int32_t violating_node_id_in)
    : blocked_url(std::move(blocked_url_in)),
      violated_directive(std::move(violated_directive_in)),
      content_security_policy_violation_type(std::move(content_security_policy_violation_type_in)),
      frame_ancestor(std::move(frame_ancestor_in)),
      source_location(std::move(source_location_in)),
      violating_node_id(std::move(violating_node_id_in)) {}

ContentSecurityPolicyIssueDetails::~ContentSecurityPolicyIssueDetails() = default;

void ContentSecurityPolicyIssueDetails::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("blocked_url", base::trace_event::ValueToString(this->blocked_url, "<value of type const base::Optional<::blink::KURL>&>"));
  value->SetString("violated_directive", this->violated_directive.Utf8());
  value->SetString("content_security_policy_violation_type", base::trace_event::ValueToString(this->content_security_policy_violation_type));
  if (this->frame_ancestor.is_null()) {
    value->SetString("frame_ancestor", "nullptr");
  } else {
    value->BeginDictionary("frame_ancestor");
    this->frame_ancestor->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->source_location.is_null()) {
    value->SetString("source_location", "nullptr");
  } else {
    value->BeginDictionary("source_location");
    this->source_location->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetInteger("violating_node_id", this->violating_node_id);
}

bool ContentSecurityPolicyIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SameSiteCookieIssueDetails::SameSiteCookieIssueDetails()
    : cookie(),
      exclusion_reason(),
      warning_reason(),
      operation(),
      site_for_cookies(),
      cookie_url(),
      request() {}

SameSiteCookieIssueDetails::SameSiteCookieIssueDetails(
    AffectedCookiePtr cookie_in,
    WTF::Vector<SameSiteCookieExclusionReason> exclusion_reason_in,
    WTF::Vector<SameSiteCookieWarningReason> warning_reason_in,
    SameSiteCookieOperation operation_in,
    const base::Optional<::blink::KURL>& site_for_cookies_in,
    const base::Optional<::blink::KURL>& cookie_url_in,
    AffectedRequestPtr request_in)
    : cookie(std::move(cookie_in)),
      exclusion_reason(std::move(exclusion_reason_in)),
      warning_reason(std::move(warning_reason_in)),
      operation(std::move(operation_in)),
      site_for_cookies(std::move(site_for_cookies_in)),
      cookie_url(std::move(cookie_url_in)),
      request(std::move(request_in)) {}

SameSiteCookieIssueDetails::~SameSiteCookieIssueDetails() = default;

void SameSiteCookieIssueDetails::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->cookie.is_null()) {
    value->SetString("cookie", "nullptr");
  } else {
    value->BeginDictionary("cookie");
    this->cookie->AsValueInto(value);
    value->EndDictionary();
  }
  value->BeginArray("exclusion_reason");
  for (const auto& item0 : this->exclusion_reason) {
    value->AppendString(base::trace_event::ValueToString(item0));
  }
  value->EndArray();
  value->BeginArray("warning_reason");
  for (const auto& item0 : this->warning_reason) {
    value->AppendString(base::trace_event::ValueToString(item0));
  }
  value->EndArray();
  value->SetString("operation", base::trace_event::ValueToString(this->operation));
  value->SetString("site_for_cookies", base::trace_event::ValueToString(this->site_for_cookies, "<value of type const base::Optional<::blink::KURL>&>"));
  value->SetString("cookie_url", base::trace_event::ValueToString(this->cookie_url, "<value of type const base::Optional<::blink::KURL>&>"));
  if (this->request.is_null()) {
    value->SetString("request", "nullptr");
  } else {
    value->BeginDictionary("request");
    this->request->AsValueInto(value);
    value->EndDictionary();
  }
}

bool SameSiteCookieIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InspectorIssueDetails::InspectorIssueDetails()
    : samesite_cookie_issue_details(),
      mixed_content_issue_details(),
      blocked_by_response_issue_details(),
      csp_issue_details() {}

InspectorIssueDetails::InspectorIssueDetails(
    SameSiteCookieIssueDetailsPtr samesite_cookie_issue_details_in,
    MixedContentIssueDetailsPtr mixed_content_issue_details_in,
    BlockedByResponseIssueDetailsPtr blocked_by_response_issue_details_in,
    ContentSecurityPolicyIssueDetailsPtr csp_issue_details_in)
    : samesite_cookie_issue_details(std::move(samesite_cookie_issue_details_in)),
      mixed_content_issue_details(std::move(mixed_content_issue_details_in)),
      blocked_by_response_issue_details(std::move(blocked_by_response_issue_details_in)),
      csp_issue_details(std::move(csp_issue_details_in)) {}

InspectorIssueDetails::~InspectorIssueDetails() = default;

void InspectorIssueDetails::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->samesite_cookie_issue_details.is_null()) {
    value->SetString("samesite_cookie_issue_details", "nullptr");
  } else {
    value->BeginDictionary("samesite_cookie_issue_details");
    this->samesite_cookie_issue_details->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->mixed_content_issue_details.is_null()) {
    value->SetString("mixed_content_issue_details", "nullptr");
  } else {
    value->BeginDictionary("mixed_content_issue_details");
    this->mixed_content_issue_details->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->blocked_by_response_issue_details.is_null()) {
    value->SetString("blocked_by_response_issue_details", "nullptr");
  } else {
    value->BeginDictionary("blocked_by_response_issue_details");
    this->blocked_by_response_issue_details->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->csp_issue_details.is_null()) {
    value->SetString("csp_issue_details", "nullptr");
  } else {
    value->BeginDictionary("csp_issue_details");
    this->csp_issue_details->AsValueInto(value);
    value->EndDictionary();
  }
}

bool InspectorIssueDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InspectorIssueInfo::InspectorIssueInfo()
    : code(),
      details() {}

InspectorIssueInfo::InspectorIssueInfo(
    InspectorIssueCode code_in,
    InspectorIssueDetailsPtr details_in)
    : code(std::move(code_in)),
      details(std::move(details_in)) {}

InspectorIssueInfo::~InspectorIssueInfo() = default;

void InspectorIssueInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("code", base::trace_event::ValueToString(this->code));
  if (this->details.is_null()) {
    value->SetString("details", "nullptr");
  } else {
    value->BeginDictionary("details");
    this->details->AsValueInto(value);
    value->EndDictionary();
  }
}

bool InspectorIssueInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::AffectedCookie::DataView, ::blink::mojom::blink::AffectedCookiePtr>::Read(
    ::blink::mojom::blink::AffectedCookie::DataView input,
    ::blink::mojom::blink::AffectedCookiePtr* output) {
  bool success = true;
  ::blink::mojom::blink::AffectedCookiePtr result(::blink::mojom::blink::AffectedCookie::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadDomain(&result->domain))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AffectedRequest::DataView, ::blink::mojom::blink::AffectedRequestPtr>::Read(
    ::blink::mojom::blink::AffectedRequest::DataView input,
    ::blink::mojom::blink::AffectedRequestPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AffectedRequestPtr result(::blink::mojom::blink::AffectedRequest::New());
  
      if (success && !input.ReadRequestId(&result->request_id))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AffectedFrame::DataView, ::blink::mojom::blink::AffectedFramePtr>::Read(
    ::blink::mojom::blink::AffectedFrame::DataView input,
    ::blink::mojom::blink::AffectedFramePtr* output) {
  bool success = true;
  ::blink::mojom::blink::AffectedFramePtr result(::blink::mojom::blink::AffectedFrame::New());
  
      if (success && !input.ReadFrameId(&result->frame_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::BlockedByResponseIssueDetails::DataView, ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr>::Read(
    ::blink::mojom::blink::BlockedByResponseIssueDetails::DataView input,
    ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr result(::blink::mojom::blink::BlockedByResponseIssueDetails::New());
  
      if (success && !input.ReadRequest(&result->request))
        success = false;
      if (success && !input.ReadParentFrame(&result->parentFrame))
        success = false;
      if (success && !input.ReadBlockedFrame(&result->blockedFrame))
        success = false;
      if (success && !input.ReadReason(&result->reason))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::MixedContentIssueDetails::DataView, ::blink::mojom::blink::MixedContentIssueDetailsPtr>::Read(
    ::blink::mojom::blink::MixedContentIssueDetails::DataView input,
    ::blink::mojom::blink::MixedContentIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::MixedContentIssueDetailsPtr result(::blink::mojom::blink::MixedContentIssueDetails::New());
  
      if (success && !input.ReadRequestContext(&result->request_context))
        success = false;
      if (success && !input.ReadResolutionStatus(&result->resolution_status))
        success = false;
      if (success && !input.ReadInsecureUrl(&result->insecure_url))
        success = false;
      if (success && !input.ReadMainResourceUrl(&result->main_resource_url))
        success = false;
      if (success && !input.ReadRequest(&result->request))
        success = false;
      if (success && !input.ReadFrame(&result->frame))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::ContentSecurityPolicyIssueDetails::DataView, ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr>::Read(
    ::blink::mojom::blink::ContentSecurityPolicyIssueDetails::DataView input,
    ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr result(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::New());
  
      if (success && !input.ReadBlockedUrl(&result->blocked_url))
        success = false;
      if (success && !input.ReadViolatedDirective(&result->violated_directive))
        success = false;
      if (success && !input.ReadContentSecurityPolicyViolationType(&result->content_security_policy_violation_type))
        success = false;
      if (success && !input.ReadFrameAncestor(&result->frame_ancestor))
        success = false;
      if (success && !input.ReadSourceLocation(&result->source_location))
        success = false;
      if (success)
        result->violating_node_id = input.violating_node_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SameSiteCookieIssueDetails::DataView, ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr>::Read(
    ::blink::mojom::blink::SameSiteCookieIssueDetails::DataView input,
    ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr result(::blink::mojom::blink::SameSiteCookieIssueDetails::New());
  
      if (success && !input.ReadCookie(&result->cookie))
        success = false;
      if (success && !input.ReadExclusionReason(&result->exclusion_reason))
        success = false;
      if (success && !input.ReadWarningReason(&result->warning_reason))
        success = false;
      if (success && !input.ReadOperation(&result->operation))
        success = false;
      if (success && !input.ReadSiteForCookies(&result->site_for_cookies))
        success = false;
      if (success && !input.ReadCookieUrl(&result->cookie_url))
        success = false;
      if (success && !input.ReadRequest(&result->request))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::InspectorIssueDetails::DataView, ::blink::mojom::blink::InspectorIssueDetailsPtr>::Read(
    ::blink::mojom::blink::InspectorIssueDetails::DataView input,
    ::blink::mojom::blink::InspectorIssueDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::InspectorIssueDetailsPtr result(::blink::mojom::blink::InspectorIssueDetails::New());
  
      if (success && !input.ReadSamesiteCookieIssueDetails(&result->samesite_cookie_issue_details))
        success = false;
      if (success && !input.ReadMixedContentIssueDetails(&result->mixed_content_issue_details))
        success = false;
      if (success && !input.ReadBlockedByResponseIssueDetails(&result->blocked_by_response_issue_details))
        success = false;
      if (success && !input.ReadCspIssueDetails(&result->csp_issue_details))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::InspectorIssueInfo::DataView, ::blink::mojom::blink::InspectorIssueInfoPtr>::Read(
    ::blink::mojom::blink::InspectorIssueInfo::DataView input,
    ::blink::mojom::blink::InspectorIssueInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::InspectorIssueInfoPtr result(::blink::mojom::blink::InspectorIssueInfo::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success && !input.ReadDetails(&result->details))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif