// third_party/blink/public/mojom/webauthn/authenticator.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-params-data.h"
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBAUTHN_AUTHENTICATOR_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
CommonCredentialInfo::CommonCredentialInfo()
    : id(),
      raw_id(),
      client_data_json(),
      authenticator_data() {}

CommonCredentialInfo::CommonCredentialInfo(
    const std::string& id_in,
    std::vector<uint8_t> raw_id_in,
    std::vector<uint8_t> client_data_json_in,
    std::vector<uint8_t> authenticator_data_in)
    : id(std::move(id_in)),
      raw_id(std::move(raw_id_in)),
      client_data_json(std::move(client_data_json_in)),
      authenticator_data(std::move(authenticator_data_in)) {}

CommonCredentialInfo::~CommonCredentialInfo() = default;

void CommonCredentialInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("id", this->id);
  value->BeginArray("raw_id");
  for (const auto& item0 : this->raw_id) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->BeginArray("client_data_json");
  for (const auto& item0 : this->client_data_json) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->BeginArray("authenticator_data");
  for (const auto& item0 : this->authenticator_data) {
    value->AppendInteger(item0);
  }
  value->EndArray();
}

bool CommonCredentialInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MakeCredentialAuthenticatorResponse::MakeCredentialAuthenticatorResponse()
    : info(),
      attestation_object(),
      transports(),
      echo_hmac_create_secret(),
      hmac_create_secret(),
      echo_prf(),
      prf(),
      public_key_der(),
      public_key_algo(),
      echo_cred_props(),
      has_cred_props_rk(),
      cred_props_rk() {}

MakeCredentialAuthenticatorResponse::MakeCredentialAuthenticatorResponse(
    CommonCredentialInfoPtr info_in,
    std::vector<uint8_t> attestation_object_in,
    std::vector<::device::FidoTransportProtocol> transports_in,
    bool echo_hmac_create_secret_in,
    bool hmac_create_secret_in,
    bool echo_prf_in,
    bool prf_in,
    base::Optional<std::vector<uint8_t>> public_key_der_in,
    int32_t public_key_algo_in,
    bool echo_cred_props_in,
    bool has_cred_props_rk_in,
    bool cred_props_rk_in)
    : info(std::move(info_in)),
      attestation_object(std::move(attestation_object_in)),
      transports(std::move(transports_in)),
      echo_hmac_create_secret(std::move(echo_hmac_create_secret_in)),
      hmac_create_secret(std::move(hmac_create_secret_in)),
      echo_prf(std::move(echo_prf_in)),
      prf(std::move(prf_in)),
      public_key_der(std::move(public_key_der_in)),
      public_key_algo(std::move(public_key_algo_in)),
      echo_cred_props(std::move(echo_cred_props_in)),
      has_cred_props_rk(std::move(has_cred_props_rk_in)),
      cred_props_rk(std::move(cred_props_rk_in)) {}

MakeCredentialAuthenticatorResponse::~MakeCredentialAuthenticatorResponse() = default;

void MakeCredentialAuthenticatorResponse::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->info.is_null()) {
    value->SetString("info", "nullptr");
  } else {
    value->BeginDictionary("info");
    this->info->AsValueInto(value);
    value->EndDictionary();
  }
  value->BeginArray("attestation_object");
  for (const auto& item0 : this->attestation_object) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->BeginArray("transports");
  for (const auto& item0 : this->transports) {
    value->AppendInteger(static_cast<int>(item0));
  }
  value->EndArray();
  value->SetBoolean("echo_hmac_create_secret", this->echo_hmac_create_secret);
  value->SetBoolean("hmac_create_secret", this->hmac_create_secret);
  value->SetBoolean("echo_prf", this->echo_prf);
  value->SetBoolean("prf", this->prf);
  if (this->public_key_der.has_value()) {
    value->BeginArray("public_key_der");
    for (const auto& item0 : this->public_key_der.value()) {
      value->AppendInteger(item0);
    }
    value->EndArray();
  } else {
    value->SetString("public_key_der", "base::nullopt");
  }
  value->SetInteger("public_key_algo", this->public_key_algo);
  value->SetBoolean("echo_cred_props", this->echo_cred_props);
  value->SetBoolean("has_cred_props_rk", this->has_cred_props_rk);
  value->SetBoolean("cred_props_rk", this->cred_props_rk);
}

bool MakeCredentialAuthenticatorResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetAssertionAuthenticatorResponse::GetAssertionAuthenticatorResponse()
    : info(),
      signature(),
      user_handle(),
      echo_appid_extension(),
      appid_extension(),
      echo_prf(),
      prf_results(),
      prf_not_evaluated() {}

GetAssertionAuthenticatorResponse::GetAssertionAuthenticatorResponse(
    CommonCredentialInfoPtr info_in,
    std::vector<uint8_t> signature_in,
    base::Optional<std::vector<uint8_t>> user_handle_in,
    bool echo_appid_extension_in,
    bool appid_extension_in,
    bool echo_prf_in,
    PRFValuesPtr prf_results_in,
    bool prf_not_evaluated_in)
    : info(std::move(info_in)),
      signature(std::move(signature_in)),
      user_handle(std::move(user_handle_in)),
      echo_appid_extension(std::move(echo_appid_extension_in)),
      appid_extension(std::move(appid_extension_in)),
      echo_prf(std::move(echo_prf_in)),
      prf_results(std::move(prf_results_in)),
      prf_not_evaluated(std::move(prf_not_evaluated_in)) {}

GetAssertionAuthenticatorResponse::~GetAssertionAuthenticatorResponse() = default;

void GetAssertionAuthenticatorResponse::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->info.is_null()) {
    value->SetString("info", "nullptr");
  } else {
    value->BeginDictionary("info");
    this->info->AsValueInto(value);
    value->EndDictionary();
  }
  value->BeginArray("signature");
  for (const auto& item0 : this->signature) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  if (this->user_handle.has_value()) {
    value->BeginArray("user_handle");
    for (const auto& item0 : this->user_handle.value()) {
      value->AppendInteger(item0);
    }
    value->EndArray();
  } else {
    value->SetString("user_handle", "base::nullopt");
  }
  value->SetBoolean("echo_appid_extension", this->echo_appid_extension);
  value->SetBoolean("appid_extension", this->appid_extension);
  value->SetBoolean("echo_prf", this->echo_prf);
  if (this->prf_results.is_null()) {
    value->SetString("prf_results", "nullptr");
  } else {
    value->BeginDictionary("prf_results");
    this->prf_results->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("prf_not_evaluated", this->prf_not_evaluated);
}

bool GetAssertionAuthenticatorResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialRpEntity::PublicKeyCredentialRpEntity()
    : id(),
      name(),
      icon() {}

PublicKeyCredentialRpEntity::PublicKeyCredentialRpEntity(
    const std::string& id_in,
    const std::string& name_in,
    const base::Optional<::GURL>& icon_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      icon(std::move(icon_in)) {}

PublicKeyCredentialRpEntity::~PublicKeyCredentialRpEntity() = default;

void PublicKeyCredentialRpEntity::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("id", this->id);
  value->SetString("name", this->name);
  value->SetString("icon", base::trace_event::ValueToString(this->icon, "<value of type const base::Optional<::GURL>&>"));
}

bool PublicKeyCredentialRpEntity::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialUserEntity::PublicKeyCredentialUserEntity()
    : id(),
      name(),
      icon(),
      display_name() {}

PublicKeyCredentialUserEntity::PublicKeyCredentialUserEntity(
    std::vector<uint8_t> id_in,
    const std::string& name_in,
    const base::Optional<::GURL>& icon_in,
    const std::string& display_name_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      icon(std::move(icon_in)),
      display_name(std::move(display_name_in)) {}

PublicKeyCredentialUserEntity::~PublicKeyCredentialUserEntity() = default;

void PublicKeyCredentialUserEntity::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("id");
  for (const auto& item0 : this->id) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->SetString("name", this->name);
  value->SetString("icon", base::trace_event::ValueToString(this->icon, "<value of type const base::Optional<::GURL>&>"));
  value->SetString("display_name", this->display_name);
}

bool PublicKeyCredentialUserEntity::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialParameters::PublicKeyCredentialParameters()
    : type(),
      algorithm_identifier() {}

PublicKeyCredentialParameters::PublicKeyCredentialParameters(
    ::device::CredentialType type_in,
    int32_t algorithm_identifier_in)
    : type(std::move(type_in)),
      algorithm_identifier(std::move(algorithm_identifier_in)) {}

PublicKeyCredentialParameters::~PublicKeyCredentialParameters() = default;

void PublicKeyCredentialParameters::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("type", static_cast<int>(this->type));
  value->SetInteger("algorithm_identifier", this->algorithm_identifier);
}

bool PublicKeyCredentialParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CableAuthentication::CableAuthentication()
    : version(),
      client_eid(),
      authenticator_eid(),
      session_pre_key() {}

CableAuthentication::CableAuthentication(
    uint8_t version_in,
    std::vector<uint8_t> client_eid_in,
    std::vector<uint8_t> authenticator_eid_in,
    std::vector<uint8_t> session_pre_key_in)
    : version(std::move(version_in)),
      client_eid(std::move(client_eid_in)),
      authenticator_eid(std::move(authenticator_eid_in)),
      session_pre_key(std::move(session_pre_key_in)) {}

CableAuthentication::~CableAuthentication() = default;

void CableAuthentication::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("version", this->version);
  value->BeginArray("client_eid");
  for (const auto& item0 : this->client_eid) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->BeginArray("authenticator_eid");
  for (const auto& item0 : this->authenticator_eid) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->BeginArray("session_pre_key");
  for (const auto& item0 : this->session_pre_key) {
    value->AppendInteger(item0);
  }
  value->EndArray();
}

bool CableAuthentication::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CableRegistration::CableRegistration()
    : versions(),
      relying_party_public_key() {}

CableRegistration::CableRegistration(
    std::vector<uint8_t> versions_in,
    std::vector<uint8_t> relying_party_public_key_in)
    : versions(std::move(versions_in)),
      relying_party_public_key(std::move(relying_party_public_key_in)) {}

CableRegistration::~CableRegistration() = default;

void CableRegistration::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("versions");
  for (const auto& item0 : this->versions) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->BeginArray("relying_party_public_key");
  for (const auto& item0 : this->relying_party_public_key) {
    value->AppendInteger(item0);
  }
  value->EndArray();
}

bool CableRegistration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PRFValues::PRFValues()
    : id(),
      first(),
      second() {}

PRFValues::PRFValues(
    base::Optional<std::vector<uint8_t>> id_in,
    std::vector<uint8_t> first_in,
    base::Optional<std::vector<uint8_t>> second_in)
    : id(std::move(id_in)),
      first(std::move(first_in)),
      second(std::move(second_in)) {}

PRFValues::~PRFValues() = default;

void PRFValues::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->id.has_value()) {
    value->BeginArray("id");
    for (const auto& item0 : this->id.value()) {
      value->AppendInteger(item0);
    }
    value->EndArray();
  } else {
    value->SetString("id", "base::nullopt");
  }
  value->BeginArray("first");
  for (const auto& item0 : this->first) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  if (this->second.has_value()) {
    value->BeginArray("second");
    for (const auto& item0 : this->second.value()) {
      value->AppendInteger(item0);
    }
    value->EndArray();
  } else {
    value->SetString("second", "base::nullopt");
  }
}

bool PRFValues::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialRequestOptions::PublicKeyCredentialRequestOptions()
    : challenge(),
      timeout(),
      relying_party_id(),
      allow_credentials(),
      user_verification(),
      appid(),
      cable_authentication_data(),
      prf(),
      prf_inputs() {}

PublicKeyCredentialRequestOptions::PublicKeyCredentialRequestOptions(
    std::vector<uint8_t> challenge_in,
    base::Optional<::base::TimeDelta> timeout_in,
    const std::string& relying_party_id_in,
    std::vector<::device::PublicKeyCredentialDescriptor> allow_credentials_in,
    ::device::UserVerificationRequirement user_verification_in,
    const base::Optional<std::string>& appid_in,
    std::vector<::device::CableDiscoveryData> cable_authentication_data_in,
    bool prf_in,
    std::vector<PRFValuesPtr> prf_inputs_in)
    : challenge(std::move(challenge_in)),
      timeout(std::move(timeout_in)),
      relying_party_id(std::move(relying_party_id_in)),
      allow_credentials(std::move(allow_credentials_in)),
      user_verification(std::move(user_verification_in)),
      appid(std::move(appid_in)),
      cable_authentication_data(std::move(cable_authentication_data_in)),
      prf(std::move(prf_in)),
      prf_inputs(std::move(prf_inputs_in)) {}

PublicKeyCredentialRequestOptions::~PublicKeyCredentialRequestOptions() = default;

void PublicKeyCredentialRequestOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("challenge");
  for (const auto& item0 : this->challenge) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->SetString("timeout", base::trace_event::ValueToString(this->timeout, "<value of type base::Optional<::base::TimeDelta>>"));
  value->SetString("relying_party_id", this->relying_party_id);
  value->BeginArray("allow_credentials");
  for (const auto& item0 : this->allow_credentials) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::device::PublicKeyCredentialDescriptor&>"));
  }
  value->EndArray();
  value->SetInteger("user_verification", static_cast<int>(this->user_verification));
  if (this->appid.has_value()) {
    value->SetString("appid", this->appid.value());
  } else {
    value->SetString("appid", "base::nullopt");
  }
  value->BeginArray("cable_authentication_data");
  for (const auto& item0 : this->cable_authentication_data) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::device::CableDiscoveryData&>"));
  }
  value->EndArray();
  value->SetBoolean("prf", this->prf);
  value->BeginArray("prf_inputs");
  for (const auto& item0 : this->prf_inputs) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
}

bool PublicKeyCredentialRequestOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuthenticatorSelectionCriteria::AuthenticatorSelectionCriteria()
    : authenticator_attachment(),
      resident_key(),
      user_verification() {}

AuthenticatorSelectionCriteria::AuthenticatorSelectionCriteria(
    ::device::AuthenticatorAttachment authenticator_attachment_in,
    ResidentKeyRequirement resident_key_in,
    ::device::UserVerificationRequirement user_verification_in)
    : authenticator_attachment(std::move(authenticator_attachment_in)),
      resident_key(std::move(resident_key_in)),
      user_verification(std::move(user_verification_in)) {}

AuthenticatorSelectionCriteria::~AuthenticatorSelectionCriteria() = default;

void AuthenticatorSelectionCriteria::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("authenticator_attachment", static_cast<int>(this->authenticator_attachment));
  value->SetString("resident_key", base::trace_event::ValueToString(this->resident_key));
  value->SetInteger("user_verification", static_cast<int>(this->user_verification));
}

bool AuthenticatorSelectionCriteria::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialCreationOptions::PublicKeyCredentialCreationOptions()
    : relying_party(),
      user(),
      challenge(),
      public_key_parameters(),
      timeout(),
      exclude_credentials(),
      authenticator_selection(),
      attestation(),
      cable_registration_data(),
      hmac_create_secret(),
      prf_enable(),
      protection_policy(),
      enforce_protection_policy(),
      appid_exclude(),
      cred_props() {}

PublicKeyCredentialCreationOptions::PublicKeyCredentialCreationOptions(
    const ::device::PublicKeyCredentialRpEntity& relying_party_in,
    const ::device::PublicKeyCredentialUserEntity& user_in,
    std::vector<uint8_t> challenge_in,
    std::vector<::device::PublicKeyCredentialParams::CredentialInfo> public_key_parameters_in,
    base::Optional<::base::TimeDelta> timeout_in,
    std::vector<::device::PublicKeyCredentialDescriptor> exclude_credentials_in,
    const base::Optional<::device::AuthenticatorSelectionCriteria>& authenticator_selection_in,
    ::device::AttestationConveyancePreference attestation_in,
    CableRegistrationPtr cable_registration_data_in,
    bool hmac_create_secret_in,
    bool prf_enable_in,
    ProtectionPolicy protection_policy_in,
    bool enforce_protection_policy_in,
    const base::Optional<std::string>& appid_exclude_in,
    bool cred_props_in)
    : relying_party(std::move(relying_party_in)),
      user(std::move(user_in)),
      challenge(std::move(challenge_in)),
      public_key_parameters(std::move(public_key_parameters_in)),
      timeout(std::move(timeout_in)),
      exclude_credentials(std::move(exclude_credentials_in)),
      authenticator_selection(std::move(authenticator_selection_in)),
      attestation(std::move(attestation_in)),
      cable_registration_data(std::move(cable_registration_data_in)),
      hmac_create_secret(std::move(hmac_create_secret_in)),
      prf_enable(std::move(prf_enable_in)),
      protection_policy(std::move(protection_policy_in)),
      enforce_protection_policy(std::move(enforce_protection_policy_in)),
      appid_exclude(std::move(appid_exclude_in)),
      cred_props(std::move(cred_props_in)) {}

PublicKeyCredentialCreationOptions::~PublicKeyCredentialCreationOptions() = default;

void PublicKeyCredentialCreationOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("relying_party", base::trace_event::ValueToString(this->relying_party, "<value of type const ::device::PublicKeyCredentialRpEntity&>"));
  value->SetString("user", base::trace_event::ValueToString(this->user, "<value of type const ::device::PublicKeyCredentialUserEntity&>"));
  value->BeginArray("challenge");
  for (const auto& item0 : this->challenge) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->BeginArray("public_key_parameters");
  for (const auto& item0 : this->public_key_parameters) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::device::PublicKeyCredentialParams::CredentialInfo&>"));
  }
  value->EndArray();
  value->SetString("timeout", base::trace_event::ValueToString(this->timeout, "<value of type base::Optional<::base::TimeDelta>>"));
  value->BeginArray("exclude_credentials");
  for (const auto& item0 : this->exclude_credentials) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::device::PublicKeyCredentialDescriptor&>"));
  }
  value->EndArray();
  value->SetString("authenticator_selection", base::trace_event::ValueToString(this->authenticator_selection, "<value of type const base::Optional<::device::AuthenticatorSelectionCriteria>&>"));
  value->SetInteger("attestation", static_cast<int>(this->attestation));
  if (this->cable_registration_data.is_null()) {
    value->SetString("cable_registration_data", "nullptr");
  } else {
    value->BeginDictionary("cable_registration_data");
    this->cable_registration_data->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("hmac_create_secret", this->hmac_create_secret);
  value->SetBoolean("prf_enable", this->prf_enable);
  value->SetString("protection_policy", base::trace_event::ValueToString(this->protection_policy));
  value->SetBoolean("enforce_protection_policy", this->enforce_protection_policy);
  if (this->appid_exclude.has_value()) {
    value->SetString("appid_exclude", this->appid_exclude.value());
  } else {
    value->SetString("appid_exclude", "base::nullopt");
  }
  value->SetBoolean("cred_props", this->cred_props);
}

bool PublicKeyCredentialCreationOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialDescriptor::PublicKeyCredentialDescriptor()
    : type(),
      id(),
      transports() {}

PublicKeyCredentialDescriptor::PublicKeyCredentialDescriptor(
    ::device::CredentialType type_in,
    std::vector<uint8_t> id_in,
    std::vector<::device::FidoTransportProtocol> transports_in)
    : type(std::move(type_in)),
      id(std::move(id_in)),
      transports(std::move(transports_in)) {}

PublicKeyCredentialDescriptor::~PublicKeyCredentialDescriptor() = default;

void PublicKeyCredentialDescriptor::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("type", static_cast<int>(this->type));
  value->BeginArray("id");
  for (const auto& item0 : this->id) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->BeginArray("transports");
  for (const auto& item0 : this->transports) {
    value->AppendInteger(static_cast<int>(item0));
  }
  value->EndArray();
}

bool PublicKeyCredentialDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char Authenticator::Name_[] = "blink.mojom.Authenticator";

class Authenticator_MakeCredential_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Authenticator_MakeCredential_ForwardToCallback(
      Authenticator::MakeCredentialCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Authenticator::MakeCredentialCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Authenticator_MakeCredential_ForwardToCallback);
};

class Authenticator_GetAssertion_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Authenticator_GetAssertion_ForwardToCallback(
      Authenticator::GetAssertionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Authenticator::GetAssertionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Authenticator_GetAssertion_ForwardToCallback);
};

class Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback(
      Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback);
};

AuthenticatorProxy::AuthenticatorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AuthenticatorProxy::MakeCredential(
    PublicKeyCredentialCreationOptionsPtr in_options, MakeCredentialCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Authenticator::MakeCredential", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_options.is_null()) {
        raw_value->SetString("options", "nullptr");
      } else {
        raw_value->BeginDictionary("options");
        in_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAuthenticator_MakeCredential_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Authenticator_MakeCredential_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->options)::BaseType::BufferWriter
      options_writer;
  mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialCreationOptionsDataView>(
      in_options, buffer, &options_writer, &serialization_context);
  params->options.Set(
      options_writer.is_null() ? nullptr : options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in Authenticator.MakeCredential request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("MakeCredential");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Authenticator_MakeCredential_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AuthenticatorProxy::GetAssertion(
    PublicKeyCredentialRequestOptionsPtr in_options, GetAssertionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Authenticator::GetAssertion", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_options.is_null()) {
        raw_value->SetString("options", "nullptr");
      } else {
        raw_value->BeginDictionary("options");
        in_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAuthenticator_GetAssertion_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Authenticator_GetAssertion_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->options)::BaseType::BufferWriter
      options_writer;
  mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialRequestOptionsDataView>(
      in_options, buffer, &options_writer, &serialization_context);
  params->options.Set(
      options_writer.is_null() ? nullptr : options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in Authenticator.GetAssertion request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("GetAssertion");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Authenticator_GetAssertion_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AuthenticatorProxy::IsUserVerifyingPlatformAuthenticatorAvailable(
    IsUserVerifyingPlatformAuthenticatorAvailableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("IsUserVerifyingPlatformAuthenticatorAvailable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AuthenticatorProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::Authenticator::Cancel");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAuthenticator_Cancel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Authenticator_Cancel_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class Authenticator_MakeCredential_ProxyToResponder {
 public:
  static Authenticator::MakeCredentialCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Authenticator_MakeCredential_ProxyToResponder> proxy(
        new Authenticator_MakeCredential_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Authenticator_MakeCredential_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Authenticator_MakeCredential_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Authenticator_MakeCredential_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Authenticator::MakeCredentialCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      AuthenticatorStatus in_status, MakeCredentialAuthenticatorResponsePtr in_credential);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Authenticator_MakeCredential_ProxyToResponder);
};

bool Authenticator_MakeCredential_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Authenticator::MakeCredentialCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::Authenticator_MakeCredential_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Authenticator_MakeCredential_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  AuthenticatorStatus p_status{};
  MakeCredentialAuthenticatorResponsePtr p_credential{};
  Authenticator_MakeCredential_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadCredential(&p_credential))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Authenticator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_credential));
  return true;
}

void Authenticator_MakeCredential_ProxyToResponder::Run(
    AuthenticatorStatus in_status, MakeCredentialAuthenticatorResponsePtr in_credential) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::Authenticator::MakeCredentialCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      if (in_credential.is_null()) {
        raw_value->SetString("credential", "nullptr");
      } else {
        raw_value->BeginDictionary("credential");
        in_credential->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAuthenticator_MakeCredential_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Authenticator_MakeCredential_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::AuthenticatorStatus>(
      in_status, &params->status);
  typename decltype(params->credential)::BaseType::BufferWriter
      credential_writer;
  mojo::internal::Serialize<::blink::mojom::MakeCredentialAuthenticatorResponseDataView>(
      in_credential, buffer, &credential_writer, &serialization_context);
  params->credential.Set(
      credential_writer.is_null() ? nullptr : credential_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Authenticator::MakeCredentialCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("MakeCredential");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Authenticator_GetAssertion_ProxyToResponder {
 public:
  static Authenticator::GetAssertionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Authenticator_GetAssertion_ProxyToResponder> proxy(
        new Authenticator_GetAssertion_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Authenticator_GetAssertion_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Authenticator_GetAssertion_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Authenticator_GetAssertion_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Authenticator::GetAssertionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      AuthenticatorStatus in_status, GetAssertionAuthenticatorResponsePtr in_credential);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Authenticator_GetAssertion_ProxyToResponder);
};

bool Authenticator_GetAssertion_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Authenticator::GetAssertionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::Authenticator_GetAssertion_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Authenticator_GetAssertion_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  AuthenticatorStatus p_status{};
  GetAssertionAuthenticatorResponsePtr p_credential{};
  Authenticator_GetAssertion_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadCredential(&p_credential))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Authenticator::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_credential));
  return true;
}

void Authenticator_GetAssertion_ProxyToResponder::Run(
    AuthenticatorStatus in_status, GetAssertionAuthenticatorResponsePtr in_credential) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::Authenticator::GetAssertionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      if (in_credential.is_null()) {
        raw_value->SetString("credential", "nullptr");
      } else {
        raw_value->BeginDictionary("credential");
        in_credential->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAuthenticator_GetAssertion_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Authenticator_GetAssertion_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::AuthenticatorStatus>(
      in_status, &params->status);
  typename decltype(params->credential)::BaseType::BufferWriter
      credential_writer;
  mojo::internal::Serialize<::blink::mojom::GetAssertionAuthenticatorResponseDataView>(
      in_credential, buffer, &credential_writer, &serialization_context);
  params->credential.Set(
      credential_writer.is_null() ? nullptr : credential_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Authenticator::GetAssertionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("GetAssertion");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder {
 public:
  static Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder> proxy(
        new Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_available);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder);
};

bool Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_available{};
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_available = input_data_view.available();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Authenticator::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_available));
  return true;
}

void Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder::Run(
    bool in_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("available", in_available);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->available = in_available;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("IsUserVerifyingPlatformAuthenticatorAvailable");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AuthenticatorStubDispatch::Accept(
    Authenticator* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kAuthenticator_MakeCredential_Name: {
      break;
    }
    case internal::kAuthenticator_GetAssertion_Name: {
      break;
    }
    case internal::kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name: {
      break;
    }
    case internal::kAuthenticator_Cancel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Authenticator::Cancel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Authenticator::Cancel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Authenticator_Cancel_Params_Data* params =
          reinterpret_cast<internal::Authenticator_Cancel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Authenticator_Cancel_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel();
      return true;
    }
  }
  return false;
}

// static
bool AuthenticatorStubDispatch::AcceptWithResponder(
    Authenticator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAuthenticator_MakeCredential_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Authenticator::MakeCredential",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Authenticator::MakeCredential");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Authenticator_MakeCredential_Params_Data* params =
          reinterpret_cast<
              internal::Authenticator_MakeCredential_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PublicKeyCredentialCreationOptionsPtr p_options{};
      Authenticator_MakeCredential_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 0, false);
        return false;
      }
      Authenticator::MakeCredentialCallback callback =
          Authenticator_MakeCredential_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeCredential(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kAuthenticator_GetAssertion_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Authenticator::GetAssertion",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Authenticator::GetAssertion");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Authenticator_GetAssertion_Params_Data* params =
          reinterpret_cast<
              internal::Authenticator_GetAssertion_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PublicKeyCredentialRequestOptionsPtr p_options{};
      Authenticator_GetAssertion_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 1, false);
        return false;
      }
      Authenticator::GetAssertionCallback callback =
          Authenticator_GetAssertion_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAssertion(
std::move(p_options), std::move(callback));
      return true;
    }
    case internal::kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data* params =
          reinterpret_cast<
              internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 2, false);
        return false;
      }
      Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback callback =
          Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsUserVerifyingPlatformAuthenticatorAvailable(std::move(callback));
      return true;
    }
    case internal::kAuthenticator_Cancel_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kAuthenticatorValidationInfo[] = {
    {&internal::Authenticator_MakeCredential_Params_Data::Validate,
     &internal::Authenticator_MakeCredential_ResponseParams_Data::Validate},
    {&internal::Authenticator_GetAssertion_Params_Data::Validate,
     &internal::Authenticator_GetAssertion_ResponseParams_Data::Validate},
    {&internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data::Validate,
     &internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data::Validate},
    {&internal::Authenticator_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool AuthenticatorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::Authenticator::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAuthenticatorValidationInfo);
}

bool AuthenticatorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::Authenticator::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kAuthenticatorValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::CommonCredentialInfo::DataView, ::blink::mojom::CommonCredentialInfoPtr>::Read(
    ::blink::mojom::CommonCredentialInfo::DataView input,
    ::blink::mojom::CommonCredentialInfoPtr* output) {
  bool success = true;
  ::blink::mojom::CommonCredentialInfoPtr result(::blink::mojom::CommonCredentialInfo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadRawId(&result->raw_id))
        success = false;
      if (success && !input.ReadClientDataJson(&result->client_data_json))
        success = false;
      if (success && !input.ReadAuthenticatorData(&result->authenticator_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::MakeCredentialAuthenticatorResponse::DataView, ::blink::mojom::MakeCredentialAuthenticatorResponsePtr>::Read(
    ::blink::mojom::MakeCredentialAuthenticatorResponse::DataView input,
    ::blink::mojom::MakeCredentialAuthenticatorResponsePtr* output) {
  bool success = true;
  ::blink::mojom::MakeCredentialAuthenticatorResponsePtr result(::blink::mojom::MakeCredentialAuthenticatorResponse::New());
  
      if (success && !input.ReadInfo(&result->info))
        success = false;
      if (success && !input.ReadAttestationObject(&result->attestation_object))
        success = false;
      if (success && !input.ReadTransports(&result->transports))
        success = false;
      if (success)
        result->echo_hmac_create_secret = input.echo_hmac_create_secret();
      if (success)
        result->hmac_create_secret = input.hmac_create_secret();
      if (success)
        result->echo_prf = input.echo_prf();
      if (success)
        result->prf = input.prf();
      if (success && !input.ReadPublicKeyDer(&result->public_key_der))
        success = false;
      if (success)
        result->public_key_algo = input.public_key_algo();
      if (success)
        result->echo_cred_props = input.echo_cred_props();
      if (success)
        result->has_cred_props_rk = input.has_cred_props_rk();
      if (success)
        result->cred_props_rk = input.cred_props_rk();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::GetAssertionAuthenticatorResponse::DataView, ::blink::mojom::GetAssertionAuthenticatorResponsePtr>::Read(
    ::blink::mojom::GetAssertionAuthenticatorResponse::DataView input,
    ::blink::mojom::GetAssertionAuthenticatorResponsePtr* output) {
  bool success = true;
  ::blink::mojom::GetAssertionAuthenticatorResponsePtr result(::blink::mojom::GetAssertionAuthenticatorResponse::New());
  
      if (success && !input.ReadInfo(&result->info))
        success = false;
      if (success && !input.ReadSignature(&result->signature))
        success = false;
      if (success && !input.ReadUserHandle(&result->user_handle))
        success = false;
      if (success)
        result->echo_appid_extension = input.echo_appid_extension();
      if (success)
        result->appid_extension = input.appid_extension();
      if (success)
        result->echo_prf = input.echo_prf();
      if (success && !input.ReadPrfResults(&result->prf_results))
        success = false;
      if (success)
        result->prf_not_evaluated = input.prf_not_evaluated();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PublicKeyCredentialRpEntity::DataView, ::blink::mojom::PublicKeyCredentialRpEntityPtr>::Read(
    ::blink::mojom::PublicKeyCredentialRpEntity::DataView input,
    ::blink::mojom::PublicKeyCredentialRpEntityPtr* output) {
  bool success = true;
  ::blink::mojom::PublicKeyCredentialRpEntityPtr result(::blink::mojom::PublicKeyCredentialRpEntity::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PublicKeyCredentialUserEntity::DataView, ::blink::mojom::PublicKeyCredentialUserEntityPtr>::Read(
    ::blink::mojom::PublicKeyCredentialUserEntity::DataView input,
    ::blink::mojom::PublicKeyCredentialUserEntityPtr* output) {
  bool success = true;
  ::blink::mojom::PublicKeyCredentialUserEntityPtr result(::blink::mojom::PublicKeyCredentialUserEntity::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PublicKeyCredentialParameters::DataView, ::blink::mojom::PublicKeyCredentialParametersPtr>::Read(
    ::blink::mojom::PublicKeyCredentialParameters::DataView input,
    ::blink::mojom::PublicKeyCredentialParametersPtr* output) {
  bool success = true;
  ::blink::mojom::PublicKeyCredentialParametersPtr result(::blink::mojom::PublicKeyCredentialParameters::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->algorithm_identifier = input.algorithm_identifier();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::CableAuthentication::DataView, ::blink::mojom::CableAuthenticationPtr>::Read(
    ::blink::mojom::CableAuthentication::DataView input,
    ::blink::mojom::CableAuthenticationPtr* output) {
  bool success = true;
  ::blink::mojom::CableAuthenticationPtr result(::blink::mojom::CableAuthentication::New());
  
      if (success)
        result->version = input.version();
      if (success && !input.ReadClientEid(&result->client_eid))
        success = false;
      if (success && !input.ReadAuthenticatorEid(&result->authenticator_eid))
        success = false;
      if (success && !input.ReadSessionPreKey(&result->session_pre_key))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::CableRegistration::DataView, ::blink::mojom::CableRegistrationPtr>::Read(
    ::blink::mojom::CableRegistration::DataView input,
    ::blink::mojom::CableRegistrationPtr* output) {
  bool success = true;
  ::blink::mojom::CableRegistrationPtr result(::blink::mojom::CableRegistration::New());
  
      if (success && !input.ReadVersions(&result->versions))
        success = false;
      if (success && !input.ReadRelyingPartyPublicKey(&result->relying_party_public_key))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PRFValues::DataView, ::blink::mojom::PRFValuesPtr>::Read(
    ::blink::mojom::PRFValues::DataView input,
    ::blink::mojom::PRFValuesPtr* output) {
  bool success = true;
  ::blink::mojom::PRFValuesPtr result(::blink::mojom::PRFValues::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadFirst(&result->first))
        success = false;
      if (success && !input.ReadSecond(&result->second))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PublicKeyCredentialRequestOptions::DataView, ::blink::mojom::PublicKeyCredentialRequestOptionsPtr>::Read(
    ::blink::mojom::PublicKeyCredentialRequestOptions::DataView input,
    ::blink::mojom::PublicKeyCredentialRequestOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::PublicKeyCredentialRequestOptionsPtr result(::blink::mojom::PublicKeyCredentialRequestOptions::New());
  
      if (success && !input.ReadChallenge(&result->challenge))
        success = false;
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
      if (success && !input.ReadRelyingPartyId(&result->relying_party_id))
        success = false;
      if (success && !input.ReadAllowCredentials(&result->allow_credentials))
        success = false;
      if (success && !input.ReadUserVerification(&result->user_verification))
        success = false;
      if (success && !input.ReadAppid(&result->appid))
        success = false;
      if (success && !input.ReadCableAuthenticationData(&result->cable_authentication_data))
        success = false;
      if (success)
        result->prf = input.prf();
      if (success && !input.ReadPrfInputs(&result->prf_inputs))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AuthenticatorSelectionCriteria::DataView, ::blink::mojom::AuthenticatorSelectionCriteriaPtr>::Read(
    ::blink::mojom::AuthenticatorSelectionCriteria::DataView input,
    ::blink::mojom::AuthenticatorSelectionCriteriaPtr* output) {
  bool success = true;
  ::blink::mojom::AuthenticatorSelectionCriteriaPtr result(::blink::mojom::AuthenticatorSelectionCriteria::New());
  
      if (success && !input.ReadAuthenticatorAttachment(&result->authenticator_attachment))
        success = false;
      if (success && !input.ReadResidentKey(&result->resident_key))
        success = false;
      if (success && !input.ReadUserVerification(&result->user_verification))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PublicKeyCredentialCreationOptions::DataView, ::blink::mojom::PublicKeyCredentialCreationOptionsPtr>::Read(
    ::blink::mojom::PublicKeyCredentialCreationOptions::DataView input,
    ::blink::mojom::PublicKeyCredentialCreationOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::PublicKeyCredentialCreationOptionsPtr result(::blink::mojom::PublicKeyCredentialCreationOptions::New());
  
      if (success && !input.ReadRelyingParty(&result->relying_party))
        success = false;
      if (success && !input.ReadUser(&result->user))
        success = false;
      if (success && !input.ReadChallenge(&result->challenge))
        success = false;
      if (success && !input.ReadPublicKeyParameters(&result->public_key_parameters))
        success = false;
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
      if (success && !input.ReadExcludeCredentials(&result->exclude_credentials))
        success = false;
      if (success && !input.ReadAuthenticatorSelection(&result->authenticator_selection))
        success = false;
      if (success && !input.ReadAttestation(&result->attestation))
        success = false;
      if (success && !input.ReadCableRegistrationData(&result->cable_registration_data))
        success = false;
      if (success)
        result->hmac_create_secret = input.hmac_create_secret();
      if (success)
        result->prf_enable = input.prf_enable();
      if (success && !input.ReadProtectionPolicy(&result->protection_policy))
        success = false;
      if (success)
        result->enforce_protection_policy = input.enforce_protection_policy();
      if (success && !input.ReadAppidExclude(&result->appid_exclude))
        success = false;
      if (success)
        result->cred_props = input.cred_props();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PublicKeyCredentialDescriptor::DataView, ::blink::mojom::PublicKeyCredentialDescriptorPtr>::Read(
    ::blink::mojom::PublicKeyCredentialDescriptor::DataView input,
    ::blink::mojom::PublicKeyCredentialDescriptorPtr* output) {
  bool success = true;
  ::blink::mojom::PublicKeyCredentialDescriptorPtr result(::blink::mojom::PublicKeyCredentialDescriptor::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadTransports(&result->transports))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif