/* key.c generated by valac 0.56.1, the Vala compiler
 * generated from key.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2005 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2016 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-ssh.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "seahorse-common.h"
#include <glib/gi18n-lib.h>
#include <gcr/gcr-base.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gstdio.h>

enum  {
	SEAHORSE_SSH_KEY_0_PROPERTY,
	SEAHORSE_SSH_KEY_KEY_DATA_PROPERTY,
	SEAHORSE_SSH_KEY_FINGERPRINT_PROPERTY,
	SEAHORSE_SSH_KEY_PUBKEY_PROPERTY,
	SEAHORSE_SSH_KEY_DESCRIPTION_PROPERTY,
	SEAHORSE_SSH_KEY_VALIDITY_PROPERTY,
	SEAHORSE_SSH_KEY_TRUST_PROPERTY,
	SEAHORSE_SSH_KEY_EXPIRES_PROPERTY,
	SEAHORSE_SSH_KEY_LENGTH_PROPERTY,
	SEAHORSE_SSH_KEY_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_key_properties[SEAHORSE_SSH_KEY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _SeahorseSshKeyParseData SeahorseSshKeyParseData;
typedef struct _SeahorseSshKeyParseFileData SeahorseSshKeyParseFileData;

struct _SeahorseSshKeyPrivate {
	SeahorseSshKeyData* _keydata;
};

struct _SeahorseSshKeyParseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* data;
	SeahorseSshKeyPubParsedHandler pub_handler;
	gpointer pub_handler_target;
	SeahorseSshKeyPrivParsedHandler priv_handler;
	gpointer priv_handler_target;
	GCancellable* cancellable;
	gboolean _tmp0_;
	GString* toParse;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	SeahorseSshSecData* secdata;
	GString* _tmp11_;
	SeahorseSshSecData* _tmp12_;
	SeahorseSshSecData* _tmp13_;
	GError* e;
	GError* _tmp14_;
	const gchar* _tmp15_;
	gchar** lines;
	GString* _tmp16_;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint lines_length1;
	gint _lines_size_;
	gchar* line;
	gchar** _tmp20_;
	gint _tmp20__length1;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	GString* _tmp23_;
	const gchar* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	GString* _tmp28_;
	gboolean _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gboolean _tmp33_;
	const gchar* _tmp34_;
	SeahorseSshKeyData* keydata;
	const gchar* _tmp35_;
	SeahorseSshKeyData* _tmp36_;
	SeahorseSshKeyData* _tmp37_;
	GError* _vala1_e;
	GError* _tmp38_;
	const gchar* _tmp39_;
	GError* _inner_error0_;
};

struct _SeahorseSshKeyParseFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* filename;
	SeahorseSshKeyPubParsedHandler pub_handler;
	gpointer pub_handler_target;
	SeahorseSshKeyPrivParsedHandler priv_handler;
	gpointer priv_handler_target;
	GCancellable* cancellable;
	gchar* contents;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_;
};

static gint SeahorseSshKey_private_offset;
static gpointer seahorse_ssh_key_parent_class = NULL;
static SeahorseExportableIface * seahorse_ssh_key_seahorse_exportable_parent_iface = NULL;
static SeahorseDeletableIface * seahorse_ssh_key_seahorse_deletable_parent_iface = NULL;
static SeahorseViewableIface * seahorse_ssh_key_seahorse_viewable_parent_iface = NULL;

static gchar* seahorse_ssh_key_parse_first_word (SeahorseSshKey* self,
                                          const gchar* line);
static void seahorse_ssh_key_changed_key (SeahorseSshKey* self);
static GList* seahorse_ssh_key_real_create_exporters (SeahorseExportable* base,
                                               SeahorseExporterType type);
static SeahorseDeleter* seahorse_ssh_key_real_create_deleter (SeahorseDeletable* base);
static GtkWindow* seahorse_ssh_key_real_create_viewer (SeahorseViewable* base,
                                                GtkWindow* parent);
static void seahorse_ssh_key_parse_data_free (gpointer _data);
static gboolean seahorse_ssh_key_parse_co (SeahorseSshKeyParseData* _data_);
static void seahorse_ssh_key_parse_file_data_free (gpointer _data);
static gboolean seahorse_ssh_key_parse_file_co (SeahorseSshKeyParseFileData* _data_);
static void seahorse_ssh_key_parse_file_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void seahorse_ssh_key_finalize (GObject * obj);
static GType seahorse_ssh_key_get_type_once (void);
static void _vala_seahorse_ssh_key_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_seahorse_ssh_key_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_ssh_key_get_instance_private (SeahorseSshKey* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshKey_private_offset);
}

SeahorseSshKey*
seahorse_ssh_key_construct (GType object_type,
                            SeahorseSshSource* source,
                            SeahorseSshKeyData* key_data)
{
	SeahorseSshKey * self = NULL;
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (key_data != NULL, NULL);
	self = (SeahorseSshKey*) g_object_new (object_type, "place", source, "key-data", key_data, NULL);
	return self;
}

SeahorseSshKey*
seahorse_ssh_key_new (SeahorseSshSource* source,
                      SeahorseSshKeyData* key_data)
{
	return seahorse_ssh_key_construct (SEAHORSE_SSH_TYPE_KEY, source, key_data);
}

static gchar*
seahorse_ssh_key_parse_first_word (SeahorseSshKey* self,
                                   const gchar* line)
{
	gchar* PARSE_CHARS = NULL;
	gchar* _tmp0_;
	gchar** words = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint words_length1;
	gint _words_size_;
	const gchar* _tmp4_ = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = g_strdup ("\t \n@;,.\\?()[]{}+/");
	PARSE_CHARS = _tmp0_;
	_tmp1_ = PARSE_CHARS;
	_tmp3_ = _tmp2_ = g_strsplit_set (line, _tmp1_, 2);
	words = _tmp3_;
	words_length1 = _vala_array_length (_tmp2_);
	_words_size_ = words_length1;
	_tmp5_ = words;
	_tmp5__length1 = words_length1;
	if (_tmp5__length1 == 2) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		_tmp6_ = words;
		_tmp6__length1 = words_length1;
		_tmp7_ = _tmp6_[0];
		_tmp4_ = _tmp7_;
	} else {
		_tmp4_ = NULL;
	}
	_tmp8_ = g_strdup (_tmp4_);
	result = _tmp8_;
	words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (PARSE_CHARS);
	return result;
}

static void
seahorse_ssh_key_changed_key (SeahorseSshKey* self)
{
	gboolean _tmp0_ = FALSE;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	SeahorseSshKeyData* _tmp7_;
	SeahorseSshKeyData* _tmp8_;
	SeahorseSshKeyData* _tmp32_;
	SeahorseSshKeyData* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	SeahorseSshKeyData* _tmp38_;
	SeahorseSshKeyData* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp48_ = NULL;
	SeahorseSshKeyData* _tmp49_;
	SeahorseSshKeyData* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* filename = NULL;
	gchar* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	SeahorseSshKeyData* _tmp63_;
	SeahorseSshKeyData* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	g_return_if_fail (self != NULL);
	_tmp1_ = seahorse_ssh_key_get_key_data (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		SeahorseSshKeyData* _tmp3_;
		SeahorseSshKeyData* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = seahorse_ssh_key_get_key_data (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = seahorse_ssh_key_data_get_fingerprint (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == NULL;
	}
	if (_tmp0_) {
		seahorse_object_set_label ((SeahorseObject*) self, "");
		seahorse_object_set_icon ((SeahorseObject*) self, NULL);
		seahorse_object_set_usage ((SeahorseObject*) self, SEAHORSE_USAGE_NONE);
		seahorse_object_set_nickname ((SeahorseObject*) self, "");
		seahorse_object_set_object_flags ((SeahorseObject*) self, SEAHORSE_FLAG_DISABLED);
		return;
	}
	_tmp7_ = seahorse_ssh_key_get_key_data (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		SeahorseSshKeyData* _tmp9_;
		SeahorseSshKeyData* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp9_ = seahorse_ssh_key_get_key_data (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = seahorse_ssh_key_data_get_comment (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			SeahorseSshKeyData* _tmp13_;
			SeahorseSshKeyData* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			SeahorseSshKeyData* _tmp17_;
			SeahorseSshKeyData* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp13_ = seahorse_ssh_key_get_key_data (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = seahorse_ssh_key_data_get_comment (_tmp14_);
			_tmp16_ = _tmp15_;
			seahorse_object_set_label ((SeahorseObject*) self, _tmp16_);
			_tmp17_ = seahorse_ssh_key_get_key_data (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = seahorse_ssh_key_data_get_comment (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = seahorse_ssh_key_parse_first_word (self, _tmp20_);
			_tmp22_ = _tmp21_;
			seahorse_object_set_nickname ((SeahorseObject*) self, _tmp22_);
			_g_free0 (_tmp22_);
		} else {
			SeahorseSshKeyData* _tmp23_;
			SeahorseSshKeyData* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			_tmp23_ = seahorse_ssh_key_get_key_data (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = seahorse_ssh_key_data_get_fingerprint (_tmp24_);
			_tmp26_ = _tmp25_;
			if (_tmp26_ == NULL) {
				seahorse_object_set_label ((SeahorseObject*) self, _ ("(Unreadable Secure Shell Key)"));
			} else {
				seahorse_object_set_label ((SeahorseObject*) self, _ ("Secure Shell Key"));
			}
		}
		_tmp28_ = seahorse_object_get_nickname ((SeahorseObject*) self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			_tmp27_ = TRUE;
		} else {
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			_tmp30_ = seahorse_object_get_nickname ((SeahorseObject*) self);
			_tmp31_ = _tmp30_;
			_tmp27_ = g_strcmp0 (_tmp31_, "") == 0;
		}
		if (_tmp27_) {
			seahorse_object_set_nickname ((SeahorseObject*) self, _ ("Secure Shell Key"));
		}
	}
	seahorse_object_set_object_flags ((SeahorseObject*) self, SEAHORSE_FLAG_EXPORTABLE | SEAHORSE_FLAG_DELETABLE);
	_tmp32_ = seahorse_ssh_key_get_key_data (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = seahorse_ssh_key_data_get_authorized (_tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_) {
		SeahorseFlags _tmp36_;
		SeahorseFlags _tmp37_;
		_tmp36_ = seahorse_object_get_object_flags ((SeahorseObject*) self);
		_tmp37_ = _tmp36_;
		seahorse_object_set_object_flags ((SeahorseObject*) self, _tmp37_ | SEAHORSE_FLAG_TRUSTED);
	}
	_tmp38_ = seahorse_ssh_key_get_key_data (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = seahorse_ssh_key_data_get_privfile (_tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_ != NULL) {
		SeahorseFlags _tmp42_;
		SeahorseFlags _tmp43_;
		GThemedIcon* _tmp44_;
		GThemedIcon* _tmp45_;
		seahorse_object_set_usage ((SeahorseObject*) self, SEAHORSE_USAGE_PRIVATE_KEY);
		_tmp42_ = seahorse_object_get_object_flags ((SeahorseObject*) self);
		_tmp43_ = _tmp42_;
		seahorse_object_set_object_flags ((SeahorseObject*) self, _tmp43_ | (SEAHORSE_FLAG_PERSONAL | SEAHORSE_FLAG_TRUSTED));
		_tmp44_ = (GThemedIcon*) g_themed_icon_new (GCR_ICON_KEY_PAIR);
		_tmp45_ = _tmp44_;
		seahorse_object_set_icon ((SeahorseObject*) self, (GIcon*) _tmp45_);
		_g_object_unref0 (_tmp45_);
	} else {
		GThemedIcon* _tmp46_;
		GThemedIcon* _tmp47_;
		seahorse_object_set_object_flags ((SeahorseObject*) self, 0);
		seahorse_object_set_usage ((SeahorseObject*) self, SEAHORSE_USAGE_PUBLIC_KEY);
		_tmp46_ = (GThemedIcon*) g_themed_icon_new (GCR_ICON_KEY);
		_tmp47_ = _tmp46_;
		seahorse_object_set_icon ((SeahorseObject*) self, (GIcon*) _tmp47_);
		_g_object_unref0 (_tmp47_);
	}
	_tmp49_ = seahorse_ssh_key_get_key_data (self);
	_tmp50_ = _tmp49_;
	_tmp51_ = seahorse_ssh_key_data_get_privfile (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp48_ = _tmp52_;
	if (_tmp48_ == NULL) {
		SeahorseSshKeyData* _tmp53_;
		SeahorseSshKeyData* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		_tmp53_ = seahorse_ssh_key_get_key_data (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = seahorse_ssh_key_data_get_pubfile (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp48_ = _tmp56_;
	}
	_tmp57_ = g_path_get_basename (_tmp48_);
	filename = _tmp57_;
	_tmp58_ = seahorse_object_get_label ((SeahorseObject*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = filename;
	_tmp61_ = g_markup_printf_escaped ("%s<span size='small' rise='0' foreground='#555555'>\n%s</span>", _tmp59_, _tmp60_);
	_tmp62_ = _tmp61_;
	seahorse_object_set_markup ((SeahorseObject*) self, _tmp62_);
	_g_free0 (_tmp62_);
	_tmp63_ = seahorse_ssh_key_get_key_data (self);
	_tmp64_ = _tmp63_;
	_tmp65_ = seahorse_ssh_key_data_get_fingerprint (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = seahorse_ssh_key_calc_identifier (_tmp66_);
	_tmp68_ = _tmp67_;
	seahorse_object_set_identifier ((SeahorseObject*) self, _tmp68_);
	_g_free0 (_tmp68_);
	_g_free0 (filename);
}

void
seahorse_ssh_key_refresh (SeahorseSshKey* self)
{
	g_return_if_fail (self != NULL);
}

static GList*
seahorse_ssh_key_real_create_exporters (SeahorseExportable* base,
                                        SeahorseExporterType type)
{
	SeahorseSshKey * self;
	GList* exporters = NULL;
	SeahorseSshExporter* _tmp0_;
	GList* result;
	self = (SeahorseSshKey*) base;
	exporters = NULL;
	_tmp0_ = seahorse_ssh_exporter_new (self, FALSE);
	exporters = g_list_append (exporters, (SeahorseExporter*) _tmp0_);
	result = exporters;
	return result;
}

static SeahorseDeleter*
seahorse_ssh_key_real_create_deleter (SeahorseDeletable* base)
{
	SeahorseSshKey * self;
	SeahorseSshDeleter* _tmp0_;
	SeahorseDeleter* result;
	self = (SeahorseSshKey*) base;
	_tmp0_ = seahorse_ssh_deleter_new (self);
	result = (SeahorseDeleter*) _tmp0_;
	return result;
}

static GtkWindow*
seahorse_ssh_key_real_create_viewer (SeahorseViewable* base,
                                     GtkWindow* parent)
{
	SeahorseSshKey * self;
	SeahorseSshKeyProperties* properties_dialog = NULL;
	SeahorseSshKeyProperties* _tmp0_;
	GtkWindow* result;
	self = (SeahorseSshKey*) base;
	_tmp0_ = seahorse_ssh_key_properties_new (self, parent);
	g_object_ref_sink (_tmp0_);
	properties_dialog = _tmp0_;
	gtk_widget_show ((GtkWidget*) properties_dialog);
	result = (GtkWindow*) properties_dialog;
	return result;
}

SeahorseSshAlgorithm
seahorse_ssh_key_get_algo (SeahorseSshKey* self)
{
	SeahorseSshKeyData* _tmp0_;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshAlgorithm _tmp2_;
	SeahorseSshAlgorithm _tmp3_;
	SeahorseSshAlgorithm result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = seahorse_ssh_key_get_key_data (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = seahorse_ssh_key_data_get_algo (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

gchar*
seahorse_ssh_key_get_location (SeahorseSshKey* self)
{
	SeahorseSshKeyData* _tmp0_;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	SeahorseSshKeyData* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = seahorse_ssh_key_get_key_data (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = seahorse_ssh_key_get_key_data (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = seahorse_ssh_key_data_get_location (_tmp3_);
	result = _tmp4_;
	return result;
}

guint
seahorse_ssh_key_get_strength (SeahorseSshKey* self)
{
	guint _tmp0_ = 0U;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = seahorse_ssh_key_get_key_data (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		SeahorseSshKeyData* _tmp3_;
		SeahorseSshKeyData* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		_tmp3_ = seahorse_ssh_key_get_key_data (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = seahorse_ssh_key_data_get_length (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = (guint) 0;
	}
	result = _tmp0_;
	return result;
}

/**
     * Creates a valid identifier for an SSH key from a given string.
     *
     * @return A valid identifier, or null if the result is too short.
     */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
seahorse_ssh_key_calc_identifier (const gchar* id)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (id != NULL, NULL);
	{
		GRegex* regex = NULL;
		GRegex* _tmp0_;
		gchar* _result_ = NULL;
		GRegex* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp0_ = g_regex_new ("[^a-zA-Z0-9]", 0, 0, &_inner_error0_);
		regex = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp1_ = regex;
		_tmp2_ = strlen (id);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_regex_replace (_tmp1_, id, (gssize) _tmp3_, 0, "", 0, &_inner_error0_);
		_result_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _result_;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ >= SEAHORSE_SSH_KEY_SSH_IDENTIFIER_SIZE) {
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gchar* _tmp12_;
			_tmp8_ = _result_;
			_tmp9_ = _result_;
			_tmp10_ = strlen (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = string_substring (_tmp8_, (glong) 0, (glong) _tmp11_);
			result = _tmp12_;
			_g_free0 (_result_);
			_g_regex_unref0 (regex);
			return result;
		}
		_g_free0 (_result_);
		_g_regex_unref0 (regex);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_strdup_printf ("Couldn't create regex for calc_identifier. Message: %s", _tmp14_);
		_tmp16_ = _tmp15_;
		g_warning ("key.vala:201: %s", _tmp16_);
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

/**
     * Sometimes keys loaded later on have more information (e.g. keys loaded
     * from authorized_keys), so propagate that up to the previously loaded key.
     */
void
seahorse_ssh_key_merge_keydata (SeahorseSshKey* self,
                                SeahorseSshKeyData* keydata)
{
	gboolean _tmp0_ = FALSE;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keydata != NULL);
	_tmp1_ = seahorse_ssh_key_get_key_data (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = seahorse_ssh_key_data_get_authorized (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = seahorse_ssh_key_data_get_authorized (keydata);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SeahorseSshKeyData* _tmp7_;
		SeahorseSshKeyData* _tmp8_;
		SeahorseSshKeyData* _tmp9_;
		SeahorseSshKeyData* _tmp10_;
		_tmp7_ = seahorse_ssh_key_get_key_data (self);
		_tmp8_ = _tmp7_;
		seahorse_ssh_key_data_set_authorized (_tmp8_, TRUE);
		_tmp9_ = seahorse_ssh_key_get_key_data (self);
		_tmp10_ = _tmp9_;
		seahorse_ssh_key_set_key_data (self, _tmp10_);
	}
}

static void
seahorse_ssh_key_parse_data_free (gpointer _data)
{
	SeahorseSshKeyParseData* _data_;
	_data_ = _data;
	_g_free0 (_data_->data);
	_g_object_unref0 (_data_->cancellable);
	g_slice_free (SeahorseSshKeyParseData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
seahorse_ssh_key_parse (const gchar* data,
                        SeahorseSshKeyPubParsedHandler pub_handler,
                        gpointer pub_handler_target,
                        SeahorseSshKeyPrivParsedHandler priv_handler,
                        gpointer priv_handler_target,
                        GCancellable* cancellable,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	SeahorseSshKeyParseData* _data_;
	gchar* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (data != NULL);
	_data_ = g_slice_new0 (SeahorseSshKeyParseData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_key_parse_data_free);
	_tmp0_ = g_strdup (data);
	_g_free0 (_data_->data);
	_data_->data = _tmp0_;
	_data_->pub_handler = pub_handler;
	_data_->pub_handler_target = pub_handler_target;
	_data_->priv_handler = priv_handler;
	_data_->priv_handler_target = priv_handler_target;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	seahorse_ssh_key_parse_co (_data_);
}

void
seahorse_ssh_key_parse_finish (GAsyncResult* _res_,
                               GError** error)
{
	SeahorseSshKeyParseData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Parses a string into public/private keys.
     *
     * @param data The string that needs to be parsed.
     * @param pub_handler Will be called anytime a public key has been parsed.
     *                    If null, nothing will be done if a public key is parsed.
     * @param priv_handler Will be called anytime a private key has been parsed.
     *                     If null, nothing will be done if a private key is parsed.
     * @param cancellable Can be used to cancel the parsing.
     */
static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
seahorse_ssh_key_parse_co (SeahorseSshKeyParseData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->data == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = g_strcmp0 (_data_->data, "") == 0;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = string_chug (_data_->data);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_string_new (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_free0 (_data_->_tmp2_);
	_data_->toParse = _data_->_tmp4_;
	while (TRUE) {
		_data_->_tmp5_ = _data_->toParse;
		_data_->_tmp6_ = _data_->_tmp5_->str;
		_data_->_tmp7_ = strlen (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		if (!(_data_->_tmp8_ > 0)) {
			break;
		}
		_data_->_tmp9_ = _data_->toParse;
		_data_->_tmp10_ = _data_->_tmp9_->str;
		if (seahorse_ssh_sec_data_contains_private_key (_data_->_tmp10_)) {
			{
				_data_->_tmp11_ = _data_->toParse;
				_data_->_tmp12_ = seahorse_ssh_sec_data_parse_data (_data_->_tmp11_, &_data_->_inner_error0_);
				_data_->secdata = _data_->_tmp12_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				if (_data_->priv_handler != NULL) {
					_data_->_tmp13_ = _data_->secdata;
					_data_->priv_handler (_data_->_tmp13_, _data_->priv_handler_target);
				}
				_g_object_unref0 (_data_->secdata);
				continue;
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp14_ = _data_->e;
				_data_->_tmp15_ = _data_->_tmp14_->message;
				g_warning ("key.vala:247: %s", _data_->_tmp15_);
				_g_error_free0 (_data_->e);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_string_free0 (_data_->toParse);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp16_ = _data_->toParse;
		_data_->_tmp17_ = _data_->_tmp16_->str;
		_data_->_tmp19_ = _data_->_tmp18_ = g_strsplit (_data_->_tmp17_, "\n", 2);
		_data_->lines = _data_->_tmp19_;
		_data_->lines_length1 = _vala_array_length (_data_->_tmp18_);
		_data_->_lines_size_ = _data_->lines_length1;
		_data_->_tmp20_ = _data_->lines;
		_data_->_tmp20__length1 = _data_->lines_length1;
		_data_->_tmp21_ = _data_->_tmp20_[0];
		_data_->_tmp22_ = g_strdup (_data_->_tmp21_);
		_data_->line = _data_->_tmp22_;
		_data_->_tmp23_ = _data_->toParse;
		_data_->_tmp24_ = _data_->line;
		_data_->_tmp25_ = strlen (_data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		g_string_erase (_data_->_tmp23_, (gssize) 0, (gssize) _data_->_tmp26_);
		_data_->_tmp27_ = _data_->lines;
		_data_->_tmp27__length1 = _data_->lines_length1;
		if (_data_->_tmp27__length1 == 2) {
			_data_->_tmp28_ = _data_->toParse;
			g_string_erase (_data_->_tmp28_, (gssize) 0, (gssize) 1);
		}
		_data_->_tmp30_ = _data_->line;
		_data_->_tmp31_ = string_strip (_data_->_tmp30_);
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = g_strcmp0 (_data_->_tmp32_, "") == 0;
		_g_free0 (_data_->_tmp32_);
		if (_data_->_tmp33_) {
			_data_->_tmp29_ = TRUE;
		} else {
			_data_->_tmp34_ = _data_->line;
			_data_->_tmp29_ = g_str_has_prefix (_data_->_tmp34_, "#");
		}
		if (_data_->_tmp29_) {
			_g_free0 (_data_->line);
			_data_->lines = (_vala_array_free (_data_->lines, _data_->lines_length1, (GDestroyNotify) g_free), NULL);
			continue;
		}
		{
			_data_->_tmp35_ = _data_->line;
			_data_->_tmp36_ = seahorse_ssh_key_data_parse_line (_data_->_tmp35_, &_data_->_inner_error0_);
			_data_->keydata = _data_->_tmp36_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			if (_data_->pub_handler != NULL) {
				_data_->_tmp37_ = _data_->keydata;
				_data_->pub_handler (_data_->_tmp37_, _data_->pub_handler_target);
			}
			_g_object_unref0 (_data_->keydata);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala1_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp38_ = _data_->_vala1_e;
			_data_->_tmp39_ = _data_->_tmp38_->message;
			g_warning ("key.vala:268: %s", _data_->_tmp39_);
			_g_error_free0 (_data_->_vala1_e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->line);
			_data_->lines = (_vala_array_free (_data_->lines, _data_->lines_length1, (GDestroyNotify) g_free), NULL);
			_g_string_free0 (_data_->toParse);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->line);
		_data_->lines = (_vala_array_free (_data_->lines, _data_->lines_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_string_free0 (_data_->toParse);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_ssh_key_parse_file_data_free (gpointer _data)
{
	SeahorseSshKeyParseFileData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->cancellable);
	g_slice_free (SeahorseSshKeyParseFileData, _data_);
}

void
seahorse_ssh_key_parse_file (const gchar* filename,
                             SeahorseSshKeyPubParsedHandler pub_handler,
                             gpointer pub_handler_target,
                             SeahorseSshKeyPrivParsedHandler priv_handler,
                             gpointer priv_handler_target,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	SeahorseSshKeyParseFileData* _data_;
	gchar* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (SeahorseSshKeyParseFileData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_key_parse_file_data_free);
	_tmp0_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp0_;
	_data_->pub_handler = pub_handler;
	_data_->pub_handler_target = pub_handler_target;
	_data_->priv_handler = priv_handler;
	_data_->priv_handler_target = priv_handler_target;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	seahorse_ssh_key_parse_file_co (_data_);
}

void
seahorse_ssh_key_parse_file_finish (GAsyncResult* _res_,
                                    GError** error)
{
	SeahorseSshKeyParseFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Parses the contents of the given file into public/private keys.
     *
     * @param data The file that will be parsed.
     * @param pub_handler Will be called anytime a public key has been parsed.
     *                    If null, nothing will be done if a public key is parsed.
     * @param priv_handler Will be called anytime a private key has been parsed.
     *                     If null, nothing will be done if a private key is parsed.
     * @param cancellable Can be used to cancel the parsing.
     */
static void
seahorse_ssh_key_parse_file_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	SeahorseSshKeyParseFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_ssh_key_parse_file_co (_data_);
}

static gboolean
seahorse_ssh_key_parse_file_co (SeahorseSshKeyParseFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	g_file_get_contents (_data_->filename, &_data_->_tmp0_, NULL, &_data_->_inner_error0_);
	_g_free0 (_data_->contents);
	_data_->contents = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->contents);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->contents;
	_data_->_state_ = 1;
	seahorse_ssh_key_parse (_data_->_tmp1_, _data_->pub_handler, _data_->pub_handler_target, _data_->priv_handler, _data_->priv_handler_target, _data_->cancellable, seahorse_ssh_key_parse_file_ready, _data_);
	return FALSE;
	_state_1:
	seahorse_ssh_key_parse_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->contents);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->contents);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SeahorseSshKeyData*
seahorse_ssh_key_get_key_data (SeahorseSshKey* self)
{
	SeahorseSshKeyData* result;
	SeahorseSshKeyData* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keydata;
	result = _tmp0_;
	return result;
}

void
seahorse_ssh_key_set_key_data (SeahorseSshKey* self,
                               SeahorseSshKeyData* value)
{
	SeahorseSshKeyData* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_keydata);
	self->priv->_keydata = _tmp0_;
	seahorse_ssh_key_changed_key (self);
	g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_key_properties[SEAHORSE_SSH_KEY_KEY_DATA_PROPERTY]);
}

const gchar*
seahorse_ssh_key_get_fingerprint (SeahorseSshKey* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = seahorse_ssh_key_get_key_data (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		SeahorseSshKeyData* _tmp3_;
		SeahorseSshKeyData* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = seahorse_ssh_key_get_key_data (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = seahorse_ssh_key_data_get_fingerprint (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

const gchar*
seahorse_ssh_key_get_pubkey (SeahorseSshKey* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = seahorse_ssh_key_get_key_data (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		SeahorseSshKeyData* _tmp3_;
		SeahorseSshKeyData* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = seahorse_ssh_key_get_key_data (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = seahorse_ssh_key_data_get_rawdata (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

const gchar*
seahorse_ssh_key_get_description (SeahorseSshKey* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	SeahorseUsage _tmp1_;
	SeahorseUsage _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = seahorse_object_get_usage ((SeahorseObject*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == SEAHORSE_USAGE_PRIVATE_KEY) {
		_tmp0_ = _ ("Personal SSH key");
	} else {
		_tmp0_ = _ ("SSH key");
	}
	result = _tmp0_;
	return result;
}

SeahorseValidity
seahorse_ssh_key_get_validity (SeahorseSshKey* self)
{
	SeahorseValidity result;
	gboolean _tmp0_ = FALSE;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = seahorse_ssh_key_get_key_data (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		SeahorseSshKeyData* _tmp3_;
		SeahorseSshKeyData* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = seahorse_ssh_key_get_key_data (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = seahorse_ssh_key_data_get_privfile (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = SEAHORSE_VALIDITY_ULTIMATE;
		return result;
	}
	result = 0;
	return result;
}

SeahorseValidity
seahorse_ssh_key_get_trust (SeahorseSshKey* self)
{
	SeahorseValidity result;
	SeahorseSshKeyData* _tmp0_;
	SeahorseSshKeyData* _tmp1_;
	gboolean _tmp2_ = FALSE;
	SeahorseSshKeyData* _tmp3_;
	SeahorseSshKeyData* _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = seahorse_ssh_key_get_key_data (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		g_warning ("key.vala:72: key_data is null");
	}
	_tmp3_ = seahorse_ssh_key_get_key_data (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		SeahorseSshKeyData* _tmp5_;
		SeahorseSshKeyData* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = seahorse_ssh_key_get_key_data (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = seahorse_ssh_key_data_get_authorized (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = SEAHORSE_VALIDITY_FULL;
		return result;
	}
	result = 0;
	return result;
}

gulong
seahorse_ssh_key_get_expires (SeahorseSshKey* self)
{
	gulong result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = (gulong) 0;
	return result;
}

guint
seahorse_ssh_key_get_length (SeahorseSshKey* self)
{
	guint result;
	guint _tmp0_ = 0U;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = seahorse_ssh_key_get_key_data (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		SeahorseSshKeyData* _tmp3_;
		SeahorseSshKeyData* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		_tmp3_ = seahorse_ssh_key_get_key_data (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = seahorse_ssh_key_data_get_length (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = (guint) 0;
	}
	result = _tmp0_;
	return result;
}

static void
seahorse_ssh_key_class_init (SeahorseSshKeyClass * klass,
                             gpointer klass_data)
{
	seahorse_ssh_key_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshKey_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_ssh_key_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_ssh_key_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_key_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_KEY_DATA_PROPERTY, seahorse_ssh_key_properties[SEAHORSE_SSH_KEY_KEY_DATA_PROPERTY] = g_param_spec_object ("key-data", "key-data", "key-data", SEAHORSE_SSH_TYPE_KEY_DATA, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Unique fingerprint for this key
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_FINGERPRINT_PROPERTY, seahorse_ssh_key_properties[SEAHORSE_SSH_KEY_FINGERPRINT_PROPERTY] = g_param_spec_string ("fingerprint", "fingerprint", "fingerprint", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Public data for this key
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_PUBKEY_PROPERTY, seahorse_ssh_key_properties[SEAHORSE_SSH_KEY_PUBKEY_PROPERTY] = g_param_spec_string ("pubkey", "pubkey", "pubkey", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Description
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_DESCRIPTION_PROPERTY, seahorse_ssh_key_properties[SEAHORSE_SSH_KEY_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Validity of this key
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_VALIDITY_PROPERTY, seahorse_ssh_key_properties[SEAHORSE_SSH_KEY_VALIDITY_PROPERTY] = g_param_spec_enum ("validity", "validity", "validity", SEAHORSE_TYPE_VALIDITY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Trust in this key
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_TRUST_PROPERTY, seahorse_ssh_key_properties[SEAHORSE_SSH_KEY_TRUST_PROPERTY] = g_param_spec_enum ("trust", "trust", "trust", SEAHORSE_TYPE_VALIDITY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Date this key expires on (0 if never)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_EXPIRES_PROPERTY, seahorse_ssh_key_properties[SEAHORSE_SSH_KEY_EXPIRES_PROPERTY] = g_param_spec_ulong ("expires", "expires", "expires", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The length of this key
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_KEY_LENGTH_PROPERTY, seahorse_ssh_key_properties[SEAHORSE_SSH_KEY_LENGTH_PROPERTY] = g_param_spec_uint ("length", "length", "length", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
seahorse_ssh_key_seahorse_exportable_interface_init (SeahorseExportableIface * iface,
                                                     gpointer iface_data)
{
	seahorse_ssh_key_seahorse_exportable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_exporters = (GList* (*) (SeahorseExportable*, SeahorseExporterType)) seahorse_ssh_key_real_create_exporters;
	iface->get_exportable = (gboolean (*) (SeahorseExportable *)) seahorse_object_get_exportable;
}

static void
seahorse_ssh_key_seahorse_deletable_interface_init (SeahorseDeletableIface * iface,
                                                    gpointer iface_data)
{
	seahorse_ssh_key_seahorse_deletable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_deleter = (SeahorseDeleter* (*) (SeahorseDeletable*)) seahorse_ssh_key_real_create_deleter;
	iface->get_deletable = (gboolean (*) (SeahorseDeletable *)) seahorse_object_get_deletable;
}

static void
seahorse_ssh_key_seahorse_viewable_interface_init (SeahorseViewableIface * iface,
                                                   gpointer iface_data)
{
	seahorse_ssh_key_seahorse_viewable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_viewer = (GtkWindow* (*) (SeahorseViewable*, GtkWindow*)) seahorse_ssh_key_real_create_viewer;
}

static void
seahorse_ssh_key_instance_init (SeahorseSshKey * self,
                                gpointer klass)
{
	self->priv = seahorse_ssh_key_get_instance_private (self);
}

static void
seahorse_ssh_key_finalize (GObject * obj)
{
	SeahorseSshKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_KEY, SeahorseSshKey);
	_g_object_unref0 (self->priv->_keydata);
	G_OBJECT_CLASS (seahorse_ssh_key_parent_class)->finalize (obj);
}

/**
 * Represents an SSH key, consisting of a public/private pair.
 */
 G_GNUC_NO_INLINE static GType
seahorse_ssh_key_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshKeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_key_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshKey), 0, (GInstanceInitFunc) seahorse_ssh_key_instance_init, NULL };
	static const GInterfaceInfo seahorse_exportable_info = { (GInterfaceInitFunc) seahorse_ssh_key_seahorse_exportable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_deletable_info = { (GInterfaceInitFunc) seahorse_ssh_key_seahorse_deletable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_viewable_info = { (GInterfaceInitFunc) seahorse_ssh_key_seahorse_viewable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType seahorse_ssh_key_type_id;
	seahorse_ssh_key_type_id = g_type_register_static (SEAHORSE_TYPE_OBJECT, "SeahorseSshKey", &g_define_type_info, 0);
	g_type_add_interface_static (seahorse_ssh_key_type_id, SEAHORSE_TYPE_EXPORTABLE, &seahorse_exportable_info);
	g_type_add_interface_static (seahorse_ssh_key_type_id, SEAHORSE_TYPE_DELETABLE, &seahorse_deletable_info);
	g_type_add_interface_static (seahorse_ssh_key_type_id, SEAHORSE_TYPE_VIEWABLE, &seahorse_viewable_info);
	SeahorseSshKey_private_offset = g_type_add_instance_private (seahorse_ssh_key_type_id, sizeof (SeahorseSshKeyPrivate));
	return seahorse_ssh_key_type_id;
}

GType
seahorse_ssh_key_get_type (void)
{
	static volatile gsize seahorse_ssh_key_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_key_type_id__once)) {
		GType seahorse_ssh_key_type_id;
		seahorse_ssh_key_type_id = seahorse_ssh_key_get_type_once ();
		g_once_init_leave (&seahorse_ssh_key_type_id__once, seahorse_ssh_key_type_id);
	}
	return seahorse_ssh_key_type_id__once;
}

static void
_vala_seahorse_ssh_key_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	SeahorseSshKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_KEY, SeahorseSshKey);
	switch (property_id) {
		case SEAHORSE_SSH_KEY_KEY_DATA_PROPERTY:
		g_value_set_object (value, seahorse_ssh_key_get_key_data (self));
		break;
		case SEAHORSE_SSH_KEY_FINGERPRINT_PROPERTY:
		g_value_set_string (value, seahorse_ssh_key_get_fingerprint (self));
		break;
		case SEAHORSE_SSH_KEY_PUBKEY_PROPERTY:
		g_value_set_string (value, seahorse_ssh_key_get_pubkey (self));
		break;
		case SEAHORSE_SSH_KEY_DESCRIPTION_PROPERTY:
		g_value_set_string (value, seahorse_ssh_key_get_description (self));
		break;
		case SEAHORSE_SSH_KEY_VALIDITY_PROPERTY:
		g_value_set_enum (value, seahorse_ssh_key_get_validity (self));
		break;
		case SEAHORSE_SSH_KEY_TRUST_PROPERTY:
		g_value_set_enum (value, seahorse_ssh_key_get_trust (self));
		break;
		case SEAHORSE_SSH_KEY_EXPIRES_PROPERTY:
		g_value_set_ulong (value, seahorse_ssh_key_get_expires (self));
		break;
		case SEAHORSE_SSH_KEY_LENGTH_PROPERTY:
		g_value_set_uint (value, seahorse_ssh_key_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_ssh_key_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	SeahorseSshKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_KEY, SeahorseSshKey);
	switch (property_id) {
		case SEAHORSE_SSH_KEY_KEY_DATA_PROPERTY:
		seahorse_ssh_key_set_key_data (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

