/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class NullsFirstOrdering<T>
extends Ordering<T>
implements Serializable {
    final Ordering<? super T> ordering;
    private static final long serialVersionUID = 0L;

    NullsFirstOrdering(Ordering<? super T> ordering) {
        this.ordering = ordering;
    }

    @Override
    public int compare(@CheckForNull T left2, @CheckForNull T right2) {
        if (left2 == right2) {
            return 0;
        }
        if (left2 == null) {
            return -1;
        }
        if (right2 == null) {
            return 1;
        }
        return this.ordering.compare(left2, right2);
    }

    @Override
    public <S extends T> Ordering<S> reverse() {
        return this.ordering.reverse().nullsLast();
    }

    @Override
    public <S extends T> Ordering<@Nullable S> nullsFirst() {
        return this;
    }

    @Override
    public <S extends T> Ordering<@Nullable S> nullsLast() {
        return this.ordering.nullsLast();
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NullsFirstOrdering) {
            NullsFirstOrdering that = (NullsFirstOrdering)object;
            return this.ordering.equals(that.ordering);
        }
        return false;
    }

    public int hashCode() {
        return this.ordering.hashCode() ^ 0x39153A74;
    }

    public String toString() {
        String string2 = String.valueOf(this.ordering);
        return new StringBuilder(13 + String.valueOf(string2).length()).append(string2).append(".nullsFirst()").toString();
    }
}

