/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function (Drupal, Backbone) {
  Drupal.contextual.AuralView = Backbone.View.extend({
    initialize: function initialize(options) {
      this.options = options;
      this.listenTo(this.model, 'change', this.render);
      this.render();
    },
    render: function render() {
      var _this = this;

      var isOpen = this.model.get('isOpen');
      this.$el.find('.contextual-links').prop('hidden', !isOpen);
      var $trigger = this.$el.find('.trigger');
      $trigger.each(function (index, element) {
        element.textContent = Drupal.t('@action @title configuration options', {
          '@action': !isOpen ? _this.options.strings.open : _this.options.strings.close,
          '@title': _this.model.get('title')
        });
      }).attr('aria-pressed', isOpen);
    }
  });
})(Drupal, Backbone);