/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _isFunction from 'lodash/isFunction';
import _isArray from 'lodash/isArray';
import _isString from 'lodash/isString';
import _isBoolean from 'lodash/isBoolean';
import _isNumber from 'lodash/isNumber';
import _isNaN from 'lodash/isNaN';
import _isObject from 'lodash/isObject'; // wrap the lodash functions to avoid having lodash's TS type definition from being
// exported, which can conflict with the lodash namespace if other versions are used

export var isFunction = function isFunction(value) {
  return _isFunction(value);
};
export var isArray = function isArray(value) {
  return _isArray(value);
};
export var isString = function isString(value) {
  return _isString(value);
};
export var isBoolean = function isBoolean(value) {
  return _isBoolean(value);
};
export var isNumber = function isNumber(value) {
  return _isNumber(value);
};
export var isNaN = function isNaN(value) {
  return _isNaN(value);
};
export var isObject = function isObject(value) {
  return _isObject(value);
};