/* tracker-bus-statement.c generated by valac 0.56.2, the Vala compiler
 * generated from tracker-bus-statement.vala, do not modify */

/*
 * Copyright (C) 2020, Red Hat Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Carlos Garnacho <carlosg@gnome.org>
 */

#include "tracker-bus.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <float.h>
#include <math.h>
#include "libtracker-sparql/tracker-connection.h"
#include <glib-object.h>

enum  {
	TRACKER_BUS_STATEMENT_0_PROPERTY,
	TRACKER_BUS_STATEMENT_NUM_PROPERTIES
};
static GParamSpec* tracker_bus_statement_properties[TRACKER_BUS_STATEMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
typedef struct _Block9Data Block9Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef struct _TrackerBusStatementExecuteAsyncData TrackerBusStatementExecuteAsyncData;
typedef struct _TrackerBusStatementSerializeAsyncData TrackerBusStatementSerializeAsyncData;

struct _TrackerBusStatementPrivate {
	GDBusConnection* bus;
	gchar* query;
	gchar* dbus_name;
	gchar* object_path;
	GHashTable* arguments;
};

struct _Block9Data {
	int _ref_count_;
	TrackerBusStatement* self;
	GMainLoop* loop;
	GAsyncResult* async_res;
};

struct _TrackerBusStatementExecuteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusStatement* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	GDBusConnection* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GVariantBuilder* _tmp5_;
	GVariantBuilder* _tmp6_;
	TrackerSparqlCursor* _tmp7_;
	TrackerSparqlCursor* _tmp8_;
	TrackerSparqlCursor* _tmp9_;
	GError* _inner_error0_;
};

struct _TrackerBusStatementSerializeAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusStatement* self;
	TrackerSerializeFlags flags;
	TrackerRdfFormat format;
	GCancellable* cancellable;
	GInputStream* result;
	GInputStream* _tmp0_;
	GDBusConnection* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GVariantBuilder* _tmp5_;
	GVariantBuilder* _tmp6_;
	GInputStream* _tmp7_;
	GInputStream* _tmp8_;
	GInputStream* _tmp9_;
	GError* _inner_error0_;
};

static gint TrackerBusStatement_private_offset;
static gpointer tracker_bus_statement_parent_class = NULL;

static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void tracker_bus_statement_real_bind_boolean (TrackerSparqlStatement* base,
                                              const gchar* name,
                                              gboolean value);
static void tracker_bus_statement_real_bind_double (TrackerSparqlStatement* base,
                                             const gchar* name,
                                             gdouble value);
static void tracker_bus_statement_real_bind_int (TrackerSparqlStatement* base,
                                          const gchar* name,
                                          gint64 value);
static void tracker_bus_statement_real_bind_string (TrackerSparqlStatement* base,
                                             const gchar* name,
                                             const gchar* value);
static void tracker_bus_statement_real_bind_datetime (TrackerSparqlStatement* base,
                                               const gchar* name,
                                               GDateTime* value);
static void tracker_bus_statement_real_clear_bindings (TrackerSparqlStatement* base);
static GVariantBuilder* tracker_bus_statement_get_arguments (TrackerBusStatement* self);
static TrackerSparqlCursor* tracker_bus_statement_real_execute (TrackerSparqlStatement* base,
                                                         GCancellable* cancellable,
                                                         GError** error);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda6_ (Block9Data* _data9_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_statement_real_execute_async_data_free (gpointer _data);
static void tracker_bus_statement_real_execute_async (TrackerSparqlStatement* base,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean tracker_bus_statement_real_execute_async_co (TrackerBusStatementExecuteAsyncData* _data_);
static void tracker_bus_statement_execute_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void tracker_bus_statement_real_serialize_async_data_free (gpointer _data);
static void tracker_bus_statement_real_serialize_async (TrackerSparqlStatement* base,
                                                 TrackerSerializeFlags flags,
                                                 TrackerRdfFormat format,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean tracker_bus_statement_real_serialize_async_co (TrackerBusStatementSerializeAsyncData* _data_);
static void tracker_bus_statement_serialize_async_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void tracker_bus_statement_finalize (GObject * obj);
static GType tracker_bus_statement_get_type_once (void);

static inline gpointer
tracker_bus_statement_get_instance_private (TrackerBusStatement* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerBusStatement_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 31 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	return self ? g_object_ref (self) : NULL;
#line 179 "tracker-bus-statement.c"
}

static void
_g_free0_ (gpointer var)
{
#line 35 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	var = (g_free (var), NULL);
#line 187 "tracker-bus-statement.c"
}

static void
_g_variant_unref0_ (gpointer var)
{
#line 35 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
#line 195 "tracker-bus-statement.c"
}

TrackerBusStatement*
tracker_bus_statement_construct (GType object_type,
                                 GDBusConnection* bus,
                                 const gchar* dbus_name,
                                 const gchar* object_path,
                                 const gchar* query)
{
	TrackerBusStatement * self = NULL;
	GDBusConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
#line 29 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_val_if_fail (bus != NULL, NULL);
#line 29 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_val_if_fail (dbus_name != NULL, NULL);
#line 29 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_val_if_fail (object_path != NULL, NULL);
#line 29 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 30 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self = (TrackerBusStatement*) g_object_new (object_type, NULL);
#line 31 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp0_ = _g_object_ref0 (bus);
#line 31 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (self->priv->bus);
#line 31 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self->priv->bus = _tmp0_;
#line 32 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp1_ = g_strdup (dbus_name);
#line 32 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_free0 (self->priv->dbus_name);
#line 32 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self->priv->dbus_name = _tmp1_;
#line 33 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp2_ = g_strdup (object_path);
#line 33 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_free0 (self->priv->object_path);
#line 33 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self->priv->object_path = _tmp2_;
#line 34 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp3_ = g_strdup (query);
#line 34 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_free0 (self->priv->query);
#line 34 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self->priv->query = _tmp3_;
#line 35 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp4_ = g_str_hash;
#line 35 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp5_ = g_str_equal;
#line 35 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_variant_unref0_);
#line 35 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_hash_table_unref0 (self->priv->arguments);
#line 35 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self->priv->arguments = _tmp6_;
#line 29 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	return self;
#line 259 "tracker-bus-statement.c"
}

TrackerBusStatement*
tracker_bus_statement_new (GDBusConnection* bus,
                           const gchar* dbus_name,
                           const gchar* object_path,
                           const gchar* query)
{
#line 29 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	return tracker_bus_statement_construct (TRACKER_BUS_TYPE_STATEMENT, bus, dbus_name, object_path, query);
#line 270 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_real_bind_boolean (TrackerSparqlStatement* base,
                                         const gchar* name,
                                         gboolean value)
{
	TrackerBusStatement * self;
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
#line 38 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self = (TrackerBusStatement*) base;
#line 38 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_if_fail (name != NULL);
#line 39 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp0_ = self->priv->arguments;
#line 39 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp1_ = g_strdup (name);
#line 39 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp2_ = g_variant_new_boolean (value);
#line 39 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_variant_ref_sink (_tmp2_);
#line 39 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
#line 296 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_real_bind_double (TrackerSparqlStatement* base,
                                        const gchar* name,
                                        gdouble value)
{
	TrackerBusStatement * self;
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self = (TrackerBusStatement*) base;
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_if_fail (name != NULL);
#line 43 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp0_ = self->priv->arguments;
#line 43 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp1_ = g_strdup (name);
#line 43 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp2_ = g_variant_new_double (value);
#line 43 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_variant_ref_sink (_tmp2_);
#line 43 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
#line 322 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_real_bind_int (TrackerSparqlStatement* base,
                                     const gchar* name,
                                     gint64 value)
{
	TrackerBusStatement * self;
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
#line 46 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self = (TrackerBusStatement*) base;
#line 46 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_if_fail (name != NULL);
#line 47 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp0_ = self->priv->arguments;
#line 47 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp1_ = g_strdup (name);
#line 47 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp2_ = g_variant_new_int64 (value);
#line 47 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_variant_ref_sink (_tmp2_);
#line 47 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
#line 348 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_real_bind_string (TrackerSparqlStatement* base,
                                        const gchar* name,
                                        const gchar* value)
{
	TrackerBusStatement * self;
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
#line 50 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self = (TrackerBusStatement*) base;
#line 50 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_if_fail (name != NULL);
#line 50 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_if_fail (value != NULL);
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp0_ = self->priv->arguments;
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp1_ = g_strdup (name);
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp2_ = g_variant_new_string (value);
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_variant_ref_sink (_tmp2_);
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp2_);
#line 376 "tracker-bus-statement.c"
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
#line 3320 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 3321 "glib-2.0.vapi"
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
#line 3321 "glib-2.0.vapi"
	result = _tmp0_;
#line 3321 "glib-2.0.vapi"
	return result;
#line 392 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_real_bind_datetime (TrackerSparqlStatement* base,
                                          const gchar* name,
                                          GDateTime* value)
{
	TrackerBusStatement * self;
	gchar* date_time = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	GVariant* _tmp3_;
#line 54 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self = (TrackerBusStatement*) base;
#line 54 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_if_fail (name != NULL);
#line 54 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_if_fail (value != NULL);
#line 55 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp0_ = g_date_time_to_string (value);
#line 55 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	date_time = _tmp0_;
#line 56 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp1_ = self->priv->arguments;
#line 56 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp2_ = g_strdup (name);
#line 56 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp3_ = g_variant_new_string (date_time);
#line 56 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_variant_ref_sink (_tmp3_);
#line 56 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
#line 54 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_free0 (date_time);
#line 428 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_real_clear_bindings (TrackerSparqlStatement* base)
{
	TrackerBusStatement * self;
	GHashTable* _tmp0_;
#line 59 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self = (TrackerBusStatement*) base;
#line 60 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp0_ = self->priv->arguments;
#line 60 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_hash_table_remove_all (_tmp0_);
#line 442 "tracker-bus-statement.c"
}

static GVariantBuilder*
tracker_bus_statement_get_arguments (TrackerBusStatement* self)
{
	GHashTable* _tmp0_;
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp4_;
	GHashTableIter iter = {0};
	GHashTable* _tmp5_;
	const gchar* arg = NULL;
	GVariant* value = NULL;
	GVariantBuilder* result;
#line 63 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp0_ = self->priv->arguments;
#line 64 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	if (g_hash_table_size (_tmp0_) == ((guint) 0)) {
#line 65 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		result = NULL;
#line 65 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		return result;
#line 469 "tracker-bus-statement.c"
	}
#line 67 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp1_ = g_variant_type_new ("a{sv}");
#line 67 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp2_ = _tmp1_;
#line 67 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp3_ = g_variant_builder_new (_tmp2_);
#line 67 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp4_ = _tmp3_;
#line 67 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_variant_type_free0 (_tmp2_);
#line 67 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	builder = _tmp4_;
#line 68 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp5_ = self->priv->arguments;
#line 68 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_hash_table_iter_init (&iter, _tmp5_);
#line 72 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	while (TRUE) {
#line 489 "tracker-bus-statement.c"
		gconstpointer _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		gboolean _tmp8_;
		GVariantBuilder* _tmp9_;
		const gchar* _tmp10_;
		GVariant* _tmp11_;
#line 72 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		_tmp8_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp6_), (gpointer*) (&_tmp7_));
#line 72 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		arg = _tmp6_;
#line 72 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		value = _tmp7_;
#line 72 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		if (!_tmp8_) {
#line 72 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
			break;
#line 506 "tracker-bus-statement.c"
		}
#line 73 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		_tmp9_ = builder;
#line 73 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		_tmp10_ = arg;
#line 73 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		_tmp11_ = value;
#line 73 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		g_variant_builder_add (_tmp9_, "{sv}", _tmp10_, _tmp11_, NULL);
#line 516 "tracker-bus-statement.c"
	}
#line 75 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	result = builder;
#line 75 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	return result;
#line 522 "tracker-bus-statement.c"
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	return _data9_;
#line 532 "tracker-bus-statement.c"
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 542 "tracker-bus-statement.c"
		TrackerBusStatement* self;
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		self = _data9_->self;
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		_g_object_unref0 (_data9_->async_res);
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		_g_main_loop_unref0 (_data9_->loop);
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		_g_object_unref0 (self);
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		g_slice_free (Block9Data, _data9_);
#line 554 "tracker-bus-statement.c"
	}
}

static void
__lambda6_ (Block9Data* _data9_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusStatement* self;
	GAsyncResult* _tmp0_;
#line 84 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self = _data9_->self;
#line 84 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_return_if_fail (res != NULL);
#line 85 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 85 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (_data9_->async_res);
#line 85 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data9_->async_res = _tmp0_;
#line 86 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_main_loop_quit (_data9_->loop);
#line 577 "tracker-bus-statement.c"
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 84 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	__lambda6_ (self, source_object, res);
#line 84 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	block9_data_unref (self);
#line 589 "tracker-bus-statement.c"
}

static TrackerSparqlCursor*
tracker_bus_statement_real_execute (TrackerSparqlStatement* base,
                                    GCancellable* cancellable,
                                    GError** error)
{
	TrackerBusStatement * self;
	Block9Data* _data9_;
	GMainContext* context = NULL;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	TrackerSparqlCursor* _tmp2_ = NULL;
	TrackerSparqlCursor* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlCursor* result;
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self = (TrackerBusStatement*) base;
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data9_ = g_slice_new0 (Block9Data);
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data9_->_ref_count_ = 1;
#line 78 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data9_->self = g_object_ref (self);
#line 80 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp0_ = g_main_context_new ();
#line 80 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	context = _tmp0_;
#line 81 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp1_ = g_main_loop_new (context, FALSE);
#line 81 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data9_->loop = _tmp1_;
#line 82 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_main_context_push_thread_default (context);
#line 83 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data9_->async_res = NULL;
#line 84 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	tracker_sparql_statement_execute_async ((TrackerSparqlStatement*) self, cancellable, ___lambda6__gasync_ready_callback, block9_data_ref (_data9_));
#line 88 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_main_loop_run (_data9_->loop);
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_main_context_pop_thread_default (context);
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp3_ = tracker_sparql_statement_execute_finish ((TrackerSparqlStatement*) self, _data9_->async_res, &_inner_error0_);
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp2_ = _tmp3_;
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		g_propagate_error (error, _inner_error0_);
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		_g_main_context_unref0 (context);
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		block9_data_unref (_data9_);
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		_data9_ = NULL;
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		return NULL;
#line 649 "tracker-bus-statement.c"
	}
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp4_ = _tmp2_;
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp2_ = NULL;
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	result = _tmp4_;
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (_tmp2_);
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_main_context_unref0 (context);
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	block9_data_unref (_data9_);
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data9_ = NULL;
#line 90 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	return result;
#line 667 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_real_execute_async_data_free (gpointer _data)
{
	TrackerBusStatementExecuteAsyncData* _data_;
	_data_ = _data;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (_data_->result);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (_data_->self);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_slice_free (TrackerBusStatementExecuteAsyncData, _data_);
#line 683 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_real_execute_async (TrackerSparqlStatement* base,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	TrackerBusStatement * self;
	TrackerBusStatementExecuteAsyncData* _data_;
	TrackerBusStatement* _tmp0_;
	GCancellable* _tmp1_;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self = (TrackerBusStatement*) base;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_ = g_slice_new0 (TrackerBusStatementExecuteAsyncData);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_statement_real_execute_async_data_free);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->self = _tmp0_;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->cancellable = _tmp1_;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	tracker_bus_statement_real_execute_async_co (_data_);
#line 716 "tracker-bus-statement.c"
}

static TrackerSparqlCursor*
tracker_bus_statement_execute_finish (TrackerSparqlStatement* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	TrackerSparqlCursor* result;
	TrackerBusStatementExecuteAsyncData* _data_;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	if (NULL == _data_) {
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		return NULL;
#line 732 "tracker-bus-statement.c"
	}
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	result = _data_->result;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->result = NULL;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	return result;
#line 740 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_execute_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	TrackerBusStatementExecuteAsyncData* _data_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_ = _user_data_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_source_object_ = source_object;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_res_ = _res_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	tracker_bus_statement_real_execute_async_co (_data_);
#line 757 "tracker-bus-statement.c"
}

static gboolean
tracker_bus_statement_real_execute_async_co (TrackerBusStatementExecuteAsyncData* _data_)
{
#line 93 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	switch (_data_->_state_) {
#line 93 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		case 0:
#line 767 "tracker-bus-statement.c"
		goto _state_0;
#line 93 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		case 1:
#line 771 "tracker-bus-statement.c"
		goto _state_1;
		default:
#line 93 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		g_assert_not_reached ();
#line 776 "tracker-bus-statement.c"
	}
	_state_0:
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp1_ = _data_->self->priv->bus;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp2_ = _data_->self->priv->dbus_name;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp3_ = _data_->self->priv->object_path;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp4_ = _data_->self->priv->query;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp5_ = tracker_bus_statement_get_arguments (_data_->self);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_state_ = 1;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	tracker_bus_connection_perform_query_call (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, _data_->_tmp6_, _data_->cancellable, tracker_bus_statement_execute_async_ready, _data_);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	return FALSE;
#line 797 "tracker-bus-statement.c"
	_state_1:
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp7_ = tracker_bus_connection_perform_query_call_finish (_data_->_res_, &_data_->_inner_error0_);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_variant_builder_unref0 (_data_->_tmp6_);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp0_ = _data_->_tmp8_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		g_object_unref (_data_->_async_result);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		return FALSE;
#line 815 "tracker-bus-statement.c"
	}
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp9_ = _data_->_tmp0_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp0_ = NULL;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->result = _data_->_tmp9_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	if (_data_->_state_ != 0) {
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 833 "tracker-bus-statement.c"
		}
	}
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_object_unref (_data_->_async_result);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	return FALSE;
#line 840 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_real_serialize_async_data_free (gpointer _data)
{
	TrackerBusStatementSerializeAsyncData* _data_;
	_data_ = _data;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (_data_->result);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (_data_->self);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_slice_free (TrackerBusStatementSerializeAsyncData, _data_);
#line 856 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_real_serialize_async (TrackerSparqlStatement* base,
                                            TrackerSerializeFlags flags,
                                            TrackerRdfFormat format,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	TrackerBusStatement * self;
	TrackerBusStatementSerializeAsyncData* _data_;
	TrackerBusStatement* _tmp0_;
	GCancellable* _tmp1_;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self = (TrackerBusStatement*) base;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_ = g_slice_new0 (TrackerBusStatementSerializeAsyncData);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_statement_real_serialize_async_data_free);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->self = _tmp0_;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->flags = flags;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->format = format;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->cancellable = _tmp1_;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	tracker_bus_statement_real_serialize_async_co (_data_);
#line 895 "tracker-bus-statement.c"
}

static GInputStream*
tracker_bus_statement_serialize_finish (TrackerSparqlStatement* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GInputStream* result;
	TrackerBusStatementSerializeAsyncData* _data_;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	if (NULL == _data_) {
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		return NULL;
#line 911 "tracker-bus-statement.c"
	}
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	result = _data_->result;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->result = NULL;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	return result;
#line 919 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_serialize_async_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	TrackerBusStatementSerializeAsyncData* _data_;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_ = _user_data_;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_source_object_ = source_object;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_res_ = _res_;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	tracker_bus_statement_real_serialize_async_co (_data_);
#line 936 "tracker-bus-statement.c"
}

static gboolean
tracker_bus_statement_real_serialize_async_co (TrackerBusStatementSerializeAsyncData* _data_)
{
#line 97 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	switch (_data_->_state_) {
#line 97 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		case 0:
#line 946 "tracker-bus-statement.c"
		goto _state_0;
#line 97 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		case 1:
#line 950 "tracker-bus-statement.c"
		goto _state_1;
		default:
#line 97 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		g_assert_not_reached ();
#line 955 "tracker-bus-statement.c"
	}
	_state_0:
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp1_ = _data_->self->priv->bus;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp2_ = _data_->self->priv->dbus_name;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp3_ = _data_->self->priv->object_path;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp4_ = _data_->self->priv->query;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp5_ = tracker_bus_statement_get_arguments (_data_->self);
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_state_ = 1;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	tracker_bus_connection_perform_serialize (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->flags, _data_->format, _data_->_tmp4_, _data_->_tmp6_, _data_->cancellable, tracker_bus_statement_serialize_async_ready, _data_);
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	return FALSE;
#line 976 "tracker-bus-statement.c"
	_state_1:
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp7_ = tracker_bus_connection_perform_serialize_finish (_data_->_res_, &_data_->_inner_error0_);
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_variant_builder_unref0 (_data_->_tmp6_);
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp0_ = _data_->_tmp8_;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		g_object_unref (_data_->_async_result);
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		return FALSE;
#line 994 "tracker-bus-statement.c"
	}
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp9_ = _data_->_tmp0_;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->_tmp0_ = NULL;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_data_->result = _data_->_tmp9_;
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	if (_data_->_state_ != 0) {
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1012 "tracker-bus-statement.c"
		}
	}
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_object_unref (_data_->_async_result);
#line 98 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	return FALSE;
#line 1019 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_class_init (TrackerBusStatementClass * klass,
                                  gpointer klass_data)
{
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	tracker_bus_statement_parent_class = g_type_class_peek_parent (klass);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	g_type_class_adjust_private_offset (klass, &TrackerBusStatement_private_offset);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	((TrackerSparqlStatementClass *) klass)->bind_boolean = (void (*) (TrackerSparqlStatement*, const gchar*, gboolean)) tracker_bus_statement_real_bind_boolean;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	((TrackerSparqlStatementClass *) klass)->bind_double = (void (*) (TrackerSparqlStatement*, const gchar*, gdouble)) tracker_bus_statement_real_bind_double;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	((TrackerSparqlStatementClass *) klass)->bind_int = (void (*) (TrackerSparqlStatement*, const gchar*, gint64)) tracker_bus_statement_real_bind_int;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	((TrackerSparqlStatementClass *) klass)->bind_string = (void (*) (TrackerSparqlStatement*, const gchar*, const gchar*)) tracker_bus_statement_real_bind_string;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	((TrackerSparqlStatementClass *) klass)->bind_datetime = (void (*) (TrackerSparqlStatement*, const gchar*, GDateTime*)) tracker_bus_statement_real_bind_datetime;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	((TrackerSparqlStatementClass *) klass)->clear_bindings = (void (*) (TrackerSparqlStatement*)) tracker_bus_statement_real_clear_bindings;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	((TrackerSparqlStatementClass *) klass)->execute = (TrackerSparqlCursor* (*) (TrackerSparqlStatement*, GCancellable*, GError**)) tracker_bus_statement_real_execute;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	((TrackerSparqlStatementClass *) klass)->execute_async = (void (*) (TrackerSparqlStatement*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_statement_real_execute_async;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	((TrackerSparqlStatementClass *) klass)->execute_finish = (TrackerSparqlCursor* (*) (TrackerSparqlStatement*, GAsyncResult*, GError**)) tracker_bus_statement_execute_finish;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	((TrackerSparqlStatementClass *) klass)->serialize_async = (void (*) (TrackerSparqlStatement*, TrackerSerializeFlags, TrackerRdfFormat, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_statement_real_serialize_async;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	((TrackerSparqlStatementClass *) klass)->serialize_finish = (GInputStream* (*) (TrackerSparqlStatement*, GAsyncResult*, GError**)) tracker_bus_statement_serialize_finish;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_bus_statement_finalize;
#line 1054 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_instance_init (TrackerBusStatement * self,
                                     gpointer klass)
{
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self->priv = tracker_bus_statement_get_instance_private (self);
#line 1063 "tracker-bus-statement.c"
}

static void
tracker_bus_statement_finalize (GObject * obj)
{
	TrackerBusStatement * self;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_BUS_TYPE_STATEMENT, TrackerBusStatement);
#line 23 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_object_unref0 (self->priv->bus);
#line 24 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_free0 (self->priv->query);
#line 25 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_free0 (self->priv->dbus_name);
#line 26 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_free0 (self->priv->object_path);
#line 27 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	_g_hash_table_unref0 (self->priv->arguments);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-statement.vala"
	G_OBJECT_CLASS (tracker_bus_statement_parent_class)->finalize (obj);
#line 1084 "tracker-bus-statement.c"
}

static GType
tracker_bus_statement_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerBusStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_bus_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerBusStatement), 0, (GInstanceInitFunc) tracker_bus_statement_instance_init, NULL };
	GType tracker_bus_statement_type_id;
	tracker_bus_statement_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_STATEMENT, "TrackerBusStatement", &g_define_type_info, 0);
	TrackerBusStatement_private_offset = g_type_add_instance_private (tracker_bus_statement_type_id, sizeof (TrackerBusStatementPrivate));
	return tracker_bus_statement_type_id;
}

GType
tracker_bus_statement_get_type (void)
{
	static volatile gsize tracker_bus_statement_type_id__once = 0;
	if (g_once_init_enter (&tracker_bus_statement_type_id__once)) {
		GType tracker_bus_statement_type_id;
		tracker_bus_statement_type_id = tracker_bus_statement_get_type_once ();
		g_once_init_leave (&tracker_bus_statement_type_id__once, tracker_bus_statement_type_id);
	}
	return tracker_bus_statement_type_id__once;
}

