/* contacts-app.c generated by valac 0.56.0, the Vala compiler
 * generated from contacts-app.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "contacts.h"
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <folks/folks.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <folks/folks-eds.h>
#include <libedataserver/libedataserver.h>

#define CONTACTS_APP_LOADING_TIMEOUT 1
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_SETTINGS (contacts_settings_get_type ())
#define CONTACTS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettings))
#define CONTACTS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))
#define CONTACTS_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))

typedef struct _ContactsSettings ContactsSettings;
typedef struct _ContactsSettingsClass ContactsSettingsClass;

#define CONTACTS_TYPE_MAIN_WINDOW (contacts_main_window_get_type ())
#define CONTACTS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow))
#define CONTACTS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))
#define CONTACTS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))

typedef struct _ContactsMainWindow ContactsMainWindow;
typedef struct _ContactsMainWindowClass ContactsMainWindowClass;
enum  {
	CONTACTS_APP_0_PROPERTY,
	CONTACTS_APP_NUM_PROPERTIES
};
static GParamSpec* contacts_app_properties[CONTACTS_APP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
typedef struct _ContactsAppShowIndividualData ContactsAppShowIndividualData;
typedef struct _Block3Data Block3Data;
typedef struct _ContactsAppShowIndividualReadyData ContactsAppShowIndividualReadyData;

#define CONTACTS_TYPE_ADDRESSBOOK_DIALOG (contacts_addressbook_dialog_get_type ())
#define CONTACTS_ADDRESSBOOK_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_ADDRESSBOOK_DIALOG, ContactsAddressbookDialog))
#define CONTACTS_ADDRESSBOOK_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_ADDRESSBOOK_DIALOG, ContactsAddressbookDialogClass))
#define CONTACTS_IS_ADDRESSBOOK_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_ADDRESSBOOK_DIALOG))
#define CONTACTS_IS_ADDRESSBOOK_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_ADDRESSBOOK_DIALOG))
#define CONTACTS_ADDRESSBOOK_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_ADDRESSBOOK_DIALOG, ContactsAddressbookDialogClass))

typedef struct _ContactsAddressbookDialog ContactsAddressbookDialog;
typedef struct _ContactsAddressbookDialogClass ContactsAddressbookDialogClass;
typedef struct _Block4Data Block4Data;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _ContactsAppShowByEmailData ContactsAppShowByEmailData;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

#define CONTACTS_TYPE_SETUP_WINDOW (contacts_setup_window_get_type ())
#define CONTACTS_SETUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindow))
#define CONTACTS_SETUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindowClass))
#define CONTACTS_IS_SETUP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETUP_WINDOW))
#define CONTACTS_IS_SETUP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETUP_WINDOW))
#define CONTACTS_SETUP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETUP_WINDOW, ContactsSetupWindowClass))

typedef struct _ContactsSetupWindow ContactsSetupWindow;
typedef struct _ContactsSetupWindowClass ContactsSetupWindowClass;
typedef struct _Block8Data Block8Data;

struct _ContactsApp {
	AdwApplication parent_instance;
	ContactsAppPrivate * priv;
};

struct _ContactsAppClass {
	AdwApplicationClass parent_class;
};

struct _ContactsAppPrivate {
	ContactsSettings* settings;
	ContactsStore* contacts_store;
	ContactsMainWindow* window;
};

struct _Block2Data {
	int _ref_count_;
	ContactsApp* self;
	gchar* id;
	gpointer _async_data_;
};

struct _ContactsAppShowIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsApp* self;
	gchar* id;
	Block2Data* _data2_;
	ContactsStore* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ContactsStore* _tmp3_;
};

struct _Block3Data {
	int _ref_count_;
	ContactsApp* self;
	GtkMessageDialog* dialog;
};

struct _ContactsAppShowIndividualReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsApp* self;
	gchar* id;
	FolksIndividual* contact;
	FolksIndividual* _tmp0_;
	ContactsStore* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	FolksIndividualAggregator* _tmp3_;
	FolksIndividual* _tmp4_;
	FolksIndividual* _tmp5_;
	FolksIndividual* _tmp6_;
	FolksIndividual* _tmp7_;
	Block3Data* _data3_;
	ContactsMainWindow* _tmp8_;
	GtkMessageDialog* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkMessageDialog* _tmp11_;
	GtkMessageDialog* _tmp12_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	ContactsApp* self;
	ContactsAddressbookDialog* dialog;
};

struct _Block5Data {
	int _ref_count_;
	ContactsApp* self;
	GtkMessageDialog* dialog;
};

struct _ContactsAppShowByEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsApp* self;
	gchar* email_address;
	FolksSimpleQuery* query;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	FolksSimpleQuery* _tmp3_;
	FolksSimpleQuery* _tmp4_;
	FolksIndividual* individual;
	ContactsStore* _tmp5_;
	FolksSimpleQuery* _tmp6_;
	FolksIndividual* _tmp7_;
	FolksIndividual* _tmp8_;
	FolksIndividual* _tmp9_;
	Block5Data* _data5_;
	ContactsMainWindow* _tmp10_;
	GtkMessageDialog* _tmp11_;
	GtkMessageDialog* _tmp12_;
	GtkMessageDialog* _tmp13_;
	GtkMessageDialog* _tmp14_;
};

struct _Block6Data {
	int _ref_count_;
	ContactsApp* self;
	gchar* query;
};

struct _Block7Data {
	int _ref_count_;
	ContactsApp* self;
	guint timeout_id;
	gulong quiescence_id;
};

struct _Block8Data {
	int _ref_count_;
	ContactsApp* self;
	GSimpleAction* change_book_action;
	ContactsSetupWindow* setup_window;
};

static gint ContactsApp_private_offset;
static gpointer contacts_app_parent_class = NULL;

VALA_EXTERN GType contacts_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsApp, g_object_unref)
VALA_EXTERN GType contacts_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsSettings, g_object_unref)
VALA_EXTERN GType contacts_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsMainWindow, g_object_unref)
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN void contacts_app_show_help (ContactsApp* self);
static void _contacts_app_show_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
VALA_EXTERN void contacts_app_show_about (ContactsApp* self);
static void _contacts_app_show_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
VALA_EXTERN void contacts_app_change_address_book (ContactsApp* self);
static void _contacts_app_change_address_book_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
VALA_EXTERN void contacts_app_online_accounts (ContactsApp* self);
static void _contacts_app_online_accounts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void contacts_app_on_show_contact (ContactsApp* self,
                                   GSimpleAction* action,
                                   GVariant* param);
static void _contacts_app_on_show_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
VALA_EXTERN ContactsApp* contacts_app_new (void);
VALA_EXTERN ContactsApp* contacts_app_construct (GType object_type);
VALA_EXTERN ContactsSettings* contacts_settings_new (ContactsApp* app);
VALA_EXTERN ContactsSettings* contacts_settings_construct (GType object_type,
                                               ContactsApp* app);
static gint contacts_app_real_command_line (GApplication* base,
                                     GApplicationCommandLine* command_line);
VALA_EXTERN void contacts_app_show_individual (ContactsApp* self,
                                   const gchar* id,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void contacts_app_show_individual_finish (ContactsApp* self,
                                          GAsyncResult* _res_);
VALA_EXTERN void contacts_app_show_by_email (ContactsApp* self,
                                 const gchar* email_address,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void contacts_app_show_by_email_finish (ContactsApp* self,
                                        GAsyncResult* _res_);
VALA_EXTERN void contacts_app_show_search (ContactsApp* self,
                               const gchar* query);
static gint contacts_app_real_handle_local_options (GApplication* base,
                                             GVariantDict* options);
VALA_EXTERN void contacts_app_show_contact (ContactsApp* self,
                                FolksIndividual* individual);
VALA_EXTERN void contacts_main_window_set_shown_contact (ContactsMainWindow* self,
                                             FolksIndividual* i);
static void contacts_app_show_individual_data_free (gpointer _data);
static gboolean contacts_app_show_individual_co (ContactsAppShowIndividualData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void contacts_app_show_individual_ready (ContactsApp* self,
                                         const gchar* id,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void contacts_app_show_individual_ready_finish (ContactsApp* self,
                                                GAsyncResult* _res_);
static void ___lambda69_ (Block2Data* _data2_);
static void ____lambda69__contacts_store_quiescent (ContactsStore* _sender,
                                             gpointer self);
static void contacts_app_show_individual_ready_data_free (gpointer _data);
static gboolean contacts_app_show_individual_ready_co (ContactsAppShowIndividualReadyData* _data_);
static void contacts_app_show_individual_ready_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda68_ (Block3Data* _data3_,
                   gint _);
static void ____lambda68__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
VALA_EXTERN GType contacts_addressbook_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAddressbookDialog, g_object_unref)
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN ContactsAddressbookDialog* contacts_addressbook_dialog_new (ContactsStore* contacts_store,
                                                            GtkWindow* window);
VALA_EXTERN ContactsAddressbookDialog* contacts_addressbook_dialog_construct (GType object_type,
                                                                  ContactsStore* contacts_store,
                                                                  GtkWindow* window);
static void __lambda60_ (Block4Data* _data4_,
                  gint _);
static void ___lambda60__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void contacts_app_show_by_email_data_free (gpointer _data);
static gboolean contacts_app_show_by_email_co (ContactsAppShowByEmailData* _data_);
static void contacts_app_show_by_email_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda70_ (Block5Data* _data5_,
                   gint _);
static void ____lambda70__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
VALA_EXTERN void contacts_main_window_show_search (ContactsMainWindow* self,
                                       const gchar* query);
static void ___lambda71_ (Block6Data* _data6_);
static void ____lambda71__contacts_store_quiescent (ContactsStore* _sender,
                                             gpointer self);
static void contacts_app_create_window (ContactsApp* self);
VALA_EXTERN ContactsMainWindow* contacts_main_window_new (ContactsSettings* settings,
                                              ContactsApp* app,
                                              ContactsStore* contacts_store);
VALA_EXTERN ContactsMainWindow* contacts_main_window_construct (GType object_type,
                                                    ContactsSettings* settings,
                                                    ContactsApp* app,
                                                    ContactsStore* contacts_store);
static void contacts_app_show_contact_list (ContactsApp* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda61_ (Block7Data* _data7_);
VALA_EXTERN void contacts_main_window_show_contact_list (ContactsMainWindow* self);
static void ___lambda61__contacts_store_quiescent (ContactsStore* _sender,
                                            gpointer self);
static gboolean __lambda62_ (Block7Data* _data7_);
static gboolean ___lambda62__gsource_func (gpointer self);
static void contacts_app_real_startup (GApplication* base);
VALA_EXTERN void contacts_app_load_styling (ContactsApp* self);
static void contacts_app_create_actions (ContactsApp* self);
static void contacts_app_real_activate (GApplication* base);
VALA_EXTERN gboolean contacts_settings_get_did_initial_setup (ContactsSettings* self);
static void contacts_app_run_setup (ContactsApp* self);
VALA_EXTERN GType contacts_setup_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsSetupWindow, g_object_unref)
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
VALA_EXTERN ContactsSetupWindow* contacts_setup_window_new (ContactsApp* app,
                                                ContactsStore* store);
VALA_EXTERN ContactsSetupWindow* contacts_setup_window_construct (GType object_type,
                                                      ContactsApp* app,
                                                      ContactsStore* store);
static void __lambda67_ (Block8Data* _data8_,
                  EdsfPersonaStore* selected_store);
VALA_EXTERN void contacts_settings_set_did_initial_setup (ContactsSettings* self,
                                              gboolean value);
static void ___lambda67__contacts_setup_window_setup_done (ContactsSetupWindow* _sender,
                                                    EdsfPersonaStore* selected_address_book,
                                                    gpointer self);
static gchar* _variant_get1 (GVariant* value);
static void contacts_app_finalize (GObject * obj);
static GType contacts_app_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry CONTACTS_APP_action_entries[6] = {{"quit", _g_application_quit_gsimple_action_activate_callback}, {"help", _contacts_app_show_help_gsimple_action_activate_callback}, {"about", _contacts_app_show_about_gsimple_action_activate_callback}, {"change-book", _contacts_app_change_address_book_gsimple_action_activate_callback}, {"online-accounts", _contacts_app_online_accounts_gsimple_action_activate_callback}, {"show-contact", _contacts_app_on_show_contact_gsimple_action_activate_callback, "s"}};
static const GOptionEntry CONTACTS_APP_options[5] = {{"email", 'e', (gint) 0, G_OPTION_ARG_STRING, NULL, N_ ("Show contact with this email address")}, {"individual", 'i', (gint) 0, G_OPTION_ARG_STRING, NULL, N_ ("Show contact with this individual id")}, {"search", 's', (gint) 0, G_OPTION_ARG_STRING, NULL, N_ ("Show contacts with the given filter")}, {"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Show the current version of Contacts")}, {0}};

static inline gpointer
contacts_app_get_instance_private (ContactsApp* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsApp_private_offset);
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}

static void
_contacts_app_show_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	contacts_app_show_help ((ContactsApp*) self);
}

static void
_contacts_app_show_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	contacts_app_show_about ((ContactsApp*) self);
}

static void
_contacts_app_change_address_book_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	contacts_app_change_address_book ((ContactsApp*) self);
}

static void
_contacts_app_online_accounts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	contacts_app_online_accounts ((ContactsApp*) self);
}

static void
_contacts_app_on_show_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	contacts_app_on_show_contact ((ContactsApp*) self, action, parameter);
}

ContactsApp*
contacts_app_construct (GType object_type)
{
	ContactsApp * self = NULL;
	ContactsSettings* _tmp0_;
	self = (ContactsApp*) g_object_new (object_type, "application-id", APP_ID, "resource-base-path", "/org/gnome/Contacts", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	_tmp0_ = contacts_settings_new (self);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	g_application_add_main_option_entries ((GApplication*) self, CONTACTS_APP_options);
	return self;
}

ContactsApp*
contacts_app_new (void)
{
	return contacts_app_construct (CONTACTS_TYPE_APP);
}

static gpointer
_g_variant_dict_ref0 (gpointer self)
{
	return self ? g_variant_dict_ref (self) : NULL;
}

static gint
contacts_app_real_command_line (GApplication* base,
                                GApplicationCommandLine* command_line)
{
	ContactsApp * self;
	GVariantDict* options = NULL;
	GVariantDict* _tmp0_;
	GVariantDict* _tmp1_;
	GVariantDict* _tmp2_;
	gint result;
	self = (ContactsApp*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = g_application_command_line_get_options_dict (command_line);
	_tmp1_ = _g_variant_dict_ref0 (_tmp0_);
	options = _tmp1_;
	g_application_activate ((GApplication*) self);
	_tmp2_ = options;
	if (g_variant_dict_contains (_tmp2_, "individual")) {
		GVariant* individual = NULL;
		GVariantDict* _tmp3_;
		const GVariantType* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		_tmp3_ = options;
		_tmp4_ = G_VARIANT_TYPE_STRING;
		_tmp5_ = g_variant_dict_lookup_value (_tmp3_, "individual", _tmp4_);
		individual = _tmp5_;
		_tmp6_ = individual;
		if (_tmp6_ != NULL) {
			GVariant* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = individual;
			_tmp8_ = g_variant_get_string (_tmp7_, NULL);
			contacts_app_show_individual (self, _tmp8_, NULL, NULL);
		}
		_g_variant_unref0 (individual);
	} else {
		GVariantDict* _tmp9_;
		_tmp9_ = options;
		if (g_variant_dict_contains (_tmp9_, "email")) {
			GVariant* email = NULL;
			GVariantDict* _tmp10_;
			const GVariantType* _tmp11_;
			GVariant* _tmp12_;
			GVariant* _tmp13_;
			_tmp10_ = options;
			_tmp11_ = G_VARIANT_TYPE_STRING;
			_tmp12_ = g_variant_dict_lookup_value (_tmp10_, "email", _tmp11_);
			email = _tmp12_;
			_tmp13_ = email;
			if (_tmp13_ != NULL) {
				GVariant* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = email;
				_tmp15_ = g_variant_get_string (_tmp14_, NULL);
				contacts_app_show_by_email (self, _tmp15_, NULL, NULL);
			}
			_g_variant_unref0 (email);
		} else {
			GVariantDict* _tmp16_;
			_tmp16_ = options;
			if (g_variant_dict_contains (_tmp16_, "search")) {
				GVariant* search_term = NULL;
				GVariantDict* _tmp17_;
				const GVariantType* _tmp18_;
				GVariant* _tmp19_;
				GVariant* _tmp20_;
				_tmp17_ = options;
				_tmp18_ = G_VARIANT_TYPE_STRING;
				_tmp19_ = g_variant_dict_lookup_value (_tmp17_, "search", _tmp18_);
				search_term = _tmp19_;
				_tmp20_ = search_term;
				if (_tmp20_ != NULL) {
					GVariant* _tmp21_;
					const gchar* _tmp22_;
					_tmp21_ = search_term;
					_tmp22_ = g_variant_get_string (_tmp21_, NULL);
					contacts_app_show_search (self, _tmp22_);
				}
				_g_variant_unref0 (search_term);
			}
		}
	}
	result = 0;
	_g_variant_dict_unref0 (options);
	return result;
}

static gint
contacts_app_real_handle_local_options (GApplication* base,
                                        GVariantDict* options)
{
	ContactsApp * self;
	gint result;
	self = (ContactsApp*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%s %s\n", PACKAGE_NAME, PACKAGE_VERSION);
		result = 0;
		return result;
	}
	result = -1;
	return result;
}

void
contacts_app_show_contact (ContactsApp* self,
                           FolksIndividual* individual)
{
	ContactsMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	contacts_main_window_set_shown_contact (_tmp0_, individual);
}

static void
contacts_app_show_individual_data_free (gpointer _data)
{
	ContactsAppShowIndividualData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowIndividualData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
contacts_app_show_individual (ContactsApp* self,
                              const gchar* id,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	ContactsAppShowIndividualData* _data_;
	ContactsApp* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_data_ = g_slice_new0 (ContactsAppShowIndividualData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_app_show_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	contacts_app_show_individual_co (_data_);
}

void
contacts_app_show_individual_finish (ContactsApp* self,
                                     GAsyncResult* _res_)
{
	ContactsAppShowIndividualData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ContactsApp* self;
		self = _data2_->self;
		_g_free0 (_data2_->id);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
___lambda69_ (Block2Data* _data2_)
{
	ContactsApp* self;
	self = _data2_->self;
	contacts_app_show_individual_ready (self, _data2_->id, NULL, NULL);
}

static void
____lambda69__contacts_store_quiescent (ContactsStore* _sender,
                                        gpointer self)
{
	___lambda69_ (self);
}

static gboolean
contacts_app_show_individual_co (ContactsAppShowIndividualData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data2_->id);
	_data_->_data2_->id = _data_->id;
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->contacts_store;
	_data_->_tmp1_ = contacts_store_get_is_quiescent (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_) {
		contacts_app_show_individual_ready (_data_->self, _data_->_data2_->id, NULL, NULL);
	} else {
		_data_->_tmp3_ = _data_->self->priv->contacts_store;
		g_signal_connect_data (_data_->_tmp3_, "quiescent", (GCallback) ____lambda69__contacts_store_quiescent, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
	}
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
contacts_app_show_individual_ready_data_free (gpointer _data)
{
	ContactsAppShowIndividualReadyData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowIndividualReadyData, _data_);
}

static void
contacts_app_show_individual_ready (ContactsApp* self,
                                    const gchar* id,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	ContactsAppShowIndividualReadyData* _data_;
	ContactsApp* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_data_ = g_slice_new0 (ContactsAppShowIndividualReadyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_app_show_individual_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	contacts_app_show_individual_ready_co (_data_);
}

static void
contacts_app_show_individual_ready_finish (ContactsApp* self,
                                           GAsyncResult* _res_)
{
	ContactsAppShowIndividualReadyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
contacts_app_show_individual_ready_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	ContactsAppShowIndividualReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_show_individual_ready_co (_data_);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ContactsApp* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda68_ (Block3Data* _data3_,
              gint _)
{
	ContactsApp* self;
	GtkMessageDialog* _tmp0_;
	self = _data3_->self;
	_tmp0_ = _data3_->dialog;
	g_signal_emit_by_name ((GtkDialog*) _tmp0_, "close");
}

static void
____lambda68__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda68_ (self, response_id);
}

static gboolean
contacts_app_show_individual_ready_co (ContactsAppShowIndividualReadyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->contact = NULL;
	{
		_data_->_tmp1_ = _data_->self->priv->contacts_store;
		_data_->_tmp2_ = contacts_store_get_aggregator (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_state_ = 1;
		folks_individual_aggregator_look_up_individual (_data_->_tmp3_, _data_->id, contacts_app_show_individual_ready_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = folks_individual_aggregator_look_up_individual_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->contact);
		_data_->contact = _data_->_tmp5_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		g_debug ("contacts-app.vala:105: Couldn't look up individual");
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->contact);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->contact;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->contact;
		contacts_app_show_contact (_data_->self, _data_->_tmp7_);
	} else {
		_data_->_data3_ = g_slice_new0 (Block3Data);
		_data_->_data3_->_ref_count_ = 1;
		_data_->_data3_->self = g_object_ref (_data_->self);
		_data_->_tmp8_ = _data_->self->priv->window;
		_data_->_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data_->_tmp8_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _ ("No contact with id %s found"), _data_->id);
		g_object_ref_sink (_data_->_tmp9_);
		_data_->_data3_->dialog = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->_data3_->dialog;
		gtk_window_set_title ((GtkWindow*) _data_->_tmp10_, _ ("Contact not found"));
		_data_->_tmp11_ = _data_->_data3_->dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp11_, "response", (GCallback) ____lambda68__gtk_dialog_response, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
		_data_->_tmp12_ = _data_->_data3_->dialog;
		gtk_widget_show ((GtkWidget*) _data_->_tmp12_);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
	}
	_g_object_unref0 (_data_->contact);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ContactsApp* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda60_ (Block4Data* _data4_,
             gint _)
{
	ContactsApp* self;
	self = _data4_->self;
	g_signal_emit_by_name ((GtkDialog*) _data4_->dialog, "close");
}

static void
___lambda60__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda60_ (self, response_id);
}

void
contacts_app_change_address_book (ContactsApp* self)
{
	Block4Data* _data4_;
	ContactsStore* _tmp0_;
	ContactsMainWindow* _tmp1_;
	ContactsAddressbookDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->contacts_store;
	_tmp1_ = self->priv->window;
	_tmp2_ = contacts_addressbook_dialog_new (_tmp0_, (GtkWindow*) _tmp1_);
	g_object_ref_sink (_tmp2_);
	_data4_->dialog = _tmp2_;
	g_signal_connect_data ((GtkDialog*) _data4_->dialog, "response", (GCallback) ___lambda60__gtk_dialog_response, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data4_->dialog);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

void
contacts_app_online_accounts (ContactsApp* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GDBusProxy* proxy = NULL;
		GDBusProxy* _tmp0_;
		GVariantBuilder* builder = NULL;
		GVariantType* _tmp1_;
		GVariantType* _tmp2_;
		GVariantBuilder* _tmp3_;
		GVariantBuilder* _tmp4_;
		GVariantBuilder* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		GVariant* param = NULL;
		GVariant* _tmp8_;
		GVariantType* _tmp9_;
		GVariantType* _tmp10_;
		GVariantBuilder* _tmp11_;
		GVariant* _tmp12_;
		GVariant* _tmp13_;
		GVariant* _tmp14_;
		GVariant** _tmp15_;
		GVariant** _tmp16_;
		gint _tmp16__length1;
		GVariant* _tmp17_;
		GVariantType* _tmp18_;
		GVariantType* _tmp19_;
		GVariant** _tmp20_;
		GVariant** _tmp21_;
		gint _tmp21__length1;
		GVariant* _tmp22_;
		GVariant** _tmp23_;
		GVariant** _tmp24_;
		gint _tmp24__length1;
		GVariant* _tmp25_;
		GVariant* _tmp26_;
		GDBusProxy* _tmp27_;
		GVariant* _tmp28_;
		GVariant* _tmp29_;
		GVariant* _tmp30_;
		_tmp0_ = g_dbus_proxy_new_for_bus_sync (G_BUS_TYPE_SESSION, G_DBUS_PROXY_FLAGS_NONE, NULL, "org.gnome.Settings", "/org/gnome/Settings", "org.gtk.Actions", NULL, &_inner_error0_);
		proxy = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = g_variant_type_new ("av");
		_tmp2_ = _tmp1_;
		_tmp3_ = g_variant_builder_new (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_variant_type_free0 (_tmp2_);
		builder = _tmp4_;
		_tmp5_ = builder;
		_tmp6_ = g_variant_new_string ("");
		g_variant_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		g_variant_builder_add (_tmp5_, "v", _tmp7_, NULL);
		_g_variant_unref0 (_tmp7_);
		_tmp8_ = g_variant_new_string ("launch-panel");
		g_variant_ref_sink (_tmp8_);
		_tmp9_ = g_variant_type_new ("v");
		_tmp10_ = _tmp9_;
		_tmp11_ = builder;
		_tmp12_ = g_variant_new ("(sav)", "online-accounts", _tmp11_, NULL);
		g_variant_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_variant_new ("v", _tmp13_, NULL);
		g_variant_ref_sink (_tmp14_);
		_tmp15_ = g_new0 (GVariant*, 1 + 1);
		_tmp15_[0] = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp16__length1 = 1;
		_tmp17_ = g_variant_new_array (_tmp10_, _tmp16_, 1);
		g_variant_ref_sink (_tmp17_);
		_tmp18_ = g_variant_type_new ("{sv}");
		_tmp19_ = _tmp18_;
		_tmp20_ = g_new0 (GVariant*, 0 + 1);
		_tmp21_ = _tmp20_;
		_tmp21__length1 = 0;
		_tmp22_ = g_variant_new_array (_tmp19_, _tmp21_, 0);
		g_variant_ref_sink (_tmp22_);
		_tmp23_ = g_new0 (GVariant*, 3 + 1);
		_tmp23_[0] = _tmp8_;
		_tmp23_[1] = _tmp17_;
		_tmp23_[2] = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp24__length1 = 3;
		_tmp25_ = g_variant_new_tuple (_tmp24_, 3);
		g_variant_ref_sink (_tmp25_);
		_tmp26_ = _tmp25_;
		_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_variant_unref), NULL);
		_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_variant_unref), NULL);
		_g_variant_type_free0 (_tmp19_);
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_variant_unref), NULL);
		_g_variant_unref0 (_tmp13_);
		_g_variant_type_free0 (_tmp10_);
		param = _tmp26_;
		_tmp27_ = proxy;
		_tmp28_ = param;
		_tmp29_ = g_dbus_proxy_call_sync (_tmp27_, "Activate", _tmp28_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error0_);
		_tmp30_ = _tmp29_;
		_g_variant_unref0 (_tmp30_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_variant_unref0 (param);
			_g_variant_builder_unref0 (builder);
			_g_object_unref0 (proxy);
			goto __catch0_g_error;
		}
		_g_variant_unref0 (param);
		_g_variant_builder_unref0 (builder);
		_g_object_unref0 (proxy);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_warning ("contacts-app.vala:147: Couldn't open online-accounts: %s", _tmp32_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
contacts_app_show_help (ContactsApp* self)
{
	ContactsMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_show_uri ((GtkWindow*) _tmp0_, "help:gnome-help/contacts", (guint32) GDK_CURRENT_TIME);
}

void
contacts_app_show_about (ContactsApp* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint authors_length1;
	gint _authors_size_;
	gchar** artists = NULL;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint artists_length1;
	gint _artists_size_;
	ContactsMainWindow* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Alexander Larsson <alexl@redhat.com>");
	_tmp1_ = g_strdup ("Erick Pérez Castellanos <erick.red@gmail.com>");
	_tmp2_ = g_strdup ("Niels De Graef <nielsdegraef@gmail.com>");
	_tmp3_ = g_strdup ("Julian Sparber <jsparber@gnome.org>");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	authors = _tmp4_;
	authors_length1 = 4;
	_authors_size_ = authors_length1;
	_tmp5_ = g_strdup ("Allan Day <allanpday@gmail.com>");
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	artists = _tmp6_;
	artists_length1 = 1;
	_artists_size_ = artists_length1;
	_tmp7_ = self->priv->window;
	gtk_show_about_dialog ((GtkWindow*) _tmp7_, "artists", artists, "authors", authors, "translator-credits", _ ("translator-credits"), "title", _ ("About GNOME Contacts"), "comments", _ ("Contact Management Application"), "copyright", _ ("© 2011 Red Hat, Inc.\n© 2011-2020 The Contacts Developers"), "license-type", GTK_LICENSE_GPL_2_0, "logo-icon-name", APP_ID, "version", PACKAGE_VERSION, "website", "https://wiki.gnome.org/Apps/Contacts", "wrap-license", TRUE, NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static void
contacts_app_show_by_email_data_free (gpointer _data)
{
	ContactsAppShowByEmailData* _data_;
	_data_ = _data;
	_g_free0 (_data_->email_address);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowByEmailData, _data_);
}

void
contacts_app_show_by_email (ContactsApp* self,
                            const gchar* email_address,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	ContactsAppShowByEmailData* _data_;
	ContactsApp* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (email_address != NULL);
	_data_ = g_slice_new0 (ContactsAppShowByEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_app_show_by_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (email_address);
	_g_free0 (_data_->email_address);
	_data_->email_address = _tmp1_;
	contacts_app_show_by_email_co (_data_);
}

void
contacts_app_show_by_email_finish (ContactsApp* self,
                                   GAsyncResult* _res_)
{
	ContactsAppShowByEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
contacts_app_show_by_email_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	ContactsAppShowByEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_show_by_email_co (_data_);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		ContactsApp* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda70_ (Block5Data* _data5_,
              gint _)
{
	ContactsApp* self;
	GtkMessageDialog* _tmp0_;
	self = _data5_->self;
	_tmp0_ = _data5_->dialog;
	g_signal_emit_by_name ((GtkDialog*) _tmp0_, "close");
}

static void
____lambda70__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda70_ (self, response_id);
}

static gboolean
contacts_app_show_by_email_co (ContactsAppShowByEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("email-addresses");
	_data_->_tmp1_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp1_[0] = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp2__length1 = 1;
	_data_->_tmp3_ = folks_simple_query_new (_data_->email_address, _data_->_tmp2_, 1);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp2_ = (_vala_array_free (_data_->_tmp2_, _data_->_tmp2__length1, (GDestroyNotify) g_free), NULL);
	_data_->query = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->contacts_store;
	_data_->_tmp6_ = _data_->query;
	_data_->_state_ = 1;
	contacts_store_find_contact (_data_->_tmp5_, (FolksQuery*) _data_->_tmp6_, contacts_app_show_by_email_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = contacts_store_find_contact_finish (_data_->_tmp5_, _data_->_res_);
	_data_->individual = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->individual;
	if (_data_->_tmp8_ != NULL) {
		_data_->_tmp9_ = _data_->individual;
		contacts_app_show_contact (_data_->self, _data_->_tmp9_);
	} else {
		_data_->_data5_ = g_slice_new0 (Block5Data);
		_data_->_data5_->_ref_count_ = 1;
		_data_->_data5_->self = g_object_ref (_data_->self);
		_data_->_tmp10_ = _data_->self->priv->window;
		_data_->_tmp11_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data_->_tmp10_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _ ("No contact with email address %s found"), _data_->email_address);
		g_object_ref_sink (_data_->_tmp11_);
		_data_->_data5_->dialog = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->_data5_->dialog;
		gtk_window_set_title ((GtkWindow*) _data_->_tmp12_, _ ("Contact not found"));
		_data_->_tmp13_ = _data_->_data5_->dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp13_, "response", (GCallback) ____lambda70__gtk_dialog_response, block5_data_ref (_data_->_data5_), (GClosureNotify) block5_data_unref, 0);
		_data_->_tmp14_ = _data_->_data5_->dialog;
		gtk_widget_show ((GtkWidget*) _data_->_tmp14_);
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
	}
	_g_object_unref0 (_data_->individual);
	_g_object_unref0 (_data_->query);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ContactsApp* self;
		self = _data6_->self;
		_g_free0 (_data6_->query);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
___lambda71_ (Block6Data* _data6_)
{
	ContactsApp* self;
	ContactsMainWindow* _tmp0_;
	self = _data6_->self;
	_tmp0_ = self->priv->window;
	contacts_main_window_show_search (_tmp0_, _data6_->query);
}

static void
____lambda71__contacts_store_quiescent (ContactsStore* _sender,
                                        gpointer self)
{
	___lambda71_ (self);
}

void
contacts_app_show_search (ContactsApp* self,
                          const gchar* query)
{
	Block6Data* _data6_;
	gchar* _tmp0_;
	ContactsStore* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = g_strdup (query);
	_g_free0 (_data6_->query);
	_data6_->query = _tmp0_;
	_tmp1_ = self->priv->contacts_store;
	_tmp2_ = contacts_store_get_is_quiescent (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		ContactsMainWindow* _tmp4_;
		_tmp4_ = self->priv->window;
		contacts_main_window_show_search (_tmp4_, _data6_->query);
	} else {
		ContactsStore* _tmp5_;
		_tmp5_ = self->priv->contacts_store;
		g_signal_connect_data (_tmp5_, "quiescent", (GCallback) ____lambda71__contacts_store_quiescent, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, G_CONNECT_AFTER);
	}
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
contacts_app_create_window (ContactsApp* self)
{
	ContactsMainWindow* win = NULL;
	ContactsSettings* _tmp0_;
	ContactsStore* _tmp1_;
	ContactsMainWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->contacts_store;
	_tmp2_ = contacts_main_window_new (_tmp0_, self, _tmp1_);
	g_object_ref_sink (_tmp2_);
	win = _tmp2_;
	gtk_widget_show ((GtkWidget*) win);
	self->priv->window = win;
	contacts_app_show_contact_list (self);
	_g_object_unref0 (win);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ContactsApp* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda61_ (Block7Data* _data7_)
{
	ContactsApp* self;
	ContactsMainWindow* _tmp0_;
	self = _data7_->self;
	g_source_remove (_data7_->timeout_id);
	g_debug ("contacts-app.vala:224: Got quiescent in time. Showing contact list");
	_tmp0_ = self->priv->window;
	contacts_main_window_show_contact_list (_tmp0_);
}

static void
___lambda61__contacts_store_quiescent (ContactsStore* _sender,
                                       gpointer self)
{
	__lambda61_ (self);
}

static gboolean
__lambda62_ (Block7Data* _data7_)
{
	ContactsApp* self;
	ContactsStore* _tmp0_;
	ContactsMainWindow* _tmp1_;
	gboolean result;
	self = _data7_->self;
	_tmp0_ = self->priv->contacts_store;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data7_->quiescence_id);
	g_debug ("contacts-app.vala:232: Didn't achieve quiescence in time! Showing cont" \
"act list anyway");
	_tmp1_ = self->priv->window;
	contacts_main_window_show_contact_list (_tmp1_);
	result = FALSE;
	return result;
}

static gboolean
___lambda62__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda62_ (self);
	return result;
}

static void
contacts_app_show_contact_list (ContactsApp* self)
{
	Block7Data* _data7_;
	ContactsStore* _tmp0_;
	gulong _tmp1_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->timeout_id = (guint) 0;
	_tmp0_ = self->priv->contacts_store;
	_tmp1_ = g_signal_connect_data (_tmp0_, "quiescent", (GCallback) ___lambda61__contacts_store_quiescent, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_data7_->quiescence_id = _tmp1_;
	_data7_->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) CONTACTS_APP_LOADING_TIMEOUT, ___lambda62__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
contacts_app_real_startup (GApplication* base)
{
	ContactsApp * self;
	ContactsStore* _tmp0_;
	self = (ContactsApp*) base;
	if (!contacts_ensure_eds_accounts (TRUE)) {
		g_application_quit ((GApplication*) self);
	}
	_tmp0_ = contacts_store_new ();
	_g_object_unref0 (self->priv->contacts_store);
	self->priv->contacts_store = _tmp0_;
	G_APPLICATION_CLASS (contacts_app_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	contacts_app_load_styling (self);
	contacts_app_create_actions (self);
}

static void
contacts_app_create_actions (ContactsApp* self)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	g_action_map_add_action_entries ((GActionMap*) self, CONTACTS_APP_action_entries, (gint) G_N_ELEMENTS (CONTACTS_APP_action_entries), self);
	_tmp0_ = g_strdup ("F1");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp2_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = g_strdup ("<Control>q");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp5_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
}

void
contacts_app_load_styling (ContactsApp* self)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GdkDisplay* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	gtk_css_provider_load_from_resource (provider, "/org/gnome/Contacts/ui/style.css");
	_tmp1_ = gdk_display_get_default ();
	gtk_style_context_add_provider_for_display (_tmp1_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (provider);
}

static void
contacts_app_real_activate (GApplication* base)
{
	ContactsApp * self;
	ContactsSettings* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (ContactsApp*) base;
	_tmp0_ = self->priv->settings;
	_tmp1_ = contacts_settings_get_did_initial_setup (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		contacts_app_create_window (self);
	} else {
		contacts_app_run_setup (self);
	}
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		ContactsApp* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->setup_window);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda67_ (Block8Data* _data8_,
             EdsfPersonaStore* selected_store)
{
	ContactsApp* self;
	ESourceRegistry* _tmp0_;
	ESource* _tmp1_;
	ESource* _tmp2_;
	ContactsSettings* _tmp3_;
	self = _data8_->self;
	g_return_if_fail (selected_store != NULL);
	gtk_window_destroy ((GtkWindow*) _data8_->setup_window);
	_tmp0_ = contacts_eds_source_registry;
	_tmp1_ = edsf_persona_store_get_source (selected_store);
	_tmp2_ = _tmp1_;
	e_source_registry_set_default_address_book (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->settings;
	contacts_settings_set_did_initial_setup (_tmp3_, TRUE);
	g_simple_action_set_enabled (_data8_->change_book_action, TRUE);
	contacts_app_create_window (self);
}

static void
___lambda67__contacts_setup_window_setup_done (ContactsSetupWindow* _sender,
                                               EdsfPersonaStore* selected_address_book,
                                               gpointer self)
{
	__lambda67_ (self, selected_address_book);
}

static void
contacts_app_run_setup (ContactsApp* self)
{
	Block8Data* _data8_;
	GAction* _tmp0_;
	ContactsStore* _tmp1_;
	ContactsSetupWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	g_debug ("contacts-app.vala:273: Running initial setup");
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "change-book");
	_data8_->change_book_action = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL;
	g_simple_action_set_enabled (_data8_->change_book_action, FALSE);
	_tmp1_ = self->priv->contacts_store;
	_tmp2_ = contacts_setup_window_new (self, _tmp1_);
	g_object_ref_sink (_tmp2_);
	_data8_->setup_window = _tmp2_;
	g_signal_connect_data (_data8_->setup_window, "setup-done", (GCallback) ___lambda67__contacts_setup_window_setup_done, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data8_->setup_window);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static gchar*
_variant_get1 (GVariant* value)
{
	if (value && g_variant_is_of_type (value, G_VARIANT_TYPE_STRING)) {
		return g_variant_dup_string (value, NULL);
	} else {
		return NULL;
	}
}

static void
contacts_app_on_show_contact (ContactsApp* self,
                              GSimpleAction* action,
                              GVariant* param)
{
	gchar* individual = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_application_activate ((GApplication*) self);
	_tmp0_ = _variant_get1 (param);
	individual = _tmp0_;
	_tmp1_ = individual;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = individual;
		contacts_app_show_individual (self, _tmp2_, NULL, NULL);
	}
	_g_free0 (individual);
}

static void
contacts_app_class_init (ContactsAppClass * klass,
                         gpointer klass_data)
{
	contacts_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsApp_private_offset);
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) contacts_app_real_command_line;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) contacts_app_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) contacts_app_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) contacts_app_real_activate;
	G_OBJECT_CLASS (klass)->finalize = contacts_app_finalize;
}

static void
contacts_app_instance_init (ContactsApp * self,
                            gpointer klass)
{
	self->priv = contacts_app_get_instance_private (self);
}

static void
contacts_app_finalize (GObject * obj)
{
	ContactsApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_APP, ContactsApp);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->contacts_store);
	G_OBJECT_CLASS (contacts_app_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsApp), 0, (GInstanceInitFunc) contacts_app_instance_init, NULL };
	GType contacts_app_type_id;
	contacts_app_type_id = g_type_register_static (adw_application_get_type (), "ContactsApp", &g_define_type_info, 0);
	ContactsApp_private_offset = g_type_add_instance_private (contacts_app_type_id, sizeof (ContactsAppPrivate));
	return contacts_app_type_id;
}

GType
contacts_app_get_type (void)
{
	static volatile gsize contacts_app_type_id__once = 0;
	if (g_once_init_enter (&contacts_app_type_id__once)) {
		GType contacts_app_type_id;
		contacts_app_type_id = contacts_app_get_type_once ();
		g_once_init_leave (&contacts_app_type_id__once, contacts_app_type_id);
	}
	return contacts_app_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

