/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 98 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQPointF.cpp"

#line 26 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQPointF.cpp"


PyDoc_STRVAR(doc_QPointF_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QPointF_isNull(PyObject *, PyObject *);}
static PyObject *meth_QPointF_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPointF, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPointF, sipName_isNull, doc_QPointF_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPointF_x, "x(self) -> float");

extern "C" {static PyObject *meth_QPointF_x(PyObject *, PyObject *);}
static PyObject *meth_QPointF_x(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPointF, &sipCpp))
        {
             ::qreal sipRes;

            sipRes = sipCpp->x();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPointF, sipName_x, doc_QPointF_x);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPointF_y, "y(self) -> float");

extern "C" {static PyObject *meth_QPointF_y(PyObject *, PyObject *);}
static PyObject *meth_QPointF_y(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPointF, &sipCpp))
        {
             ::qreal sipRes;

            sipRes = sipCpp->y();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPointF, sipName_y, doc_QPointF_y);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPointF_setX, "setX(self, float)");

extern "C" {static PyObject *meth_QPointF_setX(PyObject *, PyObject *);}
static PyObject *meth_QPointF_setX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qreal a0;
         ::QPointF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QPointF, &sipCpp, &a0))
        {
            sipCpp->setX(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPointF, sipName_setX, doc_QPointF_setX);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPointF_setY, "setY(self, float)");

extern "C" {static PyObject *meth_QPointF_setY(PyObject *, PyObject *);}
static PyObject *meth_QPointF_setY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qreal a0;
         ::QPointF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QPointF, &sipCpp, &a0))
        {
            sipCpp->setY(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPointF, sipName_setY, doc_QPointF_setY);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPointF_toPoint, "toPoint(self) -> QPoint");

extern "C" {static PyObject *meth_QPointF_toPoint(PyObject *, PyObject *);}
static PyObject *meth_QPointF_toPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPointF, &sipCpp))
        {
             ::QPoint*sipRes;

            sipRes = new  ::QPoint(sipCpp->toPoint());

            return sipConvertFromNewType(sipRes,sipType_QPoint,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPointF, sipName_toPoint, doc_QPointF_toPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPointF_manhattanLength, "manhattanLength(self) -> float");

extern "C" {static PyObject *meth_QPointF_manhattanLength(PyObject *, PyObject *);}
static PyObject *meth_QPointF_manhattanLength(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPointF, &sipCpp))
        {
             ::qreal sipRes;

            sipRes = sipCpp->manhattanLength();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPointF, sipName_manhattanLength, doc_QPointF_manhattanLength);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPointF_dotProduct, "dotProduct(Union[QPointF, QPoint], Union[QPointF, QPoint]) -> float");

extern "C" {static PyObject *meth_QPointF_dotProduct(PyObject *, PyObject *);}
static PyObject *meth_QPointF_dotProduct(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF* a0;
        int a0State = 0;
        const  ::QPointF* a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1J1", sipType_QPointF, &a0, &a0State, sipType_QPointF, &a1, &a1State))
        {
             ::qreal sipRes;

            sipRes =  ::QPointF::dotProduct(*a0,*a1);
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);
            sipReleaseType(const_cast< ::QPointF *>(a1), sipType_QPointF, a1State);

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPointF, sipName_dotProduct, doc_QPointF_dotProduct);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPointF_transposed, "transposed(self) -> QPointF");

extern "C" {static PyObject *meth_QPointF_transposed(PyObject *, PyObject *);}
static PyObject *meth_QPointF_transposed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPointF, &sipCpp))
        {
             ::QPointF*sipRes;

            sipRes = new  ::QPointF(sipCpp->transposed());

            return sipConvertFromNewType(sipRes,sipType_QPointF,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPointF, sipName_transposed, doc_QPointF_transposed);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QPointF___eq__(PyObject *,PyObject *);}
static PyObject *slot_QPointF___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QPointF *sipCpp = reinterpret_cast< ::QPointF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPointF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QPointF, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, eq_slot, sipType_QPointF, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QPointF___ne__(PyObject *,PyObject *);}
static PyObject *slot_QPointF___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QPointF *sipCpp = reinterpret_cast< ::QPointF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPointF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QPointF, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, ne_slot, sipType_QPointF, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QPointF___add__(PyObject *,PyObject *);}
static PyObject *slot_QPointF___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF* a0;
        int a0State = 0;
        const  ::QPointF* a1;
        int a1State = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_QPointF, &a0, &a0State, sipType_QPointF, &a1, &a1State))
        {
             ::QPointF*sipRes;

            sipRes = new  ::QPointF((*a0 + *a1));
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);
            sipReleaseType(const_cast< ::QPointF *>(a1), sipType_QPointF, a1State);

            return sipConvertFromNewType(sipRes,sipType_QPointF,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QPointF___sub__(PyObject *,PyObject *);}
static PyObject *slot_QPointF___sub__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF* a0;
        int a0State = 0;
        const  ::QPointF* a1;
        int a1State = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_QPointF, &a0, &a0State, sipType_QPointF, &a1, &a1State))
        {
             ::QPointF*sipRes;

            sipRes = new  ::QPointF((*a0 - *a1));
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);
            sipReleaseType(const_cast< ::QPointF *>(a1), sipType_QPointF, a1State);

            return sipConvertFromNewType(sipRes,sipType_QPointF,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, sub_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QPointF___mul__(PyObject *,PyObject *);}
static PyObject *slot_QPointF___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF* a0;
        int a0State = 0;
         ::qreal a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1d", sipType_QPointF, &a0, &a0State, &a1))
        {
             ::QPointF*sipRes;

            sipRes = new  ::QPointF((*a0 * a1));
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            return sipConvertFromNewType(sipRes,sipType_QPointF,SIP_NULLPTR);
        }
    }

    {
         ::qreal a0;
        const  ::QPointF* a1;
        int a1State = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "dJ1", &a0, sipType_QPointF, &a1, &a1State))
        {
             ::QPointF*sipRes;

            sipRes = new  ::QPointF((a0 * *a1));
            sipReleaseType(const_cast< ::QPointF *>(a1), sipType_QPointF, a1State);

            return sipConvertFromNewType(sipRes,sipType_QPointF,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, mul_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QPointF___truediv__(PyObject *,PyObject *);}
static PyObject *slot_QPointF___truediv__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF* a0;
        int a0State = 0;
         ::qreal a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1d", sipType_QPointF, &a0, &a0State, &a1))
        {
             ::QPointF*sipRes;

            sipRes = new  ::QPointF((*a0 / a1));
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            return sipConvertFromNewType(sipRes,sipType_QPointF,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtCore, truediv_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QPointF___neg__(PyObject *);}
static PyObject *slot_QPointF___neg__(PyObject *sipSelf)
{
     ::QPointF *sipCpp = reinterpret_cast< ::QPointF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPointF));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
             ::QPointF*sipRes;

            sipRes = new  ::QPointF(-(*sipCpp));

            return sipConvertFromNewType(sipRes,sipType_QPointF,SIP_NULLPTR);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QPointF___pos__(PyObject *);}
static PyObject *slot_QPointF___pos__(PyObject *sipSelf)
{
     ::QPointF *sipCpp = reinterpret_cast< ::QPointF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPointF));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
             ::QPointF*sipRes;

            sipRes = new  ::QPointF(+(*sipCpp));

            return sipConvertFromNewType(sipRes,sipType_QPointF,SIP_NULLPTR);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QPointF___itruediv__(PyObject *,PyObject *);}
static PyObject *slot_QPointF___itruediv__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QPointF)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QPointF *sipCpp = reinterpret_cast< ::QPointF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPointF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qreal a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1d", &a0))
        {
            sipCpp-> ::QPointF::operator/=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QPointF___imul__(PyObject *,PyObject *);}
static PyObject *slot_QPointF___imul__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QPointF)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QPointF *sipCpp = reinterpret_cast< ::QPointF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPointF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::qreal a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1d", &a0))
        {
            sipCpp-> ::QPointF::operator*=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QPointF___isub__(PyObject *,PyObject *);}
static PyObject *slot_QPointF___isub__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QPointF)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QPointF *sipCpp = reinterpret_cast< ::QPointF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPointF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QPointF, &a0, &a0State))
        {
            sipCpp-> ::QPointF::operator-=(*a0);
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QPointF___iadd__(PyObject *,PyObject *);}
static PyObject *slot_QPointF___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QPointF)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QPointF *sipCpp = reinterpret_cast< ::QPointF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPointF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QPointF* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QPointF, &a0, &a0State))
        {
            sipCpp-> ::QPointF::operator+=(*a0);
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static int slot_QPointF___bool__(PyObject *);}
static int slot_QPointF___bool__(PyObject *sipSelf)
{
     ::QPointF *sipCpp = reinterpret_cast< ::QPointF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPointF));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 177 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qpoint.sip"
        sipRes = !sipCpp->isNull();
#line 717 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQPointF.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QPointF___repr__(PyObject *);}
static PyObject *slot_QPointF___repr__(PyObject *sipSelf)
{
     ::QPointF *sipCpp = reinterpret_cast< ::QPointF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QPointF));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 143 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qpoint.sip"
        if (sipCpp->isNull())
        {
        #if PY_MAJOR_VERSION >= 3
            sipRes = PyUnicode_FromString("PyQt5.QtCore.QPointF()");
        #else
            sipRes = PyString_FromString("PyQt5.QtCore.QPointF()");
        #endif
        }
        else
        {
            PyObject *x = PyFloat_FromDouble(sipCpp->x());
            PyObject *y = PyFloat_FromDouble(sipCpp->y());
        
            if (x && y)
            {
        #if PY_MAJOR_VERSION >= 3
                sipRes = PyUnicode_FromFormat("PyQt5.QtCore.QPointF(%R, %R)", x, y);
        #else
                sipRes = PyString_FromString("PyQt5.QtCore.QPointF(");
                PyString_ConcatAndDel(&sipRes, PyObject_Repr(x));
                PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
                PyString_ConcatAndDel(&sipRes, PyObject_Repr(y));
                PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
        #endif
            }
        
            Py_XDECREF(x);
            Py_XDECREF(y);
        }
#line 770 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQPointF.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QPointF(void *, int);}
static void release_QPointF(void *sipCppV, int)
{
    delete reinterpret_cast< ::QPointF *>(sipCppV);
}


extern "C" {static PyObject *pickle_QPointF(void *);}
static PyObject *pickle_QPointF(void *sipCppV)
{
     ::QPointF *sipCpp = reinterpret_cast< ::QPointF *>(sipCppV);
    PyObject *sipRes;

#line 134 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qpoint.sip"
    sipRes = Py_BuildValue((char *)"dd", sipCpp->x(), sipCpp->y());
#line 796 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQPointF.cpp"

    return sipRes;
}


extern "C" {static void *array_QPointF(Py_ssize_t);}
static void *array_QPointF(Py_ssize_t sipNrElem)
{
    return new  ::QPointF[sipNrElem];
}


extern "C" {static void array_delete_QPointF(void *);}
static void array_delete_QPointF(void *sipCpp)
{
    delete[] reinterpret_cast< ::QPointF *>(sipCpp);
}


extern "C" {static void assign_QPointF(void *, Py_ssize_t, void *);}
static void assign_QPointF(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QPointF *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QPointF *>(sipSrc);
}


extern "C" {static void *copy_QPointF(const void *, Py_ssize_t);}
static void *copy_QPointF(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QPointF(reinterpret_cast<const  ::QPointF *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QPointF(sipSimpleWrapper *);}
static void dealloc_QPointF(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QPointF(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QPointF(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QPointF(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::QPointF *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new  ::QPointF();

            return sipCpp;
        }
    }

    {
         ::qreal a0;
         ::qreal a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "dd", &a0, &a1))
        {
            sipCpp = new  ::QPointF(a0,a1);

            return sipCpp;
        }
    }

    {
        const  ::QPoint* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QPoint, &a0))
        {
            sipCpp = new  ::QPointF(*a0);

            return sipCpp;
        }
    }

    {
        const  ::QPointF* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QPointF, &a0, &a0State))
        {
            sipCpp = new  ::QPointF(*a0);
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static int convertTo_QPointF(PyObject *, void **, int *, PyObject *);}
static int convertTo_QPointF(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
     ::QPointF **sipCppPtr = reinterpret_cast< ::QPointF **>(sipCppPtrV);

#line 102 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtCore/qpoint.sip"
// Allow a QPoint whenever a QPointF is expected.  This is mainly to help source
// compatibility for Qt5.

if (sipIsErr == NULL)
    return (sipCanConvertToType(sipPy, sipType_QPointF, SIP_NO_CONVERTORS) ||
            sipCanConvertToType(sipPy, sipType_QPoint, 0));

if (sipCanConvertToType(sipPy, sipType_QPointF, SIP_NO_CONVERTORS))
{
    *sipCppPtr = reinterpret_cast<QPointF *>(sipConvertToType(sipPy, sipType_QPointF, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

    return 0;
}

int state;

QPoint *pt = reinterpret_cast<QPoint *>(sipConvertToType(sipPy, sipType_QPoint, 0, 0, &state, sipIsErr));

if (*sipIsErr)
{
    sipReleaseType(pt, sipType_QPoint, state);
    return 0;
}

*sipCppPtr = new QPointF(*pt);

sipReleaseType(pt, sipType_QPoint, state);

return sipGetState(sipTransferObj);
#line 929 "/build/pyqt5/src/PyQt5-5.15.7/build/QtCore/sipQtCoreQPointF.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QPointF[] = {
    {(void *)slot_QPointF___eq__, eq_slot},
    {(void *)slot_QPointF___ne__, ne_slot},
    {(void *)slot_QPointF___add__, add_slot},
    {(void *)slot_QPointF___sub__, sub_slot},
    {(void *)slot_QPointF___mul__, mul_slot},
    {(void *)slot_QPointF___truediv__, truediv_slot},
    {(void *)slot_QPointF___neg__, neg_slot},
    {(void *)slot_QPointF___pos__, pos_slot},
    {(void *)slot_QPointF___itruediv__, itruediv_slot},
    {(void *)slot_QPointF___imul__, imul_slot},
    {(void *)slot_QPointF___isub__, isub_slot},
    {(void *)slot_QPointF___iadd__, iadd_slot},
    {(void *)slot_QPointF___bool__, bool_slot},
    {(void *)slot_QPointF___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QPointF[] = {
    {sipName_dotProduct, meth_QPointF_dotProduct, METH_VARARGS, doc_QPointF_dotProduct},
    {sipName_isNull, meth_QPointF_isNull, METH_VARARGS, doc_QPointF_isNull},
    {sipName_manhattanLength, meth_QPointF_manhattanLength, METH_VARARGS, doc_QPointF_manhattanLength},
    {sipName_setX, meth_QPointF_setX, METH_VARARGS, doc_QPointF_setX},
    {sipName_setY, meth_QPointF_setY, METH_VARARGS, doc_QPointF_setY},
    {sipName_toPoint, meth_QPointF_toPoint, METH_VARARGS, doc_QPointF_toPoint},
    {sipName_transposed, meth_QPointF_transposed, METH_VARARGS, doc_QPointF_transposed},
    {sipName_x, meth_QPointF_x, METH_VARARGS, doc_QPointF_x},
    {sipName_y, meth_QPointF_y, METH_VARARGS, doc_QPointF_y}
};

PyDoc_STRVAR(doc_QPointF, "\1QPointF()\n"
"QPointF(float, float)\n"
"QPointF(QPoint)\n"
"QPointF(QPointF)");


static pyqt5ClassPluginDef plugin_QPointF = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtCore_QPointF = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QPointF,
        SIP_NULLPTR,
        &plugin_QPointF
    },
    {
        sipNameNr_QPointF,
        {0, 0, 1},
        9, methods_QPointF,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QPointF,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QPointF,
    init_type_QPointF,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QPointF,
    assign_QPointF,
    array_QPointF,
    copy_QPointF,
    release_QPointF,
    SIP_NULLPTR,
    convertTo_QPointF,
    SIP_NULLPTR,
    SIP_NULLPTR,
    pickle_QPointF,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QPointF,
    sizeof ( ::QPointF),
};
