"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateThumbPosition = exports.EUI_THUMB_SIZE = void 0;

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EUI_THUMB_SIZE = 16;
exports.EUI_THUMB_SIZE = EUI_THUMB_SIZE;

var calculateThumbPosition = function calculateThumbPosition(value, min, max, width) {
  var thumbSize = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : EUI_THUMB_SIZE;
  // Calculate the left position based on value
  var decimal = (value - min) / (max - min); // Must be between 0-100%

  var valuePosition = decimal <= 1 ? decimal : 1;
  valuePosition = valuePosition >= 0 ? valuePosition : 0;
  var trackWidth = width !== null && width !== void 0 ? width : 0;
  var thumbToTrackRatio = thumbSize / trackWidth;
  var trackPositionScale = (1 - thumbToTrackRatio) * 100;
  return valuePosition * trackPositionScale;
};

exports.calculateThumbPosition = calculateThumbPosition;