/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.jakartaee.Converter;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.StringManager;
import org.apache.tomcat.jakartaee.Util;
import org.apache.tomcat.jakartaee.bcel.classfile.ClassParser;
import org.apache.tomcat.jakartaee.bcel.classfile.Constant;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.jakartaee.bcel.classfile.JavaClass;

public class ClassConverter
implements Converter,
ClassFileTransformer {
    private static final Logger logger = Logger.getLogger(ClassConverter.class.getCanonicalName());
    private static final StringManager sm = StringManager.getManager(ClassConverter.class);
    protected final EESpecProfile profile;

    public ClassConverter() {
        this(EESpecProfile.TOMCAT);
    }

    public ClassConverter(EESpecProfile profile) {
        this.profile = profile;
    }

    public String toString() {
        return ClassConverter.class.getCanonicalName() + '[' + this.profile.toString() + ']';
    }

    @Override
    public boolean accepts(String filename) {
        String extension = Util.getExtension(filename);
        return "class".equals(extension);
    }

    @Override
    public void convert(String path, InputStream src, OutputStream dest, EESpecProfile profile) throws IOException {
        this.convertInternal(path, src, dest, profile, null);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(classfileBuffer);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.convertInternal(className, inputStream, outputStream, this.profile, loader);
        }
        catch (IOException e) {
            throw new IllegalClassFormatException(e.getLocalizedMessage());
        }
        return outputStream.toByteArray();
    }

    protected void convertInternal(String path, InputStream src, OutputStream dest, EESpecProfile profile, ClassLoader loader) throws IOException {
        ClassParser parser = new ClassParser(src, "unknown");
        JavaClass javaClass = parser.parse();
        boolean converted = false;
        Constant[] constantPool = javaClass.getConstantPool().getConstantPool();
        for (int i = 0; i < constantPool.length; ++i) {
            ConstantUtf8 c;
            String str;
            String newString;
            if (!(constantPool[i] instanceof ConstantUtf8) || (newString = profile.convert(str = (c = (ConstantUtf8)constantPool[i]).getBytes())) == str) continue;
            if (loader != null) {
                String[] split;
                for (String current : split = newString.split(";|<")) {
                    int pos = current.indexOf("jakarta/");
                    boolean dotMode = false;
                    if (pos < 0) {
                        pos = current.indexOf("jakarta.");
                        dotMode = true;
                    }
                    if (pos < 0) continue;
                    String resourceName = current.substring(pos);
                    if (dotMode) {
                        resourceName = resourceName.replace('.', '/');
                    }
                    if (loader.getResource(resourceName = resourceName + ".class") != null) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, sm.getString("classConverter.skipName", current.substring(pos).replace('/', '.')));
                    }
                    String originalFragment = dotMode ? current.replace("jakarta.", "javax.") : current.replace("jakarta/", "javax/");
                    newString = newString.replace(current, originalFragment);
                }
            }
            c = new ConstantUtf8(newString);
            constantPool[i] = c;
            converted = true;
        }
        if (logger.isLoggable(Level.FINE)) {
            if (converted) {
                logger.log(Level.FINE, sm.getString("classConverter.converted", path.replace('/', '.')));
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, sm.getString("classConverter.noConversion", path.replace('/', '.')));
            }
        }
        javaClass.dump(dest);
    }
}

