/* tracker-utils.c generated by valac 0.56.1, the Vala compiler
 * generated from tracker-utils.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdarg.h>
#include "libtracker-sparql/tracker-generated-no-checks.h"

#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

void uuid_generate (guchar* uuid);
void uuid_unparse_lower (guchar* uuid,
                         gchar* out);

/**
 * SECTION: tracker-misc
 * @short_description: General purpose utilities provided by the library
 * @title: Utilities
 * @stability: Stable
 * @include: tracker-sparql.h
 *
 * <para>
 * The libtracker-sparql utilities help in the creation of proper SPARQL queries.
 * </para>
 */
/**
 * tracker_sparql_escape_string:
 * @literal: a string to escape
 *
 * Escapes a string so that it can be used in a SPARQL query.
 *
 * Returns: a newly-allocated string with the escaped version of @literal.
 * The returned string should be freed with g_free() when no longer needed.
 *
 * Since: 0.10
 */
gchar*
tracker_sparql_escape_string (const gchar* literal)
{
	GString* str = NULL;
	GString* _tmp0_;
	gchar* p = NULL;
	GString* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* result;
#line 49 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	g_return_val_if_fail (literal != NULL, NULL);
#line 50 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	_tmp0_ = g_string_new ("");
#line 50 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	str = _tmp0_;
#line 56 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	p = (gchar*) literal;
#line 58 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	while (TRUE) {
#line 79 "tracker-utils.c"
		gchar* _tmp1_;
		gsize len = 0UL;
		gchar* _tmp2_;
		GString* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp15_;
#line 58 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		_tmp1_ = p;
#line 58 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		if (!((*_tmp1_) != '\0')) {
#line 58 "../tracker/src/libtracker-sparql/tracker-utils.vala"
			break;
#line 94 "tracker-utils.c"
		}
#line 59 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		_tmp2_ = p;
#line 59 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		len = strcspn ((const gchar*) _tmp2_, "\t\n\r\b\f\'\"\\");
#line 60 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		_tmp3_ = str;
#line 60 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		_tmp4_ = p;
#line 60 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		g_string_append_len (_tmp3_, (const gchar*) _tmp4_, (gssize) ((glong) len));
#line 61 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		_tmp5_ = p;
#line 61 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		p = _tmp5_ + len;
#line 63 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		_tmp6_ = p;
#line 63 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		switch (*_tmp6_) {
#line 63 "../tracker/src/libtracker-sparql/tracker-utils.vala"
			case '\t':
#line 116 "tracker-utils.c"
			{
				GString* _tmp7_;
#line 65 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				_tmp7_ = str;
#line 65 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				g_string_append (_tmp7_, "\\t");
#line 66 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				break;
#line 125 "tracker-utils.c"
			}
#line 63 "../tracker/src/libtracker-sparql/tracker-utils.vala"
			case '\n':
#line 129 "tracker-utils.c"
			{
				GString* _tmp8_;
#line 68 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				_tmp8_ = str;
#line 68 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				g_string_append (_tmp8_, "\\n");
#line 69 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				break;
#line 138 "tracker-utils.c"
			}
#line 63 "../tracker/src/libtracker-sparql/tracker-utils.vala"
			case '\r':
#line 142 "tracker-utils.c"
			{
				GString* _tmp9_;
#line 71 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				_tmp9_ = str;
#line 71 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				g_string_append (_tmp9_, "\\r");
#line 72 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				break;
#line 151 "tracker-utils.c"
			}
#line 63 "../tracker/src/libtracker-sparql/tracker-utils.vala"
			case '\b':
#line 155 "tracker-utils.c"
			{
				GString* _tmp10_;
#line 74 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				_tmp10_ = str;
#line 74 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				g_string_append (_tmp10_, "\\b");
#line 75 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				break;
#line 164 "tracker-utils.c"
			}
#line 63 "../tracker/src/libtracker-sparql/tracker-utils.vala"
			case '\f':
#line 168 "tracker-utils.c"
			{
				GString* _tmp11_;
#line 77 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				_tmp11_ = str;
#line 77 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				g_string_append (_tmp11_, "\\f");
#line 78 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				break;
#line 177 "tracker-utils.c"
			}
#line 63 "../tracker/src/libtracker-sparql/tracker-utils.vala"
			case '\'':
#line 181 "tracker-utils.c"
			{
				GString* _tmp12_;
#line 80 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				_tmp12_ = str;
#line 80 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				g_string_append (_tmp12_, "\\'");
#line 81 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				break;
#line 190 "tracker-utils.c"
			}
#line 63 "../tracker/src/libtracker-sparql/tracker-utils.vala"
			case '"':
#line 194 "tracker-utils.c"
			{
				GString* _tmp13_;
#line 83 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				_tmp13_ = str;
#line 83 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				g_string_append (_tmp13_, "\\\"");
#line 84 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				break;
#line 203 "tracker-utils.c"
			}
#line 63 "../tracker/src/libtracker-sparql/tracker-utils.vala"
			case '\\':
#line 207 "tracker-utils.c"
			{
				GString* _tmp14_;
#line 86 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				_tmp14_ = str;
#line 86 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				g_string_append (_tmp14_, "\\\\");
#line 87 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				break;
#line 216 "tracker-utils.c"
			}
			default:
			{
#line 89 "../tracker/src/libtracker-sparql/tracker-utils.vala"
				continue;
#line 222 "tracker-utils.c"
			}
		}
#line 92 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		_tmp15_ = p;
#line 92 "../tracker/src/libtracker-sparql/tracker-utils.vala"
		p = _tmp15_ + 1;
#line 229 "tracker-utils.c"
	}
#line 95 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	_tmp16_ = str;
#line 95 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	_tmp17_ = _tmp16_->str;
#line 95 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	_tmp18_ = g_strdup (_tmp17_);
#line 95 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	result = _tmp18_;
#line 95 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	_g_string_free0 (str);
#line 95 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	return result;
#line 243 "tracker-utils.c"
}

/**
 * tracker_sparql_get_uuid_urn:
 *
 * Generates a unique universal identifier to be used for urns
 * when inserting SPARQL into the database. The string returned is
 * in lower case and has the format "urn:uuid:&percnt;s" where
 * &percnt;s is the uuid generated.
 *
 * Returns: a newly-allocated string. The returned string should
 * be freed with g_free() when no longer needed.
 *
 * Since: 0.10
 */
gchar*
tracker_sparql_get_uuid_urn (void)
{
	guchar* base_uuid = NULL;
	guchar* _tmp0_;
	gint base_uuid_length1;
	gint _base_uuid_size_;
	gchar* lower = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
#line 118 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	_tmp0_ = g_new0 (guchar, 16);
#line 118 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	base_uuid = _tmp0_;
#line 118 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	base_uuid_length1 = 16;
#line 118 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	_base_uuid_size_ = base_uuid_length1;
#line 119 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	_tmp1_ = g_new0 (gchar, 37);
#line 119 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	lower = (gchar*) _tmp1_;
#line 121 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	uuid_generate (base_uuid);
#line 122 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	uuid_unparse_lower (base_uuid, (gchar*) lower);
#line 125 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	_tmp2_ = g_strdup_printf ("urn:uuid:%s", lower);
#line 125 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	result = _tmp2_;
#line 125 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	_g_free0 (lower);
#line 125 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	base_uuid = (g_free (base_uuid), NULL);
#line 125 "../tracker/src/libtracker-sparql/tracker-utils.vala"
	return result;
#line 296 "tracker-utils.c"
}

