/* source-manager.c generated by valac 0.56.2, the Vala compiler
 * generated from source-manager.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdarg.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SOURCE_MANAGER (source_manager_get_type ())
#define SOURCE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_MANAGER, SourceManager))
#define SOURCE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_MANAGER, SourceManagerClass))
#define IS_SOURCE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_MANAGER))
#define IS_SOURCE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_MANAGER))
#define SOURCE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_MANAGER, SourceManagerClass))

typedef struct _SourceManager SourceManager;
typedef struct _SourceManagerClass SourceManagerClass;
typedef struct _SourceManagerPrivate SourceManagerPrivate;

#define TYPE_SCHEMA_PATH_TREE (schema_path_tree_get_type ())
#define SCHEMA_PATH_TREE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_PATH_TREE, SchemaPathTree))
#define SCHEMA_PATH_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_PATH_TREE, SchemaPathTreeClass))
#define IS_SCHEMA_PATH_TREE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_PATH_TREE))
#define IS_SCHEMA_PATH_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_PATH_TREE))
#define SCHEMA_PATH_TREE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_PATH_TREE, SchemaPathTreeClass))

typedef struct _SchemaPathTree SchemaPathTree;
typedef struct _SchemaPathTreeClass SchemaPathTreeClass;
enum  {
	SOURCE_MANAGER_0_PROPERTY,
	SOURCE_MANAGER_CACHED_SCHEMAS_PROPERTY,
	SOURCE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* source_manager_properties[SOURCE_MANAGER_NUM_PROPERTIES];
#define _schema_path_tree_unref0(var) ((var == NULL) ? NULL : (var = (schema_path_tree_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _Block44Data Block44Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block45Data Block45Data;
enum  {
	SOURCE_MANAGER_PATHS_CHANGED_SIGNAL,
	SOURCE_MANAGER_NUM_SIGNALS
};
static guint source_manager_signals[SOURCE_MANAGER_NUM_SIGNALS] = {0};
typedef struct _SchemaPathTreePrivate SchemaPathTreePrivate;

#define TYPE_CACHED_SCHEMA_INFO (cached_schema_info_get_type ())
#define CACHED_SCHEMA_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CACHED_SCHEMA_INFO, CachedSchemaInfo))
#define CACHED_SCHEMA_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CACHED_SCHEMA_INFO, CachedSchemaInfoClass))
#define IS_CACHED_SCHEMA_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CACHED_SCHEMA_INFO))
#define IS_CACHED_SCHEMA_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CACHED_SCHEMA_INFO))
#define CACHED_SCHEMA_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CACHED_SCHEMA_INFO, CachedSchemaInfoClass))

typedef struct _CachedSchemaInfo CachedSchemaInfo;
typedef struct _CachedSchemaInfoClass CachedSchemaInfoClass;
typedef struct _CachedSchemaInfoPrivate CachedSchemaInfoPrivate;
#define _cached_schema_info_unref0(var) ((var == NULL) ? NULL : (var = (cached_schema_info_unref (var), NULL)))
typedef struct _Block46Data Block46Data;
typedef struct _Block47Data Block47Data;
typedef struct _ParamSpecSchemaPathTree ParamSpecSchemaPathTree;
typedef struct _ParamSpecCachedSchemaInfo ParamSpecCachedSchemaInfo;

struct _SourceManager {
	GObject parent_instance;
	SourceManagerPrivate * priv;
};

struct _SourceManagerClass {
	GObjectClass parent_class;
};

struct _SourceManagerPrivate {
	SchemaPathTree* _cached_schemas;
	GSettingsSchemaSource* settings_schema_source;
	gchar** previous_empty_schemas;
	gint previous_empty_schemas_length1;
	gint _previous_empty_schemas_size_;
	GHashTable* relocatable_schema_paths;
	GHashTable* startup_relocatable_schema_paths;
};

struct _Block44Data {
	int _ref_count_;
	SourceManager* self;
	gchar* schema_id;
};

struct _Block45Data {
	int _ref_count_;
	GHashTable* self;
	GFunc func;
	gpointer func_target;
};

struct _SchemaPathTree {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaPathTreePrivate * priv;
};

struct _SchemaPathTreeClass {
	GTypeClass parent_class;
	void (*finalize) (SchemaPathTree *self);
};

struct _SchemaPathTreePrivate {
	gchar* path_segment;
	GHashTable* schemas;
	GHashTable* subtrees;
	SchemaPathTree* wildcard_subtree;
};

struct _CachedSchemaInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CachedSchemaInfoPrivate * priv;
	GSettingsSchema* schema;
	gulong fingerprint;
	gboolean marked;
};

struct _CachedSchemaInfoClass {
	GTypeClass parent_class;
	void (*finalize) (CachedSchemaInfo *self);
};

struct _Block46Data {
	int _ref_count_;
	SchemaPathTree* self;
	gulong fingerprint;
	GSettingsSchema* schema;
	GHashTable* modified_path_specs;
};

struct _Block47Data {
	int _ref_count_;
	SchemaPathTree* self;
	gboolean modified;
};

struct _ParamSpecSchemaPathTree {
	GParamSpec parent_instance;
};

struct _ParamSpecCachedSchemaInfo {
	GParamSpec parent_instance;
};

static gint SourceManager_private_offset;
static gpointer source_manager_parent_class = NULL;
VALA_EXTERN gchar** configuration_editor_known_mappings;
VALA_EXTERN gint configuration_editor_known_mappings_length1;
VALA_EXTERN gint configuration_editor_known_mappings_length2;
VALA_EXTERN gchar** configuration_editor_internal_mappings;
VALA_EXTERN gint configuration_editor_internal_mappings_length1;
VALA_EXTERN gint configuration_editor_internal_mappings_length2;
static gint SchemaPathTree_private_offset;
static gpointer schema_path_tree_parent_class = NULL;
static gpointer cached_schema_info_parent_class = NULL;

VALA_EXTERN GType source_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceManager, g_object_unref)
VALA_EXTERN gpointer schema_path_tree_ref (gpointer instance);
VALA_EXTERN void schema_path_tree_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_schema_path_tree (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_schema_path_tree (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_schema_path_tree (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_schema_path_tree (const GValue* value);
VALA_EXTERN GType schema_path_tree_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SchemaPathTree, schema_path_tree_unref)
VALA_EXTERN SchemaPathTree* schema_path_tree_new (const gchar* path_segment);
VALA_EXTERN SchemaPathTree* schema_path_tree_construct (GType object_type,
                                            const gchar* path_segment);
static void _g_free0_ (gpointer var);
static void _g_hash_table_unref0_ (gpointer var);
VALA_EXTERN gboolean source_manager_source_is_null (SourceManager* self);
VALA_EXTERN void source_manager_refresh_schema_source (SourceManager* self);
static GSettingsSchemaSource* source_manager_create_schema_source (SourceManager* self);
static void _vala_array_add23 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN SchemaPathTree* source_manager_get_cached_schemas (SourceManager* self);
VALA_EXTERN void schema_path_tree_add_schema (SchemaPathTree* self,
                                  GSettingsSchema* schema,
                                  GHashTable* modified_path_specs);
static void _vala_array_add24 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN void schema_path_tree_add_schema_with_path_specs (SchemaPathTree* self,
                                                  GSettingsSchema* schema,
                                                  GHashTable* path_specs,
                                                  GHashTable* modified_path_specs);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add25 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gchar** _vala_array_dup15 (gchar** self,
                           gssize length);
static gchar** _vala_array_dup16 (gchar** self,
                           gssize length);
VALA_EXTERN void schema_path_tree_remove_unmarked (SchemaPathTree* self,
                                       GHashTable* modified_path_specs);
static gchar** _vala_array_dup17 (gchar** self,
                           gssize length);
static GSettingsSchemaSource* source_manager_try_prepend_dir (GSettingsSchemaSource* source,
                                                       const gchar* schemas_dir);
VALA_EXTERN void source_manager_refresh_relocatable_schema_paths (SourceManager* self,
                                                      gboolean user_schemas,
                                                      gboolean built_in_schemas,
                                                      gboolean internal_schemas,
                                                      gboolean startup_schemas,
                                                      GVariant* user_paths_variant);
static void source_manager_add_relocatable_schema_info (SourceManager* self,
                                                 GHashTable* map,
                                                 const gchar* schema_id,
                                                 ...);
static gchar** _vala_array_dup18 (gchar** self,
                           gssize length);
static gchar** _vala_array_dup19 (gchar** self,
                           gssize length);
static void ___lambda102_ (SourceManager* self,
                    const gchar* schema_id,
                    GHashTable* paths);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static Block45Data* block45_data_ref (Block45Data* _data45_);
static void block45_data_unref (void * _userdata_);
static void ___lambda0__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static void __lambda103_ (Block44Data* _data44_,
                   const gchar* path_spec);
static void ___lambda103__gfunc (gconstpointer data,
                          gpointer self);
static void ____lambda102__gh_func (gconstpointer key,
                             gconstpointer value,
                             gpointer self);
VALA_EXTERN void source_manager_add_mapping (SourceManager* self,
                                 const gchar* schema,
                                 const gchar* folder_path);
VALA_EXTERN SourceManager* source_manager_new (void);
VALA_EXTERN SourceManager* source_manager_construct (GType object_type);
static void source_manager_set_cached_schemas (SourceManager* self,
                                        SchemaPathTree* value);
static void source_manager_finalize (GObject * obj);
static GType source_manager_get_type_once (void);
static void _vala_source_manager_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_source_manager_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
VALA_EXTERN gpointer cached_schema_info_ref (gpointer instance);
VALA_EXTERN void cached_schema_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_cached_schema_info (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_cached_schema_info (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_cached_schema_info (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_cached_schema_info (const GValue* value);
VALA_EXTERN GType cached_schema_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CachedSchemaInfo, cached_schema_info_unref)
static void _cached_schema_info_unref0_ (gpointer var);
static void _schema_path_tree_unref0_ (gpointer var);
VALA_EXTERN guint schema_path_tree_get_schema_count (SchemaPathTree* self,
                                         const gchar* path);
VALA_EXTERN void schema_path_tree_get_content_count (SchemaPathTree* self,
                                         const gchar* path,
                                         guint* schemas_count,
                                         guint* subpaths_count);
VALA_EXTERN gboolean schema_path_tree_lookup (SchemaPathTree* self,
                                  const gchar* path,
                                  GHashTable** path_schemas,
                                  GHashTable** subpaths);
static guint __lambda21_ (GSettingsSchema* schema);
static guint ___lambda21__ghash_func (gconstpointer key);
static gboolean __lambda22_ (GSettingsSchema* schema1,
                      GSettingsSchema* schema2);
static gboolean ___lambda22__gequal_func (gconstpointer a,
                                   gconstpointer b);
static void _g_settings_schema_unref0_ (gpointer var);
static gboolean schema_path_tree_lookup_segments (SchemaPathTree* self,
                                           gchar** path_segments,
                                           gint path_segments_length1,
                                           gint matched_prefix_length,
                                           GHashTable** path_schemas,
                                           GHashTable** subpaths);
static gchar** schema_path_tree_to_segments (const gchar* path,
                                      gint* result_length1);
static gboolean schema_path_tree_has_non_wildcard_content (SchemaPathTree* self);
static gboolean schema_path_tree_add_schema_to_path_spec (SchemaPathTree* self,
                                                   CachedSchemaInfo* schema_info,
                                                   gchar** path_spec,
                                                   gint path_spec_length1,
                                                   gint matched_prefix_length,
                                                   GHashTable* modified_path_specs);
VALA_EXTERN CachedSchemaInfo* cached_schema_info_new (GSettingsSchema* schema,
                                          gulong* fingerprint);
VALA_EXTERN CachedSchemaInfo* cached_schema_info_construct (GType object_type,
                                                GSettingsSchema* schema,
                                                gulong* fingerprint);
static Block46Data* block46_data_ref (Block46Data* _data46_);
static void block46_data_unref (void * _userdata_);
VALA_EXTERN gulong cached_schema_info_compute_schema_fingerprint (GSettingsSchema* schema);
static void __lambda23_ (Block46Data* _data46_,
                  const gchar* path_spec);
static void ___lambda23__gfunc (gconstpointer data,
                         gpointer self);
static gchar* schema_path_tree_to_path (gchar** segments,
                                 gint segments_length1);
static void schema_path_tree_remove_unmarked_from_path (SchemaPathTree* self,
                                                 const gchar* path_spec,
                                                 GHashTable* modified_path_specs);
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
static gboolean __lambda24_ (Block47Data* _data47_,
                      const gchar* schema_id,
                      CachedSchemaInfo* cached_schema_info);
static gboolean ___lambda24__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
static gboolean schema_path_tree_is_empty (SchemaPathTree* self);
static void _vala_array_add26 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void schema_path_tree_finalize (SchemaPathTree * obj);
static GType schema_path_tree_get_type_once (void);
static void cached_schema_info_finalize (CachedSchemaInfo * obj);
static GType cached_schema_info_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
source_manager_get_instance_private (SourceManager* self)
{
	return G_STRUCT_MEMBER_P (self, SourceManager_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_hash_table_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}

gboolean
source_manager_source_is_null (SourceManager* self)
{
	GSettingsSchemaSource* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings_schema_source;
	result = _tmp0_ == NULL;
	return result;
}

static void
_vala_array_add23 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
_vala_array_add24 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add25 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
_vala_array_dup15 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar**
_vala_array_dup16 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

void
source_manager_refresh_schema_source (SourceManager* self)
{
	GSettingsSchemaSource* settings_schema_source = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchemaSource* _tmp1_;
	GHashTable* modified_path_specs = NULL;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	gchar** non_relocatable_schemas = NULL;
	gint non_relocatable_schemas_length1 = 0;
	gint _non_relocatable_schemas_size_ = 0;
	gchar** relocatable_schemas = NULL;
	gint relocatable_schemas_length1 = 0;
	gint _relocatable_schemas_size_ = 0;
	GSettingsSchemaSource* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** empty_schemas = NULL;
	gchar** _tmp8_;
	gint empty_schemas_length1;
	gint _empty_schemas_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gchar** empty_schemas_needing_warning = NULL;
	gchar** _tmp60_;
	gint empty_schemas_needing_warning_length1;
	gint _empty_schemas_needing_warning_size_;
	gchar** _tmp61_;
	gint _tmp61__length1;
	gchar** _tmp68_;
	gint _tmp68__length1;
	SchemaPathTree* _tmp92_;
	GHashTable* _tmp93_;
	GSettingsSchemaSource* _tmp94_;
	GSettingsSchemaSource* _tmp95_;
	GHashTable* _tmp96_;
	guint _tmp97_;
	guint _tmp98_;
	g_return_if_fail (self != NULL);
	_tmp0_ = source_manager_create_schema_source (self);
	settings_schema_source = _tmp0_;
	_tmp1_ = settings_schema_source;
	if (_tmp1_ == NULL) {
		_g_settings_schema_source_unref0 (settings_schema_source);
		return;
	}
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, NULL, _g_free0_);
	modified_path_specs = _tmp4_;
	_tmp5_ = settings_schema_source;
	g_settings_schema_source_list_schemas ((GSettingsSchemaSource*) _tmp5_, TRUE, &_tmp6_, &_tmp7_);
	non_relocatable_schemas = (_vala_array_free (non_relocatable_schemas, non_relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
	non_relocatable_schemas = _tmp6_;
	non_relocatable_schemas_length1 = -1;
	_non_relocatable_schemas_size_ = non_relocatable_schemas_length1;
	non_relocatable_schemas_length1 = _vala_array_length (non_relocatable_schemas);
	relocatable_schemas = (_vala_array_free (relocatable_schemas, relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
	relocatable_schemas = _tmp7_;
	relocatable_schemas_length1 = -1;
	_relocatable_schemas_size_ = relocatable_schemas_length1;
	relocatable_schemas_length1 = _vala_array_length (relocatable_schemas);
	_tmp8_ = g_new0 (gchar*, 0 + 1);
	empty_schemas = _tmp8_;
	empty_schemas_length1 = 0;
	_empty_schemas_size_ = empty_schemas_length1;
	_tmp9_ = non_relocatable_schemas;
	_tmp9__length1 = non_relocatable_schemas_length1;
	{
		gchar** schema_id_collection = NULL;
		gint schema_id_collection_length1 = 0;
		gint _schema_id_collection_size_ = 0;
		gint schema_id_it = 0;
		schema_id_collection = _tmp9_;
		schema_id_collection_length1 = _tmp9__length1;
		for (schema_id_it = 0; schema_id_it < schema_id_collection_length1; schema_id_it = schema_id_it + 1) {
			gchar* _tmp10_;
			gchar* schema_id = NULL;
			_tmp10_ = g_strdup (schema_id_collection[schema_id_it]);
			schema_id = _tmp10_;
			{
				GSettingsSchema* settings_schema = NULL;
				GSettingsSchemaSource* _tmp11_;
				const gchar* _tmp12_;
				GSettingsSchema* _tmp13_;
				GSettingsSchema* _tmp14_;
				gboolean _tmp15_ = FALSE;
				GSettingsSchema* _tmp16_;
				gchar** _tmp17_;
				gchar** _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				gboolean _tmp20_;
				SchemaPathTree* _tmp27_;
				GSettingsSchema* _tmp28_;
				GHashTable* _tmp29_;
				_tmp11_ = settings_schema_source;
				_tmp12_ = schema_id;
				_tmp13_ = g_settings_schema_source_lookup ((GSettingsSchemaSource*) _tmp11_, _tmp12_, TRUE);
				settings_schema = _tmp13_;
				_tmp14_ = settings_schema;
				if (_tmp14_ == NULL) {
					_g_settings_schema_unref0 (settings_schema);
					_g_free0 (schema_id);
					continue;
				}
				_tmp16_ = settings_schema;
				_tmp18_ = _tmp17_ = g_settings_schema_list_keys ((GSettingsSchema*) _tmp16_);
				_tmp19_ = _tmp18_;
				_tmp19__length1 = _vala_array_length (_tmp17_);
				_tmp20_ = _vala_array_length (_tmp17_) == 0;
				_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
				if (_tmp20_) {
					GSettingsSchema* _tmp21_;
					gchar** _tmp22_;
					gchar** _tmp23_;
					gchar** _tmp24_;
					gint _tmp24__length1;
					_tmp21_ = settings_schema;
					_tmp23_ = _tmp22_ = g_settings_schema_list_children ((GSettingsSchema*) _tmp21_);
					_tmp24_ = _tmp23_;
					_tmp24__length1 = _vala_array_length (_tmp22_);
					_tmp15_ = _vala_array_length (_tmp22_) == 0;
					_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					const gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp25_ = schema_id;
					_tmp26_ = g_strdup (_tmp25_);
					_vala_array_add23 (&empty_schemas, &empty_schemas_length1, &_empty_schemas_size_, _tmp26_);
					_g_settings_schema_unref0 (settings_schema);
					_g_free0 (schema_id);
					continue;
				}
				_tmp27_ = self->priv->_cached_schemas;
				_tmp28_ = settings_schema;
				_tmp29_ = modified_path_specs;
				schema_path_tree_add_schema (_tmp27_, (GSettingsSchema*) _tmp28_, _tmp29_);
				_g_settings_schema_unref0 (settings_schema);
				_g_free0 (schema_id);
			}
		}
	}
	_tmp30_ = relocatable_schemas;
	_tmp30__length1 = relocatable_schemas_length1;
	{
		gchar** schema_id_collection = NULL;
		gint schema_id_collection_length1 = 0;
		gint _schema_id_collection_size_ = 0;
		gint schema_id_it = 0;
		schema_id_collection = _tmp30_;
		schema_id_collection_length1 = _tmp30__length1;
		for (schema_id_it = 0; schema_id_it < schema_id_collection_length1; schema_id_it = schema_id_it + 1) {
			gchar* _tmp31_;
			gchar* schema_id = NULL;
			_tmp31_ = g_strdup (schema_id_collection[schema_id_it]);
			schema_id = _tmp31_;
			{
				GHashTable* path_specs = NULL;
				GHashTable* _tmp32_;
				const gchar* _tmp33_;
				gconstpointer _tmp34_;
				GHashTable* _tmp35_;
				GHashTable* _tmp36_;
				GSettingsSchema* settings_schema = NULL;
				GSettingsSchemaSource* _tmp37_;
				const gchar* _tmp38_;
				GSettingsSchema* _tmp39_;
				gboolean _tmp40_ = FALSE;
				GSettingsSchema* _tmp41_;
				gboolean _tmp44_ = FALSE;
				GSettingsSchema* _tmp45_;
				gchar** _tmp46_;
				gchar** _tmp47_;
				gchar** _tmp48_;
				gint _tmp48__length1;
				gboolean _tmp49_;
				SchemaPathTree* _tmp56_;
				GSettingsSchema* _tmp57_;
				GHashTable* _tmp58_;
				GHashTable* _tmp59_;
				_tmp32_ = self->priv->relocatable_schema_paths;
				_tmp33_ = schema_id;
				_tmp34_ = g_hash_table_lookup (_tmp32_, _tmp33_);
				_tmp35_ = _g_hash_table_ref0 ((GHashTable*) _tmp34_);
				path_specs = _tmp35_;
				_tmp36_ = path_specs;
				if (_tmp36_ == NULL) {
					_g_hash_table_unref0 (path_specs);
					_g_free0 (schema_id);
					continue;
				}
				_tmp37_ = settings_schema_source;
				_tmp38_ = schema_id;
				_tmp39_ = g_settings_schema_source_lookup ((GSettingsSchemaSource*) _tmp37_, _tmp38_, TRUE);
				settings_schema = _tmp39_;
				_tmp41_ = settings_schema;
				if (_tmp41_ == NULL) {
					_tmp40_ = TRUE;
				} else {
					GSettingsSchema* _tmp42_;
					const gchar* _tmp43_;
					_tmp42_ = settings_schema;
					_tmp43_ = g_settings_schema_get_path ((GSettingsSchema*) _tmp42_);
					_tmp40_ = ((const gchar*) _tmp43_) != NULL;
				}
				if (_tmp40_) {
					_g_settings_schema_unref0 (settings_schema);
					_g_hash_table_unref0 (path_specs);
					_g_free0 (schema_id);
					continue;
				}
				_tmp45_ = settings_schema;
				_tmp47_ = _tmp46_ = g_settings_schema_list_keys ((GSettingsSchema*) _tmp45_);
				_tmp48_ = _tmp47_;
				_tmp48__length1 = _vala_array_length (_tmp46_);
				_tmp49_ = _vala_array_length (_tmp46_) == 0;
				_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
				if (_tmp49_) {
					GSettingsSchema* _tmp50_;
					gchar** _tmp51_;
					gchar** _tmp52_;
					gchar** _tmp53_;
					gint _tmp53__length1;
					_tmp50_ = settings_schema;
					_tmp52_ = _tmp51_ = g_settings_schema_list_children ((GSettingsSchema*) _tmp50_);
					_tmp53_ = _tmp52_;
					_tmp53__length1 = _vala_array_length (_tmp51_);
					_tmp44_ = _vala_array_length (_tmp51_) == 0;
					_tmp53_ = (_vala_array_free (_tmp53_, _tmp53__length1, (GDestroyNotify) g_free), NULL);
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					const gchar* _tmp54_;
					gchar* _tmp55_;
					_tmp54_ = schema_id;
					_tmp55_ = g_strdup (_tmp54_);
					_vala_array_add24 (&empty_schemas, &empty_schemas_length1, &_empty_schemas_size_, _tmp55_);
					_g_settings_schema_unref0 (settings_schema);
					_g_hash_table_unref0 (path_specs);
					_g_free0 (schema_id);
					continue;
				}
				_tmp56_ = self->priv->_cached_schemas;
				_tmp57_ = settings_schema;
				_tmp58_ = path_specs;
				_tmp59_ = modified_path_specs;
				schema_path_tree_add_schema_with_path_specs (_tmp56_, (GSettingsSchema*) _tmp57_, (GHashTable*) _tmp58_, _tmp59_);
				_g_settings_schema_unref0 (settings_schema);
				_g_hash_table_unref0 (path_specs);
				_g_free0 (schema_id);
			}
		}
	}
	_tmp60_ = g_new0 (gchar*, 0 + 1);
	empty_schemas_needing_warning = _tmp60_;
	empty_schemas_needing_warning_length1 = 0;
	_empty_schemas_needing_warning_size_ = empty_schemas_needing_warning_length1;
	_tmp61_ = empty_schemas;
	_tmp61__length1 = empty_schemas_length1;
	if (_tmp61__length1 > 0) {
		gchar** _tmp62_;
		gint _tmp62__length1;
		_tmp62_ = empty_schemas;
		_tmp62__length1 = empty_schemas_length1;
		{
			gchar** test_string_collection = NULL;
			gint test_string_collection_length1 = 0;
			gint _test_string_collection_size_ = 0;
			gint test_string_it = 0;
			test_string_collection = _tmp62_;
			test_string_collection_length1 = _tmp62__length1;
			for (test_string_it = 0; test_string_it < test_string_collection_length1; test_string_it = test_string_it + 1) {
				gchar* _tmp63_;
				gchar* test_string = NULL;
				_tmp63_ = g_strdup (test_string_collection[test_string_it]);
				test_string = _tmp63_;
				{
					const gchar* _tmp64_;
					gchar** _tmp65_;
					gint _tmp65__length1;
					_tmp64_ = test_string;
					_tmp65_ = self->priv->previous_empty_schemas;
					_tmp65__length1 = self->priv->previous_empty_schemas_length1;
					if (!_vala_string_array_contains (_tmp65_, _tmp65__length1, _tmp64_)) {
						const gchar* _tmp66_;
						gchar* _tmp67_;
						_tmp66_ = test_string;
						_tmp67_ = g_strdup (_tmp66_);
						_vala_array_add25 (&empty_schemas_needing_warning, &empty_schemas_needing_warning_length1, &_empty_schemas_needing_warning_size_, _tmp67_);
					}
					_g_free0 (test_string);
				}
			}
		}
	}
	_tmp68_ = empty_schemas_needing_warning;
	_tmp68__length1 = empty_schemas_needing_warning_length1;
	if (_tmp68__length1 == 1) {
		gchar** _tmp69_;
		gint _tmp69__length1;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar** _tmp75_;
		gint _tmp75__length1;
		gchar** _tmp76_;
		gint _tmp76__length1;
		_tmp69_ = empty_schemas_needing_warning;
		_tmp69__length1 = empty_schemas_needing_warning_length1;
		_tmp70_ = _tmp69_[0];
		_tmp71_ = g_strconcat ("Schema with id “", _tmp70_, NULL);
		_tmp72_ = _tmp71_;
		_tmp73_ = g_strconcat (_tmp72_, "” contains neither keys nor children.", NULL);
		_tmp74_ = _tmp73_;
		g_info ("source-manager.vala:92: %s", _tmp74_);
		_g_free0 (_tmp74_);
		_g_free0 (_tmp72_);
		_tmp75_ = empty_schemas;
		_tmp75__length1 = empty_schemas_length1;
		_tmp76_ = (_tmp75_ != NULL) ? _vala_array_dup15 (_tmp75_, _tmp75__length1) : _tmp75_;
		_tmp76__length1 = _tmp75__length1;
		self->priv->previous_empty_schemas = (_vala_array_free (self->priv->previous_empty_schemas, self->priv->previous_empty_schemas_length1, (GDestroyNotify) g_free), NULL);
		self->priv->previous_empty_schemas = _tmp76_;
		self->priv->previous_empty_schemas_length1 = _tmp76__length1;
		self->priv->_previous_empty_schemas_size_ = self->priv->previous_empty_schemas_length1;
	} else {
		gchar** _tmp77_;
		gint _tmp77__length1;
		_tmp77_ = empty_schemas_needing_warning;
		_tmp77__length1 = empty_schemas_needing_warning_length1;
		if (_tmp77__length1 > 1) {
			gchar* warning_string = NULL;
			gchar* _tmp78_;
			gchar** _tmp79_;
			gint _tmp79__length1;
			const gchar* _tmp87_;
			gchar* _tmp88_;
			const gchar* _tmp89_;
			gchar** _tmp90_;
			gint _tmp90__length1;
			gchar** _tmp91_;
			gint _tmp91__length1;
			_tmp78_ = g_strdup ("The following schemas:\n");
			warning_string = _tmp78_;
			_tmp79_ = empty_schemas_needing_warning;
			_tmp79__length1 = empty_schemas_needing_warning_length1;
			{
				gchar** warning_id_collection = NULL;
				gint warning_id_collection_length1 = 0;
				gint _warning_id_collection_size_ = 0;
				gint warning_id_it = 0;
				warning_id_collection = _tmp79_;
				warning_id_collection_length1 = _tmp79__length1;
				for (warning_id_it = 0; warning_id_it < warning_id_collection_length1; warning_id_it = warning_id_it + 1) {
					gchar* _tmp80_;
					gchar* warning_id = NULL;
					_tmp80_ = g_strdup (warning_id_collection[warning_id_it]);
					warning_id = _tmp80_;
					{
						const gchar* _tmp81_;
						const gchar* _tmp82_;
						const gchar* _tmp83_;
						gchar* _tmp84_;
						gchar* _tmp85_;
						gchar* _tmp86_;
						_tmp81_ = warning_string;
						_tmp82_ = warning_id;
						_tmp83_ = string_to_string (_tmp82_);
						_tmp84_ = g_strconcat ("  ", _tmp83_, "\n", NULL);
						_tmp85_ = _tmp84_;
						_tmp86_ = g_strconcat (_tmp81_, _tmp85_, NULL);
						_g_free0 (warning_string);
						warning_string = _tmp86_;
						_g_free0 (_tmp85_);
						_g_free0 (warning_id);
					}
				}
			}
			_tmp87_ = warning_string;
			_tmp88_ = g_strconcat (_tmp87_, "contain neither keys nor children.", NULL);
			_g_free0 (warning_string);
			warning_string = _tmp88_;
			_tmp89_ = warning_string;
			g_info ("source-manager.vala:102: %s", _tmp89_);
			_tmp90_ = empty_schemas;
			_tmp90__length1 = empty_schemas_length1;
			_tmp91_ = (_tmp90_ != NULL) ? _vala_array_dup16 (_tmp90_, _tmp90__length1) : _tmp90_;
			_tmp91__length1 = _tmp90__length1;
			self->priv->previous_empty_schemas = (_vala_array_free (self->priv->previous_empty_schemas, self->priv->previous_empty_schemas_length1, (GDestroyNotify) g_free), NULL);
			self->priv->previous_empty_schemas = _tmp91_;
			self->priv->previous_empty_schemas_length1 = _tmp91__length1;
			self->priv->_previous_empty_schemas_size_ = self->priv->previous_empty_schemas_length1;
			_g_free0 (warning_string);
		}
	}
	_tmp92_ = self->priv->_cached_schemas;
	_tmp93_ = modified_path_specs;
	schema_path_tree_remove_unmarked (_tmp92_, _tmp93_);
	_tmp94_ = settings_schema_source;
	_tmp95_ = _g_settings_schema_source_ref0 (_tmp94_);
	_g_settings_schema_source_unref0 (self->priv->settings_schema_source);
	self->priv->settings_schema_source = _tmp95_;
	_tmp96_ = modified_path_specs;
	_tmp97_ = g_hash_table_size (_tmp96_);
	_tmp98_ = _tmp97_;
	if (_tmp98_ > ((guint) 0)) {
		GHashTable* _tmp99_;
		_tmp99_ = modified_path_specs;
		g_signal_emit (self, source_manager_signals[SOURCE_MANAGER_PATHS_CHANGED_SIGNAL], 0, _tmp99_);
	}
	empty_schemas_needing_warning = (_vala_array_free (empty_schemas_needing_warning, empty_schemas_needing_warning_length1, (GDestroyNotify) g_free), NULL);
	empty_schemas = (_vala_array_free (empty_schemas, empty_schemas_length1, (GDestroyNotify) g_free), NULL);
	relocatable_schemas = (_vala_array_free (relocatable_schemas, relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
	non_relocatable_schemas = (_vala_array_free (non_relocatable_schemas, non_relocatable_schemas_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (modified_path_specs);
	_g_settings_schema_source_unref0 (settings_schema_source);
}

static gchar**
_vala_array_dup17 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static GSettingsSchemaSource*
source_manager_create_schema_source (SourceManager* self)
{
	GSettingsSchemaSource* source = NULL;
	gchar** system_data_dirs = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint system_data_dirs_length1;
	gint _system_data_dirs_size_;
	gchar* user_data_dir = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GSettingsSchemaSource* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GSettingsSchemaSource* _tmp18_;
	gchar* var_schema_dir = NULL;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	GSettingsSchemaSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	source = NULL;
	_tmp1_ = _tmp0_ = g_get_system_data_dirs ();
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup17 (_tmp1_, _vala_array_length (_tmp0_)) : _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	system_data_dirs = _tmp2_;
	system_data_dirs_length1 = _tmp2__length1;
	_system_data_dirs_size_ = system_data_dirs_length1;
	{
		gint i = 0;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = system_data_dirs;
		_tmp3__length1 = system_data_dirs_length1;
		i = _tmp3__length1 - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GSettingsSchemaSource* _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				GSettingsSchemaSource* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp6_ = source;
				_tmp7_ = system_data_dirs;
				_tmp7__length1 = system_data_dirs_length1;
				_tmp8_ = _tmp7_[i];
				_tmp9_ = g_build_filename (_tmp8_, "glib-2.0", "schemas", NULL);
				_tmp10_ = _tmp9_;
				_tmp11_ = source_manager_try_prepend_dir (_tmp6_, _tmp10_);
				_g_settings_schema_source_unref0 (source);
				source = _tmp11_;
				_g_free0 (_tmp10_);
			}
		}
	}
	_tmp12_ = g_get_user_data_dir ();
	_tmp13_ = g_strdup (_tmp12_);
	user_data_dir = _tmp13_;
	_tmp14_ = source;
	_tmp15_ = user_data_dir;
	_tmp16_ = g_build_filename (_tmp15_, "glib-2.0", "schemas", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = source_manager_try_prepend_dir (_tmp14_, _tmp17_);
	_g_settings_schema_source_unref0 (source);
	source = _tmp18_;
	_g_free0 (_tmp17_);
	_tmp19_ = g_getenv ("GSETTINGS_SCHEMA_DIR");
	_tmp20_ = g_strdup (_tmp19_);
	var_schema_dir = _tmp20_;
	_tmp21_ = var_schema_dir;
	if (_tmp21_ != NULL) {
		GSettingsSchemaSource* _tmp22_;
		const gchar* _tmp23_;
		GSettingsSchemaSource* _tmp24_;
		_tmp22_ = source;
		_tmp23_ = var_schema_dir;
		_tmp24_ = source_manager_try_prepend_dir (_tmp22_, (const gchar*) _tmp23_);
		_g_settings_schema_source_unref0 (source);
		source = _tmp24_;
	}
	result = source;
	_g_free0 (var_schema_dir);
	_g_free0 (user_data_dir);
	system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static GSettingsSchemaSource*
source_manager_try_prepend_dir (GSettingsSchemaSource* source,
                                const gchar* schemas_dir)
{
	GSettingsSchemaSource* _tmp3_;
	GError* _inner_error0_ = NULL;
	GSettingsSchemaSource* result;
	g_return_val_if_fail (schemas_dir != NULL, NULL);
	{
		GSettingsSchemaSource* _tmp0_ = NULL;
		GSettingsSchemaSource* _tmp1_;
		GSettingsSchemaSource* _tmp2_;
		_tmp1_ = g_settings_schema_source_new_from_directory (schemas_dir, source, TRUE, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_settings_schema_source_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp3_ = _g_settings_schema_source_ref0 (source);
	result = _tmp3_;
	return result;
}

static gchar**
_vala_array_dup18 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup19 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static Block44Data*
block44_data_ref (Block44Data* _data44_)
{
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}

static void
block44_data_unref (void * _userdata_)
{
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		SourceManager* self;
		self = _data44_->self;
		_g_free0 (_data44_->schema_id);
		_g_object_unref0 (self);
		g_slice_free (Block44Data, _data44_);
	}
}

static Block45Data*
block45_data_ref (Block45Data* _data45_)
{
	g_atomic_int_inc (&_data45_->_ref_count_);
	return _data45_;
}

static void
block45_data_unref (void * _userdata_)
{
	Block45Data* _data45_;
	_data45_ = (Block45Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data45_->_ref_count_)) {
		GHashTable* self;
		self = _data45_->self;
		_g_hash_table_unref0 (self);
		g_slice_free (Block45Data, _data45_);
	}
}

static void
__lambda0_ (Block45Data* _data45_,
            gconstpointer k,
            gconstpointer v)
{
	GHashTable* self;
	self = _data45_->self;
	_data45_->func (v, _data45_->func_target);
}

static void
___lambda0__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda0_ (self, key, value);
}

static void
_vala_g_hash_set_foreach (GHashTable* self,
                          GFunc func,
                          gpointer func_target)
{
	Block45Data* _data45_;
	g_return_if_fail (self != NULL);
	_data45_ = g_slice_new0 (Block45Data);
	_data45_->_ref_count_ = 1;
	_data45_->self = g_hash_table_ref (self);
	_data45_->func = func;
	_data45_->func_target = func_target;
	g_hash_table_foreach ((GHashTable*) self, ___lambda0__gh_func, _data45_);
	block45_data_unref (_data45_);
	_data45_ = NULL;
}

static void
__lambda103_ (Block44Data* _data44_,
              const gchar* path_spec)
{
	SourceManager* self;
	GHashTable* _tmp0_;
	self = _data44_->self;
	g_return_if_fail (path_spec != NULL);
	_tmp0_ = self->priv->relocatable_schema_paths;
	source_manager_add_relocatable_schema_info (self, _tmp0_, _data44_->schema_id, path_spec, NULL);
}

static void
___lambda103__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda103_ (self, (const gchar*) data);
}

static void
___lambda102_ (SourceManager* self,
               const gchar* schema_id,
               GHashTable* paths)
{
	Block44Data* _data44_;
	gchar* _tmp0_;
	g_return_if_fail (schema_id != NULL);
	g_return_if_fail (paths != NULL);
	_data44_ = g_slice_new0 (Block44Data);
	_data44_->_ref_count_ = 1;
	_data44_->self = g_object_ref (self);
	_tmp0_ = g_strdup (schema_id);
	_g_free0 (_data44_->schema_id);
	_data44_->schema_id = _tmp0_;
	_vala_g_hash_set_foreach (paths, ___lambda103__gfunc, _data44_);
	block44_data_unref (_data44_);
	_data44_ = NULL;
}

static void
____lambda102__gh_func (gconstpointer key,
                        gconstpointer value,
                        gpointer self)
{
	___lambda102_ ((SourceManager*) self, (const gchar*) key, (GHashTable*) value);
}

void
source_manager_refresh_relocatable_schema_paths (SourceManager* self,
                                                 gboolean user_schemas,
                                                 gboolean built_in_schemas,
                                                 gboolean internal_schemas,
                                                 gboolean startup_schemas,
                                                 GVariant* user_paths_variant)
{
	GHashTable* _tmp0_;
	gboolean _tmp20_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user_paths_variant != NULL);
	_tmp0_ = self->priv->relocatable_schema_paths;
	g_hash_table_remove_all (_tmp0_);
	if (user_schemas) {
		GVariantIter* entries_iter = NULL;
		GVariantIter* _tmp1_ = NULL;
		gchar* schema_id = NULL;
		gchar* path_spec = NULL;
		g_variant_get (user_paths_variant, "a{ss}", &_tmp1_, NULL);
		_g_variant_iter_free0 (entries_iter);
		entries_iter = _tmp1_;
		while (TRUE) {
			GVariantIter* _tmp2_;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gboolean _tmp5_;
			GHashTable* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp2_ = entries_iter;
			_tmp5_ = g_variant_iter_next (_tmp2_, "{ss}", &_tmp3_, &_tmp4_, NULL);
			_g_free0 (schema_id);
			schema_id = _tmp3_;
			_g_free0 (path_spec);
			path_spec = _tmp4_;
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = self->priv->relocatable_schema_paths;
			_tmp7_ = schema_id;
			_tmp8_ = path_spec;
			source_manager_add_relocatable_schema_info (self, _tmp6_, _tmp7_, _tmp8_, NULL);
		}
		_g_free0 (path_spec);
		_g_free0 (schema_id);
		_g_variant_iter_free0 (entries_iter);
	}
	if (built_in_schemas) {
		gchar** known_mappings = NULL;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gint _tmp9__length2;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gint _tmp10__length2;
		gint known_mappings_length1;
		gint known_mappings_length2;
		_tmp9_ = configuration_editor_known_mappings;
		_tmp9__length1 = configuration_editor_known_mappings_length1;
		_tmp9__length2 = configuration_editor_known_mappings_length2;
		_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup18 (_tmp9_, _tmp9__length1 * _tmp9__length2) : _tmp9_;
		_tmp10__length1 = _tmp9__length1;
		_tmp10__length2 = _tmp9__length2;
		known_mappings = _tmp10_;
		known_mappings_length1 = _tmp10__length1;
		known_mappings_length2 = _tmp10__length2;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gchar** _tmp13_;
					gint _tmp13__length1;
					gint _tmp13__length2;
					gint _tmp14_;
					GHashTable* _tmp15_;
					gchar** _tmp16_;
					gint _tmp16__length1;
					gint _tmp16__length2;
					const gchar* _tmp17_;
					gchar** _tmp18_;
					gint _tmp18__length1;
					gint _tmp18__length2;
					const gchar* _tmp19_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = known_mappings;
					_tmp13__length1 = known_mappings_length1;
					_tmp13__length2 = known_mappings_length2;
					_tmp14_ = _tmp13__length1;
					if (!(i < _tmp14_)) {
						break;
					}
					_tmp15_ = self->priv->relocatable_schema_paths;
					_tmp16_ = known_mappings;
					_tmp16__length1 = known_mappings_length1;
					_tmp16__length2 = known_mappings_length2;
					_tmp17_ = _tmp16_[(i * _tmp16__length2) + 0];
					_tmp18_ = known_mappings;
					_tmp18__length1 = known_mappings_length1;
					_tmp18__length2 = known_mappings_length2;
					_tmp19_ = _tmp18_[(i * _tmp18__length2) + 1];
					source_manager_add_relocatable_schema_info (self, _tmp15_, _tmp17_, _tmp19_, NULL);
				}
			}
		}
		known_mappings = (_vala_array_free (known_mappings, known_mappings_length1 * known_mappings_length2, (GDestroyNotify) g_free), NULL);
	}
	if (built_in_schemas) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = internal_schemas;
	}
	if (_tmp20_) {
		gchar** internal_mappings = NULL;
		gchar** _tmp21_;
		gint _tmp21__length1;
		gint _tmp21__length2;
		gchar** _tmp22_;
		gint _tmp22__length1;
		gint _tmp22__length2;
		gint internal_mappings_length1;
		gint internal_mappings_length2;
		_tmp21_ = configuration_editor_internal_mappings;
		_tmp21__length1 = configuration_editor_internal_mappings_length1;
		_tmp21__length2 = configuration_editor_internal_mappings_length2;
		_tmp22_ = (_tmp21_ != NULL) ? _vala_array_dup19 (_tmp21_, _tmp21__length1 * _tmp21__length2) : _tmp21_;
		_tmp22__length1 = _tmp21__length1;
		_tmp22__length2 = _tmp21__length2;
		internal_mappings = _tmp22_;
		internal_mappings_length1 = _tmp22__length1;
		internal_mappings_length2 = _tmp22__length2;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp23_ = FALSE;
				_tmp23_ = TRUE;
				while (TRUE) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp25__length2;
					gint _tmp26_;
					GHashTable* _tmp27_;
					gchar** _tmp28_;
					gint _tmp28__length1;
					gint _tmp28__length2;
					const gchar* _tmp29_;
					gchar** _tmp30_;
					gint _tmp30__length1;
					gint _tmp30__length2;
					const gchar* _tmp31_;
					if (!_tmp23_) {
						gint _tmp24_;
						_tmp24_ = i;
						i = _tmp24_ + 1;
					}
					_tmp23_ = FALSE;
					_tmp25_ = internal_mappings;
					_tmp25__length1 = internal_mappings_length1;
					_tmp25__length2 = internal_mappings_length2;
					_tmp26_ = _tmp25__length1;
					if (!(i < _tmp26_)) {
						break;
					}
					_tmp27_ = self->priv->relocatable_schema_paths;
					_tmp28_ = internal_mappings;
					_tmp28__length1 = internal_mappings_length1;
					_tmp28__length2 = internal_mappings_length2;
					_tmp29_ = _tmp28_[(i * _tmp28__length2) + 0];
					_tmp30_ = internal_mappings;
					_tmp30__length1 = internal_mappings_length1;
					_tmp30__length2 = internal_mappings_length2;
					_tmp31_ = _tmp30_[(i * _tmp30__length2) + 1];
					source_manager_add_relocatable_schema_info (self, _tmp27_, _tmp29_, _tmp31_, NULL);
				}
			}
		}
		internal_mappings = (_vala_array_free (internal_mappings, internal_mappings_length1 * internal_mappings_length2, (GDestroyNotify) g_free), NULL);
	}
	if (startup_schemas) {
		GHashTable* _tmp32_;
		_tmp32_ = self->priv->startup_relocatable_schema_paths;
		g_hash_table_foreach (_tmp32_, ____lambda102__gh_func, self);
	}
}

void
source_manager_add_mapping (SourceManager* self,
                            const gchar* schema,
                            const gchar* folder_path)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (folder_path != NULL);
	_tmp0_ = self->priv->startup_relocatable_schema_paths;
	source_manager_add_relocatable_schema_info (self, _tmp0_, schema, folder_path, NULL);
}

static void
source_manager_add_relocatable_schema_info (SourceManager* self,
                                            GHashTable* map,
                                            const gchar* schema_id,
                                            ...)
{
	GHashTable* schema_info = NULL;
	gconstpointer _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	va_list args = {0};
	gpointer next_arg = NULL;
	GHashTable* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	g_return_if_fail (schema_id != NULL);
	_tmp0_ = g_hash_table_lookup (map, schema_id);
	_tmp1_ = _g_hash_table_ref0 ((GHashTable*) _tmp0_);
	schema_info = _tmp1_;
	_tmp2_ = schema_info;
	if (_tmp2_ == NULL) {
		GHashFunc _tmp3_;
		GEqualFunc _tmp4_;
		GHashTable* _tmp5_;
		_tmp3_ = g_str_hash;
		_tmp4_ = g_str_equal;
		_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, _g_free0_);
		_g_hash_table_unref0 (schema_info);
		schema_info = _tmp5_;
	}
	va_start (args, schema_id);
	next_arg = NULL;
	while (TRUE) {
		gpointer _tmp6_;
		gpointer _tmp7_;
		gchar* path_spec = NULL;
		gpointer _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp14_;
		GHashTable* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp6_ = va_arg (args, gpointer);
		next_arg = _tmp6_;
		_tmp7_ = next_arg;
		if (!(_tmp7_ != NULL)) {
			break;
		}
		_tmp8_ = next_arg;
		_tmp9_ = g_strdup ((const gchar*) _tmp8_);
		path_spec = _tmp9_;
		_tmp10_ = path_spec;
		if (g_strcmp0 (_tmp10_, "") == 0) {
			_g_free0 (path_spec);
			continue;
		}
		_tmp11_ = path_spec;
		if (!g_str_has_prefix (_tmp11_, "/")) {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = path_spec;
			_tmp13_ = g_strconcat ("/", _tmp12_, NULL);
			_g_free0 (path_spec);
			path_spec = _tmp13_;
		}
		_tmp14_ = path_spec;
		if (!g_str_has_suffix (_tmp14_, "/")) {
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp15_ = path_spec;
			_tmp16_ = g_strconcat (_tmp15_, "/", NULL);
			_g_free0 (path_spec);
			path_spec = _tmp16_;
		}
		_tmp17_ = schema_info;
		_tmp18_ = path_spec;
		_tmp19_ = g_strdup (_tmp18_);
		g_hash_table_add ((GHashTable*) _tmp17_, _tmp19_);
		_g_free0 (path_spec);
	}
	_tmp20_ = schema_info;
	_tmp21_ = g_hash_table_size ((GHashTable*) _tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ > ((guint) 0)) {
		gchar* _tmp23_;
		GHashTable* _tmp24_;
		GHashTable* _tmp25_;
		_tmp23_ = g_strdup (schema_id);
		_tmp24_ = schema_info;
		_tmp25_ = _g_hash_table_ref0 ((GHashTable*) _tmp24_);
		g_hash_table_insert (map, _tmp23_, _tmp25_);
	}
	va_end (args);
	_g_hash_table_unref0 (schema_info);
}

SourceManager*
source_manager_construct (GType object_type)
{
	SourceManager * self = NULL;
	self = (SourceManager*) g_object_new (object_type, NULL);
	return self;
}

SourceManager*
source_manager_new (void)
{
	return source_manager_construct (TYPE_SOURCE_MANAGER);
}

SchemaPathTree*
source_manager_get_cached_schemas (SourceManager* self)
{
	SchemaPathTree* result;
	SchemaPathTree* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cached_schemas;
	result = _tmp0_;
	return result;
}

static gpointer
_schema_path_tree_ref0 (gpointer self)
{
	return self ? schema_path_tree_ref (self) : NULL;
}

static void
source_manager_set_cached_schemas (SourceManager* self,
                                   SchemaPathTree* value)
{
	SchemaPathTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _schema_path_tree_ref0 (value);
	_schema_path_tree_unref0 (self->priv->_cached_schemas);
	self->priv->_cached_schemas = _tmp0_;
}

static void
source_manager_class_init (SourceManagerClass * klass,
                           gpointer klass_data)
{
	source_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SourceManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_source_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_source_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = source_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOURCE_MANAGER_CACHED_SCHEMAS_PROPERTY, source_manager_properties[SOURCE_MANAGER_CACHED_SCHEMAS_PROPERTY] = param_spec_schema_path_tree ("cached-schemas", "cached-schemas", "cached-schemas", TYPE_SCHEMA_PATH_TREE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	source_manager_signals[SOURCE_MANAGER_PATHS_CHANGED_SIGNAL] = g_signal_new ("paths-changed", TYPE_SOURCE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_HASH_TABLE);
}

static void
source_manager_instance_init (SourceManager * self,
                              gpointer klass)
{
	SchemaPathTree* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	self->priv = source_manager_get_instance_private (self);
	_tmp0_ = schema_path_tree_new ("/");
	self->priv->_cached_schemas = _tmp0_;
	self->priv->settings_schema_source = NULL;
	_tmp1_ = g_strdup ("ca.desrt.dconf-editor.Demo.Empty");
	_tmp2_ = g_strdup ("ca.desrt.dconf-editor.Demo.EmptyRelocatable");
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	self->priv->previous_empty_schemas = _tmp3_;
	self->priv->previous_empty_schemas_length1 = 2;
	self->priv->_previous_empty_schemas_size_ = self->priv->previous_empty_schemas_length1;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_hash_table_unref0_);
	self->priv->relocatable_schema_paths = _tmp6_;
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, _g_hash_table_unref0_);
	self->priv->startup_relocatable_schema_paths = _tmp9_;
}

static void
source_manager_finalize (GObject * obj)
{
	SourceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_MANAGER, SourceManager);
	_schema_path_tree_unref0 (self->priv->_cached_schemas);
	_g_settings_schema_source_unref0 (self->priv->settings_schema_source);
	self->priv->previous_empty_schemas = (_vala_array_free (self->priv->previous_empty_schemas, self->priv->previous_empty_schemas_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (self->priv->relocatable_schema_paths);
	_g_hash_table_unref0 (self->priv->startup_relocatable_schema_paths);
	G_OBJECT_CLASS (source_manager_parent_class)->finalize (obj);
}

static GType
source_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SourceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceManager), 0, (GInstanceInitFunc) source_manager_instance_init, NULL };
	GType source_manager_type_id;
	source_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "SourceManager", &g_define_type_info, 0);
	SourceManager_private_offset = g_type_add_instance_private (source_manager_type_id, sizeof (SourceManagerPrivate));
	return source_manager_type_id;
}

GType
source_manager_get_type (void)
{
	static volatile gsize source_manager_type_id__once = 0;
	if (g_once_init_enter (&source_manager_type_id__once)) {
		GType source_manager_type_id;
		source_manager_type_id = source_manager_get_type_once ();
		g_once_init_leave (&source_manager_type_id__once, source_manager_type_id);
	}
	return source_manager_type_id__once;
}

static void
_vala_source_manager_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	SourceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SOURCE_MANAGER, SourceManager);
	switch (property_id) {
		case SOURCE_MANAGER_CACHED_SCHEMAS_PROPERTY:
		value_set_schema_path_tree (value, source_manager_get_cached_schemas (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_source_manager_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	SourceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SOURCE_MANAGER, SourceManager);
	switch (property_id) {
		case SOURCE_MANAGER_CACHED_SCHEMAS_PROPERTY:
		source_manager_set_cached_schemas (self, value_get_schema_path_tree (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
schema_path_tree_get_instance_private (SchemaPathTree* self)
{
	return G_STRUCT_MEMBER_P (self, SchemaPathTree_private_offset);
}

static void
_cached_schema_info_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (cached_schema_info_unref (var), NULL));
}

static void
_schema_path_tree_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (schema_path_tree_unref (var), NULL));
}

SchemaPathTree*
schema_path_tree_construct (GType object_type,
                            const gchar* path_segment)
{
	SchemaPathTree* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (path_segment != NULL, NULL);
	self = (SchemaPathTree*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (path_segment);
	_g_free0 (self->priv->path_segment);
	self->priv->path_segment = _tmp0_;
	return self;
}

SchemaPathTree*
schema_path_tree_new (const gchar* path_segment)
{
	return schema_path_tree_construct (TYPE_SCHEMA_PATH_TREE, path_segment);
}

guint
schema_path_tree_get_schema_count (SchemaPathTree* self,
                                   const gchar* path)
{
	guint schemas_count = 0U;
	guint subpaths_count = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (path != NULL, 0U);
	schemas_count = (guint) 0;
	subpaths_count = (guint) 0;
	schema_path_tree_get_content_count (self, path, &_tmp0_, &_tmp1_);
	schemas_count = _tmp0_;
	subpaths_count = _tmp1_;
	result = schemas_count;
	return result;
}

void
schema_path_tree_get_content_count (SchemaPathTree* self,
                                    const gchar* path,
                                    guint* schemas_count,
                                    guint* subpaths_count)
{
	guint _vala_schemas_count = 0U;
	guint _vala_subpaths_count = 0U;
	GHashTable* path_schemas = NULL;
	GHashTable* subpaths = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	schema_path_tree_lookup (self, path, &_tmp0_, &_tmp1_);
	_g_hash_table_unref0 (path_schemas);
	path_schemas = _tmp0_;
	_g_hash_table_unref0 (subpaths);
	subpaths = _tmp1_;
	_tmp2_ = g_hash_table_size (path_schemas);
	_tmp3_ = _tmp2_;
	_vala_schemas_count = _tmp3_;
	_tmp4_ = g_hash_table_size (subpaths);
	_tmp5_ = _tmp4_;
	_vala_subpaths_count = _tmp5_;
	_g_hash_table_unref0 (subpaths);
	_g_hash_table_unref0 (path_schemas);
	if (schemas_count) {
		*schemas_count = _vala_schemas_count;
	}
	if (subpaths_count) {
		*subpaths_count = _vala_subpaths_count;
	}
}

static guint
__lambda21_ (GSettingsSchema* schema)
{
	GHashFunc _tmp0_;
	const gchar* _tmp1_;
	guint result;
	g_return_val_if_fail (schema != NULL, 0U);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_settings_schema_get_id (schema);
	result = _tmp0_ (_tmp1_);
	return result;
}

static guint
___lambda21__ghash_func (gconstpointer key)
{
	guint result;
	result = __lambda21_ ((GSettingsSchema*) key);
	return result;
}

static gboolean
__lambda22_ (GSettingsSchema* schema1,
             GSettingsSchema* schema2)
{
	GEqualFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (schema1 != NULL, FALSE);
	g_return_val_if_fail (schema2 != NULL, FALSE);
	_tmp0_ = g_str_equal;
	_tmp1_ = g_settings_schema_get_id (schema1);
	_tmp2_ = g_settings_schema_get_id (schema2);
	result = _tmp0_ (_tmp1_, _tmp2_);
	return result;
}

static gboolean
___lambda22__gequal_func (gconstpointer a,
                          gconstpointer b)
{
	gboolean result;
	result = __lambda22_ ((GSettingsSchema*) a, (GSettingsSchema*) b);
	return result;
}

static void
_g_settings_schema_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL));
}

gboolean
schema_path_tree_lookup (SchemaPathTree* self,
                         const gchar* path,
                         GHashTable** path_schemas,
                         GHashTable** subpaths)
{
	GHashTable* _vala_path_schemas = NULL;
	GHashTable* _vala_subpaths = NULL;
	GHashTable* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	gint _tmp4_ = 0;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_hash_table_new_full (___lambda21__ghash_func, ___lambda22__gequal_func, NULL, _g_settings_schema_unref0_);
	_g_hash_table_unref0 (_vala_path_schemas);
	_vala_path_schemas = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, _g_free0_);
	_g_hash_table_unref0 (_vala_subpaths);
	_vala_subpaths = _tmp3_;
	_tmp5_ = schema_path_tree_to_segments (path, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_tmp7_ = schema_path_tree_lookup_segments (self, _tmp6_, (gint) _tmp4_, 0, &_vala_path_schemas, &_vala_subpaths);
	_tmp8_ = _tmp7_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp8_;
	if (path_schemas) {
		*path_schemas = _vala_path_schemas;
	} else {
		_g_hash_table_unref0 (_vala_path_schemas);
	}
	if (subpaths) {
		*subpaths = _vala_subpaths;
	} else {
		_g_hash_table_unref0 (_vala_subpaths);
	}
	return result;
}

static gpointer
_cached_schema_info_ref0 (gpointer self)
{
	return self ? cached_schema_info_ref (self) : NULL;
}

static gpointer
_g_settings_schema_ref0 (gpointer self)
{
	return self ? g_settings_schema_ref (self) : NULL;
}

static gboolean
schema_path_tree_lookup_segments (SchemaPathTree* self,
                                  gchar** path_segments,
                                  gint path_segments_length1,
                                  gint matched_prefix_length,
                                  GHashTable** path_schemas,
                                  GHashTable** subpaths)
{
	gboolean found = FALSE;
	SchemaPathTree* _tmp13_;
	SchemaPathTree* existing_subtree = NULL;
	GHashTable* _tmp16_;
	const gchar* _tmp17_;
	gconstpointer _tmp18_;
	SchemaPathTree* _tmp19_;
	SchemaPathTree* _tmp20_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (*path_schemas != NULL, FALSE);
	g_return_val_if_fail (*subpaths != NULL, FALSE);
	if (matched_prefix_length == path_segments_length1) {
		GHashTable* _tmp0_;
		GList* _tmp1_;
		GHashTable* _tmp6_;
		GList* _tmp7_;
		_tmp0_ = self->priv->schemas;
		_tmp1_ = g_hash_table_get_values (_tmp0_);
		{
			GList* schema_info_collection = NULL;
			GList* schema_info_it = NULL;
			schema_info_collection = _tmp1_;
			for (schema_info_it = schema_info_collection; schema_info_it != NULL; schema_info_it = schema_info_it->next) {
				CachedSchemaInfo* _tmp2_;
				CachedSchemaInfo* schema_info = NULL;
				_tmp2_ = _cached_schema_info_ref0 ((CachedSchemaInfo*) schema_info_it->data);
				schema_info = _tmp2_;
				{
					CachedSchemaInfo* _tmp3_;
					GSettingsSchema* _tmp4_;
					GSettingsSchema* _tmp5_;
					_tmp3_ = schema_info;
					_tmp4_ = _tmp3_->schema;
					_tmp5_ = _g_settings_schema_ref0 (_tmp4_);
					g_hash_table_add (*path_schemas, _tmp5_);
					_cached_schema_info_unref0 (schema_info);
				}
			}
			(schema_info_collection == NULL) ? NULL : (schema_info_collection = (g_list_free (schema_info_collection), NULL));
		}
		_tmp6_ = self->priv->subtrees;
		_tmp7_ = g_hash_table_get_values (_tmp6_);
		{
			GList* subtree_collection = NULL;
			GList* subtree_it = NULL;
			subtree_collection = _tmp7_;
			for (subtree_it = subtree_collection; subtree_it != NULL; subtree_it = subtree_it->next) {
				SchemaPathTree* _tmp8_;
				SchemaPathTree* subtree = NULL;
				_tmp8_ = _schema_path_tree_ref0 ((SchemaPathTree*) subtree_it->data);
				subtree = _tmp8_;
				{
					SchemaPathTree* _tmp9_;
					_tmp9_ = subtree;
					if (schema_path_tree_has_non_wildcard_content (_tmp9_)) {
						SchemaPathTree* _tmp10_;
						const gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp10_ = subtree;
						_tmp11_ = _tmp10_->priv->path_segment;
						_tmp12_ = g_strdup (_tmp11_);
						g_hash_table_add (*subpaths, _tmp12_);
					}
					_schema_path_tree_unref0 (subtree);
				}
			}
			(subtree_collection == NULL) ? NULL : (subtree_collection = (g_list_free (subtree_collection), NULL));
		}
		result = TRUE;
		return result;
	}
	found = FALSE;
	_tmp13_ = self->priv->wildcard_subtree;
	if (_tmp13_ != NULL) {
		SchemaPathTree* _tmp14_;
		gboolean _tmp15_;
		_tmp14_ = self->priv->wildcard_subtree;
		_tmp15_ = schema_path_tree_lookup_segments (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_SCHEMA_PATH_TREE, SchemaPathTree), path_segments, (gint) path_segments_length1, matched_prefix_length + 1, path_schemas, subpaths);
		if (_tmp15_) {
			found = TRUE;
		}
	}
	_tmp16_ = self->priv->subtrees;
	_tmp17_ = path_segments[matched_prefix_length];
	_tmp18_ = g_hash_table_lookup (_tmp16_, _tmp17_);
	_tmp19_ = _schema_path_tree_ref0 ((SchemaPathTree*) _tmp18_);
	existing_subtree = _tmp19_;
	_tmp20_ = existing_subtree;
	if (_tmp20_ != NULL) {
		SchemaPathTree* _tmp21_;
		gboolean _tmp22_;
		_tmp21_ = existing_subtree;
		_tmp22_ = schema_path_tree_lookup_segments (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_SCHEMA_PATH_TREE, SchemaPathTree), path_segments, (gint) path_segments_length1, matched_prefix_length + 1, path_schemas, subpaths);
		if (_tmp22_) {
			found = TRUE;
		}
	}
	result = found;
	_schema_path_tree_unref0 (existing_subtree);
	return result;
}

void
schema_path_tree_add_schema (SchemaPathTree* self,
                             GSettingsSchema* schema,
                             GHashTable* modified_path_specs)
{
	gchar* schema_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	CachedSchemaInfo* _tmp3_;
	CachedSchemaInfo* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (modified_path_specs != NULL);
	_tmp0_ = g_settings_schema_get_path (schema);
	_tmp1_ = g_strdup (_tmp0_);
	schema_path = _tmp1_;
	_tmp2_ = schema_path;
	if (_tmp2_ == NULL) {
		_g_free0 (schema_path);
		return;
	}
	_tmp3_ = cached_schema_info_new (schema, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = schema_path;
	_tmp7_ = schema_path_tree_to_segments ((const gchar*) _tmp5_, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	schema_path_tree_add_schema_to_path_spec (self, _tmp4_, _tmp8_, (gint) _tmp6_, 0, modified_path_specs);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_cached_schema_info_unref0 (_tmp4_);
	_g_free0 (schema_path);
}

static Block46Data*
block46_data_ref (Block46Data* _data46_)
{
	g_atomic_int_inc (&_data46_->_ref_count_);
	return _data46_;
}

static void
block46_data_unref (void * _userdata_)
{
	Block46Data* _data46_;
	_data46_ = (Block46Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data46_->_ref_count_)) {
		SchemaPathTree* self;
		self = _data46_->self;
		_g_settings_schema_unref0 (_data46_->schema);
		_g_hash_table_unref0 (_data46_->modified_path_specs);
		_schema_path_tree_unref0 (self);
		g_slice_free (Block46Data, _data46_);
	}
}

static void
__lambda23_ (Block46Data* _data46_,
             const gchar* path_spec)
{
	SchemaPathTree* self;
	CachedSchemaInfo* _tmp0_;
	CachedSchemaInfo* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	self = _data46_->self;
	g_return_if_fail (path_spec != NULL);
	_tmp0_ = cached_schema_info_new (_data46_->schema, &_data46_->fingerprint);
	_tmp1_ = _tmp0_;
	_tmp3_ = schema_path_tree_to_segments (path_spec, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	schema_path_tree_add_schema_to_path_spec (self, _tmp1_, _tmp4_, (gint) _tmp2_, 0, _data46_->modified_path_specs);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_cached_schema_info_unref0 (_tmp1_);
}

static void
___lambda23__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda23_ (self, (const gchar*) data);
}

void
schema_path_tree_add_schema_with_path_specs (SchemaPathTree* self,
                                             GSettingsSchema* schema,
                                             GHashTable* path_specs,
                                             GHashTable* modified_path_specs)
{
	Block46Data* _data46_;
	GSettingsSchema* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (path_specs != NULL);
	g_return_if_fail (modified_path_specs != NULL);
	_data46_ = g_slice_new0 (Block46Data);
	_data46_->_ref_count_ = 1;
	_data46_->self = schema_path_tree_ref (self);
	_tmp0_ = _g_settings_schema_ref0 (schema);
	_g_settings_schema_unref0 (_data46_->schema);
	_data46_->schema = _tmp0_;
	_tmp1_ = _g_hash_table_ref0 (modified_path_specs);
	_g_hash_table_unref0 (_data46_->modified_path_specs);
	_data46_->modified_path_specs = _tmp1_;
	_data46_->fingerprint = cached_schema_info_compute_schema_fingerprint (_data46_->schema);
	_vala_g_hash_set_foreach (path_specs, ___lambda23__gfunc, _data46_);
	block46_data_unref (_data46_);
	_data46_ = NULL;
}

static gboolean
schema_path_tree_add_schema_to_path_spec (SchemaPathTree* self,
                                          CachedSchemaInfo* schema_info,
                                          gchar** path_spec,
                                          gint path_spec_length1,
                                          gint matched_prefix_length,
                                          GHashTable* modified_path_specs)
{
	gchar* segment = NULL;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (schema_info != NULL, FALSE);
	g_return_val_if_fail (modified_path_specs != NULL, FALSE);
	if (matched_prefix_length == path_spec_length1) {
		CachedSchemaInfo* existing_schema_info = NULL;
		GHashTable* _tmp0_;
		GSettingsSchema* _tmp1_;
		const gchar* _tmp2_;
		gconstpointer _tmp3_;
		CachedSchemaInfo* _tmp4_;
		gboolean _tmp5_ = FALSE;
		CachedSchemaInfo* _tmp6_;
		GHashTable* _tmp12_;
		GSettingsSchema* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		CachedSchemaInfo* _tmp16_;
		gchar* _tmp17_;
		_tmp0_ = self->priv->schemas;
		_tmp1_ = schema_info->schema;
		_tmp2_ = g_settings_schema_get_id (_tmp1_);
		_tmp3_ = g_hash_table_lookup (_tmp0_, _tmp2_);
		_tmp4_ = _cached_schema_info_ref0 ((CachedSchemaInfo*) _tmp3_);
		existing_schema_info = _tmp4_;
		_tmp6_ = existing_schema_info;
		if (_tmp6_ != NULL) {
			CachedSchemaInfo* _tmp7_;
			_tmp7_ = existing_schema_info;
			_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_CACHED_SCHEMA_INFO, CachedSchemaInfo)->fingerprint == schema_info->fingerprint;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			CachedSchemaInfo* _tmp8_;
			GSettingsSchema* _tmp9_;
			GSettingsSchema* _tmp10_;
			CachedSchemaInfo* _tmp11_;
			_tmp8_ = existing_schema_info;
			_tmp9_ = schema_info->schema;
			_tmp10_ = _g_settings_schema_ref0 (_tmp9_);
			_g_settings_schema_unref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CACHED_SCHEMA_INFO, CachedSchemaInfo)->schema);
			G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CACHED_SCHEMA_INFO, CachedSchemaInfo)->schema = _tmp10_;
			_tmp11_ = existing_schema_info;
			G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_CACHED_SCHEMA_INFO, CachedSchemaInfo)->marked = TRUE;
			result = FALSE;
			_cached_schema_info_unref0 (existing_schema_info);
			return result;
		}
		_tmp12_ = self->priv->schemas;
		_tmp13_ = schema_info->schema;
		_tmp14_ = g_settings_schema_get_id (_tmp13_);
		_tmp15_ = g_strdup (_tmp14_);
		_tmp16_ = _cached_schema_info_ref0 (schema_info);
		g_hash_table_insert (_tmp12_, _tmp15_, _tmp16_);
		_tmp17_ = schema_path_tree_to_path (path_spec, (gint) path_spec_length1);
		g_hash_table_add (modified_path_specs, _tmp17_);
		result = TRUE;
		_cached_schema_info_unref0 (existing_schema_info);
		return result;
	}
	_tmp18_ = path_spec[matched_prefix_length];
	_tmp19_ = g_strdup (_tmp18_);
	segment = _tmp19_;
	_tmp20_ = segment;
	if (g_strcmp0 (_tmp20_, "") == 0) {
		SchemaPathTree* _tmp21_;
		SchemaPathTree* _tmp23_;
		_tmp21_ = self->priv->wildcard_subtree;
		if (_tmp21_ == NULL) {
			SchemaPathTree* _tmp22_;
			_tmp22_ = schema_path_tree_new ("");
			_schema_path_tree_unref0 (self->priv->wildcard_subtree);
			self->priv->wildcard_subtree = _tmp22_;
		}
		_tmp23_ = self->priv->wildcard_subtree;
		result = schema_path_tree_add_schema_to_path_spec (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_SCHEMA_PATH_TREE, SchemaPathTree), schema_info, path_spec, (gint) path_spec_length1, matched_prefix_length + 1, modified_path_specs);
		_g_free0 (segment);
		return result;
	} else {
		SchemaPathTree* existing_subtree = NULL;
		GHashTable* _tmp24_;
		const gchar* _tmp25_;
		gconstpointer _tmp26_;
		SchemaPathTree* _tmp27_;
		SchemaPathTree* _tmp28_;
		SchemaPathTree* _tmp39_;
		_tmp24_ = self->priv->subtrees;
		_tmp25_ = segment;
		_tmp26_ = g_hash_table_lookup (_tmp24_, _tmp25_);
		_tmp27_ = _schema_path_tree_ref0 ((SchemaPathTree*) _tmp26_);
		existing_subtree = _tmp27_;
		_tmp28_ = existing_subtree;
		if (_tmp28_ == NULL) {
			SchemaPathTree* new_subtree = NULL;
			const gchar* _tmp29_;
			SchemaPathTree* _tmp30_;
			GHashTable* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			SchemaPathTree* _tmp34_;
			SchemaPathTree* _tmp35_;
			SchemaPathTree* _tmp36_;
			SchemaPathTree* _tmp37_;
			gchar* _tmp38_;
			_tmp29_ = segment;
			_tmp30_ = schema_path_tree_new (_tmp29_);
			new_subtree = _tmp30_;
			_tmp31_ = self->priv->subtrees;
			_tmp32_ = segment;
			_tmp33_ = g_strdup (_tmp32_);
			_tmp34_ = new_subtree;
			_tmp35_ = _schema_path_tree_ref0 (_tmp34_);
			g_hash_table_insert (_tmp31_, _tmp33_, _tmp35_);
			_tmp36_ = new_subtree;
			_tmp37_ = _schema_path_tree_ref0 (_tmp36_);
			_schema_path_tree_unref0 (existing_subtree);
			existing_subtree = _tmp37_;
			_tmp38_ = schema_path_tree_to_path (path_spec + 0, (gint) (matched_prefix_length - 0));
			g_hash_table_add (modified_path_specs, _tmp38_);
			_schema_path_tree_unref0 (new_subtree);
		}
		_tmp39_ = existing_subtree;
		result = schema_path_tree_add_schema_to_path_spec (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_SCHEMA_PATH_TREE, SchemaPathTree), schema_info, path_spec, (gint) path_spec_length1, matched_prefix_length + 1, modified_path_specs);
		_schema_path_tree_unref0 (existing_subtree);
		_g_free0 (segment);
		return result;
	}
}

void
schema_path_tree_remove_unmarked (SchemaPathTree* self,
                                  GHashTable* modified_path_specs)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (modified_path_specs != NULL);
	schema_path_tree_remove_unmarked_from_path (self, "/", modified_path_specs);
}

static Block47Data*
block47_data_ref (Block47Data* _data47_)
{
	g_atomic_int_inc (&_data47_->_ref_count_);
	return _data47_;
}

static void
block47_data_unref (void * _userdata_)
{
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
		SchemaPathTree* self;
		self = _data47_->self;
		_schema_path_tree_unref0 (self);
		g_slice_free (Block47Data, _data47_);
	}
}

static gboolean
__lambda24_ (Block47Data* _data47_,
             const gchar* schema_id,
             CachedSchemaInfo* cached_schema_info)
{
	SchemaPathTree* self;
	gboolean result;
	self = _data47_->self;
	g_return_val_if_fail (schema_id != NULL, FALSE);
	g_return_val_if_fail (cached_schema_info != NULL, FALSE);
	if (!cached_schema_info->marked) {
		_data47_->modified = TRUE;
		result = TRUE;
		return result;
	}
	cached_schema_info->marked = FALSE;
	result = FALSE;
	return result;
}

static gboolean
___lambda24__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = __lambda24_ (self, (const gchar*) key, (CachedSchemaInfo*) value);
	return result;
}

static void
_vala_array_add26 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
schema_path_tree_remove_unmarked_from_path (SchemaPathTree* self,
                                            const gchar* path_spec,
                                            GHashTable* modified_path_specs)
{
	Block47Data* _data47_;
	GHashTable* _tmp0_;
	SchemaPathTree* _tmp1_;
	gchar** empty_subtrees = NULL;
	gchar** _tmp6_;
	gint empty_subtrees_length1;
	gint _empty_subtrees_size_;
	GHashTable* _tmp7_;
	GList* _tmp8_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path_spec != NULL);
	g_return_if_fail (modified_path_specs != NULL);
	_data47_ = g_slice_new0 (Block47Data);
	_data47_->_ref_count_ = 1;
	_data47_->self = schema_path_tree_ref (self);
	_data47_->modified = FALSE;
	_tmp0_ = self->priv->schemas;
	g_hash_table_foreach_remove (_tmp0_, ___lambda24__ghr_func, _data47_);
	_tmp1_ = self->priv->wildcard_subtree;
	if (_tmp1_ != NULL) {
		SchemaPathTree* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		SchemaPathTree* _tmp5_;
		_tmp2_ = self->priv->wildcard_subtree;
		_tmp3_ = g_strconcat (path_spec, "/", NULL);
		_tmp4_ = _tmp3_;
		schema_path_tree_remove_unmarked_from_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_SCHEMA_PATH_TREE, SchemaPathTree), _tmp4_, modified_path_specs);
		_g_free0 (_tmp4_);
		_tmp5_ = self->priv->wildcard_subtree;
		if (schema_path_tree_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_SCHEMA_PATH_TREE, SchemaPathTree))) {
			_schema_path_tree_unref0 (self->priv->wildcard_subtree);
			self->priv->wildcard_subtree = NULL;
		}
	}
	_tmp6_ = g_new0 (gchar*, 0 + 1);
	empty_subtrees = _tmp6_;
	empty_subtrees_length1 = 0;
	_empty_subtrees_size_ = empty_subtrees_length1;
	_tmp7_ = self->priv->subtrees;
	_tmp8_ = g_hash_table_get_values (_tmp7_);
	{
		GList* subtree_collection = NULL;
		GList* subtree_it = NULL;
		subtree_collection = _tmp8_;
		for (subtree_it = subtree_collection; subtree_it != NULL; subtree_it = subtree_it->next) {
			SchemaPathTree* _tmp9_;
			SchemaPathTree* subtree = NULL;
			_tmp9_ = _schema_path_tree_ref0 ((SchemaPathTree*) subtree_it->data);
			subtree = _tmp9_;
			{
				SchemaPathTree* _tmp10_;
				SchemaPathTree* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				SchemaPathTree* _tmp17_;
				_tmp10_ = subtree;
				_tmp11_ = subtree;
				_tmp12_ = _tmp11_->priv->path_segment;
				_tmp13_ = g_strconcat (path_spec, _tmp12_, NULL);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strconcat (_tmp14_, "/", NULL);
				_tmp16_ = _tmp15_;
				schema_path_tree_remove_unmarked_from_path (_tmp10_, _tmp16_, modified_path_specs);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp14_);
				_tmp17_ = subtree;
				if (schema_path_tree_is_empty (_tmp17_)) {
					SchemaPathTree* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp18_ = subtree;
					_tmp19_ = _tmp18_->priv->path_segment;
					_tmp20_ = g_strdup (_tmp19_);
					_vala_array_add26 (&empty_subtrees, &empty_subtrees_length1, &_empty_subtrees_size_, _tmp20_);
				}
				_schema_path_tree_unref0 (subtree);
			}
		}
		(subtree_collection == NULL) ? NULL : (subtree_collection = (g_list_free (subtree_collection), NULL));
	}
	_tmp21_ = empty_subtrees;
	_tmp21__length1 = empty_subtrees_length1;
	if (_tmp21__length1 > 0) {
		gchar** _tmp22_;
		gint _tmp22__length1;
		_tmp22_ = empty_subtrees;
		_tmp22__length1 = empty_subtrees_length1;
		{
			gchar** empty_subtree_segment_collection = NULL;
			gint empty_subtree_segment_collection_length1 = 0;
			gint _empty_subtree_segment_collection_size_ = 0;
			gint empty_subtree_segment_it = 0;
			empty_subtree_segment_collection = _tmp22_;
			empty_subtree_segment_collection_length1 = _tmp22__length1;
			for (empty_subtree_segment_it = 0; empty_subtree_segment_it < empty_subtree_segment_collection_length1; empty_subtree_segment_it = empty_subtree_segment_it + 1) {
				gchar* _tmp23_;
				gchar* empty_subtree_segment = NULL;
				_tmp23_ = g_strdup (empty_subtree_segment_collection[empty_subtree_segment_it]);
				empty_subtree_segment = _tmp23_;
				{
					GHashTable* _tmp24_;
					const gchar* _tmp25_;
					_tmp24_ = self->priv->subtrees;
					_tmp25_ = empty_subtree_segment;
					g_hash_table_remove (_tmp24_, _tmp25_);
					_g_free0 (empty_subtree_segment);
				}
			}
		}
		_data47_->modified = TRUE;
	}
	if (_data47_->modified) {
		gchar* _tmp26_;
		_tmp26_ = g_strdup (path_spec);
		g_hash_table_add (modified_path_specs, _tmp26_);
	}
	empty_subtrees = (_vala_array_free (empty_subtrees, empty_subtrees_length1, (GDestroyNotify) g_free), NULL);
	block47_data_unref (_data47_);
	_data47_ = NULL;
}

static gboolean
schema_path_tree_has_non_wildcard_content (SchemaPathTree* self)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->schemas;
	if (g_hash_table_size (_tmp1_) > ((guint) 0)) {
		_tmp0_ = TRUE;
	} else {
		GHashTable* _tmp2_;
		_tmp2_ = self->priv->subtrees;
		_tmp0_ = g_hash_table_size (_tmp2_) > ((guint) 0);
	}
	result = _tmp0_;
	return result;
}

static gboolean
schema_path_tree_is_empty (SchemaPathTree* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GHashTable* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->priv->schemas;
	if (g_hash_table_size (_tmp2_) == ((guint) 0)) {
		SchemaPathTree* _tmp3_;
		_tmp3_ = self->priv->wildcard_subtree;
		_tmp1_ = _tmp3_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GHashTable* _tmp4_;
		_tmp4_ = self->priv->subtrees;
		_tmp0_ = g_hash_table_size (_tmp4_) == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar**
schema_path_tree_to_segments (const gchar* path,
                              gint* result_length1)
{
	gint _tmp2_ = 0;
	gint from = 0;
	gint _tmp3_ = 0;
	gint to = 0;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** result;
	g_return_val_if_fail (path != NULL, NULL);
	if (g_strcmp0 (path, "/") == 0) {
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = g_new0 (gchar*, 0 + 1);
		_tmp1_ = _tmp0_;
		_tmp1__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	}
	if (g_str_has_prefix (path, "/")) {
		_tmp2_ = 1;
	} else {
		_tmp2_ = 0;
	}
	from = _tmp2_;
	if (g_str_has_suffix (path, "/")) {
		_tmp3_ = -1;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen (path);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_;
	}
	to = _tmp3_;
	_tmp6_ = string_slice (path, (glong) from, (glong) to);
	_tmp7_ = _tmp6_;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "/", 0);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _vala_array_length (_tmp8_);
	_g_free0 (_tmp7_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp10__length1;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gchar*
schema_path_tree_to_path (gchar** segments,
                          gint segments_length1)
{
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	if (segments_length1 == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("/");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = _vala_g_strjoinv ("/", (gchar**) segments, (gint) ((segments_length1 * sizeof (gchar*)) / sizeof (gchar*)));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("/", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "/", NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static void
value_schema_path_tree_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_schema_path_tree_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		schema_path_tree_unref (value->data[0].v_pointer);
	}
}

static void
value_schema_path_tree_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = schema_path_tree_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_schema_path_tree_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_schema_path_tree_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SchemaPathTree * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = schema_path_tree_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_schema_path_tree_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	SchemaPathTree ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = schema_path_tree_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_schema_path_tree (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecSchemaPathTree* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCHEMA_PATH_TREE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_schema_path_tree (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA_PATH_TREE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_schema_path_tree (GValue* value,
                            gpointer v_object)
{
	SchemaPathTree * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA_PATH_TREE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCHEMA_PATH_TREE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		schema_path_tree_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		schema_path_tree_unref (old);
	}
}

void
value_take_schema_path_tree (GValue* value,
                             gpointer v_object)
{
	SchemaPathTree * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCHEMA_PATH_TREE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCHEMA_PATH_TREE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		schema_path_tree_unref (old);
	}
}

static void
schema_path_tree_class_init (SchemaPathTreeClass * klass,
                             gpointer klass_data)
{
	schema_path_tree_parent_class = g_type_class_peek_parent (klass);
	((SchemaPathTreeClass *) klass)->finalize = schema_path_tree_finalize;
	g_type_class_adjust_private_offset (klass, &SchemaPathTree_private_offset);
}

static void
schema_path_tree_instance_init (SchemaPathTree * self,
                                gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	self->priv = schema_path_tree_get_instance_private (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _cached_schema_info_unref0_);
	self->priv->schemas = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _schema_path_tree_unref0_);
	self->priv->subtrees = _tmp5_;
	self->priv->wildcard_subtree = NULL;
	self->ref_count = 1;
}

static void
schema_path_tree_finalize (SchemaPathTree * obj)
{
	SchemaPathTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCHEMA_PATH_TREE, SchemaPathTree);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->path_segment);
	_g_hash_table_unref0 (self->priv->schemas);
	_g_hash_table_unref0 (self->priv->subtrees);
	_schema_path_tree_unref0 (self->priv->wildcard_subtree);
}

static GType
schema_path_tree_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_schema_path_tree_init, value_schema_path_tree_free_value, value_schema_path_tree_copy_value, value_schema_path_tree_peek_pointer, "p", value_schema_path_tree_collect_value, "p", value_schema_path_tree_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SchemaPathTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) schema_path_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SchemaPathTree), 0, (GInstanceInitFunc) schema_path_tree_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType schema_path_tree_type_id;
	schema_path_tree_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SchemaPathTree", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SchemaPathTree_private_offset = g_type_add_instance_private (schema_path_tree_type_id, sizeof (SchemaPathTreePrivate));
	return schema_path_tree_type_id;
}

GType
schema_path_tree_get_type (void)
{
	static volatile gsize schema_path_tree_type_id__once = 0;
	if (g_once_init_enter (&schema_path_tree_type_id__once)) {
		GType schema_path_tree_type_id;
		schema_path_tree_type_id = schema_path_tree_get_type_once ();
		g_once_init_leave (&schema_path_tree_type_id__once, schema_path_tree_type_id);
	}
	return schema_path_tree_type_id__once;
}

gpointer
schema_path_tree_ref (gpointer instance)
{
	SchemaPathTree * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
schema_path_tree_unref (gpointer instance)
{
	SchemaPathTree * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCHEMA_PATH_TREE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

gulong
cached_schema_info_compute_schema_fingerprint (GSettingsSchema* schema)
{
	gulong result;
	result = (gulong) 0;
	return result;
}

CachedSchemaInfo*
cached_schema_info_construct (GType object_type,
                              GSettingsSchema* schema,
                              gulong* fingerprint)
{
	CachedSchemaInfo* self = NULL;
	GSettingsSchema* _tmp0_;
	g_return_val_if_fail (schema != NULL, NULL);
	self = (CachedSchemaInfo*) g_type_create_instance (object_type);
	_tmp0_ = _g_settings_schema_ref0 (schema);
	_g_settings_schema_unref0 (self->schema);
	self->schema = _tmp0_;
	if (fingerprint != NULL) {
		self->fingerprint = (gulong) (*fingerprint);
	} else {
		self->fingerprint = cached_schema_info_compute_schema_fingerprint (schema);
	}
	self->marked = TRUE;
	return self;
}

CachedSchemaInfo*
cached_schema_info_new (GSettingsSchema* schema,
                        gulong* fingerprint)
{
	return cached_schema_info_construct (TYPE_CACHED_SCHEMA_INFO, schema, fingerprint);
}

static void
value_cached_schema_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_cached_schema_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		cached_schema_info_unref (value->data[0].v_pointer);
	}
}

static void
value_cached_schema_info_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = cached_schema_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_cached_schema_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_cached_schema_info_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CachedSchemaInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = cached_schema_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_cached_schema_info_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	CachedSchemaInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = cached_schema_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_cached_schema_info (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecCachedSchemaInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CACHED_SCHEMA_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_cached_schema_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CACHED_SCHEMA_INFO), NULL);
	return value->data[0].v_pointer;
}

void
value_set_cached_schema_info (GValue* value,
                              gpointer v_object)
{
	CachedSchemaInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CACHED_SCHEMA_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CACHED_SCHEMA_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		cached_schema_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		cached_schema_info_unref (old);
	}
}

void
value_take_cached_schema_info (GValue* value,
                               gpointer v_object)
{
	CachedSchemaInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CACHED_SCHEMA_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CACHED_SCHEMA_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		cached_schema_info_unref (old);
	}
}

static void
cached_schema_info_class_init (CachedSchemaInfoClass * klass,
                               gpointer klass_data)
{
	cached_schema_info_parent_class = g_type_class_peek_parent (klass);
	((CachedSchemaInfoClass *) klass)->finalize = cached_schema_info_finalize;
}

static void
cached_schema_info_instance_init (CachedSchemaInfo * self,
                                  gpointer klass)
{
	self->ref_count = 1;
}

static void
cached_schema_info_finalize (CachedSchemaInfo * obj)
{
	CachedSchemaInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CACHED_SCHEMA_INFO, CachedSchemaInfo);
	g_signal_handlers_destroy (self);
	_g_settings_schema_unref0 (self->schema);
}

static GType
cached_schema_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_cached_schema_info_init, value_cached_schema_info_free_value, value_cached_schema_info_copy_value, value_cached_schema_info_peek_pointer, "p", value_cached_schema_info_collect_value, "p", value_cached_schema_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CachedSchemaInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cached_schema_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CachedSchemaInfo), 0, (GInstanceInitFunc) cached_schema_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType cached_schema_info_type_id;
	cached_schema_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CachedSchemaInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return cached_schema_info_type_id;
}

GType
cached_schema_info_get_type (void)
{
	static volatile gsize cached_schema_info_type_id__once = 0;
	if (g_once_init_enter (&cached_schema_info_type_id__once)) {
		GType cached_schema_info_type_id;
		cached_schema_info_type_id = cached_schema_info_get_type_once ();
		g_once_init_leave (&cached_schema_info_type_id__once, cached_schema_info_type_id);
	}
	return cached_schema_info_type_id__once;
}

gpointer
cached_schema_info_ref (gpointer instance)
{
	CachedSchemaInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
cached_schema_info_unref (gpointer instance)
{
	CachedSchemaInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CACHED_SCHEMA_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

