/* contacts-contact-sheet.c generated by valac 0.56.0, the Vala compiler
 * generated from contacts-contact-sheet.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "contacts.h"
#include <gtk/gtk.h>
#include <folks/folks.h>
#include <gee.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define PROFILE_SIZE 128
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_CONTACT_SHEET_ROW (contacts_contact_sheet_row_get_type ())
#define CONTACTS_CONTACT_SHEET_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET_ROW, ContactsContactSheetRow))
#define CONTACTS_CONTACT_SHEET_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET_ROW, ContactsContactSheetRowClass))
#define CONTACTS_IS_CONTACT_SHEET_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET_ROW))
#define CONTACTS_IS_CONTACT_SHEET_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET_ROW))
#define CONTACTS_CONTACT_SHEET_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET_ROW, ContactsContactSheetRowClass))

typedef struct _ContactsContactSheetRow ContactsContactSheetRow;
typedef struct _ContactsContactSheetRowClass ContactsContactSheetRowClass;
typedef struct _ContactsContactSheetRowPrivate ContactsContactSheetRowPrivate;
enum  {
	CONTACTS_CONTACT_SHEET_ROW_0_PROPERTY,
	CONTACTS_CONTACT_SHEET_ROW_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_sheet_row_properties[CONTACTS_CONTACT_SHEET_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define CONTACTS_TYPE_CONTACT_SHEET (contacts_contact_sheet_get_type ())
#define CONTACTS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheet))
#define CONTACTS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))
#define CONTACTS_IS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_IS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_CONTACT_SHEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))

typedef struct _ContactsContactSheet ContactsContactSheet;
typedef struct _ContactsContactSheetClass ContactsContactSheetClass;
typedef struct _ContactsContactSheetPrivate ContactsContactSheetPrivate;
enum  {
	CONTACTS_CONTACT_SHEET_0_PROPERTY,
	CONTACTS_CONTACT_SHEET_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_sheet_properties[CONTACTS_CONTACT_SHEET_NUM_PROPERTIES];
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

#define CONTACTS_TYPE_AVATAR (contacts_avatar_get_type ())
#define CONTACTS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatar))
#define CONTACTS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))
#define CONTACTS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR))
#define CONTACTS_IS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR))
#define CONTACTS_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))

typedef struct _ContactsAvatar ContactsAvatar;
typedef struct _ContactsAvatarClass ContactsAvatarClass;
typedef struct _Block17Data Block17Data;
typedef struct _Block18Data Block18Data;

#define CONTACTS_TYPE_MAIN_WINDOW (contacts_main_window_get_type ())
#define CONTACTS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow))
#define CONTACTS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))
#define CONTACTS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))

typedef struct _ContactsMainWindow ContactsMainWindow;
typedef struct _ContactsMainWindowClass ContactsMainWindowClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;

struct _ContactsContactSheetRow {
	AdwActionRow parent_instance;
	ContactsContactSheetRowPrivate * priv;
};

struct _ContactsContactSheetRowClass {
	AdwActionRowClass parent_class;
};

struct _ContactsContactSheet {
	GtkGrid parent_instance;
	ContactsContactSheetPrivate * priv;
};

struct _ContactsContactSheetClass {
	GtkGridClass parent_class;
};

struct _ContactsContactSheetPrivate {
	gint last_row;
	FolksIndividual* individual;
	ContactsStore* store;
};

struct _Block17Data {
	int _ref_count_;
	ContactsContactSheet* self;
	FolksEmailFieldDetails* email;
};

struct _Block18Data {
	int _ref_count_;
	ContactsContactSheet* self;
	FolksUrlFieldDetails* url;
	GtkButton* button;
};

struct _Block19Data {
	int _ref_count_;
	ContactsContactSheet* self;
	FolksPostalAddressFieldDetails* addr;
};

struct _Block20Data {
	int _ref_count_;
	Block19Data * _data19_;
	GtkButton* button;
};

static gpointer contacts_contact_sheet_row_parent_class = NULL;
static gint ContactsContactSheet_private_offset;
static gpointer contacts_contact_sheet_parent_class = NULL;

VALA_EXTERN GType contacts_contact_sheet_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSheetRow, g_object_unref)
VALA_EXTERN ContactsContactSheetRow* contacts_contact_sheet_row_new (const gchar* property_name,
                                                         const gchar* title,
                                                         const gchar* subtitle);
VALA_EXTERN ContactsContactSheetRow* contacts_contact_sheet_row_construct (GType object_type,
                                                               const gchar* property_name,
                                                               const gchar* title,
                                                               const gchar* subtitle);
VALA_EXTERN GtkButton* contacts_contact_sheet_row_add_button (ContactsContactSheetRow* self,
                                                  const gchar* icon);
static GObject * contacts_contact_sheet_row_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static GType contacts_contact_sheet_row_get_type_once (void);
VALA_EXTERN GType contacts_contact_sheet_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSheet, g_object_unref)
VALA_EXTERN ContactsContactSheet* contacts_contact_sheet_new (FolksIndividual* individual,
                                                  ContactsStore* store);
VALA_EXTERN ContactsContactSheet* contacts_contact_sheet_construct (GType object_type,
                                                        FolksIndividual* individual,
                                                        ContactsStore* store);
static void contacts_contact_sheet_update (ContactsContactSheet* self);
static void _contacts_contact_sheet_update_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void _contacts_contact_sheet_update_folks_individual_personas_changed (FolksIndividual* _sender,
                                                                       GeeSet* added,
                                                                       GeeSet* removed,
                                                                       gpointer self);
static void _contacts_contact_sheet_update_contacts_store_quiescent (ContactsStore* _sender,
                                                              gpointer self);
static GtkLabel* contacts_contact_sheet_create_persona_store_label (ContactsContactSheet* self,
                                                             FolksPersona* p);
static void contacts_contact_sheet_attach_rows (ContactsContactSheet* self,
                                         GList* rows);
static void contacts_contact_sheet_attach_row (ContactsContactSheet* self,
                                        GtkListBoxRow* row);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GtkWidget* contacts_contact_sheet_create_header (ContactsContactSheet* self);
static void contacts_contact_sheet_add_row_for_property (ContactsContactSheet* self,
                                                  FolksPersona* persona,
                                                  const gchar* property);
VALA_EXTERN GType contacts_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatar, g_object_unref)
VALA_EXTERN ContactsAvatar* contacts_avatar_new (gint size,
                                     FolksIndividual* individual);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct (GType object_type,
                                           gint size,
                                           FolksIndividual* individual);
static void contacts_contact_sheet_add_emails (ContactsContactSheet* self,
                                        FolksPersona* persona,
                                        const gchar* property);
static void contacts_contact_sheet_add_phone_nrs (ContactsContactSheet* self,
                                           FolksPersona* persona,
                                           const gchar* property);
static void contacts_contact_sheet_add_im_addresses (ContactsContactSheet* self,
                                              FolksPersona* persona,
                                              const gchar* property);
static void contacts_contact_sheet_add_urls (ContactsContactSheet* self,
                                      FolksPersona* persona,
                                      const gchar* property);
static void contacts_contact_sheet_add_nickname (ContactsContactSheet* self,
                                          FolksPersona* persona,
                                          const gchar* property);
static void contacts_contact_sheet_add_birthday (ContactsContactSheet* self,
                                          FolksPersona* persona,
                                          const gchar* property);
static void contacts_contact_sheet_add_notes (ContactsContactSheet* self,
                                       FolksPersona* persona,
                                       const gchar* property);
static void contacts_contact_sheet_add_postal_addresses (ContactsContactSheet* self,
                                                  FolksPersona* persona,
                                                  const gchar* property);
static void contacts_contact_sheet_add_roles (ContactsContactSheet* self,
                                       FolksPersona* persona,
                                       const gchar* property);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void ____lambda13_ (Block17Data* _data17_);
static void _____lambda13__gtk_button_clicked (GtkButton* _sender,
                                        gpointer self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void ____lambda14_ (Block18Data* _data18_);
VALA_EXTERN GType contacts_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsMainWindow, g_object_unref)
static gchar* contacts_contact_sheet_fallback_to_https (ContactsContactSheet* self,
                                                 const gchar* url);
static void _____lambda14__gtk_button_clicked (GtkButton* _sender,
                                        gpointer self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void _____lambda15_ (Block20Data* _data20_);
static void ______lambda15__gtk_button_clicked (GtkButton* _sender,
                                         gpointer self);
static GObject * contacts_contact_sheet_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void contacts_contact_sheet_finalize (GObject * obj);
static GType contacts_contact_sheet_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* CONTACTS_CONTACT_SHEET_SORTED_PROPERTIES[9] = {"email-addresses", "phone-numbers", "im-addresses", "roles", "urls", "nickname", "birthday", "postal-addresses", "notes"};

ContactsContactSheetRow*
contacts_contact_sheet_row_construct (GType object_type,
                                      const gchar* property_name,
                                      const gchar* title,
                                      const gchar* subtitle)
{
	ContactsContactSheetRow * self = NULL;
	const gchar* icon_name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (property_name != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (ContactsContactSheetRow*) g_object_new (object_type, NULL);
	_tmp0_ = contacts_utils_get_icon_name_for_property (property_name);
	icon_name = _tmp0_;
	_tmp1_ = icon_name;
	if (_tmp1_ != NULL) {
		GtkImage* icon = NULL;
		const gchar* _tmp2_;
		GtkImage* _tmp3_;
		GtkImage* _tmp4_;
		GtkImage* _tmp5_;
		const gchar* _tmp6_;
		GtkImage* _tmp7_;
		_tmp2_ = icon_name;
		_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp2_);
		g_object_ref_sink (_tmp3_);
		icon = _tmp3_;
		_tmp4_ = icon;
		gtk_widget_add_css_class ((GtkWidget*) _tmp4_, "contacts-property-icon");
		_tmp5_ = icon;
		_tmp6_ = contacts_utils_get_display_name_for_property (property_name);
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _tmp6_);
		_tmp7_ = icon;
		adw_action_row_add_prefix ((AdwActionRow*) self, (GtkWidget*) _tmp7_);
		_g_object_unref0 (icon);
	}
	_tmp8_ = g_markup_escape_text (title, (gssize) -1);
	_tmp9_ = _tmp8_;
	adw_preferences_row_set_title ((AdwPreferencesRow*) self, _tmp9_);
	_g_free0 (_tmp9_);
	if (subtitle != NULL) {
		adw_action_row_set_subtitle ((AdwActionRow*) self, subtitle);
	}
	return self;
}

ContactsContactSheetRow*
contacts_contact_sheet_row_new (const gchar* property_name,
                                const gchar* title,
                                const gchar* subtitle)
{
	return contacts_contact_sheet_row_construct (CONTACTS_TYPE_CONTACT_SHEET_ROW, property_name, title, subtitle);
}

GtkButton*
contacts_contact_sheet_row_add_button (ContactsContactSheetRow* self,
                                       const gchar* icon)
{
	GtkButton* button = NULL;
	GtkButton* _tmp0_;
	GtkButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new_from_icon_name (icon);
	g_object_ref_sink (_tmp0_);
	button = _tmp0_;
	gtk_widget_set_valign ((GtkWidget*) button, GTK_ALIGN_CENTER);
	gtk_widget_add_css_class ((GtkWidget*) button, "flat");
	adw_action_row_add_suffix ((AdwActionRow*) self, (GtkWidget*) button);
	result = button;
	return result;
}

static GObject *
contacts_contact_sheet_row_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactSheetRow * self;
	GObjectClass* _tmp0_;
	GParamSpec* _tmp1_;
	parent_class = G_OBJECT_CLASS (contacts_contact_sheet_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_SHEET_ROW, ContactsContactSheetRow);
	_tmp0_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp1_ = g_object_class_find_property (_tmp0_, "title-selectable");
	if (_tmp1_ != NULL) {
		GValue _tmp2_ = {0};
		g_value_init (&_tmp2_, G_TYPE_BOOLEAN);
		g_value_set_boolean (&_tmp2_, TRUE);
		g_object_set_property ((GObject*) self, "title-selectable", &_tmp2_);
		G_IS_VALUE (&_tmp2_) ? (g_value_unset (&_tmp2_), NULL) : NULL;
	}
	return obj;
}

static void
contacts_contact_sheet_row_class_init (ContactsContactSheetRowClass * klass,
                                       gpointer klass_data)
{
	contacts_contact_sheet_row_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_sheet_row_constructor;
}

static void
contacts_contact_sheet_row_instance_init (ContactsContactSheetRow * self,
                                          gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
contacts_contact_sheet_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactSheetRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_sheet_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactSheetRow), 0, (GInstanceInitFunc) contacts_contact_sheet_row_instance_init, NULL };
	GType contacts_contact_sheet_row_type_id;
	contacts_contact_sheet_row_type_id = g_type_register_static (adw_action_row_get_type (), "ContactsContactSheetRow", &g_define_type_info, 0);
	return contacts_contact_sheet_row_type_id;
}

GType
contacts_contact_sheet_row_get_type (void)
{
	static volatile gsize contacts_contact_sheet_row_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_sheet_row_type_id__once)) {
		GType contacts_contact_sheet_row_type_id;
		contacts_contact_sheet_row_type_id = contacts_contact_sheet_row_get_type_once ();
		g_once_init_leave (&contacts_contact_sheet_row_type_id__once, contacts_contact_sheet_row_type_id);
	}
	return contacts_contact_sheet_row_type_id__once;
}

static inline gpointer
contacts_contact_sheet_get_instance_private (ContactsContactSheet* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactSheet_private_offset);
}

static void
_contacts_contact_sheet_update_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	contacts_contact_sheet_update ((ContactsContactSheet*) self);
}

static void
_contacts_contact_sheet_update_folks_individual_personas_changed (FolksIndividual* _sender,
                                                                  GeeSet* added,
                                                                  GeeSet* removed,
                                                                  gpointer self)
{
	contacts_contact_sheet_update ((ContactsContactSheet*) self);
}

static void
_contacts_contact_sheet_update_contacts_store_quiescent (ContactsStore* _sender,
                                                         gpointer self)
{
	contacts_contact_sheet_update ((ContactsContactSheet*) self);
}

ContactsContactSheet*
contacts_contact_sheet_construct (GType object_type,
                                  FolksIndividual* individual,
                                  ContactsStore* store)
{
	ContactsContactSheet * self = NULL;
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	g_return_val_if_fail (individual != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	self = (ContactsContactSheet*) g_object_new (object_type, NULL);
	self->priv->individual = individual;
	self->priv->store = store;
	_tmp0_ = self->priv->individual;
	g_signal_connect_object ((GObject*) _tmp0_, "notify", (GCallback) _contacts_contact_sheet_update_g_object_notify, self, 0);
	_tmp1_ = self->priv->individual;
	g_signal_connect_object (_tmp1_, "personas-changed", (GCallback) _contacts_contact_sheet_update_folks_individual_personas_changed, self, 0);
	g_signal_connect_object (store, "quiescent", (GCallback) _contacts_contact_sheet_update_contacts_store_quiescent, self, 0);
	contacts_contact_sheet_update (self);
	return self;
}

ContactsContactSheet*
contacts_contact_sheet_new (FolksIndividual* individual,
                            ContactsStore* store)
{
	return contacts_contact_sheet_construct (CONTACTS_TYPE_CONTACT_SHEET, individual, store);
}

static GtkLabel*
contacts_contact_sheet_create_persona_store_label (ContactsContactSheet* self,
                                                   FolksPersona* p)
{
	GtkLabel* store_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	PangoAttrList* attrList = NULL;
	PangoAttrList* _tmp4_;
	PangoAttribute* _tmp5_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = contacts_utils_format_persona_store_name_for_contact (p);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	store_name = _tmp3_;
	_tmp4_ = pango_attr_list_new ();
	attrList = _tmp4_;
	_tmp5_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (attrList, _tmp5_);
	gtk_label_set_attributes (store_name, attrList);
	gtk_widget_set_halign ((GtkWidget*) store_name, GTK_ALIGN_START);
	gtk_label_set_ellipsize (store_name, PANGO_ELLIPSIZE_MIDDLE);
	result = store_name;
	_pango_attr_list_unref0 (attrList);
	return result;
}

static void
contacts_contact_sheet_attach_rows (ContactsContactSheet* self,
                                    GList* rows)
{
	GtkListBox* list_box = NULL;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	GtkListBox* _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	if (rows == NULL) {
		return;
	}
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp0_);
	list_box = _tmp0_;
	_tmp1_ = list_box;
	gtk_list_box_set_selection_mode (_tmp1_, GTK_SELECTION_NONE);
	_tmp2_ = list_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, "boxed-list");
	_tmp3_ = list_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, "contacts-sheet-property");
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = rows;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkListBoxRow* row = NULL;
			row = (GtkListBoxRow*) row_it->data;
			{
				GtkListBox* _tmp4_;
				GtkListBoxRow* _tmp5_;
				_tmp4_ = list_box;
				_tmp5_ = row;
				gtk_list_box_append (_tmp4_, (GtkWidget*) _tmp5_);
			}
		}
	}
	_tmp6_ = list_box;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp6_, 0, self->priv->last_row, 3, 1);
	_tmp7_ = self->priv->last_row;
	self->priv->last_row = _tmp7_ + 1;
	_g_object_unref0 (list_box);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
contacts_contact_sheet_attach_row (ContactsContactSheet* self,
                                   GtkListBoxRow* row)
{
	GList* rows = NULL;
	GtkListBoxRow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	rows = NULL;
	_tmp0_ = _g_object_ref0 (row);
	rows = g_list_prepend (rows, _tmp0_);
	contacts_contact_sheet_attach_rows (self, rows);
	(rows == NULL) ? NULL : (rows = (_g_list_free__g_object_unref0_ (rows), NULL));
}

static void
contacts_contact_sheet_update (ContactsContactSheet* self)
{
	GtkWidget* child = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* header = NULL;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	gint _tmp8_;
	GListModel* personas = NULL;
	FolksIndividual* _tmp9_;
	GListModel* _tmp10_;
	g_return_if_fail (self != NULL);
	self->priv->last_row = 0;
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	child = _tmp0_;
	while (TRUE) {
		GtkWidget* _tmp1_;
		GtkWidget* next = NULL;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp1_ = child;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = child;
		_tmp3_ = gtk_widget_get_next_sibling (_tmp2_);
		next = _tmp3_;
		_tmp4_ = child;
		gtk_grid_remove ((GtkGrid*) self, _tmp4_);
		_tmp5_ = next;
		child = _tmp5_;
	}
	_tmp6_ = contacts_contact_sheet_create_header (self);
	header = _tmp6_;
	_tmp7_ = header;
	gtk_grid_attach ((GtkGrid*) self, _tmp7_, 0, 0, 1, 1);
	_tmp8_ = self->priv->last_row;
	self->priv->last_row = _tmp8_ + 1;
	_tmp9_ = self->priv->individual;
	_tmp10_ = contacts_utils_get_personas_for_display (_tmp9_);
	personas = _tmp10_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				GListModel* _tmp13_;
				FolksPersona* p = NULL;
				GListModel* _tmp14_;
				GObject* _tmp15_;
				gint persona_store_pos = 0;
				gboolean is_empty_persona = FALSE;
				gboolean _tmp22_ = FALSE;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = personas;
				if (!(((guint) i) < g_list_model_get_n_items (_tmp13_))) {
					break;
				}
				_tmp14_ = personas;
				_tmp15_ = g_list_model_get_item (_tmp14_, (guint) i);
				p = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, FOLKS_TYPE_PERSONA, FolksPersona);
				persona_store_pos = self->priv->last_row;
				if (i > 0) {
					FolksPersona* _tmp16_;
					GtkLabel* _tmp17_;
					GtkLabel* _tmp18_;
					gint _tmp19_;
					_tmp16_ = p;
					_tmp17_ = contacts_contact_sheet_create_persona_store_label (self, _tmp16_);
					_tmp18_ = _tmp17_;
					gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp18_, 0, self->priv->last_row, 3, 1);
					_g_object_unref0 (_tmp18_);
					_tmp19_ = self->priv->last_row;
					self->priv->last_row = _tmp19_ + 1;
				}
				{
					const gchar** prop_collection = NULL;
					gint prop_collection_length1 = 0;
					gint _prop_collection_size_ = 0;
					gint prop_it = 0;
					prop_collection = CONTACTS_CONTACT_SHEET_SORTED_PROPERTIES;
					prop_collection_length1 = G_N_ELEMENTS (CONTACTS_CONTACT_SHEET_SORTED_PROPERTIES);
					for (prop_it = 0; prop_it < prop_collection_length1; prop_it = prop_it + 1) {
						const gchar* prop = NULL;
						prop = prop_collection[prop_it];
						{
							FolksPersona* _tmp20_;
							const gchar* _tmp21_;
							_tmp20_ = p;
							_tmp21_ = prop;
							contacts_contact_sheet_add_row_for_property (self, _tmp20_, _tmp21_);
						}
					}
				}
				is_empty_persona = self->priv->last_row == (persona_store_pos + 1);
				if (i > 0) {
					_tmp22_ = is_empty_persona;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					gint _tmp23_;
					gtk_grid_remove_row ((GtkGrid*) self, persona_store_pos);
					_tmp23_ = self->priv->last_row;
					self->priv->last_row = _tmp23_ - 1;
				}
				_g_object_unref0 (p);
			}
		}
	}
	_g_object_unref0 (personas);
	_g_object_unref0 (header);
}

static GtkWidget*
contacts_contact_sheet_create_header (ContactsContactSheet* self)
{
	GtkBox* header = NULL;
	GtkBox* _tmp0_;
	ContactsAvatar* image_frame = NULL;
	FolksIndividual* _tmp1_;
	ContactsAvatar* _tmp2_;
	GtkLabel* name_label = NULL;
	GtkLabel* _tmp3_;
	FolksIndividual* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 18);
	g_object_ref_sink (_tmp0_);
	header = _tmp0_;
	gtk_widget_add_css_class ((GtkWidget*) header, "contacts-sheet-header");
	_tmp1_ = self->priv->individual;
	_tmp2_ = contacts_avatar_new (PROFILE_SIZE, _tmp1_);
	g_object_ref_sink (_tmp2_);
	image_frame = _tmp2_;
	gtk_widget_set_vexpand ((GtkWidget*) image_frame, FALSE);
	gtk_widget_set_valign ((GtkWidget*) image_frame, GTK_ALIGN_START);
	gtk_box_append (header, (GtkWidget*) image_frame);
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp3_);
	name_label = _tmp3_;
	_tmp4_ = self->priv->individual;
	_tmp5_ = folks_individual_get_display_name (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_label_set_markup (name_label, _tmp6_);
	gtk_widget_set_hexpand ((GtkWidget*) name_label, TRUE);
	gtk_label_set_xalign (name_label, 0.f);
	gtk_label_set_wrap (name_label, TRUE);
	gtk_label_set_lines (name_label, 4);
	gtk_label_set_width_chars (name_label, 10);
	gtk_label_set_selectable (name_label, TRUE);
	gtk_widget_set_can_focus ((GtkWidget*) name_label, FALSE);
	gtk_widget_add_css_class ((GtkWidget*) name_label, "title-1");
	gtk_box_append (header, (GtkWidget*) name_label);
	result = (GtkWidget*) header;
	_g_object_unref0 (name_label);
	_g_object_unref0 (image_frame);
	return result;
}

static void
contacts_contact_sheet_add_row_for_property (ContactsContactSheet* self,
                                             FolksPersona* persona,
                                             const gchar* property)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (property != NULL);
	_tmp0_ = property;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("email-addresses")))) {
		switch (0) {
			default:
			{
				contacts_contact_sheet_add_emails (self, persona, property);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("phone-numbers")))) {
		switch (0) {
			default:
			{
				contacts_contact_sheet_add_phone_nrs (self, persona, property);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("im-addresses")))) {
		switch (0) {
			default:
			{
				contacts_contact_sheet_add_im_addresses (self, persona, property);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("urls")))) {
		switch (0) {
			default:
			{
				contacts_contact_sheet_add_urls (self, persona, property);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("nickname")))) {
		switch (0) {
			default:
			{
				contacts_contact_sheet_add_nickname (self, persona, property);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("birthday")))) {
		switch (0) {
			default:
			{
				contacts_contact_sheet_add_birthday (self, persona, property);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("notes")))) {
		switch (0) {
			default:
			{
				contacts_contact_sheet_add_notes (self, persona, property);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("postal-addresses")))) {
		switch (0) {
			default:
			{
				contacts_contact_sheet_add_postal_addresses (self, persona, property);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("roles")))) {
		switch (0) {
			default:
			{
				contacts_contact_sheet_add_roles (self, persona, property);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_debug ("contacts-contact-sheet.vala:217: Unsupported property: %s", property);
				break;
			}
		}
	}
}

static void
contacts_contact_sheet_add_roles (ContactsContactSheet* self,
                                  FolksPersona* persona,
                                  const gchar* property)
{
	FolksRoleDetails* details = NULL;
	FolksRoleDetails* _tmp0_;
	GeeList* roles = NULL;
	FolksRoleDetails* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeList* _tmp4_;
	GList* rows = NULL;
	GList* _tmp54_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (property != NULL);
	details = G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_ROLE_DETAILS) ? ((FolksRoleDetails*) persona) : NULL;
	_tmp0_ = details;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = details;
	_tmp2_ = folks_role_details_get_roles (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_utils_sort_fields (FOLKS_TYPE_ROLE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeCollection*) _tmp3_);
	roles = _tmp4_;
	rows = NULL;
	{
		GeeList* _role_list = NULL;
		GeeList* _tmp5_;
		gint _role_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _role_index = 0;
		_tmp5_ = roles;
		_role_list = _tmp5_;
		_tmp6_ = _role_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_role_size = _tmp8_;
		_role_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			FolksRoleFieldDetails* role = NULL;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			FolksRoleFieldDetails* _tmp13_;
			gconstpointer _tmp14_;
			gconstpointer _tmp15_;
			gchar* role_str = NULL;
			gchar* _tmp16_;
			FolksRoleFieldDetails* _tmp17_;
			gconstpointer _tmp18_;
			gconstpointer _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			ContactsContactSheetRow* row = NULL;
			const gchar* _tmp50_;
			ContactsContactSheetRow* _tmp51_;
			ContactsContactSheetRow* _tmp52_;
			GtkListBoxRow* _tmp53_;
			_role_index = _role_index + 1;
			_tmp9_ = _role_index;
			_tmp10_ = _role_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _role_list;
			_tmp12_ = gee_list_get (_tmp11_, _role_index);
			role = (FolksRoleFieldDetails*) _tmp12_;
			_tmp13_ = role;
			_tmp14_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp13_);
			_tmp15_ = _tmp14_;
			if (folks_role_is_empty ((FolksRole*) _tmp15_)) {
				_g_object_unref0 (role);
				continue;
			}
			_tmp16_ = g_strdup ("");
			role_str = _tmp16_;
			_tmp17_ = role;
			_tmp18_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = folks_role_get_title ((FolksRole*) _tmp19_);
			_tmp21_ = _tmp20_;
			if (g_strcmp0 (_tmp21_, "") != 0) {
				FolksRoleFieldDetails* _tmp22_;
				gconstpointer _tmp23_;
				gconstpointer _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				_tmp22_ = role;
				_tmp23_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = folks_role_get_organisation_name ((FolksRole*) _tmp24_);
				_tmp26_ = _tmp25_;
				if (g_strcmp0 (_tmp26_, "") != 0) {
					FolksRoleFieldDetails* _tmp27_;
					gconstpointer _tmp28_;
					gconstpointer _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					FolksRoleFieldDetails* _tmp32_;
					gconstpointer _tmp33_;
					gconstpointer _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					_tmp27_ = role;
					_tmp28_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = folks_role_get_title ((FolksRole*) _tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = role;
					_tmp33_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = folks_role_get_organisation_name ((FolksRole*) _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = g_strdup_printf (_ ("%s at %s"), _tmp31_, _tmp36_);
					_g_free0 (role_str);
					role_str = _tmp37_;
				} else {
					FolksRoleFieldDetails* _tmp38_;
					gconstpointer _tmp39_;
					gconstpointer _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					gchar* _tmp43_;
					_tmp38_ = role;
					_tmp39_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = folks_role_get_title ((FolksRole*) _tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = g_strdup (_tmp42_);
					_g_free0 (role_str);
					role_str = _tmp43_;
				}
			} else {
				FolksRoleFieldDetails* _tmp44_;
				gconstpointer _tmp45_;
				gconstpointer _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_;
				_tmp44_ = role;
				_tmp45_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = folks_role_get_organisation_name ((FolksRole*) _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strdup (_tmp48_);
				_g_free0 (role_str);
				role_str = _tmp49_;
			}
			_tmp50_ = role_str;
			_tmp51_ = contacts_contact_sheet_row_new (property, _tmp50_, NULL);
			g_object_ref_sink (_tmp51_);
			row = _tmp51_;
			_tmp52_ = row;
			_tmp53_ = _g_object_ref0 ((GtkListBoxRow*) _tmp52_);
			rows = g_list_append (rows, _tmp53_);
			_g_object_unref0 (row);
			_g_free0 (role_str);
			_g_object_unref0 (role);
		}
	}
	_tmp54_ = rows;
	contacts_contact_sheet_attach_rows (self, _tmp54_);
	(rows == NULL) ? NULL : (rows = (_g_list_free__g_object_unref0_ (rows), NULL));
	_g_object_unref0 (roles);
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->email);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static void
____lambda13_ (Block17Data* _data17_)
{
	ContactsContactSheet* self;
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksEmailFieldDetails* _tmp3_;
	gconstpointer _tmp4_;
	gconstpointer _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	self = _data17_->self;
	_tmp0_ = self->priv->individual;
	_tmp1_ = folks_individual_get_display_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data17_->email;
	_tmp4_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s <%s>", _tmp2_, (const gchar*) _tmp5_);
	_tmp7_ = _tmp6_;
	contacts_utils_compose_mail (_tmp7_);
	_g_free0 (_tmp7_);
}

static void
_____lambda13__gtk_button_clicked (GtkButton* _sender,
                                   gpointer self)
{
	____lambda13_ (self);
}

static void
contacts_contact_sheet_add_emails (ContactsContactSheet* self,
                                   FolksPersona* persona,
                                   const gchar* property)
{
	FolksEmailDetails* details = NULL;
	FolksEmailDetails* _tmp0_;
	GeeList* emails = NULL;
	FolksEmailDetails* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeList* _tmp4_;
	GList* rows = NULL;
	GList* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (property != NULL);
	details = G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_EMAIL_DETAILS) ? ((FolksEmailDetails*) persona) : NULL;
	_tmp0_ = details;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = details;
	_tmp2_ = folks_email_details_get_email_addresses (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_utils_sort_fields (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeCollection*) _tmp3_);
	emails = _tmp4_;
	rows = NULL;
	{
		GeeList* _email_list = NULL;
		GeeList* _tmp5_;
		gint _email_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _email_index = 0;
		_tmp5_ = emails;
		_email_list = _tmp5_;
		_tmp6_ = _email_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_email_size = _tmp8_;
		_email_index = -1;
		while (TRUE) {
			Block17Data* _data17_;
			gint _tmp9_;
			gint _tmp10_;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			FolksEmailFieldDetails* _tmp13_;
			gconstpointer _tmp14_;
			gconstpointer _tmp15_;
			ContactsContactSheetRow* row = NULL;
			FolksEmailFieldDetails* _tmp16_;
			gconstpointer _tmp17_;
			gconstpointer _tmp18_;
			ContactsTypeSet* _tmp19_;
			ContactsTypeSet* _tmp20_;
			FolksEmailFieldDetails* _tmp21_;
			const gchar* _tmp22_;
			ContactsContactSheetRow* _tmp23_;
			GtkButton* button = NULL;
			ContactsContactSheetRow* _tmp24_;
			GtkButton* _tmp25_;
			GtkButton* _tmp26_;
			FolksEmailFieldDetails* _tmp27_;
			gconstpointer _tmp28_;
			gconstpointer _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			GtkButton* _tmp32_;
			ContactsContactSheetRow* _tmp33_;
			GtkListBoxRow* _tmp34_;
			_data17_ = g_slice_new0 (Block17Data);
			_data17_->_ref_count_ = 1;
			_data17_->self = g_object_ref (self);
			_email_index = _email_index + 1;
			_tmp9_ = _email_index;
			_tmp10_ = _email_size;
			if (!(_tmp9_ < _tmp10_)) {
				block17_data_unref (_data17_);
				_data17_ = NULL;
				break;
			}
			_tmp11_ = _email_list;
			_tmp12_ = gee_list_get (_tmp11_, _email_index);
			_data17_->email = (FolksEmailFieldDetails*) _tmp12_;
			_tmp13_ = _data17_->email;
			_tmp14_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp13_);
			_tmp15_ = _tmp14_;
			if (g_strcmp0 ((const gchar*) _tmp15_, "") == 0) {
				block17_data_unref (_data17_);
				_data17_ = NULL;
				continue;
			}
			_tmp16_ = _data17_->email;
			_tmp17_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = contacts_typeset_get_email ();
			_tmp20_ = _tmp19_;
			_tmp21_ = _data17_->email;
			_tmp22_ = contacts_typeset_format_type (_tmp20_, (FolksAbstractFieldDetails*) _tmp21_);
			_tmp23_ = contacts_contact_sheet_row_new (property, (const gchar*) _tmp18_, _tmp22_);
			g_object_ref_sink (_tmp23_);
			row = _tmp23_;
			_tmp24_ = row;
			_tmp25_ = contacts_contact_sheet_row_add_button (_tmp24_, "mail-send-symbolic");
			button = _tmp25_;
			_tmp26_ = button;
			_tmp27_ = _data17_->email;
			_tmp28_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf ("Send an email to %s", (const gchar*) _tmp29_);
			_tmp31_ = _tmp30_;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp26_, _ (_tmp31_));
			_g_free0 (_tmp31_);
			_tmp32_ = button;
			g_signal_connect_data (_tmp32_, "clicked", (GCallback) _____lambda13__gtk_button_clicked, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
			_tmp33_ = row;
			_tmp34_ = _g_object_ref0 ((GtkListBoxRow*) _tmp33_);
			rows = g_list_append (rows, _tmp34_);
			_g_object_unref0 (button);
			_g_object_unref0 (row);
			block17_data_unref (_data17_);
			_data17_ = NULL;
		}
	}
	_tmp35_ = rows;
	contacts_contact_sheet_attach_rows (self, _tmp35_);
	(rows == NULL) ? NULL : (rows = (_g_list_free__g_object_unref0_ (rows), NULL));
	_g_object_unref0 (emails);
}

static void
contacts_contact_sheet_add_phone_nrs (ContactsContactSheet* self,
                                      FolksPersona* persona,
                                      const gchar* property)
{
	FolksPhoneDetails* phone_details = NULL;
	FolksPhoneDetails* _tmp0_;
	GeeList* phones = NULL;
	FolksPhoneDetails* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeList* _tmp4_;
	GList* rows = NULL;
	GList* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (property != NULL);
	phone_details = G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_PHONE_DETAILS) ? ((FolksPhoneDetails*) persona) : NULL;
	_tmp0_ = phone_details;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = phone_details;
	_tmp2_ = folks_phone_details_get_phone_numbers (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_utils_sort_fields (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeCollection*) _tmp3_);
	phones = _tmp4_;
	rows = NULL;
	{
		GeeList* _phone_list = NULL;
		GeeList* _tmp5_;
		gint _phone_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _phone_index = 0;
		_tmp5_ = phones;
		_phone_list = _tmp5_;
		_tmp6_ = _phone_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_phone_size = _tmp8_;
		_phone_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			FolksPhoneFieldDetails* phone = NULL;
			GeeList* _tmp11_;
			gpointer _tmp12_;
			FolksPhoneFieldDetails* _tmp13_;
			gconstpointer _tmp14_;
			gconstpointer _tmp15_;
			ContactsContactSheetRow* row = NULL;
			FolksPhoneFieldDetails* _tmp16_;
			gconstpointer _tmp17_;
			gconstpointer _tmp18_;
			ContactsTypeSet* _tmp19_;
			ContactsTypeSet* _tmp20_;
			FolksPhoneFieldDetails* _tmp21_;
			const gchar* _tmp22_;
			ContactsContactSheetRow* _tmp23_;
			ContactsContactSheetRow* _tmp24_;
			GtkListBoxRow* _tmp25_;
			_phone_index = _phone_index + 1;
			_tmp9_ = _phone_index;
			_tmp10_ = _phone_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _phone_list;
			_tmp12_ = gee_list_get (_tmp11_, _phone_index);
			phone = (FolksPhoneFieldDetails*) _tmp12_;
			_tmp13_ = phone;
			_tmp14_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp13_);
			_tmp15_ = _tmp14_;
			if (g_strcmp0 ((const gchar*) _tmp15_, "") == 0) {
				_g_object_unref0 (phone);
				continue;
			}
			_tmp16_ = phone;
			_tmp17_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = contacts_typeset_get_phone ();
			_tmp20_ = _tmp19_;
			_tmp21_ = phone;
			_tmp22_ = contacts_typeset_format_type (_tmp20_, (FolksAbstractFieldDetails*) _tmp21_);
			_tmp23_ = contacts_contact_sheet_row_new (property, (const gchar*) _tmp18_, _tmp22_);
			g_object_ref_sink (_tmp23_);
			row = _tmp23_;
			_tmp24_ = row;
			_tmp25_ = _g_object_ref0 ((GtkListBoxRow*) _tmp24_);
			rows = g_list_append (rows, _tmp25_);
			_g_object_unref0 (row);
			_g_object_unref0 (phone);
		}
	}
	_tmp26_ = rows;
	contacts_contact_sheet_attach_rows (self, _tmp26_);
	(rows == NULL) ? NULL : (rows = (_g_list_free__g_object_unref0_ (rows), NULL));
	_g_object_unref0 (phones);
}

static void
contacts_contact_sheet_add_im_addresses (ContactsContactSheet* self,
                                         FolksPersona* persona,
                                         const gchar* property)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (property != NULL);
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->button);
		_g_object_unref0 (_data18_->url);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
____lambda14_ (Block18Data* _data18_)
{
	ContactsContactSheet* self;
	ContactsMainWindow* window = NULL;
	GtkButton* _tmp0_;
	GtkRoot* _tmp1_;
	ContactsMainWindow* _tmp2_;
	ContactsMainWindow* _tmp3_;
	FolksUrlFieldDetails* _tmp4_;
	gconstpointer _tmp5_;
	gconstpointer _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self = _data18_->self;
	_tmp0_ = _data18_->button;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) _tmp0_);
	window = CONTACTS_IS_MAIN_WINDOW (_tmp1_) ? ((ContactsMainWindow*) _tmp1_) : NULL;
	_tmp2_ = window;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = window;
	_tmp4_ = _data18_->url;
	_tmp5_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = contacts_contact_sheet_fallback_to_https (self, (const gchar*) _tmp6_);
	_tmp8_ = _tmp7_;
	gtk_show_uri ((GtkWindow*) _tmp3_, _tmp8_, (guint32) GDK_CURRENT_TIME);
	_g_free0 (_tmp8_);
}

static void
_____lambda14__gtk_button_clicked (GtkButton* _sender,
                                   gpointer self)
{
	____lambda14_ (self);
}

static void
contacts_contact_sheet_add_urls (ContactsContactSheet* self,
                                 FolksPersona* persona,
                                 const gchar* property)
{
	FolksUrlDetails* url_details = NULL;
	FolksUrlDetails* _tmp0_;
	GList* rows = NULL;
	GList* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (property != NULL);
	url_details = G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_URL_DETAILS) ? ((FolksUrlDetails*) persona) : NULL;
	_tmp0_ = url_details;
	if (_tmp0_ == NULL) {
		return;
	}
	rows = NULL;
	{
		GeeIterator* _url_it = NULL;
		FolksUrlDetails* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp1_ = url_details;
		_tmp2_ = folks_url_details_get_urls (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_url_it = _tmp4_;
		while (TRUE) {
			Block18Data* _data18_;
			GeeIterator* _tmp5_;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			FolksUrlFieldDetails* _tmp8_;
			gconstpointer _tmp9_;
			gconstpointer _tmp10_;
			ContactsContactSheetRow* row = NULL;
			FolksUrlFieldDetails* _tmp11_;
			gconstpointer _tmp12_;
			gconstpointer _tmp13_;
			ContactsContactSheetRow* _tmp14_;
			ContactsContactSheetRow* _tmp15_;
			GtkButton* _tmp16_;
			GtkButton* _tmp17_;
			GtkButton* _tmp18_;
			ContactsContactSheetRow* _tmp19_;
			GtkListBoxRow* _tmp20_;
			_data18_ = g_slice_new0 (Block18Data);
			_data18_->_ref_count_ = 1;
			_data18_->self = g_object_ref (self);
			_tmp5_ = _url_it;
			if (!gee_iterator_next (_tmp5_)) {
				block18_data_unref (_data18_);
				_data18_ = NULL;
				break;
			}
			_tmp6_ = _url_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			_data18_->url = (FolksUrlFieldDetails*) _tmp7_;
			_tmp8_ = _data18_->url;
			_tmp9_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 ((const gchar*) _tmp10_, "") == 0) {
				block18_data_unref (_data18_);
				_data18_ = NULL;
				continue;
			}
			_tmp11_ = _data18_->url;
			_tmp12_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = contacts_contact_sheet_row_new (property, (const gchar*) _tmp13_, NULL);
			g_object_ref_sink (_tmp14_);
			row = _tmp14_;
			_tmp15_ = row;
			_tmp16_ = contacts_contact_sheet_row_add_button (_tmp15_, "external-link-symbolic");
			_data18_->button = _tmp16_;
			_tmp17_ = _data18_->button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp17_, _ ("Visit website"));
			_tmp18_ = _data18_->button;
			g_signal_connect_data (_tmp18_, "clicked", (GCallback) _____lambda14__gtk_button_clicked, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
			_tmp19_ = row;
			_tmp20_ = _g_object_ref0 ((GtkListBoxRow*) _tmp19_);
			rows = g_list_append (rows, _tmp20_);
			_g_object_unref0 (row);
			block18_data_unref (_data18_);
			_data18_ = NULL;
		}
		_g_object_unref0 (_url_it);
	}
	_tmp21_ = rows;
	contacts_contact_sheet_attach_rows (self, _tmp21_);
	(rows == NULL) ? NULL : (rows = (_g_list_free__g_object_unref0_ (rows), NULL));
}

static gchar*
contacts_contact_sheet_fallback_to_https (ContactsContactSheet* self,
                                          const gchar* url)
{
	gchar* scheme = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	_tmp0_ = g_uri_parse_scheme (url);
	scheme = _tmp0_;
	_tmp1_ = scheme;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strconcat ("https://", url, NULL);
		result = _tmp2_;
		_g_free0 (scheme);
		return result;
	}
	_tmp3_ = g_strdup (url);
	result = _tmp3_;
	_g_free0 (scheme);
	return result;
}

static void
contacts_contact_sheet_add_nickname (ContactsContactSheet* self,
                                     FolksPersona* persona,
                                     const gchar* property)
{
	FolksNameDetails* name_details = NULL;
	gboolean _tmp0_ = FALSE;
	FolksNameDetails* _tmp1_;
	ContactsContactSheetRow* row = NULL;
	FolksNameDetails* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ContactsContactSheetRow* _tmp8_;
	ContactsContactSheetRow* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (property != NULL);
	name_details = G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) persona) : NULL;
	_tmp1_ = name_details;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		FolksNameDetails* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = name_details;
		_tmp3_ = folks_name_details_get_nickname (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = name_details;
	_tmp6_ = folks_name_details_get_nickname (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = contacts_contact_sheet_row_new (property, _tmp7_, NULL);
	g_object_ref_sink (_tmp8_);
	row = _tmp8_;
	_tmp9_ = row;
	contacts_contact_sheet_attach_row (self, (GtkListBoxRow*) _tmp9_);
	_g_object_unref0 (row);
}

static void
contacts_contact_sheet_add_birthday (ContactsContactSheet* self,
                                     FolksPersona* persona,
                                     const gchar* property)
{
	FolksBirthdayDetails* birthday_details = NULL;
	gboolean _tmp0_ = FALSE;
	FolksBirthdayDetails* _tmp1_;
	gchar* birthday_str = NULL;
	FolksBirthdayDetails* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* subtitle = NULL;
	gint bd_m = 0;
	gint bd_d = 0;
	gint now_m = 0;
	gint now_d = 0;
	FolksBirthdayDetails* _tmp12_;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	GDateTime* _tmp16_;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	GDateTime* _tmp19_;
	GDateTime* _tmp20_;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gboolean _tmp23_ = FALSE;
	ContactsContactSheetRow* row = NULL;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	ContactsContactSheetRow* _tmp27_;
	ContactsContactSheetRow* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (property != NULL);
	birthday_details = G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_BIRTHDAY_DETAILS) ? ((FolksBirthdayDetails*) persona) : NULL;
	_tmp1_ = birthday_details;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		FolksBirthdayDetails* _tmp2_;
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		_tmp2_ = birthday_details;
		_tmp3_ = folks_birthday_details_get_birthday (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = birthday_details;
	_tmp6_ = folks_birthday_details_get_birthday (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_date_time_to_local (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_date_time_format (_tmp9_, "%x");
	_tmp11_ = _tmp10_;
	_g_date_time_unref0 (_tmp9_);
	birthday_str = _tmp11_;
	subtitle = NULL;
	_tmp12_ = birthday_details;
	_tmp13_ = folks_birthday_details_get_birthday (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_date_time_to_local (_tmp14_);
	_tmp16_ = _tmp15_;
	g_date_time_get_ymd (_tmp16_, NULL, &_tmp17_, &_tmp18_);
	bd_m = _tmp17_;
	bd_d = _tmp18_;
	_g_date_time_unref0 (_tmp16_);
	_tmp19_ = g_date_time_new_now_local ();
	_tmp20_ = _tmp19_;
	g_date_time_get_ymd (_tmp20_, NULL, &_tmp21_, &_tmp22_);
	now_m = _tmp21_;
	now_d = _tmp22_;
	_g_date_time_unref0 (_tmp20_);
	if (bd_m == now_m) {
		_tmp23_ = bd_d == now_d;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		gchar* _tmp24_;
		_tmp24_ = g_strdup (_ ("Their birthday is today! 🎉"));
		_g_free0 (subtitle);
		subtitle = _tmp24_;
	}
	_tmp25_ = birthday_str;
	_tmp26_ = subtitle;
	_tmp27_ = contacts_contact_sheet_row_new (property, _tmp25_, _tmp26_);
	g_object_ref_sink (_tmp27_);
	row = _tmp27_;
	_tmp28_ = row;
	contacts_contact_sheet_attach_row (self, (GtkListBoxRow*) _tmp28_);
	_g_object_unref0 (row);
	_g_free0 (subtitle);
	_g_free0 (birthday_str);
}

static void
contacts_contact_sheet_add_notes (ContactsContactSheet* self,
                                  FolksPersona* persona,
                                  const gchar* property)
{
	FolksNoteDetails* note_details = NULL;
	FolksNoteDetails* _tmp0_;
	GList* rows = NULL;
	GList* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (property != NULL);
	note_details = G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_NOTE_DETAILS) ? ((FolksNoteDetails*) persona) : NULL;
	_tmp0_ = note_details;
	if (_tmp0_ == NULL) {
		return;
	}
	rows = NULL;
	{
		GeeIterator* _note_it = NULL;
		FolksNoteDetails* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp1_ = note_details;
		_tmp2_ = folks_note_details_get_notes (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_note_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			FolksNoteFieldDetails* note = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			FolksNoteFieldDetails* _tmp8_;
			gconstpointer _tmp9_;
			gconstpointer _tmp10_;
			ContactsContactSheetRow* row = NULL;
			FolksNoteFieldDetails* _tmp11_;
			gconstpointer _tmp12_;
			gconstpointer _tmp13_;
			ContactsContactSheetRow* _tmp14_;
			ContactsContactSheetRow* _tmp15_;
			GtkListBoxRow* _tmp16_;
			_tmp5_ = _note_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _note_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			note = (FolksNoteFieldDetails*) _tmp7_;
			_tmp8_ = note;
			_tmp9_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 ((const gchar*) _tmp10_, "") == 0) {
				_g_object_unref0 (note);
				continue;
			}
			_tmp11_ = note;
			_tmp12_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = contacts_contact_sheet_row_new (property, (const gchar*) _tmp13_, NULL);
			g_object_ref_sink (_tmp14_);
			row = _tmp14_;
			_tmp15_ = row;
			_tmp16_ = _g_object_ref0 ((GtkListBoxRow*) _tmp15_);
			rows = g_list_append (rows, _tmp16_);
			_g_object_unref0 (row);
			_g_object_unref0 (note);
		}
		_g_object_unref0 (_note_it);
	}
	_tmp17_ = rows;
	contacts_contact_sheet_attach_rows (self, _tmp17_);
	(rows == NULL) ? NULL : (rows = (_g_list_free__g_object_unref0_ (rows), NULL));
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data19_->self;
		_g_object_unref0 (_data19_->addr);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data20_->_data19_->self;
		_g_object_unref0 (_data20_->button);
		block19_data_unref (_data20_->_data19_);
		_data20_->_data19_ = NULL;
		g_slice_free (Block20Data, _data20_);
	}
}

static void
_____lambda15_ (Block20Data* _data20_)
{
	Block19Data* _data19_;
	ContactsContactSheet* self;
	ContactsMainWindow* window = NULL;
	GtkButton* _tmp0_;
	GtkRoot* _tmp1_;
	ContactsMainWindow* _tmp2_;
	gchar* uri = NULL;
	FolksPostalAddressFieldDetails* _tmp3_;
	gconstpointer _tmp4_;
	gconstpointer _tmp5_;
	gchar* _tmp6_;
	ContactsMainWindow* _tmp7_;
	const gchar* _tmp8_;
	_data19_ = _data20_->_data19_;
	self = _data19_->self;
	_tmp0_ = _data20_->button;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) _tmp0_);
	window = CONTACTS_IS_MAIN_WINDOW (_tmp1_) ? ((ContactsMainWindow*) _tmp1_) : NULL;
	_tmp2_ = window;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = _data19_->addr;
	_tmp4_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = contacts_utils_create_maps_uri ((FolksPostalAddress*) _tmp5_);
	uri = _tmp6_;
	_tmp7_ = window;
	_tmp8_ = uri;
	gtk_show_uri ((GtkWindow*) _tmp7_, _tmp8_, (guint32) GDK_CURRENT_TIME);
	_g_free0 (uri);
}

static void
______lambda15__gtk_button_clicked (GtkButton* _sender,
                                    gpointer self)
{
	_____lambda15_ (self);
}

static void
contacts_contact_sheet_add_postal_addresses (ContactsContactSheet* self,
                                             FolksPersona* persona,
                                             const gchar* property)
{
	FolksPostalAddressDetails* addr_details = NULL;
	FolksPostalAddressDetails* _tmp0_;
	GAppInfo* appinfo = NULL;
	GAppInfo* _tmp1_;
	gboolean map_uris_supported = FALSE;
	GAppInfo* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GList* rows = NULL;
	GList* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (property != NULL);
	addr_details = G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS) ? ((FolksPostalAddressDetails*) persona) : NULL;
	_tmp0_ = addr_details;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = g_app_info_get_default_for_uri_scheme ("maps");
	appinfo = _tmp1_;
	_tmp2_ = appinfo;
	map_uris_supported = _tmp2_ != NULL;
	_tmp3_ = bool_to_string (map_uris_supported);
	_tmp4_ = _tmp3_;
	g_debug ("contacts-contact-sheet.vala:440: Opening 'maps:' URIs supported: %s", _tmp4_);
	_g_free0 (_tmp4_);
	rows = NULL;
	{
		GeeIterator* _addr_it = NULL;
		FolksPostalAddressDetails* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp5_ = addr_details;
		_tmp6_ = folks_postal_address_details_get_postal_addresses (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_addr_it = _tmp8_;
		while (TRUE) {
			Block19Data* _data19_;
			GeeIterator* _tmp9_;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			FolksPostalAddressFieldDetails* _tmp12_;
			gconstpointer _tmp13_;
			gconstpointer _tmp14_;
			ContactsContactSheetRow* row = NULL;
			FolksPostalAddressFieldDetails* _tmp15_;
			gconstpointer _tmp16_;
			gconstpointer _tmp17_;
			gint _tmp18_ = 0;
			gchar** _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			gchar* _tmp21_;
			gchar* _tmp22_;
			ContactsTypeSet* _tmp23_;
			ContactsTypeSet* _tmp24_;
			FolksPostalAddressFieldDetails* _tmp25_;
			const gchar* _tmp26_;
			ContactsContactSheetRow* _tmp27_;
			ContactsContactSheetRow* _tmp28_;
			ContactsContactSheetRow* _tmp33_;
			GtkListBoxRow* _tmp34_;
			_data19_ = g_slice_new0 (Block19Data);
			_data19_->_ref_count_ = 1;
			_data19_->self = g_object_ref (self);
			_tmp9_ = _addr_it;
			if (!gee_iterator_next (_tmp9_)) {
				block19_data_unref (_data19_);
				_data19_ = NULL;
				break;
			}
			_tmp10_ = _addr_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			_data19_->addr = (FolksPostalAddressFieldDetails*) _tmp11_;
			_tmp12_ = _data19_->addr;
			_tmp13_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp12_);
			_tmp14_ = _tmp13_;
			if (folks_postal_address_is_empty ((FolksPostalAddress*) _tmp14_)) {
				block19_data_unref (_data19_);
				_data19_ = NULL;
				continue;
			}
			_tmp15_ = _data19_->addr;
			_tmp16_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp19_ = contacts_utils_format_address ((FolksPostalAddress*) _tmp17_, &_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp20__length1 = _tmp18_;
			_tmp21_ = _vala_g_strjoinv ("\n", _tmp20_, (gint) _tmp18_);
			_tmp22_ = _tmp21_;
			_tmp23_ = contacts_typeset_get_general ();
			_tmp24_ = _tmp23_;
			_tmp25_ = _data19_->addr;
			_tmp26_ = contacts_typeset_format_type (_tmp24_, (FolksAbstractFieldDetails*) _tmp25_);
			_tmp27_ = contacts_contact_sheet_row_new (property, _tmp22_, _tmp26_);
			g_object_ref_sink (_tmp27_);
			_tmp28_ = _tmp27_;
			_g_free0 (_tmp22_);
			_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
			row = _tmp28_;
			if (map_uris_supported) {
				Block20Data* _data20_;
				ContactsContactSheetRow* _tmp29_;
				GtkButton* _tmp30_;
				GtkButton* _tmp31_;
				GtkButton* _tmp32_;
				_data20_ = g_slice_new0 (Block20Data);
				_data20_->_ref_count_ = 1;
				_data20_->_data19_ = block19_data_ref (_data19_);
				_tmp29_ = row;
				_tmp30_ = contacts_contact_sheet_row_add_button (_tmp29_, "map-symbolic");
				_data20_->button = _tmp30_;
				_tmp31_ = _data20_->button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp31_, _ ("Show on the map"));
				_tmp32_ = _data20_->button;
				g_signal_connect_data (_tmp32_, "clicked", (GCallback) ______lambda15__gtk_button_clicked, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
				block20_data_unref (_data20_);
				_data20_ = NULL;
			}
			_tmp33_ = row;
			_tmp34_ = _g_object_ref0 ((GtkListBoxRow*) _tmp33_);
			rows = g_list_append (rows, _tmp34_);
			_g_object_unref0 (row);
			block19_data_unref (_data19_);
			_data19_ = NULL;
		}
		_g_object_unref0 (_addr_it);
	}
	_tmp35_ = rows;
	contacts_contact_sheet_attach_rows (self, _tmp35_);
	(rows == NULL) ? NULL : (rows = (_g_list_free__g_object_unref0_ (rows), NULL));
	_g_object_unref0 (appinfo);
}

static GObject *
contacts_contact_sheet_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactSheet * self;
	parent_class = G_OBJECT_CLASS (contacts_contact_sheet_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheet);
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-sheet");
	return obj;
}

static void
contacts_contact_sheet_class_init (ContactsContactSheetClass * klass,
                                   gpointer klass_data)
{
	contacts_contact_sheet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactSheet_private_offset);
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_sheet_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_sheet_finalize;
}

static void
contacts_contact_sheet_instance_init (ContactsContactSheet * self,
                                      gpointer klass)
{
	self->priv = contacts_contact_sheet_get_instance_private (self);
	self->priv->last_row = 0;
}

static void
contacts_contact_sheet_finalize (GObject * obj)
{
	ContactsContactSheet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheet);
	G_OBJECT_CLASS (contacts_contact_sheet_parent_class)->finalize (obj);
}

/**
 * The contact sheet displays the actual information of a contact.
 *
 * (Note: to edit a contact, use the {@link ContactEditor} instead.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_sheet_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactSheetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_sheet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactSheet), 0, (GInstanceInitFunc) contacts_contact_sheet_instance_init, NULL };
	GType contacts_contact_sheet_type_id;
	contacts_contact_sheet_type_id = g_type_register_static (gtk_grid_get_type (), "ContactsContactSheet", &g_define_type_info, 0);
	ContactsContactSheet_private_offset = g_type_add_instance_private (contacts_contact_sheet_type_id, sizeof (ContactsContactSheetPrivate));
	return contacts_contact_sheet_type_id;
}

GType
contacts_contact_sheet_get_type (void)
{
	static volatile gsize contacts_contact_sheet_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_sheet_type_id__once)) {
		GType contacts_contact_sheet_type_id;
		contacts_contact_sheet_type_id = contacts_contact_sheet_get_type_once ();
		g_once_init_leave (&contacts_contact_sheet_type_id__once, contacts_contact_sheet_type_id);
	}
	return contacts_contact_sheet_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

