/* print-dialog.c generated by valac 0.56.0, the Vala compiler
 * generated from print-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "libsudoku.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#define PRINT_DIALOG_DIFFICULTY_KEY_NAME "print-multiple-sudoku-difficulty"
#define PRINT_DIALOG_MAX_PUZZLES_PER_PAGE 15
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;
typedef struct _PrintDialogPrivate PrintDialogPrivate;
enum  {
	PRINT_DIALOG_0_PROPERTY,
	PRINT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* print_dialog_properties[PRINT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PrintDialog {
	GtkDialog parent_instance;
	PrintDialogPrivate * priv;
};

struct _PrintDialogClass {
	GtkDialogClass parent_class;
};

struct _PrintDialogPrivate {
	SudokuSaver* saver;
	GSettings* settings;
	GtkButton* print_button;
	GtkGrid* print_grid;
	GtkSpinButton* n_sudokus_button;
	GtkSpinButton* n_sudokus_per_page_button;
	GtkRadioButton* easy_radio_button;
	GtkRadioButton* medium_radio_button;
	GtkRadioButton* hard_radio_button;
	GtkRadioButton* very_hard_radio_button;
	GtkRevealer* revealer;
	GtkSpinner* spinner;
	GCancellable* cancellable;
};

struct _Block7Data {
	int _ref_count_;
	PrintDialog* self;
	GtkAdjustment* total;
	GtkAdjustment* per_page;
};

struct _Block8Data {
	int _ref_count_;
	PrintDialog* self;
	gint nsudokus_per_page;
};

static gint PrintDialog_private_offset;
static gpointer print_dialog_parent_class = NULL;

VALA_EXTERN GType print_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PrintDialog, g_object_unref)
VALA_EXTERN PrintDialog* print_dialog_new (SudokuSaver* saver,
                               GtkWindow* window);
VALA_EXTERN PrintDialog* print_dialog_construct (GType object_type,
                                     SudokuSaver* saver,
                                     GtkWindow* window);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda24_ (PrintDialog* self,
                  gint response_id);
static void ___lambda24__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void __lambda25_ (Block7Data* _data7_);
static void ___lambda25__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                gpointer self);
static void __lambda26_ (Block7Data* _data7_);
static void ___lambda26__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                gpointer self);
VALA_EXTERN gboolean print_dialog_start_spinner_cb (PrintDialog* self);
static void print_dialog_real_response (GtkDialog* base,
                                 gint response);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda23_ (Block8Data* _data8_,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN GType sudoku_printer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuPrinter, g_object_unref)
VALA_EXTERN SudokuPrinter* sudoku_printer_new (GeeList* boards,
                                   gint sudokus_per_page,
                                   GtkWindow* window);
VALA_EXTERN SudokuPrinter* sudoku_printer_construct (GType object_type,
                                         GeeList* boards,
                                         gint sudokus_per_page,
                                         GtkWindow* window);
VALA_EXTERN GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
static void ___lambda23__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void print_dialog_finalize (GObject * obj);
static GType print_dialog_get_type_once (void);

static inline gpointer
print_dialog_get_instance_private (PrintDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PrintDialog_private_offset);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		PrintDialog* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->per_page);
		_g_object_unref0 (_data7_->total);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda24_ (PrintDialog* self,
             gint response_id)
{
	gboolean _tmp0_ = FALSE;
	if (response_id == ((gint) GTK_RESPONSE_CANCEL)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = response_id == ((gint) GTK_RESPONSE_DELETE_EVENT);
	}
	if (_tmp0_) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

static void
___lambda24__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda24_ ((PrintDialog*) self, response_id);
}

static void
__lambda25_ (Block7Data* _data7_)
{
	PrintDialog* self;
	gint total_value = 0;
	GSettings* _tmp0_;
	gint max_per_page = 0;
	gint per_page_value = 0;
	self = _data7_->self;
	total_value = (gint) gtk_adjustment_get_value (_data7_->total);
	_tmp0_ = self->priv->settings;
	g_settings_set_int (_tmp0_, "print-multiple-sudokus-to-print", total_value);
	max_per_page = MIN (PRINT_DIALOG_MAX_PUZZLES_PER_PAGE, total_value);
	per_page_value = (gint) gtk_adjustment_get_value (_data7_->per_page);
	per_page_value = MIN (per_page_value, max_per_page);
	gtk_adjustment_set_upper (_data7_->per_page, (gdouble) max_per_page);
	gtk_adjustment_set_value (_data7_->per_page, (gdouble) per_page_value);
}

static void
___lambda25__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                           gpointer self)
{
	__lambda25_ (self);
}

static void
__lambda26_ (Block7Data* _data7_)
{
	PrintDialog* self;
	gint per_page_value = 0;
	GSettings* _tmp0_;
	self = _data7_->self;
	per_page_value = (gint) gtk_adjustment_get_value (_data7_->per_page);
	_tmp0_ = self->priv->settings;
	g_settings_set_int (_tmp0_, "print-multiple-sudokus-to-print-per-page", per_page_value);
}

static void
___lambda26__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                           gpointer self)
{
	__lambda26_ (self);
}

PrintDialog*
print_dialog_construct (GType object_type,
                        SudokuSaver* saver,
                        GtkWindow* window)
{
	PrintDialog * self = NULL;
	Block7Data* _data7_;
	SudokuSaver* _tmp0_;
	GSettings* _tmp1_;
	GtkSpinner* _tmp2_;
	GtkRevealer* _tmp3_;
	GtkRevealer* _tmp4_;
	GtkSpinner* _tmp5_;
	GtkRevealer* _tmp6_;
	GtkHeaderBar* _tmp7_;
	GtkRevealer* _tmp8_;
	DifficultyCategory saved_difficulty = 0;
	GSettings* _tmp9_;
	gint initial_total_value = 0;
	GSettings* _tmp14_;
	gint initial_per_page_value = 0;
	GSettings* _tmp15_;
	GtkSpinButton* _tmp16_;
	GtkAdjustment* _tmp17_;
	GtkAdjustment* _tmp18_;
	GtkSpinButton* _tmp19_;
	GtkAdjustment* _tmp20_;
	GtkAdjustment* _tmp21_;
	gint initial_max_per_page = 0;
	g_return_val_if_fail (saver != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	self = (PrintDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	_data7_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (saver);
	_g_object_unref0 (self->priv->saver);
	self->priv->saver = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.Sudoku");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda24__gtk_dialog_response, self, 0);
	gtk_window_set_transient_for ((GtkWindow*) self, window);
	_tmp2_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp2_;
	_tmp3_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->revealer);
	self->priv->revealer = _tmp3_;
	_tmp4_ = self->priv->revealer;
	_tmp5_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->revealer;
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	_tmp7_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
	_tmp8_ = self->priv->revealer;
	gtk_header_bar_pack_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_header_bar_get_type (), GtkHeaderBar), (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->settings;
	saved_difficulty = (DifficultyCategory) g_settings_get_enum (_tmp9_, PRINT_DIALOG_DIFFICULTY_KEY_NAME);
	if (saved_difficulty == DIFFICULTY_CATEGORY_EASY) {
		GtkRadioButton* _tmp10_;
		_tmp10_ = self->priv->easy_radio_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp10_, TRUE);
	} else {
		if (saved_difficulty == DIFFICULTY_CATEGORY_MEDIUM) {
			GtkRadioButton* _tmp11_;
			_tmp11_ = self->priv->medium_radio_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp11_, TRUE);
		} else {
			if (saved_difficulty == DIFFICULTY_CATEGORY_HARD) {
				GtkRadioButton* _tmp12_;
				_tmp12_ = self->priv->hard_radio_button;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp12_, TRUE);
			} else {
				if (saved_difficulty == DIFFICULTY_CATEGORY_VERY_HARD) {
					GtkRadioButton* _tmp13_;
					_tmp13_ = self->priv->very_hard_radio_button;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp13_, TRUE);
				} else {
					g_assert_not_reached ();
				}
			}
		}
	}
	_tmp14_ = self->priv->settings;
	initial_total_value = g_settings_get_int (_tmp14_, "print-multiple-sudokus-to-print");
	_tmp15_ = self->priv->settings;
	initial_per_page_value = g_settings_get_int (_tmp15_, "print-multiple-sudokus-to-print-per-page");
	_tmp16_ = self->priv->n_sudokus_button;
	_tmp17_ = gtk_spin_button_get_adjustment (_tmp16_);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	_data7_->total = _tmp18_;
	_tmp19_ = self->priv->n_sudokus_per_page_button;
	_tmp20_ = gtk_spin_button_get_adjustment (_tmp19_);
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_data7_->per_page = _tmp21_;
	gtk_adjustment_set_value (_data7_->total, (gdouble) initial_total_value);
	initial_max_per_page = MIN (PRINT_DIALOG_MAX_PUZZLES_PER_PAGE, initial_total_value);
	gtk_adjustment_set_value (_data7_->per_page, (gdouble) MIN (initial_max_per_page, initial_per_page_value));
	gtk_adjustment_set_upper (_data7_->per_page, (gdouble) initial_max_per_page);
	g_signal_connect_data (_data7_->total, "value-changed", (GCallback) ___lambda25__gtk_adjustment_value_changed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	g_signal_connect_data (_data7_->per_page, "value-changed", (GCallback) ___lambda26__gtk_adjustment_value_changed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return self;
}

PrintDialog*
print_dialog_new (SudokuSaver* saver,
                  GtkWindow* window)
{
	return print_dialog_construct (TYPE_PRINT_DIALOG, saver, window);
}

gboolean
print_dialog_start_spinner_cb (PrintDialog* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	GtkSpinner* _tmp2_;
	GtkRevealer* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_transition_type (_tmp0_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	_tmp1_ = self->priv->revealer;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->spinner;
	gtk_spinner_start (_tmp2_);
	_tmp3_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp3_, TRUE);
	result = G_SOURCE_REMOVE;
	return result;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		PrintDialog* self;
		self = _data8_->self;
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda23_ (Block8Data* _data8_,
             GObject* obj,
             GAsyncResult* res)
{
	PrintDialog* self;
	GError* _inner_error0_ = NULL;
	self = _data8_->self;
	g_return_if_fail (res != NULL);
	{
		GeeList* boards = NULL;
		GeeList* _tmp0_;
		GtkSpinner* _tmp1_;
		GtkRevealer* _tmp2_;
		SudokuPrinter* printer = NULL;
		SudokuPrinter* _tmp3_;
		SudokuPrinter* _tmp4_;
		_tmp0_ = sudoku_generator_generate_boards_finish (res, &_inner_error0_);
		boards = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_THREAD_ERROR) {
				goto __catch0_g_thread_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp1_ = self->priv->spinner;
		gtk_spinner_stop (_tmp1_);
		_tmp2_ = self->priv->revealer;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
		_tmp3_ = sudoku_printer_new (boards, _data8_->nsudokus_per_page, (GtkWindow*) self);
		printer = _tmp3_;
		_tmp4_ = printer;
		if (sudoku_printer_print_sudoku (_tmp4_) == GTK_PRINT_OPERATION_RESULT_APPLY) {
			{
				GeeList* _board_list = NULL;
				gint _board_size = 0;
				GeeList* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gint _board_index = 0;
				_board_list = boards;
				_tmp5_ = _board_list;
				_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
				_tmp7_ = _tmp6_;
				_board_size = _tmp7_;
				_board_index = -1;
				while (TRUE) {
					gint _tmp8_;
					gint _tmp9_;
					SudokuBoard* board = NULL;
					GeeList* _tmp10_;
					gpointer _tmp11_;
					SudokuSaver* _tmp12_;
					SudokuBoard* _tmp13_;
					SudokuGame* _tmp14_;
					SudokuGame* _tmp15_;
					_board_index = _board_index + 1;
					_tmp8_ = _board_index;
					_tmp9_ = _board_size;
					if (!(_tmp8_ < _tmp9_)) {
						break;
					}
					_tmp10_ = _board_list;
					_tmp11_ = gee_list_get (_tmp10_, _board_index);
					board = (SudokuBoard*) _tmp11_;
					_tmp12_ = self->priv->saver;
					_tmp13_ = board;
					_tmp14_ = sudoku_game_new (_tmp13_);
					_tmp15_ = _tmp14_;
					sudoku_saver_add_game_to_finished (_tmp12_, _tmp15_, FALSE);
					_g_object_unref0 (_tmp15_);
					_g_object_unref0 (board);
				}
			}
		}
		_g_object_unref0 (printer);
		_g_object_unref0 (boards);
	}
	goto __finally0;
	__catch0_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e->message;
		g_error ("print-dialog.vala:163: Thread error: %s\n", _tmp16_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		if (!g_error_matches (_tmp17_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			GError* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			g_warning ("print-dialog.vala:168: Error: %s\n", _tmp19_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda23__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda23_ (self, source_object, res);
	block8_data_unref (self);
}

static void
print_dialog_real_response (GtkDialog* base,
                            gint response)
{
	PrintDialog * self;
	Block8Data* _data8_;
	gint nsudokus = 0;
	GtkSpinButton* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkSpinButton* _tmp2_;
	GtkAdjustment* _tmp3_;
	DifficultyCategory level = 0;
	GtkRadioButton* _tmp4_;
	GSettings* _tmp8_;
	GtkButton* _tmp9_;
	GtkGrid* _tmp10_;
	GCancellable* _tmp11_;
	GCancellable* _tmp12_;
	self = (PrintDialog*) base;
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	if (response != ((gint) GTK_RESPONSE_OK)) {
		gtk_widget_destroy ((GtkWidget*) self);
		block8_data_unref (_data8_);
		_data8_ = NULL;
		return;
	}
	_tmp0_ = self->priv->n_sudokus_button;
	_tmp1_ = gtk_spin_button_get_adjustment (_tmp0_);
	nsudokus = (gint) gtk_adjustment_get_value (_tmp1_);
	_tmp2_ = self->priv->n_sudokus_per_page_button;
	_tmp3_ = gtk_spin_button_get_adjustment (_tmp2_);
	_data8_->nsudokus_per_page = (gint) gtk_adjustment_get_value (_tmp3_);
	_tmp4_ = self->priv->easy_radio_button;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp4_)) {
		level = DIFFICULTY_CATEGORY_EASY;
	} else {
		GtkRadioButton* _tmp5_;
		_tmp5_ = self->priv->medium_radio_button;
		if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp5_)) {
			level = DIFFICULTY_CATEGORY_MEDIUM;
		} else {
			GtkRadioButton* _tmp6_;
			_tmp6_ = self->priv->hard_radio_button;
			if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp6_)) {
				level = DIFFICULTY_CATEGORY_HARD;
			} else {
				GtkRadioButton* _tmp7_;
				_tmp7_ = self->priv->very_hard_radio_button;
				if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp7_)) {
					level = DIFFICULTY_CATEGORY_VERY_HARD;
				} else {
					g_assert_not_reached ();
				}
			}
		}
	}
	_tmp8_ = self->priv->settings;
	g_settings_set_enum (_tmp8_, PRINT_DIALOG_DIFFICULTY_KEY_NAME, (gint) level);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, (GSourceFunc) print_dialog_start_spinner_cb, g_object_ref (self), g_object_unref);
	_tmp9_ = self->priv->print_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
	_tmp10_ = self->priv->print_grid;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
	_tmp11_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp11_;
	_tmp12_ = self->priv->cancellable;
	sudoku_generator_generate_boards_async (nsudokus, level, _tmp12_, ___lambda23__gasync_ready_callback, block8_data_ref (_data8_));
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
print_dialog_class_init (PrintDialogClass * klass,
                         gpointer klass_data)
{
	print_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintDialog_private_offset);
	((GtkDialogClass *) klass)->response = (void (*) (GtkDialog*, gint)) print_dialog_real_response;
	G_OBJECT_CLASS (klass)->finalize = print_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Sudoku/ui/print-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "print_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, print_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "print_grid", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, print_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "n_sudokus_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, n_sudokus_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "n_sudokus_per_page_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, n_sudokus_per_page_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "easy_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, easy_radio_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "medium_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, medium_radio_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hard_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, hard_radio_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "very_hard_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, very_hard_radio_button));
}

static void
print_dialog_instance_init (PrintDialog * self,
                            gpointer klass)
{
	self->priv = print_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
print_dialog_finalize (GObject * obj)
{
	PrintDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_DIALOG, PrintDialog);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (print_dialog_parent_class)->finalize (obj);
}

static GType
print_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintDialog), 0, (GInstanceInitFunc) print_dialog_instance_init, NULL };
	GType print_dialog_type_id;
	print_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PrintDialog", &g_define_type_info, 0);
	PrintDialog_private_offset = g_type_add_instance_private (print_dialog_type_id, sizeof (PrintDialogPrivate));
	return print_dialog_type_id;
}

GType
print_dialog_get_type (void)
{
	static volatile gsize print_dialog_type_id__once = 0;
	if (g_once_init_enter (&print_dialog_type_id__once)) {
		GType print_dialog_type_id;
		print_dialog_type_id = print_dialog_get_type_once ();
		g_once_init_leave (&print_dialog_type_id__once, print_dialog_type_id);
	}
	return print_dialog_type_id__once;
}

