
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KF5AkonadiConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/KF5Akonadi" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(AKONADI_DBUS_INTERFACES_DIR  "${PACKAGE_PREFIX_DIR}/share/dbus-1/interfaces")
set_and_check(AKONADI_INCLUDE_DIR          "${PACKAGE_PREFIX_DIR}/include/KF5")

# The directory where akonadi-xml.xsd and kcfg2dbus.xsl are installed
set(KF5Akonadi_DATA_DIR "${PACKAGE_PREFIX_DIR}/share/kf5/akonadi")

# set the directories
if(NOT AKONADI_INSTALL_DIR)
   set(AKONADI_INSTALL_DIR "/usr")
endif(NOT AKONADI_INSTALL_DIR)
include(CMakeFindDependencyMacro)
find_dependency(KF5Config "5.95.0")
find_dependency(KF5ConfigWidgets "5.95.0")
find_dependency(KF5CoreAddons "5.95.0")
find_dependency(KF5ItemModels "5.95.0")
find_dependency(KF5XmlGui "5.95.0")

find_dependency(Qt5Core "5.15.2")
find_dependency(Qt5DBus "5.15.2")
find_dependency(Qt5Gui "5.15.2")
find_dependency(Qt5Network "5.15.2")
find_dependency(Qt5Widgets "5.15.2")
find_dependency(Qt5Xml "5.15.2")

if(BUILD_TESTING)
    # Link targets required by KF5AkonadiMacros.cmake
    find_dependency(KF5KIO "5.95.0")
    find_dependency(Qt5Test "5.15.2")
endif()

include(${CMAKE_CURRENT_LIST_DIR}/KF5AkonadiTargets.cmake)
include(${CMAKE_CURRENT_LIST_DIR}/KF5AkonadiMacros.cmake)

####################################################################################
# CMAKE_AUTOMOC

# CMake 3.9+ warns about automoc on files without Q_OBJECT, and doesn't know about other macros.
# 3.10+ lets us provide more macro names that require automoc.
foreach(macro_name  AKONADI_AGENTCONFIG_FACTORY)
    # we can be run multiple times, so add only once
    list (FIND CMAKE_AUTOMOC_MACRO_NAMES "${macro_name}" _index)
    if(_index LESS 0)
        list(APPEND CMAKE_AUTOMOC_MACRO_NAMES ${macro_name})
    endif()
endforeach()

# CMake's automoc needs help to find names of plugin metadata files in case Q_PLUGIN_METADATA
# is indirectly used via other C++ preprocessor macros
foreach(macro_name  AKONADI_AGENTCONFIG_FACTORY)
    # we can be run multiple times, so add only once
    list (FIND CMAKE_AUTOMOC_DEPEND_FILTERS "${macro_name}" _index)
    if(_index LESS 0)
        list(APPEND CMAKE_AUTOMOC_DEPEND_FILTERS
            "${macro_name}"
            "[\n^][ \t]*${macro_name}[ \t\n]*\\([^,]*,[ \t\n]*\"([^\"]+)\""
        )
    endif()
endforeach()

####################################################################################
