/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCacheFactory;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheMonitor;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.remote.RemoteLocation;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;

public class RemoteCacheFactory
extends AbstractAuxiliaryCacheFactory {
    private RemoteCacheMonitor monitor;
    private ConcurrentMap<RemoteLocation, RemoteCacheManager> managers;

    @Override
    public <K, V> AuxiliaryCache<K, V> createCache(AuxiliaryCacheAttributes iaca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        RemoteCacheAttributes rca = (RemoteCacheAttributes)iaca;
        ArrayList noWaits = new ArrayList();
        switch (rca.getRemoteType()) {
            case LOCAL: {
                String failoverList;
                ArrayList<RemoteLocation> failovers = new ArrayList<RemoteLocation>();
                if (rca.getRemoteLocation() != null) {
                    failovers.add(rca.getRemoteLocation());
                    RemoteCacheManager rcm = this.getManager(rca, cacheMgr, cacheEventLogger, elementSerializer);
                    noWaits.add(rcm.getCache(rca));
                }
                if ((failoverList = rca.getFailoverServers()) != null) {
                    String[] failoverServers;
                    for (String server : failoverServers = failoverList.split("\\s*,\\s*")) {
                        RemoteLocation location = RemoteLocation.parseServerAndPort(server);
                        if (location == null) continue;
                        failovers.add(location);
                        RemoteCacheAttributes frca = (RemoteCacheAttributes)rca.clone();
                        frca.setRemoteLocation(location);
                        RemoteCacheManager rcm = this.getManager(frca, cacheMgr, cacheEventLogger, elementSerializer);
                        if (!noWaits.isEmpty()) continue;
                        frca.setFailoverIndex(0);
                        noWaits.add(rcm.getCache(frca));
                    }
                }
                rca.setFailovers(failovers);
                break;
            }
            case CLUSTER: {
                String[] clusterServers;
                for (String server : clusterServers = rca.getClusterServers().split("\\s*,\\s*")) {
                    RemoteLocation location = RemoteLocation.parseServerAndPort(server);
                    if (location == null) continue;
                    RemoteCacheAttributes crca = (RemoteCacheAttributes)rca.clone();
                    crca.setRemoteLocation(location);
                    RemoteCacheManager rcm = this.getManager(crca, cacheMgr, cacheEventLogger, elementSerializer);
                    crca.setRemoteType(RemoteType.CLUSTER);
                    noWaits.add(rcm.getCache(crca));
                }
                break;
            }
        }
        return new RemoteCacheNoWaitFacade(noWaits, rca, cacheEventLogger, elementSerializer, this);
    }

    public RemoteCacheManager getManager(IRemoteCacheAttributes cattr) {
        RemoteCacheAttributes rca = (RemoteCacheAttributes)cattr.clone();
        if (rca.getRemoteLocation() == null) {
            rca.setRemoteLocation("", 1099);
        }
        return (RemoteCacheManager)this.managers.get(rca.getRemoteLocation());
    }

    public RemoteCacheManager getManager(IRemoteCacheAttributes cattr, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        RemoteCacheAttributes rca = (RemoteCacheAttributes)cattr.clone();
        if (rca.getRemoteLocation() == null) {
            rca.setRemoteLocation("", 1099);
        }
        return this.managers.computeIfAbsent(rca.getRemoteLocation(), key -> {
            RemoteCacheManager manager = new RemoteCacheManager(rca, cacheMgr, this.monitor, cacheEventLogger, elementSerializer);
            this.monitor.addManager(manager);
            return manager;
        });
    }

    @Override
    public void initialize() {
        super.initialize();
        this.managers = new ConcurrentHashMap<RemoteLocation, RemoteCacheManager>();
        this.monitor = new RemoteCacheMonitor();
        this.monitor.setDaemon(true);
    }

    @Override
    public void dispose() {
        this.managers.values().forEach(RemoteCacheManager::release);
        this.managers.clear();
        if (this.monitor != null) {
            this.monitor.notifyShutdown();
            try {
                this.monitor.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.monitor = null;
        }
        super.dispose();
    }
}

