/* ==================================== JUCER_BINARY_RESOURCE ====================================

   This is an auto-generated file: Any edits you make may be overwritten!

*/

#include <cstring>

namespace BinaryData
{

//================== UnityPluginGUIScript.cs.in ==================
static const unsigned char temp_binary_data_64[] =
"#if UNITY_EDITOR\n"
"\n"
"using UnityEditor;\n"
"using UnityEngine;\n"
"\n"
"using System.Collections.Generic;\n"
"using System.Runtime.InteropServices;\n"
"\n"
"public class ${plugin_class_name}GUI : IAudioEffectPluginGUI\n"
"{\n"
"    public override string Name           { get { return \"${plugin_name}\"; } }\n"
"    public override string Description    { get { return \"${plugin_description}\"; } }\n"
"    public override string Vendor         { get { return \"${plugin_vendor}\"; } }\n"
"\n"
"    //==============================================================================\n"
"    [DllImport(\"${plugin_name}\")] static extern System.IntPtr getRenderCallback();\n"
"\n"
"    [DllImport(\"${plugin_name}\")] static extern void unityInitialiseTexture (int id, System.IntPtr texture, int width, int height);\n"
"\n"
"    [DllImport(\"${plugin_name}\")] static extern void unityMouseDown (int id, float x, float y, EventModifiers mods, int button);\n"
"    [DllImport(\"${plugin_name}\")] static extern void unityMouseDrag (int id, float x, float y, EventModifiers mods, int button);\n"
"    [DllImport(\"${plugin_name}\")] static extern void unityMouseUp   (int id, float x, float y, EventModifiers mods);\n"
"\n"
"    [DllImport(\"${plugin_name}\")] static extern void unityKeyEvent (int id, KeyCode code, EventModifiers mods, string name);\n"
"\n"
"    [DllImport(\"${plugin_name}\")] static extern void unitySetScreenBounds (int id, float x, float y, float w, float h);\n"
"\n"
"    //==============================================================================\n"
"    private class PluginGUIInstance\n"
"    {\n"
"        public PluginGUIInstance (ref IAudioEffectPlugin plugin, int id)\n"
"        {\n"
"            instanceID = id;\n"
"\n"
"            float[] arr;\n"
"            plugin.GetFloatBuffer (\"Editor\", out arr, 1);\n"
"            hasEditor = (arr[0] > 0.0f);\n"
"        }\n"
"\n"
"        public void repaint (Rect r)\n"
"        {\n"
"            Vector2 newScreenPosition = GUIUtility.GUIToScreenPoint (r.position);\n"
"\n"
"            if (bounds != r\n"
"                || screenPosition != newScreenPosition)\n"
"            {\n"
"                screenPosition = newScreenPosition;\n"
"                bounds = r;\n"
"\n"
"                unitySetScreenBounds (instanceID, screenPosition.x, screenPosition.y, bounds.width, bounds.height);\n"
"                setupTexture();\n"
"            }\n"
"\n"
"            GL.IssuePluginEvent (getRenderCallback(), instanceID);\n"
"\n"
"            texture.SetPixels32 (pixels);\n"
"            texture.Apply();\n"
"\n"
"            EditorGUI.DrawPreviewTexture (bounds, texture);\n"
"        }\n"
"\n"
"        public bool handleMouseEvent (EventType eventType)\n"
"        {\n"
"            Vector2 mousePos = Event.current.mousePosition;\n"
"            EventModifiers mods = Event.current.modifiers;\n"
"\n"
"            if (! bounds.Contains (mousePos))\n"
"                return false;\n"
"\n"
"            Vector2 relativePos = new Vector2 (mousePos.x - bounds.x, mousePos.y - bounds.y);\n"
"\n"
"            if (eventType == EventType.MouseDown)\n"
"            {\n"
"                unityMouseDown (instanceID, relativePos.x, relativePos.y, mods, Event.current.button);\n"
"                GUIUtility.hotControl = GUIUtility.GetControlID (FocusType.Passive);\n"
"            }\n"
"            else if (eventType == EventType.MouseUp)\n"
"            {\n"
"                unityMouseUp (instanceID, relativePos.x, relativePos.y, mods);\n"
"                GUIUtility.hotControl = 0;\n"
"            }\n"
"            else if (eventType == EventType.MouseDrag)\n"
"            {\n"
"                unityMouseDrag (instanceID, relativePos.x, relativePos.y, mods, Event.current.button);\n"
"            }\n"
"\n"
"            Event.current.Use();\n"
"\n"
"            return true;\n"
"        }\n"
"\n"
"        public void handleKeyEvent (EventType eventType)\n"
"        {\n"
"            if (eventType == EventType.KeyDown)\n"
"            {\n"
"                KeyCode code = Event.current.keyCode;\n"
"\n"
"                if (code == KeyCode.None)\n"
"                    return;\n"
"\n"
"                EventModifiers mods = Event.current.modifiers;\n"
"\n"
"                unityKeyEvent (instanceID, code, mods, code.ToString());\n"
"            }\n"
"        }\n"
"\n"
"        private void setupTexture()\n"
"        {\n"
"            if (pixelHandle.IsAllocated)\n"
"                pixelHandle.Free();\n"
"\n"
"            texture = new Texture2D ((int) bounds.width, (int) bounds.height, TextureFormat.ARGB32, false);\n"
"\n"
"            pixels = texture.GetPixels32();\n"
"            pixelHandle = GCHandle.Alloc (pixels, GCHandleType.Pinned);\n"
"\n"
"            unityInitialiseTexture (instanceID, pixelHandle.AddrOfPinnedObject(), texture.width, texture.height);\n"
"        }\n"
"\n"
"        public int instanceID = -1;\n"
"        public bool hasEditor;\n"
"\n"
"        private Vector2 screenPosition;\n"
"        private Rect bounds;\n"
"\n"
"        private Texture2D texture;\n"
"        private Color32[] pixels;\n"
"        private GCHandle pixelHandle;\n"
"    }\n"
"    List<PluginGUIInstance> guis = new List<PluginGUIInstance>();\n"
"\n"
"    private PluginGUIInstance getGUIInstanceForPlugin (ref IAudioEffectPlugin plugin)\n"
"    {\n"
"        float[] idArray;\n"
"        plugin.GetFloatBuffer (\"ID\", out idArray, 1);\n"
"\n"
"        int id = (int) idArray[0];\n"
"\n"
"        for (int i = 0; i < guis.Count; ++i)\n"
"        {\n"
"            if (guis[i].instanceID == id)\n"
"                return guis[i];\n"
"        }\n"
"\n"
"        PluginGUIInstance newInstance = new PluginGUIInstance (ref plugin, id);\n"
"        guis.Add (newInstance);\n"
"\n"
"        return guis[guis.Count - 1];\n"
"    }\n"
"\n"
"    //==============================================================================\n"
"    public override bool OnGUI (IAudioEffectPlugin plugin)\n"
"    {\n"
"        PluginGUIInstance guiInstance = getGUIInstanceForPlugin (ref plugin);\n"
"\n"
"        if (! guiInstance.hasEditor)\n"
"            return true;\n"
"\n"
"        float[] arr;\n"
"        plugin.GetFloatBuffer (\"Size\", out arr, 6);\n"
"\n"
"        Rect r = GUILayoutUtility.GetRect (arr[0], arr[1],\n"
"                                           new GUILayoutOption[] { GUILayout.MinWidth (arr[2]), GUILayout.MinHeight (arr[3]),\n"
"                                                                   GUILayout.MaxWidth (arr[4]), GUILayout.MaxHeight (arr[5]) });\n"
"\n"
"        int controlID = GUIUtility.GetControlID (FocusType.Passive);\n"
"        Event currentEvent = Event.current;\n"
"        EventType currentEventType = currentEvent.GetTypeForControl (controlID);\n"
"\n"
"        if (currentEventType == EventType.Repaint)\n"
"            guiInstance.repaint (r);\n"
"        else if (currentEvent.isMouse)\n"
"            guiInstance.handleMouseEvent (currentEventType);\n"
"        else if (currentEvent.isKey)\n"
"            guiInstance.handleKeyEvent (currentEventType);\n"
"\n"
"        return false;\n"
"    }\n"
"}\n"
"\n"
"#endif\n";

const char* UnityPluginGUIScript_cs_in = (const char*) temp_binary_data_64;
}
