"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPageTemplate = exports.TEMPLATES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _page = require("./page");

var _page_side_bar = require("./page_side_bar");

var _page_body = require("./page_body");

var _page_header = require("./page_header");

var _page_content = require("./page_content");

var _bottom_bar = require("../bottom_bar");

var _services = require("../../services");

var _flex = require("../flex");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var TEMPLATES = ['default', 'centeredBody', 'centeredContent', 'empty'];
exports.TEMPLATES = TEMPLATES;

var EuiPageTemplate = function EuiPageTemplate(_ref) {
  var _pageBodyProps2;

  var _ref$template = _ref.template,
      template = _ref$template === void 0 ? 'default' : _ref$template,
      _ref$restrictWidth = _ref.restrictWidth,
      restrictWidth = _ref$restrictWidth === void 0 ? true : _ref$restrictWidth,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
      fullHeight = _ref.fullHeight,
      children = _ref.children,
      className = _ref.className,
      pageSideBar = _ref.pageSideBar,
      pageSideBarProps = _ref.pageSideBarProps,
      pageHeader = _ref.pageHeader,
      pageBodyProps = _ref.pageBodyProps,
      pageContentProps = _ref.pageContentProps,
      pageContentBodyProps = _ref.pageContentBodyProps,
      bottomBar = _ref.bottomBar,
      bottomBarProps = _ref.bottomBarProps,
      _ref$minHeight = _ref.minHeight,
      minHeight = _ref$minHeight === void 0 ? 460 : _ref$minHeight,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["template", "restrictWidth", "grow", "paddingSize", "fullHeight", "children", "className", "pageSideBar", "pageSideBarProps", "pageHeader", "pageBodyProps", "pageContentProps", "pageContentBodyProps", "bottomBar", "bottomBarProps", "minHeight"]);

  /**
   * Full height ~madness~ logic
   */
  var canFullHeight = (0, _services.useIsWithinBreakpoints)(['m', 'l', 'xl']) && (template === 'default' || template === 'empty');
  var fullHeightClass = {
    'eui-fullHeight': fullHeight && canFullHeight
  };
  var yScrollClass = {
    'eui-yScroll': fullHeight && canFullHeight
  };

  if (canFullHeight && fullHeight) {
    var _pageBodyProps, _pageContentProps, _pageContentBodyProps;

    // By using flex group it will also fix the negative margin issues for nested flex groups
    children = /*#__PURE__*/_react.default.createElement(_flex.EuiFlexGroup, {
      className: "eui-fullHeight",
      gutterSize: "none",
      direction: "column",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_flex.EuiFlexItem, {
      className: (0, _classnames.default)({
        'eui-yScroll': fullHeight === true,
        'eui-fullHeight': fullHeight === 'noscroll'
      }),
      grow: true
    }, children));
    pageBodyProps = _objectSpread(_objectSpread({}, pageBodyProps), {}, {
      className: (0, _classnames.default)(fullHeightClass, (_pageBodyProps = pageBodyProps) === null || _pageBodyProps === void 0 ? void 0 : _pageBodyProps.className)
    });
    pageContentProps = _objectSpread(_objectSpread({}, pageContentProps), {}, {
      className: (0, _classnames.default)(yScrollClass, (_pageContentProps = pageContentProps) === null || _pageContentProps === void 0 ? void 0 : _pageContentProps.className)
    });
    pageContentBodyProps = _objectSpread(_objectSpread({}, pageContentBodyProps), {}, {
      className: (0, _classnames.default)(fullHeightClass, (_pageContentBodyProps = pageContentBodyProps) === null || _pageContentBodyProps === void 0 ? void 0 : _pageContentBodyProps.className)
    });
  }

  var classes = (0, _classnames.default)('euiPageTemplate', fullHeightClass, className);

  var pageStyle = _objectSpread({
    minHeight: minHeight
  }, rest.style);
  /**
   * This seems very repetitious but it's the most readable, scalable, and maintainable
   */


  switch (template) {
    /**
     * CENTERED BODY
     * The panelled content is centered
     */
    case 'centeredBody':
      return pageSideBar ? /*#__PURE__*/_react.default.createElement(_page.EuiPage, (0, _extends2.default)({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/_react.default.createElement(_page_side_bar.EuiPageSideBar, (0, _extends2.default)({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), /*#__PURE__*/_react.default.createElement(_page_body.EuiPageBody, (0, _extends2.default)({
        paddingSize: paddingSize
      }, pageBodyProps), pageHeader && /*#__PURE__*/_react.default.createElement(_page_header.EuiPageHeader, (0, _extends2.default)({
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContent, (0, _extends2.default)({
        verticalPosition: "center",
        horizontalPosition: "center",
        paddingSize: paddingSize
      }, pageContentProps), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContentBody, (0, _extends2.default)({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))) : /*#__PURE__*/_react.default.createElement(_page.EuiPage, (0, _extends2.default)({
        className: classes,
        paddingSize: paddingSize,
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/_react.default.createElement(_page_body.EuiPageBody, (0, _extends2.default)({
        restrictWidth: restrictWidth
      }, pageBodyProps), pageHeader && /*#__PURE__*/_react.default.createElement(_page_header.EuiPageHeader, (0, _extends2.default)({
        paddingSize: "none",
        restrictWidth: false,
        bottomBorder: true
      }, pageHeader)), /*#__PURE__*/_react.default.createElement(_page_body.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContent, (0, _extends2.default)({
        verticalPosition: "center",
        horizontalPosition: "center",
        paddingSize: paddingSize
      }, pageContentProps), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContentBody, (0, _extends2.default)({
        paddingSize: "none",
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))));

    /**
     * CENTERED CONTENT
     * The content inside the panel is centered
     */

    case 'centeredContent':
      return pageSideBar ? /*#__PURE__*/_react.default.createElement(_page.EuiPage, (0, _extends2.default)({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/_react.default.createElement(_page_side_bar.EuiPageSideBar, (0, _extends2.default)({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), /*#__PURE__*/_react.default.createElement(_page_body.EuiPageBody, (0, _extends2.default)({
        panelled: true,
        paddingSize: paddingSize
      }, pageBodyProps), pageHeader && /*#__PURE__*/_react.default.createElement(_page_header.EuiPageHeader, (0, _extends2.default)({
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContent, (0, _extends2.default)({
        verticalPosition: "center",
        horizontalPosition: "center",
        hasShadow: false,
        color: "subdued",
        paddingSize: paddingSize
      }, pageContentProps), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContentBody, (0, _extends2.default)({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))) : /*#__PURE__*/_react.default.createElement(_page.EuiPage, (0, _extends2.default)({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/_react.default.createElement(_page_body.EuiPageBody, pageBodyProps, pageHeader && /*#__PURE__*/_react.default.createElement(_page_header.EuiPageHeader, (0, _extends2.default)({
        paddingSize: paddingSize,
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContent, {
        role: null,
        borderRadius: "none",
        hasShadow: false,
        paddingSize: paddingSize,
        style: {
          display: 'flex'
        }
      }, /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContent, (0, _extends2.default)({
        verticalPosition: "center",
        horizontalPosition: "center",
        hasShadow: false,
        color: "subdued",
        paddingSize: paddingSize
      }, pageContentProps), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContentBody, (0, _extends2.default)({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))));

    /**
     * EMPTY
     * No panelling at all
     */

    case 'empty':
      return pageSideBar ? /*#__PURE__*/_react.default.createElement(_page.EuiPage, (0, _extends2.default)({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/_react.default.createElement(_page_side_bar.EuiPageSideBar, (0, _extends2.default)({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), /*#__PURE__*/_react.default.createElement(_page_body.EuiPageBody, (0, _extends2.default)({
        paddingSize: paddingSize
      }, pageBodyProps), pageHeader && /*#__PURE__*/_react.default.createElement(_page_header.EuiPageHeader, (0, _extends2.default)({
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContent, (0, _extends2.default)({
        hasBorder: false,
        hasShadow: false,
        paddingSize: 'none',
        color: 'transparent',
        borderRadius: 'none'
      }, pageContentProps), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContentBody, (0, _extends2.default)({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))) : /*#__PURE__*/_react.default.createElement(_page.EuiPage, (0, _extends2.default)({
        className: classes,
        paddingSize: paddingSize,
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/_react.default.createElement(_page_body.EuiPageBody, (0, _extends2.default)({
        restrictWidth: restrictWidth
      }, pageBodyProps), pageHeader && /*#__PURE__*/_react.default.createElement(_page_header.EuiPageHeader, (0, _extends2.default)({
        paddingSize: "none",
        restrictWidth: false,
        bottomBorder: true
      }, pageHeader)), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContent, (0, _extends2.default)({
        hasBorder: false,
        hasShadow: false,
        paddingSize: 'none',
        color: 'transparent',
        borderRadius: 'none'
      }, pageContentProps), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContentBody, (0, _extends2.default)({
        paddingSize: "none"
      }, pageContentBodyProps), children))));

    /**
     * DEFAULT
     * Typical layout with nothing "centered"
     */

    default:
      // Only the default template can display a bottom bar
      var bottomBarNode = bottomBar ? /*#__PURE__*/_react.default.createElement(_bottom_bar.EuiBottomBar, (0, _extends2.default)({
        paddingSize: paddingSize,
        position: canFullHeight && fullHeight ? 'static' : 'sticky' // Using uknown here because of the possible conflict with overriding props and position `sticky`

      }, bottomBarProps), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContentBody, {
        paddingSize: 'none',
        restrictWidth: restrictWidth
      }, bottomBar)) : undefined;
      return pageSideBar ? /*#__PURE__*/_react.default.createElement(_page.EuiPage, (0, _extends2.default)({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/_react.default.createElement(_page_side_bar.EuiPageSideBar, (0, _extends2.default)({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), /*#__PURE__*/_react.default.createElement(_page_body.EuiPageBody, (0, _extends2.default)({
        panelled: true,
        paddingSize: "none"
      }, pageBodyProps), /*#__PURE__*/_react.default.createElement(_page_body.EuiPageBody, {
        component: "div",
        paddingSize: paddingSize,
        className: (_pageBodyProps2 = pageBodyProps) === null || _pageBodyProps2 === void 0 ? void 0 : _pageBodyProps2.className
      }, pageHeader && /*#__PURE__*/_react.default.createElement(_page_header.EuiPageHeader, (0, _extends2.default)({
        bottomBorder: true,
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContent, (0, _extends2.default)({
        hasShadow: false,
        hasBorder: false,
        color: 'transparent',
        borderRadius: 'none',
        paddingSize: "none"
      }, pageContentProps), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContentBody, (0, _extends2.default)({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children))), bottomBarNode)) : /*#__PURE__*/_react.default.createElement(_page.EuiPage, (0, _extends2.default)({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/_react.default.createElement(_page_body.EuiPageBody, pageBodyProps, pageHeader && /*#__PURE__*/_react.default.createElement(_page_header.EuiPageHeader, (0, _extends2.default)({
        restrictWidth: restrictWidth,
        paddingSize: paddingSize
      }, pageHeader)), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContent, (0, _extends2.default)({
        hasBorder: pageHeader === undefined ? false : undefined,
        hasShadow: false,
        paddingSize: 'none',
        color: 'plain',
        borderRadius: 'none'
      }, pageContentProps), /*#__PURE__*/_react.default.createElement(_page_content.EuiPageContentBody, (0, _extends2.default)({
        restrictWidth: restrictWidth,
        paddingSize: paddingSize
      }, pageContentBodyProps), children)), bottomBarNode));
  }
};

exports.EuiPageTemplate = EuiPageTemplate;
EuiPageTemplate.propTypes = {
  /**
     * Choose between 3 types of templates.
     * `default`: Typical layout with nothing centered
     * `centeredBody`: The panelled content is centered
     * `centeredContent`: The content inside the panel is centered
     * `empty`: Removes the panneling of the page content
     */
  template: _propTypes.default.any,

  /**
     * Padding size will not get applied to the over-arching #EuiPage,
     * but will propogate through all the components to keep them in sync
     */
  paddingSize: _propTypes.default.any,

  /**
     * Optionally include #EuiPageSideBar content.
     * The inclusion of this will affect the whole layout
     */
  pageSideBar: _propTypes.default.node,

  /**
     * Gets passed along to the #EuiPageSideBar component
     */
  pageSideBarProps: _propTypes.default.shape({
    /**
       * Adds `position: sticky` and affords for any fixed position headers
       */
    sticky: _propTypes.default.bool,

    /**
       * Adds padding around the children
       */
    paddingSize: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }),

  /**
     * Optionally include an #EuiPageHeader by passing an object of its props
     */
  pageHeader: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
       * Wrapped in an `H1` so choose appropriately.
       * A simple string is best
       */
    pageTitle: _propTypes.default.node,

    /**
       * Optional icon to place to the left of the title
       */
    iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "color", "compute", "console", "consoleApp", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentation", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "layers", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "timeslider", "training", "trash", "upgradeAssistantApp", "uptimeApp", "unfold", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),

    /**
       * Additional EuiIcon props to apply to the optional icon
       */
    iconProps: _propTypes.default.any,

    /**
       * In-app navigation presented as large borderless tabs.
       * Accepts an array of `EuiTab` objects;
       * HELP: This is evaluating to `any[]` in the props table
       */
    tabs: _propTypes.default.arrayOf(_propTypes.default.shape({
      /**
         * Visible text of the tab
         */
      label: _propTypes.default.node.isRequired
    }).isRequired),

    /**
       * Any extras to apply to the outer tabs container.
       * Extends `EuiTabs`
       */
    tabsProps: _propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,

      /**
           * ReactNode to render as this component's content
           */
      children: _propTypes.default.node
    }),

    /**
         * Position is dependent on existing with a `pageTitle` or `tabs`
         * Automatically get wrapped in a single paragraph tag inside an EuiText block
         */
    description: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.node.isRequired]),

    /**
         * Set to false if you don't want the children to stack at small screen sizes.
         * Set to `reverse` to display the right side content first for the sack of hierarchy (like global time)
         */
    responsive: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["reverse"])]),

    /**
         * Vertical alignment of the left and right side content;
         * Default is `middle` for custom content, but `top` for when `pageTitle` or `tabs` are included
         */
    alignItems: _propTypes.default.any,

    /**
         * Pass custom an array of content to this side usually up to 3 buttons.
         * The first button should be primary, usually with `fill` and will be visually displayed as the last item,
         * but first in the tab order
         */
    rightSideItems: _propTypes.default.arrayOf(_propTypes.default.node.isRequired),

    /**
         * Additional EuiFlexGroup props to pass to the container of the `rightSideItems`
         */
    rightSideGroupProps: _propTypes.default.any,

    /**
         * Custom children will be rendered before the `tabs` unless no `pageTitle` is present, then it will be the last item
         */
    children: _propTypes.default.node,

    /**
       * Sets the max-width of the page,
       * set to `true` to use the default size of `1000px (1200 for Amsterdam)`,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
    restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

    /**
         * Adjust the padding.
         * When using this setting it's best to be consistent throughout all similar usages
         */
    paddingSize: _propTypes.default.any,

    /**
         * Adds a bottom border to separate it from the content after
         */
    bottomBorder: _propTypes.default.bool
  }),

  /**
     * Gets passed along to the #EuiPageBody component
     */
  pageBodyProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
       * Sets the max-width of the page,
       * set to `true` to use the default size of `1000px (1200 for Amsterdam)`,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
    restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

    /**
         * Sets the HTML element for `EuiPageBody`.
         */
    component: _propTypes.default.any,

    /**
         * Uses an EuiPanel as the main component instead of a plain div
         */
    panelled: _propTypes.default.bool,

    /**
         * Extends any extra EuiPanel props if `panelled=true`
         */
    panelProps: _propTypes.default.any,

    /**
         * Adjusts the padding
         */
    paddingSize: _propTypes.default.any
  }),

  /**
     * Gets passed along to the #EuiPageContent component
     */
  pageContentProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
       * Adds a medium shadow to the panel;
       * Only works when `color="plain"`
       */

    /**
       * Adds a medium shadow to the panel;
       * Only works when `color="plain"`
       */
    hasShadow: _propTypes.default.bool,

    /**
       * Adds a slight 1px border on all edges.
       * Only works when `color="plain | transparent"`
       * Default is `undefined` and will default to that theme's panel style
       */

    /**
       * Adds a slight 1px border on all edges.
       * Only works when `color="plain | transparent"`
       * Default is `undefined` and will default to that theme's panel style
       */
    hasBorder: _propTypes.default.bool,

    /**
       * Padding for all four sides
       */

    /**
       * Padding for all four sides
       */
    paddingSize: _propTypes.default.any,

    /**
       * Corner border radius
       */

    /**
       * Corner border radius
       */
    borderRadius: _propTypes.default.any,

    /**
       * When true the panel will grow in height to match `EuiFlexItem`
       */

    /**
       * When true the panel will grow in height to match `EuiFlexItem`
       */
    grow: _propTypes.default.bool,
    panelRef: _propTypes.default.any,

    /**
       * Background color of the panel;
       * Usually a lightened form of the brand colors
       */

    /**
       * Background color of the panel;
       * Usually a lightened form of the brand colors
       */
    color: _propTypes.default.any,
    element: _propTypes.default.oneOf(["div"]),

    /**
         * **DEPRECATED: use `paddingSize` instead.**
         */
    panelPaddingSize: _propTypes.default.any,
    verticalPosition: _propTypes.default.oneOf(["center"]),
    horizontalPosition: _propTypes.default.oneOf(["center"]),

    /**
         * There should only be one EuiPageContent per page and should contain the main contents.
         * If this is untrue, set role = `null`, or change it to match your needed aria role
         */
    role: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf([null])])
  }),

  /**
     * Gets passed along to the #EuiPageContentBody component
     */
  pageContentBodyProps: _propTypes.default.shape({
    /**
       * Adjust the padding.
       * When using this setting it's best to be consistent throughout all similar usages
       */
    paddingSize: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
       * Sets the max-width of the page,
       * set to `true` to use the default size of `1000px (1200 for Amsterdam)`,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
    restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired])
  }),

  /**
     * Adds contents inside of an EuiBottomBar.
     * Only works when `template = 'default'`
     */
  bottomBar: _propTypes.default.any,

  /**
     * Gets passed along to the #EuiBottomBar component if `bottomBar` has contents
     */
  bottomBarProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
         * How to position the bottom bar against its parent.
         */
    position: _propTypes.default.oneOfType([_propTypes.default.oneOf(["fixed"]), _propTypes.default.oneOf(["static", "sticky"]).isRequired]),

    /**
         * Whether to wrap in an EuiPortal which appends the component to the body element.
         * Only works if `position` is `fixed`.
         */
    usePortal: _propTypes.default.bool,

    /**
         * Whether the component should apply padding on the document body element to afford for its own displacement height.
         * Only works if `usePortal` is true and `position` is `fixed`.
         */
    affordForDisplacement: _propTypes.default.bool,

    /**
         * Padding applied to the bar. Default is 'm'.
         */
    paddingSize: _propTypes.default.oneOf(["none", "s", "m", "l"]),

    /**
         * Optional class applied to the body element on mount.
         */
    bodyClassName: _propTypes.default.string,

    /**
         * Customize the screen reader heading that helps users find this control. Default is 'Page level controls'.
         */
    landmarkHeading: _propTypes.default.string,

    /**
         * Starting vertical position when `fixed` position.
         * Offset from the top of the window when `sticky` position.
         * Has no affect on `static` positions.
         */
    top: _propTypes.default.any,

    /**
         * Ending horizontal position when `fixed` position.
         * Has no affect on `static` or `sticky` positions.
         */
    right: _propTypes.default.any,

    /**
         * Starting vertical position when `fixed` position.
         * Offset from the bottom of the window when `sticky` position.
         * Has no affect on `static` positions.
         */
    bottom: _propTypes.default.any,

    /**
         * Starting horizontal position when `fixed` position.
         * Has no affect on `static` or `sticky` positions.
         */
    left: _propTypes.default.any
  }),

  /**
     * Stretches or restricts the height to 100% of the parent;
     * `true`: scrolls the EuiPageContentBody;
     * `noscroll`: removes all scroll ability;
     * Only works when `template = 'default | empty'` and breakpoint is `m` and above
     */
  fullHeight: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["noscroll"])]),

  /**
     * Minimum height in which to enforce scrolling
     */
  minHeight: _propTypes.default.any
};