/// <reference types="node" resolution-mode="require"/>
import type tsp from 'typescript/lib/protocol.d.js';
import { CancellationToken } from 'vscode-jsonrpc';
import { CommandTypes } from './tsp-command-types.js';
import { Logger } from './logger.js';
import API from './utils/api.js';
export interface TspClientOptions {
    apiVersion: API;
    logger: Logger;
    tsserverPath: string;
    logFile?: string;
    logVerbosity?: string;
    disableAutomaticTypingAcquisition?: boolean;
    maxTsServerMemory?: number;
    npmLocation?: string;
    locale?: string;
    globalPlugins?: string[];
    pluginProbeLocations?: string[];
    onEvent?: (event: tsp.Event) => void;
    onExit?: (exitCode: number | null, signal: NodeJS.Signals | null) => void;
}
interface TypeScriptRequestTypes {
    [CommandTypes.ApplyCodeActionCommand]: [tsp.ApplyCodeActionCommandRequestArgs, tsp.ApplyCodeActionCommandResponse];
    [CommandTypes.CompilerOptionsForInferredProjects]: [tsp.SetCompilerOptionsForInferredProjectsArgs, tsp.SetCompilerOptionsForInferredProjectsResponse];
    [CommandTypes.CompletionDetails]: [tsp.CompletionDetailsRequestArgs, tsp.CompletionDetailsResponse];
    [CommandTypes.CompletionInfo]: [tsp.CompletionsRequestArgs, tsp.CompletionInfoResponse];
    [CommandTypes.Configure]: [tsp.ConfigureRequestArguments, tsp.ConfigureResponse];
    [CommandTypes.Definition]: [tsp.FileLocationRequestArgs, tsp.DefinitionResponse];
    [CommandTypes.DefinitionAndBoundSpan]: [tsp.FileLocationRequestArgs, tsp.DefinitionInfoAndBoundSpanResponse];
    [CommandTypes.DocCommentTemplate]: [tsp.FileLocationRequestArgs, tsp.DocCommandTemplateResponse];
    [CommandTypes.DocumentHighlights]: [tsp.DocumentHighlightsRequestArgs, tsp.DocumentHighlightsResponse];
    [CommandTypes.EncodedSemanticClassificationsFull]: [tsp.EncodedSemanticClassificationsRequestArgs, tsp.EncodedSemanticClassificationsResponse];
    [CommandTypes.FindSourceDefinition]: [tsp.FileLocationRequestArgs, tsp.DefinitionResponse];
    [CommandTypes.Format]: [tsp.FormatRequestArgs, tsp.FormatResponse];
    [CommandTypes.Formatonkey]: [tsp.FormatOnKeyRequestArgs, tsp.FormatResponse];
    [CommandTypes.GetApplicableRefactors]: [tsp.GetApplicableRefactorsRequestArgs, tsp.GetApplicableRefactorsResponse];
    [CommandTypes.GetCodeFixes]: [tsp.CodeFixRequestArgs, tsp.CodeFixResponse];
    [CommandTypes.GetCombinedCodeFix]: [tsp.GetCombinedCodeFixRequestArgs, tsp.GetCombinedCodeFixResponse];
    [CommandTypes.GetEditsForFileRename]: [tsp.GetEditsForFileRenameRequestArgs, tsp.GetEditsForFileRenameResponse];
    [CommandTypes.GetEditsForRefactor]: [tsp.GetEditsForRefactorRequestArgs, tsp.GetEditsForRefactorResponse];
    [CommandTypes.Geterr]: [tsp.GeterrRequestArgs, any];
    [CommandTypes.GetOutliningSpans]: [tsp.FileRequestArgs, tsp.OutliningSpansResponse];
    [CommandTypes.GetSupportedCodeFixes]: [null, tsp.GetSupportedCodeFixesResponse];
    [CommandTypes.Implementation]: [tsp.FileLocationRequestArgs, tsp.ImplementationResponse];
    [CommandTypes.JsxClosingTag]: [tsp.JsxClosingTagRequestArgs, tsp.JsxClosingTagResponse];
    [CommandTypes.Navto]: [tsp.NavtoRequestArgs, tsp.NavtoResponse];
    [CommandTypes.NavTree]: [tsp.FileRequestArgs, tsp.NavTreeResponse];
    [CommandTypes.OrganizeImports]: [tsp.OrganizeImportsRequestArgs, tsp.OrganizeImportsResponse];
    [CommandTypes.ProjectInfo]: [tsp.ProjectInfoRequestArgs, tsp.ProjectInfoResponse];
    [CommandTypes.ProvideInlayHints]: [tsp.InlayHintsRequestArgs, tsp.InlayHintsResponse];
    [CommandTypes.Quickinfo]: [tsp.FileLocationRequestArgs, tsp.QuickInfoResponse];
    [CommandTypes.References]: [tsp.FileLocationRequestArgs, tsp.ReferencesResponse];
    [CommandTypes.Rename]: [tsp.RenameRequestArgs, tsp.RenameResponse];
    [CommandTypes.SignatureHelp]: [tsp.SignatureHelpRequestArgs, tsp.SignatureHelpResponse];
    [CommandTypes.TypeDefinition]: [tsp.FileLocationRequestArgs, tsp.TypeDefinitionResponse];
}
export declare class TspClient {
    private options;
    apiVersion: API;
    private tsserverProc;
    private readlineInterface;
    private seq;
    private readonly deferreds;
    private logger;
    private tsserverLogger;
    private cancellationPipeName;
    constructor(options: TspClientOptions);
    start(): boolean;
    shutdown(): void;
    notify(command: CommandTypes.Open, args: tsp.OpenRequestArgs): void;
    notify(command: CommandTypes.Close, args: tsp.FileRequestArgs): void;
    notify(command: CommandTypes.Saveto, args: tsp.SavetoRequestArgs): void;
    notify(command: CommandTypes.Change, args: tsp.ChangeRequestArgs): void;
    request<K extends keyof TypeScriptRequestTypes>(command: K, args: TypeScriptRequestTypes[K][0], token?: CancellationToken): Promise<TypeScriptRequestTypes[K][1]>;
    protected sendMessage(command: string, notification: boolean, args?: any): void;
    protected processMessage(untrimmedMessageString: string): void;
    private resolveResponse;
    private isEvent;
    private isResponse;
    private isRequestCompletedEvent;
}
export {};
//# sourceMappingURL=tsp-client.d.ts.map