/* bookmarks-list.c generated by valac 0.56.2, the Vala compiler
 * generated from bookmarks-list.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#define MODEL_UTILS_undefined_context_id ((guint16) 0)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_OVERLAYED_LIST (overlayed_list_get_type ())
#define OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAYED_LIST, OverlayedList))
#define OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAYED_LIST, OverlayedListClass))
#define IS_OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAYED_LIST))
#define IS_OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAYED_LIST))
#define OVERLAYED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAYED_LIST, OverlayedListClass))

typedef struct _OverlayedList OverlayedList;
typedef struct _OverlayedListClass OverlayedListClass;
typedef struct _OverlayedListPrivate OverlayedListPrivate;

#define TYPE_BOOKMARKS_LIST (bookmarks_list_get_type ())
#define BOOKMARKS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_LIST, BookmarksList))
#define BOOKMARKS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_LIST, BookmarksListClass))
#define IS_BOOKMARKS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_LIST))
#define IS_BOOKMARKS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_LIST))
#define BOOKMARKS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_LIST, BookmarksListClass))

typedef struct _BookmarksList BookmarksList;
typedef struct _BookmarksListClass BookmarksListClass;
typedef struct _BookmarksListPrivate BookmarksListPrivate;

#define TYPE_OVERLAYED_LIST_ROW (overlayed_list_row_get_type ())
#define OVERLAYED_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAYED_LIST_ROW, OverlayedListRow))
#define OVERLAYED_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAYED_LIST_ROW, OverlayedListRowClass))
#define IS_OVERLAYED_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAYED_LIST_ROW))
#define IS_OVERLAYED_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAYED_LIST_ROW))
#define OVERLAYED_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAYED_LIST_ROW, OverlayedListRowClass))

typedef struct _OverlayedListRow OverlayedListRow;
typedef struct _OverlayedListRowClass OverlayedListRowClass;

#define TYPE_BOOKMARK (bookmark_get_type ())
#define BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARK, Bookmark))
#define BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARK, BookmarkClass))
#define IS_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARK))
#define IS_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARK))
#define BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARK, BookmarkClass))

typedef struct _Bookmark Bookmark;
typedef struct _BookmarkClass BookmarkClass;
enum  {
	BOOKMARKS_LIST_0_PROPERTY,
	BOOKMARKS_LIST_SCHEMA_PATH_PROPERTY,
	BOOKMARKS_LIST_NUM_PROPERTIES
};
static GParamSpec* bookmarks_list_properties[BOOKMARKS_LIST_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef enum  {
	BOOKMARK_ICON_VALID_FOLDER,
	BOOKMARK_ICON_SEARCH,
	BOOKMARK_ICON_DCONF_OBJECT,
	BOOKMARK_ICON_KEY_DEFAULTS,
	BOOKMARK_ICON_EDITED_VALUE,
	BOOKMARK_ICON_EMPTY_FOLDER,
	BOOKMARK_ICON_EMPTY_OBJECT
} BookmarkIcon;

#define TYPE_BOOKMARK_ICON (bookmark_icon_get_type ())
typedef struct _Block4Data Block4Data;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())
typedef struct _Block5Data Block5Data;
enum  {
	BOOKMARKS_LIST_BOOKMARKS_CHANGED_SIGNAL,
	BOOKMARKS_LIST_UPDATE_BOOKMARKS_ICONS_SIGNAL,
	BOOKMARKS_LIST_WRITABILITY_CHANGED_SIGNAL,
	BOOKMARKS_LIST_NUM_SIGNALS
};
static guint bookmarks_list_signals[BOOKMARKS_LIST_NUM_SIGNALS] = {0};
typedef struct _OverlayedListRowPrivate OverlayedListRowPrivate;
typedef struct _BookmarkPrivate BookmarkPrivate;
enum  {
	BOOKMARK_0_PROPERTY,
	BOOKMARK_BOOKMARK_NAME_PROPERTY,
	BOOKMARK_NUM_PROPERTIES
};
static GParamSpec* bookmark_properties[BOOKMARK_NUM_PROPERTIES];

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _OverlayedList {
	GtkOverlay parent_instance;
	OverlayedListPrivate * priv;
	GtkListBox* main_list_box;
	GListStore* main_list_store;
	gchar* placeholder_icon;
	gchar* placeholder_text;
	gulong content_changed_handler;
};

struct _OverlayedListClass {
	GtkOverlayClass parent_class;
	void (*reset) (OverlayedList* self);
};

struct _BookmarksList {
	OverlayedList parent_instance;
	BookmarksListPrivate * priv;
};

struct _BookmarksListClass {
	OverlayedListClass parent_class;
};

struct _BookmarksListPrivate {
	GHashTable* bookmarks_hashtable;
	gchar* schema_id;
	GSettings* settings;
	gulong bookmarks_changed_handler;
	gboolean view_mode;
};

struct _Block4Data {
	int _ref_count_;
	BookmarksList* self;
	gboolean focused_row_will_survive;
	gchar** bookmarks_to_remove;
	gint bookmarks_to_remove_length1;
	gint _bookmarks_to_remove_size_;
	gint upper_index;
};

struct _Block5Data {
	int _ref_count_;
	BookmarksList* self;
	gulong bookmarks_writable_handler;
};

struct _OverlayedListRow {
	GtkListBoxRow parent_instance;
	OverlayedListRowPrivate * priv;
};

struct _OverlayedListRowClass {
	GtkListBoxRowClass parent_class;
	gboolean (*handle_copy_text) (OverlayedListRow* self, gchar** copy_text);
};

struct _Bookmark {
	OverlayedListRow parent_instance;
	BookmarkPrivate * priv;
};

struct _BookmarkClass {
	OverlayedListRowClass parent_class;
};

struct _BookmarkPrivate {
	GtkLabel* bookmark_label;
	gchar* _bookmark_name;
	gchar* detailed_action_name;
	gchar* inactive_action_name;
};

static gint BookmarksList_private_offset;
static gpointer bookmarks_list_parent_class = NULL;
static gint Bookmark_private_offset;
static gpointer bookmark_parent_class = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType overlayed_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayedList, g_object_unref)
VALA_EXTERN GType bookmarks_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksList, g_object_unref)
VALA_EXTERN GType overlayed_list_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayedListRow, g_object_unref)
VALA_EXTERN GType bookmark_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Bookmark, g_object_unref)
VALA_EXTERN void overlayed_list_reset (OverlayedList* self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN BookmarksList* bookmarks_list_new (gboolean needs_shadows,
                                   gboolean big_placeholder,
                                   const gchar* edit_mode_action_prefix,
                                   const gchar* schema_path);
VALA_EXTERN BookmarksList* bookmarks_list_construct (GType object_type,
                                         gboolean needs_shadows,
                                         gboolean big_placeholder,
                                         const gchar* edit_mode_action_prefix,
                                         const gchar* schema_path);
static void bookmarks_list_real_reset (OverlayedList* base);
static void bookmarks_list_on_bookmarks_changed (BookmarksList* self,
                                          GSettings* _settings,
                                          const gchar* key);
VALA_EXTERN gboolean bookmarks_list_create_bookmark_rows (BookmarksList* self,
                                              GVariant* bookmarks_variant);
static void bookmarks_list_on_writability_changed (BookmarksList* self,
                                            GSettings* _settings,
                                            const gchar* key);
VALA_EXTERN void overlayed_list_change_editability (OverlayedList* self,
                                        gboolean new_value);
VALA_EXTERN void bookmarks_list_enter_edit_mode (BookmarksList* self);
static void __lambda27_ (BookmarksList* self,
                  GtkWidget* widget);
VALA_EXTERN void bookmark_set_actionable (Bookmark* self,
                              gboolean actionable);
static void ___lambda27__gtk_callback (GtkWidget* widget,
                                gpointer self);
VALA_EXTERN gboolean bookmarks_list_leave_edit_mode (BookmarksList* self);
static void __lambda26_ (BookmarksList* self,
                  GtkWidget* widget);
static void ___lambda26__gtk_callback (GtkWidget* widget,
                                gpointer self);
VALA_EXTERN void overlayed_list_select_row_for_real (OverlayedList* self,
                                         GtkListBoxRow* row);
VALA_EXTERN GVariant* bookmarks_list_get_bookmarks_as_variant (BookmarksList* self);
VALA_EXTERN gchar** bookmarks_list_get_bookmarks_as_array (BookmarksList* self,
                                               gint* result_length1);
VALA_EXTERN gboolean browser_window_is_path_invalid (const gchar* path);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _bookmarks_list_create_bookmark_rows (GVariant* bookmarks_variant,
                                           gboolean view_mode,
                                           GListStore** main_list_store,
                                           GtkListBox* main_list_box,
                                           GHashTable** bookmarks_hashtable);
VALA_EXTERN guint overlayed_list_get_n_items (OverlayedList* self);
VALA_EXTERN const gchar* bookmark_get_bookmark_name (Bookmark* self);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN Bookmark* bookmark_new (const gchar* bookmark_name,
                        gboolean view_mode);
VALA_EXTERN Bookmark* bookmark_construct (GType object_type,
                              const gchar* bookmark_name,
                              gboolean view_mode);
VALA_EXTERN GType bookmark_icon_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void bookmarks_list_update_bookmark_icon (BookmarksList* self,
                                          const gchar* bookmark,
                                          BookmarkIcon icon);
static inline void _bookmarks_list_update_bookmark_icon (GtkStyleContext* context,
                                           BookmarkIcon icon);
VALA_EXTERN void bookmarks_list_trash_bookmark (BookmarksList* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda28_ (Block4Data* _data4_,
                  GtkListBox* _list_box,
                  GtkListBoxRow* selected_row);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ___lambda28__gtk_list_box_foreach_func (GtkListBox* box,
                                             GtkListBoxRow* row,
                                             gpointer self);
static void bookmarks_list_remove_bookmarks (GSettings* settings,
                                      gchar** bookmarks_to_remove,
                                      gint bookmarks_to_remove_length1);
VALA_EXTERN void bookmarks_list_move_top (BookmarksList* self);
VALA_EXTERN gint* overlayed_list_get_selected_rows_indices (OverlayedList* self,
                                                gint* result_length1);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gboolean _vala_int_array_contains (gint * stack,
                                   gssize stack_length,
                                   const gint needle);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void bookmarks_list_set_new_bookmarks (BookmarksList* self,
                                       gchar** new_bookmarks,
                                       gint new_bookmarks_length1);
VALA_EXTERN void overlayed_list_scroll_top (OverlayedList* self);
VALA_EXTERN void bookmarks_list_move_up (BookmarksList* self);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN void bookmarks_list_move_down (BookmarksList* self);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN void bookmarks_list_move_bottom (BookmarksList* self);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN void overlayed_list_scroll_bottom (OverlayedList* self);
VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void bookmarks_list_append_bookmark (BookmarksList* self,
                                     ViewType type,
                                     const gchar* bookmark);
static void _bookmarks_list_append_bookmark (GSettings* settings,
                                      const gchar* bookmark_name);
VALA_EXTERN gchar* bookmarks_list_get_bookmark_name (ViewType type,
                                         const gchar* path);
static void _vala_array_add12 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN void bookmarks_list_remove_bookmark (BookmarksList* self,
                                     ViewType type,
                                     const gchar* bookmark);
static void _bookmarks_list_remove_bookmark (GSettings* settings,
                                      const gchar* bookmark_name);
static void _vala_array_add13 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add14 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN void bookmarks_list_set_schema_path (BookmarksList* self,
                                     const gchar* value);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void _bookmarks_list_on_bookmarks_changed_g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self);
static void _bookmarks_list_on_writability_changed_g_settings_writable_changed (GSettings* _sender,
                                                                         const gchar* key,
                                                                         gpointer self);
static void _bookmarks_list_schema_path___lambda104_ (Block5Data* _data5_);
static void __bookmarks_list_schema_path___lambda104__gtk_widget_destroy (GtkWidget* _sender,
                                                                   gpointer self);
static void g_cclosure_user_marshal_VOID__VARIANT_BOOLEAN (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static GObject * bookmarks_list_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
VALA_EXTERN void overlayed_list_add_placeholder (OverlayedList* self);
VALA_EXTERN void overlayed_list_set_first_mode_name (OverlayedList* self,
                                         const gchar* value);
VALA_EXTERN void overlayed_list_set_second_mode_name (OverlayedList* self,
                                          const gchar* value);
static void bookmarks_list_finalize (GObject * obj);
static GType bookmarks_list_get_type_once (void);
static void _vala_bookmarks_list_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
VALA_EXTERN gboolean overlayed_list_row_handle_copy_text (OverlayedListRow* self,
                                              gchar** copy_text);
static gboolean bookmark_real_handle_copy_text (OverlayedListRow* base,
                                         gchar** copy_text);
static void bookmark_construct_actions_names (const gchar* bookmark_text,
                                       ViewType bookmark_type,
                                       gchar** detailed_action_name,
                                       gchar** inactive_action_name);
static void bookmark_parse_bookmark_name (const gchar* bookmark_name,
                                   gchar** bookmark_text,
                                   ViewType* bookmark_type);
VALA_EXTERN gboolean model_utils_is_folder_path (const gchar* path);
static void bookmark_set_bookmark_name (Bookmark* self,
                                 const gchar* value);
static GObject * bookmark_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties);
static void bookmark_finalize (GObject * obj);
static GType bookmark_get_type_once (void);
static void _vala_bookmark_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_bookmark_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
bookmarks_list_get_instance_private (BookmarksList* self)
{
	return G_STRUCT_MEMBER_P (self, BookmarksList_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

BookmarksList*
bookmarks_list_construct (GType object_type,
                          gboolean needs_shadows,
                          gboolean big_placeholder,
                          const gchar* edit_mode_action_prefix,
                          const gchar* schema_path)
{
	BookmarksList * self = NULL;
	g_return_val_if_fail (edit_mode_action_prefix != NULL, NULL);
	g_return_val_if_fail (schema_path != NULL, NULL);
	self = (BookmarksList*) g_object_new (object_type, "needs-shadows", needs_shadows, "big-placeholder", big_placeholder, "edit-mode-action-prefix", edit_mode_action_prefix, "schema-path", schema_path, NULL);
	return self;
}

BookmarksList*
bookmarks_list_new (gboolean needs_shadows,
                    gboolean big_placeholder,
                    const gchar* edit_mode_action_prefix,
                    const gchar* schema_path)
{
	return bookmarks_list_construct (TYPE_BOOKMARKS_LIST, needs_shadows, big_placeholder, edit_mode_action_prefix, schema_path);
}

static void
bookmarks_list_real_reset (OverlayedList* base)
{
	BookmarksList * self;
	self = (BookmarksList*) base;
}

static void
bookmarks_list_on_bookmarks_changed (BookmarksList* self,
                                     GSettings* _settings,
                                     const gchar* key)
{
	GVariant* bookmarks_variant = NULL;
	GVariant* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_settings_get_value (_settings, key);
	bookmarks_variant = _tmp0_;
	bookmarks_list_create_bookmark_rows (self, bookmarks_variant);
	g_signal_emit (self, bookmarks_list_signals[BOOKMARKS_LIST_UPDATE_BOOKMARKS_ICONS_SIGNAL], 0, bookmarks_variant);
	g_signal_emit (self, bookmarks_list_signals[BOOKMARKS_LIST_BOOKMARKS_CHANGED_SIGNAL], 0, bookmarks_variant, g_settings_is_writable (_settings, key));
	_g_variant_unref0 (bookmarks_variant);
}

static void
bookmarks_list_on_writability_changed (BookmarksList* self,
                                       GSettings* _settings,
                                       const gchar* key)
{
	gboolean is_writable = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_settings != NULL);
	g_return_if_fail (key != NULL);
	is_writable = g_settings_is_writable (_settings, key);
	g_signal_emit (self, bookmarks_list_signals[BOOKMARKS_LIST_WRITABILITY_CHANGED_SIGNAL], 0, is_writable);
	overlayed_list_change_editability ((OverlayedList*) self, is_writable);
}

static void
__lambda27_ (BookmarksList* self,
             GtkWidget* widget)
{
	g_return_if_fail (widget != NULL);
	bookmark_set_actionable (G_TYPE_CHECK_INSTANCE_CAST (widget, TYPE_BOOKMARK, Bookmark), FALSE);
}

static void
___lambda27__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda27_ ((BookmarksList*) self, widget);
}

void
bookmarks_list_enter_edit_mode (BookmarksList* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((OverlayedList*) self)->main_list_box;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	_tmp1_ = ((OverlayedList*) self)->main_list_box;
	gtk_container_foreach ((GtkContainer*) _tmp1_, ___lambda27__gtk_callback, self);
	_tmp2_ = ((OverlayedList*) self)->main_list_box;
	gtk_list_box_set_activate_on_single_click (_tmp2_, FALSE);
	_tmp3_ = ((OverlayedList*) self)->main_list_box;
	gtk_list_box_set_selection_mode (_tmp3_, GTK_SELECTION_MULTIPLE);
	self->priv->view_mode = FALSE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda26_ (BookmarksList* self,
             GtkWidget* widget)
{
	g_return_if_fail (widget != NULL);
	bookmark_set_actionable (G_TYPE_CHECK_INSTANCE_CAST (widget, TYPE_BOOKMARK, Bookmark), TRUE);
}

static void
___lambda26__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda26_ ((BookmarksList*) self, widget);
}

gboolean
bookmarks_list_leave_edit_mode (BookmarksList* self)
{
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkWidget* _tmp1_;
	GtkListBoxRow* _tmp2_;
	gboolean give_focus_to_switch = FALSE;
	GtkListBoxRow* _tmp3_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	GtkListBox* _tmp11_;
	GtkListBoxRow* _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((OverlayedList*) self)->main_list_box;
	_tmp1_ = gtk_container_get_focus_child ((GtkContainer*) _tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_box_row_get_type (), GtkListBoxRow));
	row = _tmp2_;
	_tmp3_ = row;
	give_focus_to_switch = _tmp3_ == NULL;
	if (give_focus_to_switch) {
		GList* selected_rows = NULL;
		GtkListBox* _tmp4_;
		GList* _tmp5_;
		GList* _tmp6_;
		gconstpointer _tmp7_;
		GtkListBoxRow* _tmp8_;
		_tmp4_ = ((OverlayedList*) self)->main_list_box;
		_tmp5_ = gtk_list_box_get_selected_rows (_tmp4_);
		selected_rows = _tmp5_;
		_tmp6_ = selected_rows;
		_tmp7_ = g_list_nth_data (_tmp6_, (guint) 0);
		_tmp8_ = _g_object_ref0 ((GtkListBoxRow*) _tmp7_);
		_g_object_unref0 (row);
		row = _tmp8_;
		(selected_rows == NULL) ? NULL : (selected_rows = (g_list_free (selected_rows), NULL));
	}
	_tmp9_ = ((OverlayedList*) self)->main_list_box;
	gtk_container_foreach ((GtkContainer*) _tmp9_, ___lambda26__gtk_callback, self);
	_tmp10_ = ((OverlayedList*) self)->main_list_box;
	gtk_list_box_set_activate_on_single_click (_tmp10_, TRUE);
	_tmp11_ = ((OverlayedList*) self)->main_list_box;
	gtk_list_box_set_selection_mode (_tmp11_, GTK_SELECTION_SINGLE);
	self->priv->view_mode = TRUE;
	_tmp12_ = row;
	if (_tmp12_ != NULL) {
		GtkListBoxRow* _tmp13_;
		_tmp13_ = row;
		overlayed_list_select_row_for_real ((OverlayedList*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_list_box_row_get_type (), GtkListBoxRow));
	}
	result = give_focus_to_switch;
	_g_object_unref0 (row);
	return result;
}

GVariant*
bookmarks_list_get_bookmarks_as_variant (BookmarksList* self)
{
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "bookmarks");
	result = _tmp1_;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
bookmarks_list_get_bookmarks_as_array (BookmarksList* self,
                                       gint* result_length1)
{
	gchar** all_bookmarks = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint all_bookmarks_length1;
	gint _all_bookmarks_size_;
	gchar** unduplicated_bookmarks = NULL;
	gchar** _tmp3_;
	gint unduplicated_bookmarks_length1;
	gint _unduplicated_bookmarks_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "bookmarks");
	all_bookmarks = _tmp2_;
	all_bookmarks_length1 = _vala_array_length (_tmp1_);
	_all_bookmarks_size_ = all_bookmarks_length1;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	unduplicated_bookmarks = _tmp3_;
	unduplicated_bookmarks_length1 = 0;
	_unduplicated_bookmarks_size_ = unduplicated_bookmarks_length1;
	_tmp4_ = all_bookmarks;
	_tmp4__length1 = all_bookmarks_length1;
	{
		gchar** bookmark_collection = NULL;
		gint bookmark_collection_length1 = 0;
		gint _bookmark_collection_size_ = 0;
		gint bookmark_it = 0;
		bookmark_collection = _tmp4_;
		bookmark_collection_length1 = _tmp4__length1;
		for (bookmark_it = 0; bookmark_it < bookmark_collection_length1; bookmark_it = bookmark_it + 1) {
			gchar* _tmp5_;
			gchar* bookmark = NULL;
			_tmp5_ = g_strdup (bookmark_collection[bookmark_it]);
			bookmark = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp6_ = bookmark;
				if (browser_window_is_path_invalid (_tmp6_)) {
					_g_free0 (bookmark);
					continue;
				}
				_tmp7_ = bookmark;
				_tmp8_ = unduplicated_bookmarks;
				_tmp8__length1 = unduplicated_bookmarks_length1;
				if (_vala_string_array_contains (_tmp8_, _tmp8__length1, _tmp7_)) {
					_g_free0 (bookmark);
					continue;
				}
				_tmp9_ = bookmark;
				_tmp10_ = g_strdup (_tmp9_);
				_vala_array_add1 (&unduplicated_bookmarks, &unduplicated_bookmarks_length1, &_unduplicated_bookmarks_size_, _tmp10_);
				_g_free0 (bookmark);
			}
		}
	}
	_tmp11_ = unduplicated_bookmarks;
	_tmp11__length1 = unduplicated_bookmarks_length1;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	all_bookmarks = (_vala_array_free (all_bookmarks, all_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gboolean
bookmarks_list_create_bookmark_rows (BookmarksList* self,
                                     GVariant* bookmarks_variant)
{
	GtkListBox* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bookmarks_variant != NULL, FALSE);
	_tmp0_ = ((OverlayedList*) self)->main_list_box;
	_bookmarks_list_create_bookmark_rows (bookmarks_variant, self->priv->view_mode, &((OverlayedList*) self)->main_list_store, _tmp0_, &self->priv->bookmarks_hashtable);
	_tmp1_ = overlayed_list_get_n_items ((OverlayedList*) self);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == ((guint) 0);
	return result;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_bookmarks_list_create_bookmark_rows (GVariant* bookmarks_variant,
                                      gboolean view_mode,
                                      GListStore** main_list_store,
                                      GtkListBox* main_list_box,
                                      GHashTable** bookmarks_hashtable)
{
	gchar* saved_bookmark_name = NULL;
	gchar* _tmp0_;
	GtkListBoxRow* selected_row = NULL;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GtkListBoxRow* _tmp4_;
	gchar** bookmarks = NULL;
	gsize _tmp10_ = 0;
	const gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint bookmarks_length1;
	gint _bookmarks_size_;
	gchar** unduplicated_bookmarks = NULL;
	gchar** _tmp13_;
	gint unduplicated_bookmarks_length1;
	gint _unduplicated_bookmarks_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GtkListBoxRow* _tmp33_;
	GtkListBoxRow* _tmp36_;
	g_return_if_fail (bookmarks_variant != NULL);
	g_return_if_fail (*main_list_store != NULL);
	g_return_if_fail (main_list_box != NULL);
	g_return_if_fail (*bookmarks_hashtable != NULL);
	_tmp0_ = g_strdup ("");
	saved_bookmark_name = _tmp0_;
	_tmp1_ = gtk_list_box_get_selected_row (main_list_box);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selected_row = _tmp2_;
	_tmp4_ = selected_row;
	if (_tmp4_ != NULL) {
		GtkListBoxRow* _tmp5_;
		_tmp5_ = selected_row;
		_tmp3_ = IS_BOOKMARK (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_list_box_row_get_type (), GtkListBoxRow));
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkListBoxRow* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = selected_row;
		_tmp7_ = bookmark_get_bookmark_name (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_list_box_row_get_type (), GtkListBoxRow), TYPE_BOOKMARK, Bookmark));
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (saved_bookmark_name);
		saved_bookmark_name = _tmp9_;
	}
	_g_object_unref0 (selected_row);
	selected_row = NULL;
	g_list_store_remove_all (*main_list_store);
	g_hash_table_remove_all (*bookmarks_hashtable);
	_tmp11_ = g_variant_get_strv (bookmarks_variant, &_tmp10_);
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup4 (_tmp11_, _tmp10_) : _tmp11_;
	_tmp12__length1 = _tmp10_;
	_tmp11_ = (g_free (_tmp11_), NULL);
	bookmarks = _tmp12_;
	bookmarks_length1 = _tmp12__length1;
	_bookmarks_size_ = bookmarks_length1;
	_tmp13_ = g_new0 (gchar*, 0 + 1);
	unduplicated_bookmarks = _tmp13_;
	unduplicated_bookmarks_length1 = 0;
	_unduplicated_bookmarks_size_ = unduplicated_bookmarks_length1;
	_tmp14_ = bookmarks;
	_tmp14__length1 = bookmarks_length1;
	{
		gchar** bookmark_collection = NULL;
		gint bookmark_collection_length1 = 0;
		gint _bookmark_collection_size_ = 0;
		gint bookmark_it = 0;
		bookmark_collection = _tmp14_;
		bookmark_collection_length1 = _tmp14__length1;
		for (bookmark_it = 0; bookmark_it < bookmark_collection_length1; bookmark_it = bookmark_it + 1) {
			gchar* _tmp15_;
			gchar* bookmark = NULL;
			_tmp15_ = g_strdup (bookmark_collection[bookmark_it]);
			bookmark = _tmp15_;
			{
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				Bookmark* bookmark_row = NULL;
				const gchar* _tmp21_;
				Bookmark* _tmp22_;
				Bookmark* _tmp23_;
				Bookmark* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				Bookmark* _tmp27_;
				Bookmark* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				_tmp16_ = bookmark;
				if (browser_window_is_path_invalid (_tmp16_)) {
					_g_free0 (bookmark);
					continue;
				}
				_tmp17_ = bookmark;
				_tmp18_ = unduplicated_bookmarks;
				_tmp18__length1 = unduplicated_bookmarks_length1;
				if (_vala_string_array_contains (_tmp18_, _tmp18__length1, _tmp17_)) {
					_g_free0 (bookmark);
					continue;
				}
				_tmp19_ = bookmark;
				_tmp20_ = g_strdup (_tmp19_);
				_vala_array_add2 (&unduplicated_bookmarks, &unduplicated_bookmarks_length1, &_unduplicated_bookmarks_size_, _tmp20_);
				_tmp21_ = bookmark;
				_tmp22_ = bookmark_new (_tmp21_, view_mode);
				g_object_ref_sink (_tmp22_);
				bookmark_row = _tmp22_;
				_tmp23_ = bookmark_row;
				g_list_store_append (*main_list_store, (GObject*) _tmp23_);
				_tmp24_ = bookmark_row;
				gtk_widget_show ((GtkWidget*) _tmp24_);
				_tmp25_ = bookmark;
				_tmp26_ = g_strdup (_tmp25_);
				_tmp27_ = bookmark_row;
				_tmp28_ = _g_object_ref0 (_tmp27_);
				g_hash_table_insert (*bookmarks_hashtable, _tmp26_, _tmp28_);
				_tmp29_ = saved_bookmark_name;
				_tmp30_ = bookmark;
				if (g_strcmp0 (_tmp29_, _tmp30_) == 0) {
					Bookmark* _tmp31_;
					GtkListBoxRow* _tmp32_;
					_tmp31_ = bookmark_row;
					_tmp32_ = _g_object_ref0 ((GtkListBoxRow*) _tmp31_);
					_g_object_unref0 (selected_row);
					selected_row = _tmp32_;
				}
				_g_object_unref0 (bookmark_row);
				_g_free0 (bookmark);
			}
		}
	}
	_tmp33_ = selected_row;
	if (_tmp33_ == NULL) {
		GtkListBoxRow* _tmp34_;
		GtkListBoxRow* _tmp35_;
		_tmp34_ = gtk_list_box_get_row_at_index (main_list_box, 0);
		_tmp35_ = _g_object_ref0 (_tmp34_);
		_g_object_unref0 (selected_row);
		selected_row = _tmp35_;
	}
	_tmp36_ = selected_row;
	if (_tmp36_ != NULL) {
		GtkListBoxRow* _tmp37_;
		_tmp37_ = selected_row;
		gtk_list_box_select_row (main_list_box, G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_list_box_row_get_type (), GtkListBoxRow));
	}
	unduplicated_bookmarks = (_vala_array_free (unduplicated_bookmarks, unduplicated_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	bookmarks = (_vala_array_free (bookmarks, bookmarks_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (selected_row);
	_g_free0 (saved_bookmark_name);
}

void
bookmarks_list_update_bookmark_icon (BookmarksList* self,
                                     const gchar* bookmark,
                                     BookmarkIcon icon)
{
	Bookmark* bookmark_row = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	Bookmark* _tmp2_;
	Bookmark* _tmp3_;
	GtkWidget* bookmark_grid = NULL;
	Bookmark* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkStyleContext* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmark != NULL);
	_tmp0_ = self->priv->bookmarks_hashtable;
	_tmp1_ = g_hash_table_lookup (_tmp0_, bookmark);
	_tmp2_ = _g_object_ref0 ((Bookmark*) _tmp1_);
	bookmark_row = _tmp2_;
	_tmp3_ = bookmark_row;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (bookmark_row);
		return;
	}
	_tmp4_ = bookmark_row;
	_tmp5_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_BOOKMARK, Bookmark));
	_tmp6_ = _g_object_ref0 (_tmp5_);
	bookmark_grid = _tmp6_;
	_tmp7_ = bookmark_grid;
	if (_tmp7_ == NULL) {
		g_assert_not_reached ();
	}
	_tmp8_ = bookmark_grid;
	_tmp9_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_bookmarks_list_update_bookmark_icon (_tmp9_, icon);
	_g_object_unref0 (bookmark_grid);
	_g_object_unref0 (bookmark_row);
}

static inline void
_bookmarks_list_update_bookmark_icon (GtkStyleContext* context,
                                      BookmarkIcon icon)
{
	g_return_if_fail (context != NULL);
	switch (icon) {
		case BOOKMARK_ICON_VALID_FOLDER:
		{
			gtk_style_context_add_class (context, "folder");
			return;
		}
		case BOOKMARK_ICON_EMPTY_FOLDER:
		{
			gtk_style_context_add_class (context, "folder");
			gtk_style_context_add_class (context, "erase");
			return;
		}
		case BOOKMARK_ICON_SEARCH:
		{
			gtk_style_context_add_class (context, "search");
			return;
		}
		case BOOKMARK_ICON_EMPTY_OBJECT:
		{
			gtk_style_context_add_class (context, "key");
			gtk_style_context_add_class (context, "dconf-key");
			gtk_style_context_add_class (context, "erase");
			return;
		}
		case BOOKMARK_ICON_DCONF_OBJECT:
		{
			gtk_style_context_add_class (context, "key");
			gtk_style_context_add_class (context, "dconf-key");
			return;
		}
		case BOOKMARK_ICON_KEY_DEFAULTS:
		{
			gtk_style_context_add_class (context, "key");
			gtk_style_context_add_class (context, "gsettings-key");
			return;
		}
		case BOOKMARK_ICON_EDITED_VALUE:
		{
			gtk_style_context_add_class (context, "key");
			gtk_style_context_add_class (context, "gsettings-key");
			gtk_style_context_add_class (context, "edited");
			return;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BookmarksList* self;
		self = _data4_->self;
		_data4_->bookmarks_to_remove = (_vala_array_free (_data4_->bookmarks_to_remove, _data4_->bookmarks_to_remove_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda28_ (Block4Data* _data4_,
             GtkListBox* _list_box,
             GtkListBoxRow* selected_row)
{
	BookmarksList* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint index = 0;
	self = _data4_->self;
	g_return_if_fail (_list_box != NULL);
	g_return_if_fail (selected_row != NULL);
	if (!IS_BOOKMARK (selected_row)) {
		g_assert_not_reached ();
	}
	_tmp0_ = bookmark_get_bookmark_name (G_TYPE_CHECK_INSTANCE_CAST (selected_row, TYPE_BOOKMARK, Bookmark));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	_vala_array_add3 (&_data4_->bookmarks_to_remove, &_data4_->bookmarks_to_remove_length1, &_data4_->_bookmarks_to_remove_size_, _tmp2_);
	if (_data4_->focused_row_will_survive) {
		return;
	}
	index = gtk_list_box_row_get_index (selected_row);
	if (_data4_->upper_index > index) {
		_data4_->upper_index = index;
	}
}

static void
___lambda28__gtk_list_box_foreach_func (GtkListBox* box,
                                        GtkListBoxRow* row,
                                        gpointer self)
{
	__lambda28_ (self, box, row);
}

void
bookmarks_list_trash_bookmark (BookmarksList* self)
{
	Block4Data* _data4_;
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkWidget* _tmp1_;
	GtkListBoxRow* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GtkListBoxRow* _tmp4_;
	gchar** _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBoxRow* _tmp15_;
	GSettings* _tmp18_;
	GSettings* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = ((OverlayedList*) self)->main_list_box;
	_tmp1_ = gtk_container_get_focus_child ((GtkContainer*) _tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_box_row_get_type (), GtkListBoxRow));
	row = _tmp2_;
	_tmp4_ = row;
	if (_tmp4_ != NULL) {
		GtkListBoxRow* _tmp5_;
		_tmp5_ = row;
		_tmp3_ = !gtk_list_box_row_is_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_list_box_row_get_type (), GtkListBoxRow));
	} else {
		_tmp3_ = FALSE;
	}
	_data4_->focused_row_will_survive = _tmp3_;
	_tmp6_ = g_new0 (gchar*, 0 + 1);
	_data4_->bookmarks_to_remove = _tmp6_;
	_data4_->bookmarks_to_remove_length1 = 0;
	_data4_->_bookmarks_to_remove_size_ = _data4_->bookmarks_to_remove_length1;
	_data4_->upper_index = G_MAXINT;
	_tmp7_ = ((OverlayedList*) self)->main_list_box;
	gtk_list_box_selected_foreach (_tmp7_, ___lambda28__gtk_list_box_foreach_func, _data4_);
	if (_data4_->upper_index == G_MAXINT) {
		g_assert_not_reached ();
	}
	if (!_data4_->focused_row_will_survive) {
		GtkListBox* _tmp8_;
		GtkListBoxRow* _tmp9_;
		GtkListBoxRow* _tmp10_;
		GtkListBoxRow* _tmp11_;
		_tmp8_ = ((OverlayedList*) self)->main_list_box;
		_tmp9_ = gtk_list_box_get_row_at_index (_tmp8_, _data4_->upper_index + 1);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (row);
		row = _tmp10_;
		_tmp11_ = row;
		if (_tmp11_ == NULL) {
			if (_data4_->upper_index > 0) {
				GtkListBox* _tmp12_;
				GtkListBoxRow* _tmp13_;
				GtkListBoxRow* _tmp14_;
				_tmp12_ = ((OverlayedList*) self)->main_list_box;
				_tmp13_ = gtk_list_box_get_row_at_index (_tmp12_, _data4_->upper_index - 1);
				_tmp14_ = _g_object_ref0 (_tmp13_);
				_g_object_unref0 (row);
				row = _tmp14_;
			}
		}
	}
	_tmp15_ = row;
	if (_tmp15_ != NULL) {
		GtkListBox* _tmp16_;
		GtkListBoxRow* _tmp17_;
		_tmp16_ = ((OverlayedList*) self)->main_list_box;
		_tmp17_ = row;
		gtk_list_box_select_row (_tmp16_, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_list_box_row_get_type (), GtkListBoxRow));
	}
	_tmp18_ = self->priv->settings;
	bookmarks_list_remove_bookmarks (_tmp18_, _data4_->bookmarks_to_remove, (gint) _data4_->bookmarks_to_remove_length1);
	_tmp19_ = self->priv->settings;
	_tmp20_ = g_settings_get_value (_tmp19_, "bookmarks");
	_tmp21_ = _tmp20_;
	g_signal_emit (self, bookmarks_list_signals[BOOKMARKS_LIST_UPDATE_BOOKMARKS_ICONS_SIGNAL], 0, _tmp21_);
	_g_variant_unref0 (_tmp21_);
	_g_object_unref0 (row);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
_vala_int_array_contains (gint * stack,
                          gssize stack_length,
                          const gint needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
bookmarks_list_move_top (BookmarksList* self)
{
	gint* indices = NULL;
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint indices_length1;
	gint _indices_size_;
	gchar** old_bookmarks = NULL;
	GSettings* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint old_bookmarks_length1;
	gint _old_bookmarks_size_;
	gchar** new_bookmarks = NULL;
	gchar** _tmp5_;
	gint new_bookmarks_length1;
	gint _new_bookmarks_size_;
	gint* _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	g_return_if_fail (self != NULL);
	_tmp1_ = overlayed_list_get_selected_rows_indices ((OverlayedList*) self, &_tmp0_);
	indices = _tmp1_;
	indices_length1 = _tmp0_;
	_indices_size_ = indices_length1;
	_tmp2_ = self->priv->settings;
	_tmp4_ = _tmp3_ = g_settings_get_strv (_tmp2_, "bookmarks");
	old_bookmarks = _tmp4_;
	old_bookmarks_length1 = _vala_array_length (_tmp3_);
	_old_bookmarks_size_ = old_bookmarks_length1;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	new_bookmarks = _tmp5_;
	new_bookmarks_length1 = 0;
	_new_bookmarks_size_ = new_bookmarks_length1;
	_tmp6_ = indices;
	_tmp6__length1 = indices_length1;
	{
		gint* index_collection = NULL;
		gint index_collection_length1 = 0;
		gint _index_collection_size_ = 0;
		gint index_it = 0;
		index_collection = _tmp6_;
		index_collection_length1 = _tmp6__length1;
		for (index_it = 0; index_it < index_collection_length1; index_it = index_it + 1) {
			gint index = 0;
			index = index_collection[index_it];
			{
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp7_ = old_bookmarks;
				_tmp7__length1 = old_bookmarks_length1;
				_tmp8_ = _tmp7_[index];
				_tmp9_ = g_strdup (_tmp8_);
				_vala_array_add4 (&new_bookmarks, &new_bookmarks_length1, &_new_bookmarks_size_, _tmp9_);
			}
		}
	}
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gchar** _tmp12_;
				gint _tmp12__length1;
				gint* _tmp13_;
				gint _tmp13__length1;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = index;
					index = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = old_bookmarks;
				_tmp12__length1 = old_bookmarks_length1;
				if (!(index < _tmp12__length1)) {
					break;
				}
				_tmp13_ = indices;
				_tmp13__length1 = indices_length1;
				if (_vala_int_array_contains (_tmp13_, _tmp13__length1, index)) {
					continue;
				}
				_tmp14_ = old_bookmarks;
				_tmp14__length1 = old_bookmarks_length1;
				_tmp15_ = _tmp14_[index];
				_tmp16_ = g_strdup (_tmp15_);
				_vala_array_add5 (&new_bookmarks, &new_bookmarks_length1, &_new_bookmarks_size_, _tmp16_);
			}
		}
	}
	_tmp17_ = new_bookmarks;
	_tmp17__length1 = new_bookmarks_length1;
	bookmarks_list_set_new_bookmarks (self, _tmp17_, (gint) _tmp17__length1);
	overlayed_list_scroll_top ((OverlayedList*) self);
	new_bookmarks = (_vala_array_free (new_bookmarks, new_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	old_bookmarks = (_vala_array_free (old_bookmarks, old_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	indices = (g_free (indices), NULL);
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
bookmarks_list_move_up (BookmarksList* self)
{
	gint* indices = NULL;
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint indices_length1;
	gint _indices_size_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint index = 0;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gchar** old_bookmarks = NULL;
	GSettings* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint old_bookmarks_length1;
	gint _old_bookmarks_size_;
	gchar** new_bookmarks = NULL;
	gchar** _tmp8_;
	gint new_bookmarks_length1;
	gint _new_bookmarks_size_;
	guint position = 0U;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	g_return_if_fail (self != NULL);
	_tmp1_ = overlayed_list_get_selected_rows_indices ((OverlayedList*) self, &_tmp0_);
	indices = _tmp1_;
	indices_length1 = _tmp0_;
	_indices_size_ = indices_length1;
	_tmp2_ = indices;
	_tmp2__length1 = indices_length1;
	if (_tmp2__length1 != 1) {
		indices = (g_free (indices), NULL);
		return;
	}
	_tmp3_ = indices;
	_tmp3__length1 = indices_length1;
	_tmp4_ = _tmp3_[0];
	index = _tmp4_;
	if (index == 0) {
		indices = (g_free (indices), NULL);
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp7_ = _tmp6_ = g_settings_get_strv (_tmp5_, "bookmarks");
	old_bookmarks = _tmp7_;
	old_bookmarks_length1 = _vala_array_length (_tmp6_);
	_old_bookmarks_size_ = old_bookmarks_length1;
	_tmp8_ = g_new0 (gchar*, 0 + 1);
	new_bookmarks = _tmp8_;
	new_bookmarks_length1 = 0;
	_new_bookmarks_size_ = new_bookmarks_length1;
	position = (guint) 0;
	_tmp9_ = old_bookmarks;
	_tmp9__length1 = old_bookmarks_length1;
	{
		gchar** bookmark_collection = NULL;
		gint bookmark_collection_length1 = 0;
		gint _bookmark_collection_size_ = 0;
		gint bookmark_it = 0;
		bookmark_collection = _tmp9_;
		bookmark_collection_length1 = _tmp9__length1;
		for (bookmark_it = 0; bookmark_it < bookmark_collection_length1; bookmark_it = bookmark_it + 1) {
			gchar* _tmp10_;
			gchar* bookmark = NULL;
			_tmp10_ = g_strdup (bookmark_collection[bookmark_it]);
			bookmark = _tmp10_;
			{
				guint _tmp16_;
				if (((guint) index) == (position + 1)) {
					gchar** _tmp11_;
					gint _tmp11__length1;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp11_ = old_bookmarks;
					_tmp11__length1 = old_bookmarks_length1;
					_tmp12_ = _tmp11_[index];
					_tmp13_ = g_strdup (_tmp12_);
					_vala_array_add6 (&new_bookmarks, &new_bookmarks_length1, &_new_bookmarks_size_, _tmp13_);
				}
				if (((guint) index) != position) {
					const gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp14_ = bookmark;
					_tmp15_ = g_strdup (_tmp14_);
					_vala_array_add7 (&new_bookmarks, &new_bookmarks_length1, &_new_bookmarks_size_, _tmp15_);
				}
				_tmp16_ = position;
				position = _tmp16_ + 1;
				_g_free0 (bookmark);
			}
		}
	}
	_tmp17_ = new_bookmarks;
	_tmp17__length1 = new_bookmarks_length1;
	bookmarks_list_set_new_bookmarks (self, _tmp17_, (gint) _tmp17__length1);
	new_bookmarks = (_vala_array_free (new_bookmarks, new_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	old_bookmarks = (_vala_array_free (old_bookmarks, old_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	indices = (g_free (indices), NULL);
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
bookmarks_list_move_down (BookmarksList* self)
{
	gint* indices = NULL;
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint indices_length1;
	gint _indices_size_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint index = 0;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gchar** old_bookmarks = NULL;
	GSettings* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint old_bookmarks_length1;
	gint _old_bookmarks_size_;
	gchar** new_bookmarks = NULL;
	gchar** _tmp8_;
	gint new_bookmarks_length1;
	gint _new_bookmarks_size_;
	guint position = 0U;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	g_return_if_fail (self != NULL);
	_tmp1_ = overlayed_list_get_selected_rows_indices ((OverlayedList*) self, &_tmp0_);
	indices = _tmp1_;
	indices_length1 = _tmp0_;
	_indices_size_ = indices_length1;
	_tmp2_ = indices;
	_tmp2__length1 = indices_length1;
	if (_tmp2__length1 != 1) {
		indices = (g_free (indices), NULL);
		return;
	}
	_tmp3_ = indices;
	_tmp3__length1 = indices_length1;
	_tmp4_ = _tmp3_[0];
	index = _tmp4_;
	_tmp5_ = self->priv->settings;
	_tmp7_ = _tmp6_ = g_settings_get_strv (_tmp5_, "bookmarks");
	old_bookmarks = _tmp7_;
	old_bookmarks_length1 = _vala_array_length (_tmp6_);
	_old_bookmarks_size_ = old_bookmarks_length1;
	_tmp8_ = g_new0 (gchar*, 0 + 1);
	new_bookmarks = _tmp8_;
	new_bookmarks_length1 = 0;
	_new_bookmarks_size_ = new_bookmarks_length1;
	position = (guint) 0;
	_tmp9_ = old_bookmarks;
	_tmp9__length1 = old_bookmarks_length1;
	{
		gchar** bookmark_collection = NULL;
		gint bookmark_collection_length1 = 0;
		gint _bookmark_collection_size_ = 0;
		gint bookmark_it = 0;
		bookmark_collection = _tmp9_;
		bookmark_collection_length1 = _tmp9__length1;
		for (bookmark_it = 0; bookmark_it < bookmark_collection_length1; bookmark_it = bookmark_it + 1) {
			gchar* _tmp10_;
			gchar* bookmark = NULL;
			_tmp10_ = g_strdup (bookmark_collection[bookmark_it]);
			bookmark = _tmp10_;
			{
				guint _tmp16_;
				if (((guint) index) != position) {
					const gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp11_ = bookmark;
					_tmp12_ = g_strdup (_tmp11_);
					_vala_array_add8 (&new_bookmarks, &new_bookmarks_length1, &_new_bookmarks_size_, _tmp12_);
				}
				if (position == ((guint) (index + 1))) {
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp13_ = old_bookmarks;
					_tmp13__length1 = old_bookmarks_length1;
					_tmp14_ = _tmp13_[index];
					_tmp15_ = g_strdup (_tmp14_);
					_vala_array_add9 (&new_bookmarks, &new_bookmarks_length1, &_new_bookmarks_size_, _tmp15_);
				}
				_tmp16_ = position;
				position = _tmp16_ + 1;
				_g_free0 (bookmark);
			}
		}
	}
	_tmp17_ = new_bookmarks;
	_tmp17__length1 = new_bookmarks_length1;
	bookmarks_list_set_new_bookmarks (self, _tmp17_, (gint) _tmp17__length1);
	new_bookmarks = (_vala_array_free (new_bookmarks, new_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	old_bookmarks = (_vala_array_free (old_bookmarks, old_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	indices = (g_free (indices), NULL);
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
bookmarks_list_move_bottom (BookmarksList* self)
{
	gint* indices = NULL;
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint indices_length1;
	gint _indices_size_;
	gchar** old_bookmarks = NULL;
	GSettings* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint old_bookmarks_length1;
	gint _old_bookmarks_size_;
	gchar** new_bookmarks = NULL;
	gchar** _tmp5_;
	gint new_bookmarks_length1;
	gint _new_bookmarks_size_;
	gint* _tmp13_;
	gint _tmp13__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	g_return_if_fail (self != NULL);
	_tmp1_ = overlayed_list_get_selected_rows_indices ((OverlayedList*) self, &_tmp0_);
	indices = _tmp1_;
	indices_length1 = _tmp0_;
	_indices_size_ = indices_length1;
	_tmp2_ = self->priv->settings;
	_tmp4_ = _tmp3_ = g_settings_get_strv (_tmp2_, "bookmarks");
	old_bookmarks = _tmp4_;
	old_bookmarks_length1 = _vala_array_length (_tmp3_);
	_old_bookmarks_size_ = old_bookmarks_length1;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	new_bookmarks = _tmp5_;
	new_bookmarks_length1 = 0;
	_new_bookmarks_size_ = new_bookmarks_length1;
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gchar** _tmp8_;
				gint _tmp8__length1;
				gint* _tmp9_;
				gint _tmp9__length1;
				gchar** _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = index;
					index = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = old_bookmarks;
				_tmp8__length1 = old_bookmarks_length1;
				if (!(index < _tmp8__length1)) {
					break;
				}
				_tmp9_ = indices;
				_tmp9__length1 = indices_length1;
				if (_vala_int_array_contains (_tmp9_, _tmp9__length1, index)) {
					continue;
				}
				_tmp10_ = old_bookmarks;
				_tmp10__length1 = old_bookmarks_length1;
				_tmp11_ = _tmp10_[index];
				_tmp12_ = g_strdup (_tmp11_);
				_vala_array_add10 (&new_bookmarks, &new_bookmarks_length1, &_new_bookmarks_size_, _tmp12_);
			}
		}
	}
	_tmp13_ = indices;
	_tmp13__length1 = indices_length1;
	{
		gint* index_collection = NULL;
		gint index_collection_length1 = 0;
		gint _index_collection_size_ = 0;
		gint index_it = 0;
		index_collection = _tmp13_;
		index_collection_length1 = _tmp13__length1;
		for (index_it = 0; index_it < index_collection_length1; index_it = index_it + 1) {
			gint index = 0;
			index = index_collection[index_it];
			{
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = old_bookmarks;
				_tmp14__length1 = old_bookmarks_length1;
				_tmp15_ = _tmp14_[index];
				_tmp16_ = g_strdup (_tmp15_);
				_vala_array_add11 (&new_bookmarks, &new_bookmarks_length1, &_new_bookmarks_size_, _tmp16_);
			}
		}
	}
	_tmp17_ = new_bookmarks;
	_tmp17__length1 = new_bookmarks_length1;
	bookmarks_list_set_new_bookmarks (self, _tmp17_, (gint) _tmp17__length1);
	overlayed_list_scroll_bottom ((OverlayedList*) self);
	new_bookmarks = (_vala_array_free (new_bookmarks, new_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	old_bookmarks = (_vala_array_free (old_bookmarks, old_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	indices = (g_free (indices), NULL);
}

static void
bookmarks_list_set_new_bookmarks (BookmarksList* self,
                                  gchar** new_bookmarks,
                                  gint new_bookmarks_length1)
{
	GListStore* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GListStore* _tmp4_;
	GSettings* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((OverlayedList*) self)->main_list_store;
	g_signal_handler_block (_tmp0_, ((OverlayedList*) self)->content_changed_handler);
	_tmp1_ = self->priv->settings;
	g_signal_handler_block (_tmp1_, self->priv->bookmarks_changed_handler);
	_tmp2_ = self->priv->settings;
	g_settings_set_strv (_tmp2_, "bookmarks", new_bookmarks);
	g_settings_sync ();
	_tmp3_ = self->priv->settings;
	g_signal_handler_unblock (_tmp3_, self->priv->bookmarks_changed_handler);
	_tmp4_ = ((OverlayedList*) self)->main_list_store;
	g_signal_handler_unblock (_tmp4_, ((OverlayedList*) self)->content_changed_handler);
	_tmp5_ = self->priv->settings;
	bookmarks_list_on_bookmarks_changed (self, _tmp5_, "bookmarks");
}

void
bookmarks_list_append_bookmark (BookmarksList* self,
                                ViewType type,
                                const gchar* bookmark)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmark != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = bookmarks_list_get_bookmark_name (type, bookmark);
	_tmp2_ = _tmp1_;
	_bookmarks_list_append_bookmark (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
_vala_array_add12 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_bookmarks_list_append_bookmark (GSettings* settings,
                                 const gchar* bookmark_name)
{
	gchar** bookmarks = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint bookmarks_length1;
	gint _bookmarks_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (bookmark_name != NULL);
	_tmp1_ = _tmp0_ = g_settings_get_strv (settings, "bookmarks");
	bookmarks = _tmp1_;
	bookmarks_length1 = _vala_array_length (_tmp0_);
	_bookmarks_size_ = bookmarks_length1;
	_tmp2_ = bookmarks;
	_tmp2__length1 = bookmarks_length1;
	if (_vala_string_array_contains (_tmp2_, _tmp2__length1, bookmark_name)) {
		bookmarks = (_vala_array_free (bookmarks, bookmarks_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp3_ = g_strdup (bookmark_name);
	_vala_array_add12 (&bookmarks, &bookmarks_length1, &_bookmarks_size_, _tmp3_);
	_tmp4_ = bookmarks;
	_tmp4__length1 = bookmarks_length1;
	g_settings_set_strv (settings, "bookmarks", _tmp4_);
	bookmarks = (_vala_array_free (bookmarks, bookmarks_length1, (GDestroyNotify) g_free), NULL);
}

void
bookmarks_list_remove_bookmark (BookmarksList* self,
                                ViewType type,
                                const gchar* bookmark)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmark != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = bookmarks_list_get_bookmark_name (type, bookmark);
	_tmp2_ = _tmp1_;
	_bookmarks_list_remove_bookmark (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
_vala_array_add13 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_bookmarks_list_remove_bookmark (GSettings* settings,
                                 const gchar* bookmark_name)
{
	gchar** old_bookmarks = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint old_bookmarks_length1;
	gint _old_bookmarks_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** new_bookmarks = NULL;
	gchar** _tmp3_;
	gint new_bookmarks_length1;
	gint _new_bookmarks_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (bookmark_name != NULL);
	_tmp1_ = _tmp0_ = g_settings_get_strv (settings, "bookmarks");
	old_bookmarks = _tmp1_;
	old_bookmarks_length1 = _vala_array_length (_tmp0_);
	_old_bookmarks_size_ = old_bookmarks_length1;
	_tmp2_ = old_bookmarks;
	_tmp2__length1 = old_bookmarks_length1;
	if (!_vala_string_array_contains (_tmp2_, _tmp2__length1, bookmark_name)) {
		old_bookmarks = (_vala_array_free (old_bookmarks, old_bookmarks_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	new_bookmarks = _tmp3_;
	new_bookmarks_length1 = 0;
	_new_bookmarks_size_ = new_bookmarks_length1;
	_tmp4_ = old_bookmarks;
	_tmp4__length1 = old_bookmarks_length1;
	{
		gchar** bookmark_collection = NULL;
		gint bookmark_collection_length1 = 0;
		gint _bookmark_collection_size_ = 0;
		gint bookmark_it = 0;
		bookmark_collection = _tmp4_;
		bookmark_collection_length1 = _tmp4__length1;
		for (bookmark_it = 0; bookmark_it < bookmark_collection_length1; bookmark_it = bookmark_it + 1) {
			gchar* _tmp5_;
			gchar* bookmark = NULL;
			_tmp5_ = g_strdup (bookmark_collection[bookmark_it]);
			bookmark = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				const gchar* _tmp7_;
				_tmp7_ = bookmark;
				if (g_strcmp0 (_tmp7_, bookmark_name) != 0) {
					const gchar* _tmp8_;
					gchar** _tmp9_;
					gint _tmp9__length1;
					_tmp8_ = bookmark;
					_tmp9_ = new_bookmarks;
					_tmp9__length1 = new_bookmarks_length1;
					_tmp6_ = !_vala_string_array_contains (_tmp9_, _tmp9__length1, _tmp8_);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp10_ = bookmark;
					_tmp11_ = g_strdup (_tmp10_);
					_vala_array_add13 (&new_bookmarks, &new_bookmarks_length1, &_new_bookmarks_size_, _tmp11_);
				}
				_g_free0 (bookmark);
			}
		}
	}
	_tmp12_ = new_bookmarks;
	_tmp12__length1 = new_bookmarks_length1;
	g_settings_set_strv (settings, "bookmarks", _tmp12_);
	new_bookmarks = (_vala_array_free (new_bookmarks, new_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	old_bookmarks = (_vala_array_free (old_bookmarks, old_bookmarks_length1, (GDestroyNotify) g_free), NULL);
}

static void
_vala_array_add14 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
bookmarks_list_remove_bookmarks (GSettings* settings,
                                 gchar** bookmarks_to_remove,
                                 gint bookmarks_to_remove_length1)
{
	gchar** old_bookmarks = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint old_bookmarks_length1;
	gint _old_bookmarks_size_;
	gchar** new_bookmarks = NULL;
	gchar** _tmp2_;
	gint new_bookmarks_length1;
	gint _new_bookmarks_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	g_return_if_fail (settings != NULL);
	_tmp1_ = _tmp0_ = g_settings_get_strv (settings, "bookmarks");
	old_bookmarks = _tmp1_;
	old_bookmarks_length1 = _vala_array_length (_tmp0_);
	_old_bookmarks_size_ = old_bookmarks_length1;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	new_bookmarks = _tmp2_;
	new_bookmarks_length1 = 0;
	_new_bookmarks_size_ = new_bookmarks_length1;
	_tmp3_ = old_bookmarks;
	_tmp3__length1 = old_bookmarks_length1;
	{
		gchar** bookmark_collection = NULL;
		gint bookmark_collection_length1 = 0;
		gint _bookmark_collection_size_ = 0;
		gint bookmark_it = 0;
		bookmark_collection = _tmp3_;
		bookmark_collection_length1 = _tmp3__length1;
		for (bookmark_it = 0; bookmark_it < bookmark_collection_length1; bookmark_it = bookmark_it + 1) {
			gchar* _tmp4_;
			gchar* bookmark = NULL;
			_tmp4_ = g_strdup (bookmark_collection[bookmark_it]);
			bookmark = _tmp4_;
			{
				gboolean _tmp5_ = FALSE;
				const gchar* _tmp6_;
				_tmp6_ = bookmark;
				if (!_vala_string_array_contains (bookmarks_to_remove, bookmarks_to_remove_length1, _tmp6_)) {
					const gchar* _tmp7_;
					gchar** _tmp8_;
					gint _tmp8__length1;
					_tmp7_ = bookmark;
					_tmp8_ = new_bookmarks;
					_tmp8__length1 = new_bookmarks_length1;
					_tmp5_ = !_vala_string_array_contains (_tmp8_, _tmp8__length1, _tmp7_);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					const gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp9_ = bookmark;
					_tmp10_ = g_strdup (_tmp9_);
					_vala_array_add14 (&new_bookmarks, &new_bookmarks_length1, &_new_bookmarks_size_, _tmp10_);
				}
				_g_free0 (bookmark);
			}
		}
	}
	_tmp11_ = new_bookmarks;
	_tmp11__length1 = new_bookmarks_length1;
	g_settings_set_strv (settings, "bookmarks", _tmp11_);
	new_bookmarks = (_vala_array_free (new_bookmarks, new_bookmarks_length1, (GDestroyNotify) g_free), NULL);
	old_bookmarks = (_vala_array_free (old_bookmarks, old_bookmarks_length1, (GDestroyNotify) g_free), NULL);
}

inline gchar*
bookmarks_list_get_bookmark_name (ViewType type,
                                  const gchar* path)
{
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	if (type == VIEW_TYPE_SEARCH) {
		gchar* _tmp0_;
		_tmp0_ = g_strconcat ("?", path, NULL);
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (path);
		result = _tmp1_;
		return result;
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BookmarksList* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_bookmarks_list_on_bookmarks_changed_g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self)
{
	bookmarks_list_on_bookmarks_changed ((BookmarksList*) self, _sender, key);
}

static void
_bookmarks_list_on_writability_changed_g_settings_writable_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self)
{
	bookmarks_list_on_writability_changed ((BookmarksList*) self, _sender, key);
}

static void
_bookmarks_list_schema_path___lambda104_ (Block5Data* _data5_)
{
	BookmarksList* self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	self = _data5_->self;
	_tmp0_ = self->priv->settings;
	g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->bookmarks_changed_handler);
	_tmp1_ = self->priv->settings;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _data5_->bookmarks_writable_handler);
}

static void
__bookmarks_list_schema_path___lambda104__gtk_widget_destroy (GtkWidget* _sender,
                                                              gpointer self)
{
	_bookmarks_list_schema_path___lambda104_ (self);
}

void
bookmarks_list_set_schema_path (BookmarksList* self,
                                const gchar* value)
{
	Block5Data* _data5_;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gulong _tmp3_;
	GSettings* _tmp4_;
	gulong _tmp5_;
	GVariant* bookmarks_variant = NULL;
	GSettings* _tmp6_;
	GVariant* _tmp7_;
	gboolean is_writable = FALSE;
	GSettings* _tmp8_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->priv->schema_id;
	_tmp1_ = g_settings_new_with_path (_tmp0_, value);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_signal_connect_object (_tmp2_, "changed::bookmarks", (GCallback) _bookmarks_list_on_bookmarks_changed_g_settings_changed, self, 0);
	self->priv->bookmarks_changed_handler = _tmp3_;
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_signal_connect_object (_tmp4_, "writable-changed::bookmarks", (GCallback) _bookmarks_list_on_writability_changed_g_settings_writable_changed, self, 0);
	_data5_->bookmarks_writable_handler = _tmp5_;
	_tmp6_ = self->priv->settings;
	_tmp7_ = g_settings_get_value (_tmp6_, "bookmarks");
	bookmarks_variant = _tmp7_;
	_tmp8_ = self->priv->settings;
	is_writable = g_settings_is_writable (_tmp8_, "bookmarks");
	bookmarks_list_create_bookmark_rows (self, bookmarks_variant);
	overlayed_list_change_editability ((OverlayedList*) self, is_writable);
	g_signal_emit (self, bookmarks_list_signals[BOOKMARKS_LIST_BOOKMARKS_CHANGED_SIGNAL], 0, bookmarks_variant, is_writable);
	g_signal_connect_data ((GtkWidget*) self, "destroy", (GCallback) __bookmarks_list_schema_path___lambda104__gtk_widget_destroy, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_g_variant_unref0 (bookmarks_variant);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	g_object_notify_by_pspec ((GObject *) self, bookmarks_list_properties[BOOKMARKS_LIST_SCHEMA_PATH_PROPERTY]);
}

static void
g_cclosure_user_marshal_VOID__VARIANT_BOOLEAN (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__VARIANT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__VARIANT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__VARIANT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_variant (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static GObject *
bookmarks_list_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BookmarksList * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	parent_class = G_OBJECT_CLASS (bookmarks_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARKS_LIST, BookmarksList);
	_tmp0_ = g_strdup ("starred-symbolic");
	_g_free0 (((OverlayedList*) self)->placeholder_icon);
	((OverlayedList*) self)->placeholder_icon = _tmp0_;
	_tmp1_ = g_strdup (_ ("Bookmarks will\nbe added here"));
	_g_free0 (((OverlayedList*) self)->placeholder_text);
	((OverlayedList*) self)->placeholder_text = _tmp1_;
	overlayed_list_add_placeholder ((OverlayedList*) self);
	overlayed_list_set_first_mode_name ((OverlayedList*) self, _ ("Use"));
	overlayed_list_set_second_mode_name ((OverlayedList*) self, _ ("Edit"));
	return obj;
}

static void
bookmarks_list_class_init (BookmarksListClass * klass,
                           gpointer klass_data)
{
	bookmarks_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BookmarksList_private_offset);
	((OverlayedListClass *) klass)->reset = (void (*) (OverlayedList*)) bookmarks_list_real_reset;
	G_OBJECT_CLASS (klass)->set_property = _vala_bookmarks_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = bookmarks_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = bookmarks_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKMARKS_LIST_SCHEMA_PATH_PROPERTY, bookmarks_list_properties[BOOKMARKS_LIST_SCHEMA_PATH_PROPERTY] = g_param_spec_string ("schema-path", "schema-path", "schema-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	bookmarks_list_signals[BOOKMARKS_LIST_BOOKMARKS_CHANGED_SIGNAL] = g_signal_new ("bookmarks-changed", TYPE_BOOKMARKS_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__VARIANT_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_VARIANT, G_TYPE_BOOLEAN);
	bookmarks_list_signals[BOOKMARKS_LIST_UPDATE_BOOKMARKS_ICONS_SIGNAL] = g_signal_new ("update-bookmarks-icons", TYPE_BOOKMARKS_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VARIANT, G_TYPE_NONE, 1, G_TYPE_VARIANT);
	bookmarks_list_signals[BOOKMARKS_LIST_WRITABILITY_CHANGED_SIGNAL] = g_signal_new ("writability-changed", TYPE_BOOKMARKS_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
bookmarks_list_instance_init (BookmarksList * self,
                              gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	self->priv = bookmarks_list_get_instance_private (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	self->priv->bookmarks_hashtable = _tmp2_;
	_tmp3_ = g_strdup ("ca.desrt.dconf-editor.Bookmarks");
	self->priv->schema_id = _tmp3_;
	self->priv->bookmarks_changed_handler = (gulong) 0;
	self->priv->view_mode = TRUE;
}

static void
bookmarks_list_finalize (GObject * obj)
{
	BookmarksList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARKS_LIST, BookmarksList);
	_g_hash_table_unref0 (self->priv->bookmarks_hashtable);
	_g_free0 (self->priv->schema_id);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (bookmarks_list_parent_class)->finalize (obj);
}

static GType
bookmarks_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookmarksListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookmarks_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookmarksList), 0, (GInstanceInitFunc) bookmarks_list_instance_init, NULL };
	GType bookmarks_list_type_id;
	bookmarks_list_type_id = g_type_register_static (TYPE_OVERLAYED_LIST, "BookmarksList", &g_define_type_info, 0);
	BookmarksList_private_offset = g_type_add_instance_private (bookmarks_list_type_id, sizeof (BookmarksListPrivate));
	return bookmarks_list_type_id;
}

GType
bookmarks_list_get_type (void)
{
	static volatile gsize bookmarks_list_type_id__once = 0;
	if (g_once_init_enter (&bookmarks_list_type_id__once)) {
		GType bookmarks_list_type_id;
		bookmarks_list_type_id = bookmarks_list_get_type_once ();
		g_once_init_leave (&bookmarks_list_type_id__once, bookmarks_list_type_id);
	}
	return bookmarks_list_type_id__once;
}

static void
_vala_bookmarks_list_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	BookmarksList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOKMARKS_LIST, BookmarksList);
	switch (property_id) {
		case BOOKMARKS_LIST_SCHEMA_PATH_PROPERTY:
		bookmarks_list_set_schema_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
bookmark_get_instance_private (Bookmark* self)
{
	return G_STRUCT_MEMBER_P (self, Bookmark_private_offset);
}

Bookmark*
bookmark_construct (GType object_type,
                    const gchar* bookmark_name,
                    gboolean view_mode)
{
	Bookmark * self = NULL;
	g_return_val_if_fail (bookmark_name != NULL, NULL);
	self = (Bookmark*) g_object_new (object_type, "bookmark-name", bookmark_name, NULL);
	bookmark_set_actionable (self, view_mode);
	return self;
}

Bookmark*
bookmark_new (const gchar* bookmark_name,
              gboolean view_mode)
{
	return bookmark_construct (TYPE_BOOKMARK, bookmark_name, view_mode);
}

void
bookmark_set_actionable (Bookmark* self,
                         gboolean actionable)
{
	g_return_if_fail (self != NULL);
	if (actionable) {
		const gchar* _tmp0_;
		_tmp0_ = self->priv->detailed_action_name;
		gtk_actionable_set_detailed_action_name ((GtkActionable*) self, _tmp0_);
	} else {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->inactive_action_name;
		gtk_actionable_set_detailed_action_name ((GtkActionable*) self, _tmp1_);
	}
}

static gboolean
bookmark_real_handle_copy_text (OverlayedListRow* base,
                                gchar** copy_text)
{
	Bookmark * self;
	gchar* _vala_copy_text = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	self = (Bookmark*) base;
	_tmp0_ = self->priv->_bookmark_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp1_;
	result = TRUE;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

static void
bookmark_construct_actions_names (const gchar* bookmark_text,
                                  ViewType bookmark_type,
                                  gchar** detailed_action_name,
                                  gchar** inactive_action_name)
{
	gchar* _vala_detailed_action_name = NULL;
	gchar* _vala_inactive_action_name = NULL;
	g_return_if_fail (bookmark_text != NULL);
	switch (bookmark_type) {
		case VIEW_TYPE_SEARCH:
		{
			GVariant* variant = NULL;
			GVariant* _tmp0_;
			GVariant* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp0_ = g_variant_new_string (bookmark_text);
			g_variant_ref_sink (_tmp0_);
			variant = _tmp0_;
			_tmp1_ = variant;
			_tmp2_ = g_variant_print (_tmp1_, FALSE);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_strconcat ("browser.open-search(", _tmp3_, NULL);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strconcat (_tmp5_, ")", NULL);
			_g_free0 (_vala_detailed_action_name);
			_vala_detailed_action_name = _tmp6_;
			_g_free0 (_tmp5_);
			_g_free0 (_tmp3_);
			_tmp7_ = g_strdup ("browser.empty('')");
			_g_free0 (_vala_inactive_action_name);
			_vala_inactive_action_name = _tmp7_;
			_g_variant_unref0 (variant);
			if (detailed_action_name) {
				*detailed_action_name = _vala_detailed_action_name;
			} else {
				_g_free0 (_vala_detailed_action_name);
			}
			if (inactive_action_name) {
				*inactive_action_name = _vala_inactive_action_name;
			} else {
				_g_free0 (_vala_inactive_action_name);
			}
			return;
		}
		case VIEW_TYPE_FOLDER:
		{
			GVariant* variant = NULL;
			GVariant* _tmp8_;
			GVariant* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp8_ = g_variant_new_string (bookmark_text);
			g_variant_ref_sink (_tmp8_);
			variant = _tmp8_;
			_tmp9_ = variant;
			_tmp10_ = g_variant_print (_tmp9_, FALSE);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat ("browser.open-folder(", _tmp11_, NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat (_tmp13_, ")", NULL);
			_g_free0 (_vala_detailed_action_name);
			_vala_detailed_action_name = _tmp14_;
			_g_free0 (_tmp13_);
			_g_free0 (_tmp11_);
			_tmp15_ = g_strdup ("browser.empty('')");
			_g_free0 (_vala_inactive_action_name);
			_vala_inactive_action_name = _tmp15_;
			_g_variant_unref0 (variant);
			if (detailed_action_name) {
				*detailed_action_name = _vala_detailed_action_name;
			} else {
				_g_free0 (_vala_detailed_action_name);
			}
			if (inactive_action_name) {
				*inactive_action_name = _vala_inactive_action_name;
			} else {
				_g_free0 (_vala_inactive_action_name);
			}
			return;
		}
		case VIEW_TYPE_OBJECT:
		{
			GVariant* variant = NULL;
			GVariant* _tmp16_;
			GVariant* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp16_ = g_variant_new ("(sq)", bookmark_text, MODEL_UTILS_undefined_context_id, NULL);
			g_variant_ref_sink (_tmp16_);
			variant = _tmp16_;
			_tmp17_ = variant;
			_tmp18_ = g_variant_print (_tmp17_, TRUE);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strconcat ("browser.open-object(", _tmp19_, NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strconcat (_tmp21_, ")", NULL);
			_g_free0 (_vala_detailed_action_name);
			_vala_detailed_action_name = _tmp22_;
			_g_free0 (_tmp21_);
			_g_free0 (_tmp19_);
			_tmp23_ = g_strdup ("browser.empty(('',uint16 65535))");
			_g_free0 (_vala_inactive_action_name);
			_vala_inactive_action_name = _tmp23_;
			_g_variant_unref0 (variant);
			if (detailed_action_name) {
				*detailed_action_name = _vala_detailed_action_name;
			} else {
				_g_free0 (_vala_detailed_action_name);
			}
			if (inactive_action_name) {
				*inactive_action_name = _vala_inactive_action_name;
			} else {
				_g_free0 (_vala_inactive_action_name);
			}
			return;
		}
		default:
		case VIEW_TYPE_CONFIG:
		{
			g_assert_not_reached ();
		}
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
bookmark_parse_bookmark_name (const gchar* bookmark_name,
                              gchar** bookmark_text,
                              ViewType* bookmark_type)
{
	gchar* _vala_bookmark_text = NULL;
	ViewType _vala_bookmark_type = 0;
	g_return_if_fail (bookmark_name != NULL);
	if (g_str_has_prefix (bookmark_name, "?")) {
		gint _tmp0_;
		gint _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = strlen (bookmark_name);
		_tmp1_ = _tmp0_;
		_tmp2_ = string_slice (bookmark_name, (glong) 1, (glong) _tmp1_);
		_g_free0 (_vala_bookmark_text);
		_vala_bookmark_text = _tmp2_;
		_vala_bookmark_type = VIEW_TYPE_SEARCH;
	} else {
		if (model_utils_is_folder_path (bookmark_name)) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup (bookmark_name);
			_g_free0 (_vala_bookmark_text);
			_vala_bookmark_text = _tmp3_;
			_vala_bookmark_type = VIEW_TYPE_FOLDER;
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup (bookmark_name);
			_g_free0 (_vala_bookmark_text);
			_vala_bookmark_text = _tmp4_;
			_vala_bookmark_type = VIEW_TYPE_OBJECT;
		}
	}
	if (bookmark_text) {
		*bookmark_text = _vala_bookmark_text;
	} else {
		_g_free0 (_vala_bookmark_text);
	}
	if (bookmark_type) {
		*bookmark_type = _vala_bookmark_type;
	}
}

const gchar*
bookmark_get_bookmark_name (Bookmark* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_bookmark_name;
	result = _tmp0_;
	return result;
}

static void
bookmark_set_bookmark_name (Bookmark* self,
                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_bookmark_name);
	self->priv->_bookmark_name = _tmp0_;
}

static GObject *
bookmark_constructor (GType type,
                      guint n_construct_properties,
                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Bookmark * self;
	gchar* bookmark_text = NULL;
	ViewType bookmark_type = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	ViewType _tmp2_ = 0;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_;
	const gchar* _tmp7_;
	parent_class = G_OBJECT_CLASS (bookmark_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARK, Bookmark);
	_tmp0_ = self->priv->_bookmark_name;
	bookmark_parse_bookmark_name (_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (bookmark_text);
	bookmark_text = _tmp1_;
	bookmark_type = _tmp2_;
	_tmp3_ = bookmark_text;
	bookmark_construct_actions_names (_tmp3_, bookmark_type, &_tmp4_, &_tmp5_);
	_g_free0 (self->priv->detailed_action_name);
	self->priv->detailed_action_name = _tmp4_;
	_g_free0 (self->priv->inactive_action_name);
	self->priv->inactive_action_name = _tmp5_;
	_tmp6_ = self->priv->bookmark_label;
	_tmp7_ = bookmark_text;
	gtk_label_set_label (_tmp6_, _tmp7_);
	_g_free0 (bookmark_text);
	return obj;
}

static void
bookmark_class_init (BookmarkClass * klass,
                     gpointer klass_data)
{
	bookmark_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Bookmark_private_offset);
	((OverlayedListRowClass *) klass)->handle_copy_text = (gboolean (*) (OverlayedListRow*, gchar**)) bookmark_real_handle_copy_text;
	G_OBJECT_CLASS (klass)->get_property = _vala_bookmark_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bookmark_set_property;
	G_OBJECT_CLASS (klass)->constructor = bookmark_constructor;
	G_OBJECT_CLASS (klass)->finalize = bookmark_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOKMARK_BOOKMARK_NAME_PROPERTY, bookmark_properties[BOOKMARK_BOOKMARK_NAME_PROPERTY] = g_param_spec_string ("bookmark-name", "bookmark-name", "bookmark-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/bookmark.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bookmark_label", FALSE, Bookmark_private_offset + G_STRUCT_OFFSET (BookmarkPrivate, bookmark_label));
}

static void
bookmark_instance_init (Bookmark * self,
                        gpointer klass)
{
	self->priv = bookmark_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
bookmark_finalize (GObject * obj)
{
	Bookmark * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARK, Bookmark);
	_g_free0 (self->priv->_bookmark_name);
	_g_free0 (self->priv->detailed_action_name);
	_g_free0 (self->priv->inactive_action_name);
	G_OBJECT_CLASS (bookmark_parent_class)->finalize (obj);
}

static GType
bookmark_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookmarkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookmark_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Bookmark), 0, (GInstanceInitFunc) bookmark_instance_init, NULL };
	GType bookmark_type_id;
	bookmark_type_id = g_type_register_static (TYPE_OVERLAYED_LIST_ROW, "Bookmark", &g_define_type_info, 0);
	Bookmark_private_offset = g_type_add_instance_private (bookmark_type_id, sizeof (BookmarkPrivate));
	return bookmark_type_id;
}

GType
bookmark_get_type (void)
{
	static volatile gsize bookmark_type_id__once = 0;
	if (g_once_init_enter (&bookmark_type_id__once)) {
		GType bookmark_type_id;
		bookmark_type_id = bookmark_get_type_once ();
		g_once_init_leave (&bookmark_type_id__once, bookmark_type_id);
	}
	return bookmark_type_id__once;
}

static void
_vala_bookmark_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Bookmark * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOKMARK, Bookmark);
	switch (property_id) {
		case BOOKMARK_BOOKMARK_NAME_PROPERTY:
		g_value_set_string (value, bookmark_get_bookmark_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bookmark_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Bookmark * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOKMARK, Bookmark);
	switch (property_id) {
		case BOOKMARK_BOOKMARK_NAME_PROPERTY:
		bookmark_set_bookmark_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

