/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.HeapFragment;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.truffle.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectArrayItemNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TerminalJavaNodes;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.netbeans.api.progress.ProgressHandle;

public abstract class TruffleInstancePropertyProvider<O extends TruffleObject, T extends TruffleType<O>, F extends TruffleLanguageHeapFragment<O, T>, L extends TruffleLanguage<O, T, F>, I>
extends HeapViewerNode.Provider {
    private final L language;
    private final String propertyName;
    private final int maxPropertyItems;
    private final boolean displaysProgress;
    private final boolean filtersProperties;

    protected TruffleInstancePropertyProvider(String propertyName, L language, boolean displaysProgress, boolean filtersProperties, int maxPropertyItems) {
        this.language = language;
        this.propertyName = propertyName;
        this.maxPropertyItems = maxPropertyItems;
        this.displaysProgress = displaysProgress;
        this.filtersProperties = filtersProperties;
    }

    public String getName() {
        return this.propertyName;
    }

    protected final L getLanguage() {
        return this.language;
    }

    public abstract boolean supportsView(Heap var1, String var2);

    public abstract boolean supportsNode(HeapViewerNode var1, Heap var2, String var3);

    protected abstract Collection<I> getPropertyItems(Instance var1);

    protected boolean includeItem(I item) {
        return true;
    }

    protected abstract HeapViewerNode createNode(I var1, Heap var2);

    public final HeapViewerNode[] getNodes(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        Instance instance = (Instance)HeapViewerNode.getValue((HeapViewerNode)parent, (DataType)DataType.INSTANCE, (Heap)heap);
        return instance == null ? null : this.getNodes(instance, parent, heap, viewID, viewFilter, dataTypes, sortOrders, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final HeapViewerNode[] getNodes(Instance instance, HeapViewerNode parent, final Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        Collection<I> itemsC = null;
        if (!this.displaysProgress) {
            itemsC = this.getPropertyItems(instance);
        } else {
            ProgressHandle pHandle = ProgressHandle.createHandle((String)Bundle.TruffleInstancePropertyProvider_ComputingNodes(this.propertyName));
            pHandle.setInitialDelay(1000);
            pHandle.start(1000);
            HeapFragment.setProgress((ProgressHandle)pHandle, (int)0);
            try {
                itemsC = this.getPropertyItems(instance);
            }
            finally {
                pHandle.finish();
            }
        }
        if (itemsC == null) {
            return null;
        }
        final ArrayList<I> items = new ArrayList<I>(itemsC);
        if (this.filtersProperties) {
            Iterator itemsIt = items.iterator();
            while (itemsIt.hasNext()) {
                if (this.includeItem(itemsIt.next())) continue;
                itemsIt.remove();
            }
        }
        NodesComputer<Integer> computer = new NodesComputer<Integer>(items.size(), this.maxPropertyItems){

            protected boolean sorts(DataType dataType) {
                return !DataType.COUNT.equals(dataType);
            }

            protected HeapViewerNode createNode(Integer index) {
                return TruffleInstancePropertyProvider.this.createNode(items.get(index), heap);
            }

            protected ProgressIterator<Integer> objectsIterator(int index, Progress progress) {
                Iterator iterator = 1.integerIterator((int)index, (int)items.size());
                return new ProgressIterator(iterator, index, false, progress);
            }

            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.TruffleInstancePropertyProvider_MoreNodes(moreNodesCount, TruffleInstancePropertyProvider.this.propertyName);
            }

            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.TruffleInstancePropertyProvider_SamplesContainer(objectsCount, TruffleInstancePropertyProvider.this.propertyName);
            }

            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.TruffleInstancePropertyProvider_NodesContainer(firstNodeIdx, lastNodeIdx, TruffleInstancePropertyProvider.this.propertyName);
            }
        };
        return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
    }

    public static abstract class ArrayItems<O extends TruffleObject, T extends TruffleType<O>, F extends TruffleLanguageHeapFragment<O, T>, L extends TruffleLanguage<O, T, F>>
    extends TruffleInstancePropertyProvider<O, T, F, L, ArrayItemValue> {
        public ArrayItems(String propertyName, L language, boolean filtersProperties) {
            super(propertyName, language, false, filtersProperties, UIThresholds.MAX_ARRAY_ITEMS);
        }

        @Override
        public boolean supportsNode(HeapViewerNode parent, Heap heap, String viewID) {
            if (parent instanceof InstanceNode && !InstanceNode.Mode.INCOMING_REFERENCE.equals((Object)((InstanceNode)parent).getMode())) {
                Instance instance = ((InstanceNode)parent).getInstance();
                return instance instanceof ObjectArrayInstance;
            }
            return false;
        }

        @Override
        protected Collection<ArrayItemValue> getPropertyItems(Instance instance) {
            return ((ObjectArrayInstance)instance).getItems();
        }

        protected abstract HeapViewerNode createObjectArrayItemNode(O var1, String var2, ArrayItemValue var3);

        @Override
        protected boolean includeItem(ArrayItemValue item) {
            Instance instance = item.getInstance();
            if (instance == null) {
                return true;
            }
            if (instance instanceof PrimitiveArrayInstance) {
                return true;
            }
            if (((TruffleLanguage)((Object)this.getLanguage())).isLanguageObject(instance)) {
                return true;
            }
            if (DynamicObject.isDynamicObject(instance)) {
                return true;
            }
            return this.includeInstance(instance);
        }

        protected boolean includeInstance(Instance instance) {
            return true;
        }

        @Override
        protected final HeapViewerNode createNode(ArrayItemValue item, Heap heap) {
            Instance instance = item.getInstance();
            if (((TruffleLanguage)((Object)this.getLanguage())).isLanguageObject(instance)) {
                Object object = ((TruffleLanguage)((Object)this.getLanguage())).createObject(instance);
                return this.createObjectArrayItemNode(object, ((TruffleObject)object).getType(), item);
            }
            return this.createForeignArrayItemNode(instance, item, heap);
        }

        protected HeapViewerNode createForeignArrayItemNode(Instance instance, ArrayItemValue item, Heap heap) {
            if (DynamicObject.isDynamicObject(instance)) {
                DynamicObject dobj = new DynamicObject(instance);
                return new DynamicObjectArrayItemNode<DynamicObject>(dobj, dobj.getType(), item);
            }
            return new TerminalJavaNodes.ArrayItem(item, false);
        }
    }
}

