/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.visualvm.jmx.impl.JmxApplication;
import org.openide.util.RequestProcessor;

abstract class JmxHeartbeat {
    private static final int MAX_HEARTBEAT_THREADS = Integer.getInteger("org.graalvm.visualvm.jmx.JmxHeartbeatThreads", 10);
    private static final int LAZY_HEARTBEAT_DELAY = Integer.getInteger("org.graalvm.visualvm.jmx.HeartbeatDelay", 5000);
    private static final int IMMEDIATE_HEARTBEAT_DELAY = Integer.getInteger("org.graalvm.visualvm.jmx.ImmediateHeartbeatDelay", 100);
    private static final JmxHeartbeat LAZY = new Lazy();
    private static final JmxHeartbeat IMMEDIATE = new Immediate(LAZY);
    private final String id;
    private final int delay;

    private JmxHeartbeat(String id, int delay) {
        this.id = id;
        this.delay = delay;
    }

    static void scheduleImmediately(JmxApplication ... apps) {
        IMMEDIATE.schedule(apps);
    }

    static void scheduleLazily(JmxApplication ... apps) {
        LAZY.schedule(apps);
    }

    protected abstract void schedule(JmxApplication ... var1);

    protected abstract void pingFinished(JmxApplication ... var1);

    protected final void pingApps(Collection<JmxApplication> applications) {
        int count = applications.size();
        final AtomicInteger counter = new AtomicInteger(count);
        final List unresolved = Collections.synchronizedList(new ArrayList());
        RequestProcessor processor = new RequestProcessor("JMX " + this.id + " Heartbeat Processor", Math.min(count, MAX_HEARTBEAT_THREADS));
        for (final JmxApplication app : applications) {
            processor.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!app.tryConnect()) {
                            unresolved.add(app);
                        }
                    }
                    finally {
                        if (counter.decrementAndGet() == 0) {
                            JmxHeartbeat.this.pingFinished(unresolved.toArray(new JmxApplication[0]));
                        }
                    }
                }
            }, this.delay);
        }
    }

    protected static void cleanupUnavailableApps(Collection<JmxApplication> apps, boolean checkHeartbeat) {
        Iterator<JmxApplication> appsI = apps.iterator();
        while (appsI.hasNext()) {
            JmxApplication app = appsI.next();
            if (app.isRemoved() || app.getState() == 1) {
                appsI.remove();
                continue;
            }
            if (!checkHeartbeat || !app.isHeartbeatDisabled()) continue;
            appsI.remove();
        }
    }

    private static final class Immediate
    extends JmxHeartbeat {
        private final JmxHeartbeat fallback;

        private Immediate(JmxHeartbeat fallback) {
            super("Immediate", IMMEDIATE_HEARTBEAT_DELAY);
            this.fallback = fallback;
        }

        @Override
        protected void schedule(JmxApplication ... apps) {
            if (apps == null || apps.length == 0) {
                return;
            }
            ArrayList<JmxApplication> unavailableApps = new ArrayList<JmxApplication>(Arrays.asList(apps));
            Immediate.cleanupUnavailableApps(unavailableApps, false);
            if (unavailableApps.isEmpty()) {
                return;
            }
            this.pingApps(unavailableApps);
        }

        @Override
        protected void pingFinished(JmxApplication ... apps) {
            if (apps.length > 0) {
                this.fallback.schedule(apps);
            }
        }
    }

    private static final class Lazy
    extends JmxHeartbeat {
        private final Collection<JmxApplication> unavailable = new HashSet<JmxApplication>();
        private boolean heartbeatRunning;

        private Lazy() {
            super("Lazy", LAZY_HEARTBEAT_DELAY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void schedule(JmxApplication ... apps) {
            ArrayList<JmxApplication> toPing;
            Collection<JmxApplication> collection = this.unavailable;
            synchronized (collection) {
                if (apps != null && apps.length > 0) {
                    this.unavailable.addAll(Arrays.asList(apps));
                }
                Lazy.cleanupUnavailableApps(this.unavailable, true);
                if (this.heartbeatRunning || this.unavailable.isEmpty()) {
                    return;
                }
                this.heartbeatRunning = true;
                toPing = new ArrayList<JmxApplication>(this.unavailable);
                this.unavailable.clear();
            }
            this.pingApps(toPing);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void pingFinished(JmxApplication ... apps) {
            boolean pendingUnavailable;
            Collection<JmxApplication> collection = this.unavailable;
            synchronized (collection) {
                if (apps.length > 0) {
                    this.unavailable.addAll(Arrays.asList(apps));
                }
                Lazy.cleanupUnavailableApps(this.unavailable, true);
                pendingUnavailable = !this.unavailable.isEmpty();
                this.heartbeatRunning = false;
            }
            if (pendingUnavailable) {
                this.schedule(new JmxApplication[0]);
            }
        }
    }
}

