/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eggs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemWelcome
extends PlainDiagram {
    private final List<String> strings = new ArrayList<String>();
    private final GraphicPosition position;

    public PSystemWelcome(UmlSource source, GraphicPosition position) {
        super(source);
        this.position = position;
        this.strings.add("<b>Welcome to PlantUML!");
        this.strings.add(" ");
        this.strings.add("You can start with a simple UML Diagram like:");
        this.strings.add(" ");
        this.strings.add("\"\"Bob->Alice: Hello\"\"");
        this.strings.add(" ");
        this.strings.add("Or");
        this.strings.add(" ");
        this.strings.add("\"\"class Example\"\"");
        this.strings.add(" ");
        this.strings.add("You will find more information about PlantUML syntax on <u>https://plantuml.com</u>");
        this.strings.add(" ");
        this.strings.add("(If you use this software, you accept its license)");
        this.strings.add("(Details by typing \"\"license\"\" keyword)");
        this.strings.add(" ");
        if (position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
            this.strings.add(" ");
            this.strings.add(" ");
            this.strings.add(" ");
            this.strings.add(" ");
        }
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) throws IOException {
        return this.getGraphicStrings();
    }

    public TextBlockBackcolored getGraphicStrings() {
        if (this.position != null) {
            return GraphicStrings.createBlackOnWhite(this.strings, PSystemVersion.getPlantumlImage(), this.position);
        }
        return GraphicStrings.createBlackOnWhite(this.strings);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Empty)");
    }
}

