// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from AT90USB1287.atdf, see http://packs.download.atmel.com/

//go:build avr && at90usb1287
// +build avr,at90usb1287

// Device information for the AT90USB1287.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "AT90USB1287"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin,Power-on Reset,Brown-out Reset,Watchdog Reset,and JTAG AVR Reset. See Datasheet.
	IRQ_INT0         = 1  // External Interrupt Request 0
	IRQ_INT1         = 2  // External Interrupt Request 1
	IRQ_INT2         = 3  // External Interrupt Request 2
	IRQ_INT3         = 4  // External Interrupt Request 3
	IRQ_INT4         = 5  // External Interrupt Request 4
	IRQ_INT5         = 6  // External Interrupt Request 5
	IRQ_INT6         = 7  // External Interrupt Request 6
	IRQ_INT7         = 8  // External Interrupt Request 7
	IRQ_PCINT0       = 9  // Pin Change Interrupt Request 0
	IRQ_USB_GEN      = 10 // USB General Interrupt Request
	IRQ_USB_COM      = 11 // USB Endpoint/Pipe Interrupt Communication Request
	IRQ_WDT          = 12 // Watchdog Time-out Interrupt
	IRQ_TIMER2_COMPA = 13 // Timer/Counter2 Compare Match A
	IRQ_TIMER2_COMPB = 14 // Timer/Counter2 Compare Match B
	IRQ_TIMER2_OVF   = 15 // Timer/Counter2 Overflow
	IRQ_TIMER1_CAPT  = 16 // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 17 // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 18 // Timer/Counter1 Compare Match B
	IRQ_TIMER1_COMPC = 19 // Timer/Counter1 Compare Match C
	IRQ_TIMER1_OVF   = 20 // Timer/Counter1 Overflow
	IRQ_TIMER0_COMPA = 21 // Timer/Counter0 Compare Match A
	IRQ_TIMER0_COMPB = 22 // Timer/Counter0 Compare Match B
	IRQ_TIMER0_OVF   = 23 // Timer/Counter0 Overflow
	IRQ_SPI_STC      = 24 // SPI Serial Transfer Complete
	IRQ_USART1_RX    = 25 // USART1, Rx Complete
	IRQ_USART1_UDRE  = 26 // USART1 Data register Empty
	IRQ_USART1_TX    = 27 // USART1, Tx Complete
	IRQ_ANALOG_COMP  = 28 // Analog Comparator
	IRQ_ADC          = 29 // ADC Conversion Complete
	IRQ_EE_READY     = 30 // EEPROM Ready
	IRQ_TIMER3_CAPT  = 31 // Timer/Counter3 Capture Event
	IRQ_TIMER3_COMPA = 32 // Timer/Counter3 Compare Match A
	IRQ_TIMER3_COMPB = 33 // Timer/Counter3 Compare Match B
	IRQ_TIMER3_COMPC = 34 // Timer/Counter3 Compare Match C
	IRQ_TIMER3_OVF   = 35 // Timer/Counter3 Overflow
	IRQ_TWI          = 36 // 2-wire Serial Interface
	IRQ_SPM_READY    = 37 // Store Program Memory Read
	IRQ_max          = 37 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_INT1
//go:interrupt
func interruptINT1() {
	callHandlers(IRQ_INT1)
}

//export __vector_INT2
//go:interrupt
func interruptINT2() {
	callHandlers(IRQ_INT2)
}

//export __vector_INT3
//go:interrupt
func interruptINT3() {
	callHandlers(IRQ_INT3)
}

//export __vector_INT4
//go:interrupt
func interruptINT4() {
	callHandlers(IRQ_INT4)
}

//export __vector_INT5
//go:interrupt
func interruptINT5() {
	callHandlers(IRQ_INT5)
}

//export __vector_INT6
//go:interrupt
func interruptINT6() {
	callHandlers(IRQ_INT6)
}

//export __vector_INT7
//go:interrupt
func interruptINT7() {
	callHandlers(IRQ_INT7)
}

//export __vector_PCINT0
//go:interrupt
func interruptPCINT0() {
	callHandlers(IRQ_PCINT0)
}

//export __vector_USB_GEN
//go:interrupt
func interruptUSB_GEN() {
	callHandlers(IRQ_USB_GEN)
}

//export __vector_USB_COM
//go:interrupt
func interruptUSB_COM() {
	callHandlers(IRQ_USB_COM)
}

//export __vector_WDT
//go:interrupt
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export __vector_TIMER2_COMPA
//go:interrupt
func interruptTIMER2_COMPA() {
	callHandlers(IRQ_TIMER2_COMPA)
}

//export __vector_TIMER2_COMPB
//go:interrupt
func interruptTIMER2_COMPB() {
	callHandlers(IRQ_TIMER2_COMPB)
}

//export __vector_TIMER2_OVF
//go:interrupt
func interruptTIMER2_OVF() {
	callHandlers(IRQ_TIMER2_OVF)
}

//export __vector_TIMER1_CAPT
//go:interrupt
func interruptTIMER1_CAPT() {
	callHandlers(IRQ_TIMER1_CAPT)
}

//export __vector_TIMER1_COMPA
//go:interrupt
func interruptTIMER1_COMPA() {
	callHandlers(IRQ_TIMER1_COMPA)
}

//export __vector_TIMER1_COMPB
//go:interrupt
func interruptTIMER1_COMPB() {
	callHandlers(IRQ_TIMER1_COMPB)
}

//export __vector_TIMER1_COMPC
//go:interrupt
func interruptTIMER1_COMPC() {
	callHandlers(IRQ_TIMER1_COMPC)
}

//export __vector_TIMER1_OVF
//go:interrupt
func interruptTIMER1_OVF() {
	callHandlers(IRQ_TIMER1_OVF)
}

//export __vector_TIMER0_COMPA
//go:interrupt
func interruptTIMER0_COMPA() {
	callHandlers(IRQ_TIMER0_COMPA)
}

//export __vector_TIMER0_COMPB
//go:interrupt
func interruptTIMER0_COMPB() {
	callHandlers(IRQ_TIMER0_COMPB)
}

//export __vector_TIMER0_OVF
//go:interrupt
func interruptTIMER0_OVF() {
	callHandlers(IRQ_TIMER0_OVF)
}

//export __vector_SPI_STC
//go:interrupt
func interruptSPI_STC() {
	callHandlers(IRQ_SPI_STC)
}

//export __vector_USART1_RX
//go:interrupt
func interruptUSART1_RX() {
	callHandlers(IRQ_USART1_RX)
}

//export __vector_USART1_UDRE
//go:interrupt
func interruptUSART1_UDRE() {
	callHandlers(IRQ_USART1_UDRE)
}

//export __vector_USART1_TX
//go:interrupt
func interruptUSART1_TX() {
	callHandlers(IRQ_USART1_TX)
}

//export __vector_ANALOG_COMP
//go:interrupt
func interruptANALOG_COMP() {
	callHandlers(IRQ_ANALOG_COMP)
}

//export __vector_ADC
//go:interrupt
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export __vector_EE_READY
//go:interrupt
func interruptEE_READY() {
	callHandlers(IRQ_EE_READY)
}

//export __vector_TIMER3_CAPT
//go:interrupt
func interruptTIMER3_CAPT() {
	callHandlers(IRQ_TIMER3_CAPT)
}

//export __vector_TIMER3_COMPA
//go:interrupt
func interruptTIMER3_COMPA() {
	callHandlers(IRQ_TIMER3_COMPA)
}

//export __vector_TIMER3_COMPB
//go:interrupt
func interruptTIMER3_COMPB() {
	callHandlers(IRQ_TIMER3_COMPB)
}

//export __vector_TIMER3_COMPC
//go:interrupt
func interruptTIMER3_COMPC() {
	callHandlers(IRQ_TIMER3_COMPC)
}

//export __vector_TIMER3_OVF
//go:interrupt
func interruptTIMER3_OVF() {
	callHandlers(IRQ_TIMER3_OVF)
}

//export __vector_TWI
//go:interrupt
func interruptTWI() {
	callHandlers(IRQ_TWI)
}

//export __vector_SPM_READY
//go:interrupt
func interruptSPM_READY() {
	callHandlers(IRQ_SPM_READY)
}

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// I/O Port
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x22)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x21)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x20)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	PORTE = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	DDRE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))
	PINE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))
	PORTF = (*volatile.Register8)(unsafe.Pointer(uintptr(0x31)))
	DDRF  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x30)))
	PINF  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))

	// CPU Registers
	SREG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	MCUCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	XMCRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x74)))
	XMCRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x75)))
	OSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	CLKPR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SMCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	EIND   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5c)))
	RAMPZ  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5b)))
	GPIOR2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	GPIOR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	GPIOR0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	PRR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x65)))
	PRR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))

	// Two Wire Serial Interface
	TWAMR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbd)))
	TWBR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb8)))
	TWCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbc)))
	TWSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb9)))
	TWDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbb)))
	TWAR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xba)))

	// Serial Peripheral Interface
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))

	// USART
	UDR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xce)))
	UCSR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc8)))
	UCSR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc9)))
	UCSR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0xca)))
	UBRR1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcc)))
	UBRR1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcd)))

	// USB Device Registers
	UEINT   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf4)))
	UEBCHX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf3)))
	UEBCLX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf2)))
	UEDATX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf1)))
	UEIENX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf0)))
	UESTA1X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xef)))
	UESTA0X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xee)))
	UECFG1X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xed)))
	UECFG0X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xec)))
	UECONX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xeb)))
	UERST   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xea)))
	UENUM   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe9)))
	UEINTX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe8)))
	UDMFN   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe6)))
	UDFNUML = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe4)))
	UDFNUMH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe5)))
	UDADDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe3)))
	UDIEN   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe2)))
	UDINT   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe1)))
	UDCON   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe0)))

	// USB Controller
	OTGINT  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdf)))
	OTGIEN  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xde)))
	OTGCON  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdd)))
	OTGTCON = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf9)))
	USBINT  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xda)))
	USBSTA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd9)))
	USBCON  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd8)))
	UHWCON  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd7)))

	// USB Host Registers
	UPERRX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf5)))
	UPINT   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf8)))
	UPBCHX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf7)))
	UPBCLX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf6)))
	UPDATX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xaf)))
	UPIENX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xae)))
	UPCFG2X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xad)))
	UPSTAX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xac)))
	UPCFG1X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xab)))
	UPCFG0X = (*volatile.Register8)(unsafe.Pointer(uintptr(0xaa)))
	UPCONX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa9)))
	UPRST   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa8)))
	UPNUM   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa7)))
	UPINTX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa6)))
	UPINRQX = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa5)))
	UHFLEN  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa4)))
	UHFNUML = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa2)))
	UHFNUMH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa3)))
	UHADDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa1)))
	UHIEN   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa0)))
	UHINT   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9f)))
	UHCON   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9e)))

	// Bootloader
	SPMCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))

	// Timer/Counter, 8-bit
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	GTCCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))

	// Timer/Counter, 8-bit Async
	TIMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x70)))
	TIFR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x37)))
	TCCR2A = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb0)))
	TCCR2B = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb1)))
	TCNT2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb2)))
	OCR2B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb4)))
	OCR2A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb3)))
	ASSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb6)))

	// Timer/Counter, 16-bit
	TCCR3A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x90)))
	TCCR3B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x91)))
	TCCR3C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x92)))
	TCNT3L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x94)))
	TCNT3H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x95)))
	OCR3AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x98)))
	OCR3AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x99)))
	OCR3BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9a)))
	OCR3BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9b)))
	OCR3CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9c)))
	OCR3CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x9d)))
	ICR3L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x96)))
	ICR3H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x97)))
	TIMSK3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x71)))
	TIFR3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x38)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	OCR1CL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8c)))
	OCR1CH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8d)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))

	// JTAG Interface
	OCDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x51)))

	// External Interrupts
	EICRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EICRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6a)))
	EIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))
	PCIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	PCICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))

	// Analog-to-Digital Converter
	ADMUX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	ADCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))
	ADCL   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	ADCH   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	ADCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7b)))
	DIDR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))

	// Analog Comparator
	ACSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))
	DIDR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))

	// Phase Locked Loop
	PLLCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x49)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_BODLEVEL0    = 0x1 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL1    = 0x2 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL2    = 0x4 // Brown-out Detector trigger level
	EXTENDED_BODLEVEL_Msk = 0x7 // Brown-out Detector trigger level
	EXTENDED_HWBE         = 0x8 // Hardware Boot Enable
	EXTENDED_HWBE_Msk     = 0x8 // Hardware Boot Enable

	// HIGH
	HIGH_OCDEN       = 0x80 // On-Chip Debug Enabled
	HIGH_OCDEN_Msk   = 0x80 // On-Chip Debug Enabled
	HIGH_JTAGEN      = 0x40 // JTAG Interface Enabled
	HIGH_JTAGEN_Msk  = 0x40 // JTAG Interface Enabled
	HIGH_SPIEN       = 0x20 // Serial program downloading (SPI) enabled
	HIGH_SPIEN_Msk   = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON       = 0x10 // Watchdog timer always on
	HIGH_WDTON_Msk   = 0x10 // Watchdog timer always on
	HIGH_EESAVE      = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_EESAVE_Msk  = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BOOTSZ0     = 0x2  // Select Boot Size
	HIGH_BOOTSZ1     = 0x4  // Select Boot Size
	HIGH_BOOTSZ_Msk  = 0x6  // Select Boot Size
	HIGH_BOOTRST     = 0x1  // Boot Reset vector Enabled
	HIGH_BOOTRST_Msk = 0x1  // Boot Reset vector Enabled

	// LOW
	LOW_CKDIV8        = 0x80 // Divide clock by 8 internally
	LOW_CKDIV8_Msk    = 0x80 // Divide clock by 8 internally
	LOW_CKOUT         = 0x40 // Clock output on PORTC7
	LOW_CKOUT_Msk     = 0x40 // Clock output on PORTC7
	LOW_SUT_CKSEL0    = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1    = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2    = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3    = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4    = 0x10 // Select Clock Source
	LOW_SUT_CKSEL5    = 0x20 // Select Clock Source
	LOW_SUT_CKSEL_Msk = 0x3f // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0      = 0x1  // Memory Lock
	LOCKBIT_LB1      = 0x2  // Memory Lock
	LOCKBIT_LB_Msk   = 0x3  // Memory Lock
	LOCKBIT_BLB00    = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01    = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB0_Msk = 0xc  // Boot Loader Protection Mode
	LOCKBIT_BLB10    = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11    = 0x20 // Boot Loader Protection Mode
	LOCKBIT_BLB1_Msk = 0x30 // Boot Loader Protection Mode
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control Register
	WDTCSR_WDIF     = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIF_Msk = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIE     = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDIE_Msk = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDP0     = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1     = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2     = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3     = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDP_Msk  = 0x27 // Watchdog Timer Prescaler Bits
	WDTCSR_WDCE     = 0x10 // Watchdog Change Enable
	WDTCSR_WDCE_Msk = 0x10 // Watchdog Change Enable
	WDTCSR_WDE      = 0x8  // Watch Dog Enable
	WDTCSR_WDE_Msk  = 0x8  // Watch Dog Enable
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// MCUCR: MCU Control Register
	MCUCR_JTD       = 0x80 // JTAG Interface Disable
	MCUCR_JTD_Msk   = 0x80 // JTAG Interface Disable
	MCUCR_PUD       = 0x10 // Pull-up disable
	MCUCR_PUD_Msk   = 0x10 // Pull-up disable
	MCUCR_IVSEL     = 0x2  // Interrupt Vector Select
	MCUCR_IVSEL_Msk = 0x2  // Interrupt Vector Select
	MCUCR_IVCE      = 0x1  // Interrupt Vector Change Enable
	MCUCR_IVCE_Msk  = 0x1  // Interrupt Vector Change Enable

	// MCUSR: MCU Status Register
	MCUSR_JTRF      = 0x10 // JTAG Reset Flag
	MCUSR_JTRF_Msk  = 0x10 // JTAG Reset Flag
	MCUSR_WDRF      = 0x8  // Watchdog Reset Flag
	MCUSR_WDRF_Msk  = 0x8  // Watchdog Reset Flag
	MCUSR_BORF      = 0x4  // Brown-out Reset Flag
	MCUSR_BORF_Msk  = 0x4  // Brown-out Reset Flag
	MCUSR_EXTRF     = 0x2  // External Reset Flag
	MCUSR_EXTRF_Msk = 0x2  // External Reset Flag
	MCUSR_PORF      = 0x1  // Power-on reset flag
	MCUSR_PORF_Msk  = 0x1  // Power-on reset flag

	// XMCRA: External Memory Control Register A
	XMCRA_SRE      = 0x80 // External SRAM Enable
	XMCRA_SRE_Msk  = 0x80 // External SRAM Enable
	XMCRA_SRL0     = 0x10 // Wait state page limit
	XMCRA_SRL1     = 0x20 // Wait state page limit
	XMCRA_SRL2     = 0x40 // Wait state page limit
	XMCRA_SRL_Msk  = 0x70 // Wait state page limit
	XMCRA_SRW10    = 0x4  // Wait state select bit upper page
	XMCRA_SRW11    = 0x8  // Wait state select bit upper page
	XMCRA_SRW1_Msk = 0xc  // Wait state select bit upper page
	XMCRA_SRW00    = 0x1  // Wait state select bit lower page
	XMCRA_SRW01    = 0x2  // Wait state select bit lower page
	XMCRA_SRW0_Msk = 0x3  // Wait state select bit lower page

	// XMCRB: External Memory Control Register B
	XMCRB_XMBK     = 0x80 // External Memory Bus Keeper Enable
	XMCRB_XMBK_Msk = 0x80 // External Memory Bus Keeper Enable
	XMCRB_XMM0     = 0x1  // External Memory High Mask
	XMCRB_XMM1     = 0x2  // External Memory High Mask
	XMCRB_XMM2     = 0x4  // External Memory High Mask
	XMCRB_XMM_Msk  = 0x7  // External Memory High Mask

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_OSCCAL0    = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1    = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2    = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3    = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4    = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5    = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6    = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7    = 0x80 // Oscillator Calibration
	OSCCAL_OSCCAL_Msk = 0xff // Oscillator Calibration

	// CLKPR
	CLKPR_CLKPCE     = 0x80
	CLKPR_CLKPCE_Msk = 0x80
	CLKPR_CLKPS0     = 0x1
	CLKPR_CLKPS1     = 0x2
	CLKPR_CLKPS2     = 0x4
	CLKPR_CLKPS3     = 0x8
	CLKPR_CLKPS_Msk  = 0xf

	// SMCR: Sleep Mode Control Register
	SMCR_SM0    = 0x2 // Sleep Mode Select bits
	SMCR_SM1    = 0x4 // Sleep Mode Select bits
	SMCR_SM2    = 0x8 // Sleep Mode Select bits
	SMCR_SM_Msk = 0xe // Sleep Mode Select bits
	SMCR_SE     = 0x1 // Sleep Enable
	SMCR_SE_Msk = 0x1 // Sleep Enable

	// GPIOR2: General Purpose IO Register 2
	GPIOR2_GPIOR0    = 0x1  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR1    = 0x2  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR2    = 0x4  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR3    = 0x8  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR4    = 0x10 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR5    = 0x20 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR6    = 0x40 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR7    = 0x80 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR_Msk = 0xff // General Purpose IO Register 2 bis

	// GPIOR1: General Purpose IO Register 1
	GPIOR1_GPIOR0    = 0x1  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR1    = 0x2  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR2    = 0x4  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR3    = 0x8  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR4    = 0x10 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR5    = 0x20 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR6    = 0x40 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR7    = 0x80 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR_Msk = 0xff // General Purpose IO Register 1 bis

	// GPIOR0: General Purpose IO Register 0
	GPIOR0_GPIOR07     = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR07_Msk = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR06     = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR06_Msk = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR05     = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR05_Msk = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR04     = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR04_Msk = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR03     = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR03_Msk = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR02     = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR02_Msk = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR01     = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR01_Msk = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR00     = 0x1  // General Purpose IO Register 0 bit 0
	GPIOR0_GPIOR00_Msk = 0x1  // General Purpose IO Register 0 bit 0

	// PRR1: Power Reduction Register1
	PRR1_PRUSB        = 0x80 // Power Reduction USB
	PRR1_PRUSB_Msk    = 0x80 // Power Reduction USB
	PRR1_PRTIM3       = 0x8  // Power Reduction Timer/Counter3
	PRR1_PRTIM3_Msk   = 0x8  // Power Reduction Timer/Counter3
	PRR1_PRUSART1     = 0x1  // Power Reduction USART1
	PRR1_PRUSART1_Msk = 0x1  // Power Reduction USART1

	// PRR0: Power Reduction Register0
	PRR0_PRTWI      = 0x80 // Power Reduction TWI
	PRR0_PRTWI_Msk  = 0x80 // Power Reduction TWI
	PRR0_PRTIM2     = 0x40 // Power Reduction Timer/Counter2
	PRR0_PRTIM2_Msk = 0x40 // Power Reduction Timer/Counter2
	PRR0_PRTIM0     = 0x20 // Power Reduction Timer/Counter0
	PRR0_PRTIM0_Msk = 0x20 // Power Reduction Timer/Counter0
	PRR0_PRTIM1     = 0x8  // Power Reduction Timer/Counter1
	PRR0_PRTIM1_Msk = 0x8  // Power Reduction Timer/Counter1
	PRR0_PRSPI      = 0x4  // Power Reduction Serial Peripheral Interface
	PRR0_PRSPI_Msk  = 0x4  // Power Reduction Serial Peripheral Interface
	PRR0_PRADC      = 0x1  // Power Reduction ADC
	PRR0_PRADC_Msk  = 0x1  // Power Reduction ADC
)

// Bitfields for TWI: Two Wire Serial Interface
const (
	// TWAMR: TWI (Slave) Address Mask Register
	TWAMR_TWAM0    = 0x2
	TWAMR_TWAM1    = 0x4
	TWAMR_TWAM2    = 0x8
	TWAMR_TWAM3    = 0x10
	TWAMR_TWAM4    = 0x20
	TWAMR_TWAM5    = 0x40
	TWAMR_TWAM6    = 0x80
	TWAMR_TWAM_Msk = 0xfe

	// TWCR: TWI Control Register
	TWCR_TWINT     = 0x80 // TWI Interrupt Flag
	TWCR_TWINT_Msk = 0x80 // TWI Interrupt Flag
	TWCR_TWEA      = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWEA_Msk  = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWSTA     = 0x20 // TWI Start Condition Bit
	TWCR_TWSTA_Msk = 0x20 // TWI Start Condition Bit
	TWCR_TWSTO     = 0x10 // TWI Stop Condition Bit
	TWCR_TWSTO_Msk = 0x10 // TWI Stop Condition Bit
	TWCR_TWWC      = 0x8  // TWI Write Collition Flag
	TWCR_TWWC_Msk  = 0x8  // TWI Write Collition Flag
	TWCR_TWEN      = 0x4  // TWI Enable Bit
	TWCR_TWEN_Msk  = 0x4  // TWI Enable Bit
	TWCR_TWIE      = 0x1  // TWI Interrupt Enable
	TWCR_TWIE_Msk  = 0x1  // TWI Interrupt Enable

	// TWSR: TWI Status Register
	TWSR_TWS0     = 0x8  // TWI Status
	TWSR_TWS1     = 0x10 // TWI Status
	TWSR_TWS2     = 0x20 // TWI Status
	TWSR_TWS3     = 0x40 // TWI Status
	TWSR_TWS4     = 0x80 // TWI Status
	TWSR_TWS_Msk  = 0xf8 // TWI Status
	TWSR_TWPS0    = 0x1  // TWI Prescaler
	TWSR_TWPS1    = 0x2  // TWI Prescaler
	TWSR_TWPS_Msk = 0x3  // TWI Prescaler

	// TWAR: TWI (Slave) Address register
	TWAR_TWA0      = 0x2  // TWI (Slave) Address register Bits
	TWAR_TWA1      = 0x4  // TWI (Slave) Address register Bits
	TWAR_TWA2      = 0x8  // TWI (Slave) Address register Bits
	TWAR_TWA3      = 0x10 // TWI (Slave) Address register Bits
	TWAR_TWA4      = 0x20 // TWI (Slave) Address register Bits
	TWAR_TWA5      = 0x40 // TWI (Slave) Address register Bits
	TWAR_TWA6      = 0x80 // TWI (Slave) Address register Bits
	TWAR_TWA_Msk   = 0xfe // TWI (Slave) Address register Bits
	TWAR_TWGCE     = 0x1  // TWI General Call Recognition Enable Bit
	TWAR_TWGCE_Msk = 0x1  // TWI General Call Recognition Enable Bit
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPCR: SPI Control Register
	SPCR_SPIE     = 0x80 // SPI Interrupt Enable
	SPCR_SPIE_Msk = 0x80 // SPI Interrupt Enable
	SPCR_SPE      = 0x40 // SPI Enable
	SPCR_SPE_Msk  = 0x40 // SPI Enable
	SPCR_DORD     = 0x20 // Data Order
	SPCR_DORD_Msk = 0x20 // Data Order
	SPCR_MSTR     = 0x10 // Master/Slave Select
	SPCR_MSTR_Msk = 0x10 // Master/Slave Select
	SPCR_CPOL     = 0x8  // Clock polarity
	SPCR_CPOL_Msk = 0x8  // Clock polarity
	SPCR_CPHA     = 0x4  // Clock Phase
	SPCR_CPHA_Msk = 0x4  // Clock Phase
	SPCR_SPR0     = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1     = 0x2  // SPI Clock Rate Selects
	SPCR_SPR_Msk  = 0x3  // SPI Clock Rate Selects

	// SPSR: SPI Status Register
	SPSR_SPIF      = 0x80 // SPI Interrupt Flag
	SPSR_SPIF_Msk  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL      = 0x40 // Write Collision Flag
	SPSR_WCOL_Msk  = 0x40 // Write Collision Flag
	SPSR_SPI2X     = 0x1  // Double SPI Speed Bit
	SPSR_SPI2X_Msk = 0x1  // Double SPI Speed Bit
)

// Bitfields for USART: USART
const (
	// UCSR1A: USART Control and Status Register A
	UCSR1A_RXC1      = 0x80 // USART Receive Complete
	UCSR1A_RXC1_Msk  = 0x80 // USART Receive Complete
	UCSR1A_TXC1      = 0x40 // USART Transmitt Complete
	UCSR1A_TXC1_Msk  = 0x40 // USART Transmitt Complete
	UCSR1A_UDRE1     = 0x20 // USART Data Register Empty
	UCSR1A_UDRE1_Msk = 0x20 // USART Data Register Empty
	UCSR1A_FE1       = 0x10 // Framing Error
	UCSR1A_FE1_Msk   = 0x10 // Framing Error
	UCSR1A_DOR1      = 0x8  // Data overRun
	UCSR1A_DOR1_Msk  = 0x8  // Data overRun
	UCSR1A_UPE1      = 0x4  // Parity Error
	UCSR1A_UPE1_Msk  = 0x4  // Parity Error
	UCSR1A_U2X1      = 0x2  // Double the USART transmission speed
	UCSR1A_U2X1_Msk  = 0x2  // Double the USART transmission speed
	UCSR1A_MPCM1     = 0x1  // Multi-processor Communication Mode
	UCSR1A_MPCM1_Msk = 0x1  // Multi-processor Communication Mode

	// UCSR1B: USART Control and Status Register B
	UCSR1B_RXCIE1     = 0x80 // RX Complete Interrupt Enable
	UCSR1B_RXCIE1_Msk = 0x80 // RX Complete Interrupt Enable
	UCSR1B_TXCIE1     = 0x40 // TX Complete Interrupt Enable
	UCSR1B_TXCIE1_Msk = 0x40 // TX Complete Interrupt Enable
	UCSR1B_UDRIE1     = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_UDRIE1_Msk = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_RXEN1      = 0x10 // Receiver Enable
	UCSR1B_RXEN1_Msk  = 0x10 // Receiver Enable
	UCSR1B_TXEN1      = 0x8  // Transmitter Enable
	UCSR1B_TXEN1_Msk  = 0x8  // Transmitter Enable
	UCSR1B_UCSZ12     = 0x4  // Character Size
	UCSR1B_UCSZ12_Msk = 0x4  // Character Size
	UCSR1B_RXB81      = 0x2  // Receive Data Bit 8
	UCSR1B_RXB81_Msk  = 0x2  // Receive Data Bit 8
	UCSR1B_TXB81      = 0x1  // Transmit Data Bit 8
	UCSR1B_TXB81_Msk  = 0x1  // Transmit Data Bit 8

	// UCSR1C: USART Control and Status Register C
	UCSR1C_UMSEL10    = 0x40 // USART Mode Select
	UCSR1C_UMSEL11    = 0x80 // USART Mode Select
	UCSR1C_UMSEL1_Msk = 0xc0 // USART Mode Select
	UCSR1C_UPM10      = 0x10 // Parity Mode Bits
	UCSR1C_UPM11      = 0x20 // Parity Mode Bits
	UCSR1C_UPM1_Msk   = 0x30 // Parity Mode Bits
	UCSR1C_USBS1      = 0x8  // Stop Bit Select
	UCSR1C_USBS1_Msk  = 0x8  // Stop Bit Select
	UCSR1C_UCSZ10     = 0x2  // Character Size
	UCSR1C_UCSZ11     = 0x4  // Character Size
	UCSR1C_UCSZ1_Msk  = 0x6  // Character Size
	UCSR1C_UCPOL1     = 0x1  // Clock Polarity
	UCSR1C_UCPOL1_Msk = 0x1  // Clock Polarity
)

// Bitfields for USB_DEVICE: USB Device Registers
const (
	// UEIENX
	UEIENX_FLERRE       = 0x80
	UEIENX_FLERRE_Msk   = 0x80
	UEIENX_NAKINE       = 0x40
	UEIENX_NAKINE_Msk   = 0x40
	UEIENX_NAKOUTE      = 0x10
	UEIENX_NAKOUTE_Msk  = 0x10
	UEIENX_RXSTPE       = 0x8
	UEIENX_RXSTPE_Msk   = 0x8
	UEIENX_RXOUTE       = 0x4
	UEIENX_RXOUTE_Msk   = 0x4
	UEIENX_STALLEDE     = 0x2
	UEIENX_STALLEDE_Msk = 0x2
	UEIENX_TXINE        = 0x1
	UEIENX_TXINE_Msk    = 0x1

	// UESTA1X
	UESTA1X_CTRLDIR     = 0x4
	UESTA1X_CTRLDIR_Msk = 0x4
	UESTA1X_CURRBK0     = 0x1
	UESTA1X_CURRBK1     = 0x2
	UESTA1X_CURRBK_Msk  = 0x3

	// UESTA0X
	UESTA0X_CFGOK       = 0x80
	UESTA0X_CFGOK_Msk   = 0x80
	UESTA0X_OVERFI      = 0x40
	UESTA0X_OVERFI_Msk  = 0x40
	UESTA0X_UNDERFI     = 0x20
	UESTA0X_UNDERFI_Msk = 0x20
	UESTA0X_DTSEQ0      = 0x4
	UESTA0X_DTSEQ1      = 0x8
	UESTA0X_DTSEQ_Msk   = 0xc
	UESTA0X_NBUSYBK0    = 0x1
	UESTA0X_NBUSYBK1    = 0x2
	UESTA0X_NBUSYBK_Msk = 0x3

	// UECFG1X
	UECFG1X_EPSIZE0    = 0x10
	UECFG1X_EPSIZE1    = 0x20
	UECFG1X_EPSIZE2    = 0x40
	UECFG1X_EPSIZE_Msk = 0x70
	UECFG1X_EPBK0      = 0x4
	UECFG1X_EPBK1      = 0x8
	UECFG1X_EPBK_Msk   = 0xc
	UECFG1X_ALLOC      = 0x2
	UECFG1X_ALLOC_Msk  = 0x2

	// UECFG0X
	UECFG0X_EPTYPE0    = 0x40
	UECFG0X_EPTYPE1    = 0x80
	UECFG0X_EPTYPE_Msk = 0xc0
	UECFG0X_EPDIR      = 0x1
	UECFG0X_EPDIR_Msk  = 0x1

	// UECONX
	UECONX_STALLRQ      = 0x20
	UECONX_STALLRQ_Msk  = 0x20
	UECONX_STALLRQC     = 0x10
	UECONX_STALLRQC_Msk = 0x10
	UECONX_RSTDT        = 0x8
	UECONX_RSTDT_Msk    = 0x8
	UECONX_EPEN         = 0x1
	UECONX_EPEN_Msk     = 0x1

	// UERST
	UERST_EPRST0    = 0x1
	UERST_EPRST1    = 0x2
	UERST_EPRST2    = 0x4
	UERST_EPRST3    = 0x8
	UERST_EPRST4    = 0x10
	UERST_EPRST5    = 0x20
	UERST_EPRST6    = 0x40
	UERST_EPRST_Msk = 0x7f

	// UEINTX
	UEINTX_FIFOCON      = 0x80
	UEINTX_FIFOCON_Msk  = 0x80
	UEINTX_NAKINI       = 0x40
	UEINTX_NAKINI_Msk   = 0x40
	UEINTX_RWAL         = 0x20
	UEINTX_RWAL_Msk     = 0x20
	UEINTX_NAKOUTI      = 0x10
	UEINTX_NAKOUTI_Msk  = 0x10
	UEINTX_RXSTPI       = 0x8
	UEINTX_RXSTPI_Msk   = 0x8
	UEINTX_RXOUTI       = 0x4
	UEINTX_RXOUTI_Msk   = 0x4
	UEINTX_STALLEDI     = 0x2
	UEINTX_STALLEDI_Msk = 0x2
	UEINTX_TXINI        = 0x1
	UEINTX_TXINI_Msk    = 0x1

	// UDMFN
	UDMFN_FNCERR     = 0x10
	UDMFN_FNCERR_Msk = 0x10

	// UDADDR
	UDADDR_ADDEN     = 0x80
	UDADDR_ADDEN_Msk = 0x80
	UDADDR_UADD0     = 0x1
	UDADDR_UADD1     = 0x2
	UDADDR_UADD2     = 0x4
	UDADDR_UADD3     = 0x8
	UDADDR_UADD4     = 0x10
	UDADDR_UADD5     = 0x20
	UDADDR_UADD6     = 0x40
	UDADDR_UADD_Msk  = 0x7f

	// UDIEN
	UDIEN_UPRSME      = 0x40
	UDIEN_UPRSME_Msk  = 0x40
	UDIEN_EORSME      = 0x20
	UDIEN_EORSME_Msk  = 0x20
	UDIEN_WAKEUPE     = 0x10
	UDIEN_WAKEUPE_Msk = 0x10
	UDIEN_EORSTE      = 0x8
	UDIEN_EORSTE_Msk  = 0x8
	UDIEN_SOFE        = 0x4
	UDIEN_SOFE_Msk    = 0x4
	UDIEN_SUSPE       = 0x1
	UDIEN_SUSPE_Msk   = 0x1

	// UDINT
	UDINT_UPRSMI      = 0x40
	UDINT_UPRSMI_Msk  = 0x40
	UDINT_EORSMI      = 0x20
	UDINT_EORSMI_Msk  = 0x20
	UDINT_WAKEUPI     = 0x10
	UDINT_WAKEUPI_Msk = 0x10
	UDINT_EORSTI      = 0x8
	UDINT_EORSTI_Msk  = 0x8
	UDINT_SOFI        = 0x4
	UDINT_SOFI_Msk    = 0x4
	UDINT_SUSPI       = 0x1
	UDINT_SUSPI_Msk   = 0x1

	// UDCON
	UDCON_LSM        = 0x4
	UDCON_LSM_Msk    = 0x4
	UDCON_RMWKUP     = 0x2
	UDCON_RMWKUP_Msk = 0x2
	UDCON_DETACH     = 0x1
	UDCON_DETACH_Msk = 0x1
)

// Bitfields for USB_GLOBAL: USB Controller
const (
	// OTGINT
	OTGINT_STOI        = 0x20
	OTGINT_STOI_Msk    = 0x20
	OTGINT_HNPERRI     = 0x10
	OTGINT_HNPERRI_Msk = 0x10
	OTGINT_ROLEEXI     = 0x8
	OTGINT_ROLEEXI_Msk = 0x8
	OTGINT_BCERRI      = 0x4
	OTGINT_BCERRI_Msk  = 0x4
	OTGINT_VBERRI      = 0x2
	OTGINT_VBERRI_Msk  = 0x2
	OTGINT_SRPI        = 0x1
	OTGINT_SRPI_Msk    = 0x1

	// OTGIEN
	OTGIEN_STOE        = 0x20
	OTGIEN_STOE_Msk    = 0x20
	OTGIEN_HNPERRE     = 0x10
	OTGIEN_HNPERRE_Msk = 0x10
	OTGIEN_ROLEEXE     = 0x8
	OTGIEN_ROLEEXE_Msk = 0x8
	OTGIEN_BCERRE      = 0x4
	OTGIEN_BCERRE_Msk  = 0x4
	OTGIEN_VBERRE      = 0x2
	OTGIEN_VBERRE_Msk  = 0x2
	OTGIEN_SRPE        = 0x1
	OTGIEN_SRPE_Msk    = 0x1

	// OTGCON
	OTGCON_HNPREQ      = 0x20
	OTGCON_HNPREQ_Msk  = 0x20
	OTGCON_SRPREQ      = 0x10
	OTGCON_SRPREQ_Msk  = 0x10
	OTGCON_SRPSEL      = 0x8
	OTGCON_SRPSEL_Msk  = 0x8
	OTGCON_VBUSHWC     = 0x4
	OTGCON_VBUSHWC_Msk = 0x4
	OTGCON_VBUSREQ     = 0x2
	OTGCON_VBUSREQ_Msk = 0x2
	OTGCON_VBUSRQC     = 0x1
	OTGCON_VBUSRQC_Msk = 0x1

	// OTGTCON
	OTGTCON_OTGTCON_7     = 0x80
	OTGTCON_OTGTCON_7_Msk = 0x80
	OTGTCON_PAGE0         = 0x20
	OTGTCON_PAGE1         = 0x40
	OTGTCON_PAGE_Msk      = 0x60
	OTGTCON_VALUE_20      = 0x1
	OTGTCON_VALUE_21      = 0x2
	OTGTCON_VALUE_22      = 0x4
	OTGTCON_VALUE_2_Msk   = 0x7

	// USBINT
	USBINT_IDTI       = 0x2
	USBINT_IDTI_Msk   = 0x2
	USBINT_VBUSTI     = 0x1
	USBINT_VBUSTI_Msk = 0x1

	// USBSTA
	USBSTA_SPEED     = 0x8
	USBSTA_SPEED_Msk = 0x8
	USBSTA_ID        = 0x2
	USBSTA_ID_Msk    = 0x2
	USBSTA_VBUS      = 0x1
	USBSTA_VBUS_Msk  = 0x1

	// USBCON: USB General Control Register
	USBCON_USBE        = 0x80
	USBCON_USBE_Msk    = 0x80
	USBCON_HOST        = 0x40
	USBCON_HOST_Msk    = 0x40
	USBCON_FRZCLK      = 0x20
	USBCON_FRZCLK_Msk  = 0x20
	USBCON_OTGPADE     = 0x10
	USBCON_OTGPADE_Msk = 0x10
	USBCON_IDTE        = 0x2
	USBCON_IDTE_Msk    = 0x2
	USBCON_VBUSTE      = 0x1
	USBCON_VBUSTE_Msk  = 0x1

	// UHWCON: USB Hardware Configuration Register
	UHWCON_UIMOD      = 0x80
	UHWCON_UIMOD_Msk  = 0x80
	UHWCON_UIDE       = 0x40
	UHWCON_UIDE_Msk   = 0x40
	UHWCON_UVCONE     = 0x10
	UHWCON_UVCONE_Msk = 0x10
	UHWCON_UVREGE     = 0x1
	UHWCON_UVREGE_Msk = 0x1
)

// Bitfields for USB_HOST: USB Host Registers
const (
	// UPERRX
	UPERRX_COUNTER0    = 0x20
	UPERRX_COUNTER1    = 0x40
	UPERRX_COUNTER_Msk = 0x60
	UPERRX_CRC16       = 0x10
	UPERRX_CRC16_Msk   = 0x10
	UPERRX_TIMEOUT     = 0x8
	UPERRX_TIMEOUT_Msk = 0x8
	UPERRX_PID         = 0x4
	UPERRX_PID_Msk     = 0x4
	UPERRX_DATAPID     = 0x2
	UPERRX_DATAPID_Msk = 0x2
	UPERRX_DATATGL     = 0x1
	UPERRX_DATATGL_Msk = 0x1

	// UPIENX
	UPIENX_FLERRE       = 0x80
	UPIENX_FLERRE_Msk   = 0x80
	UPIENX_NAKEDE       = 0x40
	UPIENX_NAKEDE_Msk   = 0x40
	UPIENX_PERRE        = 0x10
	UPIENX_PERRE_Msk    = 0x10
	UPIENX_TXSTPE       = 0x8
	UPIENX_TXSTPE_Msk   = 0x8
	UPIENX_TXOUTE       = 0x4
	UPIENX_TXOUTE_Msk   = 0x4
	UPIENX_RXSTALLE     = 0x2
	UPIENX_RXSTALLE_Msk = 0x2
	UPIENX_RXINE        = 0x1
	UPIENX_RXINE_Msk    = 0x1

	// UPSTAX
	UPSTAX_CFGOK       = 0x80
	UPSTAX_CFGOK_Msk   = 0x80
	UPSTAX_OVERFI      = 0x40
	UPSTAX_OVERFI_Msk  = 0x40
	UPSTAX_UNDERFI     = 0x20
	UPSTAX_UNDERFI_Msk = 0x20
	UPSTAX_DTSEQ0      = 0x4
	UPSTAX_DTSEQ1      = 0x8
	UPSTAX_DTSEQ_Msk   = 0xc
	UPSTAX_NBUSYK0     = 0x1
	UPSTAX_NBUSYK1     = 0x2
	UPSTAX_NBUSYK_Msk  = 0x3

	// UPCFG1X
	UPCFG1X_PSIZE0    = 0x10
	UPCFG1X_PSIZE1    = 0x20
	UPCFG1X_PSIZE2    = 0x40
	UPCFG1X_PSIZE_Msk = 0x70
	UPCFG1X_PBK0      = 0x4
	UPCFG1X_PBK1      = 0x8
	UPCFG1X_PBK_Msk   = 0xc
	UPCFG1X_ALLOC     = 0x2
	UPCFG1X_ALLOC_Msk = 0x2

	// UPCFG0X
	UPCFG0X_PTYPE0     = 0x40
	UPCFG0X_PTYPE1     = 0x80
	UPCFG0X_PTYPE_Msk  = 0xc0
	UPCFG0X_PTOKEN0    = 0x10
	UPCFG0X_PTOKEN1    = 0x20
	UPCFG0X_PTOKEN_Msk = 0x30
	UPCFG0X_PEPNUM0    = 0x1
	UPCFG0X_PEPNUM1    = 0x2
	UPCFG0X_PEPNUM2    = 0x4
	UPCFG0X_PEPNUM3    = 0x8
	UPCFG0X_PEPNUM_Msk = 0xf

	// UPCONX
	UPCONX_PFREEZE     = 0x40
	UPCONX_PFREEZE_Msk = 0x40
	UPCONX_INMODE      = 0x20
	UPCONX_INMODE_Msk  = 0x20
	UPCONX_RSTDT       = 0x8
	UPCONX_RSTDT_Msk   = 0x8
	UPCONX_PEN         = 0x1
	UPCONX_PEN_Msk     = 0x1

	// UPRST
	UPRST_PRST0    = 0x1
	UPRST_PRST1    = 0x2
	UPRST_PRST2    = 0x4
	UPRST_PRST3    = 0x8
	UPRST_PRST4    = 0x10
	UPRST_PRST5    = 0x20
	UPRST_PRST6    = 0x40
	UPRST_PRST_Msk = 0x7f

	// UPINTX
	UPINTX_FIFOCON      = 0x80
	UPINTX_FIFOCON_Msk  = 0x80
	UPINTX_NAKEDI       = 0x40
	UPINTX_NAKEDI_Msk   = 0x40
	UPINTX_RWAL         = 0x20
	UPINTX_RWAL_Msk     = 0x20
	UPINTX_PERRI        = 0x10
	UPINTX_PERRI_Msk    = 0x10
	UPINTX_TXSTPI       = 0x8
	UPINTX_TXSTPI_Msk   = 0x8
	UPINTX_TXOUTI       = 0x4
	UPINTX_TXOUTI_Msk   = 0x4
	UPINTX_RXSTALLI     = 0x2
	UPINTX_RXSTALLI_Msk = 0x2
	UPINTX_RXINI        = 0x1
	UPINTX_RXINI_Msk    = 0x1

	// UHIEN
	UHIEN_HWUPE      = 0x40
	UHIEN_HWUPE_Msk  = 0x40
	UHIEN_HSOFE      = 0x20
	UHIEN_HSOFE_Msk  = 0x20
	UHIEN_RXRSME     = 0x10
	UHIEN_RXRSME_Msk = 0x10
	UHIEN_RSMEDE     = 0x8
	UHIEN_RSMEDE_Msk = 0x8
	UHIEN_RSTE       = 0x4
	UHIEN_RSTE_Msk   = 0x4
	UHIEN_DDISCE     = 0x2
	UHIEN_DDISCE_Msk = 0x2
	UHIEN_DCONNE     = 0x1
	UHIEN_DCONNE_Msk = 0x1

	// UHINT
	UHINT_UHUPI      = 0x40
	UHINT_UHUPI_Msk  = 0x40
	UHINT_HSOFI      = 0x20
	UHINT_HSOFI_Msk  = 0x20
	UHINT_RXRSMI     = 0x10
	UHINT_RXRSMI_Msk = 0x10
	UHINT_RSMEDI     = 0x8
	UHINT_RSMEDI_Msk = 0x8
	UHINT_RSTI       = 0x4
	UHINT_RSTI_Msk   = 0x4
	UHINT_DDISCI     = 0x2
	UHINT_DDISCI_Msk = 0x2
	UHINT_DCONNI     = 0x1
	UHINT_DCONNI_Msk = 0x1

	// UHCON
	UHCON_RESUME     = 0x4
	UHCON_RESUME_Msk = 0x4
	UHCON_RESET      = 0x2
	UHCON_RESET_Msk  = 0x2
	UHCON_SOFEN      = 0x1
	UHCON_SOFEN_Msk  = 0x1
)

// Bitfields for BOOT_LOAD: Bootloader
const (
	// SPMCSR: Store Program Memory Control Register
	SPMCSR_SPMIE      = 0x80 // SPM Interrupt Enable
	SPMCSR_SPMIE_Msk  = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB      = 0x40 // Read While Write Section Busy
	SPMCSR_RWWSB_Msk  = 0x40 // Read While Write Section Busy
	SPMCSR_SIGRD      = 0x20 // Signature Row Read
	SPMCSR_SIGRD_Msk  = 0x20 // Signature Row Read
	SPMCSR_RWWSRE     = 0x10 // Read While Write section read enable
	SPMCSR_RWWSRE_Msk = 0x10 // Read While Write section read enable
	SPMCSR_BLBSET     = 0x8  // Boot Lock Bit Set
	SPMCSR_BLBSET_Msk = 0x8  // Boot Lock Bit Set
	SPMCSR_PGWRT      = 0x4  // Page Write
	SPMCSR_PGWRT_Msk  = 0x4  // Page Write
	SPMCSR_PGERS      = 0x2  // Page Erase
	SPMCSR_PGERS_Msk  = 0x2  // Page Erase
	SPMCSR_SPMEN      = 0x1  // Store Program Memory Enable
	SPMCSR_SPMEN_Msk  = 0x1  // Store Program Memory Enable
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_EEPM0     = 0x10 // EEPROM Programming Mode Bits
	EECR_EEPM1     = 0x20 // EEPROM Programming Mode Bits
	EECR_EEPM_Msk  = 0x30 // EEPROM Programming Mode Bits
	EECR_EERIE     = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8  // EEPROM Ready Interrupt Enable
	EECR_EEMPE     = 0x4  // EEPROM Master Write Enable
	EECR_EEMPE_Msk = 0x4  // EEPROM Master Write Enable
	EECR_EEPE      = 0x2  // EEPROM Write Enable
	EECR_EEPE_Msk  = 0x2  // EEPROM Write Enable
	EECR_EERE      = 0x1  // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1  // EEPROM Read Enable
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TCCR0B: Timer/Counter Control Register B
	TCCR0B_FOC0A     = 0x80 // Force Output Compare A
	TCCR0B_FOC0A_Msk = 0x80 // Force Output Compare A
	TCCR0B_FOC0B     = 0x40 // Force Output Compare B
	TCCR0B_FOC0B_Msk = 0x40 // Force Output Compare B
	TCCR0B_WGM02     = 0x8
	TCCR0B_WGM02_Msk = 0x8
	TCCR0B_CS00      = 0x1 // Clock Select
	TCCR0B_CS01      = 0x2 // Clock Select
	TCCR0B_CS02      = 0x4 // Clock Select
	TCCR0B_CS0_Msk   = 0x7 // Clock Select

	// TCCR0A: Timer/Counter  Control Register A
	TCCR0A_COM0A0    = 0x40 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A1    = 0x80 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A_Msk = 0xc0 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0B0    = 0x10 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B1    = 0x20 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B_Msk = 0x30 // Compare Output Mode, Fast PWm
	TCCR0A_WGM00     = 0x1  // Waveform Generation Mode
	TCCR0A_WGM01     = 0x2  // Waveform Generation Mode
	TCCR0A_WGM0_Msk  = 0x3  // Waveform Generation Mode

	// TIMSK0: Timer/Counter0 Interrupt Mask Register
	TIMSK0_OCIE0B     = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0B_Msk = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0A     = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_OCIE0A_Msk = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_TOIE0      = 0x1 // Timer/Counter0 Overflow Interrupt Enable
	TIMSK0_TOIE0_Msk  = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag register
	TIFR0_OCF0B     = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0B_Msk = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0A     = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_OCF0A_Msk = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_TOV0      = 0x1 // Timer/Counter0 Overflow Flag
	TIFR0_TOV0_Msk  = 0x1 // Timer/Counter0 Overflow Flag

	// GTCCR: General Timer/Counter Control Register
	GTCCR_TSM         = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_TSM_Msk     = 0x80 // Timer/Counter Synchronization Mode
	GTCCR_PSRSYNC     = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	GTCCR_PSRSYNC_Msk = 0x1  // Prescaler Reset Timer/Counter1 and Timer/Counter0
	GTCCR_PSRASY      = 0x2  // Prescaler Reset Timer/Counter2
	GTCCR_PSRASY_Msk  = 0x2  // Prescaler Reset Timer/Counter2
)

// Bitfields for TC8_ASYNC: Timer/Counter, 8-bit Async
const (
	// TIMSK2: Timer/Counter Interrupt Mask register
	TIMSK2_OCIE2B     = 0x4 // Timer/Counter2 Output Compare Match B Interrupt Enable
	TIMSK2_OCIE2B_Msk = 0x4 // Timer/Counter2 Output Compare Match B Interrupt Enable
	TIMSK2_OCIE2A     = 0x2 // Timer/Counter2 Output Compare Match A Interrupt Enable
	TIMSK2_OCIE2A_Msk = 0x2 // Timer/Counter2 Output Compare Match A Interrupt Enable
	TIMSK2_TOIE2      = 0x1 // Timer/Counter2 Overflow Interrupt Enable
	TIMSK2_TOIE2_Msk  = 0x1 // Timer/Counter2 Overflow Interrupt Enable

	// TIFR2: Timer/Counter Interrupt Flag Register
	TIFR2_OCF2B     = 0x4 // Output Compare Flag 2B
	TIFR2_OCF2B_Msk = 0x4 // Output Compare Flag 2B
	TIFR2_OCF2A     = 0x2 // Output Compare Flag 2A
	TIFR2_OCF2A_Msk = 0x2 // Output Compare Flag 2A
	TIFR2_TOV2      = 0x1 // Timer/Counter2 Overflow Flag
	TIFR2_TOV2_Msk  = 0x1 // Timer/Counter2 Overflow Flag

	// TCCR2A: Timer/Counter2 Control Register A
	TCCR2A_COM2A0    = 0x40 // Compare Output Mode bits
	TCCR2A_COM2A1    = 0x80 // Compare Output Mode bits
	TCCR2A_COM2A_Msk = 0xc0 // Compare Output Mode bits
	TCCR2A_COM2B0    = 0x10 // Compare Output Mode bits
	TCCR2A_COM2B1    = 0x20 // Compare Output Mode bits
	TCCR2A_COM2B_Msk = 0x30 // Compare Output Mode bits
	TCCR2A_WGM20     = 0x1  // Waveform Genration Mode
	TCCR2A_WGM21     = 0x2  // Waveform Genration Mode
	TCCR2A_WGM2_Msk  = 0x3  // Waveform Genration Mode

	// TCCR2B: Timer/Counter2 Control Register B
	TCCR2B_FOC2A     = 0x80 // Force Output Compare A
	TCCR2B_FOC2A_Msk = 0x80 // Force Output Compare A
	TCCR2B_FOC2B     = 0x40 // Force Output Compare B
	TCCR2B_FOC2B_Msk = 0x40 // Force Output Compare B
	TCCR2B_WGM22     = 0x8  // Waveform Generation Mode
	TCCR2B_WGM22_Msk = 0x8  // Waveform Generation Mode
	TCCR2B_CS20      = 0x1  // Clock Select bits
	TCCR2B_CS21      = 0x2  // Clock Select bits
	TCCR2B_CS22      = 0x4  // Clock Select bits
	TCCR2B_CS2_Msk   = 0x7  // Clock Select bits

	// ASSR: Asynchronous Status Register
	ASSR_EXCLK       = 0x40 // Enable External Clock Input
	ASSR_EXCLK_Msk   = 0x40 // Enable External Clock Input
	ASSR_AS2         = 0x20 // Asynchronous Timer/Counter2
	ASSR_AS2_Msk     = 0x20 // Asynchronous Timer/Counter2
	ASSR_TCN2UB      = 0x10 // Timer/Counter2 Update Busy
	ASSR_TCN2UB_Msk  = 0x10 // Timer/Counter2 Update Busy
	ASSR_OCR2AUB     = 0x8  // Output Compare Register2 Update Busy
	ASSR_OCR2AUB_Msk = 0x8  // Output Compare Register2 Update Busy
	ASSR_OCR2BUB     = 0x4  // Output Compare Register 2 Update Busy
	ASSR_OCR2BUB_Msk = 0x4  // Output Compare Register 2 Update Busy
	ASSR_TCR2AUB     = 0x2  // Timer/Counter Control Register2 Update Busy
	ASSR_TCR2AUB_Msk = 0x2  // Timer/Counter Control Register2 Update Busy
	ASSR_TCR2BUB     = 0x1  // Timer/Counter Control Register2 Update Busy
	ASSR_TCR2BUB_Msk = 0x1  // Timer/Counter Control Register2 Update Busy
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TCCR3A: Timer/Counter3 Control Register A
	TCCR3A_COM3A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR3A_COM3A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR3A_COM3A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR3A_COM3B0    = 0x10 // Compare Output Mode 3B, bits
	TCCR3A_COM3B1    = 0x20 // Compare Output Mode 3B, bits
	TCCR3A_COM3B_Msk = 0x30 // Compare Output Mode 3B, bits
	TCCR3A_COM3C0    = 0x4  // Compare Output Mode 3C, bits
	TCCR3A_COM3C1    = 0x8  // Compare Output Mode 3C, bits
	TCCR3A_COM3C_Msk = 0xc  // Compare Output Mode 3C, bits
	TCCR3A_WGM30     = 0x1  // Waveform Generation Mode
	TCCR3A_WGM31     = 0x2  // Waveform Generation Mode
	TCCR3A_WGM3_Msk  = 0x3  // Waveform Generation Mode

	// TCCR3B: Timer/Counter3 Control Register B
	TCCR3B_ICNC3     = 0x80 // Input Capture 3 Noise Canceler
	TCCR3B_ICNC3_Msk = 0x80 // Input Capture 3 Noise Canceler
	TCCR3B_ICES3     = 0x40 // Input Capture 3 Edge Select
	TCCR3B_ICES3_Msk = 0x40 // Input Capture 3 Edge Select
	TCCR3B_WGM30     = 0x8  // Waveform Generation Mode
	TCCR3B_WGM31     = 0x10 // Waveform Generation Mode
	TCCR3B_WGM3_Msk  = 0x18 // Waveform Generation Mode
	TCCR3B_CS30      = 0x1  // Prescaler source of Timer/Counter 3
	TCCR3B_CS31      = 0x2  // Prescaler source of Timer/Counter 3
	TCCR3B_CS32      = 0x4  // Prescaler source of Timer/Counter 3
	TCCR3B_CS3_Msk   = 0x7  // Prescaler source of Timer/Counter 3

	// TCCR3C: Timer/Counter 3 Control Register C
	TCCR3C_FOC3A     = 0x80 // Force Output Compare 3A
	TCCR3C_FOC3A_Msk = 0x80 // Force Output Compare 3A
	TCCR3C_FOC3B     = 0x40 // Force Output Compare 3B
	TCCR3C_FOC3B_Msk = 0x40 // Force Output Compare 3B
	TCCR3C_FOC3C     = 0x20 // Force Output Compare 3C
	TCCR3C_FOC3C_Msk = 0x20 // Force Output Compare 3C

	// TIMSK3: Timer/Counter3 Interrupt Mask Register
	TIMSK3_ICIE3      = 0x20 // Timer/Counter3 Input Capture Interrupt Enable
	TIMSK3_ICIE3_Msk  = 0x20 // Timer/Counter3 Input Capture Interrupt Enable
	TIMSK3_OCIE3C     = 0x8  // Timer/Counter3 Output Compare C Match Interrupt Enable
	TIMSK3_OCIE3C_Msk = 0x8  // Timer/Counter3 Output Compare C Match Interrupt Enable
	TIMSK3_OCIE3B     = 0x4  // Timer/Counter3 Output Compare B Match Interrupt Enable
	TIMSK3_OCIE3B_Msk = 0x4  // Timer/Counter3 Output Compare B Match Interrupt Enable
	TIMSK3_OCIE3A     = 0x2  // Timer/Counter3 Output Compare A Match Interrupt Enable
	TIMSK3_OCIE3A_Msk = 0x2  // Timer/Counter3 Output Compare A Match Interrupt Enable
	TIMSK3_TOIE3      = 0x1  // Timer/Counter3 Overflow Interrupt Enable
	TIMSK3_TOIE3_Msk  = 0x1  // Timer/Counter3 Overflow Interrupt Enable

	// TIFR3: Timer/Counter3 Interrupt Flag register
	TIFR3_ICF3      = 0x20 // Input Capture Flag 3
	TIFR3_ICF3_Msk  = 0x20 // Input Capture Flag 3
	TIFR3_OCF3C     = 0x8  // Output Compare Flag 3C
	TIFR3_OCF3C_Msk = 0x8  // Output Compare Flag 3C
	TIFR3_OCF3B     = 0x4  // Output Compare Flag 3B
	TIFR3_OCF3B_Msk = 0x4  // Output Compare Flag 3B
	TIFR3_OCF3A     = 0x2  // Output Compare Flag 3A
	TIFR3_OCF3A_Msk = 0x2  // Output Compare Flag 3A
	TIFR3_TOV3      = 0x1  // Timer/Counter3 Overflow Flag
	TIFR3_TOV3_Msk  = 0x1  // Timer/Counter3 Overflow Flag

	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0    = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1    = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1B_Msk = 0x30 // Compare Output Mode 1B, bits
	TCCR1A_COM1C0    = 0x4  // Compare Output Mode 1C, bits
	TCCR1A_COM1C1    = 0x8  // Compare Output Mode 1C, bits
	TCCR1A_COM1C_Msk = 0xc  // Compare Output Mode 1C, bits
	TCCR1A_WGM10     = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11     = 0x2  // Waveform Generation Mode
	TCCR1A_WGM1_Msk  = 0x3  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1     = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICNC1_Msk = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1     = 0x40 // Input Capture 1 Edge Select
	TCCR1B_ICES1_Msk = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10     = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11     = 0x10 // Waveform Generation Mode
	TCCR1B_WGM1_Msk  = 0x18 // Waveform Generation Mode
	TCCR1B_CS10      = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11      = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12      = 0x4  // Prescaler source of Timer/Counter 1
	TCCR1B_CS1_Msk   = 0x7  // Prescaler source of Timer/Counter 1

	// TCCR1C: Timer/Counter 1 Control Register C
	TCCR1C_FOC1A     = 0x80 // Force Output Compare 1A
	TCCR1C_FOC1A_Msk = 0x80 // Force Output Compare 1A
	TCCR1C_FOC1B     = 0x40 // Force Output Compare 1B
	TCCR1C_FOC1B_Msk = 0x40 // Force Output Compare 1B
	TCCR1C_FOC1C     = 0x20 // Force Output Compare 1C
	TCCR1C_FOC1C_Msk = 0x20 // Force Output Compare 1C

	// TIMSK1: Timer/Counter1 Interrupt Mask Register
	TIMSK1_ICIE1      = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_ICIE1_Msk  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1C     = 0x8  // Timer/Counter1 Output Compare C Match Interrupt Enable
	TIMSK1_OCIE1C_Msk = 0x8  // Timer/Counter1 Output Compare C Match Interrupt Enable
	TIMSK1_OCIE1B     = 0x4  // Timer/Counter1 Output Compare B Match Interrupt Enable
	TIMSK1_OCIE1B_Msk = 0x4  // Timer/Counter1 Output Compare B Match Interrupt Enable
	TIMSK1_OCIE1A     = 0x2  // Timer/Counter1 Output Compare A Match Interrupt Enable
	TIMSK1_OCIE1A_Msk = 0x2  // Timer/Counter1 Output Compare A Match Interrupt Enable
	TIMSK1_TOIE1      = 0x1  // Timer/Counter1 Overflow Interrupt Enable
	TIMSK1_TOIE1_Msk  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter1 Interrupt Flag register
	TIFR1_ICF1      = 0x20 // Input Capture Flag 1
	TIFR1_ICF1_Msk  = 0x20 // Input Capture Flag 1
	TIFR1_OCF1C     = 0x8  // Output Compare Flag 1C
	TIFR1_OCF1C_Msk = 0x8  // Output Compare Flag 1C
	TIFR1_OCF1B     = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1B_Msk = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1A     = 0x2  // Output Compare Flag 1A
	TIFR1_OCF1A_Msk = 0x2  // Output Compare Flag 1A
	TIFR1_TOV1      = 0x1  // Timer/Counter1 Overflow Flag
	TIFR1_TOV1_Msk  = 0x1  // Timer/Counter1 Overflow Flag
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register A
	EICRA_ISC30    = 0x40 // External Interrupt Sense Control Bit
	EICRA_ISC31    = 0x80 // External Interrupt Sense Control Bit
	EICRA_ISC3_Msk = 0xc0 // External Interrupt Sense Control Bit
	EICRA_ISC20    = 0x10 // External Interrupt Sense Control Bit
	EICRA_ISC21    = 0x20 // External Interrupt Sense Control Bit
	EICRA_ISC2_Msk = 0x30 // External Interrupt Sense Control Bit
	EICRA_ISC10    = 0x4  // External Interrupt Sense Control Bit
	EICRA_ISC11    = 0x8  // External Interrupt Sense Control Bit
	EICRA_ISC1_Msk = 0xc  // External Interrupt Sense Control Bit
	EICRA_ISC00    = 0x1  // External Interrupt Sense Control Bit
	EICRA_ISC01    = 0x2  // External Interrupt Sense Control Bit
	EICRA_ISC0_Msk = 0x3  // External Interrupt Sense Control Bit

	// EICRB: External Interrupt Control Register B
	EICRB_ISC70    = 0x40 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC71    = 0x80 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC7_Msk = 0xc0 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC60    = 0x10 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC61    = 0x20 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC6_Msk = 0x30 // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC50    = 0x4  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC51    = 0x8  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC5_Msk = 0xc  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC40    = 0x1  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC41    = 0x2  // External Interrupt 7-4 Sense Control Bit
	EICRB_ISC4_Msk = 0x3  // External Interrupt 7-4 Sense Control Bit

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0    = 0x1  // External Interrupt Request 7 Enable
	EIMSK_INT1    = 0x2  // External Interrupt Request 7 Enable
	EIMSK_INT2    = 0x4  // External Interrupt Request 7 Enable
	EIMSK_INT3    = 0x8  // External Interrupt Request 7 Enable
	EIMSK_INT4    = 0x10 // External Interrupt Request 7 Enable
	EIMSK_INT5    = 0x20 // External Interrupt Request 7 Enable
	EIMSK_INT6    = 0x40 // External Interrupt Request 7 Enable
	EIMSK_INT7    = 0x80 // External Interrupt Request 7 Enable
	EIMSK_INT_Msk = 0xff // External Interrupt Request 7 Enable

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0    = 0x1  // External Interrupt Flags
	EIFR_INTF1    = 0x2  // External Interrupt Flags
	EIFR_INTF2    = 0x4  // External Interrupt Flags
	EIFR_INTF3    = 0x8  // External Interrupt Flags
	EIFR_INTF4    = 0x10 // External Interrupt Flags
	EIFR_INTF5    = 0x20 // External Interrupt Flags
	EIFR_INTF6    = 0x40 // External Interrupt Flags
	EIFR_INTF7    = 0x80 // External Interrupt Flags
	EIFR_INTF_Msk = 0xff // External Interrupt Flags

	// PCIFR: Pin Change Interrupt Flag Register
	PCIFR_PCIF0     = 0x1 // Pin Change Interrupt Flag 0
	PCIFR_PCIF0_Msk = 0x1 // Pin Change Interrupt Flag 0

	// PCICR: Pin Change Interrupt Control Register
	PCICR_PCIE0     = 0x1 // Pin Change Interrupt Enable 0
	PCICR_PCIE0_Msk = 0x1 // Pin Change Interrupt Enable 0
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC multiplexer Selection Register
	ADMUX_REFS0     = 0x40 // Reference Selection Bits
	ADMUX_REFS1     = 0x80 // Reference Selection Bits
	ADMUX_REFS_Msk  = 0xc0 // Reference Selection Bits
	ADMUX_ADLAR     = 0x20 // Left Adjust Result
	ADMUX_ADLAR_Msk = 0x20 // Left Adjust Result
	ADMUX_MUX0      = 0x1  // Analog Channel and Gain Selection Bits
	ADMUX_MUX1      = 0x2  // Analog Channel and Gain Selection Bits
	ADMUX_MUX2      = 0x4  // Analog Channel and Gain Selection Bits
	ADMUX_MUX3      = 0x8  // Analog Channel and Gain Selection Bits
	ADMUX_MUX4      = 0x10 // Analog Channel and Gain Selection Bits
	ADMUX_MUX_Msk   = 0x1f // Analog Channel and Gain Selection Bits

	// ADCSRA: The ADC Control and Status register
	ADCSRA_ADEN      = 0x80 // ADC Enable
	ADCSRA_ADEN_Msk  = 0x80 // ADC Enable
	ADCSRA_ADSC      = 0x40 // ADC Start Conversion
	ADCSRA_ADSC_Msk  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE     = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADATE_Msk = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADIF      = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIF_Msk  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE      = 0x8  // ADC Interrupt Enable
	ADCSRA_ADIE_Msk  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0     = 0x1  // ADC Prescaler Select Bits
	ADCSRA_ADPS1     = 0x2  // ADC Prescaler Select Bits
	ADCSRA_ADPS2     = 0x4  // ADC Prescaler Select Bits
	ADCSRA_ADPS_Msk  = 0x7  // ADC Prescaler Select Bits

	// ADCSRB: ADC Control and Status Register B
	ADCSRB_ADHSM     = 0x80 // ADC High Speed Mode
	ADCSRB_ADHSM_Msk = 0x80 // ADC High Speed Mode
	ADCSRB_ADTS0     = 0x1  // ADC Auto Trigger Sources
	ADCSRB_ADTS1     = 0x2  // ADC Auto Trigger Sources
	ADCSRB_ADTS2     = 0x4  // ADC Auto Trigger Sources
	ADCSRB_ADTS_Msk  = 0x7  // ADC Auto Trigger Sources
	ADCSRB_ACME      = 0x40 // Analog Comparator Multiplexer Enable
	ADCSRB_ACME_Msk  = 0x40 // Analog Comparator Multiplexer Enable

	// DIDR0: Digital Input Disable Register 1
	DIDR0_ADC7D     = 0x80 // ADC7 Digital input Disable
	DIDR0_ADC7D_Msk = 0x80 // ADC7 Digital input Disable
	DIDR0_ADC6D     = 0x40 // ADC6 Digital input Disable
	DIDR0_ADC6D_Msk = 0x40 // ADC6 Digital input Disable
	DIDR0_ADC5D     = 0x20 // ADC5 Digital input Disable
	DIDR0_ADC5D_Msk = 0x20 // ADC5 Digital input Disable
	DIDR0_ADC4D     = 0x10 // ADC4 Digital input Disable
	DIDR0_ADC4D_Msk = 0x10 // ADC4 Digital input Disable
	DIDR0_ADC3D     = 0x8  // ADC3 Digital input Disable
	DIDR0_ADC3D_Msk = 0x8  // ADC3 Digital input Disable
	DIDR0_ADC2D     = 0x4  // ADC2 Digital input Disable
	DIDR0_ADC2D_Msk = 0x4  // ADC2 Digital input Disable
	DIDR0_ADC1D     = 0x2  // ADC1 Digital input Disable
	DIDR0_ADC1D_Msk = 0x2  // ADC1 Digital input Disable
	DIDR0_ADC0D     = 0x1  // ADC0 Digital input Disable
	DIDR0_ADC0D_Msk = 0x1  // ADC0 Digital input Disable
)

// Bitfields for AC: Analog Comparator
const (
	// ACSR: Analog Comparator Control And Status Register
	ACSR_ACD      = 0x80 // Analog Comparator Disable
	ACSR_ACD_Msk  = 0x80 // Analog Comparator Disable
	ACSR_ACBG     = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACBG_Msk = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACO      = 0x20 // Analog Compare Output
	ACSR_ACO_Msk  = 0x20 // Analog Compare Output
	ACSR_ACI      = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACI_Msk  = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACIE     = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIE_Msk = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIC     = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIC_Msk = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIS0    = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS1    = 0x2  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS_Msk = 0x3  // Analog Comparator Interrupt Mode Select bits

	// DIDR1
	DIDR1_AIN1D     = 0x2 // AIN1 Digital Input Disable
	DIDR1_AIN1D_Msk = 0x2 // AIN1 Digital Input Disable
	DIDR1_AIN0D     = 0x1 // AIN0 Digital Input Disable
	DIDR1_AIN0D_Msk = 0x1 // AIN0 Digital Input Disable
)

// Bitfields for PLL: Phase Locked Loop
const (
	// PLLCSR: PLL Status and Control register
	PLLCSR_PLLP0     = 0x4  // PLL prescaler Bits
	PLLCSR_PLLP1     = 0x8  // PLL prescaler Bits
	PLLCSR_PLLP2     = 0x10 // PLL prescaler Bits
	PLLCSR_PLLP_Msk  = 0x1c // PLL prescaler Bits
	PLLCSR_PLLE      = 0x2  // PLL Enable Bit
	PLLCSR_PLLE_Msk  = 0x2  // PLL Enable Bit
	PLLCSR_PLOCK     = 0x1  // PLL Lock Status Bit
	PLLCSR_PLOCK_Msk = 0x1  // PLL Lock Status Bit
)
