import type * as lsp from 'vscode-languageserver';
import type tsp from 'typescript/lib/protocol.d.js';
import { LspDocuments } from './document.js';
import type { TypeScriptInitializationOptions } from './ts-protocol.js';
import type { TspClient } from './tsp-client.js';
export interface WorkspaceConfiguration {
    javascript?: WorkspaceConfigurationLanguageOptions;
    typescript?: WorkspaceConfigurationLanguageOptions;
    completions?: WorkspaceConfigurationCompletionOptions;
    diagnostics?: WorkspaceConfigurationDiagnosticsOptions;
}
export interface WorkspaceConfigurationLanguageOptions {
    format?: tsp.FormatCodeSettings;
    inlayHints?: TypeScriptInlayHintsPreferences;
}
export interface TypeScriptInlayHintsPreferences {
    includeInlayParameterNameHints?: 'none' | 'literals' | 'all';
    includeInlayParameterNameHintsWhenArgumentMatchesName?: boolean;
    includeInlayFunctionParameterTypeHints?: boolean;
    includeInlayVariableTypeHints?: boolean;
    includeInlayPropertyDeclarationTypeHints?: boolean;
    includeInlayFunctionLikeReturnTypeHints?: boolean;
    includeInlayEnumMemberValueHints?: boolean;
}
interface WorkspaceConfigurationDiagnosticsOptions {
    ignoredCodes?: number[];
}
export interface WorkspaceConfigurationCompletionOptions {
    completeFunctionCalls?: boolean;
}
export declare class ConfigurationManager {
    private readonly documents;
    tsPreferences: Required<tsp.UserPreferences>;
    workspaceConfiguration: WorkspaceConfiguration;
    private tspClient;
    constructor(documents: LspDocuments);
    mergeTsPreferences(preferences: tsp.UserPreferences): void;
    setWorkspaceConfiguration(configuration: WorkspaceConfiguration): void;
    setAndConfigureTspClient(client: TspClient, hostInfo?: TypeScriptInitializationOptions['hostInfo']): Promise<void>;
    configureGloballyFromDocument(filename: string, formattingOptions?: lsp.FormattingOptions): Promise<void>;
    getPreferences(filename: string): tsp.UserPreferences;
    private getFormattingOptions;
    private getQuoteStylePreference;
    private getWorkspacePreferencesForFile;
}
export {};
//# sourceMappingURL=configuration-manager.d.ts.map