/* tracker-store.c generated by valac 0.56.1, the Vala compiler
 * generated from tracker-store.vala, do not modify */

/*
 * Copyright (C) 2009-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Philip Van Hoof <philip@codeminded.be>
 */

#include <glib-object.h>
#include <glib.h>
#include "tracker-store/tracker-config.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "libtracker-data/tracker-class.h"
#include "tracker-store/tracker-events.h"
#include "libtracker-sparql/tracker-sparql.h"
#include "tracker-store/tracker-writeback.h"
#include "libtracker-direct/tracker-direct.h"
#include "libtracker-data/tracker-data-manager.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include <gobject/gvaluecollector.h>

#define TRACKER_STORE_MAX_CONCURRENT_QUERIES 2
#define TRACKER_STORE_MAX_TASK_TIME 30
#define TRACKER_STORE_GRAPH_UPDATED_IMMEDIATE_EMIT_AT 50000
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TRACKER_TYPE_STORE (tracker_store_get_type ())
#define TRACKER_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STORE, TrackerStore))
#define TRACKER_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STORE, TrackerStoreClass))
#define TRACKER_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STORE))
#define TRACKER_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STORE))
#define TRACKER_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STORE, TrackerStoreClass))

typedef struct _TrackerStore TrackerStore;
typedef struct _TrackerStoreClass TrackerStoreClass;
typedef struct _TrackerStorePrivate TrackerStorePrivate;
typedef void (*TrackerStoreSignalEmissionFunc) (GHashTable* graph_updated, GHashTable* writeback, gpointer user_data);
typedef void (*TrackerStoreStateCallback) (gpointer user_data);

#define TRACKER_STORE_TYPE_CURSOR_TASK (tracker_store_cursor_task_get_type ())
#define TRACKER_STORE_CURSOR_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_CURSOR_TASK, TrackerStoreCursorTask))
#define TRACKER_STORE_CURSOR_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_CURSOR_TASK, TrackerStoreCursorTaskClass))
#define TRACKER_STORE_IS_CURSOR_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_CURSOR_TASK))
#define TRACKER_STORE_IS_CURSOR_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_CURSOR_TASK))
#define TRACKER_STORE_CURSOR_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_CURSOR_TASK, TrackerStoreCursorTaskClass))

typedef struct _TrackerStoreCursorTask TrackerStoreCursorTask;
typedef struct _TrackerStoreCursorTaskClass TrackerStoreCursorTaskClass;
#define _tracker_store_cursor_task_unref0(var) ((var == NULL) ? NULL : (var = (tracker_store_cursor_task_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _TrackerStoreCursorTaskPrivate TrackerStoreCursorTaskPrivate;
typedef void (*TrackerStoreSparqlQueryInThread) (TrackerSparqlCursor* cursor, gpointer user_data, GError** error);
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _TrackerStoreSparqlQueryData TrackerStoreSparqlQueryData;
typedef struct _TrackerStoreSparqlUpdateData TrackerStoreSparqlUpdateData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerStoreSparqlUpdateBlankData TrackerStoreSparqlUpdateBlankData;
typedef struct _TrackerStoreQueueTurtleImportData TrackerStoreQueueTurtleImportData;
typedef struct _TrackerStorePauseData TrackerStorePauseData;
typedef struct _TrackerStoreParamSpecCursorTask TrackerStoreParamSpecCursorTask;
typedef struct _TrackerParamSpecStore TrackerParamSpecStore;

struct _TrackerStore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStorePrivate * priv;
};

struct _TrackerStoreClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStore *self);
};

struct _Block7Data {
	int _ref_count_;
	TrackerStoreCursorTask* task;
};

struct _TrackerStoreCursorTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStoreCursorTaskPrivate * priv;
	TrackerSparqlCursor* cursor;
	GSourceFunc callback;
	gpointer callback_target;
	TrackerStoreSparqlQueryInThread thread_func;
	gpointer thread_func_target;
	GError* error;
};

struct _TrackerStoreCursorTaskClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStoreCursorTask *self);
};

struct _Block8Data {
	int _ref_count_;
	GCancellable* task_cancellable;
};

struct _Block9Data {
	int _ref_count_;
	GCancellable* cancellable;
	guint timeout_id;
	gpointer _async_data_;
};

struct _TrackerStoreSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* conn;
	gchar* sparql;
	gint priority;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
	gchar* client_id;
	Block9Data* _data9_;
	GCancellable* _tmp0_;
	TrackerSparqlCursor* cursor;
	GCancellable* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerStoreCursorTask* task;
	TrackerSparqlCursor* _tmp3_;
	TrackerStoreCursorTask* _tmp4_;
	TrackerStoreCursorTask* _tmp5_;
	TrackerStoreCursorTask* _tmp6_;
	GThreadPool* _tmp7_;
	TrackerStoreCursorTask* _tmp8_;
	TrackerStoreCursorTask* _tmp9_;
	TrackerStoreCursorTask* _tmp10_;
	GError* _tmp11_;
	TrackerStoreCursorTask* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _inner_error0_;
};

struct _TrackerStoreSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* conn;
	gchar* sparql;
	gint priority;
	gchar* client_id;
	GError* _tmp0_;
	GCancellable* cancellable;
	GCancellable* _tmp1_;
	GError* _inner_error0_;
};

struct _TrackerStoreSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* conn;
	gchar* sparql;
	gint priority;
	gchar* client_id;
	GVariant* result;
	GError* _tmp0_;
	GCancellable* cancellable;
	GCancellable* _tmp1_;
	GVariant* nodes;
	GVariant* _tmp2_;
	GError* _inner_error0_;
};

struct _TrackerStoreQueueTurtleImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* conn;
	GFile* file;
	gchar* client_id;
	GError* _tmp0_;
	GCancellable* cancellable;
	GCancellable* _tmp1_;
	GError* _inner_error0_;
};

struct _TrackerStorePauseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* sparql_conn;
	TrackerDirectConnection* _tmp0_;
	TrackerDirectConnection* _tmp1_;
};

struct _TrackerStoreParamSpecCursorTask {
	GParamSpec parent_instance;
};

struct _TrackerParamSpecStore {
	GParamSpec parent_instance;
};

static gpointer tracker_store_parent_class = NULL;
static gint tracker_store_max_task_time;
static gint tracker_store_max_task_time = 0;
static gboolean tracker_store_active;
static gboolean tracker_store_active = FALSE;
static TrackerConfig* tracker_store_config;
static TrackerConfig* tracker_store_config = NULL;
static guint tracker_store_signal_timeout;
static guint tracker_store_signal_timeout = 0U;
static gint tracker_store_n_updates;
static gint tracker_store_n_updates = 0;
static GHashTable* tracker_store_client_cancellables;
static GHashTable* tracker_store_client_cancellables = NULL;
static TrackerStoreSignalEmissionFunc tracker_store_signal_callback;
static gpointer tracker_store_signal_callback_target;
static TrackerStoreSignalEmissionFunc tracker_store_signal_callback = NULL;
static gpointer tracker_store_signal_callback_target = NULL;
static TrackerStoreStateCallback tracker_store_idle_cb;
static gpointer tracker_store_idle_cb_target;
static TrackerStoreStateCallback tracker_store_idle_cb = NULL;
static gpointer tracker_store_idle_cb_target = NULL;
static TrackerStoreStateCallback tracker_store_busy_cb;
static gpointer tracker_store_busy_cb_target;
static TrackerStoreStateCallback tracker_store_busy_cb = NULL;
static gpointer tracker_store_busy_cb_target = NULL;
static gboolean tracker_store_busy;
static gboolean tracker_store_busy = FALSE;
static GThreadPool* tracker_store_cursor_pool;
static GThreadPool* tracker_store_cursor_pool = NULL;
static gpointer tracker_store_cursor_task_parent_class = NULL;

VALA_EXTERN gpointer tracker_store_ref (gpointer instance);
VALA_EXTERN void tracker_store_unref (gpointer instance);
VALA_EXTERN GParamSpec* tracker_param_spec_store (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void tracker_value_set_store (GValue* value,
                              gpointer v_object);
VALA_EXTERN void tracker_value_take_store (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer tracker_value_get_store (const GValue* value);
VALA_EXTERN GType tracker_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerStore, tracker_store_unref)
static gpointer tracker_store_cursor_task_ref (gpointer instance);
static void tracker_store_cursor_task_unref (gpointer instance);
static GParamSpec* tracker_store_param_spec_cursor_task (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags) G_GNUC_UNUSED ;
static void tracker_store_value_set_cursor_task (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED ;
static void tracker_store_value_take_cursor_task (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED ;
static gpointer tracker_store_value_get_cursor_task (const GValue* value) G_GNUC_UNUSED ;
static GType tracker_store_cursor_task_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerStoreCursorTask, tracker_store_cursor_task_unref)
static void tracker_store_cursor_dispatch_cb (TrackerStoreCursorTask* task);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block7Data* _data7_);
static void tracker_store_update_state (void);
static gboolean ___lambda6__gsource_func (gpointer self);
VALA_EXTERN void tracker_store_init (TrackerConfig* config_p,
                         TrackerStoreStateCallback idle,
                         gpointer idle_target,
                         TrackerStoreStateCallback busy,
                         gpointer busy_target);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _tracker_store_cursor_dispatch_cb_gfunc (gpointer data,
                                              gpointer self);
VALA_EXTERN void tracker_store_shutdown (void);
static GCancellable* tracker_store_create_cancellable (const gchar* client_id);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda7_ (Block8Data* _data8_);
static void ___lambda7__gfunc (gconstpointer data,
                        gpointer self);
static void tracker_store_do_emit_signals (void);
static void tracker_store_ensure_signal_timeout (void);
static gboolean ___lambda8_ (void);
static gboolean ____lambda8__gsource_func (gpointer self);
static void tracker_store_sparql_query_data_free (gpointer _data);
VALA_EXTERN void tracker_store_sparql_query (TrackerDirectConnection* conn,
                                 const gchar* sparql,
                                 gint priority,
                                 TrackerStoreSparqlQueryInThread in_thread,
                                 gpointer in_thread_target,
                                 const gchar* client_id,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void tracker_store_sparql_query_finish (GAsyncResult* _res_,
                                        GError** error);
static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static gboolean ___lambda9_ (Block9Data* _data9_);
static gboolean ____lambda9__gsource_func (gpointer self);
static void tracker_store_sparql_query_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static TrackerStoreCursorTask* tracker_store_cursor_task_new (TrackerSparqlCursor* cursor);
static TrackerStoreCursorTask* tracker_store_cursor_task_construct (GType object_type,
                                                             TrackerSparqlCursor* cursor);
static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self);
static void tracker_store_pre_update (void);
static void tracker_store_post_update (void);
static void tracker_store_sparql_update_data_free (gpointer _data);
VALA_EXTERN void tracker_store_sparql_update (TrackerDirectConnection* conn,
                                  const gchar* sparql,
                                  gint priority,
                                  const gchar* client_id,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void tracker_store_sparql_update_finish (GAsyncResult* _res_,
                                         GError** error);
static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_);
static void tracker_store_sparql_update_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void tracker_store_sparql_update_blank_data_free (gpointer _data);
VALA_EXTERN void tracker_store_sparql_update_blank (TrackerDirectConnection* conn,
                                        const gchar* sparql,
                                        gint priority,
                                        const gchar* client_id,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_,
                                                    GError** error);
static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_);
static void tracker_store_sparql_update_blank_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void tracker_store_queue_turtle_import_data_free (gpointer _data);
VALA_EXTERN void tracker_store_queue_turtle_import (TrackerDirectConnection* conn,
                                        GFile* file,
                                        const gchar* client_id,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_,
                                               GError** error);
static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_);
static void tracker_store_queue_turtle_import_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
VALA_EXTERN void tracker_store_unreg_batches (const gchar* client_id);
static void tracker_store_pause_data_free (gpointer _data);
VALA_EXTERN void tracker_store_pause (GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
VALA_EXTERN void tracker_store_pause_finish (GAsyncResult* _res_);
static gboolean tracker_store_pause_co (TrackerStorePauseData* _data_);
VALA_EXTERN TrackerDirectConnection* tracker_main_get_sparql_connection (void);
VALA_EXTERN void tracker_store_resume (void);
static void tracker_store_on_statements_committed (void);
static void tracker_store_check_graph_updated_signal (void);
static void tracker_store_on_statements_rolled_back (void);
static gboolean ___lambda10_ (void);
static gboolean ____lambda10__gsource_func (gpointer self);
static void tracker_store_on_statement_inserted (gint graph_id,
                                          const gchar* graph,
                                          gint subject_id,
                                          const gchar* subject,
                                          gint pred_id,
                                          gint object_id,
                                          const gchar* object,
                                          GPtrArray* rdf_types);
static void tracker_store_on_statement_deleted (gint graph_id,
                                         const gchar* graph,
                                         gint subject_id,
                                         const gchar* subject,
                                         gint pred_id,
                                         gint object_id,
                                         const gchar* object,
                                         GPtrArray* rdf_types);
VALA_EXTERN void tracker_store_enable_signals (void);
VALA_EXTERN TrackerDataManager* tracker_main_get_data_manager (void);
static void _tracker_store_on_statement_inserted_tracker_statement_callback (gint graph_id,
                                                                      const gchar* graph,
                                                                      gint subject_id,
                                                                      const gchar* subject,
                                                                      gint predicate_id,
                                                                      gint object_id,
                                                                      const gchar* object,
                                                                      GPtrArray* rdf_types,
                                                                      gpointer self);
static void _tracker_store_on_statement_deleted_tracker_statement_callback (gint graph_id,
                                                                     const gchar* graph,
                                                                     gint subject_id,
                                                                     const gchar* subject,
                                                                     gint predicate_id,
                                                                     gint object_id,
                                                                     const gchar* object,
                                                                     GPtrArray* rdf_types,
                                                                     gpointer self);
static void _tracker_store_on_statements_committed_tracker_commit_callback (gpointer self);
static void _tracker_store_on_statements_rolled_back_tracker_commit_callback (gpointer self);
VALA_EXTERN void tracker_store_disable_signals (void);
VALA_EXTERN void tracker_store_set_signal_callback (TrackerStoreSignalEmissionFunc func,
                                        gpointer func_target);
VALA_EXTERN TrackerStore* tracker_store_new (void);
VALA_EXTERN TrackerStore* tracker_store_construct (GType object_type);
static void tracker_store_cursor_task_finalize (TrackerStoreCursorTask * obj);
static GType tracker_store_cursor_task_get_type_once (void);
static void tracker_store_finalize (TrackerStore * obj);
static GType tracker_store_get_type_once (void);

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_tracker_store_cursor_task_unref0 (_data7_->task);
		g_slice_free (Block7Data, _data7_);
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
__lambda6_ (Block7Data* _data7_)
{
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	gboolean result;
	_tmp0_ = _data7_->task->callback;
	_tmp0__target = _data7_->task->callback_target;
	_tmp0_ (_tmp0__target);
	tracker_store_update_state ();
	result = FALSE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ (self);
	return result;
}

static void
tracker_store_cursor_dispatch_cb (TrackerStoreCursorTask* task)
{
	Block7Data* _data7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (task != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_tracker_store_cursor_task_unref0 (_data7_->task);
	_data7_->task = task;
	{
		TrackerStoreSparqlQueryInThread _tmp0_;
		gpointer _tmp0__target;
		TrackerSparqlCursor* _tmp1_;
		_tmp0_ = _data7_->task->thread_func;
		_tmp0__target = _data7_->task->thread_func_target;
		_tmp1_ = _data7_->task->cursor;
		_tmp0_ (_tmp1_, _tmp0__target, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _g_error_copy0 (_tmp2_);
		_g_error_free0 (_data7_->task->error);
		_data7_->task->error = _tmp3_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block7_data_unref (_data7_);
		_data7_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_tracker_store_cursor_dispatch_cb_gfunc (gpointer data,
                                         gpointer self)
{
	tracker_store_cursor_dispatch_cb ((TrackerStoreCursorTask*) data);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
tracker_store_init (TrackerConfig* config_p,
                    TrackerStoreStateCallback idle,
                    gpointer idle_target,
                    TrackerStoreStateCallback busy,
                    gpointer busy_target)
{
	gchar* max_task_time_env = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	TrackerConfig* _tmp10_;
	TrackerStoreStateCallback _tmp11_;
	gpointer _tmp11__target;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (config_p != NULL);
	_tmp0_ = g_getenv ("TRACKER_STORE_MAX_TASK_TIME");
	_tmp1_ = g_strdup (_tmp0_);
	max_task_time_env = _tmp1_;
	_tmp2_ = max_task_time_env;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = max_task_time_env;
		tracker_store_max_task_time = atoi (_tmp3_);
	} else {
		tracker_store_max_task_time = TRACKER_STORE_MAX_TASK_TIME;
	}
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (tracker_store_client_cancellables);
	tracker_store_client_cancellables = _tmp6_;
	{
		GThreadPool* _tmp7_ = NULL;
		GThreadPool* _tmp8_;
		GThreadPool* _tmp9_;
		_tmp8_ = g_thread_pool_new (_tracker_store_cursor_dispatch_cb_gfunc, NULL, 16, FALSE, &_inner_error0_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_thread_pool_free0 (tracker_store_cursor_pool);
		tracker_store_cursor_pool = _tmp9_;
		_g_thread_pool_free0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (max_task_time_env);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_thread_pool_set_max_idle_time ((guint) (15 * 1000));
	g_thread_pool_set_max_unused_threads (2);
	_tmp10_ = _g_object_ref0 (config_p);
	_g_object_unref0 (tracker_store_config);
	tracker_store_config = _tmp10_;
	tracker_store_idle_cb = idle;
	tracker_store_idle_cb_target = idle_target;
	tracker_store_busy_cb = busy;
	tracker_store_busy_cb_target = busy_target;
	_tmp11_ = tracker_store_idle_cb;
	_tmp11__target = tracker_store_idle_cb_target;
	_tmp11_ (_tmp11__target);
	_g_free0 (max_task_time_env);
}

void
tracker_store_shutdown (void)
{
	if (tracker_store_signal_timeout != ((guint) 0)) {
		g_source_remove (tracker_store_signal_timeout);
		tracker_store_signal_timeout = (guint) 0;
	}
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->task_cancellable);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda7_ (Block8Data* _data8_)
{
	g_cancellable_cancel (_data8_->task_cancellable);
}

static void
___lambda7__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda7_ (self);
}

static GCancellable*
tracker_store_create_cancellable (const gchar* client_id)
{
	Block8Data* _data8_;
	GCancellable* client_cancellable = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	GCancellable* result;
	g_return_val_if_fail (client_id != NULL, NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_tmp0_ = tracker_store_client_cancellables;
	_tmp1_ = g_hash_table_lookup (_tmp0_, client_id);
	_tmp2_ = _g_object_ref0 ((GCancellable*) _tmp1_);
	client_cancellable = _tmp2_;
	_tmp3_ = client_cancellable;
	if (_tmp3_ == NULL) {
		GCancellable* _tmp4_;
		GHashTable* _tmp5_;
		gchar* _tmp6_;
		GCancellable* _tmp7_;
		GCancellable* _tmp8_;
		_tmp4_ = g_cancellable_new ();
		_g_object_unref0 (client_cancellable);
		client_cancellable = _tmp4_;
		_tmp5_ = tracker_store_client_cancellables;
		_tmp6_ = g_strdup (client_id);
		_tmp7_ = client_cancellable;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		g_hash_table_insert (_tmp5_, _tmp6_, _tmp8_);
	}
	_tmp9_ = g_cancellable_new ();
	_data8_->task_cancellable = _tmp9_;
	_tmp10_ = client_cancellable;
	g_cancellable_connect (_tmp10_, (GCallback) ___lambda7__gfunc, block8_data_ref (_data8_), block8_data_unref);
	_tmp11_ = _g_object_ref0 (_data8_->task_cancellable);
	result = _tmp11_;
	_g_object_unref0 (client_cancellable);
	block8_data_unref (_data8_);
	_data8_ = NULL;
	return result;
}

static void
tracker_store_do_emit_signals (void)
{
	TrackerStoreSignalEmissionFunc _tmp0_;
	gpointer _tmp0__target;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	_tmp0_ = tracker_store_signal_callback;
	_tmp0__target = tracker_store_signal_callback_target;
	_tmp1_ = tracker_events_get_pending ();
	_tmp2_ = _tmp1_;
	_tmp3_ = tracker_writeback_get_ready ();
	_tmp4_ = _tmp3_;
	_tmp0_ (_tmp2_, _tmp4_, _tmp0__target);
	_g_hash_table_unref0 (_tmp4_);
	_g_hash_table_unref0 (_tmp2_);
}

static gboolean
___lambda8_ (void)
{
	gboolean result;
	tracker_store_do_emit_signals ();
	if (tracker_store_n_updates == 0) {
		tracker_store_signal_timeout = (guint) 0;
		result = FALSE;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}

static gboolean
____lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda8_ ();
	return result;
}

static void
tracker_store_ensure_signal_timeout (void)
{
	if (tracker_store_signal_timeout == ((guint) 0)) {
		TrackerConfig* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = tracker_store_config;
		_tmp1_ = tracker_config_get_graphupdated_delay (_tmp0_);
		_tmp2_ = _tmp1_;
		tracker_store_signal_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp2_, ____lambda8__gsource_func, NULL, NULL);
	}
}

static void
tracker_store_sparql_query_data_free (gpointer _data)
{
	TrackerStoreSparqlQueryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->conn);
	_g_free0 (_data_->sparql);
	_g_free0 (_data_->client_id);
	g_slice_free (TrackerStoreSparqlQueryData, _data_);
}

void
tracker_store_sparql_query (TrackerDirectConnection* conn,
                            const gchar* sparql,
                            gint priority,
                            TrackerStoreSparqlQueryInThread in_thread,
                            gpointer in_thread_target,
                            const gchar* client_id,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	TrackerStoreSparqlQueryData* _data_;
	TrackerDirectConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (sparql != NULL);
	g_return_if_fail (client_id != NULL);
	_data_ = g_slice_new0 (TrackerStoreSparqlQueryData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_query_data_free);
	_tmp0_ = _g_object_ref0 (conn);
	_g_object_unref0 (_data_->conn);
	_data_->conn = _tmp0_;
	_tmp1_ = g_strdup (sparql);
	_g_free0 (_data_->sparql);
	_data_->sparql = _tmp1_;
	_data_->priority = priority;
	_data_->in_thread = in_thread;
	_data_->in_thread_target = in_thread_target;
	_tmp2_ = g_strdup (client_id);
	_g_free0 (_data_->client_id);
	_data_->client_id = _tmp2_;
	tracker_store_sparql_query_co (_data_);
}

void
tracker_store_sparql_query_finish (GAsyncResult* _res_,
                                   GError** error)
{
	TrackerStoreSparqlQueryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->cancellable);
		g_slice_free (Block9Data, _data9_);
	}
}

static gboolean
___lambda9_ (Block9Data* _data9_)
{
	GCancellable* _tmp0_;
	gboolean result;
	_tmp0_ = _data9_->cancellable;
	g_cancellable_cancel (_tmp0_);
	_data9_->timeout_id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
____lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda9_ (self);
	return result;
}

static void
tracker_store_sparql_query_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	TrackerStoreSparqlQueryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_store_sparql_query_co (_data_);
}

static gboolean
_tracker_store_sparql_query_co_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_store_sparql_query_co (self);
	return result;
}

static gpointer
_tracker_store_cursor_task_ref0 (gpointer self)
{
	return self ? tracker_store_cursor_task_ref (self) : NULL;
}

static gboolean
tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data9_ = g_slice_new0 (Block9Data);
	_data_->_data9_->_ref_count_ = 1;
	_data_->_data9_->_async_data_ = _data_;
	_data_->_tmp0_ = tracker_store_create_cancellable (_data_->client_id);
	_data_->_data9_->cancellable = _data_->_tmp0_;
	_data_->_data9_->timeout_id = (guint) 0;
	if (tracker_store_max_task_time != 0) {
		_data_->_data9_->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) tracker_store_max_task_time, ____lambda9__gsource_func, block9_data_ref (_data_->_data9_), block9_data_unref);
	}
	_data_->_tmp1_ = _data_->_data9_->cancellable;
	_data_->_state_ = 1;
	tracker_sparql_connection_query_async ((TrackerSparqlConnection*) _data_->conn, _data_->sparql, _data_->_tmp1_, tracker_store_sparql_query_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = tracker_sparql_connection_query_finish ((TrackerSparqlConnection*) _data_->conn, _data_->_res_, &_data_->_inner_error0_);
	_data_->cursor = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_data9_->timeout_id != ((guint) 0)) {
		g_source_remove (_data_->_data9_->timeout_id);
	}
	_data_->_tmp3_ = _data_->cursor;
	_data_->_tmp4_ = tracker_store_cursor_task_new (_data_->_tmp3_);
	_data_->task = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->task;
	_data_->_tmp5_->thread_func = _data_->in_thread;
	_data_->_tmp5_->thread_func_target = _data_->in_thread_target;
	_data_->_tmp6_ = _data_->task;
	_data_->_tmp6_->callback = _tracker_store_sparql_query_co_gsource_func;
	_data_->_tmp6_->callback_target = _data_;
	{
		_data_->_tmp7_ = tracker_store_cursor_pool;
		_data_->_tmp8_ = _data_->task;
		_data_->_tmp9_ = _tracker_store_cursor_task_ref0 (_data_->_tmp8_);
		g_thread_pool_push (_data_->_tmp7_, _data_->_tmp9_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_tracker_store_cursor_task_unref0 (_data_->task);
		_g_object_unref0 (_data_->cursor);
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	tracker_store_update_state ();
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	_data_->_tmp10_ = _data_->task;
	_data_->_tmp11_ = _data_->_tmp10_->error;
	if (_data_->_tmp11_ != NULL) {
		_data_->_tmp12_ = _data_->task;
		_data_->_tmp13_ = _data_->_tmp12_->error;
		_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
		_data_->_inner_error0_ = _data_->_tmp14_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_tracker_store_cursor_task_unref0 (_data_->task);
		_g_object_unref0 (_data_->cursor);
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_tracker_store_cursor_task_unref0 (_data_->task);
	_g_object_unref0 (_data_->cursor);
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_store_pre_update (void)
{
	gint _tmp0_;
	_tmp0_ = tracker_store_n_updates;
	tracker_store_n_updates = _tmp0_ + 1;
	tracker_store_update_state ();
	tracker_store_ensure_signal_timeout ();
}

static void
tracker_store_post_update (void)
{
	gint _tmp0_;
	_tmp0_ = tracker_store_n_updates;
	tracker_store_n_updates = _tmp0_ - 1;
	tracker_store_update_state ();
}

static void
tracker_store_sparql_update_data_free (gpointer _data)
{
	TrackerStoreSparqlUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->conn);
	_g_free0 (_data_->sparql);
	_g_free0 (_data_->client_id);
	g_slice_free (TrackerStoreSparqlUpdateData, _data_);
}

void
tracker_store_sparql_update (TrackerDirectConnection* conn,
                             const gchar* sparql,
                             gint priority,
                             const gchar* client_id,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	TrackerStoreSparqlUpdateData* _data_;
	TrackerDirectConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (sparql != NULL);
	g_return_if_fail (client_id != NULL);
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_update_data_free);
	_tmp0_ = _g_object_ref0 (conn);
	_g_object_unref0 (_data_->conn);
	_data_->conn = _tmp0_;
	_tmp1_ = g_strdup (sparql);
	_g_free0 (_data_->sparql);
	_data_->sparql = _tmp1_;
	_data_->priority = priority;
	_tmp2_ = g_strdup (client_id);
	_g_free0 (_data_->client_id);
	_data_->client_id = _tmp2_;
	tracker_store_sparql_update_co (_data_);
}

void
tracker_store_sparql_update_finish (GAsyncResult* _res_,
                                    GError** error)
{
	TrackerStoreSparqlUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
tracker_store_sparql_update_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	TrackerStoreSparqlUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_store_sparql_update_co (_data_);
}

static gboolean
tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!tracker_store_active) {
		_data_->_tmp0_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Store is not active");
		_data_->_inner_error0_ = _data_->_tmp0_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	tracker_store_pre_update ();
	_data_->_tmp1_ = tracker_store_create_cancellable (_data_->client_id);
	_data_->cancellable = _data_->_tmp1_;
	_data_->_state_ = 1;
	tracker_sparql_connection_update_async ((TrackerSparqlConnection*) _data_->conn, _data_->sparql, _data_->priority, _data_->cancellable, tracker_store_sparql_update_ready, _data_);
	return FALSE;
	_state_1:
	tracker_sparql_connection_update_finish ((TrackerSparqlConnection*) _data_->conn, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->cancellable);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	tracker_store_post_update ();
	_g_object_unref0 (_data_->cancellable);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_store_sparql_update_blank_data_free (gpointer _data)
{
	TrackerStoreSparqlUpdateBlankData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->conn);
	_g_free0 (_data_->sparql);
	_g_free0 (_data_->client_id);
	_g_variant_unref0 (_data_->result);
	g_slice_free (TrackerStoreSparqlUpdateBlankData, _data_);
}

void
tracker_store_sparql_update_blank (TrackerDirectConnection* conn,
                                   const gchar* sparql,
                                   gint priority,
                                   const gchar* client_id,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	TrackerStoreSparqlUpdateBlankData* _data_;
	TrackerDirectConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (sparql != NULL);
	g_return_if_fail (client_id != NULL);
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateBlankData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_update_blank_data_free);
	_tmp0_ = _g_object_ref0 (conn);
	_g_object_unref0 (_data_->conn);
	_data_->conn = _tmp0_;
	_tmp1_ = g_strdup (sparql);
	_g_free0 (_data_->sparql);
	_data_->sparql = _tmp1_;
	_data_->priority = priority;
	_tmp2_ = g_strdup (client_id);
	_g_free0 (_data_->client_id);
	_data_->client_id = _tmp2_;
	tracker_store_sparql_update_blank_co (_data_);
}

GVariant*
tracker_store_sparql_update_blank_finish (GAsyncResult* _res_,
                                          GError** error)
{
	GVariant* result;
	TrackerStoreSparqlUpdateBlankData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_store_sparql_update_blank_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	TrackerStoreSparqlUpdateBlankData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_store_sparql_update_blank_co (_data_);
}

static gboolean
tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!tracker_store_active) {
		_data_->_tmp0_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Store is not active");
		_data_->_inner_error0_ = _data_->_tmp0_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	tracker_store_pre_update ();
	_data_->_tmp1_ = tracker_store_create_cancellable (_data_->client_id);
	_data_->cancellable = _data_->_tmp1_;
	_data_->_state_ = 1;
	tracker_sparql_connection_update_blank_async ((TrackerSparqlConnection*) _data_->conn, _data_->sparql, _data_->priority, _data_->cancellable, tracker_store_sparql_update_blank_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = tracker_sparql_connection_update_blank_finish ((TrackerSparqlConnection*) _data_->conn, _data_->_res_, &_data_->_inner_error0_);
	_data_->nodes = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->cancellable);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	tracker_store_post_update ();
	_data_->result = _data_->nodes;
	_g_object_unref0 (_data_->cancellable);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_store_queue_turtle_import_data_free (gpointer _data)
{
	TrackerStoreQueueTurtleImportData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->conn);
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->client_id);
	g_slice_free (TrackerStoreQueueTurtleImportData, _data_);
}

void
tracker_store_queue_turtle_import (TrackerDirectConnection* conn,
                                   GFile* file,
                                   const gchar* client_id,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	TrackerStoreQueueTurtleImportData* _data_;
	TrackerDirectConnection* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (client_id != NULL);
	_data_ = g_slice_new0 (TrackerStoreQueueTurtleImportData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_queue_turtle_import_data_free);
	_tmp0_ = _g_object_ref0 (conn);
	_g_object_unref0 (_data_->conn);
	_data_->conn = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = g_strdup (client_id);
	_g_free0 (_data_->client_id);
	_data_->client_id = _tmp2_;
	tracker_store_queue_turtle_import_co (_data_);
}

void
tracker_store_queue_turtle_import_finish (GAsyncResult* _res_,
                                          GError** error)
{
	TrackerStoreQueueTurtleImportData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
tracker_store_queue_turtle_import_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	TrackerStoreQueueTurtleImportData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_store_queue_turtle_import_co (_data_);
}

static gboolean
tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!tracker_store_active) {
		_data_->_tmp0_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Store is not active");
		_data_->_inner_error0_ = _data_->_tmp0_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	tracker_store_pre_update ();
	_data_->_tmp1_ = tracker_store_create_cancellable (_data_->client_id);
	_data_->cancellable = _data_->_tmp1_;
	_data_->_state_ = 1;
	tracker_sparql_connection_load_async ((TrackerSparqlConnection*) _data_->conn, _data_->file, _data_->cancellable, tracker_store_queue_turtle_import_ready, _data_);
	return FALSE;
	_state_1:
	tracker_sparql_connection_load_finish ((TrackerSparqlConnection*) _data_->conn, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->cancellable);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	tracker_store_post_update ();
	_g_object_unref0 (_data_->cancellable);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
tracker_store_unreg_batches (const gchar* client_id)
{
	GCancellable* cancellable = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (client_id != NULL);
	_tmp0_ = tracker_store_client_cancellables;
	_tmp1_ = g_hash_table_lookup (_tmp0_, client_id);
	_tmp2_ = _g_object_ref0 ((GCancellable*) _tmp1_);
	cancellable = _tmp2_;
	_tmp3_ = cancellable;
	if (_tmp3_ != NULL) {
		GCancellable* _tmp4_;
		GHashTable* _tmp5_;
		_tmp4_ = cancellable;
		g_cancellable_cancel (_tmp4_);
		_tmp5_ = tracker_store_client_cancellables;
		g_hash_table_remove (_tmp5_, client_id);
		tracker_store_update_state ();
	}
	_g_object_unref0 (cancellable);
}

static void
tracker_store_pause_data_free (gpointer _data)
{
	TrackerStorePauseData* _data_;
	_data_ = _data;
	g_slice_free (TrackerStorePauseData, _data_);
}

void
tracker_store_pause (GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	TrackerStorePauseData* _data_;
	_data_ = g_slice_new0 (TrackerStorePauseData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_pause_data_free);
	tracker_store_pause_co (_data_);
}

void
tracker_store_pause_finish (GAsyncResult* _res_)
{
	TrackerStorePauseData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
tracker_store_pause_co (TrackerStorePauseData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	tracker_store_active = FALSE;
	_data_->_tmp0_ = tracker_main_get_sparql_connection ();
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->sparql_conn = _data_->_tmp1_;
	tracker_direct_connection_sync (_data_->sparql_conn);
	_g_object_unref0 (_data_->sparql_conn);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
tracker_store_resume (void)
{
	tracker_store_active = TRUE;
}

static void
tracker_store_update_state (void)
{
	gboolean cur_busy = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	if (!tracker_store_active) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = tracker_store_n_updates != 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GThreadPool* _tmp3_;
		_tmp3_ = tracker_store_cursor_pool;
		_tmp1_ = g_thread_pool_unprocessed (_tmp3_) > ((guint) 0);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GThreadPool* _tmp4_;
		_tmp4_ = tracker_store_cursor_pool;
		_tmp0_ = g_thread_pool_get_num_threads (_tmp4_) > ((guint) 0);
	}
	cur_busy = _tmp0_;
	if (tracker_store_busy == cur_busy) {
		return;
	}
	tracker_store_busy = cur_busy;
	if (tracker_store_busy) {
		TrackerStoreStateCallback _tmp5_;
		gpointer _tmp5__target;
		_tmp5_ = tracker_store_busy_cb;
		_tmp5__target = tracker_store_busy_cb_target;
		_tmp5_ (_tmp5__target);
	} else {
		TrackerStoreStateCallback _tmp6_;
		gpointer _tmp6__target;
		_tmp6_ = tracker_store_idle_cb;
		_tmp6__target = tracker_store_idle_cb_target;
		_tmp6_ (_tmp6__target);
	}
}

static void
tracker_store_on_statements_committed (void)
{
	tracker_events_transact ();
	tracker_writeback_transact ();
	tracker_store_check_graph_updated_signal ();
	tracker_store_update_state ();
}

static void
tracker_store_on_statements_rolled_back (void)
{
	tracker_events_reset_pending ();
	tracker_writeback_reset_pending ();
}

static gboolean
___lambda10_ (void)
{
	gboolean result;
	tracker_store_do_emit_signals ();
	result = FALSE;
	return result;
}

static gboolean
____lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda10_ ();
	return result;
}

static void
tracker_store_check_graph_updated_signal (void)
{
	if (tracker_events_get_total () > ((guint) TRACKER_STORE_GRAPH_UPDATED_IMMEDIATE_EMIT_AT)) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda10__gsource_func, NULL, NULL);
	}
}

static void
tracker_store_on_statement_inserted (gint graph_id,
                                     const gchar* graph,
                                     gint subject_id,
                                     const gchar* subject,
                                     gint pred_id,
                                     gint object_id,
                                     const gchar* object,
                                     GPtrArray* rdf_types)
{
	g_return_if_fail (subject != NULL);
	g_return_if_fail (rdf_types != NULL);
	tracker_events_add_insert (graph_id, subject_id, subject, pred_id, object_id, object, rdf_types);
	tracker_writeback_check (graph_id, graph, subject_id, subject, pred_id, object_id, object, rdf_types);
}

static void
tracker_store_on_statement_deleted (gint graph_id,
                                    const gchar* graph,
                                    gint subject_id,
                                    const gchar* subject,
                                    gint pred_id,
                                    gint object_id,
                                    const gchar* object,
                                    GPtrArray* rdf_types)
{
	g_return_if_fail (subject != NULL);
	g_return_if_fail (rdf_types != NULL);
	tracker_events_add_delete (graph_id, subject_id, subject, pred_id, object_id, object, rdf_types);
	tracker_writeback_check (graph_id, graph, subject_id, subject, pred_id, object_id, object, rdf_types);
}

static void
_tracker_store_on_statement_inserted_tracker_statement_callback (gint graph_id,
                                                                 const gchar* graph,
                                                                 gint subject_id,
                                                                 const gchar* subject,
                                                                 gint predicate_id,
                                                                 gint object_id,
                                                                 const gchar* object,
                                                                 GPtrArray* rdf_types,
                                                                 gpointer self)
{
	tracker_store_on_statement_inserted (graph_id, graph, subject_id, subject, predicate_id, object_id, object, rdf_types);
}

static void
_tracker_store_on_statement_deleted_tracker_statement_callback (gint graph_id,
                                                                const gchar* graph,
                                                                gint subject_id,
                                                                const gchar* subject,
                                                                gint predicate_id,
                                                                gint object_id,
                                                                const gchar* object,
                                                                GPtrArray* rdf_types,
                                                                gpointer self)
{
	tracker_store_on_statement_deleted (graph_id, graph, subject_id, subject, predicate_id, object_id, object, rdf_types);
}

static void
_tracker_store_on_statements_committed_tracker_commit_callback (gpointer self)
{
	tracker_store_on_statements_committed ();
}

static void
_tracker_store_on_statements_rolled_back_tracker_commit_callback (gpointer self)
{
	tracker_store_on_statements_rolled_back ();
}

void
tracker_store_enable_signals (void)
{
	TrackerDataManager* data_manager = NULL;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
	TrackerData* data = NULL;
	TrackerData* _tmp2_;
	TrackerData* _tmp3_;
	_tmp0_ = tracker_main_get_data_manager ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	data_manager = _tmp1_;
	_tmp2_ = tracker_data_manager_get_data (data_manager);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	data = _tmp3_;
	tracker_data_add_insert_statement_callback (data, _tracker_store_on_statement_inserted_tracker_statement_callback, NULL);
	tracker_data_add_delete_statement_callback (data, _tracker_store_on_statement_deleted_tracker_statement_callback, NULL);
	tracker_data_add_commit_statement_callback (data, _tracker_store_on_statements_committed_tracker_commit_callback, NULL);
	tracker_data_add_rollback_statement_callback (data, _tracker_store_on_statements_rolled_back_tracker_commit_callback, NULL);
	_g_object_unref0 (data);
	_g_object_unref0 (data_manager);
}

void
tracker_store_disable_signals (void)
{
	TrackerDataManager* data_manager = NULL;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
	TrackerData* data = NULL;
	TrackerData* _tmp2_;
	TrackerData* _tmp3_;
	_tmp0_ = tracker_main_get_data_manager ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	data_manager = _tmp1_;
	_tmp2_ = tracker_data_manager_get_data (data_manager);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	data = _tmp3_;
	tracker_data_remove_insert_statement_callback (data, _tracker_store_on_statement_inserted_tracker_statement_callback, NULL);
	tracker_data_remove_delete_statement_callback (data, _tracker_store_on_statement_deleted_tracker_statement_callback, NULL);
	tracker_data_remove_commit_statement_callback (data, _tracker_store_on_statements_committed_tracker_commit_callback, NULL);
	tracker_data_remove_rollback_statement_callback (data, _tracker_store_on_statements_rolled_back_tracker_commit_callback, NULL);
	_g_object_unref0 (data);
	_g_object_unref0 (data_manager);
}

void
tracker_store_set_signal_callback (TrackerStoreSignalEmissionFunc func,
                                   gpointer func_target)
{
	tracker_store_signal_callback = func;
	tracker_store_signal_callback_target = func_target;
}

TrackerStore*
tracker_store_construct (GType object_type)
{
	TrackerStore* self = NULL;
	self = (TrackerStore*) g_type_create_instance (object_type);
	return self;
}

TrackerStore*
tracker_store_new (void)
{
	return tracker_store_construct (TRACKER_TYPE_STORE);
}

static TrackerStoreCursorTask*
tracker_store_cursor_task_construct (GType object_type,
                                     TrackerSparqlCursor* cursor)
{
	TrackerStoreCursorTask* self = NULL;
	TrackerSparqlCursor* _tmp0_;
	g_return_val_if_fail (cursor != NULL, NULL);
	self = (TrackerStoreCursorTask*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (cursor);
	_g_object_unref0 (self->cursor);
	self->cursor = _tmp0_;
	return self;
}

static TrackerStoreCursorTask*
tracker_store_cursor_task_new (TrackerSparqlCursor* cursor)
{
	return tracker_store_cursor_task_construct (TRACKER_STORE_TYPE_CURSOR_TASK, cursor);
}

static void
tracker_store_value_cursor_task_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tracker_store_value_cursor_task_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tracker_store_cursor_task_unref (value->data[0].v_pointer);
	}
}

static void
tracker_store_value_cursor_task_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_store_cursor_task_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tracker_store_value_cursor_task_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tracker_store_value_cursor_task_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TrackerStoreCursorTask * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_store_cursor_task_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tracker_store_value_cursor_task_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	TrackerStoreCursorTask ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_store_cursor_task_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
tracker_store_param_spec_cursor_task (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	TrackerStoreParamSpecCursorTask* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_STORE_TYPE_CURSOR_TASK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
tracker_store_value_get_cursor_task (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_CURSOR_TASK), NULL);
	return value->data[0].v_pointer;
}

static void
tracker_store_value_set_cursor_task (GValue* value,
                                     gpointer v_object)
{
	TrackerStoreCursorTask * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_CURSOR_TASK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_CURSOR_TASK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_store_cursor_task_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_store_cursor_task_unref (old);
	}
}

static void
tracker_store_value_take_cursor_task (GValue* value,
                                      gpointer v_object)
{
	TrackerStoreCursorTask * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_CURSOR_TASK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_CURSOR_TASK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_store_cursor_task_unref (old);
	}
}

static void
tracker_store_cursor_task_class_init (TrackerStoreCursorTaskClass * klass,
                                      gpointer klass_data)
{
	tracker_store_cursor_task_parent_class = g_type_class_peek_parent (klass);
	((TrackerStoreCursorTaskClass *) klass)->finalize = tracker_store_cursor_task_finalize;
}

static void
tracker_store_cursor_task_instance_init (TrackerStoreCursorTask * self,
                                         gpointer klass)
{
	self->ref_count = 1;
}

static void
tracker_store_cursor_task_finalize (TrackerStoreCursorTask * obj)
{
	TrackerStoreCursorTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_CURSOR_TASK, TrackerStoreCursorTask);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->cursor);
	_g_error_free0 (self->error);
}

static GType
tracker_store_cursor_task_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tracker_store_value_cursor_task_init, tracker_store_value_cursor_task_free_value, tracker_store_value_cursor_task_copy_value, tracker_store_value_cursor_task_peek_pointer, "p", tracker_store_value_cursor_task_collect_value, "p", tracker_store_value_cursor_task_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreCursorTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_cursor_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreCursorTask), 0, (GInstanceInitFunc) tracker_store_cursor_task_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tracker_store_cursor_task_type_id;
	tracker_store_cursor_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStoreCursorTask", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tracker_store_cursor_task_type_id;
}

static GType
tracker_store_cursor_task_get_type (void)
{
	static volatile gsize tracker_store_cursor_task_type_id__once = 0;
	if (g_once_init_enter (&tracker_store_cursor_task_type_id__once)) {
		GType tracker_store_cursor_task_type_id;
		tracker_store_cursor_task_type_id = tracker_store_cursor_task_get_type_once ();
		g_once_init_leave (&tracker_store_cursor_task_type_id__once, tracker_store_cursor_task_type_id);
	}
	return tracker_store_cursor_task_type_id__once;
}

static gpointer
tracker_store_cursor_task_ref (gpointer instance)
{
	TrackerStoreCursorTask * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
tracker_store_cursor_task_unref (gpointer instance)
{
	TrackerStoreCursorTask * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_STORE_CURSOR_TASK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
tracker_value_store_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tracker_value_store_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tracker_store_unref (value->data[0].v_pointer);
	}
}

static void
tracker_value_store_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_store_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tracker_value_store_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tracker_value_store_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TrackerStore * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_store_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tracker_value_store_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	TrackerStore ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_store_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
tracker_param_spec_store (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	TrackerParamSpecStore* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_STORE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
tracker_value_get_store (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE), NULL);
	return value->data[0].v_pointer;
}

void
tracker_value_set_store (GValue* value,
                         gpointer v_object)
{
	TrackerStore * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_store_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_store_unref (old);
	}
}

void
tracker_value_take_store (GValue* value,
                          gpointer v_object)
{
	TrackerStore * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_store_unref (old);
	}
}

static void
tracker_store_class_init (TrackerStoreClass * klass,
                          gpointer klass_data)
{
	tracker_store_parent_class = g_type_class_peek_parent (klass);
	((TrackerStoreClass *) klass)->finalize = tracker_store_finalize;
}

static void
tracker_store_instance_init (TrackerStore * self,
                             gpointer klass)
{
	self->ref_count = 1;
}

static void
tracker_store_finalize (TrackerStore * obj)
{
	TrackerStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_STORE, TrackerStore);
	g_signal_handlers_destroy (self);
}

static GType
tracker_store_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tracker_value_store_init, tracker_value_store_free_value, tracker_value_store_copy_value, tracker_value_store_peek_pointer, "p", tracker_value_store_collect_value, "p", tracker_value_store_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStore), 0, (GInstanceInitFunc) tracker_store_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tracker_store_type_id;
	tracker_store_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStore", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tracker_store_type_id;
}

GType
tracker_store_get_type (void)
{
	static volatile gsize tracker_store_type_id__once = 0;
	if (g_once_init_enter (&tracker_store_type_id__once)) {
		GType tracker_store_type_id;
		tracker_store_type_id = tracker_store_get_type_once ();
		g_once_init_leave (&tracker_store_type_id__once, tracker_store_type_id);
	}
	return tracker_store_type_id__once;
}

gpointer
tracker_store_ref (gpointer instance)
{
	TrackerStore * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tracker_store_unref (gpointer instance)
{
	TrackerStore * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_STORE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

