/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jetty.client.util.AbstractTypedContentProvider;

public class ByteBufferContentProvider
extends AbstractTypedContentProvider {
    private final ByteBuffer[] buffers;
    private final int length;

    public ByteBufferContentProvider(ByteBuffer ... buffers2) {
        this("application/octet-stream", buffers2);
    }

    public ByteBufferContentProvider(String contentType, ByteBuffer ... buffers2) {
        super(contentType);
        this.buffers = buffers2;
        int length = 0;
        for (ByteBuffer buffer2 : buffers2) {
            length += buffer2.remaining();
        }
        this.length = length;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public boolean isReproducible() {
        return true;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new Iterator<ByteBuffer>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < ByteBufferContentProvider.this.buffers.length;
            }

            @Override
            public ByteBuffer next() {
                try {
                    ByteBuffer buffer2 = ByteBufferContentProvider.this.buffers[this.index];
                    ((ByteBufferContentProvider)ByteBufferContentProvider.this).buffers[this.index] = buffer2.slice();
                    ++this.index;
                    return buffer2;
                }
                catch (ArrayIndexOutOfBoundsException x) {
                    throw new NoSuchElementException();
                }
            }
        };
    }
}

