/* rygel-http-request.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-http-request.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <gio/gio.h>
#include <glib.h>
#include <libsoup/soup.h>
#include <glib-object.h>
#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

enum  {
	RYGEL_HTTP_REQUEST_0_PROPERTY,
	RYGEL_HTTP_REQUEST_CANCELLABLE_PROPERTY,
	RYGEL_HTTP_REQUEST_NUM_PROPERTIES
};
static GParamSpec* rygel_http_request_properties[RYGEL_HTTP_REQUEST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_CLIENT_HACKS_ERROR (rygel_client_hacks_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHttpRequestRunData RygelHttpRequestRunData;
typedef struct _RygelHttpRequestFindItemData RygelHttpRequestFindItemData;

struct _RygelHTTPRequestPrivate {
	RygelMediaContainer* root_container;
	GCancellable* _cancellable;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

struct _RygelHttpRequestRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelHTTPRequest* self;
	SoupServer* _tmp0_;
	SoupMessage* _tmp1_;
	RygelHTTPItemURI* _tmp2_;
	SoupMessage* _tmp3_;
	SoupURI* _tmp4_;
	SoupURI* _tmp5_;
	const gchar* _tmp6_;
	RygelHTTPServer* _tmp7_;
	RygelHTTPItemURI* _tmp8_;
	RygelHTTPItemURI* _tmp9_;
	GError* _error_;
	GError* _tmp10_;
	GError* _inner_error0_;
};

struct _RygelHttpRequestFindItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelHTTPRequest* self;
	RygelMediaObject* media_object;
	RygelMediaContainer* _tmp0_;
	RygelHTTPItemURI* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaObject* _tmp4_;
	gboolean _tmp5_;
	RygelMediaObject* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	RygelMediaObject* _tmp9_;
	RygelHTTPItemURI* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	RygelMediaObject* _tmp13_;
	RygelHTTPItemURI* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	RygelMediaObject* _tmp18_;
	RygelMediaObject* _tmp19_;
	GError* _inner_error0_;
};

static gint RygelHTTPRequest_private_offset;
static gpointer rygel_http_request_parent_class = NULL;
static RygelStateMachineIface * rygel_http_request_rygel_state_machine_parent_iface = NULL;

VALA_EXTERN GType rygel_client_hacks_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GQuark rygel_client_hacks_error_quark (void);
GType rygel_client_hacks_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelClientHacks* rygel_client_hacks_create (SoupMessage* message,
                                             GError** error);
static void rygel_http_request_real_run_data_free (gpointer _data);
static void rygel_http_request_real_run (RygelStateMachine* base,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static gboolean rygel_http_request_real_run_co (RygelHttpRequestRunData* _data_);
static void rygel_http_request_run_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void rygel_http_request_real_find_item_data_free (gpointer _data);
static void rygel_http_request_real_find_item (RygelHTTPRequest* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean rygel_http_request_real_find_item_co (RygelHttpRequestFindItemData* _data_);
static void rygel_http_request_find_item_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void rygel_http_request_finalize (GObject * obj);
static GType rygel_http_request_get_type_once (void);
static void _vala_rygel_http_request_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_rygel_http_request_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
rygel_http_request_error_quark (void)
{
	return g_quark_from_static_string ("rygel-http-request-error-quark");
}

static GType
rygel_http_request_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, "RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE", "unacceptable"}, {RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, "RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST", "bad-request"}, {RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND", "not-found"}, {RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR, "RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR", "internal-server-error"}, {0, NULL, NULL}};
	GType rygel_http_request_error_type_id;
	rygel_http_request_error_type_id = g_enum_register_static ("RygelHTTPRequestError", values);
	return rygel_http_request_error_type_id;
}

GType
rygel_http_request_error_get_type (void)
{
	static volatile gsize rygel_http_request_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_http_request_error_type_id__once)) {
		GType rygel_http_request_error_type_id;
		rygel_http_request_error_type_id = rygel_http_request_error_get_type_once ();
		g_once_init_leave (&rygel_http_request_error_type_id__once, rygel_http_request_error_type_id);
	}
	return rygel_http_request_error_type_id__once;
}

static inline gpointer
rygel_http_request_get_instance_private (RygelHTTPRequest* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPRequest_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelHTTPRequest*
rygel_http_request_construct (GType object_type,
                              RygelHTTPServer* http_server,
                              SoupServer* server,
                              SoupMessage* msg)
{
	RygelHTTPRequest * self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelMediaContainer* _tmp3_;
	SoupMessage* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (http_server != NULL, NULL);
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	self = (RygelHTTPRequest*) g_object_new (object_type, NULL);
	self->http_server = http_server;
	_tmp0_ = g_cancellable_new ();
	_tmp1_ = _tmp0_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = http_server->root_container;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->root_container);
	self->priv->root_container = _tmp3_;
	self->server = server;
	_tmp4_ = _g_object_ref0 (msg);
	_g_object_unref0 (self->msg);
	self->msg = _tmp4_;
	{
		RygelClientHacks* _tmp5_ = NULL;
		RygelClientHacks* _tmp6_;
		RygelClientHacks* _tmp7_;
		_tmp6_ = rygel_client_hacks_create (msg, &_inner_error0_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (self->hack);
		self->hack = _tmp7_;
		_g_object_unref0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

static void
rygel_http_request_real_run_data_free (gpointer _data)
{
	RygelHttpRequestRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpRequestRunData, _data_);
}

static void
rygel_http_request_real_run (RygelStateMachine* base,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	RygelHTTPRequest * self;
	RygelHttpRequestRunData* _data_;
	RygelHTTPRequest* _tmp0_;
	self = (RygelHTTPRequest*) base;
	_data_ = g_slice_new0 (RygelHttpRequestRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_http_request_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_request_real_run_co (_data_);
}

static void
rygel_http_request_run_finish (RygelStateMachine* base,
                               GAsyncResult* _res_)
{
	RygelHttpRequestRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_http_request_run_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	RygelHttpRequestRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_request_real_run_co (_data_);
}

static gboolean
rygel_http_request_real_run_co (RygelHttpRequestRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->server;
	_data_->_tmp1_ = _data_->self->msg;
	soup_server_pause_message (_data_->_tmp0_, _data_->_tmp1_);
	{
		_data_->_tmp3_ = _data_->self->msg;
		_data_->_tmp4_ = soup_message_get_uri (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = _data_->_tmp5_->path;
		_data_->_tmp7_ = _data_->self->http_server;
		_data_->_tmp8_ = rygel_http_item_uri_new_from_string (_data_->_tmp6_, _data_->_tmp7_, &_data_->_inner_error0_);
		_data_->_tmp2_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->_tmp2_;
		_data_->_tmp2_ = NULL;
		_g_object_unref0 (_data_->self->uri);
		_data_->self->uri = _data_->_tmp9_;
		_data_->_state_ = 1;
		rygel_http_request_find_item (_data_->self, rygel_http_request_run_ready, _data_);
		return FALSE;
		_state_1:
		rygel_http_request_find_item_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp2_);
			goto __catch0_g_error;
		}
		_data_->_state_ = 2;
		rygel_http_request_handle (_data_->self, rygel_http_request_run_ready, _data_);
		return FALSE;
		_state_2:
		rygel_http_request_handle_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp2_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->_error_;
		rygel_http_request_handle_error (_data_->self, _data_->_tmp10_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	rygel_state_machine_set_cancellable ((RygelStateMachine*) _data_->self, NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_http_request_handle (RygelHTTPRequest* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	RygelHTTPRequestClass* _klass_;
	_klass_ = RYGEL_HTTP_REQUEST_GET_CLASS (self);
	if (_klass_->handle) {
		_klass_->handle (self, _callback_, _user_data_);
	}
}

void
rygel_http_request_handle_finish (RygelHTTPRequest* self,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	RygelHTTPRequestClass* _klass_;
	_klass_ = RYGEL_HTTP_REQUEST_GET_CLASS (self);
	if (_klass_->handle_finish) {
		_klass_->handle_finish (self, _res_, error);
	}
}

static void
rygel_http_request_real_find_item_data_free (gpointer _data)
{
	RygelHttpRequestFindItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpRequestFindItemData, _data_);
}

static void
rygel_http_request_real_find_item (RygelHTTPRequest* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	RygelHttpRequestFindItemData* _data_;
	RygelHTTPRequest* _tmp0_;
	_data_ = g_slice_new0 (RygelHttpRequestFindItemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_http_request_real_find_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_request_real_find_item_co (_data_);
}

static void
rygel_http_request_real_find_item_finish (RygelHTTPRequest* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	RygelHttpRequestFindItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_http_request_find_item_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	RygelHttpRequestFindItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_request_real_find_item_co (_data_);
}

static gboolean
rygel_http_request_real_find_item_co (RygelHttpRequestFindItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->root_container;
	_data_->_tmp1_ = _data_->self->uri;
	_data_->_tmp2_ = rygel_http_item_uri_get_item_id (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_state_ = 1;
	rygel_media_container_find_object (_data_->_tmp0_, _data_->_tmp3_, NULL, rygel_http_request_find_item_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = rygel_media_container_find_object_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	_data_->media_object = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->media_object;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp5_ = TRUE;
	} else {
		_data_->_tmp9_ = _data_->media_object;
		if (RYGEL_IS_MEDIA_CONTAINER (_data_->_tmp9_)) {
			_data_->_tmp10_ = _data_->self->uri;
			_data_->_tmp11_ = rygel_http_item_uri_get_resource_name (_data_->_tmp10_);
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp8_ = _data_->_tmp12_ != NULL;
		} else {
			_data_->_tmp8_ = FALSE;
		}
		if (_data_->_tmp8_) {
			_data_->_tmp7_ = TRUE;
		} else {
			_data_->_tmp13_ = _data_->media_object;
			_data_->_tmp7_ = RYGEL_IS_MEDIA_FILE_ITEM (_data_->_tmp13_);
		}
		_data_->_tmp5_ = !_data_->_tmp7_;
	}
	if (_data_->_tmp5_) {
		_data_->_tmp14_ = _data_->self->uri;
		_data_->_tmp15_ = rygel_http_item_uri_get_item_id (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _ ("Requested item “%s” not found"), _data_->_tmp16_);
		_data_->_inner_error0_ = _data_->_tmp17_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->media_object);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->media_object;
	_data_->_tmp19_ = _g_object_ref0 (_data_->_tmp18_);
	_g_object_unref0 (_data_->self->object);
	_data_->self->object = _data_->_tmp19_;
	_g_object_unref0 (_data_->media_object);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_http_request_find_item (RygelHTTPRequest* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	RygelHTTPRequestClass* _klass_;
	_klass_ = RYGEL_HTTP_REQUEST_GET_CLASS (self);
	if (_klass_->find_item) {
		_klass_->find_item (self, _callback_, _user_data_);
	}
}

void
rygel_http_request_find_item_finish (RygelHTTPRequest* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	RygelHTTPRequestClass* _klass_;
	_klass_ = RYGEL_HTTP_REQUEST_GET_CLASS (self);
	if (_klass_->find_item_finish) {
		_klass_->find_item_finish (self, _res_, error);
	}
}

void
rygel_http_request_handle_error (RygelHTTPRequest* self,
                                 GError* _error_)
{
	const gchar* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
	guint status = 0U;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_error_ != NULL);
	_tmp0_ = _error_->message;
	g_warning ("rygel-http-request.vala:103: %s", _tmp0_);
	_tmp1_ = self->server;
	_tmp2_ = self->msg;
	soup_server_unpause_message (_tmp1_, _tmp2_);
	if (_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
		status = (guint) _error_->code;
	} else {
		status = (guint) SOUP_STATUS_NOT_FOUND;
	}
	_tmp3_ = _error_->message;
	rygel_http_request_end (self, status, _tmp3_);
}

void
rygel_http_request_end (RygelHTTPRequest* self,
                        guint status,
                        const gchar* reason)
{
	g_return_if_fail (self != NULL);
	if (status != ((guint) SOUP_STATUS_NONE)) {
		if (reason == NULL) {
			SoupMessage* _tmp0_;
			_tmp0_ = self->msg;
			soup_message_set_status (_tmp0_, status);
		} else {
			SoupMessage* _tmp1_;
			_tmp1_ = self->msg;
			soup_message_set_status_full (_tmp1_, status, reason);
		}
	}
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}

static GCancellable*
rygel_http_request_real_get_cancellable (RygelStateMachine* base)
{
	GCancellable* result;
	RygelHTTPRequest* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPRequest*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

static void
rygel_http_request_real_set_cancellable (RygelStateMachine* base,
                                         GCancellable* value)
{
	RygelHTTPRequest* self;
	GCancellable* old_value;
	self = (RygelHTTPRequest*) base;
	old_value = rygel_http_request_real_get_cancellable (base);
	if (old_value != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_request_properties[RYGEL_HTTP_REQUEST_CANCELLABLE_PROPERTY]);
	}
}

static void
rygel_http_request_class_init (RygelHTTPRequestClass * klass,
                               gpointer klass_data)
{
	rygel_http_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPRequest_private_offset);
	((RygelHTTPRequestClass *) klass)->find_item = (void (*) (RygelHTTPRequest*, GAsyncReadyCallback, gpointer)) rygel_http_request_real_find_item;
	((RygelHTTPRequestClass *) klass)->find_item_finish = (void (*) (RygelHTTPRequest*, GAsyncResult*, GError**)) rygel_http_request_real_find_item_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_request_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_REQUEST_CANCELLABLE_PROPERTY, rygel_http_request_properties[RYGEL_HTTP_REQUEST_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_http_request_rygel_state_machine_interface_init (RygelStateMachineIface * iface,
                                                       gpointer iface_data)
{
	rygel_http_request_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*) (RygelStateMachine*, GAsyncReadyCallback, gpointer)) rygel_http_request_real_run;
	iface->run_finish = (void (*) (RygelStateMachine*, GAsyncResult*)) rygel_http_request_run_finish;
	iface->get_cancellable = rygel_http_request_real_get_cancellable;
	iface->set_cancellable = rygel_http_request_real_set_cancellable;
}

static void
rygel_http_request_instance_init (RygelHTTPRequest * self,
                                  gpointer klass)
{
	self->priv = rygel_http_request_get_instance_private (self);
}

static void
rygel_http_request_finalize (GObject * obj)
{
	RygelHTTPRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest);
	_g_object_unref0 (self->priv->root_container);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->uri);
	_g_object_unref0 (self->object);
	_g_object_unref0 (self->hack);
	G_OBJECT_CLASS (rygel_http_request_parent_class)->finalize (obj);
}

/**
 * Base class for HTTP client requests.
 */
static GType
rygel_http_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPRequest), 0, (GInstanceInitFunc) rygel_http_request_instance_init, NULL };
	static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_request_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_http_request_type_id;
	rygel_http_request_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPRequest", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (rygel_http_request_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	RygelHTTPRequest_private_offset = g_type_add_instance_private (rygel_http_request_type_id, sizeof (RygelHTTPRequestPrivate));
	return rygel_http_request_type_id;
}

GType
rygel_http_request_get_type (void)
{
	static volatile gsize rygel_http_request_type_id__once = 0;
	if (g_once_init_enter (&rygel_http_request_type_id__once)) {
		GType rygel_http_request_type_id;
		rygel_http_request_type_id = rygel_http_request_get_type_once ();
		g_once_init_leave (&rygel_http_request_type_id__once, rygel_http_request_type_id);
	}
	return rygel_http_request_type_id__once;
}

static void
_vala_rygel_http_request_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	RygelHTTPRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest);
	switch (property_id) {
		case RYGEL_HTTP_REQUEST_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_http_request_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	RygelHTTPRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest);
	switch (property_id) {
		case RYGEL_HTTP_REQUEST_CANCELLABLE_PROPERTY:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

