/* rygel-media-file-item.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-media-file-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include "rygel-core.h"

#define RYGEL_TYPE_MEDIA_FILE_ITEM_ERROR (rygel_media_file_item_error_get_type ())
enum  {
	RYGEL_MEDIA_FILE_ITEM_0_PROPERTY,
	RYGEL_MEDIA_FILE_ITEM_MIME_TYPE_PROPERTY,
	RYGEL_MEDIA_FILE_ITEM_DLNA_PROFILE_PROPERTY,
	RYGEL_MEDIA_FILE_ITEM_SIZE_PROPERTY,
	RYGEL_MEDIA_FILE_ITEM_PLACE_HOLDER_PROPERTY,
	RYGEL_MEDIA_FILE_ITEM_OCM_FLAGS_PROPERTY,
	RYGEL_MEDIA_FILE_ITEM_NUM_PROPERTIES
};
static GParamSpec* rygel_media_file_item_properties[RYGEL_MEDIA_FILE_ITEM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaFileItemAddEngineResourcesData RygelMediaFileItemAddEngineResourcesData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

typedef enum  {
	RYGEL_MEDIA_FILE_ITEM_ERROR_BAD_URI
} RygelMediaFileItemError;
#define RYGEL_MEDIA_FILE_ITEM_ERROR rygel_media_file_item_error_quark ()

struct _RygelMediaFileItemPrivate {
	gchar* _mime_type;
	gchar* _dlna_profile;
	gint64 _size;
	gboolean _place_holder;
};

struct _RygelMediaFileItemAddEngineResourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaFileItem* self;
	RygelMediaEngine* media_engine;
	RygelMediaEngine* _tmp0_;
	GeeList* added_resources;
	RygelMediaEngine* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeList* _resource_list;
	GeeList* _tmp8_;
	gint _resource_size;
	GeeList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _resource_index;
	gint _tmp12_;
	gint _tmp13_;
	RygelMediaResource* resource;
	GeeList* _tmp14_;
	gpointer _tmp15_;
	RygelMediaResource* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GeeList* _tmp19_;
	GeeList* _tmp20_;
	GeeList* _tmp21_;
};

static gint RygelMediaFileItem_private_offset;
static gpointer rygel_media_file_item_parent_class = NULL;
GRegex* rygel_media_file_item_address_regex = NULL;
GeeHashMap* rygel_media_file_item_mime_to_ext = NULL;

VALA_EXTERN GQuark rygel_media_file_item_error_quark (void);
GType rygel_media_file_item_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void rygel_media_file_item_add_additional_resources (RygelMediaFileItem* self,
                                                     RygelHTTPServer* server);
static RygelDataSource* rygel_media_file_item_real_create_stream_source_for_resource (RygelMediaObject* base,
                                                                               RygelHTTPRequest* request,
                                                                               RygelMediaResource* resource,
                                                                               GError** error);
static GUPnPDIDLLiteObject* rygel_media_file_item_real_serialize (RygelMediaObject* base,
                                                           RygelSerializer* serializer,
                                                           RygelHTTPServer* http_server,
                                                           GError** error);
static RygelMediaResource* rygel_media_file_item_real_get_primary_resource (RygelMediaFileItem* self);
VALA_EXTERN gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self,
                                                const gchar* uri,
                                                GError** error);
static gchar* rygel_media_file_item_real_get_extension (RygelMediaFileItem* self);
static void rygel_media_file_item_real_add_engine_resources_data_free (gpointer _data);
static void rygel_media_file_item_real_add_engine_resources (RygelMediaFileItem* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean rygel_media_file_item_real_add_engine_resources_co (RygelMediaFileItemAddEngineResourcesData* _data_);
static void rygel_media_file_item_add_engine_resources_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void rygel_media_file_item_real_add_additional_resources (RygelMediaFileItem* self,
                                                          RygelHTTPServer* server);
static void rygel_media_file_item_finalize (GObject * obj);
static GType rygel_media_file_item_get_type_once (void);
static void _vala_rygel_media_file_item_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_rygel_media_file_item_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
rygel_media_file_item_error_quark (void)
{
	return g_quark_from_static_string ("rygel-media-file-item-error-quark");
}

static GType
rygel_media_file_item_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_MEDIA_FILE_ITEM_ERROR_BAD_URI, "RYGEL_MEDIA_FILE_ITEM_ERROR_BAD_URI", "bad-uri"}, {0, NULL, NULL}};
	GType rygel_media_file_item_error_type_id;
	rygel_media_file_item_error_type_id = g_enum_register_static ("RygelMediaFileItemError", values);
	return rygel_media_file_item_error_type_id;
}

GType
rygel_media_file_item_error_get_type (void)
{
	static volatile gsize rygel_media_file_item_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_file_item_error_type_id__once)) {
		GType rygel_media_file_item_error_type_id;
		rygel_media_file_item_error_type_id = rygel_media_file_item_error_get_type_once ();
		g_once_init_leave (&rygel_media_file_item_error_type_id__once, rygel_media_file_item_error_type_id);
	}
	return rygel_media_file_item_error_type_id__once;
}

static inline gpointer
rygel_media_file_item_get_instance_private (RygelMediaFileItem* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaFileItem_private_offset);
}

RygelMediaFileItem*
rygel_media_file_item_construct (GType object_type,
                                 const gchar* id,
                                 RygelMediaContainer* parent,
                                 const gchar* title,
                                 const gchar* upnp_class)
{
	RygelMediaFileItem * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	self = (RygelMediaFileItem*) g_object_new (object_type, "id", id, "parent", parent, "title", title, "upnp-class", upnp_class, NULL);
	return self;
}

static RygelDataSource*
rygel_media_file_item_real_create_stream_source_for_resource (RygelMediaObject* base,
                                                              RygelHTTPRequest* request,
                                                              RygelMediaResource* resource,
                                                              GError** error)
{
	RygelMediaFileItem * self;
	RygelDataSource* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_;
	RygelMediaEngine* _tmp2_;
	RygelHTTPServer* _tmp3_;
	GHashTable* _tmp4_;
	RygelDataSource* _tmp5_;
	RygelDataSource* _tmp6_;
	RygelDataSource* _tmp7_;
	GError* _inner_error0_ = NULL;
	RygelDataSource* result;
	self = (RygelMediaFileItem*) base;
	g_return_val_if_fail (request != NULL, NULL);
	g_return_val_if_fail (resource != NULL, NULL);
	_tmp1_ = rygel_media_engine_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = request->http_server;
	_tmp4_ = _tmp3_->replacements;
	_tmp5_ = rygel_media_engine_create_data_source_for_resource (_tmp2_, (RygelMediaObject*) self, resource, _tmp4_, &_inner_error0_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	_tmp0_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp7_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp7_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GUPnPDIDLLiteObject*
rygel_media_file_item_real_serialize (RygelMediaObject* base,
                                      RygelSerializer* serializer,
                                      RygelHTTPServer* http_server,
                                      GError** error)
{
	RygelMediaFileItem * self;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_;
	GUPnPDIDLLiteItem* didl_item = NULL;
	GUPnPDIDLLiteItem* _tmp2_;
	gboolean _tmp3_;
	GUPnPDIDLLiteItem* _tmp4_;
	GError* _inner_error0_ = NULL;
	GUPnPDIDLLiteObject* result;
	self = (RygelMediaFileItem*) base;
	g_return_val_if_fail (serializer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp1_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_media_file_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem), serializer, http_server, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gupnp_didl_lite_item_get_type ()) ? ((GUPnPDIDLLiteItem*) _tmp0_) : NULL);
	didl_item = _tmp2_;
	_tmp3_ = self->priv->_place_holder;
	if (!_tmp3_) {
		rygel_media_file_item_add_additional_resources (self, http_server);
	}
	_tmp4_ = didl_item;
	rygel_media_object_serialize_resource_list ((RygelMediaObject*) self, (GUPnPDIDLLiteObject*) _tmp4_, http_server, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (didl_item);
		_g_object_unref0 (_tmp0_);
		return NULL;
	}
	result = (GUPnPDIDLLiteObject*) didl_item;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Subclasses override this method to create the type-specific primary
     * MediaResource.
     *
     * The resource returned is presumed to represent the "internal" file
     * resource and a uri referring to the source file. Transport-specific
     * variants can be created by the caller.
     *
     * @return a RygelMediaResource for the on-disk file represented by this
     * instance.
     */
static RygelMediaResource*
rygel_media_file_item_real_get_primary_resource (RygelMediaFileItem* self)
{
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gint64 _tmp13_;
	gint64 _tmp14_;
	GError* _inner_error0_ = NULL;
	RygelMediaResource* result;
	_tmp0_ = rygel_media_resource_new ("primary");
	res = _tmp0_;
	_tmp1_ = self->priv->_mime_type;
	rygel_media_resource_set_mime_type (res, _tmp1_);
	_tmp2_ = self->priv->_dlna_profile;
	rygel_media_resource_set_dlna_profile (res, _tmp2_);
	rygel_media_resource_set_dlna_flags (res, GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
	rygel_media_resource_set_dlna_operation (res, GUPNP_DLNA_OPERATION_RANGE);
	_tmp3_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) self);
	_tmp4_ = _tmp3_;
	rygel_media_resource_set_uri (res, _tmp4_);
	_g_free0 (_tmp4_);
	{
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = rygel_media_resource_get_uri (res);
		_tmp7_ = _tmp6_;
		_tmp8_ = rygel_media_object_get_protocol_for_uri ((RygelMediaObject*) self, _tmp7_, &_inner_error0_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		rygel_media_resource_set_protocol (res, _tmp5_);
		_g_free0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		g_clear_error (&_inner_error0_);
		_tmp9_ = rygel_media_resource_get_uri (res);
		_tmp10_ = _tmp9_;
		g_warning (_ ("Could not determine protocol for URI %s"), _tmp10_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (res);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp11_ = rygel_media_file_item_get_extension (self);
	_tmp12_ = _tmp11_;
	rygel_media_resource_set_extension (res, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = rygel_media_file_item_get_size (self);
	_tmp14_ = _tmp13_;
	rygel_media_resource_set_size (res, _tmp14_);
	result = res;
	return result;
}

RygelMediaResource*
rygel_media_file_item_get_primary_resource (RygelMediaFileItem* self)
{
	RygelMediaFileItemClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_MEDIA_FILE_ITEM_GET_CLASS (self);
	if (_klass_->get_primary_resource) {
		return _klass_->get_primary_resource (self);
	}
	return NULL;
}

/**
     * Return the file/uri extension that best represents the item's primary
     * resource.
     */
static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
rygel_media_file_item_real_get_extension (RygelMediaFileItem* self)
{
	gchar* uri_extension = NULL;
	gchar* basename = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint dot_index = 0;
	const gchar* _tmp4_;
	const gchar* _tmp8_;
	gchar* result;
	uri_extension = NULL;
	_tmp0_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_path_get_basename (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	basename = _tmp3_;
	dot_index = -1;
	_tmp4_ = basename;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = basename;
		dot_index = string_last_index_of (_tmp5_, ".", 0);
		if (dot_index > -1) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = basename;
			_tmp7_ = string_substring (_tmp6_, (glong) (dot_index + 1), (glong) -1);
			_g_free0 (uri_extension);
			uri_extension = _tmp7_;
		}
	}
	_tmp8_ = uri_extension;
	if (_tmp8_ == NULL) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = self->priv->_mime_type;
		_tmp10_ = rygel_media_file_item_ext_from_mime_type (self, _tmp9_);
		_g_free0 (uri_extension);
		uri_extension = _tmp10_;
	}
	result = uri_extension;
	_g_free0 (basename);
	return result;
}

gchar*
rygel_media_file_item_get_extension (RygelMediaFileItem* self)
{
	RygelMediaFileItemClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_MEDIA_FILE_ITEM_GET_CLASS (self);
	if (_klass_->get_extension) {
		return _klass_->get_extension (self);
	}
	return NULL;
}

gchar*
rygel_media_file_item_ext_from_mime_type (RygelMediaFileItem* self,
                                          const gchar* mime_type)
{
	GeeHashMap* _tmp0_;
	gchar* short_mime = NULL;
	gchar** _tmp37_;
	gchar** _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GeeHashMap* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp48_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	_tmp0_ = rygel_media_file_item_mime_to_ext;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		gchar** videos = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gint videos_length1;
		gint _videos_size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		GeeHashMap* _tmp14_;
		GeeHashMap* _tmp15_;
		GeeHashMap* _tmp16_;
		GeeHashMap* _tmp17_;
		GeeHashMap* _tmp18_;
		GeeHashMap* _tmp19_;
		GeeHashMap* _tmp20_;
		GeeHashMap* _tmp21_;
		GeeHashMap* _tmp22_;
		GeeHashMap* _tmp23_;
		gchar** images = NULL;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar** _tmp26_;
		gint images_length1;
		gint _images_size_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		GeeHashMap* _tmp34_;
		GeeHashMap* _tmp35_;
		GeeHashMap* _tmp36_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (rygel_media_file_item_mime_to_ext);
		rygel_media_file_item_mime_to_ext = _tmp1_;
		_tmp2_ = g_strdup ("mpeg");
		_tmp3_ = g_strdup ("webm");
		_tmp4_ = g_strdup ("ogg");
		_tmp5_ = g_strdup ("mp4");
		_tmp6_ = g_new0 (gchar*, 4 + 1);
		_tmp6_[0] = _tmp2_;
		_tmp6_[1] = _tmp3_;
		_tmp6_[2] = _tmp4_;
		_tmp6_[3] = _tmp5_;
		videos = _tmp6_;
		videos_length1 = 4;
		_videos_size_ = videos_length1;
		_tmp7_ = videos;
		_tmp7__length1 = videos_length1;
		{
			gchar** video_collection = NULL;
			gint video_collection_length1 = 0;
			gint _video_collection_size_ = 0;
			gint video_it = 0;
			video_collection = _tmp7_;
			video_collection_length1 = _tmp7__length1;
			for (video_it = 0; video_it < video_collection_length1; video_it = video_it + 1) {
				gchar* _tmp8_;
				gchar* video = NULL;
				_tmp8_ = g_strdup (video_collection[video_it]);
				video = _tmp8_;
				{
					GeeHashMap* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					const gchar* _tmp13_;
					_tmp9_ = rygel_media_file_item_mime_to_ext;
					_tmp10_ = video;
					_tmp11_ = g_strconcat ("video/", _tmp10_, NULL);
					_tmp12_ = _tmp11_;
					_tmp13_ = video;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, _tmp12_, _tmp13_);
					_g_free0 (_tmp12_);
					_g_free0 (video);
				}
			}
		}
		_tmp14_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, "video/x-matroska", "mkv");
		_tmp15_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "video/x-mkv", "mkv");
		_tmp16_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, "audio/x-wav", "wav");
		_tmp17_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, "audio/x-matroska", "mka");
		_tmp18_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, "audio/x-mkv", "mka");
		_tmp19_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, "audio/x-mka", "mka");
		_tmp20_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, "audio/L16", "lpcm");
		_tmp21_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, "audio/vnd.dlna.adts", "adts");
		_tmp22_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, "audio/mpeg", "mp3");
		_tmp23_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, "audio/3gpp", "3gp");
		_tmp24_ = g_strdup ("jpeg");
		_tmp25_ = g_strdup ("png");
		_tmp26_ = g_new0 (gchar*, 2 + 1);
		_tmp26_[0] = _tmp24_;
		_tmp26_[1] = _tmp25_;
		images = _tmp26_;
		images_length1 = 2;
		_images_size_ = images_length1;
		_tmp27_ = images;
		_tmp27__length1 = images_length1;
		{
			gchar** image_collection = NULL;
			gint image_collection_length1 = 0;
			gint _image_collection_size_ = 0;
			gint image_it = 0;
			image_collection = _tmp27_;
			image_collection_length1 = _tmp27__length1;
			for (image_it = 0; image_it < image_collection_length1; image_it = image_it + 1) {
				gchar* _tmp28_;
				gchar* image = NULL;
				_tmp28_ = g_strdup (image_collection[image_it]);
				image = _tmp28_;
				{
					GeeHashMap* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					const gchar* _tmp33_;
					_tmp29_ = rygel_media_file_item_mime_to_ext;
					_tmp30_ = image;
					_tmp31_ = g_strconcat ("image/", _tmp30_, NULL);
					_tmp32_ = _tmp31_;
					_tmp33_ = image;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, _tmp32_, _tmp33_);
					_g_free0 (_tmp32_);
					_g_free0 (image);
				}
			}
		}
		_tmp34_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp34_, "text/srt", "srt");
		_tmp35_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp35_, "text/xml", "xml");
		_tmp36_ = rygel_media_file_item_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp36_, "application/ogg", "ogg");
		images = (_vala_array_free (images, images_length1, (GDestroyNotify) g_free), NULL);
		videos = (_vala_array_free (videos, videos_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp38_ = _tmp37_ = g_strsplit (mime_type, ";", 0);
	_tmp39_ = _tmp38_;
	_tmp39__length1 = _vala_array_length (_tmp37_);
	_tmp40_ = _tmp39_[0];
	_tmp41_ = g_strdup (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
	short_mime = _tmp42_;
	_tmp43_ = rygel_media_file_item_mime_to_ext;
	_tmp44_ = short_mime;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp43_, _tmp44_)) {
		GeeHashMap* _tmp45_;
		const gchar* _tmp46_;
		gpointer _tmp47_;
		_tmp45_ = rygel_media_file_item_mime_to_ext;
		_tmp46_ = short_mime;
		_tmp47_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp45_, _tmp46_);
		result = (gchar*) _tmp47_;
		_g_free0 (short_mime);
		return result;
	}
	_tmp48_ = g_strdup ("");
	result = _tmp48_;
	_g_free0 (short_mime);
	return result;
}

static void
rygel_media_file_item_real_add_engine_resources_data_free (gpointer _data)
{
	RygelMediaFileItemAddEngineResourcesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaFileItemAddEngineResourcesData, _data_);
}

static void
rygel_media_file_item_real_add_engine_resources (RygelMediaFileItem* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	RygelMediaFileItemAddEngineResourcesData* _data_;
	RygelMediaFileItem* _tmp0_;
	_data_ = g_slice_new0 (RygelMediaFileItemAddEngineResourcesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_file_item_real_add_engine_resources_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_file_item_real_add_engine_resources_co (_data_);
}

static void
rygel_media_file_item_real_add_engine_resources_finish (RygelMediaFileItem* self,
                                                        GAsyncResult* _res_)
{
	RygelMediaFileItemAddEngineResourcesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Request the media engine for the resources it can provide for this
     * item. Typically these are the transcoded resources.
     */
static void
rygel_media_file_item_add_engine_resources_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	RygelMediaFileItemAddEngineResourcesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_file_item_real_add_engine_resources_co (_data_);
}

static gboolean
rygel_media_file_item_real_add_engine_resources_co (RygelMediaFileItemAddEngineResourcesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_media_engine_get_default ();
	_data_->media_engine = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->media_engine;
	_data_->_state_ = 1;
	rygel_media_engine_get_resources_for_item (_data_->_tmp1_, (RygelMediaObject*) _data_->self, rygel_media_file_item_add_engine_resources_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = rygel_media_engine_get_resources_for_item_finish (_data_->_tmp1_, _data_->_res_);
	_data_->added_resources = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->added_resources;
	_data_->_tmp4_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = rygel_media_object_get_primary_uri ((RygelMediaObject*) _data_->self);
	_data_->_tmp7_ = _data_->_tmp6_;
	g_debug ("rygel-media-file-item.vala:266: Adding %d resources to item source %s:", _data_->_tmp5_, _data_->_tmp7_);
	_g_free0 (_data_->_tmp7_);
	{
		_data_->_tmp8_ = _data_->added_resources;
		_data_->_resource_list = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->_resource_list;
		_data_->_tmp10_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_resource_size = _data_->_tmp11_;
		_data_->_resource_index = -1;
		while (TRUE) {
			_data_->_resource_index = _data_->_resource_index + 1;
			_data_->_tmp12_ = _data_->_resource_index;
			_data_->_tmp13_ = _data_->_resource_size;
			if (!(_data_->_tmp12_ < _data_->_tmp13_)) {
				break;
			}
			_data_->_tmp14_ = _data_->_resource_list;
			_data_->_tmp15_ = gee_list_get (_data_->_tmp14_, _data_->_resource_index);
			_data_->resource = (RygelMediaResource*) _data_->_tmp15_;
			_data_->_tmp16_ = _data_->resource;
			_data_->_tmp17_ = rygel_media_resource_get_name (_data_->_tmp16_);
			_data_->_tmp18_ = _data_->_tmp17_;
			g_debug ("rygel-media-file-item.vala:271:     %s", _data_->_tmp18_);
			_g_free0 (_data_->_tmp18_);
			_g_object_unref0 (_data_->resource);
		}
	}
	_data_->_tmp19_ = rygel_media_object_get_resource_list ((RygelMediaObject*) _data_->self);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = _data_->added_resources;
	gee_collection_add_all ((GeeCollection*) _data_->_tmp20_, (GeeCollection*) _data_->_tmp21_);
	_g_object_unref0 (_data_->_tmp20_);
	_g_object_unref0 (_data_->added_resources);
	_g_object_unref0 (_data_->media_engine);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_media_file_item_add_engine_resources (RygelMediaFileItem* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	RygelMediaFileItemClass* _klass_;
	_klass_ = RYGEL_MEDIA_FILE_ITEM_GET_CLASS (self);
	if (_klass_->add_engine_resources) {
		_klass_->add_engine_resources (self, _callback_, _user_data_);
	}
}

void
rygel_media_file_item_add_engine_resources_finish (RygelMediaFileItem* self,
                                                   GAsyncResult* _res_)
{
	RygelMediaFileItemClass* _klass_;
	_klass_ = RYGEL_MEDIA_FILE_ITEM_GET_CLASS (self);
	if (_klass_->add_engine_resources_finish) {
		_klass_->add_engine_resources_finish (self, _res_);
	}
}

/**
     * Subclasses can override this method to augment the MediaObject MediaResource
     * list with secondary MediaResource objects representing derivative resources.
     *
     * Note: Implementations should add both internal/file-based resources and HTTP-accessible
     *       resources to the MediaResource list.
     * FIXME: Will be renamed once we can safely remove old add_resources
     */
static void
rygel_media_file_item_real_add_additional_resources (RygelMediaFileItem* self,
                                                     RygelHTTPServer* server)
{
	g_return_if_fail (server != NULL);
}

void
rygel_media_file_item_add_additional_resources (RygelMediaFileItem* self,
                                                RygelHTTPServer* server)
{
	RygelMediaFileItemClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = RYGEL_MEDIA_FILE_ITEM_GET_CLASS (self);
	if (_klass_->add_additional_resources) {
		_klass_->add_additional_resources (self, server);
	}
}

const gchar*
rygel_media_file_item_get_mime_type (RygelMediaFileItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mime_type;
	result = _tmp0_;
	return result;
}

void
rygel_media_file_item_set_mime_type (RygelMediaFileItem* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_file_item_get_mime_type (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mime_type);
		self->priv->_mime_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_file_item_properties[RYGEL_MEDIA_FILE_ITEM_MIME_TYPE_PROPERTY]);
	}
}

const gchar*
rygel_media_file_item_get_dlna_profile (RygelMediaFileItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dlna_profile;
	result = _tmp0_;
	return result;
}

void
rygel_media_file_item_set_dlna_profile (RygelMediaFileItem* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_file_item_get_dlna_profile (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_dlna_profile);
		self->priv->_dlna_profile = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_file_item_properties[RYGEL_MEDIA_FILE_ITEM_DLNA_PROFILE_PROPERTY]);
	}
}

gint64
rygel_media_file_item_get_size (RygelMediaFileItem* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_size;
	return result;
}

void
rygel_media_file_item_set_size (RygelMediaFileItem* self,
                                gint64 value)
{
	g_return_if_fail (self != NULL);
	if (value == ((gint64) 0)) {
		rygel_media_file_item_set_place_holder (self, TRUE);
	}
	self->priv->_size = value;
	g_object_notify_by_pspec ((GObject *) self, rygel_media_file_item_properties[RYGEL_MEDIA_FILE_ITEM_SIZE_PROPERTY]);
}

gboolean
rygel_media_file_item_get_place_holder (RygelMediaFileItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_place_holder;
	return result;
}

void
rygel_media_file_item_set_place_holder (RygelMediaFileItem* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_file_item_get_place_holder (self);
	if (old_value != value) {
		self->priv->_place_holder = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_file_item_properties[RYGEL_MEDIA_FILE_ITEM_PLACE_HOLDER_PROPERTY]);
	}
}

static GUPnPOCMFlags
rygel_media_file_item_real_get_ocm_flags (RygelMediaObject* base)
{
	GUPnPOCMFlags result;
	RygelMediaFileItem* self;
	GUPnPOCMFlags flags = 0U;
	gboolean _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (RygelMediaFileItem*) base;
	flags = GUPNP_OCM_FLAGS_NONE;
	_tmp0_ = self->priv->_place_holder;
	if (_tmp0_) {
		flags |= GUPNP_OCM_FLAGS_DESTROYABLE;
	} else {
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp1_;
		gboolean allow_deletion = FALSE;
		_tmp1_ = rygel_meta_config_get_default ();
		config = _tmp1_;
		allow_deletion = TRUE;
		{
			gboolean _tmp2_ = FALSE;
			RygelMetaConfig* _tmp3_;
			_tmp3_ = config;
			_tmp2_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			allow_deletion = _tmp2_;
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0U;
		}
		if (allow_deletion) {
			flags |= GUPNP_OCM_FLAGS_DESTROYABLE;
		}
		_g_object_unref0 (config);
	}
	if (RYGEL_IS_UPDATABLE_OBJECT (self)) {
		flags |= GUPNP_OCM_FLAGS_CHANGE_METADATA;
	}
	result = flags;
	return result;
}

static void
rygel_media_file_item_class_init (RygelMediaFileItemClass * klass,
                                  gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	rygel_media_file_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaFileItem_private_offset);
	((RygelMediaObjectClass *) klass)->create_stream_source_for_resource = (RygelDataSource* (*) (RygelMediaObject*, RygelHTTPRequest*, RygelMediaResource*, GError**)) rygel_media_file_item_real_create_stream_source_for_resource;
	((RygelMediaObjectClass *) klass)->serialize = (GUPnPDIDLLiteObject* (*) (RygelMediaObject*, RygelSerializer*, RygelHTTPServer*, GError**)) rygel_media_file_item_real_serialize;
	((RygelMediaFileItemClass *) klass)->get_primary_resource = (RygelMediaResource* (*) (RygelMediaFileItem*)) rygel_media_file_item_real_get_primary_resource;
	((RygelMediaFileItemClass *) klass)->get_extension = (gchar* (*) (RygelMediaFileItem*)) rygel_media_file_item_real_get_extension;
	((RygelMediaFileItemClass *) klass)->add_engine_resources = (void (*) (RygelMediaFileItem*, GAsyncReadyCallback, gpointer)) rygel_media_file_item_real_add_engine_resources;
	((RygelMediaFileItemClass *) klass)->add_engine_resources_finish = (void (*) (RygelMediaFileItem*, GAsyncResult*)) rygel_media_file_item_real_add_engine_resources_finish;
	((RygelMediaFileItemClass *) klass)->add_additional_resources = (void (*) (RygelMediaFileItem*, RygelHTTPServer*)) rygel_media_file_item_real_add_additional_resources;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_file_item_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_file_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_file_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_file_item_finalize;
	/**
	     * The mime type of the source content (this.uri).
	     * A null/empty value means that the mime-type is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_FILE_ITEM_MIME_TYPE_PROPERTY, rygel_media_file_item_properties[RYGEL_MEDIA_FILE_ITEM_MIME_TYPE_PROPERTY] = g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The DLNA profile of the source content (this.uri).
	     * A null/empty value means that the DLNA profile is unknown
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_FILE_ITEM_DLNA_PROFILE_PROPERTY, rygel_media_file_item_properties[RYGEL_MEDIA_FILE_ITEM_DLNA_PROFILE_PROPERTY] = g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_FILE_ITEM_SIZE_PROPERTY, rygel_media_file_item_properties[RYGEL_MEDIA_FILE_ITEM_SIZE_PROPERTY] = g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_FILE_ITEM_PLACE_HOLDER_PROPERTY, rygel_media_file_item_properties[RYGEL_MEDIA_FILE_ITEM_PLACE_HOLDER_PROPERTY] = g_param_spec_boolean ("place-holder", "place-holder", "place-holder", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_FILE_ITEM_OCM_FLAGS_PROPERTY, rygel_media_file_item_properties[RYGEL_MEDIA_FILE_ITEM_OCM_FLAGS_PROPERTY] = g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	{
		GRegex* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		_tmp1_ = g_regex_escape_string ("@ADDRESS@", -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (rygel_media_file_item_address_regex);
		rygel_media_file_item_address_regex = _tmp5_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
rygel_media_file_item_instance_init (RygelMediaFileItem * self,
                                     gpointer klass)
{
	self->priv = rygel_media_file_item_get_instance_private (self);
	self->priv->_size = (gint64) -1;
	self->priv->_place_holder = FALSE;
}

static void
rygel_media_file_item_finalize (GObject * obj)
{
	RygelMediaFileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_dlna_profile);
	G_OBJECT_CLASS (rygel_media_file_item_parent_class)->finalize (obj);
}

/**
 * Represents a file-accessible or http-accessible media item (music file,
 * image file, video file, etc) with some pre-established metadata or a
 * content placeholder for uploaded content.
 *
 * Items representing non-file-accessible content should create their own
 * MediaItem subclass.
 */
static GType
rygel_media_file_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaFileItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_file_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaFileItem), 0, (GInstanceInitFunc) rygel_media_file_item_instance_init, NULL };
	GType rygel_media_file_item_type_id;
	rygel_media_file_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelMediaFileItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	RygelMediaFileItem_private_offset = g_type_add_instance_private (rygel_media_file_item_type_id, sizeof (RygelMediaFileItemPrivate));
	return rygel_media_file_item_type_id;
}

GType
rygel_media_file_item_get_type (void)
{
	static volatile gsize rygel_media_file_item_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_file_item_type_id__once)) {
		GType rygel_media_file_item_type_id;
		rygel_media_file_item_type_id = rygel_media_file_item_get_type_once ();
		g_once_init_leave (&rygel_media_file_item_type_id__once, rygel_media_file_item_type_id);
	}
	return rygel_media_file_item_type_id__once;
}

static void
_vala_rygel_media_file_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	RygelMediaFileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem);
	switch (property_id) {
		case RYGEL_MEDIA_FILE_ITEM_MIME_TYPE_PROPERTY:
		g_value_set_string (value, rygel_media_file_item_get_mime_type (self));
		break;
		case RYGEL_MEDIA_FILE_ITEM_DLNA_PROFILE_PROPERTY:
		g_value_set_string (value, rygel_media_file_item_get_dlna_profile (self));
		break;
		case RYGEL_MEDIA_FILE_ITEM_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_media_file_item_get_size (self));
		break;
		case RYGEL_MEDIA_FILE_ITEM_PLACE_HOLDER_PROPERTY:
		g_value_set_boolean (value, rygel_media_file_item_get_place_holder (self));
		break;
		case RYGEL_MEDIA_FILE_ITEM_OCM_FLAGS_PROPERTY:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags ((RygelMediaObject*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_file_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	RygelMediaFileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem);
	switch (property_id) {
		case RYGEL_MEDIA_FILE_ITEM_MIME_TYPE_PROPERTY:
		rygel_media_file_item_set_mime_type (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_FILE_ITEM_DLNA_PROFILE_PROPERTY:
		rygel_media_file_item_set_dlna_profile (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_FILE_ITEM_SIZE_PROPERTY:
		rygel_media_file_item_set_size (self, g_value_get_int64 (value));
		break;
		case RYGEL_MEDIA_FILE_ITEM_PLACE_HOLDER_PROPERTY:
		rygel_media_file_item_set_place_holder (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

