/* WindowIcon.c generated by valac 0.56.2, the Vala compiler
 * generated from WindowIcon.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2017-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "workspacesapplet.h"
#include <libwnck/libwnck.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

enum  {
	WORKSPACES_WINDOW_ICON_0_PROPERTY,
	WORKSPACES_WINDOW_ICON_NUM_PROPERTIES
};
static GParamSpec* workspaces_window_icon_properties[WORKSPACES_WINDOW_ICON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block7Data Block7Data;

struct _WorkspacesWindowIconPrivate {
	WnckWindow* window;
};

struct _Block7Data {
	int _ref_count_;
	WorkspacesWindowIcon* self;
	WnckWindow* window;
};

static gint WorkspacesWindowIcon_private_offset;
static gpointer workspaces_window_icon_parent_class = NULL;
static GType workspaces_window_icon_type_id = 0;

static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda11_ (Block7Data* _data7_);
static void ___lambda11__wnck_window_name_changed (WnckWindow* _sender,
                                            gpointer self);
static void workspaces_window_icon_on_drag_begin (WorkspacesWindowIcon* self,
                                           GtkWidget* widget,
                                           GdkDragContext* context);
static void _workspaces_window_icon_on_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                                  GdkDragContext* context,
                                                                  gpointer self);
static void workspaces_window_icon_on_drag_end (WorkspacesWindowIcon* self,
                                         GtkWidget* widget,
                                         GdkDragContext* context);
static void _workspaces_window_icon_on_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                                              GdkDragContext* context,
                                                              gpointer self);
static void _workspaces_window_icon_on_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                        GdkDragContext* context,
                                                                        GtkSelectionData* selection_data,
                                                                        guint info,
                                                                        guint time_,
                                                                        gpointer self);
static gboolean workspaces_window_icon_real_button_release_event (GtkWidget* base,
                                                           GdkEventButton* event);
static void workspaces_window_icon_convert_ulong_to_bytes (WorkspacesWindowIcon* self,
                                                    gulong number,
                                                    guchar** buffer,
                                                    gint* buffer_length1);
static void workspaces_window_icon_finalize (GObject * obj);

VALA_EXTERN const GtkTargetEntry WORKSPACES_target_list[1];

static inline gpointer
workspaces_window_icon_get_instance_private (WorkspacesWindowIcon* self)
{
	return G_STRUCT_MEMBER_P (self, WorkspacesWindowIcon_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		WorkspacesWindowIcon* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->window);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda11_ (Block7Data* _data7_)
{
	WorkspacesWindowIcon* self;
	const gchar* _tmp0_;
	self = _data7_->self;
	_tmp0_ = wnck_window_get_name (_data7_->window);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp0_);
}

static void
___lambda11__wnck_window_name_changed (WnckWindow* _sender,
                                       gpointer self)
{
	__lambda11_ (self);
}

static void
_workspaces_window_icon_on_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                             GdkDragContext* context,
                                                             gpointer self)
{
	workspaces_window_icon_on_drag_begin ((WorkspacesWindowIcon*) self, _sender, context);
}

static void
_workspaces_window_icon_on_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                                         GdkDragContext* context,
                                                         gpointer self)
{
	workspaces_window_icon_on_drag_end ((WorkspacesWindowIcon*) self, _sender, context);
}

static void
_workspaces_window_icon_on_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                   GdkDragContext* context,
                                                                   GtkSelectionData* selection_data,
                                                                   guint info,
                                                                   guint time_,
                                                                   gpointer self)
{
	workspaces_window_icon_on_drag_data_get ((WorkspacesWindowIcon*) self, _sender, context, selection_data, info, time_);
}

WorkspacesWindowIcon*
workspaces_window_icon_construct (GType object_type,
                                  WnckWindow* window)
{
	WorkspacesWindowIcon * self = NULL;
	Block7Data* _data7_;
	WnckWindow* _tmp0_;
	WnckWindow* _tmp1_;
	GtkStyleContext* _tmp2_;
	const gchar* _tmp3_;
	GtkImage* icon = NULL;
	GdkPixbuf* _tmp4_;
	GtkImage* _tmp5_;
	GdkPixbuf* _tmp6_;
	g_return_val_if_fail (window != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data7_->window);
	_data7_->window = _tmp0_;
	self = (WorkspacesWindowIcon*) g_object_new (object_type, NULL);
	_data7_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (_data7_->window);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp1_;
	gtk_button_set_relief ((GtkButton*) self, GTK_RELIEF_NONE);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "workspace-icon-button");
	_tmp3_ = wnck_window_get_name (_data7_->window);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp3_);
	_tmp4_ = wnck_window_get_mini_icon (_data7_->window);
	_tmp5_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp4_);
	g_object_ref_sink (_tmp5_);
	icon = _tmp5_;
	gtk_image_set_pixel_size (icon, 16);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) icon);
	gtk_widget_show ((GtkWidget*) icon);
	g_signal_connect_data (_data7_->window, "name-changed", (GCallback) ___lambda11__wnck_window_name_changed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	gtk_drag_source_set ((GtkWidget*) self, GDK_BUTTON1_MASK, WORKSPACES_target_list, (gint) G_N_ELEMENTS (WORKSPACES_target_list), GDK_ACTION_MOVE);
	_tmp6_ = wnck_window_get_icon (_data7_->window);
	gtk_drag_source_set_icon_pixbuf ((GtkWidget*) self, _tmp6_);
	g_signal_connect_object ((GtkWidget*) self, "drag-begin", (GCallback) _workspaces_window_icon_on_drag_begin_gtk_widget_drag_begin, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-end", (GCallback) _workspaces_window_icon_on_drag_end_gtk_widget_drag_end, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-get", (GCallback) _workspaces_window_icon_on_drag_data_get_gtk_widget_drag_data_get, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (icon);
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return self;
}

WorkspacesWindowIcon*
workspaces_window_icon_new (WnckWindow* window)
{
	return workspaces_window_icon_construct (WORKSPACES_TYPE_WINDOW_ICON, window);
}

static gboolean
workspaces_window_icon_real_button_release_event (GtkWidget* base,
                                                  GdkEventButton* event)
{
	WorkspacesWindowIcon * self;
	WnckWorkspace* workspace = NULL;
	WnckScreen* _tmp0_;
	WnckWorkspace* _tmp1_;
	WnckWorkspace* _tmp2_;
	gboolean _tmp3_ = FALSE;
	WnckWorkspace* _tmp4_;
	WnckWindow* _tmp9_;
	WnckWorkspace* _tmp10_;
	gboolean result;
	self = (WorkspacesWindowIcon*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = workspaces_workspaces_applet_wnck_screen;
	_tmp1_ = wnck_screen_get_active_workspace (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	workspace = _tmp2_;
	_tmp4_ = workspace;
	if (_tmp4_ != NULL) {
		WnckWorkspace* _tmp5_;
		WnckWindow* _tmp6_;
		WnckWorkspace* _tmp7_;
		_tmp5_ = workspace;
		_tmp6_ = self->priv->window;
		_tmp7_ = wnck_window_get_workspace (_tmp6_);
		_tmp3_ = _tmp5_ == _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		WnckWindow* _tmp8_;
		_tmp8_ = self->priv->window;
		wnck_window_activate (_tmp8_, event->time);
		result = FALSE;
		_g_object_unref0 (workspace);
		return result;
	}
	_tmp9_ = self->priv->window;
	_tmp10_ = wnck_window_get_workspace (_tmp9_);
	wnck_workspace_activate (_tmp10_, event->time);
	result = FALSE;
	_g_object_unref0 (workspace);
	return result;
}

static void
workspaces_window_icon_on_drag_begin (WorkspacesWindowIcon* self,
                                      GtkWidget* widget,
                                      GdkDragContext* context)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	workspaces_workspaces_applet_dragging = TRUE;
}

static void
workspaces_window_icon_on_drag_end (WorkspacesWindowIcon* self,
                                    GtkWidget* widget,
                                    GdkDragContext* context)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	workspaces_workspaces_applet_dragging = FALSE;
}

void
workspaces_window_icon_on_drag_data_get (WorkspacesWindowIcon* self,
                                         GtkWidget* widget,
                                         GdkDragContext* context,
                                         GtkSelectionData* selection_data,
                                         guint target_type,
                                         guint time)
{
	gulong window_xid = 0UL;
	WnckWindow* _tmp0_;
	guchar* buf = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	guchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = self->priv->window;
	window_xid = wnck_window_get_xid (_tmp0_);
	workspaces_window_icon_convert_ulong_to_bytes (self, window_xid, &_tmp1_, &_tmp2_);
	buf = (g_free (buf), NULL);
	buf = _tmp1_;
	buf_length1 = _tmp2_;
	_buf_size_ = buf_length1;
	gtk_selection_data_set (selection_data, gtk_selection_data_get_target (selection_data), 8, buf, (gint) buf_length1);
	buf = (g_free (buf), NULL);
}

static void
workspaces_window_icon_convert_ulong_to_bytes (WorkspacesWindowIcon* self,
                                               gulong number,
                                               guchar** buffer,
                                               gint* buffer_length1)
{
	guchar* _vala_buffer = NULL;
	gint _vala_buffer_length1 = 0;
	guchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (guchar, sizeof (gulong));
	_vala_buffer = (g_free (_vala_buffer), NULL);
	_vala_buffer = _tmp0_;
	_vala_buffer_length1 = sizeof (gulong);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guchar* _tmp3_;
				gint _tmp3__length1;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((gulong) i) < sizeof (gulong))) {
					break;
				}
				_tmp3_ = _vala_buffer;
				_tmp3__length1 = _vala_buffer_length1;
				_tmp3_[i] = (guchar) (number & 0xFF);
				number = number >> 8;
			}
		}
	}
	if (buffer) {
		*buffer = _vala_buffer;
	} else {
		_vala_buffer = (g_free (_vala_buffer), NULL);
	}
	if (buffer_length1) {
		*buffer_length1 = _vala_buffer_length1;
	}
}

static void
workspaces_window_icon_class_init (WorkspacesWindowIconClass * klass,
                                   gpointer klass_data)
{
	workspaces_window_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WorkspacesWindowIcon_private_offset);
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) workspaces_window_icon_real_button_release_event;
	G_OBJECT_CLASS (klass)->finalize = workspaces_window_icon_finalize;
}

static void
workspaces_window_icon_instance_init (WorkspacesWindowIcon * self,
                                      gpointer klass)
{
	self->priv = workspaces_window_icon_get_instance_private (self);
}

static void
workspaces_window_icon_finalize (GObject * obj)
{
	WorkspacesWindowIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WORKSPACES_TYPE_WINDOW_ICON, WorkspacesWindowIcon);
	_g_object_unref0 (self->priv->window);
	G_OBJECT_CLASS (workspaces_window_icon_parent_class)->finalize (obj);
}

GType
workspaces_window_icon_get_type (void)
{
	return workspaces_window_icon_type_id;
}

GType
workspaces_window_icon_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (WorkspacesWindowIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) workspaces_window_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WorkspacesWindowIcon), 0, (GInstanceInitFunc) workspaces_window_icon_instance_init, NULL };
	workspaces_window_icon_type_id = g_type_module_register_type (module, gtk_button_get_type (), "WorkspacesWindowIcon", &g_define_type_info, 0);
	WorkspacesWindowIcon_private_offset = sizeof (WorkspacesWindowIconPrivate);
	return workspaces_window_icon_type_id;
}

