/* settings_desktop.c generated by valac 0.56.2, the Vala compiler
 * generated from settings_desktop.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#define BUDGIE_SETTINGS_GROUP_APPEARANCE "appearance"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	BUDGIE_DESKTOP_TYPE_NONE = 0,
	BUDGIE_DESKTOP_TYPE_BUDGIE = 1,
	BUDGIE_DESKTOP_TYPE_DESKTOPFOLDER = 2,
	BUDGIE_DESKTOP_TYPE_NEMO = 3
} BudgieDesktopType;

#define BUDGIE_TYPE_DESKTOP_TYPE (budgie_desktop_type_get_type ())

#define BUDGIE_TYPE_SETTINGS_PAGE (budgie_settings_page_get_type ())
#define BUDGIE_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPage))
#define BUDGIE_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))
#define BUDGIE_IS_SETTINGS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_IS_SETTINGS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_PAGE))
#define BUDGIE_SETTINGS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_PAGE, BudgieSettingsPageClass))

typedef struct _BudgieSettingsPage BudgieSettingsPage;
typedef struct _BudgieSettingsPageClass BudgieSettingsPageClass;
typedef struct _BudgieSettingsPagePrivate BudgieSettingsPagePrivate;

#define BUDGIE_TYPE_DESKTOP_PAGE (budgie_desktop_page_get_type ())
#define BUDGIE_DESKTOP_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_DESKTOP_PAGE, BudgieDesktopPage))
#define BUDGIE_DESKTOP_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_DESKTOP_PAGE, BudgieDesktopPageClass))
#define BUDGIE_IS_DESKTOP_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_DESKTOP_PAGE))
#define BUDGIE_IS_DESKTOP_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_DESKTOP_PAGE))
#define BUDGIE_DESKTOP_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_DESKTOP_PAGE, BudgieDesktopPageClass))

typedef struct _BudgieDesktopPage BudgieDesktopPage;
typedef struct _BudgieDesktopPageClass BudgieDesktopPageClass;
typedef struct _BudgieDesktopPagePrivate BudgieDesktopPagePrivate;

#define BUDGIE_TYPE_SETTINGS_GRID (budgie_settings_grid_get_type ())
#define BUDGIE_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGrid))
#define BUDGIE_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))
#define BUDGIE_IS_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_IS_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_SETTINGS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))

typedef struct _BudgieSettingsGrid BudgieSettingsGrid;
typedef struct _BudgieSettingsGridClass BudgieSettingsGridClass;
enum  {
	BUDGIE_DESKTOP_PAGE_0_PROPERTY,
	BUDGIE_DESKTOP_PAGE_NUM_PROPERTIES
};
static GParamSpec* budgie_desktop_page_properties[BUDGIE_DESKTOP_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUDGIE_TYPE_SETTINGS_ROW (budgie_settings_row_get_type ())
#define BUDGIE_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRow))
#define BUDGIE_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))
#define BUDGIE_IS_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_IS_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_SETTINGS_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))

typedef struct _BudgieSettingsRow BudgieSettingsRow;
typedef struct _BudgieSettingsRowClass BudgieSettingsRowClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BudgieSettingsPage {
	GtkBox parent_instance;
	BudgieSettingsPagePrivate * priv;
};

struct _BudgieSettingsPageClass {
	GtkBoxClass parent_class;
};

struct _BudgieDesktopPage {
	BudgieSettingsPage parent_instance;
	BudgieDesktopPagePrivate * priv;
};

struct _BudgieDesktopPageClass {
	BudgieSettingsPageClass parent_class;
};

struct _BudgieDesktopPagePrivate {
	GSettings* budgie_wm_settings;
	GSettings* gnome_wm_settings;
	GtkSpinButton* workspace_count;
	GSettings* budgie_desktop_view_settings;
	GSettings* desktop_folder_settings;
	GSettings* nemo_settings;
	BudgieSettingsGrid* grid;
	GtkSwitch* show_switch;
	GtkSwitch* show_mounts;
	GtkSwitch* show_home;
	GtkSwitch* show_trash;
	GtkComboBox* icon_size;
	GtkComboBox* click_policy;
	gint use_desktop_type;
};

static gint BudgieDesktopPage_private_offset;
static gpointer budgie_desktop_page_parent_class = NULL;

VALA_EXTERN GType budgie_desktop_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType budgie_settings_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsPage, g_object_unref)
VALA_EXTERN GType budgie_desktop_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieDesktopPage, g_object_unref)
VALA_EXTERN GType budgie_settings_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsGrid, g_object_unref)
VALA_EXTERN BudgieDesktopPage* budgie_desktop_page_new (void);
VALA_EXTERN BudgieDesktopPage* budgie_desktop_page_construct (GType object_type);
VALA_EXTERN gint budgie_desktop_page_get_preferred_desktop_app (BudgieDesktopPage* self);
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_new (void);
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_construct (GType object_type);
static void budgie_desktop_page_update_switches (BudgieDesktopPage* self);
static void _budgie_desktop_page_update_switches_g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self);
VALA_EXTERN GType budgie_settings_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsRow, g_object_unref)
VALA_EXTERN void budgie_settings_grid_add_row (BudgieSettingsGrid* self,
                                   BudgieSettingsRow* row);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_new (GtkWidget* widget,
                                            const gchar* label,
                                            const gchar* description);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_construct (GType object_type,
                                                  GtkWidget* widget,
                                                  const gchar* label,
                                                  const gchar* description);
static void budgie_desktop_page_setup_show_binding (BudgieDesktopPage* self);
static void budgie_desktop_page_setup_show_active_mounts_binding (BudgieDesktopPage* self);
static void budgie_desktop_page_setup_show_home_binding (BudgieDesktopPage* self);
static void budgie_desktop_page_setup_show_trash_binding (BudgieDesktopPage* self);
static void budgie_desktop_page_setup_click_policy (BudgieDesktopPage* self);
static void budgie_desktop_page_setup_icon_size (BudgieDesktopPage* self);
static void budgie_desktop_page_build_workspace_option (BudgieDesktopPage* self);
static void __lambda14_ (BudgieDesktopPage* self);
static void ___lambda14__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                 gpointer self);
VALA_EXTERN gchar* budgie_desktop_page_get_exec_for_type (BudgieDesktopPage* self,
                                              gint t);
static gboolean budgie_desktop_page_is_showing (BudgieDesktopPage* self);
static void budgie_desktop_page_finalize (GObject * obj);
static GType budgie_desktop_page_get_type_once (void);

static GType
budgie_desktop_type_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_DESKTOP_TYPE_NONE, "BUDGIE_DESKTOP_TYPE_NONE", "none"}, {BUDGIE_DESKTOP_TYPE_BUDGIE, "BUDGIE_DESKTOP_TYPE_BUDGIE", "budgie"}, {BUDGIE_DESKTOP_TYPE_DESKTOPFOLDER, "BUDGIE_DESKTOP_TYPE_DESKTOPFOLDER", "desktopfolder"}, {BUDGIE_DESKTOP_TYPE_NEMO, "BUDGIE_DESKTOP_TYPE_NEMO", "nemo"}, {0, NULL, NULL}};
	GType budgie_desktop_type_type_id;
	budgie_desktop_type_type_id = g_enum_register_static ("BudgieDesktopType", values);
	return budgie_desktop_type_type_id;
}

GType
budgie_desktop_type_get_type (void)
{
	static volatile gsize budgie_desktop_type_type_id__once = 0;
	if (g_once_init_enter (&budgie_desktop_type_type_id__once)) {
		GType budgie_desktop_type_type_id;
		budgie_desktop_type_type_id = budgie_desktop_type_get_type_once ();
		g_once_init_leave (&budgie_desktop_type_type_id__once, budgie_desktop_type_type_id);
	}
	return budgie_desktop_type_type_id__once;
}

static inline gpointer
budgie_desktop_page_get_instance_private (BudgieDesktopPage* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieDesktopPage_private_offset);
}

static void
_budgie_desktop_page_update_switches_g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self)
{
	budgie_desktop_page_update_switches ((BudgieDesktopPage*) self);
}

BudgieDesktopPage*
budgie_desktop_page_construct (GType object_type)
{
	BudgieDesktopPage * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	BudgieSettingsGrid* _tmp2_;
	BudgieSettingsGrid* _tmp3_;
	self = (BudgieDesktopPage*) g_object_new (object_type, "group", BUDGIE_SETTINGS_GROUP_APPEARANCE, "content-id", "desktop", "title", _ ("Desktop"), "display-weight", 1, "icon-name", "preferences-desktop-wallpaper", NULL);
	_tmp0_ = g_settings_new ("com.solus-project.budgie-wm");
	_g_object_unref0 (self->priv->budgie_wm_settings);
	self->priv->budgie_wm_settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.desktop.wm.preferences");
	_g_object_unref0 (self->priv->gnome_wm_settings);
	self->priv->gnome_wm_settings = _tmp1_;
	self->priv->use_desktop_type = budgie_desktop_page_get_preferred_desktop_app (self);
	_tmp2_ = budgie_settings_grid_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp2_;
	_tmp3_ = self->priv->grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_BUDGIE)) {
		GSettings* _tmp4_;
		GSettings* _tmp5_;
		_tmp4_ = g_settings_new ("org.buddiesofbudgie.budgie-desktop-view");
		_g_object_unref0 (self->priv->budgie_desktop_view_settings);
		self->priv->budgie_desktop_view_settings = _tmp4_;
		_tmp5_ = self->priv->budgie_desktop_view_settings;
		g_signal_connect_object (_tmp5_, "changed", (GCallback) _budgie_desktop_page_update_switches_g_settings_changed, self, 0);
	} else {
		if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_DESKTOPFOLDER)) {
			GSettings* _tmp6_;
			GSettings* _tmp7_;
			_tmp6_ = g_settings_new ("com.github.spheras.desktopfolder");
			_g_object_unref0 (self->priv->desktop_folder_settings);
			self->priv->desktop_folder_settings = _tmp6_;
			_tmp7_ = self->priv->desktop_folder_settings;
			g_signal_connect_object (_tmp7_, "changed", (GCallback) _budgie_desktop_page_update_switches_g_settings_changed, self, 0);
		} else {
			if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_NEMO)) {
				GSettings* _tmp8_;
				GSettings* _tmp9_;
				_tmp8_ = g_settings_new ("org.nemo.desktop");
				_g_object_unref0 (self->priv->nemo_settings);
				self->priv->nemo_settings = _tmp8_;
				_tmp9_ = self->priv->nemo_settings;
				g_signal_connect_object (_tmp9_, "changed", (GCallback) _budgie_desktop_page_update_switches_g_settings_changed, self, 0);
			}
		}
	}
	if (self->priv->use_desktop_type != ((gint) BUDGIE_DESKTOP_TYPE_NONE)) {
		GtkSwitch* _tmp10_;
		BudgieSettingsGrid* _tmp11_;
		GtkSwitch* _tmp12_;
		BudgieSettingsRow* _tmp13_;
		BudgieSettingsRow* _tmp14_;
		_tmp10_ = (GtkSwitch*) gtk_switch_new ();
		g_object_ref_sink (_tmp10_);
		_g_object_unref0 (self->priv->show_switch);
		self->priv->show_switch = _tmp10_;
		_tmp11_ = self->priv->grid;
		_tmp12_ = self->priv->show_switch;
		_tmp13_ = budgie_settings_row_new ((GtkWidget*) _tmp12_, _ ("Desktop Icons"), _ ("Control whether to allow icons on the desktop."));
		_tmp14_ = _tmp13_;
		budgie_settings_grid_add_row (_tmp11_, _tmp14_);
		_g_object_unref0 (_tmp14_);
		budgie_desktop_page_setup_show_binding (self);
		if (self->priv->use_desktop_type != ((gint) BUDGIE_DESKTOP_TYPE_DESKTOPFOLDER)) {
			GtkSwitch* _tmp15_;
			BudgieSettingsGrid* _tmp16_;
			GtkSwitch* _tmp17_;
			BudgieSettingsRow* _tmp18_;
			BudgieSettingsRow* _tmp19_;
			GtkSwitch* _tmp20_;
			BudgieSettingsGrid* _tmp21_;
			GtkSwitch* _tmp22_;
			BudgieSettingsRow* _tmp23_;
			BudgieSettingsRow* _tmp24_;
			GtkSwitch* _tmp25_;
			BudgieSettingsGrid* _tmp26_;
			GtkSwitch* _tmp27_;
			BudgieSettingsRow* _tmp28_;
			BudgieSettingsRow* _tmp29_;
			_tmp15_ = (GtkSwitch*) gtk_switch_new ();
			g_object_ref_sink (_tmp15_);
			_g_object_unref0 (self->priv->show_mounts);
			self->priv->show_mounts = _tmp15_;
			_tmp16_ = self->priv->grid;
			_tmp17_ = self->priv->show_mounts;
			_tmp18_ = budgie_settings_row_new ((GtkWidget*) _tmp17_, _ ("Active Mounts"), _ ("Show all active mounts on the desktop."));
			_tmp19_ = _tmp18_;
			budgie_settings_grid_add_row (_tmp16_, _tmp19_);
			_g_object_unref0 (_tmp19_);
			budgie_desktop_page_setup_show_active_mounts_binding (self);
			_tmp20_ = (GtkSwitch*) gtk_switch_new ();
			g_object_ref_sink (_tmp20_);
			_g_object_unref0 (self->priv->show_home);
			self->priv->show_home = _tmp20_;
			_tmp21_ = self->priv->grid;
			_tmp22_ = self->priv->show_home;
			_tmp23_ = budgie_settings_row_new ((GtkWidget*) _tmp22_, _ ("Home directory"), _ ("Add a shortcut to your home directory on the desktop."));
			_tmp24_ = _tmp23_;
			budgie_settings_grid_add_row (_tmp21_, _tmp24_);
			_g_object_unref0 (_tmp24_);
			budgie_desktop_page_setup_show_home_binding (self);
			_tmp25_ = (GtkSwitch*) gtk_switch_new ();
			g_object_ref_sink (_tmp25_);
			_g_object_unref0 (self->priv->show_trash);
			self->priv->show_trash = _tmp25_;
			_tmp26_ = self->priv->grid;
			_tmp27_ = self->priv->show_trash;
			_tmp28_ = budgie_settings_row_new ((GtkWidget*) _tmp27_, _ ("Trash"), _ ("Add a shortcut to the Trash directory on the desktop."));
			_tmp29_ = _tmp28_;
			budgie_settings_grid_add_row (_tmp26_, _tmp29_);
			_g_object_unref0 (_tmp29_);
			budgie_desktop_page_setup_show_trash_binding (self);
		}
		if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_BUDGIE)) {
			GtkComboBox* _tmp30_;
			GtkComboBox* _tmp31_;
			BudgieSettingsGrid* _tmp32_;
			GtkComboBox* _tmp33_;
			BudgieSettingsRow* _tmp34_;
			BudgieSettingsRow* _tmp35_;
			_tmp30_ = (GtkComboBox*) gtk_combo_box_new ();
			g_object_ref_sink (_tmp30_);
			_g_object_unref0 (self->priv->click_policy);
			self->priv->click_policy = _tmp30_;
			budgie_desktop_page_setup_click_policy (self);
			_tmp31_ = (GtkComboBox*) gtk_combo_box_new ();
			g_object_ref_sink (_tmp31_);
			_g_object_unref0 (self->priv->icon_size);
			self->priv->icon_size = _tmp31_;
			_tmp32_ = self->priv->grid;
			_tmp33_ = self->priv->icon_size;
			_tmp34_ = budgie_settings_row_new ((GtkWidget*) _tmp33_, _ ("Icon Size"), _ ("Set the desired size of icons on the desktop."));
			_tmp35_ = _tmp34_;
			budgie_settings_grid_add_row (_tmp32_, _tmp35_);
			_g_object_unref0 (_tmp35_);
			budgie_desktop_page_setup_icon_size (self);
		}
	}
	budgie_desktop_page_build_workspace_option (self);
	budgie_desktop_page_update_switches (self);
	return self;
}

BudgieDesktopPage*
budgie_desktop_page_new (void)
{
	return budgie_desktop_page_construct (BUDGIE_TYPE_DESKTOP_PAGE);
}

static void
__lambda14_ (BudgieDesktopPage* self)
{
	gint new_val = 0;
	GtkSpinButton* _tmp0_;
	GSettings* _tmp3_;
	_tmp0_ = self->priv->workspace_count;
	new_val = gtk_spin_button_get_value_as_int (_tmp0_);
	if (new_val < 1) {
		GtkSpinButton* _tmp1_;
		new_val = 1;
		_tmp1_ = self->priv->workspace_count;
		gtk_spin_button_set_value (_tmp1_, 1.0);
	} else {
		if (new_val > 8) {
			GtkSpinButton* _tmp2_;
			new_val = 8;
			_tmp2_ = self->priv->workspace_count;
			gtk_spin_button_set_value (_tmp2_, 8.0);
		}
	}
	_tmp3_ = self->priv->gnome_wm_settings;
	g_settings_set_int (_tmp3_, "num-workspaces", new_val);
}

static void
___lambda14__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                            gpointer self)
{
	__lambda14_ ((BudgieDesktopPage*) self);
}

static void
budgie_desktop_page_build_workspace_option (BudgieDesktopPage* self)
{
	GtkSpinButton* _tmp0_;
	GtkSpinButton* _tmp1_;
	GSettings* _tmp2_;
	GtkSpinButton* _tmp3_;
	BudgieSettingsGrid* _tmp4_;
	GtkSpinButton* _tmp5_;
	BudgieSettingsRow* _tmp6_;
	BudgieSettingsRow* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 8, (gdouble) 1);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->workspace_count);
	self->priv->workspace_count = _tmp0_;
	_tmp1_ = self->priv->workspace_count;
	_tmp2_ = self->priv->gnome_wm_settings;
	gtk_spin_button_set_value (_tmp1_, (gdouble) g_settings_get_int (_tmp2_, "num-workspaces"));
	_tmp3_ = self->priv->workspace_count;
	g_signal_connect_object (_tmp3_, "value-changed", (GCallback) ___lambda14__gtk_spin_button_value_changed, self, 0);
	_tmp4_ = self->priv->grid;
	_tmp5_ = self->priv->workspace_count;
	_tmp6_ = budgie_settings_row_new ((GtkWidget*) _tmp5_, _ ("Number of virtual desktops"), _ ("Number of virtual desktops / workspaces to create automatically on sta" \
"rtup."));
	_tmp7_ = _tmp6_;
	budgie_settings_grid_add_row (_tmp4_, _tmp7_);
	_g_object_unref0 (_tmp7_);
}

gchar*
budgie_desktop_page_get_exec_for_type (BudgieDesktopPage* self,
                                       gint t)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (t) {
		case BUDGIE_DESKTOP_TYPE_BUDGIE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("org.buddiesofbudgie.budgie-desktop-view");
			result = _tmp0_;
			return result;
		}
		case BUDGIE_DESKTOP_TYPE_DESKTOPFOLDER:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("com.github.spheras.desktopfolder");
			result = _tmp1_;
			return result;
		}
		case BUDGIE_DESKTOP_TYPE_NEMO:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("nemo-desktop");
			result = _tmp2_;
			return result;
		}
		default:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("none");
			result = _tmp3_;
			return result;
		}
	}
}

gint
budgie_desktop_page_get_preferred_desktop_app (BudgieDesktopPage* self)
{
	gint desktop_override = 0;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* budgie_path = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->budgie_wm_settings;
	desktop_override = g_settings_get_enum (_tmp0_, "desktop-type-override");
	if (desktop_override != ((gint) BUDGIE_DESKTOP_TYPE_NONE)) {
		_tmp1_ = desktop_override != ((gint) BUDGIE_DESKTOP_TYPE_BUDGIE);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* desired_executable = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_;
		_tmp2_ = budgie_desktop_page_get_exec_for_type (self, desktop_override);
		desired_executable = _tmp2_;
		_tmp3_ = desired_executable;
		_tmp4_ = g_find_program_in_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_ != NULL;
		_g_free0 (_tmp5_);
		if (_tmp6_) {
			result = desktop_override;
			_g_free0 (desired_executable);
			return result;
		}
		_g_free0 (desired_executable);
	}
	_tmp7_ = budgie_desktop_page_get_exec_for_type (self, (gint) BUDGIE_DESKTOP_TYPE_BUDGIE);
	budgie_path = _tmp7_;
	_tmp8_ = budgie_path;
	_tmp9_ = g_find_program_in_path (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_ != NULL;
	_g_free0 (_tmp10_);
	if (_tmp11_) {
		result = (gint) BUDGIE_DESKTOP_TYPE_BUDGIE;
		_g_free0 (budgie_path);
		return result;
	}
	result = (gint) BUDGIE_DESKTOP_TYPE_NONE;
	_g_free0 (budgie_path);
	return result;
}

static gboolean
budgie_desktop_page_is_showing (BudgieDesktopPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_BUDGIE)) {
		GSettings* _tmp0_;
		_tmp0_ = self->priv->budgie_desktop_view_settings;
		result = g_settings_get_boolean (_tmp0_, "show");
		return result;
	} else {
		if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_DESKTOPFOLDER)) {
			GSettings* _tmp1_;
			_tmp1_ = self->priv->desktop_folder_settings;
			result = g_settings_get_boolean (_tmp1_, "show-desktopfolder");
			return result;
		} else {
			if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_NEMO)) {
				GSettings* _tmp2_;
				_tmp2_ = self->priv->nemo_settings;
				result = g_settings_get_boolean (_tmp2_, "show-desktop-icons");
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static void
budgie_desktop_page_setup_click_policy (BudgieDesktopPage* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_BUDGIE)) {
		GtkCellRendererText* render = NULL;
		GtkCellRendererText* _tmp0_;
		GtkListStore* model = NULL;
		GtkListStore* _tmp1_;
		GtkTreeIter iter = {0};
		static const gchar* policies[2] = {"single", "double"};
		GtkComboBox* _tmp12_;
		GtkListStore* _tmp13_;
		GtkComboBox* _tmp14_;
		GtkComboBox* _tmp15_;
		GtkCellRendererText* _tmp16_;
		GtkComboBox* _tmp17_;
		GtkCellRendererText* _tmp18_;
		GSettings* _tmp19_;
		GtkComboBox* _tmp20_;
		BudgieSettingsGrid* _tmp21_;
		GtkComboBox* _tmp22_;
		BudgieSettingsRow* _tmp23_;
		BudgieSettingsRow* _tmp24_;
		_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp0_);
		render = _tmp0_;
		_tmp1_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, -1);
		model = _tmp1_;
		{
			const gchar** pol_collection = NULL;
			gint pol_collection_length1 = 0;
			gint _pol_collection_size_ = 0;
			gint pol_it = 0;
			pol_collection = policies;
			pol_collection_length1 = G_N_ELEMENTS (policies);
			for (pol_it = 0; pol_it < pol_collection_length1; pol_it = pol_it + 1) {
				const gchar* pol = NULL;
				pol = pol_collection[pol_it];
				{
					GtkListStore* _tmp2_;
					GtkTreeIter _tmp3_ = {0};
					gchar* label_name = NULL;
					gchar* _tmp4_;
					const gchar* _tmp5_;
					GtkListStore* _tmp7_;
					GtkTreeIter _tmp8_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					_tmp2_ = model;
					gtk_list_store_append (_tmp2_, &_tmp3_);
					iter = _tmp3_;
					_tmp4_ = g_strdup (_ ("Single"));
					label_name = _tmp4_;
					_tmp5_ = pol;
					if (g_strcmp0 (_tmp5_, "double") == 0) {
						gchar* _tmp6_;
						_tmp6_ = g_strdup (_ ("Double"));
						_g_free0 (label_name);
						label_name = _tmp6_;
					}
					_tmp7_ = model;
					_tmp8_ = iter;
					_tmp9_ = pol;
					_tmp10_ = label_name;
					_tmp11_ = pol;
					gtk_list_store_set (_tmp7_, &_tmp8_, 0, _tmp9_, 1, _tmp10_, 2, _tmp11_, -1, -1);
					_g_free0 (label_name);
				}
			}
		}
		_tmp12_ = self->priv->click_policy;
		_tmp13_ = model;
		gtk_combo_box_set_model (_tmp12_, (GtkTreeModel*) _tmp13_);
		_tmp14_ = self->priv->click_policy;
		gtk_combo_box_set_id_column (_tmp14_, 0);
		_tmp15_ = self->priv->click_policy;
		_tmp16_ = render;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp15_, (GtkCellRenderer*) _tmp16_, TRUE);
		_tmp17_ = self->priv->click_policy;
		_tmp18_ = render;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp17_, (GtkCellRenderer*) _tmp18_, "text", 1);
		_tmp19_ = self->priv->budgie_desktop_view_settings;
		_tmp20_ = self->priv->click_policy;
		g_settings_bind (_tmp19_, "click-policy", (GObject*) _tmp20_, "active-id", G_SETTINGS_BIND_DEFAULT);
		_tmp21_ = self->priv->grid;
		_tmp22_ = self->priv->click_policy;
		_tmp23_ = budgie_settings_row_new ((GtkWidget*) _tmp22_, _ ("Click Policy"), _ ("Click Policy determines if we should open items on a single or double " \
"click."));
		_tmp24_ = _tmp23_;
		budgie_settings_grid_add_row (_tmp21_, _tmp24_);
		_g_object_unref0 (_tmp24_);
		_g_object_unref0 (model);
		_g_object_unref0 (render);
	}
}

static void
budgie_desktop_page_setup_show_binding (BudgieDesktopPage* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_BUDGIE)) {
		GSettings* _tmp0_;
		GtkSwitch* _tmp1_;
		_tmp0_ = self->priv->budgie_desktop_view_settings;
		_tmp1_ = self->priv->show_switch;
		g_settings_bind (_tmp0_, "show", (GObject*) _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
	} else {
		if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_DESKTOPFOLDER)) {
			GSettings* _tmp2_;
			GtkSwitch* _tmp3_;
			_tmp2_ = self->priv->desktop_folder_settings;
			_tmp3_ = self->priv->show_switch;
			g_settings_bind (_tmp2_, "show-desktopfolder", (GObject*) _tmp3_, "active", G_SETTINGS_BIND_DEFAULT);
		} else {
			if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_NEMO)) {
				GSettings* _tmp4_;
				GtkSwitch* _tmp5_;
				_tmp4_ = self->priv->nemo_settings;
				_tmp5_ = self->priv->show_switch;
				g_settings_bind (_tmp4_, "show-desktop-icons", (GObject*) _tmp5_, "active", G_SETTINGS_BIND_DEFAULT);
			}
		}
	}
}

static void
budgie_desktop_page_setup_show_active_mounts_binding (BudgieDesktopPage* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_BUDGIE)) {
		GSettings* _tmp0_;
		GtkSwitch* _tmp1_;
		_tmp0_ = self->priv->budgie_desktop_view_settings;
		_tmp1_ = self->priv->show_mounts;
		g_settings_bind (_tmp0_, "show-active-mounts", (GObject*) _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
	} else {
		if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_NEMO)) {
			GSettings* _tmp2_;
			GtkSwitch* _tmp3_;
			_tmp2_ = self->priv->nemo_settings;
			_tmp3_ = self->priv->show_mounts;
			g_settings_bind (_tmp2_, "volumes-visible", (GObject*) _tmp3_, "active", G_SETTINGS_BIND_DEFAULT);
		}
	}
}

static void
budgie_desktop_page_setup_show_home_binding (BudgieDesktopPage* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_BUDGIE)) {
		GSettings* _tmp0_;
		GtkSwitch* _tmp1_;
		_tmp0_ = self->priv->budgie_desktop_view_settings;
		_tmp1_ = self->priv->show_home;
		g_settings_bind (_tmp0_, "show-home-folder", (GObject*) _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
	} else {
		if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_NEMO)) {
			GSettings* _tmp2_;
			GtkSwitch* _tmp3_;
			_tmp2_ = self->priv->nemo_settings;
			_tmp3_ = self->priv->show_home;
			g_settings_bind (_tmp2_, "home-icon-visible", (GObject*) _tmp3_, "active", G_SETTINGS_BIND_DEFAULT);
		}
	}
}

static void
budgie_desktop_page_setup_show_trash_binding (BudgieDesktopPage* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_BUDGIE)) {
		GSettings* _tmp0_;
		GtkSwitch* _tmp1_;
		_tmp0_ = self->priv->budgie_desktop_view_settings;
		_tmp1_ = self->priv->show_trash;
		g_settings_bind (_tmp0_, "show-trash-folder", (GObject*) _tmp1_, "active", G_SETTINGS_BIND_DEFAULT);
	} else {
		if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_NEMO)) {
			GSettings* _tmp2_;
			GtkSwitch* _tmp3_;
			_tmp2_ = self->priv->nemo_settings;
			_tmp3_ = self->priv->show_trash;
			g_settings_bind (_tmp2_, "trash-icon-visible", (GObject*) _tmp3_, "active", G_SETTINGS_BIND_DEFAULT);
		}
	}
}

static void
budgie_desktop_page_setup_icon_size (BudgieDesktopPage* self)
{
	GtkListStore* model = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter iter = {0};
	static const gchar* icon_sizes[4] = {"small", "normal", "large", "massive"};
	GtkComboBox* _tmp15_;
	GtkListStore* _tmp16_;
	GtkComboBox* _tmp17_;
	GtkCellRendererText* render = NULL;
	GtkCellRendererText* _tmp18_;
	GtkComboBox* _tmp19_;
	GtkComboBox* _tmp20_;
	GSettings* _tmp21_;
	GtkComboBox* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, -1);
	model = _tmp0_;
	{
		const gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = icon_sizes;
		s_collection_length1 = G_N_ELEMENTS (icon_sizes);
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				GtkListStore* _tmp1_;
				GtkTreeIter _tmp2_ = {0};
				gchar* label_name = NULL;
				gchar* _tmp3_;
				const gchar* _tmp4_;
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp1_ = model;
				gtk_list_store_append (_tmp1_, &_tmp2_);
				iter = _tmp2_;
				_tmp3_ = g_strdup (_ ("Normal"));
				label_name = _tmp3_;
				_tmp4_ = s;
				if (g_strcmp0 (_tmp4_, "small") == 0) {
					gchar* _tmp5_;
					_tmp5_ = g_strdup (_ ("Small"));
					_g_free0 (label_name);
					label_name = _tmp5_;
				} else {
					const gchar* _tmp6_;
					_tmp6_ = s;
					if (g_strcmp0 (_tmp6_, "large") == 0) {
						gchar* _tmp7_;
						_tmp7_ = g_strdup (_ ("Large"));
						_g_free0 (label_name);
						label_name = _tmp7_;
					} else {
						const gchar* _tmp8_;
						_tmp8_ = s;
						if (g_strcmp0 (_tmp8_, "massive") == 0) {
							gchar* _tmp9_;
							_tmp9_ = g_strdup (_ ("Massive"));
							_g_free0 (label_name);
							label_name = _tmp9_;
						}
					}
				}
				_tmp10_ = model;
				_tmp11_ = iter;
				_tmp12_ = s;
				_tmp13_ = label_name;
				_tmp14_ = s;
				gtk_list_store_set (_tmp10_, &_tmp11_, 0, _tmp12_, 1, _tmp13_, 2, _tmp14_, -1, -1);
				_g_free0 (label_name);
			}
		}
	}
	_tmp15_ = self->priv->icon_size;
	_tmp16_ = model;
	gtk_combo_box_set_model (_tmp15_, (GtkTreeModel*) _tmp16_);
	_tmp17_ = self->priv->icon_size;
	gtk_combo_box_set_id_column (_tmp17_, 0);
	_tmp18_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp18_);
	render = _tmp18_;
	_tmp19_ = self->priv->icon_size;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp19_, (GtkCellRenderer*) render, TRUE);
	_tmp20_ = self->priv->icon_size;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp20_, (GtkCellRenderer*) render, "text", 1);
	_tmp21_ = self->priv->budgie_desktop_view_settings;
	_tmp22_ = self->priv->icon_size;
	g_settings_bind (_tmp21_, "icon-size", (GObject*) _tmp22_, "active-id", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (render);
	_g_object_unref0 (model);
}

static void
budgie_desktop_page_update_switches (BudgieDesktopPage* self)
{
	gboolean b = FALSE;
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp2_;
	GtkSwitch* _tmp4_;
	GtkComboBox* _tmp6_;
	g_return_if_fail (self != NULL);
	if (self->priv->use_desktop_type == ((gint) BUDGIE_DESKTOP_TYPE_NONE)) {
		return;
	}
	b = budgie_desktop_page_is_showing (self);
	_tmp0_ = self->priv->show_mounts;
	if (_tmp0_ != NULL) {
		GtkSwitch* _tmp1_;
		_tmp1_ = self->priv->show_mounts;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, b);
	}
	_tmp2_ = self->priv->show_home;
	if (_tmp2_ != NULL) {
		GtkSwitch* _tmp3_;
		_tmp3_ = self->priv->show_home;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, b);
	}
	_tmp4_ = self->priv->show_trash;
	if (_tmp4_ != NULL) {
		GtkSwitch* _tmp5_;
		_tmp5_ = self->priv->show_trash;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, b);
	}
	_tmp6_ = self->priv->icon_size;
	if (_tmp6_ != NULL) {
		GtkComboBox* _tmp7_;
		_tmp7_ = self->priv->icon_size;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, b);
	}
}

static void
budgie_desktop_page_class_init (BudgieDesktopPageClass * klass,
                                gpointer klass_data)
{
	budgie_desktop_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieDesktopPage_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_desktop_page_finalize;
}

static void
budgie_desktop_page_instance_init (BudgieDesktopPage * self,
                                   gpointer klass)
{
	self->priv = budgie_desktop_page_get_instance_private (self);
	self->priv->use_desktop_type = (gint) BUDGIE_DESKTOP_TYPE_NONE;
}

static void
budgie_desktop_page_finalize (GObject * obj)
{
	BudgieDesktopPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_DESKTOP_PAGE, BudgieDesktopPage);
	_g_object_unref0 (self->priv->budgie_wm_settings);
	_g_object_unref0 (self->priv->gnome_wm_settings);
	_g_object_unref0 (self->priv->workspace_count);
	_g_object_unref0 (self->priv->budgie_desktop_view_settings);
	_g_object_unref0 (self->priv->desktop_folder_settings);
	_g_object_unref0 (self->priv->nemo_settings);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->show_switch);
	_g_object_unref0 (self->priv->show_mounts);
	_g_object_unref0 (self->priv->show_home);
	_g_object_unref0 (self->priv->show_trash);
	_g_object_unref0 (self->priv->icon_size);
	_g_object_unref0 (self->priv->click_policy);
	G_OBJECT_CLASS (budgie_desktop_page_parent_class)->finalize (obj);
}

/**
* DesktopPage allows users to change aspects of the fonts used
*/
static GType
budgie_desktop_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieDesktopPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_desktop_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieDesktopPage), 0, (GInstanceInitFunc) budgie_desktop_page_instance_init, NULL };
	GType budgie_desktop_page_type_id;
	budgie_desktop_page_type_id = g_type_register_static (BUDGIE_TYPE_SETTINGS_PAGE, "BudgieDesktopPage", &g_define_type_info, 0);
	BudgieDesktopPage_private_offset = g_type_add_instance_private (budgie_desktop_page_type_id, sizeof (BudgieDesktopPagePrivate));
	return budgie_desktop_page_type_id;
}

GType
budgie_desktop_page_get_type (void)
{
	static volatile gsize budgie_desktop_page_type_id__once = 0;
	if (g_once_init_enter (&budgie_desktop_page_type_id__once)) {
		GType budgie_desktop_page_type_id;
		budgie_desktop_page_type_id = budgie_desktop_page_get_type_once ();
		g_once_init_leave (&budgie_desktop_page_type_id__once, budgie_desktop_page_type_id);
	}
	return budgie_desktop_page_type_id__once;
}

