/* tracker-steroids.c generated by valac 0.56.1, the Vala compiler
 * generated from tracker-steroids.vala, do not modify */

/*
 * Copyright (C) 2010, Codeminded BVBA <abustany@gnome.org>
 * Copyright (C) 2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gunixoutputstream.h>
#include "libtracker-common/tracker-common.h"
#include "libtracker-direct/tracker-direct.h"
#include "libtracker-sparql/tracker-sparql.h"
#include <gio/gunixinputstream.h>
#include "libtracker-data/tracker-db-interface.h"
#include <gio/gunixfdlist.h>

#define TRACKER_STEROIDS_PATH "/org/freedesktop/Tracker1/Steroids"
#define TRACKER_STEROIDS_BUFFER_SIZE 65536
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TRACKER_TYPE_STEROIDS (tracker_steroids_get_type ())
#define TRACKER_STEROIDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STEROIDS, TrackerSteroids))
#define TRACKER_STEROIDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STEROIDS, TrackerSteroidsClass))
#define TRACKER_IS_STEROIDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STEROIDS))
#define TRACKER_IS_STEROIDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STEROIDS))
#define TRACKER_STEROIDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STEROIDS, TrackerSteroidsClass))

typedef struct _TrackerSteroids TrackerSteroids;
typedef struct _TrackerSteroidsClass TrackerSteroidsClass;
typedef struct _TrackerSteroidsPrivate TrackerSteroidsPrivate;
enum  {
	TRACKER_STEROIDS_0_PROPERTY,
	TRACKER_STEROIDS_NUM_PROPERTIES
};
static GParamSpec* tracker_steroids_properties[TRACKER_STEROIDS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef void (*TrackerStoreSparqlQueryInThread) (TrackerSparqlCursor* cursor, gpointer user_data, GError** error);
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSteroidsQueryData TrackerSteroidsQueryData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSteroidsUpdateInternalData TrackerSteroidsUpdateInternalData;
typedef struct _TrackerSteroidsUpdateData TrackerSteroidsUpdateData;
typedef struct _TrackerSteroidsBatchUpdateData TrackerSteroidsBatchUpdateData;
typedef struct _TrackerSteroidsUpdateBlankData TrackerSteroidsUpdateBlankData;
typedef struct _TrackerSteroidsBatchUpdateBlankData TrackerSteroidsBatchUpdateBlankData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef struct _TrackerSteroidsUpdateArrayData TrackerSteroidsUpdateArrayData;
typedef struct _TrackerSteroidsQueryReadyData TrackerSteroidsQueryReadyData;
typedef struct _TrackerSteroidsUpdateReadyData TrackerSteroidsUpdateReadyData;
typedef struct _TrackerSteroidsBatchUpdateReadyData TrackerSteroidsBatchUpdateReadyData;
typedef struct _TrackerSteroidsUpdateBlankReadyData TrackerSteroidsUpdateBlankReadyData;
typedef struct _TrackerSteroidsBatchUpdateBlankReadyData TrackerSteroidsBatchUpdateBlankReadyData;
typedef struct _TrackerSteroidsUpdateArrayReadyData TrackerSteroidsUpdateArrayReadyData;

struct _TrackerSteroids {
	GObject parent_instance;
	TrackerSteroidsPrivate * priv;
};

struct _TrackerSteroidsClass {
	GObjectClass parent_class;
};

struct _Block5Data {
	int _ref_count_;
	TrackerSteroids* self;
	GUnixOutputStream* output_stream;
	gpointer _async_data_;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSteroidsQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSteroids* self;
	char* sender;
	gchar* query;
	GUnixOutputStream* output_stream;
	gchar** result;
	gint result_length1;
	Block5Data* _data5_;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp0_;
	Block6Data* _data6_;
	TrackerDirectConnection* sparql_conn;
	TrackerDirectConnection* _tmp1_;
	TrackerDirectConnection* _tmp2_;
	TrackerDirectConnection* _tmp3_;
	const gchar* _tmp4_;
	const char* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* e;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	GError* _inner_error0_;
};

struct _TrackerSteroidsUpdateInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSteroids* self;
	char* sender;
	gint priority;
	gboolean blank;
	GUnixInputStream* input_stream;
	GVariant* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp2_;
	gsize bytes_read;
	GDataInputStream* data_input_stream;
	GDataInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	GDataInputStream* _tmp5_;
	gint query_size;
	GDataInputStream* _tmp6_;
	guint8* query;
	guint8* _tmp7_;
	gint query_length1;
	gint _query_size_;
	GDataInputStream* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	gsize _tmp10_;
	TrackerDBusRequest* _tmp11_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	TrackerDirectConnection* sparql_conn;
	TrackerDirectConnection* _tmp13_;
	TrackerDirectConnection* _tmp14_;
	TrackerDirectConnection* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	TrackerDBusRequest* _tmp17_;
	GVariant* variant;
	TrackerDirectConnection* _tmp18_;
	guint8* _tmp19_;
	gint _tmp19__length1;
	GVariant* _tmp20_;
	TrackerDBusRequest* _tmp21_;
	GError* ie;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GError* _tmp24_;
	GError* e;
	TrackerDBusRequest* _tmp25_;
	GError* _tmp26_;
	GError* _tmp27_;
	GError* _tmp28_;
	GError* _tmp29_;
	GError* _tmp30_;
	const gchar* _tmp31_;
	GError* _tmp32_;
	GError* _inner_error0_;
};

struct _TrackerSteroidsUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSteroids* self;
	char* sender;
	GUnixInputStream* input_stream;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GError* _inner_error0_;
};

struct _TrackerSteroidsBatchUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSteroids* self;
	char* sender;
	GUnixInputStream* input_stream;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GError* _inner_error0_;
};

struct _TrackerSteroidsUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSteroids* self;
	char* sender;
	GUnixInputStream* input_stream;
	GVariant* result;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GError* _inner_error0_;
};

struct _TrackerSteroidsBatchUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSteroids* self;
	char* sender;
	GUnixInputStream* input_stream;
	GVariant* result;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GError* _inner_error0_;
};

struct _TrackerSteroidsUpdateArrayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSteroids* self;
	char* sender;
	GUnixInputStream* input_stream;
	GVariant* result;
	TrackerDBusRequest* request;
	TrackerDBusRequest* _tmp0_;
	GDataInputStream* data_input_stream;
	GDataInputStream* _tmp1_;
	GDataInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	gint query_count;
	GDataInputStream* _tmp4_;
	GString* combined_query;
	GString* _tmp5_;
	gchar** query_array;
	gchar** _tmp6_;
	gint query_array_length1;
	gint _query_array_size_;
	gint i;
	gboolean _tmp7_;
	gint _tmp8_;
	gsize bytes_read;
	gint query_size;
	GDataInputStream* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	guint8* _tmp11_;
	GDataInputStream* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gsize _tmp15_;
	TrackerDBusRequest* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	const gchar* _tmp18_;
	GString* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	const gchar* _tmp21_;
	GVariantBuilder* builder;
	GVariantBuilder* _tmp22_;
	TrackerDirectConnection* sparql_conn;
	TrackerDirectConnection* _tmp23_;
	TrackerDirectConnection* _tmp24_;
	TrackerDirectConnection* _tmp25_;
	GString* _tmp26_;
	const gchar* _tmp27_;
	gboolean _tmp28_;
	gint _tmp29_;
	GVariantBuilder* _tmp30_;
	GVariantBuilder* _tmp31_;
	TrackerDBusRequest* _tmp32_;
	GVariantBuilder* _tmp33_;
	GVariant* _tmp34_;
	gboolean _tmp35_;
	gint _tmp36_;
	TrackerDBusRequest* _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	const gchar* _tmp39_;
	TrackerDirectConnection* _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	const gchar* _tmp42_;
	GVariantBuilder* _tmp43_;
	GVariantBuilder* _tmp44_;
	GError* e1;
	GVariantBuilder* _tmp45_;
	GVariantBuilder* _tmp46_;
	GError* _tmp47_;
	const gchar* _tmp48_;
	TrackerDBusRequest* _tmp49_;
	GVariantBuilder* _tmp50_;
	GVariant* _tmp51_;
	GError* e;
	TrackerDBusRequest* _tmp52_;
	GError* _tmp53_;
	GError* _tmp54_;
	GError* _tmp55_;
	GError* _tmp56_;
	GError* _tmp57_;
	const gchar* _tmp58_;
	GError* _tmp59_;
	GError* _inner_error0_;
};

struct _TrackerSteroidsQueryReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* query;
	GUnixOutputStream* output_stream;
};

struct _TrackerSteroidsUpdateReadyData {
	GDBusMethodInvocation* _invocation_;
	GUnixInputStream* input_stream;
};

struct _TrackerSteroidsBatchUpdateReadyData {
	GDBusMethodInvocation* _invocation_;
	GUnixInputStream* input_stream;
};

struct _TrackerSteroidsUpdateBlankReadyData {
	GDBusMethodInvocation* _invocation_;
	GUnixInputStream* input_stream;
};

struct _TrackerSteroidsBatchUpdateBlankReadyData {
	GDBusMethodInvocation* _invocation_;
	GUnixInputStream* input_stream;
};

struct _TrackerSteroidsUpdateArrayReadyData {
	GDBusMethodInvocation* _invocation_;
	GUnixInputStream* input_stream;
};

static gpointer tracker_steroids_parent_class = NULL;

VALA_EXTERN GType tracker_steroids_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerSteroids, g_object_unref)
VALA_EXTERN guint tracker_steroids_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
static void tracker_steroids_query_data_free (gpointer _data);
VALA_EXTERN void tracker_steroids_query (TrackerSteroids* self,
                             const char* sender,
                             const gchar* query,
                             GUnixOutputStream* output_stream,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN gchar** tracker_steroids_query_finish (TrackerSteroids* self,
                                       GAsyncResult* _res_,
                                       gint* result_length1,
                                       GError** error);
static gboolean tracker_steroids_query_co (TrackerSteroidsQueryData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
VALA_EXTERN TrackerDirectConnection* tracker_main_get_sparql_connection (void);
VALA_EXTERN void tracker_store_sparql_query (TrackerDirectConnection* conn,
                                 const gchar* sparql,
                                 gint priority,
                                 TrackerStoreSparqlQueryInThread in_thread,
                                 gpointer in_thread_target,
                                 const gchar* client_id,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void tracker_store_sparql_query_finish (GAsyncResult* _res_,
                                        GError** error);
static void ___lambda14_ (Block6Data* _data6_,
                   TrackerSparqlCursor* cursor,
                   GError** error);
static void ____lambda14__tracker_store_sparql_query_in_thread (TrackerSparqlCursor* cursor,
                                                         gpointer self,
                                                         GError** error);
static void tracker_steroids_query_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void tracker_steroids_update_internal_data_free (gpointer _data);
static void tracker_steroids_update_internal (TrackerSteroids* self,
                                       const char* sender,
                                       gint priority,
                                       gboolean blank,
                                       GUnixInputStream* input_stream,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static GVariant* tracker_steroids_update_internal_finish (TrackerSteroids* self,
                                                   GAsyncResult* _res_,
                                                   GError** error);
static gboolean tracker_steroids_update_internal_co (TrackerSteroidsUpdateInternalData* _data_);
VALA_EXTERN void tracker_store_sparql_update (TrackerDirectConnection* conn,
                                  const gchar* sparql,
                                  gint priority,
                                  const gchar* client_id,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void tracker_store_sparql_update_finish (GAsyncResult* _res_,
                                         GError** error);
static void tracker_steroids_update_internal_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN void tracker_store_sparql_update_blank (TrackerDirectConnection* conn,
                                        const gchar* sparql,
                                        gint priority,
                                        const gchar* client_id,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_,
                                                    GError** error);
static void tracker_steroids_update_data_free (gpointer _data);
VALA_EXTERN void tracker_steroids_update (TrackerSteroids* self,
                              const char* sender,
                              GUnixInputStream* input_stream,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN void tracker_steroids_update_finish (TrackerSteroids* self,
                                     GAsyncResult* _res_,
                                     GError** error);
static gboolean tracker_steroids_update_co (TrackerSteroidsUpdateData* _data_);
static void tracker_steroids_update_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static void tracker_steroids_batch_update_data_free (gpointer _data);
VALA_EXTERN void tracker_steroids_batch_update (TrackerSteroids* self,
                                    const char* sender,
                                    GUnixInputStream* input_stream,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void tracker_steroids_batch_update_finish (TrackerSteroids* self,
                                           GAsyncResult* _res_,
                                           GError** error);
static gboolean tracker_steroids_batch_update_co (TrackerSteroidsBatchUpdateData* _data_);
static void tracker_steroids_batch_update_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void tracker_steroids_update_blank_data_free (gpointer _data);
VALA_EXTERN void tracker_steroids_update_blank (TrackerSteroids* self,
                                    const char* sender,
                                    GUnixInputStream* input_stream,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN GVariant* tracker_steroids_update_blank_finish (TrackerSteroids* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static gboolean tracker_steroids_update_blank_co (TrackerSteroidsUpdateBlankData* _data_);
static void tracker_steroids_update_blank_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void tracker_steroids_batch_update_blank_data_free (gpointer _data);
VALA_EXTERN void tracker_steroids_batch_update_blank (TrackerSteroids* self,
                                          const char* sender,
                                          GUnixInputStream* input_stream,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN GVariant* tracker_steroids_batch_update_blank_finish (TrackerSteroids* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static gboolean tracker_steroids_batch_update_blank_co (TrackerSteroidsBatchUpdateBlankData* _data_);
static void tracker_steroids_batch_update_blank_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void tracker_steroids_update_array_data_free (gpointer _data);
VALA_EXTERN void tracker_steroids_update_array (TrackerSteroids* self,
                                    const char* sender,
                                    GUnixInputStream* input_stream,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN GVariant* tracker_steroids_update_array_finish (TrackerSteroids* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static gboolean tracker_steroids_update_array_co (TrackerSteroidsUpdateArrayData* _data_);
static void tracker_steroids_update_array_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
VALA_EXTERN TrackerSteroids* tracker_steroids_new (void);
VALA_EXTERN TrackerSteroids* tracker_steroids_construct (GType object_type);
static GType tracker_steroids_get_type_once (void);
static void _dbus_tracker_steroids_query (TrackerSteroids* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_tracker_steroids_query_ready (GObject * source_object,
                                         GAsyncResult * _res_,
                                         gpointer _user_data_);
static void _dbus_tracker_steroids_update (TrackerSteroids* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation);
static void _dbus_tracker_steroids_update_ready (GObject * source_object,
                                          GAsyncResult * _res_,
                                          gpointer _user_data_);
static void _dbus_tracker_steroids_batch_update (TrackerSteroids* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_tracker_steroids_batch_update_ready (GObject * source_object,
                                                GAsyncResult * _res_,
                                                gpointer _user_data_);
static void _dbus_tracker_steroids_update_blank (TrackerSteroids* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_tracker_steroids_update_blank_ready (GObject * source_object,
                                                GAsyncResult * _res_,
                                                gpointer _user_data_);
static void _dbus_tracker_steroids_batch_update_blank (TrackerSteroids* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void _dbus_tracker_steroids_batch_update_blank_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_);
static void _dbus_tracker_steroids_update_array (TrackerSteroids* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_tracker_steroids_update_array_ready (GObject * source_object,
                                                GAsyncResult * _res_,
                                                gpointer _user_data_);
static void tracker_steroids_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data);
static GVariant* tracker_steroids_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data);
static gboolean tracker_steroids_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data);
static void _tracker_steroids_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _tracker_steroids_dbus_arg_info_query_query = {-1, "query", "s", NULL};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_query_output_stream = {-1, "output_stream", "h", NULL};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_query_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_query_in[] = {&_tracker_steroids_dbus_arg_info_query_query, &_tracker_steroids_dbus_arg_info_query_output_stream, NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_query_out[] = {&_tracker_steroids_dbus_arg_info_query_result, NULL};
static const GDBusMethodInfo _tracker_steroids_dbus_method_info_query = {-1, "Query", (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_query_in), (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_query_out), NULL};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_update_input_stream = {-1, "input_stream", "h", NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_update_in[] = {&_tracker_steroids_dbus_arg_info_update_input_stream, NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_steroids_dbus_method_info_update = {-1, "Update", (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_update_in), (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_update_out), NULL};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_batch_update_input_stream = {-1, "input_stream", "h", NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_batch_update_in[] = {&_tracker_steroids_dbus_arg_info_batch_update_input_stream, NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_batch_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_steroids_dbus_method_info_batch_update = {-1, "BatchUpdate", (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_batch_update_in), (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_batch_update_out), NULL};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_update_blank_input_stream = {-1, "input_stream", "h", NULL};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_update_blank_result = {-1, "result", "aaa{ss}", NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_update_blank_in[] = {&_tracker_steroids_dbus_arg_info_update_blank_input_stream, NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_update_blank_out[] = {&_tracker_steroids_dbus_arg_info_update_blank_result, NULL};
static const GDBusMethodInfo _tracker_steroids_dbus_method_info_update_blank = {-1, "UpdateBlank", (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_update_blank_in), (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_update_blank_out), NULL};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_batch_update_blank_input_stream = {-1, "input_stream", "h", NULL};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_batch_update_blank_result = {-1, "result", "aaa{ss}", NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_batch_update_blank_in[] = {&_tracker_steroids_dbus_arg_info_batch_update_blank_input_stream, NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_batch_update_blank_out[] = {&_tracker_steroids_dbus_arg_info_batch_update_blank_result, NULL};
static const GDBusMethodInfo _tracker_steroids_dbus_method_info_batch_update_blank = {-1, "BatchUpdateBlank", (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_batch_update_blank_in), (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_batch_update_blank_out), NULL};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_update_array_input_stream = {-1, "input_stream", "h", NULL};
static const GDBusArgInfo _tracker_steroids_dbus_arg_info_update_array_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_update_array_in[] = {&_tracker_steroids_dbus_arg_info_update_array_input_stream, NULL};
static const GDBusArgInfo * const _tracker_steroids_dbus_arg_info_update_array_out[] = {&_tracker_steroids_dbus_arg_info_update_array_result, NULL};
static const GDBusMethodInfo _tracker_steroids_dbus_method_info_update_array = {-1, "UpdateArray", (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_update_array_in), (GDBusArgInfo **) (&_tracker_steroids_dbus_arg_info_update_array_out), NULL};
static const GDBusMethodInfo * const _tracker_steroids_dbus_method_info[] = {&_tracker_steroids_dbus_method_info_query, &_tracker_steroids_dbus_method_info_update, &_tracker_steroids_dbus_method_info_batch_update, &_tracker_steroids_dbus_method_info_update_blank, &_tracker_steroids_dbus_method_info_batch_update_blank, &_tracker_steroids_dbus_method_info_update_array, NULL};
static const GDBusSignalInfo * const _tracker_steroids_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _tracker_steroids_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _tracker_steroids_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Steroids", (GDBusMethodInfo **) (&_tracker_steroids_dbus_method_info), (GDBusSignalInfo **) (&_tracker_steroids_dbus_signal_info), (GDBusPropertyInfo **) (&_tracker_steroids_dbus_property_info), NULL};
static const GDBusInterfaceVTable _tracker_steroids_dbus_interface_vtable = {tracker_steroids_dbus_interface_method_call, tracker_steroids_dbus_interface_get_property, tracker_steroids_dbus_interface_set_property};

static void
tracker_steroids_query_data_free (gpointer _data)
{
	TrackerSteroidsQueryData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_free0 (_data_->query);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSteroidsQueryData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
tracker_steroids_query (TrackerSteroids* self,
                        const char* sender,
                        const gchar* query,
                        GUnixOutputStream* output_stream,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	TrackerSteroidsQueryData* _data_;
	TrackerSteroids* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
	GUnixOutputStream* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (query != NULL);
	g_return_if_fail (output_stream != NULL);
	_data_ = g_slice_new0 (TrackerSteroidsQueryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_steroids_query_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	_tmp2_ = g_strdup (query);
	_g_free0 (_data_->query);
	_data_->query = _tmp2_;
	_tmp3_ = _g_object_ref0 (output_stream);
	_g_object_unref0 (_data_->output_stream);
	_data_->output_stream = _tmp3_;
	tracker_steroids_query_co (_data_);
}

gchar**
tracker_steroids_query_finish (TrackerSteroids* self,
                               GAsyncResult* _res_,
                               gint* result_length1,
                               GError** error)
{
	gchar** result;
	TrackerSteroidsQueryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		TrackerSteroids* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->output_stream);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		TrackerSteroids* self;
		self = _data6_->_data5_->self;
		_data6_->variable_names = (_vala_array_free (_data6_->variable_names, _data6_->variable_names_length1, (GDestroyNotify) g_free), NULL);
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}

static void
___lambda14_ (Block6Data* _data6_,
              TrackerSparqlCursor* cursor,
              GError** error)
{
	Block5Data* _data5_;
	TrackerSteroids* self;
	GDataOutputStream* data_output_stream = NULL;
	GBufferedOutputStream* _tmp0_;
	GBufferedOutputStream* _tmp1_;
	GDataOutputStream* _tmp2_;
	GDataOutputStream* _tmp3_;
	GDataOutputStream* _tmp4_;
	gint n_columns = 0;
	gint _tmp5_;
	gint _tmp6_;
	gint* column_sizes = NULL;
	gint* _tmp7_;
	gint column_sizes_length1;
	gint _column_sizes_size_;
	gint* column_offsets = NULL;
	gint* _tmp8_;
	gint column_offsets_length1;
	gint _column_offsets_size_;
	gchar** column_data = NULL;
	gchar** _tmp9_;
	gint column_data_length1;
	gint _column_data_size_;
	gchar** _tmp10_;
	GError* _inner_error0_ = NULL;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_return_if_fail (cursor != NULL);
	_tmp0_ = (GBufferedOutputStream*) g_buffered_output_stream_new_sized ((GOutputStream*) _data5_->output_stream, (gsize) TRACKER_STEROIDS_BUFFER_SIZE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_data_output_stream_new ((GOutputStream*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	data_output_stream = _tmp3_;
	_tmp4_ = data_output_stream;
	g_data_output_stream_set_byte_order (_tmp4_, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
	_tmp5_ = tracker_sparql_cursor_get_n_columns (cursor);
	_tmp6_ = _tmp5_;
	n_columns = _tmp6_;
	_tmp7_ = g_new0 (gint, n_columns);
	column_sizes = _tmp7_;
	column_sizes_length1 = n_columns;
	_column_sizes_size_ = column_sizes_length1;
	_tmp8_ = g_new0 (gint, n_columns);
	column_offsets = _tmp8_;
	column_offsets_length1 = n_columns;
	_column_offsets_size_ = column_offsets_length1;
	_tmp9_ = g_new0 (gchar*, n_columns + 1);
	column_data = _tmp9_;
	column_data_length1 = n_columns;
	_column_data_size_ = column_data_length1;
	_tmp10_ = g_new0 (gchar*, n_columns + 1);
	_data6_->variable_names = (_vala_array_free (_data6_->variable_names, _data6_->variable_names_length1, (GDestroyNotify) g_free), NULL);
	_data6_->variable_names = _tmp10_;
	_data6_->variable_names_length1 = n_columns;
	_data6_->_variable_names_size_ = _data6_->variable_names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				const gchar* _tmp13_;
				gchar* _tmp14_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(i < n_columns)) {
					break;
				}
				_tmp13_ = tracker_sparql_cursor_get_variable_name (cursor, i);
				_tmp14_ = g_strdup (_tmp13_);
				_g_free0 (_data6_->variable_names[i]);
				_data6_->variable_names[i] = _tmp14_;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp15_ = FALSE;
		gint last_offset = 0;
		GDataOutputStream* _tmp31_;
		_tmp15_ = tracker_sparql_cursor_next (cursor, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
			column_offsets = (g_free (column_offsets), NULL);
			column_sizes = (g_free (column_sizes), NULL);
			_g_object_unref0 (data_output_stream);
			return;
		}
		if (!_tmp15_) {
			break;
		}
		last_offset = -1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					const gchar* str = NULL;
					const gchar* _tmp18_;
					gint _tmp19_ = 0;
					const gchar* _tmp20_;
					gint* _tmp24_;
					gint _tmp24__length1;
					gchar** _tmp25_;
					gint _tmp25__length1;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gint* _tmp28_;
					gint _tmp28__length1;
					gint _tmp29_;
					gint* _tmp30_;
					gint _tmp30__length1;
					if (!_tmp16_) {
						gint _tmp17_;
						_tmp17_ = i;
						i = _tmp17_ + 1;
					}
					_tmp16_ = FALSE;
					if (!(i < n_columns)) {
						break;
					}
					_tmp18_ = tracker_sparql_cursor_get_string (cursor, i, NULL);
					str = _tmp18_;
					_tmp20_ = str;
					if (_tmp20_ != NULL) {
						const gchar* _tmp21_;
						gint _tmp22_;
						gint _tmp23_;
						_tmp21_ = str;
						_tmp22_ = strlen (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp19_ = _tmp23_;
					} else {
						_tmp19_ = 0;
					}
					_tmp24_ = column_sizes;
					_tmp24__length1 = column_sizes_length1;
					_tmp24_[i] = _tmp19_;
					_tmp25_ = column_data;
					_tmp25__length1 = column_data_length1;
					_tmp26_ = str;
					_tmp27_ = g_strdup (_tmp26_);
					_g_free0 (_tmp25_[i]);
					_tmp25_[i] = _tmp27_;
					_tmp28_ = column_sizes;
					_tmp28__length1 = column_sizes_length1;
					_tmp29_ = _tmp28_[i];
					last_offset += _tmp29_ + 1;
					_tmp30_ = column_offsets;
					_tmp30__length1 = column_offsets_length1;
					_tmp30_[i] = last_offset;
				}
			}
		}
		_tmp31_ = data_output_stream;
		g_data_output_stream_put_int32 (_tmp31_, (gint32) n_columns, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
			column_offsets = (g_free (column_offsets), NULL);
			column_sizes = (g_free (column_sizes), NULL);
			_g_object_unref0 (data_output_stream);
			return;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp32_ = FALSE;
				_tmp32_ = TRUE;
				while (TRUE) {
					GDataOutputStream* _tmp34_;
					if (!_tmp32_) {
						gint _tmp33_;
						_tmp33_ = i;
						i = _tmp33_ + 1;
					}
					_tmp32_ = FALSE;
					if (!(i < n_columns)) {
						break;
					}
					_tmp34_ = data_output_stream;
					g_data_output_stream_put_int32 (_tmp34_, (gint32) ((gint) tracker_sparql_cursor_get_value_type (cursor, i)), NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
						column_offsets = (g_free (column_offsets), NULL);
						column_sizes = (g_free (column_sizes), NULL);
						_g_object_unref0 (data_output_stream);
						return;
					}
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp35_ = FALSE;
				_tmp35_ = TRUE;
				while (TRUE) {
					GDataOutputStream* _tmp37_;
					gint* _tmp38_;
					gint _tmp38__length1;
					gint _tmp39_;
					if (!_tmp35_) {
						gint _tmp36_;
						_tmp36_ = i;
						i = _tmp36_ + 1;
					}
					_tmp35_ = FALSE;
					if (!(i < n_columns)) {
						break;
					}
					_tmp37_ = data_output_stream;
					_tmp38_ = column_offsets;
					_tmp38__length1 = column_offsets_length1;
					_tmp39_ = _tmp38_[i];
					g_data_output_stream_put_int32 (_tmp37_, (gint32) _tmp39_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
						column_offsets = (g_free (column_offsets), NULL);
						column_sizes = (g_free (column_sizes), NULL);
						_g_object_unref0 (data_output_stream);
						return;
					}
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp40_ = FALSE;
				_tmp40_ = TRUE;
				while (TRUE) {
					const gchar* _tmp42_ = NULL;
					gchar** _tmp43_;
					gint _tmp43__length1;
					const gchar* _tmp44_;
					GDataOutputStream* _tmp47_;
					GDataOutputStream* _tmp48_;
					if (!_tmp40_) {
						gint _tmp41_;
						_tmp41_ = i;
						i = _tmp41_ + 1;
					}
					_tmp40_ = FALSE;
					if (!(i < n_columns)) {
						break;
					}
					_tmp43_ = column_data;
					_tmp43__length1 = column_data_length1;
					_tmp44_ = _tmp43_[i];
					if (_tmp44_ != NULL) {
						gchar** _tmp45_;
						gint _tmp45__length1;
						const gchar* _tmp46_;
						_tmp45_ = column_data;
						_tmp45__length1 = column_data_length1;
						_tmp46_ = _tmp45_[i];
						_tmp42_ = _tmp46_;
					} else {
						_tmp42_ = "";
					}
					_tmp47_ = data_output_stream;
					g_data_output_stream_put_string (_tmp47_, _tmp42_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
						column_offsets = (g_free (column_offsets), NULL);
						column_sizes = (g_free (column_sizes), NULL);
						_g_object_unref0 (data_output_stream);
						return;
					}
					_tmp48_ = data_output_stream;
					g_data_output_stream_put_byte (_tmp48_, (guint8) 0, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
						column_offsets = (g_free (column_offsets), NULL);
						column_sizes = (g_free (column_sizes), NULL);
						_g_object_unref0 (data_output_stream);
						return;
					}
				}
			}
		}
	}
	column_data = (_vala_array_free (column_data, column_data_length1, (GDestroyNotify) g_free), NULL);
	column_offsets = (g_free (column_offsets), NULL);
	column_sizes = (g_free (column_sizes), NULL);
	_g_object_unref0 (data_output_stream);
}

static void
____lambda14__tracker_store_sparql_query_in_thread (TrackerSparqlCursor* cursor,
                                                    gpointer self,
                                                    GError** error)
{
	___lambda14_ (self, cursor, error);
}

static void
tracker_steroids_query_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	TrackerSteroidsQueryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_steroids_query_co (_data_);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
tracker_steroids_query_co (TrackerSteroidsQueryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data5_->output_stream);
	_data_->_data5_->output_stream = _data_->output_stream;
	_data_->_data5_->_async_data_ = _data_;
	_data_->_tmp0_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Steroids.Query", NULL);
	_data_->request = _data_->_tmp0_;
	tracker_dbus_request_debug (_data_->request, "query: %s", _data_->query, NULL);
	{
		_data_->_data6_ = g_slice_new0 (Block6Data);
		_data_->_data6_->_ref_count_ = 1;
		_data_->_data6_->_data5_ = block5_data_ref (_data_->_data5_);
		_data_->_data6_->variable_names = NULL;
		_data_->_data6_->variable_names_length1 = 0;
		_data_->_data6_->_variable_names_size_ = _data_->_data6_->variable_names_length1;
		_data_->_tmp1_ = tracker_main_get_sparql_connection ();
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->sparql_conn = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->sparql_conn;
		_data_->_tmp4_ = _data_->query;
		_data_->_tmp5_ = _data_->sender;
		_data_->_state_ = 1;
		tracker_store_sparql_query (_data_->_tmp3_, _data_->_tmp4_, G_PRIORITY_HIGH, ____lambda14__tracker_store_sparql_query_in_thread, _data_->_data6_, (const gchar*) _data_->_tmp5_, tracker_steroids_query_ready, _data_);
		return FALSE;
		_state_1:
		tracker_store_sparql_query_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->sparql_conn);
			block6_data_unref (_data_->_data6_);
			_data_->_data6_ = NULL;
			goto __catch0_g_error;
		}
		tracker_dbus_request_end (_data_->request, NULL);
		_data_->_tmp6_ = (_data_->_data6_->variable_names != NULL) ? _vala_array_dup1 (_data_->_data6_->variable_names, _data_->_data6_->variable_names_length1) : _data_->_data6_->variable_names;
		_data_->_tmp6__length1 = _data_->_data6_->variable_names_length1;
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp7__length1 = _data_->_tmp6__length1;
		_data_->result_length1 = _data_->_tmp7__length1;
		_data_->result = _data_->_tmp7_;
		_g_object_unref0 (_data_->sparql_conn);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->e;
		tracker_dbus_request_end (_data_->request, _data_->_tmp8_);
		_data_->_tmp9_ = _data_->e;
		if (_data_->_tmp9_->domain == TRACKER_SPARQL_ERROR) {
			_data_->_tmp10_ = _data_->e;
			_data_->_tmp11_ = _g_error_copy0 (_data_->_tmp10_);
			_data_->_inner_error0_ = _data_->_tmp11_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		} else {
			_data_->_tmp12_ = _data_->e;
			_data_->_tmp13_ = _data_->_tmp12_->message;
			_data_->_tmp14_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp13_);
			_data_->_inner_error0_ = _data_->_tmp14_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_steroids_update_internal_data_free (gpointer _data)
{
	TrackerSteroidsUpdateInternalData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_object_unref0 (_data_->input_stream);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSteroidsUpdateInternalData, _data_);
}

static void
tracker_steroids_update_internal (TrackerSteroids* self,
                                  const char* sender,
                                  gint priority,
                                  gboolean blank,
                                  GUnixInputStream* input_stream,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	TrackerSteroidsUpdateInternalData* _data_;
	TrackerSteroids* _tmp0_;
	char* _tmp1_;
	GUnixInputStream* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (input_stream != NULL);
	_data_ = g_slice_new0 (TrackerSteroidsUpdateInternalData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_steroids_update_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	_data_->priority = priority;
	_data_->blank = blank;
	_tmp2_ = _g_object_ref0 (input_stream);
	_g_object_unref0 (_data_->input_stream);
	_data_->input_stream = _tmp2_;
	tracker_steroids_update_internal_co (_data_);
}

static GVariant*
tracker_steroids_update_internal_finish (TrackerSteroids* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GVariant* result;
	TrackerSteroidsUpdateInternalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_steroids_update_internal_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	TrackerSteroidsUpdateInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_steroids_update_internal_co (_data_);
}

static gboolean
tracker_steroids_update_internal_co (TrackerSteroidsUpdateInternalData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->priority != G_PRIORITY_HIGH) {
		_data_->_tmp0_ = "Batch";
	} else {
		_data_->_tmp0_ = "";
	}
	if (_data_->blank) {
		_data_->_tmp1_ = "Blank";
	} else {
		_data_->_tmp1_ = "";
	}
	_data_->_tmp2_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Steroids.%sUpdate%s", _data_->_tmp0_, _data_->_tmp1_, NULL);
	_data_->request = _data_->_tmp2_;
	{
		_data_->_tmp3_ = g_data_input_stream_new ((GInputStream*) _data_->input_stream);
		_data_->data_input_stream = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->data_input_stream;
		g_buffered_input_stream_set_buffer_size ((GBufferedInputStream*) _data_->_tmp4_, (gsize) TRACKER_STEROIDS_BUFFER_SIZE);
		_data_->_tmp5_ = _data_->data_input_stream;
		g_data_input_stream_set_byte_order (_data_->_tmp5_, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
		_data_->_tmp6_ = _data_->data_input_stream;
		_data_->query_size = (gint) g_data_input_stream_read_int32 (_data_->_tmp6_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->data_input_stream);
			if (g_error_matches (_data_->_inner_error0_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
				goto __catch0_tracker_db_no_space;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = g_new0 (guint8, _data_->query_size + 1);
		_data_->query = _data_->_tmp7_;
		_data_->query_length1 = _data_->query_size + 1;
		_data_->_query_size_ = _data_->query_length1;
		_data_->_tmp8_ = _data_->data_input_stream;
		_data_->_tmp9_ = _data_->query;
		_data_->_tmp9__length1 = _data_->query_length1;
		_data_->_tmp10_ = 0UL;
		g_input_stream_read_all ((GInputStream*) _data_->_tmp8_, _data_->_tmp9_ + 0, (gsize) (_data_->query_size - 0), &_data_->_tmp10_, NULL, &_data_->_inner_error0_);
		_data_->bytes_read = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_data_->query = (g_free (_data_->query), NULL);
			_g_object_unref0 (_data_->data_input_stream);
			if (g_error_matches (_data_->_inner_error0_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
				goto __catch0_tracker_db_no_space;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->data_input_stream);
		_data_->data_input_stream = NULL;
		_data_->_tmp11_ = _data_->request;
		_data_->_tmp12_ = _data_->query;
		_data_->_tmp12__length1 = _data_->query_length1;
		tracker_dbus_request_debug (_data_->_tmp11_, "query: %s", (const gchar*) _data_->_tmp12_, NULL);
		_data_->_tmp13_ = tracker_main_get_sparql_connection ();
		_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
		_data_->sparql_conn = _data_->_tmp14_;
		if (!_data_->blank) {
			_data_->_tmp15_ = _data_->sparql_conn;
			_data_->_tmp16_ = _data_->query;
			_data_->_tmp16__length1 = _data_->query_length1;
			_data_->_state_ = 1;
			tracker_store_sparql_update (_data_->_tmp15_, (const gchar*) _data_->_tmp16_, _data_->priority, (const gchar*) _data_->sender, tracker_steroids_update_internal_ready, _data_);
			return FALSE;
			_state_1:
			tracker_store_sparql_update_finish (_data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->sparql_conn);
				_data_->query = (g_free (_data_->query), NULL);
				_g_object_unref0 (_data_->data_input_stream);
				if (g_error_matches (_data_->_inner_error0_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
					goto __catch0_tracker_db_no_space;
				}
				goto __catch0_g_error;
			}
			_data_->_tmp17_ = _data_->request;
			tracker_dbus_request_end (_data_->_tmp17_, NULL);
			_data_->result = NULL;
			_g_object_unref0 (_data_->sparql_conn);
			_data_->query = (g_free (_data_->query), NULL);
			_g_object_unref0 (_data_->data_input_stream);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp18_ = _data_->sparql_conn;
			_data_->_tmp19_ = _data_->query;
			_data_->_tmp19__length1 = _data_->query_length1;
			_data_->_state_ = 2;
			tracker_store_sparql_update_blank (_data_->_tmp18_, (const gchar*) _data_->_tmp19_, _data_->priority, (const gchar*) _data_->sender, tracker_steroids_update_internal_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp20_ = tracker_store_sparql_update_blank_finish (_data_->_res_, &_data_->_inner_error0_);
			_data_->variant = _data_->_tmp20_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->sparql_conn);
				_data_->query = (g_free (_data_->query), NULL);
				_g_object_unref0 (_data_->data_input_stream);
				if (g_error_matches (_data_->_inner_error0_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
					goto __catch0_tracker_db_no_space;
				}
				goto __catch0_g_error;
			}
			_data_->_tmp21_ = _data_->request;
			tracker_dbus_request_end (_data_->_tmp21_, NULL);
			_data_->result = _data_->variant;
			_g_object_unref0 (_data_->sparql_conn);
			_data_->query = (g_free (_data_->query), NULL);
			_g_object_unref0 (_data_->data_input_stream);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->sparql_conn);
		_data_->query = (g_free (_data_->query), NULL);
		_g_object_unref0 (_data_->data_input_stream);
	}
	goto __finally0;
	__catch0_tracker_db_no_space:
	{
		_data_->ie = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp22_ = _data_->ie;
		_data_->_tmp23_ = _data_->_tmp22_->message;
		_data_->_tmp24_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp23_);
		_data_->_inner_error0_ = _data_->_tmp24_;
		_g_error_free0 (_data_->ie);
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp25_ = _data_->request;
		_data_->_tmp26_ = _data_->e;
		tracker_dbus_request_end (_data_->_tmp25_, _data_->_tmp26_);
		_data_->_tmp27_ = _data_->e;
		if (_data_->_tmp27_->domain == TRACKER_SPARQL_ERROR) {
			_data_->_tmp28_ = _data_->e;
			_data_->_tmp29_ = _g_error_copy0 (_data_->_tmp28_);
			_data_->_inner_error0_ = _data_->_tmp29_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		} else {
			_data_->_tmp30_ = _data_->e;
			_data_->_tmp31_ = _data_->_tmp30_->message;
			_data_->_tmp32_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp31_);
			_data_->_inner_error0_ = _data_->_tmp32_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_steroids_update_data_free (gpointer _data)
{
	TrackerSteroidsUpdateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_object_unref0 (_data_->input_stream);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSteroidsUpdateData, _data_);
}

void
tracker_steroids_update (TrackerSteroids* self,
                         const char* sender,
                         GUnixInputStream* input_stream,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	TrackerSteroidsUpdateData* _data_;
	TrackerSteroids* _tmp0_;
	char* _tmp1_;
	GUnixInputStream* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (input_stream != NULL);
	_data_ = g_slice_new0 (TrackerSteroidsUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_steroids_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	_tmp2_ = _g_object_ref0 (input_stream);
	_g_object_unref0 (_data_->input_stream);
	_data_->input_stream = _tmp2_;
	tracker_steroids_update_co (_data_);
}

void
tracker_steroids_update_finish (TrackerSteroids* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	TrackerSteroidsUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
tracker_steroids_update_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	TrackerSteroidsUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_steroids_update_co (_data_);
}

static gboolean
tracker_steroids_update_co (TrackerSteroidsUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	tracker_steroids_update_internal (_data_->self, _data_->sender, G_PRIORITY_HIGH, FALSE, _data_->input_stream, tracker_steroids_update_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = tracker_steroids_update_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_variant_unref0 (_data_->_tmp1_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_steroids_batch_update_data_free (gpointer _data)
{
	TrackerSteroidsBatchUpdateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_object_unref0 (_data_->input_stream);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSteroidsBatchUpdateData, _data_);
}

void
tracker_steroids_batch_update (TrackerSteroids* self,
                               const char* sender,
                               GUnixInputStream* input_stream,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	TrackerSteroidsBatchUpdateData* _data_;
	TrackerSteroids* _tmp0_;
	char* _tmp1_;
	GUnixInputStream* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (input_stream != NULL);
	_data_ = g_slice_new0 (TrackerSteroidsBatchUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_steroids_batch_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	_tmp2_ = _g_object_ref0 (input_stream);
	_g_object_unref0 (_data_->input_stream);
	_data_->input_stream = _tmp2_;
	tracker_steroids_batch_update_co (_data_);
}

void
tracker_steroids_batch_update_finish (TrackerSteroids* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	TrackerSteroidsBatchUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
tracker_steroids_batch_update_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	TrackerSteroidsBatchUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_steroids_batch_update_co (_data_);
}

static gboolean
tracker_steroids_batch_update_co (TrackerSteroidsBatchUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	tracker_steroids_update_internal (_data_->self, _data_->sender, G_PRIORITY_LOW, FALSE, _data_->input_stream, tracker_steroids_batch_update_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = tracker_steroids_update_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_variant_unref0 (_data_->_tmp1_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_steroids_update_blank_data_free (gpointer _data)
{
	TrackerSteroidsUpdateBlankData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_object_unref0 (_data_->input_stream);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSteroidsUpdateBlankData, _data_);
}

void
tracker_steroids_update_blank (TrackerSteroids* self,
                               const char* sender,
                               GUnixInputStream* input_stream,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	TrackerSteroidsUpdateBlankData* _data_;
	TrackerSteroids* _tmp0_;
	char* _tmp1_;
	GUnixInputStream* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (input_stream != NULL);
	_data_ = g_slice_new0 (TrackerSteroidsUpdateBlankData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_steroids_update_blank_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	_tmp2_ = _g_object_ref0 (input_stream);
	_g_object_unref0 (_data_->input_stream);
	_data_->input_stream = _tmp2_;
	tracker_steroids_update_blank_co (_data_);
}

GVariant*
tracker_steroids_update_blank_finish (TrackerSteroids* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GVariant* result;
	TrackerSteroidsUpdateBlankData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_steroids_update_blank_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	TrackerSteroidsUpdateBlankData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_steroids_update_blank_co (_data_);
}

static gboolean
tracker_steroids_update_blank_co (TrackerSteroidsUpdateBlankData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	tracker_steroids_update_internal (_data_->self, _data_->sender, G_PRIORITY_HIGH, TRUE, _data_->input_stream, tracker_steroids_update_blank_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = tracker_steroids_update_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp2_;
	_g_variant_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_steroids_batch_update_blank_data_free (gpointer _data)
{
	TrackerSteroidsBatchUpdateBlankData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_object_unref0 (_data_->input_stream);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSteroidsBatchUpdateBlankData, _data_);
}

void
tracker_steroids_batch_update_blank (TrackerSteroids* self,
                                     const char* sender,
                                     GUnixInputStream* input_stream,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	TrackerSteroidsBatchUpdateBlankData* _data_;
	TrackerSteroids* _tmp0_;
	char* _tmp1_;
	GUnixInputStream* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (input_stream != NULL);
	_data_ = g_slice_new0 (TrackerSteroidsBatchUpdateBlankData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_steroids_batch_update_blank_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	_tmp2_ = _g_object_ref0 (input_stream);
	_g_object_unref0 (_data_->input_stream);
	_data_->input_stream = _tmp2_;
	tracker_steroids_batch_update_blank_co (_data_);
}

GVariant*
tracker_steroids_batch_update_blank_finish (TrackerSteroids* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GVariant* result;
	TrackerSteroidsBatchUpdateBlankData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_steroids_batch_update_blank_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	TrackerSteroidsBatchUpdateBlankData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_steroids_batch_update_blank_co (_data_);
}

static gboolean
tracker_steroids_batch_update_blank_co (TrackerSteroidsBatchUpdateBlankData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	tracker_steroids_update_internal (_data_->self, _data_->sender, G_PRIORITY_LOW, TRUE, _data_->input_stream, tracker_steroids_batch_update_blank_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = tracker_steroids_update_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp2_;
	_g_variant_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
tracker_steroids_update_array_data_free (gpointer _data)
{
	TrackerSteroidsUpdateArrayData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_g_object_unref0 (_data_->input_stream);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerSteroidsUpdateArrayData, _data_);
}

void
tracker_steroids_update_array (TrackerSteroids* self,
                               const char* sender,
                               GUnixInputStream* input_stream,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	TrackerSteroidsUpdateArrayData* _data_;
	TrackerSteroids* _tmp0_;
	char* _tmp1_;
	GUnixInputStream* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (input_stream != NULL);
	_data_ = g_slice_new0 (TrackerSteroidsUpdateArrayData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_steroids_update_array_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	_tmp2_ = _g_object_ref0 (input_stream);
	_g_object_unref0 (_data_->input_stream);
	_data_->input_stream = _tmp2_;
	tracker_steroids_update_array_co (_data_);
}

GVariant*
tracker_steroids_update_array_finish (TrackerSteroids* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GVariant* result;
	TrackerSteroidsUpdateArrayData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_steroids_update_array_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	TrackerSteroidsUpdateArrayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_steroids_update_array_co (_data_);
}

static gboolean
tracker_steroids_update_array_co (TrackerSteroidsUpdateArrayData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = tracker_dbus_request_begin ((const gchar*) _data_->sender, "Steroids.UpdateArray", NULL);
	_data_->request = _data_->_tmp0_;
	{
		_data_->_tmp1_ = g_data_input_stream_new ((GInputStream*) _data_->input_stream);
		_data_->data_input_stream = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->data_input_stream;
		g_buffered_input_stream_set_buffer_size ((GBufferedInputStream*) _data_->_tmp2_, (gsize) TRACKER_STEROIDS_BUFFER_SIZE);
		_data_->_tmp3_ = _data_->data_input_stream;
		g_data_input_stream_set_byte_order (_data_->_tmp3_, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
		_data_->_tmp4_ = _data_->data_input_stream;
		_data_->query_count = (gint) g_data_input_stream_read_int32 (_data_->_tmp4_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->data_input_stream);
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = g_string_new ("");
		_data_->combined_query = _data_->_tmp5_;
		_data_->_tmp6_ = g_new0 (gchar*, _data_->query_count + 1);
		_data_->query_array = _data_->_tmp6_;
		_data_->query_array_length1 = _data_->query_count;
		_data_->_query_array_size_ = _data_->query_array_length1;
		{
			_data_->i = 0;
			_data_->_tmp7_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp7_) {
					_data_->_tmp8_ = _data_->i;
					_data_->i = _data_->_tmp8_ + 1;
				}
				_data_->_tmp7_ = FALSE;
				if (!(_data_->i < _data_->query_count)) {
					break;
				}
				_data_->_tmp9_ = _data_->data_input_stream;
				_data_->query_size = (gint) g_data_input_stream_read_int32 (_data_->_tmp9_, NULL, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_data_->query_array = (_vala_array_free (_data_->query_array, _data_->query_array_length1, (GDestroyNotify) g_free), NULL);
					_g_string_free0 (_data_->combined_query);
					_g_object_unref0 (_data_->data_input_stream);
					goto __catch0_g_error;
				}
				_data_->_tmp10_ = _data_->query_array;
				_data_->_tmp10__length1 = _data_->query_array_length1;
				_data_->_tmp11_ = g_new0 (guint8, _data_->query_size + 1);
				_g_free0 (_data_->_tmp10_[_data_->i]);
				_data_->_tmp10_[_data_->i] = (gchar*) _data_->_tmp11_;
				_data_->_tmp12_ = _data_->data_input_stream;
				_data_->_tmp13_ = _data_->query_array;
				_data_->_tmp13__length1 = _data_->query_array_length1;
				_data_->_tmp14_ = _data_->_tmp13_[_data_->i];
				_data_->_tmp15_ = 0UL;
				g_input_stream_read_all ((GInputStream*) _data_->_tmp12_, ((guint8*) _data_->_tmp14_) + 0, (gsize) (_data_->query_size - 0), &_data_->_tmp15_, NULL, &_data_->_inner_error0_);
				_data_->bytes_read = _data_->_tmp15_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_data_->query_array = (_vala_array_free (_data_->query_array, _data_->query_array_length1, (GDestroyNotify) g_free), NULL);
					_g_string_free0 (_data_->combined_query);
					_g_object_unref0 (_data_->data_input_stream);
					goto __catch0_g_error;
				}
				_data_->_tmp16_ = _data_->request;
				_data_->_tmp17_ = _data_->query_array;
				_data_->_tmp17__length1 = _data_->query_array_length1;
				_data_->_tmp18_ = _data_->_tmp17_[_data_->i];
				tracker_dbus_request_debug (_data_->_tmp16_, "query: %s", _data_->_tmp18_, NULL);
				_data_->_tmp19_ = _data_->combined_query;
				_data_->_tmp20_ = _data_->query_array;
				_data_->_tmp20__length1 = _data_->query_array_length1;
				_data_->_tmp21_ = _data_->_tmp20_[_data_->i];
				g_string_append (_data_->_tmp19_, _data_->_tmp21_);
			}
		}
		_g_object_unref0 (_data_->data_input_stream);
		_data_->data_input_stream = NULL;
		_data_->_tmp22_ = g_variant_builder_new ((const GVariantType*) "as");
		_data_->builder = _data_->_tmp22_;
		_data_->_tmp23_ = tracker_main_get_sparql_connection ();
		_data_->_tmp24_ = _g_object_ref0 (_data_->_tmp23_);
		_data_->sparql_conn = _data_->_tmp24_;
		{
			_data_->_tmp25_ = _data_->sparql_conn;
			_data_->_tmp26_ = _data_->combined_query;
			_data_->_tmp27_ = _data_->_tmp26_->str;
			_data_->_state_ = 1;
			tracker_store_sparql_update (_data_->_tmp25_, _data_->_tmp27_, G_PRIORITY_LOW, (const gchar*) _data_->sender, tracker_steroids_update_array_ready, _data_);
			return FALSE;
			_state_1:
			tracker_store_sparql_update_finish (_data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			{
				_data_->i = 0;
				_data_->_tmp28_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp28_) {
						_data_->_tmp29_ = _data_->i;
						_data_->i = _data_->_tmp29_ + 1;
					}
					_data_->_tmp28_ = FALSE;
					if (!(_data_->i < _data_->query_count)) {
						break;
					}
					_data_->_tmp30_ = _data_->builder;
					g_variant_builder_add (_data_->_tmp30_, "s", "", NULL);
					_data_->_tmp31_ = _data_->builder;
					g_variant_builder_add (_data_->_tmp31_, "s", "", NULL);
				}
			}
			_data_->_tmp32_ = _data_->request;
			tracker_dbus_request_end (_data_->_tmp32_, NULL);
			_data_->_tmp33_ = _data_->builder;
			_data_->_tmp34_ = g_variant_builder_end (_data_->_tmp33_);
			g_variant_ref_sink (_data_->_tmp34_);
			_data_->result = _data_->_tmp34_;
			_g_object_unref0 (_data_->sparql_conn);
			_g_variant_builder_unref0 (_data_->builder);
			_data_->query_array = (_vala_array_free (_data_->query_array, _data_->query_array_length1, (GDestroyNotify) g_free), NULL);
			_g_string_free0 (_data_->combined_query);
			_g_object_unref0 (_data_->data_input_stream);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			_g_string_free0 (_data_->combined_query);
			_data_->combined_query = NULL;
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->sparql_conn);
			_g_variant_builder_unref0 (_data_->builder);
			_data_->query_array = (_vala_array_free (_data_->query_array, _data_->query_array_length1, (GDestroyNotify) g_free), NULL);
			_g_string_free0 (_data_->combined_query);
			_g_object_unref0 (_data_->data_input_stream);
			goto __catch0_g_error;
		}
		{
			_data_->i = 0;
			_data_->_tmp35_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp35_) {
					_data_->_tmp36_ = _data_->i;
					_data_->i = _data_->_tmp36_ + 1;
				}
				_data_->_tmp35_ = FALSE;
				if (!(_data_->i < _data_->query_count)) {
					break;
				}
				_data_->_tmp37_ = _data_->request;
				_data_->_tmp38_ = _data_->query_array;
				_data_->_tmp38__length1 = _data_->query_array_length1;
				_data_->_tmp39_ = _data_->_tmp38_[_data_->i];
				tracker_dbus_request_debug (_data_->_tmp37_, "query: %s", _data_->_tmp39_, NULL);
				{
					_data_->_tmp40_ = _data_->sparql_conn;
					_data_->_tmp41_ = _data_->query_array;
					_data_->_tmp41__length1 = _data_->query_array_length1;
					_data_->_tmp42_ = _data_->_tmp41_[_data_->i];
					_data_->_state_ = 2;
					tracker_store_sparql_update (_data_->_tmp40_, _data_->_tmp42_, G_PRIORITY_LOW, (const gchar*) _data_->sender, tracker_steroids_update_array_ready, _data_);
					return FALSE;
					_state_2:
					tracker_store_sparql_update_finish (_data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch2_g_error;
					}
					_data_->_tmp43_ = _data_->builder;
					g_variant_builder_add (_data_->_tmp43_, "s", "", NULL);
					_data_->_tmp44_ = _data_->builder;
					g_variant_builder_add (_data_->_tmp44_, "s", "", NULL);
				}
				goto __finally2;
				__catch2_g_error:
				{
					_data_->e1 = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp45_ = _data_->builder;
					g_variant_builder_add (_data_->_tmp45_, "s", "org.freedesktop.Tracker1.SparqlError.Internal", NULL);
					_data_->_tmp46_ = _data_->builder;
					_data_->_tmp47_ = _data_->e1;
					_data_->_tmp48_ = _data_->_tmp47_->message;
					g_variant_builder_add (_data_->_tmp46_, "s", _data_->_tmp48_, NULL);
					_g_error_free0 (_data_->e1);
				}
				__finally2:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->sparql_conn);
					_g_variant_builder_unref0 (_data_->builder);
					_data_->query_array = (_vala_array_free (_data_->query_array, _data_->query_array_length1, (GDestroyNotify) g_free), NULL);
					_g_string_free0 (_data_->combined_query);
					_g_object_unref0 (_data_->data_input_stream);
					goto __catch0_g_error;
				}
			}
		}
		_data_->_tmp49_ = _data_->request;
		tracker_dbus_request_end (_data_->_tmp49_, NULL);
		_data_->_tmp50_ = _data_->builder;
		_data_->_tmp51_ = g_variant_builder_end (_data_->_tmp50_);
		g_variant_ref_sink (_data_->_tmp51_);
		_data_->result = _data_->_tmp51_;
		_g_object_unref0 (_data_->sparql_conn);
		_g_variant_builder_unref0 (_data_->builder);
		_data_->query_array = (_vala_array_free (_data_->query_array, _data_->query_array_length1, (GDestroyNotify) g_free), NULL);
		_g_string_free0 (_data_->combined_query);
		_g_object_unref0 (_data_->data_input_stream);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp52_ = _data_->request;
		_data_->_tmp53_ = _data_->e;
		tracker_dbus_request_end (_data_->_tmp52_, _data_->_tmp53_);
		_data_->_tmp54_ = _data_->e;
		if (_data_->_tmp54_->domain == TRACKER_SPARQL_ERROR) {
			_data_->_tmp55_ = _data_->e;
			_data_->_tmp56_ = _g_error_copy0 (_data_->_tmp55_);
			_data_->_inner_error0_ = _data_->_tmp56_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		} else {
			_data_->_tmp57_ = _data_->e;
			_data_->_tmp58_ = _data_->_tmp57_->message;
			_data_->_tmp59_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp58_);
			_data_->_inner_error0_ = _data_->_tmp59_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

TrackerSteroids*
tracker_steroids_construct (GType object_type)
{
	TrackerSteroids * self = NULL;
	self = (TrackerSteroids*) g_object_new (object_type, NULL);
	return self;
}

TrackerSteroids*
tracker_steroids_new (void)
{
	return tracker_steroids_construct (TRACKER_TYPE_STEROIDS);
}

static void
tracker_steroids_class_init (TrackerSteroidsClass * klass,
                             gpointer klass_data)
{
	tracker_steroids_parent_class = g_type_class_peek_parent (klass);
}

static void
tracker_steroids_instance_init (TrackerSteroids * self,
                                gpointer klass)
{
}

static GType
tracker_steroids_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerSteroidsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_steroids_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSteroids), 0, (GInstanceInitFunc) tracker_steroids_instance_init, NULL };
	GType tracker_steroids_type_id;
	tracker_steroids_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSteroids", &g_define_type_info, 0);
	g_type_set_qdata (tracker_steroids_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) tracker_steroids_register_object);
	return tracker_steroids_type_id;
}

GType
tracker_steroids_get_type (void)
{
	static volatile gsize tracker_steroids_type_id__once = 0;
	if (g_once_init_enter (&tracker_steroids_type_id__once)) {
		GType tracker_steroids_type_id;
		tracker_steroids_type_id = tracker_steroids_get_type_once ();
		g_once_init_leave (&tracker_steroids_type_id__once, tracker_steroids_type_id);
	}
	return tracker_steroids_type_id__once;
}

static void
_dbus_tracker_steroids_query (TrackerSteroids* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GUnixFDList* _fd_list;
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	gint _fd;
	TrackerSteroidsQueryReadyData* _ready_data;
	GVariant* _tmp7_;
	GError* error = NULL;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (TrackerSteroidsQueryReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->query = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_fd_list = g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation));
	if (_fd_list) {
		g_variant_iter_next (&_arguments_iter, "h", &_fd_index);
		_fd = g_unix_fd_list_get (_fd_list, _fd_index, &error);
		if (_fd >= 0) {
			_ready_data->output_stream = (GUnixOutputStream *) g_unix_output_stream_new (_fd, TRUE);
		}
	} else {
		g_set_error_literal (&error, G_IO_ERROR, G_IO_ERROR_FAILED, "FD List is NULL");
	}
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	tracker_steroids_query (self, g_dbus_method_invocation_get_sender (invocation), _ready_data->query, _ready_data->output_stream, (GAsyncReadyCallback) _dbus_tracker_steroids_query_ready, _ready_data);
	_error:
	;
}

static void
_dbus_tracker_steroids_query_ready (GObject * source_object,
                                    GAsyncResult * _res_,
                                    gpointer _user_data_)
{
	TrackerSteroidsQueryReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GUnixFDList* _fd_list;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp8_;
	GVariantBuilder _tmp9_;
	gint _tmp10_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = tracker_steroids_query_finish ((TrackerSteroids*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	_tmp8_ = result;
	g_variant_builder_init (&_tmp9_, G_VARIANT_TYPE ("as"));
	for (_tmp10_ = 0; _tmp10_ < result_length1; _tmp10_++) {
		g_variant_builder_add_value (&_tmp9_, g_variant_new_string (*_tmp8_));
		_tmp8_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp9_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->query);
	_g_object_unref0 (_ready_data->output_stream);
	g_slice_free (TrackerSteroidsQueryReadyData, _ready_data);
}

static void
_dbus_tracker_steroids_update (TrackerSteroids* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation)
{
	GUnixFDList* _fd_list;
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	gint _fd;
	TrackerSteroidsUpdateReadyData* _ready_data;
	GError* error = NULL;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (TrackerSteroidsUpdateReadyData);
	_ready_data->_invocation_ = invocation;
	_fd_list = g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation));
	if (_fd_list) {
		g_variant_iter_next (&_arguments_iter, "h", &_fd_index);
		_fd = g_unix_fd_list_get (_fd_list, _fd_index, &error);
		if (_fd >= 0) {
			_ready_data->input_stream = (GUnixInputStream *) g_unix_input_stream_new (_fd, TRUE);
		}
	} else {
		g_set_error_literal (&error, G_IO_ERROR, G_IO_ERROR_FAILED, "FD List is NULL");
	}
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	tracker_steroids_update (self, g_dbus_method_invocation_get_sender (invocation), _ready_data->input_stream, (GAsyncReadyCallback) _dbus_tracker_steroids_update_ready, _ready_data);
	_error:
	;
}

static void
_dbus_tracker_steroids_update_ready (GObject * source_object,
                                     GAsyncResult * _res_,
                                     gpointer _user_data_)
{
	TrackerSteroidsUpdateReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GUnixFDList* _fd_list;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	tracker_steroids_update_finish ((TrackerSteroids*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_object_unref0 (_ready_data->input_stream);
	g_slice_free (TrackerSteroidsUpdateReadyData, _ready_data);
}

static void
_dbus_tracker_steroids_batch_update (TrackerSteroids* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GUnixFDList* _fd_list;
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	gint _fd;
	TrackerSteroidsBatchUpdateReadyData* _ready_data;
	GError* error = NULL;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (TrackerSteroidsBatchUpdateReadyData);
	_ready_data->_invocation_ = invocation;
	_fd_list = g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation));
	if (_fd_list) {
		g_variant_iter_next (&_arguments_iter, "h", &_fd_index);
		_fd = g_unix_fd_list_get (_fd_list, _fd_index, &error);
		if (_fd >= 0) {
			_ready_data->input_stream = (GUnixInputStream *) g_unix_input_stream_new (_fd, TRUE);
		}
	} else {
		g_set_error_literal (&error, G_IO_ERROR, G_IO_ERROR_FAILED, "FD List is NULL");
	}
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	tracker_steroids_batch_update (self, g_dbus_method_invocation_get_sender (invocation), _ready_data->input_stream, (GAsyncReadyCallback) _dbus_tracker_steroids_batch_update_ready, _ready_data);
	_error:
	;
}

static void
_dbus_tracker_steroids_batch_update_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_)
{
	TrackerSteroidsBatchUpdateReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GUnixFDList* _fd_list;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	tracker_steroids_batch_update_finish ((TrackerSteroids*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_object_unref0 (_ready_data->input_stream);
	g_slice_free (TrackerSteroidsBatchUpdateReadyData, _ready_data);
}

static void
_dbus_tracker_steroids_update_blank (TrackerSteroids* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GUnixFDList* _fd_list;
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	gint _fd;
	TrackerSteroidsUpdateBlankReadyData* _ready_data;
	GError* error = NULL;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (TrackerSteroidsUpdateBlankReadyData);
	_ready_data->_invocation_ = invocation;
	_fd_list = g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation));
	if (_fd_list) {
		g_variant_iter_next (&_arguments_iter, "h", &_fd_index);
		_fd = g_unix_fd_list_get (_fd_list, _fd_index, &error);
		if (_fd >= 0) {
			_ready_data->input_stream = (GUnixInputStream *) g_unix_input_stream_new (_fd, TRUE);
		}
	} else {
		g_set_error_literal (&error, G_IO_ERROR, G_IO_ERROR_FAILED, "FD List is NULL");
	}
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	tracker_steroids_update_blank (self, g_dbus_method_invocation_get_sender (invocation), _ready_data->input_stream, (GAsyncReadyCallback) _dbus_tracker_steroids_update_blank_ready, _ready_data);
	_error:
	;
}

static void
_dbus_tracker_steroids_update_blank_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_)
{
	TrackerSteroidsUpdateBlankReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GUnixFDList* _fd_list;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = tracker_steroids_update_blank_finish ((TrackerSteroids*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_object_unref0 (_ready_data->input_stream);
	g_slice_free (TrackerSteroidsUpdateBlankReadyData, _ready_data);
}

static void
_dbus_tracker_steroids_batch_update_blank (TrackerSteroids* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GUnixFDList* _fd_list;
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	gint _fd;
	TrackerSteroidsBatchUpdateBlankReadyData* _ready_data;
	GError* error = NULL;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (TrackerSteroidsBatchUpdateBlankReadyData);
	_ready_data->_invocation_ = invocation;
	_fd_list = g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation));
	if (_fd_list) {
		g_variant_iter_next (&_arguments_iter, "h", &_fd_index);
		_fd = g_unix_fd_list_get (_fd_list, _fd_index, &error);
		if (_fd >= 0) {
			_ready_data->input_stream = (GUnixInputStream *) g_unix_input_stream_new (_fd, TRUE);
		}
	} else {
		g_set_error_literal (&error, G_IO_ERROR, G_IO_ERROR_FAILED, "FD List is NULL");
	}
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	tracker_steroids_batch_update_blank (self, g_dbus_method_invocation_get_sender (invocation), _ready_data->input_stream, (GAsyncReadyCallback) _dbus_tracker_steroids_batch_update_blank_ready, _ready_data);
	_error:
	;
}

static void
_dbus_tracker_steroids_batch_update_blank_ready (GObject * source_object,
                                                 GAsyncResult * _res_,
                                                 gpointer _user_data_)
{
	TrackerSteroidsBatchUpdateBlankReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GUnixFDList* _fd_list;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = tracker_steroids_batch_update_blank_finish ((TrackerSteroids*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_object_unref0 (_ready_data->input_stream);
	g_slice_free (TrackerSteroidsBatchUpdateBlankReadyData, _ready_data);
}

static void
_dbus_tracker_steroids_update_array (TrackerSteroids* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GUnixFDList* _fd_list;
	GVariantIter _arguments_iter;
	gint _fd_index = 0;
	gint _fd;
	TrackerSteroidsUpdateArrayReadyData* _ready_data;
	GError* error = NULL;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (TrackerSteroidsUpdateArrayReadyData);
	_ready_data->_invocation_ = invocation;
	_fd_list = g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation));
	if (_fd_list) {
		g_variant_iter_next (&_arguments_iter, "h", &_fd_index);
		_fd = g_unix_fd_list_get (_fd_list, _fd_index, &error);
		if (_fd >= 0) {
			_ready_data->input_stream = (GUnixInputStream *) g_unix_input_stream_new (_fd, TRUE);
		}
	} else {
		g_set_error_literal (&error, G_IO_ERROR, G_IO_ERROR_FAILED, "FD List is NULL");
	}
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	tracker_steroids_update_array (self, g_dbus_method_invocation_get_sender (invocation), _ready_data->input_stream, (GAsyncReadyCallback) _dbus_tracker_steroids_update_array_ready, _ready_data);
	_error:
	;
}

static void
_dbus_tracker_steroids_update_array_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_)
{
	TrackerSteroidsUpdateArrayReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GUnixFDList* _fd_list;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = tracker_steroids_update_array_finish ((TrackerSteroids*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_fd_list = g_unix_fd_list_new ();
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_message_set_unix_fd_list (_reply_message, _fd_list);
	g_object_unref (_fd_list);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_object_unref0 (_ready_data->input_stream);
	g_slice_free (TrackerSteroidsUpdateArrayReadyData, _ready_data);
}

static void
tracker_steroids_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Query") == 0) {
		_dbus_tracker_steroids_query (object, parameters, invocation);
	} else if (strcmp (method_name, "Update") == 0) {
		_dbus_tracker_steroids_update (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchUpdate") == 0) {
		_dbus_tracker_steroids_batch_update (object, parameters, invocation);
	} else if (strcmp (method_name, "UpdateBlank") == 0) {
		_dbus_tracker_steroids_update_blank (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchUpdateBlank") == 0) {
		_dbus_tracker_steroids_batch_update_blank (object, parameters, invocation);
	} else if (strcmp (method_name, "UpdateArray") == 0) {
		_dbus_tracker_steroids_update_array (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
tracker_steroids_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
tracker_steroids_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
tracker_steroids_register_object (gpointer object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_tracker_steroids_dbus_interface_info), &_tracker_steroids_dbus_interface_vtable, data, _tracker_steroids_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_tracker_steroids_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

