// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATmega162.atdf, see http://packs.download.atmel.com/

//go:build avr && atmega162
// +build avr,atmega162

// Device information for the ATmega162.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATmega162"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin,Power-on Reset,Brown-out Reset,Watchdog Reset,and JTAG AVR Reset. See Datasheet.
	IRQ_INT0         = 1  // External Interrupt Request 0
	IRQ_INT1         = 2  // External Interrupt Request 1
	IRQ_INT2         = 3  // External Interrupt Request 2
	IRQ_PCINT0       = 4  // Pin Change Interrupt Request 0
	IRQ_PCINT1       = 5  // Pin Change Interrupt Request 1
	IRQ_TIMER3_CAPT  = 6  // Timer/Counter3 Capture Event
	IRQ_TIMER3_COMPA = 7  // Timer/Counter3 Compare Match A
	IRQ_TIMER3_COMPB = 8  // Timer/Counter3 Compare Match B
	IRQ_TIMER3_OVF   = 9  // Timer/Counter3 Overflow
	IRQ_TIMER2_COMP  = 10 // Timer/Counter2 Compare Match
	IRQ_TIMER2_OVF   = 11 // Timer/Counter2 Overflow
	IRQ_TIMER1_CAPT  = 12 // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 13 // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 14 // Timer/Counter Compare Match B
	IRQ_TIMER1_OVF   = 15 // Timer/Counter1 Overflow
	IRQ_TIMER0_COMP  = 16 // Timer/Counter0 Compare Match
	IRQ_TIMER0_OVF   = 17 // Timer/Counter0 Overflow
	IRQ_SPI_STC      = 18 // SPI Serial Transfer Complete
	IRQ_USART0_RXC   = 19 // USART0, Rx Complete
	IRQ_USART1_RXC   = 20 // USART1, Rx Complete
	IRQ_USART0_UDRE  = 21 // USART0 Data register Empty
	IRQ_USART1_UDRE  = 22 // USART1, Data register Empty
	IRQ_USART0_TXC   = 23 // USART0, Tx Complete
	IRQ_USART1_TXC   = 24 // USART1, Tx Complete
	IRQ_EE_RDY       = 25 // EEPROM Ready
	IRQ_ANA_COMP     = 26 // Analog Comparator
	IRQ_SPM_RDY      = 27 // Store Program Memory Read
	IRQ_max          = 27 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_INT1
//go:interrupt
func interruptINT1() {
	callHandlers(IRQ_INT1)
}

//export __vector_INT2
//go:interrupt
func interruptINT2() {
	callHandlers(IRQ_INT2)
}

//export __vector_PCINT0
//go:interrupt
func interruptPCINT0() {
	callHandlers(IRQ_PCINT0)
}

//export __vector_PCINT1
//go:interrupt
func interruptPCINT1() {
	callHandlers(IRQ_PCINT1)
}

//export __vector_TIMER3_CAPT
//go:interrupt
func interruptTIMER3_CAPT() {
	callHandlers(IRQ_TIMER3_CAPT)
}

//export __vector_TIMER3_COMPA
//go:interrupt
func interruptTIMER3_COMPA() {
	callHandlers(IRQ_TIMER3_COMPA)
}

//export __vector_TIMER3_COMPB
//go:interrupt
func interruptTIMER3_COMPB() {
	callHandlers(IRQ_TIMER3_COMPB)
}

//export __vector_TIMER3_OVF
//go:interrupt
func interruptTIMER3_OVF() {
	callHandlers(IRQ_TIMER3_OVF)
}

//export __vector_TIMER2_COMP
//go:interrupt
func interruptTIMER2_COMP() {
	callHandlers(IRQ_TIMER2_COMP)
}

//export __vector_TIMER2_OVF
//go:interrupt
func interruptTIMER2_OVF() {
	callHandlers(IRQ_TIMER2_OVF)
}

//export __vector_TIMER1_CAPT
//go:interrupt
func interruptTIMER1_CAPT() {
	callHandlers(IRQ_TIMER1_CAPT)
}

//export __vector_TIMER1_COMPA
//go:interrupt
func interruptTIMER1_COMPA() {
	callHandlers(IRQ_TIMER1_COMPA)
}

//export __vector_TIMER1_COMPB
//go:interrupt
func interruptTIMER1_COMPB() {
	callHandlers(IRQ_TIMER1_COMPB)
}

//export __vector_TIMER1_OVF
//go:interrupt
func interruptTIMER1_OVF() {
	callHandlers(IRQ_TIMER1_OVF)
}

//export __vector_TIMER0_COMP
//go:interrupt
func interruptTIMER0_COMP() {
	callHandlers(IRQ_TIMER0_COMP)
}

//export __vector_TIMER0_OVF
//go:interrupt
func interruptTIMER0_OVF() {
	callHandlers(IRQ_TIMER0_OVF)
}

//export __vector_SPI_STC
//go:interrupt
func interruptSPI_STC() {
	callHandlers(IRQ_SPI_STC)
}

//export __vector_USART0_RXC
//go:interrupt
func interruptUSART0_RXC() {
	callHandlers(IRQ_USART0_RXC)
}

//export __vector_USART1_RXC
//go:interrupt
func interruptUSART1_RXC() {
	callHandlers(IRQ_USART1_RXC)
}

//export __vector_USART0_UDRE
//go:interrupt
func interruptUSART0_UDRE() {
	callHandlers(IRQ_USART0_UDRE)
}

//export __vector_USART1_UDRE
//go:interrupt
func interruptUSART1_UDRE() {
	callHandlers(IRQ_USART1_UDRE)
}

//export __vector_USART0_TXC
//go:interrupt
func interruptUSART0_TXC() {
	callHandlers(IRQ_USART0_TXC)
}

//export __vector_USART1_TXC
//go:interrupt
func interruptUSART1_TXC() {
	callHandlers(IRQ_USART1_TXC)
}

//export __vector_EE_RDY
//go:interrupt
func interruptEE_RDY() {
	callHandlers(IRQ_EE_RDY)
}

//export __vector_ANA_COMP
//go:interrupt
func interruptANA_COMP() {
	callHandlers(IRQ_ANA_COMP)
}

//export __vector_SPM_RDY
//go:interrupt
func interruptSPM_RDY() {
	callHandlers(IRQ_SPM_RDY)
}

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Timer/Counter, 16-bit
	TIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x59)))
	TIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x58)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4f)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x49)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	ETIMSK = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7d)))
	ETIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	TCCR3A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	TCCR3B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	TCNT3L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	TCNT3H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR3AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	OCR3AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))
	OCR3BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	OCR3BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	ICR3L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	ICR3H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))

	// Timer/Counter, 8-bit Async
	TCCR2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	TCNT2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))
	OCR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	ASSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))

	// Analog Comparator
	ACSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))

	// USART
	UDR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))
	UCSR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	UCSR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	UCSR0C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	UBRR0H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	UBRR0L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	UDR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	UCSR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x22)))
	UCSR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x21)))
	UCSR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5c)))
	UBRR1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5c)))
	UBRR1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x20)))

	// Serial Peripheral Interface
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))

	// CPU Registers
	SREG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	MCUCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	EMCUCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x56)))
	OSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	CLKPR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SFIOR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))

	// JTAG Interface
	OCDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))

	// Bootloader
	SPMCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))

	// I/O Port
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3a)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x39)))
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x38)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x37)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x34)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x33)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x32)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x31)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x30)))
	PORTE = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	DDRE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	PINE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))

	// Timer/Counter, 8-bit
	TCCR0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	TCNT0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x52)))
	OCR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x51)))

	// Watchdog Timer
	WDTCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))

	// External Interrupts
	GICR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5b)))
	GIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5a)))
	PCMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6c)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_M161C        = 0x10 // ATmega161 compability mode
	EXTENDED_M161C_Msk    = 0x10 // ATmega161 compability mode
	EXTENDED_BODLEVEL0    = 0x2  // Brownout detector trigger level
	EXTENDED_BODLEVEL1    = 0x4  // Brownout detector trigger level
	EXTENDED_BODLEVEL2    = 0x8  // Brownout detector trigger level
	EXTENDED_BODLEVEL_Msk = 0xe  // Brownout detector trigger level

	// HIGH
	HIGH_OCDEN       = 0x80 // On-Chip Debug Enabled
	HIGH_OCDEN_Msk   = 0x80 // On-Chip Debug Enabled
	HIGH_JTAGEN      = 0x40 // JTAG Interface Enabled
	HIGH_JTAGEN_Msk  = 0x40 // JTAG Interface Enabled
	HIGH_SPIEN       = 0x20 // Serial program downloading (SPI) enabled
	HIGH_SPIEN_Msk   = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON       = 0x10 // Watchdog timer always on
	HIGH_WDTON_Msk   = 0x10 // Watchdog timer always on
	HIGH_EESAVE      = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_EESAVE_Msk  = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BOOTSZ0     = 0x2  // Select Boot Size
	HIGH_BOOTSZ1     = 0x4  // Select Boot Size
	HIGH_BOOTSZ_Msk  = 0x6  // Select Boot Size
	HIGH_BOOTRST     = 0x1  // Boot Reset vector Enabled
	HIGH_BOOTRST_Msk = 0x1  // Boot Reset vector Enabled

	// LOW
	LOW_CKDIV8        = 0x80 // Divide clock by 8 internally
	LOW_CKDIV8_Msk    = 0x80 // Divide clock by 8 internally
	LOW_CKOUT         = 0x40 // Clock output on PORTB0
	LOW_CKOUT_Msk     = 0x40 // Clock output on PORTB0
	LOW_SUT_CKSEL0    = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1    = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2    = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3    = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4    = 0x10 // Select Clock Source
	LOW_SUT_CKSEL5    = 0x20 // Select Clock Source
	LOW_SUT_CKSEL_Msk = 0x3f // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0      = 0x1  // Memory Lock
	LOCKBIT_LB1      = 0x2  // Memory Lock
	LOCKBIT_LB_Msk   = 0x3  // Memory Lock
	LOCKBIT_BLB00    = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01    = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB0_Msk = 0xc  // Boot Loader Protection Mode
	LOCKBIT_BLB10    = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11    = 0x20 // Boot Loader Protection Mode
	LOCKBIT_BLB1_Msk = 0x30 // Boot Loader Protection Mode
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TIMSK: Timer/Counter Interrupt Mask Register
	TIMSK_TOIE1      = 0x80 // Timer/Counter1 Overflow Interrupt Enable
	TIMSK_TOIE1_Msk  = 0x80 // Timer/Counter1 Overflow Interrupt Enable
	TIMSK_OCIE1A     = 0x40 // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK_OCIE1A_Msk = 0x40 // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK_OCIE1B     = 0x20 // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK_OCIE1B_Msk = 0x20 // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK_TICIE1     = 0x8  // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK_TICIE1_Msk = 0x8  // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK_OCIE2      = 0x10 // Timer/Counter2 Output Compare Match Interrupt Enable
	TIMSK_OCIE2_Msk  = 0x10 // Timer/Counter2 Output Compare Match Interrupt Enable
	TIMSK_TOIE2      = 0x4  // Timer/Counter2 Overflow Interrupt Enable
	TIMSK_TOIE2_Msk  = 0x4  // Timer/Counter2 Overflow Interrupt Enable
	TIMSK_TOIE0      = 0x2  // Timer/Counter0 Overflow Interrupt Enable
	TIMSK_TOIE0_Msk  = 0x2  // Timer/Counter0 Overflow Interrupt Enable
	TIMSK_OCIE0      = 0x1  // Timer/Counter0 Output Compare Match Interrupt register
	TIMSK_OCIE0_Msk  = 0x1  // Timer/Counter0 Output Compare Match Interrupt register

	// TIFR: Timer/Counter Interrupt Flag register
	TIFR_TOV1      = 0x80 // Timer/Counter1 Overflow Flag
	TIFR_TOV1_Msk  = 0x80 // Timer/Counter1 Overflow Flag
	TIFR_OCF1A     = 0x40 // Output Compare Flag 1A
	TIFR_OCF1A_Msk = 0x40 // Output Compare Flag 1A
	TIFR_OCF1B     = 0x20 // Output Compare Flag 1B
	TIFR_OCF1B_Msk = 0x20 // Output Compare Flag 1B
	TIFR_ICF1      = 0x8  // Input Capture Flag 1
	TIFR_ICF1_Msk  = 0x8  // Input Capture Flag 1
	TIFR_OCF2      = 0x10 // Output Compare Flag 2
	TIFR_OCF2_Msk  = 0x10 // Output Compare Flag 2
	TIFR_TOV2      = 0x4  // Timer/Counter2 Overflow Flag
	TIFR_TOV2_Msk  = 0x4  // Timer/Counter2 Overflow Flag
	TIFR_TOV0      = 0x2  // Timer/Counter0 Overflow Flag
	TIFR_TOV0_Msk  = 0x2  // Timer/Counter0 Overflow Flag
	TIFR_OCF0      = 0x1  // Output Compare Flag 0
	TIFR_OCF0_Msk  = 0x1  // Output Compare Flag 0

	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0    = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1    = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1B_Msk = 0x30 // Compare Output Mode 1B, bits
	TCCR1A_FOC1A     = 0x8  // Force Output Compare for Channel A
	TCCR1A_FOC1A_Msk = 0x8  // Force Output Compare for Channel A
	TCCR1A_FOC1B     = 0x4  // Force Output Compare for Channel B
	TCCR1A_FOC1B_Msk = 0x4  // Force Output Compare for Channel B
	TCCR1A_WGM10     = 0x1  // Pulse Width Modulator Select Bits
	TCCR1A_WGM11     = 0x2  // Pulse Width Modulator Select Bits
	TCCR1A_WGM1_Msk  = 0x3  // Pulse Width Modulator Select Bits

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1     = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICNC1_Msk = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1     = 0x40 // Input Capture 1 Edge Select
	TCCR1B_ICES1_Msk = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10     = 0x8  // Pulse Width Modulator Select Bits
	TCCR1B_WGM11     = 0x10 // Pulse Width Modulator Select Bits
	TCCR1B_WGM1_Msk  = 0x18 // Pulse Width Modulator Select Bits
	TCCR1B_CS10      = 0x1  // Clock Select1 bits
	TCCR1B_CS11      = 0x2  // Clock Select1 bits
	TCCR1B_CS12      = 0x4  // Clock Select1 bits
	TCCR1B_CS1_Msk   = 0x7  // Clock Select1 bits

	// ETIMSK: Extended Timer/Counter Interrupt Mask Register
	ETIMSK_TICIE3     = 0x20 // Timer/Counter3 Input Capture Interrupt Enable
	ETIMSK_TICIE3_Msk = 0x20 // Timer/Counter3 Input Capture Interrupt Enable
	ETIMSK_OCIE3A     = 0x10 // Timer/Counter3 Output CompareA Match Interrupt Enable
	ETIMSK_OCIE3A_Msk = 0x10 // Timer/Counter3 Output CompareA Match Interrupt Enable
	ETIMSK_OCIE3B     = 0x8  // Timer/Counter3 Output CompareB Match Interrupt Enable
	ETIMSK_OCIE3B_Msk = 0x8  // Timer/Counter3 Output CompareB Match Interrupt Enable
	ETIMSK_TOIE3      = 0x4  // Timer/Counter3 Overflow Interrupt Enable
	ETIMSK_TOIE3_Msk  = 0x4  // Timer/Counter3 Overflow Interrupt Enable

	// ETIFR: Extended Timer/Counter Interrupt Flag register
	ETIFR_ICF3      = 0x20 // Input Capture Flag 3
	ETIFR_ICF3_Msk  = 0x20 // Input Capture Flag 3
	ETIFR_OCF3A     = 0x10 // Output Compare Flag 3A
	ETIFR_OCF3A_Msk = 0x10 // Output Compare Flag 3A
	ETIFR_OCF3B     = 0x8  // Output Compare Flag 3B
	ETIFR_OCF3B_Msk = 0x8  // Output Compare Flag 3B
	ETIFR_TOV3      = 0x4  // Timer/Counter3 Overflow Flag
	ETIFR_TOV3_Msk  = 0x4  // Timer/Counter3 Overflow Flag

	// TCCR3A: Timer/Counter3 Control Register A
	TCCR3A_COM3A0    = 0x40 // Compare Output Mode 3A, bits
	TCCR3A_COM3A1    = 0x80 // Compare Output Mode 3A, bits
	TCCR3A_COM3A_Msk = 0xc0 // Compare Output Mode 3A, bits
	TCCR3A_COM3B0    = 0x10 // Compare Output Mode 3B, bits
	TCCR3A_COM3B1    = 0x20 // Compare Output Mode 3B, bits
	TCCR3A_COM3B_Msk = 0x30 // Compare Output Mode 3B, bits
	TCCR3A_FOC3A     = 0x8  // Force Output Compare for Channel A
	TCCR3A_FOC3A_Msk = 0x8  // Force Output Compare for Channel A
	TCCR3A_FOC3B     = 0x4  // Force Output Compare for Channel B
	TCCR3A_FOC3B_Msk = 0x4  // Force Output Compare for Channel B
	TCCR3A_WGM30     = 0x1  // Pulse Width Modulator Select Bits
	TCCR3A_WGM31     = 0x2  // Pulse Width Modulator Select Bits
	TCCR3A_WGM3_Msk  = 0x3  // Pulse Width Modulator Select Bits

	// TCCR3B: Timer/Counter3 Control Register B
	TCCR3B_ICNC3     = 0x80 // Input Capture 3 Noise Canceler
	TCCR3B_ICNC3_Msk = 0x80 // Input Capture 3 Noise Canceler
	TCCR3B_ICES3     = 0x40 // Input Capture 3 Edge Select
	TCCR3B_ICES3_Msk = 0x40 // Input Capture 3 Edge Select
	TCCR3B_WGM30     = 0x8  // Pulse Width Modulator Select Bits
	TCCR3B_WGM31     = 0x10 // Pulse Width Modulator Select Bits
	TCCR3B_WGM3_Msk  = 0x18 // Pulse Width Modulator Select Bits
	TCCR3B_CS30      = 0x1  // Clock Select3 bits
	TCCR3B_CS31      = 0x2  // Clock Select3 bits
	TCCR3B_CS32      = 0x4  // Clock Select3 bits
	TCCR3B_CS3_Msk   = 0x7  // Clock Select3 bits
)

// Bitfields for TC8_ASYNC: Timer/Counter, 8-bit Async
const (
	// TCCR2: Timer/Counter Control Register
	TCCR2_FOC2      = 0x80 // Forde Output Compare
	TCCR2_FOC2_Msk  = 0x80 // Forde Output Compare
	TCCR2_WGM20     = 0x40 // Pulse Width Modulator Select Bit 0
	TCCR2_WGM20_Msk = 0x40 // Pulse Width Modulator Select Bit 0
	TCCR2_COM20     = 0x10 // Compare Match Output Mode
	TCCR2_COM21     = 0x20 // Compare Match Output Mode
	TCCR2_COM2_Msk  = 0x30 // Compare Match Output Mode
	TCCR2_WGM21     = 0x8  // Pulse Width Modulator Select Bit 1
	TCCR2_WGM21_Msk = 0x8  // Pulse Width Modulator Select Bit 1
	TCCR2_CS20      = 0x1  // Clock Select
	TCCR2_CS21      = 0x2  // Clock Select
	TCCR2_CS22      = 0x4  // Clock Select
	TCCR2_CS2_Msk   = 0x7  // Clock Select

	// ASSR: Asynchronous Status Register
	ASSR_AS2        = 0x8 // Asynchronous Timer 2
	ASSR_AS2_Msk    = 0x8 // Asynchronous Timer 2
	ASSR_TCN2UB     = 0x4 // Timer/Counter2 Update Busy
	ASSR_TCN2UB_Msk = 0x4 // Timer/Counter2 Update Busy
	ASSR_OCR2UB     = 0x2 // Output Compare Register2 Update Busy
	ASSR_OCR2UB_Msk = 0x2 // Output Compare Register2 Update Busy
	ASSR_TCR2UB     = 0x1 // Timer/Counter Control Register2 Update Busy
	ASSR_TCR2UB_Msk = 0x1 // Timer/Counter Control Register2 Update Busy
)

// Bitfields for AC: Analog Comparator
const (
	// ACSR: Analog Comparator Control And Status Register
	ACSR_ACD      = 0x80 // Analog Comparator Disable
	ACSR_ACD_Msk  = 0x80 // Analog Comparator Disable
	ACSR_ACBG     = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACBG_Msk = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACO      = 0x20 // Analog Compare Output
	ACSR_ACO_Msk  = 0x20 // Analog Compare Output
	ACSR_ACI      = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACI_Msk  = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACIE     = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIE_Msk = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIC     = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIC_Msk = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIS0    = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS1    = 0x2  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS_Msk = 0x3  // Analog Comparator Interrupt Mode Select bits
)

// Bitfields for USART: USART
const (
	// UCSR0A: USART Control and Status Register A
	UCSR0A_RXC0      = 0x80 // USART Receive Complete
	UCSR0A_RXC0_Msk  = 0x80 // USART Receive Complete
	UCSR0A_TXC0      = 0x40 // USART Transmitt Complete
	UCSR0A_TXC0_Msk  = 0x40 // USART Transmitt Complete
	UCSR0A_UDRE0     = 0x20 // USART Data Register Empty
	UCSR0A_UDRE0_Msk = 0x20 // USART Data Register Empty
	UCSR0A_FE0       = 0x10 // Framing Error
	UCSR0A_FE0_Msk   = 0x10 // Framing Error
	UCSR0A_DOR0      = 0x8  // Data overRun
	UCSR0A_DOR0_Msk  = 0x8  // Data overRun
	UCSR0A_UPE0      = 0x4  // Parity Error
	UCSR0A_UPE0_Msk  = 0x4  // Parity Error
	UCSR0A_U2X0      = 0x2  // Double the USART transmission speed
	UCSR0A_U2X0_Msk  = 0x2  // Double the USART transmission speed
	UCSR0A_MPCM0     = 0x1  // Multi-processor Communication Mode
	UCSR0A_MPCM0_Msk = 0x1  // Multi-processor Communication Mode

	// UCSR0B: USART Control and Status Register B
	UCSR0B_RXCIE0     = 0x80 // RX Complete Interrupt Enable
	UCSR0B_RXCIE0_Msk = 0x80 // RX Complete Interrupt Enable
	UCSR0B_TXCIE0     = 0x40 // TX Complete Interrupt Enable
	UCSR0B_TXCIE0_Msk = 0x40 // TX Complete Interrupt Enable
	UCSR0B_UDRIE0     = 0x20 // USART Data register Empty Interrupt Enable
	UCSR0B_UDRIE0_Msk = 0x20 // USART Data register Empty Interrupt Enable
	UCSR0B_RXEN0      = 0x10 // Receiver Enable
	UCSR0B_RXEN0_Msk  = 0x10 // Receiver Enable
	UCSR0B_TXEN0      = 0x8  // Transmitter Enable
	UCSR0B_TXEN0_Msk  = 0x8  // Transmitter Enable
	UCSR0B_UCSZ02     = 0x4  // Character Size
	UCSR0B_UCSZ02_Msk = 0x4  // Character Size
	UCSR0B_RXB80      = 0x2  // Receive Data Bit 8
	UCSR0B_RXB80_Msk  = 0x2  // Receive Data Bit 8
	UCSR0B_TXB80      = 0x1  // Transmit Data Bit 8
	UCSR0B_TXB80_Msk  = 0x1  // Transmit Data Bit 8

	// UCSR0C: USART Control and Status Register C
	UCSR0C_URSEL0     = 0x80 // Register Select
	UCSR0C_URSEL0_Msk = 0x80 // Register Select
	UCSR0C_UMSEL0     = 0x40 // USART Mode Select
	UCSR0C_UMSEL0_Msk = 0x40 // USART Mode Select
	UCSR0C_UPM00      = 0x10 // Parity Mode Bits
	UCSR0C_UPM01      = 0x20 // Parity Mode Bits
	UCSR0C_UPM0_Msk   = 0x30 // Parity Mode Bits
	UCSR0C_USBS0      = 0x8  // Stop Bit Select
	UCSR0C_USBS0_Msk  = 0x8  // Stop Bit Select
	UCSR0C_UCSZ00     = 0x2  // Character Size
	UCSR0C_UCSZ01     = 0x4  // Character Size
	UCSR0C_UCSZ0_Msk  = 0x6  // Character Size
	UCSR0C_UCPOL0     = 0x1  // Clock Polarity
	UCSR0C_UCPOL0_Msk = 0x1  // Clock Polarity

	// UBRR0H: USART Baud Rate Register High Byte
	UBRR0H_URSEL0     = 0x80 // Register Select
	UBRR0H_URSEL0_Msk = 0x80 // Register Select
	UBRR0H_UBRR00     = 0x1  // USART Baud Rate Register High bits
	UBRR0H_UBRR01     = 0x2  // USART Baud Rate Register High bits
	UBRR0H_UBRR02     = 0x4  // USART Baud Rate Register High bits
	UBRR0H_UBRR03     = 0x8  // USART Baud Rate Register High bits
	UBRR0H_UBRR0_Msk  = 0xf  // USART Baud Rate Register High bits

	// UBRR0L: USART Baud Rate Register Low Byte
	UBRR0L_UBRR00    = 0x1  // USART Baud Rate Register Low bits
	UBRR0L_UBRR01    = 0x2  // USART Baud Rate Register Low bits
	UBRR0L_UBRR02    = 0x4  // USART Baud Rate Register Low bits
	UBRR0L_UBRR03    = 0x8  // USART Baud Rate Register Low bits
	UBRR0L_UBRR04    = 0x10 // USART Baud Rate Register Low bits
	UBRR0L_UBRR05    = 0x20 // USART Baud Rate Register Low bits
	UBRR0L_UBRR06    = 0x40 // USART Baud Rate Register Low bits
	UBRR0L_UBRR07    = 0x80 // USART Baud Rate Register Low bits
	UBRR0L_UBRR0_Msk = 0xff // USART Baud Rate Register Low bits

	// UCSR1A: USART Control and Status Register A
	UCSR1A_RXC1      = 0x80 // USART Receive Complete
	UCSR1A_RXC1_Msk  = 0x80 // USART Receive Complete
	UCSR1A_TXC1      = 0x40 // USART Transmitt Complete
	UCSR1A_TXC1_Msk  = 0x40 // USART Transmitt Complete
	UCSR1A_UDRE1     = 0x20 // USART Data Register Empty
	UCSR1A_UDRE1_Msk = 0x20 // USART Data Register Empty
	UCSR1A_FE1       = 0x10 // Framing Error
	UCSR1A_FE1_Msk   = 0x10 // Framing Error
	UCSR1A_DOR1      = 0x8  // Data overRun
	UCSR1A_DOR1_Msk  = 0x8  // Data overRun
	UCSR1A_UPE1      = 0x4  // Parity Error
	UCSR1A_UPE1_Msk  = 0x4  // Parity Error
	UCSR1A_U2X1      = 0x2  // Double the USART transmission speed
	UCSR1A_U2X1_Msk  = 0x2  // Double the USART transmission speed
	UCSR1A_MPCM1     = 0x1  // Multi-processor Communication Mode
	UCSR1A_MPCM1_Msk = 0x1  // Multi-processor Communication Mode

	// UCSR1B: USART Control and Status Register B
	UCSR1B_RXCIE1     = 0x80 // RX Complete Interrupt Enable
	UCSR1B_RXCIE1_Msk = 0x80 // RX Complete Interrupt Enable
	UCSR1B_TXCIE1     = 0x40 // TX Complete Interrupt Enable
	UCSR1B_TXCIE1_Msk = 0x40 // TX Complete Interrupt Enable
	UCSR1B_UDRIE1     = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_UDRIE1_Msk = 0x20 // USART Data register Empty Interrupt Enable
	UCSR1B_RXEN1      = 0x10 // Receiver Enable
	UCSR1B_RXEN1_Msk  = 0x10 // Receiver Enable
	UCSR1B_TXEN1      = 0x8  // Transmitter Enable
	UCSR1B_TXEN1_Msk  = 0x8  // Transmitter Enable
	UCSR1B_UCSZ12     = 0x4  // Character Size
	UCSR1B_UCSZ12_Msk = 0x4  // Character Size
	UCSR1B_RXB81      = 0x2  // Receive Data Bit 8
	UCSR1B_RXB81_Msk  = 0x2  // Receive Data Bit 8
	UCSR1B_TXB81      = 0x1  // Transmit Data Bit 8
	UCSR1B_TXB81_Msk  = 0x1  // Transmit Data Bit 8

	// UCSR1C: USART Control and Status Register C
	UCSR1C_URSEL1     = 0x80 // Register Select
	UCSR1C_URSEL1_Msk = 0x80 // Register Select
	UCSR1C_UMSEL1     = 0x40 // USART Mode Select
	UCSR1C_UMSEL1_Msk = 0x40 // USART Mode Select
	UCSR1C_UPM10      = 0x10 // Parity Mode Bits
	UCSR1C_UPM11      = 0x20 // Parity Mode Bits
	UCSR1C_UPM1_Msk   = 0x30 // Parity Mode Bits
	UCSR1C_USBS1      = 0x8  // Stop Bit Select
	UCSR1C_USBS1_Msk  = 0x8  // Stop Bit Select
	UCSR1C_UCSZ10     = 0x2  // Character Size
	UCSR1C_UCSZ11     = 0x4  // Character Size
	UCSR1C_UCSZ1_Msk  = 0x6  // Character Size
	UCSR1C_UCPOL1     = 0x1  // Clock Polarity
	UCSR1C_UCPOL1_Msk = 0x1  // Clock Polarity

	// UBRR1H: USART Baud Rate Register Highg Byte
	UBRR1H_URSEL0     = 0x80 // Register Select
	UBRR1H_URSEL0_Msk = 0x80 // Register Select
	UBRR1H_UBRR10     = 0x1  // USART Baud Rate Register High bits
	UBRR1H_UBRR11     = 0x2  // USART Baud Rate Register High bits
	UBRR1H_UBRR12     = 0x4  // USART Baud Rate Register High bits
	UBRR1H_UBRR13     = 0x8  // USART Baud Rate Register High bits
	UBRR1H_UBRR1_Msk  = 0xf  // USART Baud Rate Register High bits

	// UBRR1L: USART Baud Rate Register Low Byte
	UBRR1L_UBRR10    = 0x1  // USART Baud Rate Register Low bits
	UBRR1L_UBRR11    = 0x2  // USART Baud Rate Register Low bits
	UBRR1L_UBRR12    = 0x4  // USART Baud Rate Register Low bits
	UBRR1L_UBRR13    = 0x8  // USART Baud Rate Register Low bits
	UBRR1L_UBRR14    = 0x10 // USART Baud Rate Register Low bits
	UBRR1L_UBRR15    = 0x20 // USART Baud Rate Register Low bits
	UBRR1L_UBRR16    = 0x40 // USART Baud Rate Register Low bits
	UBRR1L_UBRR17    = 0x80 // USART Baud Rate Register Low bits
	UBRR1L_UBRR1_Msk = 0xff // USART Baud Rate Register Low bits
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPCR: SPI Control Register
	SPCR_SPIE     = 0x80 // SPI Interrupt Enable
	SPCR_SPIE_Msk = 0x80 // SPI Interrupt Enable
	SPCR_SPE      = 0x40 // SPI Enable
	SPCR_SPE_Msk  = 0x40 // SPI Enable
	SPCR_DORD     = 0x20 // Data Order
	SPCR_DORD_Msk = 0x20 // Data Order
	SPCR_MSTR     = 0x10 // Master/Slave Select
	SPCR_MSTR_Msk = 0x10 // Master/Slave Select
	SPCR_CPOL     = 0x8  // Clock polarity
	SPCR_CPOL_Msk = 0x8  // Clock polarity
	SPCR_CPHA     = 0x4  // Clock Phase
	SPCR_CPHA_Msk = 0x4  // Clock Phase
	SPCR_SPR0     = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1     = 0x2  // SPI Clock Rate Selects
	SPCR_SPR_Msk  = 0x3  // SPI Clock Rate Selects

	// SPSR: SPI Status Register
	SPSR_SPIF      = 0x80 // SPI Interrupt Flag
	SPSR_SPIF_Msk  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL      = 0x40 // Write Collision Flag
	SPSR_WCOL_Msk  = 0x40 // Write Collision Flag
	SPSR_SPI2X     = 0x1  // Double SPI Speed Bit
	SPSR_SPI2X_Msk = 0x1  // Double SPI Speed Bit
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// MCUCR: MCU Control Register
	MCUCR_SRE       = 0x80 // External SRAM Enable
	MCUCR_SRE_Msk   = 0x80 // External SRAM Enable
	MCUCR_SRW10     = 0x40 // External SRAM Wait State Select
	MCUCR_SRW10_Msk = 0x40 // External SRAM Wait State Select
	MCUCR_SE        = 0x20 // Sleep Enable
	MCUCR_SE_Msk    = 0x20 // Sleep Enable
	MCUCR_SM1       = 0x10 // Sleep Mode Select
	MCUCR_SM1_Msk   = 0x10 // Sleep Mode Select
	MCUCR_ISC10     = 0x4  // Interrupt Sense Control 1 bits
	MCUCR_ISC11     = 0x8  // Interrupt Sense Control 1 bits
	MCUCR_ISC1_Msk  = 0xc  // Interrupt Sense Control 1 bits
	MCUCR_ISC00     = 0x1  // Interrupt Sense Control 0 bits
	MCUCR_ISC01     = 0x2  // Interrupt Sense Control 0 bits
	MCUCR_ISC0_Msk  = 0x3  // Interrupt Sense Control 0 bits

	// MCUCSR: MCU Control And Status Register
	MCUCSR_JTD       = 0x80 // JTAG Interface Disable
	MCUCSR_JTD_Msk   = 0x80 // JTAG Interface Disable
	MCUCSR_SM2       = 0x20 // Sleep Mode Select Bit 2
	MCUCSR_SM2_Msk   = 0x20 // Sleep Mode Select Bit 2
	MCUCSR_JTRF      = 0x10 // JTAG Reset Flag
	MCUCSR_JTRF_Msk  = 0x10 // JTAG Reset Flag
	MCUCSR_WDRF      = 0x8  // Watchdog Reset Flag
	MCUCSR_WDRF_Msk  = 0x8  // Watchdog Reset Flag
	MCUCSR_BORF      = 0x4  // Brown-out Reset Flag
	MCUCSR_BORF_Msk  = 0x4  // Brown-out Reset Flag
	MCUCSR_EXTRF     = 0x2  // External Reset Flag
	MCUCSR_EXTRF_Msk = 0x2  // External Reset Flag
	MCUCSR_PORF      = 0x1  // Power-on reset flag
	MCUCSR_PORF_Msk  = 0x1  // Power-on reset flag

	// EMCUCR: Extended MCU Control Register
	EMCUCR_SM0       = 0x80 // Sleep mode Select Bit 0
	EMCUCR_SM0_Msk   = 0x80 // Sleep mode Select Bit 0
	EMCUCR_SRL0      = 0x10 // Wait State Sector Limit Bits
	EMCUCR_SRL1      = 0x20 // Wait State Sector Limit Bits
	EMCUCR_SRL2      = 0x40 // Wait State Sector Limit Bits
	EMCUCR_SRL_Msk   = 0x70 // Wait State Sector Limit Bits
	EMCUCR_SRW00     = 0x4  // Wait State Select Bit 1 for Lower Sector
	EMCUCR_SRW01     = 0x8  // Wait State Select Bit 1 for Lower Sector
	EMCUCR_SRW0_Msk  = 0xc  // Wait State Select Bit 1 for Lower Sector
	EMCUCR_SRW11     = 0x2  // Wait State Select Bit 1 for Upper Sector
	EMCUCR_SRW11_Msk = 0x2  // Wait State Select Bit 1 for Upper Sector
	EMCUCR_ISC2      = 0x1  // Interrupt Sense Control 2
	EMCUCR_ISC2_Msk  = 0x1  // Interrupt Sense Control 2

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_OSCCAL0    = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1    = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2    = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3    = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4    = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5    = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6    = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7    = 0x80 // Oscillator Calibration
	OSCCAL_OSCCAL_Msk = 0xff // Oscillator Calibration

	// CLKPR: Clock prescale register
	CLKPR_CLKPCE     = 0x80 // Clock Prescaler Change Enable
	CLKPR_CLKPCE_Msk = 0x80 // Clock Prescaler Change Enable
	CLKPR_CLKPS0     = 0x1  // Clock Prescaler Select Bits
	CLKPR_CLKPS1     = 0x2  // Clock Prescaler Select Bits
	CLKPR_CLKPS2     = 0x4  // Clock Prescaler Select Bits
	CLKPR_CLKPS3     = 0x8  // Clock Prescaler Select Bits
	CLKPR_CLKPS_Msk  = 0xf  // Clock Prescaler Select Bits

	// SFIOR: Special Function IO Register
	SFIOR_TSM        = 0x80 // Timer/Counter Synchronization Mode
	SFIOR_TSM_Msk    = 0x80 // Timer/Counter Synchronization Mode
	SFIOR_XMBK       = 0x40 // External Memory Bus Keeper Enable
	SFIOR_XMBK_Msk   = 0x40 // External Memory Bus Keeper Enable
	SFIOR_XMM0       = 0x8  // External Memory High Mask Bits
	SFIOR_XMM1       = 0x10 // External Memory High Mask Bits
	SFIOR_XMM2       = 0x20 // External Memory High Mask Bits
	SFIOR_XMM_Msk    = 0x38 // External Memory High Mask Bits
	SFIOR_PUD        = 0x4  // Pull-up Disable
	SFIOR_PUD_Msk    = 0x4  // Pull-up Disable
	SFIOR_PSR2       = 0x2  // Prescaler Reset Timer/Counter2
	SFIOR_PSR2_Msk   = 0x2  // Prescaler Reset Timer/Counter2
	SFIOR_PSR310     = 0x1  // Prescaler Reset Timer/Counter3, Timer/Counter1 and Timer/Counter0
	SFIOR_PSR310_Msk = 0x1  // Prescaler Reset Timer/Counter3, Timer/Counter1 and Timer/Counter0
)

// Bitfields for JTAG: JTAG Interface
const (
	// OCDR: On-Chip Debug Related Register in I/O Memory
	OCDR_OCDR0    = 0x1  // On-Chip Debug Register Bits
	OCDR_OCDR1    = 0x2  // On-Chip Debug Register Bits
	OCDR_OCDR2    = 0x4  // On-Chip Debug Register Bits
	OCDR_OCDR3    = 0x8  // On-Chip Debug Register Bits
	OCDR_OCDR4    = 0x10 // On-Chip Debug Register Bits
	OCDR_OCDR5    = 0x20 // On-Chip Debug Register Bits
	OCDR_OCDR6    = 0x40 // On-Chip Debug Register Bits
	OCDR_OCDR7    = 0x80 // On-Chip Debug Register Bits
	OCDR_OCDR_Msk = 0xff // On-Chip Debug Register Bits
)

// Bitfields for BOOT_LOAD: Bootloader
const (
	// SPMCR: Store Program Memory Control Register
	SPMCR_SPMIE      = 0x80 // SPM Interrupt Enable
	SPMCR_SPMIE_Msk  = 0x80 // SPM Interrupt Enable
	SPMCR_RWWSB      = 0x40 // Read While Write Section Busy
	SPMCR_RWWSB_Msk  = 0x40 // Read While Write Section Busy
	SPMCR_RWWSRE     = 0x10 // Read While Write secion read enable
	SPMCR_RWWSRE_Msk = 0x10 // Read While Write secion read enable
	SPMCR_BLBSET     = 0x8  // Boot Lock Bit Set
	SPMCR_BLBSET_Msk = 0x8  // Boot Lock Bit Set
	SPMCR_PGWRT      = 0x4  // Page Write
	SPMCR_PGWRT_Msk  = 0x4  // Page Write
	SPMCR_PGERS      = 0x2  // Page Erase
	SPMCR_PGERS_Msk  = 0x2  // Page Erase
	SPMCR_SPMEN      = 0x1  // Store Program Memory Enable
	SPMCR_SPMEN_Msk  = 0x1  // Store Program Memory Enable
)

// Bitfields for EEPROM: EEPROM
const (
	// EEARL: EEPROM Address Register Bytes

	// EEARH: EEPROM Address Register Bytes
	EEAR_EEAR0    = 0x1   // EEPROM Address Register bits
	EEAR_EEAR1    = 0x2   // EEPROM Address Register bits
	EEAR_EEAR2    = 0x4   // EEPROM Address Register bits
	EEAR_EEAR3    = 0x8   // EEPROM Address Register bits
	EEAR_EEAR4    = 0x10  // EEPROM Address Register bits
	EEAR_EEAR5    = 0x20  // EEPROM Address Register bits
	EEAR_EEAR6    = 0x40  // EEPROM Address Register bits
	EEAR_EEAR7    = 0x80  // EEPROM Address Register bits
	EEAR_EEAR_Msk = 0x1ff // EEPROM Address Register bits

	// EEDR: EEPROM Data Register
	EEDR_EEDR0    = 0x1  // EEPROM Data Register bits
	EEDR_EEDR1    = 0x2  // EEPROM Data Register bits
	EEDR_EEDR2    = 0x4  // EEPROM Data Register bits
	EEDR_EEDR3    = 0x8  // EEPROM Data Register bits
	EEDR_EEDR4    = 0x10 // EEPROM Data Register bits
	EEDR_EEDR5    = 0x20 // EEPROM Data Register bits
	EEDR_EEDR6    = 0x40 // EEPROM Data Register bits
	EEDR_EEDR7    = 0x80 // EEPROM Data Register bits
	EEDR_EEDR_Msk = 0xff // EEPROM Data Register bits

	// EECR: EEPROM Control Register
	EECR_EERIE     = 0x8 // EEPROM Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8 // EEPROM Ready Interrupt Enable
	EECR_EEMWE     = 0x4 // EEPROM Master Write Enable
	EECR_EEMWE_Msk = 0x4 // EEPROM Master Write Enable
	EECR_EEWE      = 0x2 // EEPROM Write Enable
	EECR_EEWE_Msk  = 0x2 // EEPROM Write Enable
	EECR_EERE      = 0x1 // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1 // EEPROM Read Enable
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TCCR0: Timer/Counter 0 Control Register
	TCCR0_FOC0      = 0x80 // Force Output Compare
	TCCR0_FOC0_Msk  = 0x80 // Force Output Compare
	TCCR0_WGM00     = 0x40 // Waveform Generation Mode 0
	TCCR0_WGM00_Msk = 0x40 // Waveform Generation Mode 0
	TCCR0_COM00     = 0x10 // Compare Match Output Modes
	TCCR0_COM01     = 0x20 // Compare Match Output Modes
	TCCR0_COM0_Msk  = 0x30 // Compare Match Output Modes
	TCCR0_WGM01     = 0x8  // Waveform Generation Mode 1
	TCCR0_WGM01_Msk = 0x8  // Waveform Generation Mode 1
	TCCR0_CS00      = 0x1  // Clock Selects
	TCCR0_CS01      = 0x2  // Clock Selects
	TCCR0_CS02      = 0x4  // Clock Selects
	TCCR0_CS0_Msk   = 0x7  // Clock Selects
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCR: Watchdog Timer Control Register
	WDTCR_WDCE     = 0x10 // Watchdog Change Enable
	WDTCR_WDCE_Msk = 0x10 // Watchdog Change Enable
	WDTCR_WDE      = 0x8  // Watch Dog Enable
	WDTCR_WDE_Msk  = 0x8  // Watch Dog Enable
	WDTCR_WDP0     = 0x1  // Watch Dog Timer Prescaler bits
	WDTCR_WDP1     = 0x2  // Watch Dog Timer Prescaler bits
	WDTCR_WDP2     = 0x4  // Watch Dog Timer Prescaler bits
	WDTCR_WDP_Msk  = 0x7  // Watch Dog Timer Prescaler bits
)

// Bitfields for EXINT: External Interrupts
const (
	// GICR: General Interrupt Control Register
	GICR_INT0      = 0x40 // External Interrupt Request 0 Enable
	GICR_INT0_Msk  = 0x40 // External Interrupt Request 0 Enable
	GICR_INT1      = 0x80 // External Interrupt Request 1 Enable
	GICR_INT1_Msk  = 0x80 // External Interrupt Request 1 Enable
	GICR_INT2      = 0x20 // External Interrupt Request 2 Enable
	GICR_INT2_Msk  = 0x20 // External Interrupt Request 2 Enable
	GICR_PCIE0     = 0x8  // Pin Change Interrupt Enables
	GICR_PCIE1     = 0x10 // Pin Change Interrupt Enables
	GICR_PCIE_Msk  = 0x18 // Pin Change Interrupt Enables
	GICR_IVSEL     = 0x2  // Interrupt Vector Select
	GICR_IVSEL_Msk = 0x2  // Interrupt Vector Select
	GICR_IVCE      = 0x1  // Interrupt Vector Change Enable
	GICR_IVCE_Msk  = 0x1  // Interrupt Vector Change Enable

	// GIFR: General Interrupt Flag Register
	GIFR_INTF0     = 0x40 // External Interrupt Flags
	GIFR_INTF1     = 0x80 // External Interrupt Flags
	GIFR_INTF_Msk  = 0xc0 // External Interrupt Flags
	GIFR_INTF2     = 0x20 // External Interrupt Flag 2
	GIFR_INTF2_Msk = 0x20 // External Interrupt Flag 2
	GIFR_PCIF0     = 0x8  // Pin Change Interrupt Flags
	GIFR_PCIF1     = 0x10 // Pin Change Interrupt Flags
	GIFR_PCIF_Msk  = 0x18 // Pin Change Interrupt Flags

	// PCMSK1: Pin Change Mask Register 1
	PCMSK1_PCINT0    = 0x1  // Pin Change Interrupt mask bits
	PCMSK1_PCINT1    = 0x2  // Pin Change Interrupt mask bits
	PCMSK1_PCINT2    = 0x4  // Pin Change Interrupt mask bits
	PCMSK1_PCINT3    = 0x8  // Pin Change Interrupt mask bits
	PCMSK1_PCINT4    = 0x10 // Pin Change Interrupt mask bits
	PCMSK1_PCINT5    = 0x20 // Pin Change Interrupt mask bits
	PCMSK1_PCINT6    = 0x40 // Pin Change Interrupt mask bits
	PCMSK1_PCINT7    = 0x80 // Pin Change Interrupt mask bits
	PCMSK1_PCINT_Msk = 0xff // Pin Change Interrupt mask bits

	// PCMSK0: Pin Change Enable Mask
	PCMSK0_PCINT0    = 0x1  // Pin Change Interrupt mask bits
	PCMSK0_PCINT1    = 0x2  // Pin Change Interrupt mask bits
	PCMSK0_PCINT2    = 0x4  // Pin Change Interrupt mask bits
	PCMSK0_PCINT3    = 0x8  // Pin Change Interrupt mask bits
	PCMSK0_PCINT4    = 0x10 // Pin Change Interrupt mask bits
	PCMSK0_PCINT5    = 0x20 // Pin Change Interrupt mask bits
	PCMSK0_PCINT6    = 0x40 // Pin Change Interrupt mask bits
	PCMSK0_PCINT7    = 0x80 // Pin Change Interrupt mask bits
	PCMSK0_PCINT_Msk = 0xff // Pin Change Interrupt mask bits
)
