import * as lsp from 'vscode-languageserver';
import { LspServer } from './lsp-server.js';
export declare const PACKAGE_ROOT: string;
export declare function uri(...components: string[]): string;
export declare function filePath(...components: string[]): string;
export declare function readContents(path: string): string;
export declare function positionAt(document: lsp.TextDocumentItem, idx: number): lsp.Position;
export declare function position(document: lsp.TextDocumentItem, match: string): lsp.Position;
export declare function positionAfter(document: lsp.TextDocumentItem, match: string): lsp.Position;
export declare function lastPosition(document: lsp.TextDocumentItem, match: string): lsp.Position;
export declare function toPlatformEOL(text: string): string;
export declare class TestLspServer extends LspServer {
    workspaceEdits: lsp.ApplyWorkspaceEditParams[];
}
interface TestLspServerOptions {
    rootUri: string | null;
    tsserverLogVerbosity?: string;
    publishDiagnostics: (args: lsp.PublishDiagnosticsParams) => void;
    clientCapabilitiesOverride?: lsp.ClientCapabilities;
}
export declare function createServer(options: TestLspServerOptions): Promise<TestLspServer>;
export {};
//# sourceMappingURL=test-utils.d.ts.map