/* large-pathbar.c generated by valac 0.56.2, the Vala compiler
 * generated from large-pathbar.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#define MODEL_UTILS_undefined_context_id ((guint16) 0)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PATHBAR (pathbar_get_type ())
#define PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATHBAR, Pathbar))
#define IS_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATHBAR))
#define PATHBAR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PATHBAR, PathbarIface))

typedef struct _Pathbar Pathbar;
typedef struct _PathbarIface PathbarIface;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_LARGE_PATHBAR (large_pathbar_get_type ())
#define LARGE_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LARGE_PATHBAR, LargePathbar))
#define LARGE_PATHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LARGE_PATHBAR, LargePathbarClass))
#define IS_LARGE_PATHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LARGE_PATHBAR))
#define IS_LARGE_PATHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LARGE_PATHBAR))
#define LARGE_PATHBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LARGE_PATHBAR, LargePathbarClass))

typedef struct _LargePathbar LargePathbar;
typedef struct _LargePathbarClass LargePathbarClass;
typedef struct _LargePathbarPrivate LargePathbarPrivate;

#define TYPE_LARGE_PATHBAR_ITEM (large_pathbar_item_get_type ())
#define LARGE_PATHBAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LARGE_PATHBAR_ITEM, LargePathbarItem))
#define LARGE_PATHBAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LARGE_PATHBAR_ITEM, LargePathbarItemClass))
#define IS_LARGE_PATHBAR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LARGE_PATHBAR_ITEM))
#define IS_LARGE_PATHBAR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LARGE_PATHBAR_ITEM))
#define LARGE_PATHBAR_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LARGE_PATHBAR_ITEM, LargePathbarItemClass))

typedef struct _LargePathbarItem LargePathbarItem;
typedef struct _LargePathbarItemClass LargePathbarItemClass;
enum  {
	LARGE_PATHBAR_0_PROPERTY,
	LARGE_PATHBAR_NUM_PROPERTIES
};
static GParamSpec* large_pathbar_properties[LARGE_PATHBAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;
typedef enum  {
	LARGE_PATHBAR_ITEM_CURSOR_TYPE_DEFAULT,
	LARGE_PATHBAR_ITEM_CURSOR_TYPE_POINTER,
	LARGE_PATHBAR_ITEM_CURSOR_TYPE_CONTEXT
} LargePathbarItemCursorType;

#define LARGE_PATHBAR_ITEM_TYPE_CURSOR_TYPE (large_pathbar_item_cursor_type_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _LargePathbarItemPrivate LargePathbarItemPrivate;
enum  {
	LARGE_PATHBAR_ITEM_0_PROPERTY,
	LARGE_PATHBAR_ITEM_IS_ACTIVE_PROPERTY,
	LARGE_PATHBAR_ITEM_ALTERNATIVE_ACTION_PROPERTY,
	LARGE_PATHBAR_ITEM_DEFAULT_ACTION_PROPERTY,
	LARGE_PATHBAR_ITEM_TEXT_STRING_PROPERTY,
	LARGE_PATHBAR_ITEM_HAS_CONFIG_MENU_PROPERTY,
	LARGE_PATHBAR_ITEM_NUM_PROPERTIES
};
static GParamSpec* large_pathbar_item_properties[LARGE_PATHBAR_ITEM_NUM_PROPERTIES];

struct _PathbarIface {
	GTypeInterface parent_iface;
	gboolean (*has_popover) (Pathbar* self);
	void (*close_menu) (Pathbar* self);
	void (*toggle_menu) (Pathbar* self);
	void (*set_path) (Pathbar* self, ViewType type, const gchar* path);
	void (*update_ghosts) (Pathbar* self, const gchar* non_ghost_path, gboolean is_search);
	void (*get_complete_path) (Pathbar* self, gchar** _complete_path);
	void (*get_fallback_path_and_complete_path) (Pathbar* self, gchar** _fallback_path, gchar** _complete_path);
	gchar* (*get_selected_child) (Pathbar* self, const gchar* current_path);
};

struct _LargePathbar {
	GtkBox parent_instance;
	LargePathbarPrivate * priv;
};

struct _LargePathbarClass {
	GtkBoxClass parent_class;
};

struct _LargePathbarPrivate {
	LargePathbarItem* root_button;
	LargePathbarItem* active_button;
	gchar* complete_path;
	gchar* fallback_path;
};

struct _Block16Data {
	int _ref_count_;
	LargePathbar* self;
	gchar** split;
	gint split_length1;
	gint _split_size_;
	gboolean destroy_all;
	gboolean maintain_all;
	ViewType type;
};

struct _Block17Data {
	int _ref_count_;
	LargePathbar* self;
	gchar* action_target;
	gchar* non_ghost_path;
	gboolean is_search;
};

struct _LargePathbarItem {
	GtkButton parent_instance;
	LargePathbarItemPrivate * priv;
};

struct _LargePathbarItemClass {
	GtkButtonClass parent_class;
};

struct _LargePathbarItemPrivate {
	gboolean _is_active;
	gchar* _alternative_action;
	gchar* _default_action;
	gchar* _text_string;
	gboolean _has_config_menu;
	GtkLabel* text_label;
	GtkPopover* popover;
	LargePathbarItemCursorType cursor_type;
	gboolean hover;
};

static gint LargePathbar_private_offset;
static gpointer large_pathbar_parent_class = NULL;
static PathbarIface * large_pathbar_pathbar_parent_iface = NULL;
static gint LargePathbarItem_private_offset;
static gpointer large_pathbar_item_parent_class = NULL;

VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pathbar_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType large_pathbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LargePathbar, g_object_unref)
VALA_EXTERN GType large_pathbar_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LargePathbarItem, g_object_unref)
static void large_pathbar_real_get_complete_path (Pathbar* base,
                                           gchar** _complete_path);
static void large_pathbar_real_get_fallback_path_and_complete_path (Pathbar* base,
                                                             gchar** _fallback_path,
                                                             gchar** _complete_path);
VALA_EXTERN gboolean model_utils_is_folder_path (const gchar* path);
VALA_EXTERN LargePathbar* large_pathbar_new (const gchar* complete_path_or_empty,
                                 ViewType type,
                                 const gchar* path);
VALA_EXTERN LargePathbar* large_pathbar_construct (GType object_type,
                                       const gchar* complete_path_or_empty,
                                       ViewType type,
                                       const gchar* path);
static void _large_pathbar_set_path (LargePathbar* self,
                              ViewType type,
                              const gchar* path);
VALA_EXTERN void pathbar_set_path (Pathbar* self,
                       ViewType type,
                       const gchar* path);
static gboolean large_pathbar_real_has_popover (Pathbar* base);
VALA_EXTERN gboolean large_pathbar_item_has_popover (LargePathbarItem* self);
static void large_pathbar_real_close_menu (Pathbar* base);
VALA_EXTERN void large_pathbar_item_close_menu (LargePathbarItem* self);
static void large_pathbar_real_toggle_menu (Pathbar* base);
VALA_EXTERN void large_pathbar_item_toggle_menu (LargePathbarItem* self);
static void large_pathbar_real_set_path (Pathbar* base,
                                  ViewType type,
                                  const gchar* path);
static inline void large_pathbar_update_active_button_cursor (ViewType type,
                                                LargePathbarItem** active_button);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static inline void large_pathbar_update_config_style_class (gboolean type_is_config,
                                              GtkStyleContext* context);
static void large_pathbar_activate_item (LargePathbar* self,
                                  LargePathbarItem* item,
                                  gboolean state);
static void __lambda15_ (Block16Data* _data16_,
                  GtkWidget* child);
VALA_EXTERN const gchar* large_pathbar_item_get_text_string (LargePathbarItem* self);
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
static void ___lambda15__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void large_pathbar_add_path_bar_item (LargePathbar* self,
                                      const gchar* label,
                                      const gchar* complete_path,
                                      gboolean is_folder,
                                      gboolean block);
static void large_pathbar_add_slash_label (LargePathbar* self);
static void __lambda16_ (LargePathbar* self,
                  GtkWidget* child);
static void ___lambda16__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void large_pathbar_real_update_ghosts (Pathbar* base,
                                       const gchar* non_ghost_path,
                                       gboolean is_search);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda17_ (Block17Data* _data17_,
                  GtkWidget* child);
VALA_EXTERN gboolean large_pathbar_item_get_is_active (LargePathbarItem* self);
VALA_EXTERN GType large_pathbar_item_cursor_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void large_pathbar_item_set_cursor_type (LargePathbarItem* self,
                                         LargePathbarItemCursorType cursor_type);
VALA_EXTERN const gchar* large_pathbar_item_get_default_action (LargePathbarItem* self);
VALA_EXTERN const gchar* large_pathbar_item_get_alternative_action (LargePathbarItem* self);
static void ___lambda17__gtk_callback (GtkWidget* widget,
                                gpointer self);
static inline LargePathbarItem* large_pathbar_create_path_bar_item (const gchar* label,
                                                      const gchar* complete_path,
                                                      gboolean is_folder);
static inline void large_pathbar_init_folder_path_bar_item (const gchar* label,
                                              const gchar* complete_path,
                                              LargePathbarItem** path_bar_item);
static inline void large_pathbar_init_object_path_bar_item (const gchar* label,
                                              const gchar* complete_path,
                                              LargePathbarItem** path_bar_item);
VALA_EXTERN LargePathbarItem* large_pathbar_item_new (const gchar* label,
                                          const gchar* _default_action,
                                          const gchar* _alternative_action,
                                          gboolean _has_config_menu);
VALA_EXTERN LargePathbarItem* large_pathbar_item_construct (GType object_type,
                                                const gchar* label,
                                                const gchar* _default_action,
                                                const gchar* _alternative_action,
                                                gboolean _has_config_menu);
static inline void _large_pathbar_activate_item (LargePathbarItem* item,
                                   gboolean state);
VALA_EXTERN void large_pathbar_item_set_is_active (LargePathbarItem* self,
                                       gboolean value);
static GObject * large_pathbar_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
VALA_EXTERN void pathbar_get_complete_path (Pathbar* self,
                                gchar** _complete_path);
VALA_EXTERN void pathbar_get_fallback_path_and_complete_path (Pathbar* self,
                                                  gchar** _fallback_path,
                                                  gchar** _complete_path);
VALA_EXTERN gboolean pathbar_has_popover (Pathbar* self);
VALA_EXTERN void pathbar_close_menu (Pathbar* self);
VALA_EXTERN void pathbar_toggle_menu (Pathbar* self);
VALA_EXTERN void pathbar_update_ghosts (Pathbar* self,
                            const gchar* non_ghost_path,
                            gboolean is_search);
static void large_pathbar_finalize (GObject * obj);
static GType large_pathbar_get_type_once (void);
static void large_pathbar_item_set_new_cursor_type (LargePathbarItem* self,
                                             LargePathbarItemCursorType new_cursor_type);
static void large_pathbar_item_update_cursor (LargePathbarItem* self);
static void large_pathbar_item_generate_popover (LargePathbarItem* self);
static void _large_pathbar_item_update_cursor_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
VALA_EXTERN void pathbar_populate_pathbar_menu (gboolean is_folder,
                                    GMenu** menu);
static gboolean large_pathbar_item_get_has_config_menu (LargePathbarItem* self);
static void large_pathbar_item_set_alternative_action (LargePathbarItem* self,
                                                const gchar* value);
static void large_pathbar_item_set_default_action (LargePathbarItem* self,
                                            const gchar* value);
static void large_pathbar_item_set_text_string (LargePathbarItem* self,
                                         const gchar* value);
static void large_pathbar_item_set_has_config_menu (LargePathbarItem* self,
                                             gboolean value);
static GObject * large_pathbar_item_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static gboolean _large_pathbar_item___lambda13_ (LargePathbarItem* self);
static gboolean __large_pathbar_item___lambda13__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                         GdkEventCrossing* event,
                                                                         gpointer self);
static gboolean _large_pathbar_item___lambda14_ (LargePathbarItem* self);
static gboolean __large_pathbar_item___lambda14__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                         GdkEventCrossing* event,
                                                                         gpointer self);
static void large_pathbar_item_finalize (GObject * obj);
static GType large_pathbar_item_get_type_once (void);
static void _vala_large_pathbar_item_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_large_pathbar_item_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
large_pathbar_get_instance_private (LargePathbar* self)
{
	return G_STRUCT_MEMBER_P (self, LargePathbar_private_offset);
}

static void
large_pathbar_real_get_complete_path (Pathbar* base,
                                      gchar** _complete_path)
{
	LargePathbar * self;
	gchar* _vala__complete_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (LargePathbar*) base;
	_tmp0_ = self->priv->complete_path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_vala__complete_path);
	_vala__complete_path = _tmp1_;
	if (_complete_path) {
		*_complete_path = _vala__complete_path;
	} else {
		_g_free0 (_vala__complete_path);
	}
}

static void
large_pathbar_real_get_fallback_path_and_complete_path (Pathbar* base,
                                                        gchar** _fallback_path,
                                                        gchar** _complete_path)
{
	LargePathbar * self;
	gchar* _vala__fallback_path = NULL;
	gchar* _vala__complete_path = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	self = (LargePathbar*) base;
	_tmp2_ = self->priv->fallback_path;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->fallback_path;
		_tmp1_ = model_utils_is_folder_path (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->complete_path;
		_tmp5_ = self->priv->fallback_path;
		_tmp0_ = g_str_has_prefix (_tmp4_, _tmp5_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = self->priv->fallback_path;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (_vala__fallback_path);
		_vala__fallback_path = _tmp7_;
	} else {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->complete_path;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (_vala__fallback_path);
		_vala__fallback_path = _tmp9_;
	}
	_tmp10_ = self->priv->complete_path;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (_vala__complete_path);
	_vala__complete_path = _tmp11_;
	if (_fallback_path) {
		*_fallback_path = _vala__fallback_path;
	} else {
		_g_free0 (_vala__fallback_path);
	}
	if (_complete_path) {
		*_complete_path = _vala__complete_path;
	} else {
		_g_free0 (_vala__complete_path);
	}
}

LargePathbar*
large_pathbar_construct (GType object_type,
                         const gchar* complete_path_or_empty,
                         ViewType type,
                         const gchar* path)
{
	LargePathbar * self = NULL;
	g_return_val_if_fail (complete_path_or_empty != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	self = (LargePathbar*) g_object_new (object_type, NULL);
	if (g_strcmp0 (complete_path_or_empty, "") != 0) {
		gchar* _tmp0_;
		ViewType _tmp1_ = 0;
		_tmp0_ = g_strdup (complete_path_or_empty);
		_g_free0 (self->priv->complete_path);
		self->priv->complete_path = _tmp0_;
		if (model_utils_is_folder_path (complete_path_or_empty)) {
			_tmp1_ = VIEW_TYPE_FOLDER;
		} else {
			_tmp1_ = VIEW_TYPE_OBJECT;
		}
		_large_pathbar_set_path (self, _tmp1_, complete_path_or_empty);
	}
	pathbar_set_path ((Pathbar*) self, type, path);
	return self;
}

LargePathbar*
large_pathbar_new (const gchar* complete_path_or_empty,
                   ViewType type,
                   const gchar* path)
{
	return large_pathbar_construct (TYPE_LARGE_PATHBAR, complete_path_or_empty, type, path);
}

static gboolean
large_pathbar_real_has_popover (Pathbar* base)
{
	LargePathbar * self;
	LargePathbarItem* _tmp0_;
	gboolean result;
	self = (LargePathbar*) base;
	_tmp0_ = self->priv->active_button;
	result = large_pathbar_item_has_popover (_tmp0_);
	return result;
}

static void
large_pathbar_real_close_menu (Pathbar* base)
{
	LargePathbar * self;
	LargePathbarItem* _tmp0_;
	self = (LargePathbar*) base;
	_tmp0_ = self->priv->active_button;
	large_pathbar_item_close_menu (_tmp0_);
}

static void
large_pathbar_real_toggle_menu (Pathbar* base)
{
	LargePathbar * self;
	LargePathbarItem* _tmp0_;
	self = (LargePathbar*) base;
	_tmp0_ = self->priv->active_button;
	large_pathbar_item_toggle_menu (_tmp0_);
}

static void
large_pathbar_real_set_path (Pathbar* base,
                             ViewType type,
                             const gchar* path)
{
	LargePathbar * self;
	self = (LargePathbar*) base;
	g_return_if_fail (path != NULL);
	if (type == VIEW_TYPE_SEARCH) {
		return;
	}
	_large_pathbar_set_path (self, type, path);
	large_pathbar_update_active_button_cursor (type, &self->priv->active_button);
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		LargePathbar* self;
		self = _data16_->self;
		_data16_->split = (_vala_array_free (_data16_->split, _data16_->split_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
__lambda15_ (Block16Data* _data16_,
             GtkWidget* child)
{
	LargePathbar* self;
	LargePathbarItem* item = NULL;
	LargePathbarItem* _tmp2_;
	gboolean _tmp9_ = FALSE;
	LargePathbarItem* _tmp10_;
	LargePathbarItem* _tmp11_;
	self = _data16_->self;
	g_return_if_fail (child != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_label_get_type ())) {
		if (_data16_->destroy_all) {
			gtk_widget_destroy (child);
		} else {
			const gchar* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = self->priv->complete_path;
			_tmp1_ = g_strconcat (_tmp0_, "/", NULL);
			_g_free0 (self->priv->complete_path);
			self->priv->complete_path = _tmp1_;
		}
		return;
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, TYPE_LARGE_PATHBAR_ITEM, LargePathbarItem));
	item = _tmp2_;
	if (_data16_->maintain_all) {
		const gchar* _tmp3_;
		LargePathbarItem* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		LargePathbarItem* _tmp8_;
		_tmp3_ = self->priv->complete_path;
		_tmp4_ = item;
		_tmp5_ = large_pathbar_item_get_text_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp3_, _tmp6_, NULL);
		_g_free0 (self->priv->complete_path);
		self->priv->complete_path = _tmp7_;
		_tmp8_ = item;
		large_pathbar_activate_item (self, _tmp8_, FALSE);
		_g_object_unref0 (item);
		return;
	}
	_tmp10_ = item;
	_tmp11_ = self->priv->root_button;
	if (_tmp10_ == _tmp11_) {
		_tmp9_ = TRUE;
	} else {
		gboolean _tmp12_ = FALSE;
		if (!_data16_->destroy_all) {
			LargePathbarItem* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar** _tmp16_;
			gint _tmp16__length1;
			const gchar* _tmp17_;
			_tmp13_ = item;
			_tmp14_ = large_pathbar_item_get_text_string (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _data16_->split;
			_tmp16__length1 = _data16_->split_length1;
			_tmp17_ = _tmp16_[0];
			_tmp12_ = g_strcmp0 (_tmp15_, _tmp17_) == 0;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp9_ = _tmp12_;
	}
	if (_tmp9_) {
		const gchar* _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		gchar** _tmp23_;
		gint _tmp23__length1;
		gchar** _tmp24_;
		gint _tmp24__length1;
		gboolean _tmp25_ = FALSE;
		gchar** _tmp26_;
		gint _tmp26__length1;
		_tmp18_ = self->priv->complete_path;
		_tmp19_ = _data16_->split;
		_tmp19__length1 = _data16_->split_length1;
		_tmp20_ = _tmp19_[0];
		_tmp21_ = g_strconcat (_tmp18_, _tmp20_, NULL);
		_g_free0 (self->priv->complete_path);
		self->priv->complete_path = _tmp21_;
		_tmp22_ = _data16_->split;
		_tmp22__length1 = _data16_->split_length1;
		_tmp23_ = _data16_->split;
		_tmp23__length1 = _data16_->split_length1;
		_tmp24_ = (_tmp22_ != NULL) ? _vala_array_dup8 (_tmp22_ + 1, _tmp23__length1 - 1) : _tmp22_;
		_tmp24__length1 = _tmp23__length1 - 1;
		_data16_->split = (_vala_array_free (_data16_->split, _data16_->split_length1, (GDestroyNotify) g_free), NULL);
		_data16_->split = _tmp24_;
		_data16_->split_length1 = _tmp24__length1;
		_data16_->_split_size_ = _data16_->split_length1;
		_tmp26_ = _data16_->split;
		_tmp26__length1 = _data16_->split_length1;
		if (_tmp26__length1 == 0) {
			_tmp25_ = TRUE;
		} else {
			gboolean _tmp27_ = FALSE;
			gchar** _tmp28_;
			gint _tmp28__length1;
			_tmp28_ = _data16_->split;
			_tmp28__length1 = _data16_->split_length1;
			if (_tmp28__length1 == 1) {
				gboolean _tmp29_ = FALSE;
				if (_data16_->type == VIEW_TYPE_FOLDER) {
					_tmp29_ = TRUE;
				} else {
					_tmp29_ = _data16_->type == VIEW_TYPE_CONFIG;
				}
				_tmp27_ = _tmp29_;
			} else {
				_tmp27_ = FALSE;
			}
			_tmp25_ = _tmp27_;
		}
		if (_tmp25_) {
			LargePathbarItem* _tmp30_;
			_tmp30_ = item;
			large_pathbar_activate_item (self, _tmp30_, TRUE);
			_data16_->maintain_all = TRUE;
		} else {
			LargePathbarItem* _tmp31_;
			_tmp31_ = item;
			large_pathbar_activate_item (self, _tmp31_, FALSE);
		}
		_g_object_unref0 (item);
		return;
	}
	gtk_widget_destroy (child);
	_data16_->destroy_all = TRUE;
	_g_object_unref0 (item);
}

static void
___lambda15__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda15_ (self, widget);
}

static void
__lambda16_ (LargePathbar* self,
             GtkWidget* child)
{
	g_return_if_fail (child != NULL);
	gtk_widget_show (child);
}

static void
___lambda16__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda16_ ((LargePathbar*) self, widget);
}

static void
_large_pathbar_set_path (LargePathbar* self,
                         ViewType type,
                         const gchar* path)
{
	Block16Data* _data16_;
	GtkStyleContext* _tmp0_;
	LargePathbarItem* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar* last = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_data16_->type = type;
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	large_pathbar_update_config_style_class (_data16_->type == VIEW_TYPE_CONFIG, _tmp0_);
	_tmp1_ = self->priv->root_button;
	large_pathbar_activate_item (self, _tmp1_, g_strcmp0 (path, "/") == 0);
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->complete_path);
	self->priv->complete_path = _tmp2_;
	_tmp4_ = _tmp3_ = g_strsplit (path, "/", 0);
	_data16_->split = _tmp4_;
	_data16_->split_length1 = _vala_array_length (_tmp3_);
	_data16_->_split_size_ = _data16_->split_length1;
	_tmp5_ = _data16_->split;
	_tmp5__length1 = _data16_->split_length1;
	_tmp6_ = _data16_->split;
	_tmp6__length1 = _data16_->split_length1;
	_tmp7_ = _tmp5_[_tmp6__length1 - 1];
	_tmp8_ = g_strdup (_tmp7_);
	last = _tmp8_;
	_data16_->destroy_all = FALSE;
	_data16_->maintain_all = FALSE;
	gtk_container_foreach ((GtkContainer*) self, ___lambda15__gtk_callback, _data16_);
	_tmp9_ = _data16_->split;
	_tmp9__length1 = _data16_->split_length1;
	if (_tmp9__length1 > 0) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp10_ = _data16_->split;
		_tmp10__length1 = _data16_->split_length1;
		if (_tmp10__length1 > 1) {
			guint index = 0U;
			gchar** _tmp11_;
			gint _tmp11__length1;
			gchar** _tmp12_;
			gint _tmp12__length1;
			index = (guint) 0;
			_tmp11_ = _data16_->split;
			_tmp11__length1 = _data16_->split_length1;
			_tmp12_ = _data16_->split;
			_tmp12__length1 = _data16_->split_length1;
			{
				gchar** item_collection = NULL;
				gint item_collection_length1 = 0;
				gint _item_collection_size_ = 0;
				gint item_it = 0;
				item_collection = _tmp11_ + 0;
				item_collection_length1 = (_tmp12__length1 - 1) - 0;
				for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
					gchar* _tmp13_;
					gchar* item = NULL;
					_tmp13_ = g_strdup (item_collection[item_it]);
					item = _tmp13_;
					{
						const gchar* _tmp14_;
						const gchar* _tmp15_;
						gchar* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
						gboolean _tmp19_ = FALSE;
						gboolean _tmp20_ = FALSE;
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						guint _tmp24_;
						_tmp14_ = self->priv->complete_path;
						_tmp15_ = item;
						_tmp16_ = g_strconcat (_tmp15_, "/", NULL);
						_tmp17_ = _tmp16_;
						_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
						_g_free0 (self->priv->complete_path);
						self->priv->complete_path = _tmp18_;
						_g_free0 (_tmp17_);
						if (_data16_->type == VIEW_TYPE_FOLDER) {
							_tmp20_ = TRUE;
						} else {
							_tmp20_ = _data16_->type == VIEW_TYPE_CONFIG;
						}
						if (_tmp20_) {
							gchar** _tmp21_;
							gint _tmp21__length1;
							_tmp21_ = _data16_->split;
							_tmp21__length1 = _data16_->split_length1;
							_tmp19_ = index == ((guint) (_tmp21__length1 - 2));
						} else {
							_tmp19_ = FALSE;
						}
						_tmp22_ = item;
						_tmp23_ = self->priv->complete_path;
						large_pathbar_add_path_bar_item (self, _tmp22_, _tmp23_, TRUE, _tmp19_);
						large_pathbar_add_slash_label (self);
						_tmp24_ = index;
						index = _tmp24_ + 1;
						_g_free0 (item);
					}
				}
			}
		}
		if (_data16_->type == VIEW_TYPE_OBJECT) {
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			_tmp25_ = self->priv->complete_path;
			_tmp26_ = last;
			_tmp27_ = g_strconcat (_tmp25_, _tmp26_, NULL);
			_g_free0 (self->priv->complete_path);
			self->priv->complete_path = _tmp27_;
			_tmp28_ = last;
			_tmp29_ = self->priv->complete_path;
			large_pathbar_add_path_bar_item (self, _tmp28_, _tmp29_, FALSE, TRUE);
		}
	}
	gtk_container_foreach ((GtkContainer*) self, ___lambda16__gtk_callback, self);
	_g_free0 (last);
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

static inline void
large_pathbar_update_config_style_class (gboolean type_is_config,
                                         GtkStyleContext* context)
{
	g_return_if_fail (context != NULL);
	if (type_is_config) {
		gtk_style_context_add_class (context, "config");
	} else {
		gtk_style_context_remove_class (context, "config");
	}
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		LargePathbar* self;
		self = _data17_->self;
		_g_free0 (_data17_->action_target);
		_g_free0 (_data17_->non_ghost_path);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
__lambda17_ (Block17Data* _data17_,
             GtkWidget* child)
{
	LargePathbar* self;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	self = _data17_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = gtk_widget_get_style_context (child);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	if (IS_LARGE_PATHBAR_ITEM (child)) {
		LargePathbarItem* item = NULL;
		LargePathbarItem* _tmp2_;
		GVariant* variant = NULL;
		LargePathbarItem* _tmp3_;
		GVariant* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		const gchar* _tmp8_;
		LargePathbarItem* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, TYPE_LARGE_PATHBAR_ITEM, LargePathbarItem));
		item = _tmp2_;
		_tmp3_ = item;
		_tmp4_ = gtk_actionable_get_action_target_value ((GtkActionable*) _tmp3_);
		_tmp5_ = _g_variant_ref0 (_tmp4_);
		variant = _tmp5_;
		_tmp6_ = variant;
		if (_tmp6_ == NULL) {
			g_assert_not_reached ();
		}
		_tmp7_ = variant;
		_tmp8_ = g_variant_get_type_string ((GVariant*) _tmp7_);
		if (g_strcmp0 (_tmp8_, "s") == 0) {
			GVariant* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = variant;
			_tmp10_ = g_variant_get_string ((GVariant*) _tmp9_, NULL);
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (_data17_->action_target);
			_data17_->action_target = _tmp11_;
		} else {
			guint16 unused = 0U;
			GVariant* _tmp12_;
			gchar* _tmp13_ = NULL;
			guint16 _tmp14_ = 0U;
			_tmp12_ = variant;
			g_variant_get ((GVariant*) _tmp12_, "(sq)", &_tmp13_, &_tmp14_, NULL);
			_g_free0 (_data17_->action_target);
			_data17_->action_target = _tmp13_;
			unused = _tmp14_;
		}
		_tmp15_ = item;
		_tmp16_ = large_pathbar_item_get_is_active (_tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_) {
			if (_data17_->is_search) {
				LargePathbarItem* _tmp18_;
				LargePathbarItem* _tmp19_;
				LargePathbarItem* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				_tmp18_ = item;
				large_pathbar_item_set_cursor_type (_tmp18_, LARGE_PATHBAR_ITEM_CURSOR_TYPE_POINTER);
				_tmp19_ = item;
				_tmp20_ = item;
				_tmp21_ = large_pathbar_item_get_default_action (_tmp20_);
				_tmp22_ = _tmp21_;
				gtk_actionable_set_detailed_action_name ((GtkActionable*) _tmp19_, _tmp22_);
			} else {
				LargePathbarItem* _tmp23_;
				LargePathbarItem* _tmp24_;
				_tmp23_ = item;
				large_pathbar_item_set_cursor_type (_tmp23_, LARGE_PATHBAR_ITEM_CURSOR_TYPE_CONTEXT);
				_tmp24_ = item;
				gtk_actionable_set_action_name ((GtkActionable*) _tmp24_, "browser.empty");
			}
			if (g_str_has_prefix (_data17_->non_ghost_path, _data17_->action_target)) {
				GtkStyleContext* _tmp25_;
				_tmp25_ = context;
				gtk_style_context_remove_class (_tmp25_, "inexistent");
			} else {
				GtkStyleContext* _tmp26_;
				_tmp26_ = context;
				gtk_style_context_add_class (_tmp26_, "inexistent");
			}
		} else {
			if (g_str_has_prefix (_data17_->non_ghost_path, _data17_->action_target)) {
				LargePathbarItem* _tmp27_;
				LargePathbarItem* _tmp28_;
				LargePathbarItem* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				GtkStyleContext* _tmp32_;
				_tmp27_ = item;
				large_pathbar_item_set_cursor_type (_tmp27_, LARGE_PATHBAR_ITEM_CURSOR_TYPE_POINTER);
				_tmp28_ = item;
				_tmp29_ = item;
				_tmp30_ = large_pathbar_item_get_default_action (_tmp29_);
				_tmp31_ = _tmp30_;
				gtk_actionable_set_detailed_action_name ((GtkActionable*) _tmp28_, _tmp31_);
				_tmp32_ = context;
				gtk_style_context_remove_class (_tmp32_, "inexistent");
			} else {
				LargePathbarItem* _tmp33_;
				LargePathbarItem* _tmp34_;
				LargePathbarItem* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				GtkStyleContext* _tmp38_;
				_tmp33_ = item;
				large_pathbar_item_set_cursor_type (_tmp33_, LARGE_PATHBAR_ITEM_CURSOR_TYPE_DEFAULT);
				_tmp34_ = item;
				_tmp35_ = item;
				_tmp36_ = large_pathbar_item_get_alternative_action (_tmp35_);
				_tmp37_ = _tmp36_;
				gtk_actionable_set_detailed_action_name ((GtkActionable*) _tmp34_, _tmp37_);
				_tmp38_ = context;
				gtk_style_context_add_class (_tmp38_, "inexistent");
			}
		}
		_g_variant_unref0 (variant);
		_g_object_unref0 (item);
	} else {
		if (g_str_has_prefix (_data17_->non_ghost_path, _data17_->action_target)) {
			GtkStyleContext* _tmp39_;
			_tmp39_ = context;
			gtk_style_context_remove_class (_tmp39_, "inexistent");
		} else {
			GtkStyleContext* _tmp40_;
			_tmp40_ = context;
			gtk_style_context_add_class (_tmp40_, "inexistent");
		}
	}
	_g_object_unref0 (context);
}

static void
___lambda17__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda17_ (self, widget);
}

static void
large_pathbar_real_update_ghosts (Pathbar* base,
                                  const gchar* non_ghost_path,
                                  gboolean is_search)
{
	LargePathbar * self;
	Block17Data* _data17_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = (LargePathbar*) base;
	g_return_if_fail (non_ghost_path != NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = g_strdup (non_ghost_path);
	_g_free0 (_data17_->non_ghost_path);
	_data17_->non_ghost_path = _tmp0_;
	_data17_->is_search = is_search;
	_tmp1_ = g_strdup (_data17_->non_ghost_path);
	_g_free0 (self->priv->fallback_path);
	self->priv->fallback_path = _tmp1_;
	_tmp2_ = g_strdup ("");
	_data17_->action_target = _tmp2_;
	gtk_container_foreach ((GtkContainer*) self, ___lambda17__gtk_callback, _data17_);
	block17_data_unref (_data17_);
	_data17_ = NULL;
}

static inline void
large_pathbar_update_active_button_cursor (ViewType type,
                                           LargePathbarItem** active_button)
{
	g_return_if_fail (*active_button != NULL);
	if (type == VIEW_TYPE_CONFIG) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		large_pathbar_item_set_cursor_type (*active_button, LARGE_PATHBAR_ITEM_CURSOR_TYPE_POINTER);
		_tmp0_ = large_pathbar_item_get_default_action (*active_button);
		_tmp1_ = _tmp0_;
		gtk_actionable_set_detailed_action_name ((GtkActionable*) (*active_button), _tmp1_);
	} else {
		large_pathbar_item_set_cursor_type (*active_button, LARGE_PATHBAR_ITEM_CURSOR_TYPE_CONTEXT);
		gtk_actionable_set_action_name ((GtkActionable*) (*active_button), "browser.empty");
	}
}

static void
large_pathbar_add_slash_label (LargePathbar* self)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("/");
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
large_pathbar_add_path_bar_item (LargePathbar* self,
                                 const gchar* label,
                                 const gchar* complete_path,
                                 gboolean is_folder,
                                 gboolean block)
{
	LargePathbarItem* path_bar_item = NULL;
	LargePathbarItem* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (complete_path != NULL);
	_tmp0_ = large_pathbar_create_path_bar_item (label, complete_path, is_folder);
	path_bar_item = _tmp0_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) path_bar_item);
	large_pathbar_activate_item (self, path_bar_item, block);
	_g_object_unref0 (path_bar_item);
}

static inline LargePathbarItem*
large_pathbar_create_path_bar_item (const gchar* label,
                                    const gchar* complete_path,
                                    gboolean is_folder)
{
	LargePathbarItem* path_bar_item = NULL;
	LargePathbarItem* result;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (complete_path != NULL, NULL);
	if (is_folder) {
		LargePathbarItem* _tmp0_ = NULL;
		large_pathbar_init_folder_path_bar_item (label, complete_path, &_tmp0_);
		_g_object_unref0 (path_bar_item);
		path_bar_item = _tmp0_;
	} else {
		LargePathbarItem* _tmp1_ = NULL;
		large_pathbar_init_object_path_bar_item (label, complete_path, &_tmp1_);
		_g_object_unref0 (path_bar_item);
		path_bar_item = _tmp1_;
	}
	result = path_bar_item;
	return result;
}

static inline void
large_pathbar_init_folder_path_bar_item (const gchar* label,
                                         const gchar* complete_path,
                                         LargePathbarItem** path_bar_item)
{
	LargePathbarItem* _vala_path_bar_item = NULL;
	GVariant* variant = NULL;
	GVariant* _tmp0_;
	gchar* _variant = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	LargePathbarItem* _tmp10_;
	g_return_if_fail (label != NULL);
	g_return_if_fail (complete_path != NULL);
	_tmp0_ = g_variant_new_string (complete_path);
	g_variant_ref_sink (_tmp0_);
	variant = _tmp0_;
	_tmp1_ = g_variant_print (variant, FALSE);
	_variant = _tmp1_;
	_tmp2_ = g_strconcat ("browser.open-folder(", _variant, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ")", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("ui.notify-folder-emptied(", _variant, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, ")", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = large_pathbar_item_new (label, _tmp5_, _tmp9_, TRUE);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (_vala_path_bar_item);
	_vala_path_bar_item = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_variant);
	_g_variant_unref0 (variant);
	if (path_bar_item) {
		*path_bar_item = _vala_path_bar_item;
	} else {
		_g_object_unref0 (_vala_path_bar_item);
	}
}

static inline void
large_pathbar_init_object_path_bar_item (const gchar* label,
                                         const gchar* complete_path,
                                         LargePathbarItem** path_bar_item)
{
	LargePathbarItem* _vala_path_bar_item = NULL;
	GVariant* variant = NULL;
	GVariant* _tmp0_;
	gchar* _variant = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	LargePathbarItem* _tmp10_;
	g_return_if_fail (label != NULL);
	g_return_if_fail (complete_path != NULL);
	_tmp0_ = g_variant_new ("(sq)", complete_path, MODEL_UTILS_undefined_context_id, NULL);
	g_variant_ref_sink (_tmp0_);
	variant = _tmp0_;
	_tmp1_ = g_variant_print (variant, TRUE);
	_variant = _tmp1_;
	_tmp2_ = g_strconcat ("browser.open-object(", _variant, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ")", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("ui.notify-object-deleted(", _variant, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, ")", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = large_pathbar_item_new (label, _tmp5_, _tmp9_, FALSE);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (_vala_path_bar_item);
	_vala_path_bar_item = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_variant);
	_g_variant_unref0 (variant);
	if (path_bar_item) {
		*path_bar_item = _vala_path_bar_item;
	} else {
		_g_object_unref0 (_vala_path_bar_item);
	}
}

static void
large_pathbar_activate_item (LargePathbar* self,
                             LargePathbarItem* item,
                             gboolean state)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	if (state) {
		LargePathbarItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (item);
		_g_object_unref0 (self->priv->active_button);
		self->priv->active_button = _tmp0_;
	}
	_large_pathbar_activate_item (item, state);
}

static inline void
_large_pathbar_activate_item (LargePathbarItem* item,
                              gboolean state)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (item != NULL);
	_tmp0_ = large_pathbar_item_get_is_active (item);
	_tmp1_ = _tmp0_;
	if (state == _tmp1_) {
		return;
	}
	if (state) {
		GtkStyleContext* _tmp2_;
		large_pathbar_item_set_is_active (item, TRUE);
		large_pathbar_item_set_cursor_type (item, LARGE_PATHBAR_ITEM_CURSOR_TYPE_CONTEXT);
		gtk_actionable_set_action_name ((GtkActionable*) item, "browser.empty");
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) item);
		gtk_style_context_add_class (_tmp2_, "active");
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GtkStyleContext* _tmp5_;
		large_pathbar_item_set_is_active (item, FALSE);
		large_pathbar_item_set_cursor_type (item, LARGE_PATHBAR_ITEM_CURSOR_TYPE_POINTER);
		_tmp3_ = large_pathbar_item_get_default_action (item);
		_tmp4_ = _tmp3_;
		gtk_actionable_set_detailed_action_name ((GtkActionable*) item, _tmp4_);
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) item);
		gtk_style_context_remove_class (_tmp5_, "active");
	}
}

static GObject *
large_pathbar_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	LargePathbar * self;
	LargePathbarItem* _tmp0_;
	LargePathbarItem* _tmp1_;
	parent_class = G_OBJECT_CLASS (large_pathbar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LARGE_PATHBAR, LargePathbar);
	_tmp0_ = self->priv->root_button;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->active_button);
	self->priv->active_button = _tmp1_;
	large_pathbar_add_slash_label (self);
	return obj;
}

static void
large_pathbar_class_init (LargePathbarClass * klass,
                          gpointer klass_data)
{
	large_pathbar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &LargePathbar_private_offset);
	G_OBJECT_CLASS (klass)->constructor = large_pathbar_constructor;
	G_OBJECT_CLASS (klass)->finalize = large_pathbar_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/large-pathbar.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "root_button", FALSE, LargePathbar_private_offset + G_STRUCT_OFFSET (LargePathbarPrivate, root_button));
}

static void
large_pathbar_pathbar_interface_init (PathbarIface * iface,
                                      gpointer iface_data)
{
	large_pathbar_pathbar_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_complete_path = (void (*) (Pathbar*, gchar**)) large_pathbar_real_get_complete_path;
	iface->get_fallback_path_and_complete_path = (void (*) (Pathbar*, gchar**, gchar**)) large_pathbar_real_get_fallback_path_and_complete_path;
	iface->has_popover = (gboolean (*) (Pathbar*)) large_pathbar_real_has_popover;
	iface->close_menu = (void (*) (Pathbar*)) large_pathbar_real_close_menu;
	iface->toggle_menu = (void (*) (Pathbar*)) large_pathbar_real_toggle_menu;
	iface->set_path = (void (*) (Pathbar*, ViewType, const gchar*)) large_pathbar_real_set_path;
	iface->update_ghosts = (void (*) (Pathbar*, const gchar*, gboolean)) large_pathbar_real_update_ghosts;
}

static void
large_pathbar_instance_init (LargePathbar * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = large_pathbar_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->complete_path = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->fallback_path = _tmp1_;
	g_type_ensure (TYPE_LARGE_PATHBAR_ITEM);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
large_pathbar_finalize (GObject * obj)
{
	LargePathbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LARGE_PATHBAR, LargePathbar);
	_g_object_unref0 (self->priv->active_button);
	_g_free0 (self->priv->complete_path);
	_g_free0 (self->priv->fallback_path);
	G_OBJECT_CLASS (large_pathbar_parent_class)->finalize (obj);
}

static GType
large_pathbar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LargePathbarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) large_pathbar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LargePathbar), 0, (GInstanceInitFunc) large_pathbar_instance_init, NULL };
	static const GInterfaceInfo pathbar_info = { (GInterfaceInitFunc) large_pathbar_pathbar_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType large_pathbar_type_id;
	large_pathbar_type_id = g_type_register_static (gtk_box_get_type (), "LargePathbar", &g_define_type_info, 0);
	g_type_add_interface_static (large_pathbar_type_id, TYPE_PATHBAR, &pathbar_info);
	LargePathbar_private_offset = g_type_add_instance_private (large_pathbar_type_id, sizeof (LargePathbarPrivate));
	return large_pathbar_type_id;
}

GType
large_pathbar_get_type (void)
{
	static volatile gsize large_pathbar_type_id__once = 0;
	if (g_once_init_enter (&large_pathbar_type_id__once)) {
		GType large_pathbar_type_id;
		large_pathbar_type_id = large_pathbar_get_type_once ();
		g_once_init_leave (&large_pathbar_type_id__once, large_pathbar_type_id);
	}
	return large_pathbar_type_id__once;
}

static inline gpointer
large_pathbar_item_get_instance_private (LargePathbarItem* self)
{
	return G_STRUCT_MEMBER_P (self, LargePathbarItem_private_offset);
}

static GType
large_pathbar_item_cursor_type_get_type_once (void)
{
	static const GEnumValue values[] = {{LARGE_PATHBAR_ITEM_CURSOR_TYPE_DEFAULT, "LARGE_PATHBAR_ITEM_CURSOR_TYPE_DEFAULT", "default"}, {LARGE_PATHBAR_ITEM_CURSOR_TYPE_POINTER, "LARGE_PATHBAR_ITEM_CURSOR_TYPE_POINTER", "pointer"}, {LARGE_PATHBAR_ITEM_CURSOR_TYPE_CONTEXT, "LARGE_PATHBAR_ITEM_CURSOR_TYPE_CONTEXT", "context"}, {0, NULL, NULL}};
	GType large_pathbar_item_cursor_type_type_id;
	large_pathbar_item_cursor_type_type_id = g_enum_register_static ("LargePathbarItemCursorType", values);
	return large_pathbar_item_cursor_type_type_id;
}

GType
large_pathbar_item_cursor_type_get_type (void)
{
	static volatile gsize large_pathbar_item_cursor_type_type_id__once = 0;
	if (g_once_init_enter (&large_pathbar_item_cursor_type_type_id__once)) {
		GType large_pathbar_item_cursor_type_type_id;
		large_pathbar_item_cursor_type_type_id = large_pathbar_item_cursor_type_get_type_once ();
		g_once_init_leave (&large_pathbar_item_cursor_type_type_id__once, large_pathbar_item_cursor_type_type_id);
	}
	return large_pathbar_item_cursor_type_type_id__once;
}

void
large_pathbar_item_set_cursor_type (LargePathbarItem* self,
                                    LargePathbarItemCursorType cursor_type)
{
	g_return_if_fail (self != NULL);
	self->priv->cursor_type = cursor_type;
	if (self->priv->hover) {
		large_pathbar_item_set_new_cursor_type (self, cursor_type);
	}
}

static void
large_pathbar_item_set_new_cursor_type (LargePathbarItem* self,
                                        LargePathbarItemCursorType new_cursor_type)
{
	GdkWindow* gdk_window = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp2_;
	GdkDisplay* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GdkWindow* _tmp5_;
	GdkCursor* cursor = NULL;
	GdkWindow* _tmp11_;
	GdkCursor* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	gdk_window = _tmp1_;
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	display = _tmp3_;
	_tmp5_ = gdk_window;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		GdkDisplay* _tmp6_;
		_tmp6_ = display;
		_tmp4_ = _tmp6_ == NULL;
	}
	if (_tmp4_) {
		_g_object_unref0 (display);
		_g_object_unref0 (gdk_window);
		return;
	}
	cursor = NULL;
	switch (new_cursor_type) {
		case LARGE_PATHBAR_ITEM_CURSOR_TYPE_DEFAULT:
		{
			_g_object_unref0 (cursor);
			cursor = NULL;
			break;
		}
		case LARGE_PATHBAR_ITEM_CURSOR_TYPE_POINTER:
		{
			GdkDisplay* _tmp7_;
			GdkCursor* _tmp8_;
			_tmp7_ = display;
			_tmp8_ = gdk_cursor_new_from_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gdk_display_get_type (), GdkDisplay), "pointer");
			_g_object_unref0 (cursor);
			cursor = _tmp8_;
			break;
		}
		case LARGE_PATHBAR_ITEM_CURSOR_TYPE_CONTEXT:
		{
			GdkDisplay* _tmp9_;
			GdkCursor* _tmp10_;
			_tmp9_ = display;
			_tmp10_ = gdk_cursor_new_from_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gdk_display_get_type (), GdkDisplay), "context-menu");
			_g_object_unref0 (cursor);
			cursor = _tmp10_;
			break;
		}
		default:
		break;
	}
	_tmp11_ = gdk_window;
	_tmp12_ = cursor;
	gdk_window_set_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gdk_window_get_type (), GdkWindow), _tmp12_);
	_g_object_unref0 (cursor);
	_g_object_unref0 (display);
	_g_object_unref0 (gdk_window);
}

static void
large_pathbar_item_update_cursor (LargePathbarItem* self)
{
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkStyleContext* _tmp3_;
	GtkPopover* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	_tmp3_ = context;
	if (gtk_style_context_has_class (_tmp3_, "inexistent")) {
		GtkStyleContext* _tmp4_;
		_tmp4_ = context;
		_tmp2_ = !gtk_style_context_has_class (_tmp4_, "active");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_g_object_unref0 (context);
		return;
	}
	if (self->priv->cursor_type != LARGE_PATHBAR_ITEM_CURSOR_TYPE_CONTEXT) {
		self->priv->cursor_type = LARGE_PATHBAR_ITEM_CURSOR_TYPE_CONTEXT;
		large_pathbar_item_set_new_cursor_type (self, self->priv->cursor_type);
		_g_object_unref0 (context);
		return;
	}
	large_pathbar_item_generate_popover (self);
	_tmp5_ = self->priv->popover;
	gtk_popover_popup (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_popover_get_type (), GtkPopover));
	_g_object_unref0 (context);
}

static void
_large_pathbar_item_update_cursor_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	large_pathbar_item_update_cursor ((LargePathbarItem*) self);
}

LargePathbarItem*
large_pathbar_item_construct (GType object_type,
                              const gchar* label,
                              const gchar* _default_action,
                              const gchar* _alternative_action,
                              gboolean _has_config_menu)
{
	LargePathbarItem * self = NULL;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (_default_action != NULL, NULL);
	g_return_val_if_fail (_alternative_action != NULL, NULL);
	self = (LargePathbarItem*) g_object_new (object_type, "text-string", label, "default-action", _default_action, "alternative-action", _alternative_action, "has-config-menu", _has_config_menu, NULL);
	_tmp0_ = self->priv->text_label;
	gtk_label_set_text (_tmp0_, label);
	gtk_actionable_set_detailed_action_name ((GtkActionable*) self, _default_action);
	return self;
}

LargePathbarItem*
large_pathbar_item_new (const gchar* label,
                        const gchar* _default_action,
                        const gchar* _alternative_action,
                        gboolean _has_config_menu)
{
	return large_pathbar_item_construct (TYPE_LARGE_PATHBAR_ITEM, label, _default_action, _alternative_action, _has_config_menu);
}

gboolean
large_pathbar_item_has_popover (LargePathbarItem* self)
{
	gboolean _tmp0_ = FALSE;
	GtkPopover* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->popover;
	if (_tmp1_ != NULL) {
		GtkPopover* _tmp2_;
		_tmp2_ = self->priv->popover;
		_tmp0_ = gtk_widget_get_mapped ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_popover_get_type (), GtkPopover));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
large_pathbar_item_close_menu (LargePathbarItem* self)
{
	g_return_if_fail (self != NULL);
	if (large_pathbar_item_has_popover (self)) {
		GtkPopover* _tmp0_;
		_tmp0_ = self->priv->popover;
		gtk_popover_popdown (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_popover_get_type (), GtkPopover));
	}
}

void
large_pathbar_item_toggle_menu (LargePathbarItem* self)
{
	GtkPopover* _tmp0_;
	GtkPopover* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	if (_tmp0_ == NULL) {
		large_pathbar_item_generate_popover (self);
	}
	_tmp1_ = self->priv->popover;
	if (gtk_widget_get_mapped ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_popover_get_type (), GtkPopover))) {
		GtkPopover* _tmp2_;
		_tmp2_ = self->priv->popover;
		gtk_popover_popdown (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_popover_get_type (), GtkPopover));
	} else {
		GtkPopover* _tmp3_;
		_tmp3_ = self->priv->popover;
		gtk_popover_popup (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_popover_get_type (), GtkPopover));
	}
}

static void
large_pathbar_item_generate_popover (LargePathbarItem* self)
{
	GMenu* menu = NULL;
	GMenu* _tmp0_;
	gboolean _tmp1_;
	GMenu* _tmp2_;
	GMenu* _tmp3_;
	GtkPopover* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_menu_new ();
	menu = _tmp0_;
	_tmp1_ = self->priv->_has_config_menu;
	pathbar_populate_pathbar_menu (_tmp1_, &menu);
	_tmp2_ = menu;
	g_menu_freeze (_tmp2_);
	_tmp3_ = menu;
	_tmp4_ = (GtkPopover*) gtk_popover_new_from_model ((GtkWidget*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_menu_model_get_type (), GMenuModel));
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp4_;
	_g_object_unref0 (menu);
}

gboolean
large_pathbar_item_get_is_active (LargePathbarItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_active;
	return result;
}

void
large_pathbar_item_set_is_active (LargePathbarItem* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_active = value;
}

const gchar*
large_pathbar_item_get_alternative_action (LargePathbarItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_alternative_action;
	result = _tmp0_;
	return result;
}

static void
large_pathbar_item_set_alternative_action (LargePathbarItem* self,
                                           const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_alternative_action);
	self->priv->_alternative_action = _tmp0_;
}

const gchar*
large_pathbar_item_get_default_action (LargePathbarItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_action;
	result = _tmp0_;
	return result;
}

static void
large_pathbar_item_set_default_action (LargePathbarItem* self,
                                       const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_default_action);
	self->priv->_default_action = _tmp0_;
}

const gchar*
large_pathbar_item_get_text_string (LargePathbarItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text_string;
	result = _tmp0_;
	return result;
}

static void
large_pathbar_item_set_text_string (LargePathbarItem* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_text_string);
	self->priv->_text_string = _tmp0_;
}

static gboolean
large_pathbar_item_get_has_config_menu (LargePathbarItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_config_menu;
	return result;
}

static void
large_pathbar_item_set_has_config_menu (LargePathbarItem* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_config_menu = value;
}

static gboolean
_large_pathbar_item___lambda13_ (LargePathbarItem* self)
{
	self->priv->hover = TRUE;
	large_pathbar_item_set_new_cursor_type (self, self->priv->cursor_type);
}

static gboolean
__large_pathbar_item___lambda13__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                GdkEventCrossing* event,
                                                                gpointer self)
{
	gboolean result;
	result = _large_pathbar_item___lambda13_ ((LargePathbarItem*) self);
	return result;
}

static gboolean
_large_pathbar_item___lambda14_ (LargePathbarItem* self)
{
	self->priv->hover = FALSE;
	large_pathbar_item_set_new_cursor_type (self, LARGE_PATHBAR_ITEM_CURSOR_TYPE_DEFAULT);
}

static gboolean
__large_pathbar_item___lambda14__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                GdkEventCrossing* event,
                                                                gpointer self)
{
	gboolean result;
	result = _large_pathbar_item___lambda14_ ((LargePathbarItem*) self);
	return result;
}

static GObject *
large_pathbar_item_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	LargePathbarItem * self;
	parent_class = G_OBJECT_CLASS (large_pathbar_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LARGE_PATHBAR_ITEM, LargePathbarItem);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) __large_pathbar_item___lambda13__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) __large_pathbar_item___lambda14__gtk_widget_leave_notify_event, self, 0);
	return obj;
}

static void
large_pathbar_item_class_init (LargePathbarItemClass * klass,
                               gpointer klass_data)
{
	large_pathbar_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &LargePathbarItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_large_pathbar_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_large_pathbar_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = large_pathbar_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = large_pathbar_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LARGE_PATHBAR_ITEM_IS_ACTIVE_PROPERTY, large_pathbar_item_properties[LARGE_PATHBAR_ITEM_IS_ACTIVE_PROPERTY] = g_param_spec_boolean ("is-active", "is-active", "is-active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LARGE_PATHBAR_ITEM_ALTERNATIVE_ACTION_PROPERTY, large_pathbar_item_properties[LARGE_PATHBAR_ITEM_ALTERNATIVE_ACTION_PROPERTY] = g_param_spec_string ("alternative-action", "alternative-action", "alternative-action", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LARGE_PATHBAR_ITEM_DEFAULT_ACTION_PROPERTY, large_pathbar_item_properties[LARGE_PATHBAR_ITEM_DEFAULT_ACTION_PROPERTY] = g_param_spec_string ("default-action", "default-action", "default-action", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LARGE_PATHBAR_ITEM_TEXT_STRING_PROPERTY, large_pathbar_item_properties[LARGE_PATHBAR_ITEM_TEXT_STRING_PROPERTY] = g_param_spec_string ("text-string", "text-string", "text-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LARGE_PATHBAR_ITEM_HAS_CONFIG_MENU_PROPERTY, large_pathbar_item_properties[LARGE_PATHBAR_ITEM_HAS_CONFIG_MENU_PROPERTY] = g_param_spec_boolean ("has-config-menu", "has-config-menu", "has-config-menu", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/large-pathbar-item.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_label", FALSE, LargePathbarItem_private_offset + G_STRUCT_OFFSET (LargePathbarItemPrivate, text_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "update_cursor", G_CALLBACK(_large_pathbar_item_update_cursor_gtk_button_clicked));
}

static void
large_pathbar_item_instance_init (LargePathbarItem * self,
                                  gpointer klass)
{
	self->priv = large_pathbar_item_get_instance_private (self);
	self->priv->_is_active = FALSE;
	self->priv->popover = NULL;
	self->priv->cursor_type = LARGE_PATHBAR_ITEM_CURSOR_TYPE_POINTER;
	self->priv->hover = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
large_pathbar_item_finalize (GObject * obj)
{
	LargePathbarItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LARGE_PATHBAR_ITEM, LargePathbarItem);
	_g_free0 (self->priv->_alternative_action);
	_g_free0 (self->priv->_default_action);
	_g_free0 (self->priv->_text_string);
	_g_object_unref0 (self->priv->popover);
	G_OBJECT_CLASS (large_pathbar_item_parent_class)->finalize (obj);
}

static GType
large_pathbar_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LargePathbarItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) large_pathbar_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LargePathbarItem), 0, (GInstanceInitFunc) large_pathbar_item_instance_init, NULL };
	GType large_pathbar_item_type_id;
	large_pathbar_item_type_id = g_type_register_static (gtk_button_get_type (), "LargePathbarItem", &g_define_type_info, 0);
	LargePathbarItem_private_offset = g_type_add_instance_private (large_pathbar_item_type_id, sizeof (LargePathbarItemPrivate));
	return large_pathbar_item_type_id;
}

GType
large_pathbar_item_get_type (void)
{
	static volatile gsize large_pathbar_item_type_id__once = 0;
	if (g_once_init_enter (&large_pathbar_item_type_id__once)) {
		GType large_pathbar_item_type_id;
		large_pathbar_item_type_id = large_pathbar_item_get_type_once ();
		g_once_init_leave (&large_pathbar_item_type_id__once, large_pathbar_item_type_id);
	}
	return large_pathbar_item_type_id__once;
}

static void
_vala_large_pathbar_item_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	LargePathbarItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LARGE_PATHBAR_ITEM, LargePathbarItem);
	switch (property_id) {
		case LARGE_PATHBAR_ITEM_IS_ACTIVE_PROPERTY:
		g_value_set_boolean (value, large_pathbar_item_get_is_active (self));
		break;
		case LARGE_PATHBAR_ITEM_ALTERNATIVE_ACTION_PROPERTY:
		g_value_set_string (value, large_pathbar_item_get_alternative_action (self));
		break;
		case LARGE_PATHBAR_ITEM_DEFAULT_ACTION_PROPERTY:
		g_value_set_string (value, large_pathbar_item_get_default_action (self));
		break;
		case LARGE_PATHBAR_ITEM_TEXT_STRING_PROPERTY:
		g_value_set_string (value, large_pathbar_item_get_text_string (self));
		break;
		case LARGE_PATHBAR_ITEM_HAS_CONFIG_MENU_PROPERTY:
		g_value_set_boolean (value, large_pathbar_item_get_has_config_menu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_large_pathbar_item_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	LargePathbarItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LARGE_PATHBAR_ITEM, LargePathbarItem);
	switch (property_id) {
		case LARGE_PATHBAR_ITEM_IS_ACTIVE_PROPERTY:
		large_pathbar_item_set_is_active (self, g_value_get_boolean (value));
		break;
		case LARGE_PATHBAR_ITEM_ALTERNATIVE_ACTION_PROPERTY:
		large_pathbar_item_set_alternative_action (self, g_value_get_string (value));
		break;
		case LARGE_PATHBAR_ITEM_DEFAULT_ACTION_PROPERTY:
		large_pathbar_item_set_default_action (self, g_value_get_string (value));
		break;
		case LARGE_PATHBAR_ITEM_TEXT_STRING_PROPERTY:
		large_pathbar_item_set_text_string (self, g_value_get_string (value));
		break;
		case LARGE_PATHBAR_ITEM_HAS_CONFIG_MENU_PROPERTY:
		large_pathbar_item_set_has_config_menu (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

