/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "./portal/flatpak-portal-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.Flatpak
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PortalFlatpak
 * @title: PortalFlatpak
 * @short_description: Generated C code for the org.freedesktop.portal.Flatpak D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak.top_of_page">org.freedesktop.portal.Flatpak</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.Flatpak ---- */

static const _ExtendedGDBusArgInfo _portal_flatpak_method_info_spawn_IN_ARG_cwd_path =
{
  {
    -1,
    (gchar *) "cwd_path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_method_info_spawn_IN_ARG_argv =
{
  {
    -1,
    (gchar *) "argv",
    (gchar *) "aay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_method_info_spawn_IN_ARG_fds =
{
  {
    -1,
    (gchar *) "fds",
    (gchar *) "a{uh}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_method_info_spawn_IN_ARG_envs =
{
  {
    -1,
    (gchar *) "envs",
    (gchar *) "a{ss}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_method_info_spawn_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_method_info_spawn_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _portal_flatpak_method_info_spawn_IN_ARG_pointers[] =
{
  &_portal_flatpak_method_info_spawn_IN_ARG_cwd_path.parent_struct,
  &_portal_flatpak_method_info_spawn_IN_ARG_argv.parent_struct,
  &_portal_flatpak_method_info_spawn_IN_ARG_fds.parent_struct,
  &_portal_flatpak_method_info_spawn_IN_ARG_envs.parent_struct,
  &_portal_flatpak_method_info_spawn_IN_ARG_flags.parent_struct,
  &_portal_flatpak_method_info_spawn_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _portal_flatpak_method_info_spawn_OUT_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _portal_flatpak_method_info_spawn_OUT_ARG_pointers[] =
{
  &_portal_flatpak_method_info_spawn_OUT_ARG_pid.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _portal_flatpak_method_info_spawn =
{
  {
    -1,
    (gchar *) "Spawn",
    (GDBusArgInfo **) &_portal_flatpak_method_info_spawn_IN_ARG_pointers,
    (GDBusArgInfo **) &_portal_flatpak_method_info_spawn_OUT_ARG_pointers,
    NULL
  },
  "handle-spawn",
  TRUE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_method_info_spawn_signal_IN_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_method_info_spawn_signal_IN_ARG_signal =
{
  {
    -1,
    (gchar *) "signal",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_method_info_spawn_signal_IN_ARG_to_process_group =
{
  {
    -1,
    (gchar *) "to_process_group",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _portal_flatpak_method_info_spawn_signal_IN_ARG_pointers[] =
{
  &_portal_flatpak_method_info_spawn_signal_IN_ARG_pid.parent_struct,
  &_portal_flatpak_method_info_spawn_signal_IN_ARG_signal.parent_struct,
  &_portal_flatpak_method_info_spawn_signal_IN_ARG_to_process_group.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _portal_flatpak_method_info_spawn_signal =
{
  {
    -1,
    (gchar *) "SpawnSignal",
    (GDBusArgInfo **) &_portal_flatpak_method_info_spawn_signal_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-spawn-signal",
  FALSE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_method_info_create_update_monitor_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _portal_flatpak_method_info_create_update_monitor_IN_ARG_pointers[] =
{
  &_portal_flatpak_method_info_create_update_monitor_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _portal_flatpak_method_info_create_update_monitor_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _portal_flatpak_method_info_create_update_monitor_OUT_ARG_pointers[] =
{
  &_portal_flatpak_method_info_create_update_monitor_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _portal_flatpak_method_info_create_update_monitor =
{
  {
    -1,
    (gchar *) "CreateUpdateMonitor",
    (GDBusArgInfo **) &_portal_flatpak_method_info_create_update_monitor_IN_ARG_pointers,
    (GDBusArgInfo **) &_portal_flatpak_method_info_create_update_monitor_OUT_ARG_pointers,
    NULL
  },
  "handle-create-update-monitor",
  FALSE
};

static const GDBusMethodInfo * const _portal_flatpak_method_info_pointers[] =
{
  &_portal_flatpak_method_info_spawn.parent_struct,
  &_portal_flatpak_method_info_spawn_signal.parent_struct,
  &_portal_flatpak_method_info_create_update_monitor.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _portal_flatpak_signal_info_spawn_started_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_signal_info_spawn_started_ARG_relpid =
{
  {
    -1,
    (gchar *) "relpid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _portal_flatpak_signal_info_spawn_started_ARG_pointers[] =
{
  &_portal_flatpak_signal_info_spawn_started_ARG_pid.parent_struct,
  &_portal_flatpak_signal_info_spawn_started_ARG_relpid.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _portal_flatpak_signal_info_spawn_started =
{
  {
    -1,
    (gchar *) "SpawnStarted",
    (GDBusArgInfo **) &_portal_flatpak_signal_info_spawn_started_ARG_pointers,
    NULL
  },
  "spawn-started"
};

static const _ExtendedGDBusArgInfo _portal_flatpak_signal_info_spawn_exited_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_signal_info_spawn_exited_ARG_exit_status =
{
  {
    -1,
    (gchar *) "exit_status",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _portal_flatpak_signal_info_spawn_exited_ARG_pointers[] =
{
  &_portal_flatpak_signal_info_spawn_exited_ARG_pid.parent_struct,
  &_portal_flatpak_signal_info_spawn_exited_ARG_exit_status.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _portal_flatpak_signal_info_spawn_exited =
{
  {
    -1,
    (gchar *) "SpawnExited",
    (GDBusArgInfo **) &_portal_flatpak_signal_info_spawn_exited_ARG_pointers,
    NULL
  },
  "spawn-exited"
};

static const GDBusSignalInfo * const _portal_flatpak_signal_info_pointers[] =
{
  &_portal_flatpak_signal_info_spawn_started.parent_struct,
  &_portal_flatpak_signal_info_spawn_exited.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _portal_flatpak_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _portal_flatpak_property_info_supports =
{
  {
    -1,
    (gchar *) "supports",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supports",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _portal_flatpak_property_info_pointers[] =
{
  &_portal_flatpak_property_info_version.parent_struct,
  &_portal_flatpak_property_info_supports.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _portal_flatpak_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.Flatpak",
    (GDBusMethodInfo **) &_portal_flatpak_method_info_pointers,
    (GDBusSignalInfo **) &_portal_flatpak_signal_info_pointers,
    (GDBusPropertyInfo **) &_portal_flatpak_property_info_pointers,
    NULL
  },
  "flatpak",
};


/**
 * portal_flatpak_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak.top_of_page">org.freedesktop.portal.Flatpak</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
portal_flatpak_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_portal_flatpak_interface_info.parent_struct;
}

/**
 * portal_flatpak_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PortalFlatpak interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
portal_flatpak_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  g_object_class_override_property (klass, property_id_begin++, "supports");
  return property_id_begin - 1;
}



/**
 * PortalFlatpak:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak.top_of_page">org.freedesktop.portal.Flatpak</link>.
 */

/**
 * PortalFlatpakIface:
 * @parent_iface: The parent interface.
 * @handle_create_update_monitor: Handler for the #PortalFlatpak::handle-create-update-monitor signal.
 * @handle_spawn: Handler for the #PortalFlatpak::handle-spawn signal.
 * @handle_spawn_signal: Handler for the #PortalFlatpak::handle-spawn-signal signal.
 * @get_supports: Getter for the #PortalFlatpak:supports property.
 * @get_version: Getter for the #PortalFlatpak:version property.
 * @spawn_exited: Handler for the #PortalFlatpak::spawn-exited signal.
 * @spawn_started: Handler for the #PortalFlatpak::spawn-started signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak.top_of_page">org.freedesktop.portal.Flatpak</link>.
 */

typedef PortalFlatpakIface PortalFlatpakInterface;
G_DEFINE_INTERFACE (PortalFlatpak, portal_flatpak, G_TYPE_OBJECT)

static void
portal_flatpak_default_init (PortalFlatpakIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PortalFlatpak::handle-spawn:
   * @object: A #PortalFlatpak.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_cwd_path: Argument passed by remote caller.
   * @arg_argv: Argument passed by remote caller.
   * @arg_fds: Argument passed by remote caller.
   * @arg_envs: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak.Spawn">Spawn()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call portal_flatpak_complete_spawn() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-spawn",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PortalFlatpakIface, handle_spawn),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    8,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_VARIANT, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_VARIANT);

  /**
   * PortalFlatpak::handle-spawn-signal:
   * @object: A #PortalFlatpak.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pid: Argument passed by remote caller.
   * @arg_signal: Argument passed by remote caller.
   * @arg_to_process_group: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak.SpawnSignal">SpawnSignal()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call portal_flatpak_complete_spawn_signal() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-spawn-signal",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PortalFlatpakIface, handle_spawn_signal),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * PortalFlatpak::handle-create-update-monitor:
   * @object: A #PortalFlatpak.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak.CreateUpdateMonitor">CreateUpdateMonitor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call portal_flatpak_complete_create_update_monitor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-update-monitor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PortalFlatpakIface, handle_create_update_monitor),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * PortalFlatpak::spawn-started:
   * @object: A #PortalFlatpak.
   * @arg_pid: Argument.
   * @arg_relpid: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-portal-Flatpak.SpawnStarted">"SpawnStarted"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("spawn-started",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PortalFlatpakIface, spawn_started),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * PortalFlatpak::spawn-exited:
   * @object: A #PortalFlatpak.
   * @arg_pid: Argument.
   * @arg_exit_status: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-portal-Flatpak.SpawnExited">"SpawnExited"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("spawn-exited",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PortalFlatpakIface, spawn_exited),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_UINT, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * PortalFlatpak:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-Flatpak.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * PortalFlatpak:supports:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-Flatpak.supports">"supports"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("supports", "supports", "supports", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * portal_flatpak_get_version: (skip)
 * @object: A #PortalFlatpak.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-Flatpak.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
portal_flatpak_get_version (PortalFlatpak *object)
{
  return PORTAL_FLATPAK_GET_IFACE (object)->get_version (object);
}

/**
 * portal_flatpak_set_version: (skip)
 * @object: A #PortalFlatpak.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-Flatpak.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
portal_flatpak_set_version (PortalFlatpak *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * portal_flatpak_get_supports: (skip)
 * @object: A #PortalFlatpak.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-Flatpak.supports">"supports"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
portal_flatpak_get_supports (PortalFlatpak *object)
{
  return PORTAL_FLATPAK_GET_IFACE (object)->get_supports (object);
}

/**
 * portal_flatpak_set_supports: (skip)
 * @object: A #PortalFlatpak.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-Flatpak.supports">"supports"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
portal_flatpak_set_supports (PortalFlatpak *object, guint value)
{
  g_object_set (G_OBJECT (object), "supports", value, NULL);
}

/**
 * portal_flatpak_emit_spawn_started:
 * @object: A #PortalFlatpak.
 * @arg_pid: Argument to pass with the signal.
 * @arg_relpid: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-portal-Flatpak.SpawnStarted">"SpawnStarted"</link> D-Bus signal.
 */
void
portal_flatpak_emit_spawn_started (
    PortalFlatpak *object,
    guint arg_pid,
    guint arg_relpid)
{
  g_signal_emit_by_name (object, "spawn-started", arg_pid, arg_relpid);
}

/**
 * portal_flatpak_emit_spawn_exited:
 * @object: A #PortalFlatpak.
 * @arg_pid: Argument to pass with the signal.
 * @arg_exit_status: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-portal-Flatpak.SpawnExited">"SpawnExited"</link> D-Bus signal.
 */
void
portal_flatpak_emit_spawn_exited (
    PortalFlatpak *object,
    guint arg_pid,
    guint arg_exit_status)
{
  g_signal_emit_by_name (object, "spawn-exited", arg_pid, arg_exit_status);
}

/**
 * portal_flatpak_call_spawn:
 * @proxy: A #PortalFlatpakProxy.
 * @arg_cwd_path: Argument to pass with the method invocation.
 * @arg_argv: Argument to pass with the method invocation.
 * @arg_fds: Argument to pass with the method invocation.
 * @arg_envs: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak.Spawn">Spawn()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call portal_flatpak_call_spawn_finish() to get the result of the operation.
 *
 * See portal_flatpak_call_spawn_sync() for the synchronous, blocking version of this method.
 */
void
portal_flatpak_call_spawn (
    PortalFlatpak *proxy,
    const gchar *arg_cwd_path,
    const gchar *const *arg_argv,
    GVariant *arg_fds,
    GVariant *arg_envs,
    guint arg_flags,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "Spawn",
    g_variant_new ("(^ay^aay@a{uh}@a{ss}u@a{sv})",
                   arg_cwd_path,
                   arg_argv,
                   arg_fds,
                   arg_envs,
                   arg_flags,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * portal_flatpak_call_spawn_finish:
 * @proxy: A #PortalFlatpakProxy.
 * @out_pid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to portal_flatpak_call_spawn().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with portal_flatpak_call_spawn().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
portal_flatpak_call_spawn_finish (
    PortalFlatpak *proxy,
    guint *out_pid,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_pid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * portal_flatpak_call_spawn_sync:
 * @proxy: A #PortalFlatpakProxy.
 * @arg_cwd_path: Argument to pass with the method invocation.
 * @arg_argv: Argument to pass with the method invocation.
 * @arg_fds: Argument to pass with the method invocation.
 * @arg_envs: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_pid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak.Spawn">Spawn()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See portal_flatpak_call_spawn() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
portal_flatpak_call_spawn_sync (
    PortalFlatpak *proxy,
    const gchar *arg_cwd_path,
    const gchar *const *arg_argv,
    GVariant *arg_fds,
    GVariant *arg_envs,
    guint arg_flags,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    guint *out_pid,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "Spawn",
    g_variant_new ("(^ay^aay@a{uh}@a{ss}u@a{sv})",
                   arg_cwd_path,
                   arg_argv,
                   arg_fds,
                   arg_envs,
                   arg_flags,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_pid);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * portal_flatpak_call_spawn_signal:
 * @proxy: A #PortalFlatpakProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @arg_signal: Argument to pass with the method invocation.
 * @arg_to_process_group: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak.SpawnSignal">SpawnSignal()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call portal_flatpak_call_spawn_signal_finish() to get the result of the operation.
 *
 * See portal_flatpak_call_spawn_signal_sync() for the synchronous, blocking version of this method.
 */
void
portal_flatpak_call_spawn_signal (
    PortalFlatpak *proxy,
    guint arg_pid,
    guint arg_signal,
    gboolean arg_to_process_group,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SpawnSignal",
    g_variant_new ("(uub)",
                   arg_pid,
                   arg_signal,
                   arg_to_process_group),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * portal_flatpak_call_spawn_signal_finish:
 * @proxy: A #PortalFlatpakProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to portal_flatpak_call_spawn_signal().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with portal_flatpak_call_spawn_signal().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
portal_flatpak_call_spawn_signal_finish (
    PortalFlatpak *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * portal_flatpak_call_spawn_signal_sync:
 * @proxy: A #PortalFlatpakProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @arg_signal: Argument to pass with the method invocation.
 * @arg_to_process_group: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak.SpawnSignal">SpawnSignal()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See portal_flatpak_call_spawn_signal() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
portal_flatpak_call_spawn_signal_sync (
    PortalFlatpak *proxy,
    guint arg_pid,
    guint arg_signal,
    gboolean arg_to_process_group,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SpawnSignal",
    g_variant_new ("(uub)",
                   arg_pid,
                   arg_signal,
                   arg_to_process_group),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * portal_flatpak_call_create_update_monitor:
 * @proxy: A #PortalFlatpakProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak.CreateUpdateMonitor">CreateUpdateMonitor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call portal_flatpak_call_create_update_monitor_finish() to get the result of the operation.
 *
 * See portal_flatpak_call_create_update_monitor_sync() for the synchronous, blocking version of this method.
 */
void
portal_flatpak_call_create_update_monitor (
    PortalFlatpak *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateUpdateMonitor",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * portal_flatpak_call_create_update_monitor_finish:
 * @proxy: A #PortalFlatpakProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to portal_flatpak_call_create_update_monitor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with portal_flatpak_call_create_update_monitor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
portal_flatpak_call_create_update_monitor_finish (
    PortalFlatpak *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * portal_flatpak_call_create_update_monitor_sync:
 * @proxy: A #PortalFlatpakProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak.CreateUpdateMonitor">CreateUpdateMonitor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See portal_flatpak_call_create_update_monitor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
portal_flatpak_call_create_update_monitor_sync (
    PortalFlatpak *proxy,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateUpdateMonitor",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * portal_flatpak_complete_spawn:
 * @object: A #PortalFlatpak.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @pid: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak.Spawn">Spawn()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
portal_flatpak_complete_spawn (
    PortalFlatpak *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    guint pid)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(u)",
                   pid),
    fd_list);
}

/**
 * portal_flatpak_complete_spawn_signal:
 * @object: A #PortalFlatpak.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak.SpawnSignal">SpawnSignal()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
portal_flatpak_complete_spawn_signal (
    PortalFlatpak *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * portal_flatpak_complete_create_update_monitor:
 * @object: A #PortalFlatpak.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak.CreateUpdateMonitor">CreateUpdateMonitor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
portal_flatpak_complete_create_update_monitor (
    PortalFlatpak *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/* ------------------------------------------------------------------------ */

/**
 * PortalFlatpakProxy:
 *
 * The #PortalFlatpakProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PortalFlatpakProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PortalFlatpakProxy.
 */

struct _PortalFlatpakProxyPrivate
{
  GData *qdata;
};

static void portal_flatpak_proxy_iface_init (PortalFlatpakIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PortalFlatpakProxy, portal_flatpak_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PortalFlatpakProxy)
                         G_IMPLEMENT_INTERFACE (PORTAL_TYPE_FLATPAK, portal_flatpak_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PortalFlatpakProxy, portal_flatpak_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PORTAL_TYPE_FLATPAK, portal_flatpak_proxy_iface_init))

#endif
static void
portal_flatpak_proxy_finalize (GObject *object)
{
  PortalFlatpakProxy *proxy = PORTAL_FLATPAK_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (portal_flatpak_proxy_parent_class)->finalize (object);
}

static void
portal_flatpak_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _portal_flatpak_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
portal_flatpak_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.Flatpak: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
portal_flatpak_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _portal_flatpak_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.Flatpak", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) portal_flatpak_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
portal_flatpak_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_portal_flatpak_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PORTAL_TYPE_FLATPAK);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PORTAL_TYPE_FLATPAK);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
portal_flatpak_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PortalFlatpakProxy *proxy = PORTAL_FLATPAK_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_portal_flatpak_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_portal_flatpak_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
portal_flatpak_proxy_get_version (PortalFlatpak *object)
{
  PortalFlatpakProxy *proxy = PORTAL_FLATPAK_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
portal_flatpak_proxy_get_supports (PortalFlatpak *object)
{
  PortalFlatpakProxy *proxy = PORTAL_FLATPAK_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "supports");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
portal_flatpak_proxy_init (PortalFlatpakProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = portal_flatpak_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PORTAL_TYPE_FLATPAK_PROXY, PortalFlatpakProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), portal_flatpak_interface_info ());
}

static void
portal_flatpak_proxy_class_init (PortalFlatpakProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = portal_flatpak_proxy_finalize;
  gobject_class->get_property = portal_flatpak_proxy_get_property;
  gobject_class->set_property = portal_flatpak_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = portal_flatpak_proxy_g_signal;
  proxy_class->g_properties_changed = portal_flatpak_proxy_g_properties_changed;

  portal_flatpak_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PortalFlatpakProxyPrivate));
#endif
}

static void
portal_flatpak_proxy_iface_init (PortalFlatpakIface *iface)
{
  iface->get_version = portal_flatpak_proxy_get_version;
  iface->get_supports = portal_flatpak_proxy_get_supports;
}

/**
 * portal_flatpak_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak.top_of_page">org.freedesktop.portal.Flatpak</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call portal_flatpak_proxy_new_finish() to get the result of the operation.
 *
 * See portal_flatpak_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
portal_flatpak_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PORTAL_TYPE_FLATPAK_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Flatpak", NULL);
}

/**
 * portal_flatpak_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to portal_flatpak_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with portal_flatpak_proxy_new().
 *
 * Returns: (transfer full) (type PortalFlatpakProxy): The constructed proxy object or %NULL if @error is set.
 */
PortalFlatpak *
portal_flatpak_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PORTAL_FLATPAK (ret);
  else
    return NULL;
}

/**
 * portal_flatpak_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak.top_of_page">org.freedesktop.portal.Flatpak</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See portal_flatpak_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PortalFlatpakProxy): The constructed proxy object or %NULL if @error is set.
 */
PortalFlatpak *
portal_flatpak_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PORTAL_TYPE_FLATPAK_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Flatpak", NULL);
  if (ret != NULL)
    return PORTAL_FLATPAK (ret);
  else
    return NULL;
}


/**
 * portal_flatpak_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like portal_flatpak_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call portal_flatpak_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See portal_flatpak_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
portal_flatpak_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PORTAL_TYPE_FLATPAK_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Flatpak", NULL);
}

/**
 * portal_flatpak_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to portal_flatpak_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with portal_flatpak_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PortalFlatpakProxy): The constructed proxy object or %NULL if @error is set.
 */
PortalFlatpak *
portal_flatpak_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PORTAL_FLATPAK (ret);
  else
    return NULL;
}

/**
 * portal_flatpak_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like portal_flatpak_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See portal_flatpak_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PortalFlatpakProxy): The constructed proxy object or %NULL if @error is set.
 */
PortalFlatpak *
portal_flatpak_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PORTAL_TYPE_FLATPAK_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Flatpak", NULL);
  if (ret != NULL)
    return PORTAL_FLATPAK (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PortalFlatpakSkeleton:
 *
 * The #PortalFlatpakSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PortalFlatpakSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PortalFlatpakSkeleton.
 */

struct _PortalFlatpakSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_portal_flatpak_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PORTAL_TYPE_FLATPAK);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PORTAL_TYPE_FLATPAK);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_portal_flatpak_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_portal_flatpak_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_portal_flatpak_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_portal_flatpak_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _portal_flatpak_skeleton_vtable =
{
  _portal_flatpak_skeleton_handle_method_call,
  _portal_flatpak_skeleton_handle_get_property,
  _portal_flatpak_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
portal_flatpak_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return portal_flatpak_interface_info ();
}

static GDBusInterfaceVTable *
portal_flatpak_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_portal_flatpak_skeleton_vtable;
}

static GVariant *
portal_flatpak_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_portal_flatpak_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _portal_flatpak_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _portal_flatpak_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _portal_flatpak_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Flatpak", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _portal_flatpak_emit_changed (gpointer user_data);

static void
portal_flatpak_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _portal_flatpak_emit_changed (skeleton);
}

static void
_portal_flatpak_on_signal_spawn_started (
    PortalFlatpak *object,
    guint arg_pid,
    guint arg_relpid)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uu)",
                   arg_pid,
                   arg_relpid));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Flatpak", "SpawnStarted",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_portal_flatpak_on_signal_spawn_exited (
    PortalFlatpak *object,
    guint arg_pid,
    guint arg_exit_status)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uu)",
                   arg_pid,
                   arg_exit_status));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Flatpak", "SpawnExited",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void portal_flatpak_skeleton_iface_init (PortalFlatpakIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PortalFlatpakSkeleton, portal_flatpak_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PortalFlatpakSkeleton)
                         G_IMPLEMENT_INTERFACE (PORTAL_TYPE_FLATPAK, portal_flatpak_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PortalFlatpakSkeleton, portal_flatpak_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PORTAL_TYPE_FLATPAK, portal_flatpak_skeleton_iface_init))

#endif
static void
portal_flatpak_skeleton_finalize (GObject *object)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (portal_flatpak_skeleton_parent_class)->finalize (object);
}

static void
portal_flatpak_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_portal_flatpak_emit_changed (gpointer user_data)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.Flatpak",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_portal_flatpak_schedule_emit_changed (PortalFlatpakSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
portal_flatpak_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _portal_flatpak_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _portal_flatpak_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
portal_flatpak_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _portal_flatpak_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _portal_flatpak_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
portal_flatpak_skeleton_init (PortalFlatpakSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = portal_flatpak_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PORTAL_TYPE_FLATPAK_SKELETON, PortalFlatpakSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
}

static guint 
portal_flatpak_skeleton_get_version (PortalFlatpak *object)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
portal_flatpak_skeleton_get_supports (PortalFlatpak *object)
{
  PortalFlatpakSkeleton *skeleton = PORTAL_FLATPAK_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
portal_flatpak_skeleton_class_init (PortalFlatpakSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = portal_flatpak_skeleton_finalize;
  gobject_class->get_property = portal_flatpak_skeleton_get_property;
  gobject_class->set_property = portal_flatpak_skeleton_set_property;
  gobject_class->notify       = portal_flatpak_skeleton_notify;


  portal_flatpak_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = portal_flatpak_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = portal_flatpak_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = portal_flatpak_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = portal_flatpak_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PortalFlatpakSkeletonPrivate));
#endif
}

static void
portal_flatpak_skeleton_iface_init (PortalFlatpakIface *iface)
{
  iface->spawn_started = _portal_flatpak_on_signal_spawn_started;
  iface->spawn_exited = _portal_flatpak_on_signal_spawn_exited;
  iface->get_version = portal_flatpak_skeleton_get_version;
  iface->get_supports = portal_flatpak_skeleton_get_supports;
}

/**
 * portal_flatpak_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak.top_of_page">org.freedesktop.portal.Flatpak</link>.
 *
 * Returns: (transfer full) (type PortalFlatpakSkeleton): The skeleton object.
 */
PortalFlatpak *
portal_flatpak_skeleton_new (void)
{
  return PORTAL_FLATPAK (g_object_new (PORTAL_TYPE_FLATPAK_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.Flatpak.UpdateMonitor
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PortalFlatpakUpdateMonitor
 * @title: PortalFlatpakUpdateMonitor
 * @short_description: Generated C code for the org.freedesktop.portal.Flatpak.UpdateMonitor D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak-UpdateMonitor.top_of_page">org.freedesktop.portal.Flatpak.UpdateMonitor</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.Flatpak.UpdateMonitor ---- */

static const _ExtendedGDBusMethodInfo _portal_flatpak_update_monitor_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_update_monitor_method_info_update_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _portal_flatpak_update_monitor_method_info_update_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _portal_flatpak_update_monitor_method_info_update_IN_ARG_pointers[] =
{
  &_portal_flatpak_update_monitor_method_info_update_IN_ARG_parent_window.parent_struct,
  &_portal_flatpak_update_monitor_method_info_update_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _portal_flatpak_update_monitor_method_info_update =
{
  {
    -1,
    (gchar *) "Update",
    (GDBusArgInfo **) &_portal_flatpak_update_monitor_method_info_update_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-update",
  FALSE
};

static const GDBusMethodInfo * const _portal_flatpak_update_monitor_method_info_pointers[] =
{
  &_portal_flatpak_update_monitor_method_info_close.parent_struct,
  &_portal_flatpak_update_monitor_method_info_update.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _portal_flatpak_update_monitor_signal_info_update_available_ARG_update_info =
{
  {
    -1,
    (gchar *) "update_info",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _portal_flatpak_update_monitor_signal_info_update_available_ARG_pointers[] =
{
  &_portal_flatpak_update_monitor_signal_info_update_available_ARG_update_info.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _portal_flatpak_update_monitor_signal_info_update_available =
{
  {
    -1,
    (gchar *) "UpdateAvailable",
    (GDBusArgInfo **) &_portal_flatpak_update_monitor_signal_info_update_available_ARG_pointers,
    NULL
  },
  "update-available"
};

static const _ExtendedGDBusArgInfo _portal_flatpak_update_monitor_signal_info_progress_ARG_info =
{
  {
    -1,
    (gchar *) "info",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _portal_flatpak_update_monitor_signal_info_progress_ARG_pointers[] =
{
  &_portal_flatpak_update_monitor_signal_info_progress_ARG_info.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _portal_flatpak_update_monitor_signal_info_progress =
{
  {
    -1,
    (gchar *) "Progress",
    (GDBusArgInfo **) &_portal_flatpak_update_monitor_signal_info_progress_ARG_pointers,
    NULL
  },
  "progress"
};

static const GDBusSignalInfo * const _portal_flatpak_update_monitor_signal_info_pointers[] =
{
  &_portal_flatpak_update_monitor_signal_info_update_available.parent_struct,
  &_portal_flatpak_update_monitor_signal_info_progress.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _portal_flatpak_update_monitor_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.Flatpak.UpdateMonitor",
    (GDBusMethodInfo **) &_portal_flatpak_update_monitor_method_info_pointers,
    (GDBusSignalInfo **) &_portal_flatpak_update_monitor_signal_info_pointers,
    NULL,
    NULL
  },
  "flatpak-update-monitor",
};


/**
 * portal_flatpak_update_monitor_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak-UpdateMonitor.top_of_page">org.freedesktop.portal.Flatpak.UpdateMonitor</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
portal_flatpak_update_monitor_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_portal_flatpak_update_monitor_interface_info.parent_struct;
}

/**
 * portal_flatpak_update_monitor_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PortalFlatpakUpdateMonitor interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
portal_flatpak_update_monitor_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * PortalFlatpakUpdateMonitor:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak-UpdateMonitor.top_of_page">org.freedesktop.portal.Flatpak.UpdateMonitor</link>.
 */

/**
 * PortalFlatpakUpdateMonitorIface:
 * @parent_iface: The parent interface.
 * @handle_close: Handler for the #PortalFlatpakUpdateMonitor::handle-close signal.
 * @handle_update: Handler for the #PortalFlatpakUpdateMonitor::handle-update signal.
 * @progress: Handler for the #PortalFlatpakUpdateMonitor::progress signal.
 * @update_available: Handler for the #PortalFlatpakUpdateMonitor::update-available signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak-UpdateMonitor.top_of_page">org.freedesktop.portal.Flatpak.UpdateMonitor</link>.
 */

typedef PortalFlatpakUpdateMonitorIface PortalFlatpakUpdateMonitorInterface;
G_DEFINE_INTERFACE (PortalFlatpakUpdateMonitor, portal_flatpak_update_monitor, G_TYPE_OBJECT)

static void
portal_flatpak_update_monitor_default_init (PortalFlatpakUpdateMonitorIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PortalFlatpakUpdateMonitor::handle-close:
   * @object: A #PortalFlatpakUpdateMonitor.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak-UpdateMonitor.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call portal_flatpak_update_monitor_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PortalFlatpakUpdateMonitorIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * PortalFlatpakUpdateMonitor::handle-update:
   * @object: A #PortalFlatpakUpdateMonitor.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak-UpdateMonitor.Update">Update()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call portal_flatpak_update_monitor_complete_update() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PortalFlatpakUpdateMonitorIface, handle_update),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * PortalFlatpakUpdateMonitor::update-available:
   * @object: A #PortalFlatpakUpdateMonitor.
   * @arg_update_info: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-portal-Flatpak-UpdateMonitor.UpdateAvailable">"UpdateAvailable"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("update-available",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PortalFlatpakUpdateMonitorIface, update_available),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

  /**
   * PortalFlatpakUpdateMonitor::progress:
   * @object: A #PortalFlatpakUpdateMonitor.
   * @arg_info: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-portal-Flatpak-UpdateMonitor.Progress">"Progress"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("progress",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PortalFlatpakUpdateMonitorIface, progress),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_VARIANT);

}

/**
 * portal_flatpak_update_monitor_emit_update_available:
 * @object: A #PortalFlatpakUpdateMonitor.
 * @arg_update_info: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-portal-Flatpak-UpdateMonitor.UpdateAvailable">"UpdateAvailable"</link> D-Bus signal.
 */
void
portal_flatpak_update_monitor_emit_update_available (
    PortalFlatpakUpdateMonitor *object,
    GVariant *arg_update_info)
{
  g_signal_emit_by_name (object, "update-available", arg_update_info);
}

/**
 * portal_flatpak_update_monitor_emit_progress:
 * @object: A #PortalFlatpakUpdateMonitor.
 * @arg_info: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-portal-Flatpak-UpdateMonitor.Progress">"Progress"</link> D-Bus signal.
 */
void
portal_flatpak_update_monitor_emit_progress (
    PortalFlatpakUpdateMonitor *object,
    GVariant *arg_info)
{
  g_signal_emit_by_name (object, "progress", arg_info);
}

/**
 * portal_flatpak_update_monitor_call_close:
 * @proxy: A #PortalFlatpakUpdateMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak-UpdateMonitor.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call portal_flatpak_update_monitor_call_close_finish() to get the result of the operation.
 *
 * See portal_flatpak_update_monitor_call_close_sync() for the synchronous, blocking version of this method.
 */
void
portal_flatpak_update_monitor_call_close (
    PortalFlatpakUpdateMonitor *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * portal_flatpak_update_monitor_call_close_finish:
 * @proxy: A #PortalFlatpakUpdateMonitorProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to portal_flatpak_update_monitor_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with portal_flatpak_update_monitor_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
portal_flatpak_update_monitor_call_close_finish (
    PortalFlatpakUpdateMonitor *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * portal_flatpak_update_monitor_call_close_sync:
 * @proxy: A #PortalFlatpakUpdateMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak-UpdateMonitor.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See portal_flatpak_update_monitor_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
portal_flatpak_update_monitor_call_close_sync (
    PortalFlatpakUpdateMonitor *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * portal_flatpak_update_monitor_call_update:
 * @proxy: A #PortalFlatpakUpdateMonitorProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak-UpdateMonitor.Update">Update()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call portal_flatpak_update_monitor_call_update_finish() to get the result of the operation.
 *
 * See portal_flatpak_update_monitor_call_update_sync() for the synchronous, blocking version of this method.
 */
void
portal_flatpak_update_monitor_call_update (
    PortalFlatpakUpdateMonitor *proxy,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Update",
    g_variant_new ("(s@a{sv})",
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * portal_flatpak_update_monitor_call_update_finish:
 * @proxy: A #PortalFlatpakUpdateMonitorProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to portal_flatpak_update_monitor_call_update().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with portal_flatpak_update_monitor_call_update().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
portal_flatpak_update_monitor_call_update_finish (
    PortalFlatpakUpdateMonitor *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * portal_flatpak_update_monitor_call_update_sync:
 * @proxy: A #PortalFlatpakUpdateMonitorProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak-UpdateMonitor.Update">Update()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See portal_flatpak_update_monitor_call_update() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
portal_flatpak_update_monitor_call_update_sync (
    PortalFlatpakUpdateMonitor *proxy,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Update",
    g_variant_new ("(s@a{sv})",
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * portal_flatpak_update_monitor_complete_close:
 * @object: A #PortalFlatpakUpdateMonitor.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak-UpdateMonitor.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
portal_flatpak_update_monitor_complete_close (
    PortalFlatpakUpdateMonitor *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * portal_flatpak_update_monitor_complete_update:
 * @object: A #PortalFlatpakUpdateMonitor.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Flatpak-UpdateMonitor.Update">Update()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
portal_flatpak_update_monitor_complete_update (
    PortalFlatpakUpdateMonitor *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * PortalFlatpakUpdateMonitorProxy:
 *
 * The #PortalFlatpakUpdateMonitorProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PortalFlatpakUpdateMonitorProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PortalFlatpakUpdateMonitorProxy.
 */

struct _PortalFlatpakUpdateMonitorProxyPrivate
{
  GData *qdata;
};

static void portal_flatpak_update_monitor_proxy_iface_init (PortalFlatpakUpdateMonitorIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PortalFlatpakUpdateMonitorProxy, portal_flatpak_update_monitor_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PortalFlatpakUpdateMonitorProxy)
                         G_IMPLEMENT_INTERFACE (PORTAL_TYPE_FLATPAK_UPDATE_MONITOR, portal_flatpak_update_monitor_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PortalFlatpakUpdateMonitorProxy, portal_flatpak_update_monitor_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PORTAL_TYPE_FLATPAK_UPDATE_MONITOR, portal_flatpak_update_monitor_proxy_iface_init))

#endif
static void
portal_flatpak_update_monitor_proxy_finalize (GObject *object)
{
  PortalFlatpakUpdateMonitorProxy *proxy = PORTAL_FLATPAK_UPDATE_MONITOR_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (portal_flatpak_update_monitor_proxy_parent_class)->finalize (object);
}

static void
portal_flatpak_update_monitor_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
portal_flatpak_update_monitor_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
portal_flatpak_update_monitor_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_portal_flatpak_update_monitor_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PORTAL_TYPE_FLATPAK_UPDATE_MONITOR);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PORTAL_TYPE_FLATPAK_UPDATE_MONITOR);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
portal_flatpak_update_monitor_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PortalFlatpakUpdateMonitorProxy *proxy = PORTAL_FLATPAK_UPDATE_MONITOR_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_portal_flatpak_update_monitor_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_portal_flatpak_update_monitor_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
portal_flatpak_update_monitor_proxy_init (PortalFlatpakUpdateMonitorProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = portal_flatpak_update_monitor_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PORTAL_TYPE_FLATPAK_UPDATE_MONITOR_PROXY, PortalFlatpakUpdateMonitorProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), portal_flatpak_update_monitor_interface_info ());
}

static void
portal_flatpak_update_monitor_proxy_class_init (PortalFlatpakUpdateMonitorProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = portal_flatpak_update_monitor_proxy_finalize;
  gobject_class->get_property = portal_flatpak_update_monitor_proxy_get_property;
  gobject_class->set_property = portal_flatpak_update_monitor_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = portal_flatpak_update_monitor_proxy_g_signal;
  proxy_class->g_properties_changed = portal_flatpak_update_monitor_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PortalFlatpakUpdateMonitorProxyPrivate));
#endif
}

static void
portal_flatpak_update_monitor_proxy_iface_init (PortalFlatpakUpdateMonitorIface *iface G_GNUC_UNUSED)
{
}

/**
 * portal_flatpak_update_monitor_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak-UpdateMonitor.top_of_page">org.freedesktop.portal.Flatpak.UpdateMonitor</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call portal_flatpak_update_monitor_proxy_new_finish() to get the result of the operation.
 *
 * See portal_flatpak_update_monitor_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
portal_flatpak_update_monitor_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PORTAL_TYPE_FLATPAK_UPDATE_MONITOR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Flatpak.UpdateMonitor", NULL);
}

/**
 * portal_flatpak_update_monitor_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to portal_flatpak_update_monitor_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with portal_flatpak_update_monitor_proxy_new().
 *
 * Returns: (transfer full) (type PortalFlatpakUpdateMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
PortalFlatpakUpdateMonitor *
portal_flatpak_update_monitor_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PORTAL_FLATPAK_UPDATE_MONITOR (ret);
  else
    return NULL;
}

/**
 * portal_flatpak_update_monitor_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak-UpdateMonitor.top_of_page">org.freedesktop.portal.Flatpak.UpdateMonitor</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See portal_flatpak_update_monitor_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PortalFlatpakUpdateMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
PortalFlatpakUpdateMonitor *
portal_flatpak_update_monitor_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PORTAL_TYPE_FLATPAK_UPDATE_MONITOR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Flatpak.UpdateMonitor", NULL);
  if (ret != NULL)
    return PORTAL_FLATPAK_UPDATE_MONITOR (ret);
  else
    return NULL;
}


/**
 * portal_flatpak_update_monitor_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like portal_flatpak_update_monitor_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call portal_flatpak_update_monitor_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See portal_flatpak_update_monitor_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
portal_flatpak_update_monitor_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PORTAL_TYPE_FLATPAK_UPDATE_MONITOR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Flatpak.UpdateMonitor", NULL);
}

/**
 * portal_flatpak_update_monitor_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to portal_flatpak_update_monitor_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with portal_flatpak_update_monitor_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PortalFlatpakUpdateMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
PortalFlatpakUpdateMonitor *
portal_flatpak_update_monitor_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PORTAL_FLATPAK_UPDATE_MONITOR (ret);
  else
    return NULL;
}

/**
 * portal_flatpak_update_monitor_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like portal_flatpak_update_monitor_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See portal_flatpak_update_monitor_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PortalFlatpakUpdateMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
PortalFlatpakUpdateMonitor *
portal_flatpak_update_monitor_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PORTAL_TYPE_FLATPAK_UPDATE_MONITOR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Flatpak.UpdateMonitor", NULL);
  if (ret != NULL)
    return PORTAL_FLATPAK_UPDATE_MONITOR (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PortalFlatpakUpdateMonitorSkeleton:
 *
 * The #PortalFlatpakUpdateMonitorSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PortalFlatpakUpdateMonitorSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PortalFlatpakUpdateMonitorSkeleton.
 */

struct _PortalFlatpakUpdateMonitorSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_portal_flatpak_update_monitor_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PortalFlatpakUpdateMonitorSkeleton *skeleton = PORTAL_FLATPAK_UPDATE_MONITOR_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PORTAL_TYPE_FLATPAK_UPDATE_MONITOR);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PORTAL_TYPE_FLATPAK_UPDATE_MONITOR);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_portal_flatpak_update_monitor_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PortalFlatpakUpdateMonitorSkeleton *skeleton = PORTAL_FLATPAK_UPDATE_MONITOR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_portal_flatpak_update_monitor_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_portal_flatpak_update_monitor_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PortalFlatpakUpdateMonitorSkeleton *skeleton = PORTAL_FLATPAK_UPDATE_MONITOR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_portal_flatpak_update_monitor_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _portal_flatpak_update_monitor_skeleton_vtable =
{
  _portal_flatpak_update_monitor_skeleton_handle_method_call,
  _portal_flatpak_update_monitor_skeleton_handle_get_property,
  _portal_flatpak_update_monitor_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
portal_flatpak_update_monitor_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return portal_flatpak_update_monitor_interface_info ();
}

static GDBusInterfaceVTable *
portal_flatpak_update_monitor_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_portal_flatpak_update_monitor_skeleton_vtable;
}

static GVariant *
portal_flatpak_update_monitor_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PortalFlatpakUpdateMonitorSkeleton *skeleton = PORTAL_FLATPAK_UPDATE_MONITOR_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_portal_flatpak_update_monitor_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _portal_flatpak_update_monitor_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _portal_flatpak_update_monitor_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _portal_flatpak_update_monitor_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Flatpak.UpdateMonitor", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
portal_flatpak_update_monitor_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_portal_flatpak_update_monitor_on_signal_update_available (
    PortalFlatpakUpdateMonitor *object,
    GVariant *arg_update_info)
{
  PortalFlatpakUpdateMonitorSkeleton *skeleton = PORTAL_FLATPAK_UPDATE_MONITOR_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a{sv})",
                   arg_update_info));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Flatpak.UpdateMonitor", "UpdateAvailable",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_portal_flatpak_update_monitor_on_signal_progress (
    PortalFlatpakUpdateMonitor *object,
    GVariant *arg_info)
{
  PortalFlatpakUpdateMonitorSkeleton *skeleton = PORTAL_FLATPAK_UPDATE_MONITOR_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a{sv})",
                   arg_info));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Flatpak.UpdateMonitor", "Progress",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void portal_flatpak_update_monitor_skeleton_iface_init (PortalFlatpakUpdateMonitorIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PortalFlatpakUpdateMonitorSkeleton, portal_flatpak_update_monitor_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PortalFlatpakUpdateMonitorSkeleton)
                         G_IMPLEMENT_INTERFACE (PORTAL_TYPE_FLATPAK_UPDATE_MONITOR, portal_flatpak_update_monitor_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PortalFlatpakUpdateMonitorSkeleton, portal_flatpak_update_monitor_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PORTAL_TYPE_FLATPAK_UPDATE_MONITOR, portal_flatpak_update_monitor_skeleton_iface_init))

#endif
static void
portal_flatpak_update_monitor_skeleton_finalize (GObject *object)
{
  PortalFlatpakUpdateMonitorSkeleton *skeleton = PORTAL_FLATPAK_UPDATE_MONITOR_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (portal_flatpak_update_monitor_skeleton_parent_class)->finalize (object);
}

static void
portal_flatpak_update_monitor_skeleton_init (PortalFlatpakUpdateMonitorSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = portal_flatpak_update_monitor_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PORTAL_TYPE_FLATPAK_UPDATE_MONITOR_SKELETON, PortalFlatpakUpdateMonitorSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
portal_flatpak_update_monitor_skeleton_class_init (PortalFlatpakUpdateMonitorSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = portal_flatpak_update_monitor_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = portal_flatpak_update_monitor_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = portal_flatpak_update_monitor_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = portal_flatpak_update_monitor_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = portal_flatpak_update_monitor_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PortalFlatpakUpdateMonitorSkeletonPrivate));
#endif
}

static void
portal_flatpak_update_monitor_skeleton_iface_init (PortalFlatpakUpdateMonitorIface *iface)
{
  iface->update_available = _portal_flatpak_update_monitor_on_signal_update_available;
  iface->progress = _portal_flatpak_update_monitor_on_signal_progress;
}

/**
 * portal_flatpak_update_monitor_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Flatpak-UpdateMonitor.top_of_page">org.freedesktop.portal.Flatpak.UpdateMonitor</link>.
 *
 * Returns: (transfer full) (type PortalFlatpakUpdateMonitorSkeleton): The skeleton object.
 */
PortalFlatpakUpdateMonitor *
portal_flatpak_update_monitor_skeleton_new (void)
{
  return PORTAL_FLATPAK_UPDATE_MONITOR (g_object_new (PORTAL_TYPE_FLATPAK_UPDATE_MONITOR_SKELETON, NULL));
}

