/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.deps.behavior;

import net.adaptivebox.deps.behavior.AbsGTBehavior;
import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;
import net.adaptivebox.space.BasicPoint;
import net.adaptivebox.space.DesignSpace;

public class PSGTBehavior
extends AbsGTBehavior {
    public double c1 = 2.0;
    public double c2 = 2.0;
    public double weight = 0.4;
    public double CL = 0.0;
    private BasicPoint pold_t;
    private BasicPoint pcurrent_t;

    @Override
    public void setMemPoints(SearchPoint pbest, BasicPoint pcurrent, BasicPoint pold) {
        this.pcurrent_t = pcurrent;
        this.pbest_t = pbest;
        this.pold_t = pold;
    }

    @Override
    public void generateBehavior(SearchPoint trailPoint, ProblemEncoder problemEncoder) {
        DesignSpace designSpace = problemEncoder.getDesignSpace();
        double[] pold_t_location = this.pold_t.getLocation();
        double[] pbest_t_location = this.pbest_t.getLocation();
        double[] pcurrent_t_location = this.pcurrent_t.getLocation();
        double[] gbest_t_location = this.socialLib.getGbest().getLocation();
        double[] trailPointLocation = trailPoint.getLocation();
        int DIMENSION = designSpace.getDimension();
        for (int b = 0; b < DIMENSION; ++b) {
            double deltaxbm;
            if (RandomGenerator.doubleZeroOneRandom() < this.CL) {
                designSpace.mutationAt(trailPointLocation, b);
                continue;
            }
            double deltaxb = this.weight * (pcurrent_t_location[b] - pold_t_location[b]) + this.c1 * RandomGenerator.doubleZeroOneRandom() * (pbest_t_location[b] - pcurrent_t_location[b]) + this.c2 * RandomGenerator.doubleZeroOneRandom() * (gbest_t_location[b] - pcurrent_t_location[b]);
            if (deltaxb < -(deltaxbm = 0.5 * designSpace.getMagnitudeIn(b))) {
                deltaxb = -deltaxbm;
            } else if (deltaxb > deltaxbm) {
                deltaxb = deltaxbm;
            }
            trailPointLocation[b] = pcurrent_t_location[b] + deltaxb;
        }
    }

    @Override
    public void testBehavior(SearchPoint trailPoint, IGoodnessCompareEngine qualityComparator) {
        Library.replace(qualityComparator, trailPoint, this.pbest_t);
        this.pold_t.importLocation(this.pcurrent_t);
        this.pcurrent_t.importLocation(trailPoint);
    }
}

