/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.6.2
 *
 * Copyright (c) 2022 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 30 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qquaternion.sip"
#include <qquaternion.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQQuaternion.cpp"

#line 30 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qvector3d.sip"
#include <qvector3d.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQQuaternion.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qvector4d.sip"
#include <qvector4d.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQQuaternion.cpp"
#line 483 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qgenericmatrix.sip"
#include <qgenericmatrix.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQQuaternion.cpp"


PyDoc_STRVAR(doc_QQuaternion_length, "length(self) -> float");

extern "C" {static PyObject *meth_QQuaternion_length(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_length(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->length();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_length, doc_QQuaternion_length);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_lengthSquared, "lengthSquared(self) -> float");

extern "C" {static PyObject *meth_QQuaternion_lengthSquared(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_lengthSquared(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->lengthSquared();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_lengthSquared, doc_QQuaternion_lengthSquared);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_normalized, "normalized(self) -> QQuaternion");

extern "C" {static PyObject *meth_QQuaternion_normalized(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_normalized(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion(sipCpp->normalized());

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_normalized, doc_QQuaternion_normalized);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_normalize, "normalize(self)");

extern "C" {static PyObject *meth_QQuaternion_normalize(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_normalize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            sipCpp->normalize();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_normalize, doc_QQuaternion_normalize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_rotatedVector, "rotatedVector(self, QVector3D) -> QVector3D");

extern "C" {static PyObject *meth_QQuaternion_rotatedVector(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_rotatedVector(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector3D* a0;
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QQuaternion, &sipCpp, sipType_QVector3D, &a0))
        {
             ::QVector3D*sipRes;

            sipRes = new  ::QVector3D(sipCpp->rotatedVector(*a0));

            return sipConvertFromNewType(sipRes,sipType_QVector3D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_rotatedVector, doc_QQuaternion_rotatedVector);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_fromAxisAndAngle, "fromAxisAndAngle(QVector3D, float) -> QQuaternion\n"
"fromAxisAndAngle(float, float, float, float) -> QQuaternion");

extern "C" {static PyObject *meth_QQuaternion_fromAxisAndAngle(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_fromAxisAndAngle(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector3D* a0;
        float a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9f", sipType_QVector3D, &a0, &a1))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion( ::QQuaternion::fromAxisAndAngle(*a0,a1));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    {
        float a0;
        float a1;
        float a2;
        float a3;

        if (sipParseArgs(&sipParseErr, sipArgs, "ffff", &a0, &a1, &a2, &a3))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion( ::QQuaternion::fromAxisAndAngle(a0,a1,a2,a3));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_fromAxisAndAngle, doc_QQuaternion_fromAxisAndAngle);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_slerp, "slerp(QQuaternion, QQuaternion, float) -> QQuaternion");

extern "C" {static PyObject *meth_QQuaternion_slerp(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_slerp(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion* a0;
        const  ::QQuaternion* a1;
        float a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9f", sipType_QQuaternion, &a0, sipType_QQuaternion, &a1, &a2))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion( ::QQuaternion::slerp(*a0,*a1,a2));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_slerp, doc_QQuaternion_slerp);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_nlerp, "nlerp(QQuaternion, QQuaternion, float) -> QQuaternion");

extern "C" {static PyObject *meth_QQuaternion_nlerp(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_nlerp(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion* a0;
        const  ::QQuaternion* a1;
        float a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9f", sipType_QQuaternion, &a0, sipType_QQuaternion, &a1, &a2))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion( ::QQuaternion::nlerp(*a0,*a1,a2));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_nlerp, doc_QQuaternion_nlerp);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QQuaternion_isNull(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_isNull, doc_QQuaternion_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_isIdentity, "isIdentity(self) -> bool");

extern "C" {static PyObject *meth_QQuaternion_isIdentity(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_isIdentity(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isIdentity();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_isIdentity, doc_QQuaternion_isIdentity);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_x, "x(self) -> float");

extern "C" {static PyObject *meth_QQuaternion_x(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_x(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->x();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_x, doc_QQuaternion_x);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_y, "y(self) -> float");

extern "C" {static PyObject *meth_QQuaternion_y(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_y(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->y();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_y, doc_QQuaternion_y);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_z, "z(self) -> float");

extern "C" {static PyObject *meth_QQuaternion_z(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_z(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->z();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_z, doc_QQuaternion_z);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_scalar, "scalar(self) -> float");

extern "C" {static PyObject *meth_QQuaternion_scalar(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_scalar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->scalar();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_scalar, doc_QQuaternion_scalar);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_setX, "setX(self, float)");

extern "C" {static PyObject *meth_QQuaternion_setX(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_setX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
         ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QQuaternion, &sipCpp, &a0))
        {
            sipCpp->setX(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_setX, doc_QQuaternion_setX);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_setY, "setY(self, float)");

extern "C" {static PyObject *meth_QQuaternion_setY(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_setY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
         ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QQuaternion, &sipCpp, &a0))
        {
            sipCpp->setY(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_setY, doc_QQuaternion_setY);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_setZ, "setZ(self, float)");

extern "C" {static PyObject *meth_QQuaternion_setZ(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_setZ(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
         ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QQuaternion, &sipCpp, &a0))
        {
            sipCpp->setZ(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_setZ, doc_QQuaternion_setZ);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_setScalar, "setScalar(self, float)");

extern "C" {static PyObject *meth_QQuaternion_setScalar(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_setScalar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
         ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QQuaternion, &sipCpp, &a0))
        {
            sipCpp->setScalar(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_setScalar, doc_QQuaternion_setScalar);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_conjugate, "conjugate(self) -> QQuaternion");

extern "C" {static PyObject *meth_QQuaternion_conjugate(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_conjugate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion(sipCpp->conjugate());

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_conjugate, doc_QQuaternion_conjugate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_setVector, "setVector(self, QVector3D)\n"
"setVector(self, float, float, float)");

extern "C" {static PyObject *meth_QQuaternion_setVector(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_setVector(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector3D* a0;
         ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QQuaternion, &sipCpp, sipType_QVector3D, &a0))
        {
            sipCpp->setVector(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        float a0;
        float a1;
        float a2;
         ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bfff", &sipSelf, sipType_QQuaternion, &sipCpp, &a0, &a1, &a2))
        {
            sipCpp->setVector(a0,a1,a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_setVector, doc_QQuaternion_setVector);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_vector, "vector(self) -> QVector3D");

extern "C" {static PyObject *meth_QQuaternion_vector(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_vector(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
             ::QVector3D*sipRes;

            sipRes = new  ::QVector3D(sipCpp->vector());

            return sipConvertFromNewType(sipRes,sipType_QVector3D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_vector, doc_QQuaternion_vector);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_toVector4D, "toVector4D(self) -> QVector4D");

extern "C" {static PyObject *meth_QQuaternion_toVector4D(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_toVector4D(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
             ::QVector4D*sipRes;

            sipRes = new  ::QVector4D(sipCpp->toVector4D());

            return sipConvertFromNewType(sipRes,sipType_QVector4D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_toVector4D, doc_QQuaternion_toVector4D);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_getAxisAndAngle, "getAxisAndAngle(self) -> Tuple[QVector3D, float]");

extern "C" {static PyObject *meth_QQuaternion_getAxisAndAngle(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_getAxisAndAngle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QVector3D* a0;
        float a1;
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            a0 = new  ::QVector3D();

            sipCpp->getAxisAndAngle(a0,&a1);

            return sipBuildResult(0,"(Nf)",a0,sipType_QVector3D,SIP_NULLPTR,a1);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_getAxisAndAngle, doc_QQuaternion_getAxisAndAngle);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_getEulerAngles, "getEulerAngles(self) -> Tuple[float, float, float]");

extern "C" {static PyObject *meth_QQuaternion_getEulerAngles(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_getEulerAngles(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        float a1;
        float a2;
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            sipCpp->getEulerAngles(&a0,&a1,&a2);

            return sipBuildResult(0,"(fff)",a0,a1,a2);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_getEulerAngles, doc_QQuaternion_getEulerAngles);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_fromEulerAngles, "fromEulerAngles(float, float, float) -> QQuaternion\n"
"fromEulerAngles(QVector3D) -> QQuaternion");

extern "C" {static PyObject *meth_QQuaternion_fromEulerAngles(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_fromEulerAngles(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        float a1;
        float a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "fff", &a0, &a1, &a2))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion( ::QQuaternion::fromEulerAngles(a0,a1,a2));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    {
        const  ::QVector3D* a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9", sipType_QVector3D, &a0))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion( ::QQuaternion::fromEulerAngles(*a0));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_fromEulerAngles, doc_QQuaternion_fromEulerAngles);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_toRotationMatrix, "toRotationMatrix(self) -> QMatrix3x3");

extern "C" {static PyObject *meth_QQuaternion_toRotationMatrix(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_toRotationMatrix(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
             ::QMatrix3x3*sipRes;

            sipRes = new  ::QMatrix3x3(sipCpp->toRotationMatrix());

            return sipConvertFromNewType(sipRes,sipType_QMatrix3x3,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_toRotationMatrix, doc_QQuaternion_toRotationMatrix);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_fromRotationMatrix, "fromRotationMatrix(QMatrix3x3) -> QQuaternion");

extern "C" {static PyObject *meth_QQuaternion_fromRotationMatrix(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_fromRotationMatrix(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QMatrix3x3* a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9", sipType_QMatrix3x3, &a0))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion( ::QQuaternion::fromRotationMatrix(*a0));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_fromRotationMatrix, doc_QQuaternion_fromRotationMatrix);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_getAxes, "getAxes(self) -> Tuple[QVector3D, QVector3D, QVector3D]");

extern "C" {static PyObject *meth_QQuaternion_getAxes(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_getAxes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::QVector3D* a0;
         ::QVector3D* a1;
         ::QVector3D* a2;
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
            a0 = new  ::QVector3D();
            a1 = new  ::QVector3D();
            a2 = new  ::QVector3D();

            sipCpp->getAxes(a0,a1,a2);

            return sipBuildResult(0,"(NNN)",a0,sipType_QVector3D,SIP_NULLPTR,a1,sipType_QVector3D,SIP_NULLPTR,a2,sipType_QVector3D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_getAxes, doc_QQuaternion_getAxes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_fromAxes, "fromAxes(QVector3D, QVector3D, QVector3D) -> QQuaternion");

extern "C" {static PyObject *meth_QQuaternion_fromAxes(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_fromAxes(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector3D* a0;
        const  ::QVector3D* a1;
        const  ::QVector3D* a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1, sipType_QVector3D, &a2))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion( ::QQuaternion::fromAxes(*a0,*a1,*a2));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_fromAxes, doc_QQuaternion_fromAxes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_fromDirection, "fromDirection(QVector3D, QVector3D) -> QQuaternion");

extern "C" {static PyObject *meth_QQuaternion_fromDirection(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_fromDirection(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector3D* a0;
        const  ::QVector3D* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion( ::QQuaternion::fromDirection(*a0,*a1));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_fromDirection, doc_QQuaternion_fromDirection);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_rotationTo, "rotationTo(QVector3D, QVector3D) -> QQuaternion");

extern "C" {static PyObject *meth_QQuaternion_rotationTo(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_rotationTo(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QVector3D* a0;
        const  ::QVector3D* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion( ::QQuaternion::rotationTo(*a0,*a1));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_rotationTo, doc_QQuaternion_rotationTo);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_dotProduct, "dotProduct(QQuaternion, QQuaternion) -> float");

extern "C" {static PyObject *meth_QQuaternion_dotProduct(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_dotProduct(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion* a0;
        const  ::QQuaternion* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_QQuaternion, &a0, sipType_QQuaternion, &a1))
        {
            float sipRes;

            sipRes =  ::QQuaternion::dotProduct(*a0,*a1);

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_dotProduct, doc_QQuaternion_dotProduct);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_inverted, "inverted(self) -> QQuaternion");

extern "C" {static PyObject *meth_QQuaternion_inverted(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_inverted(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion(sipCpp->inverted());

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_inverted, doc_QQuaternion_inverted);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_conjugated, "conjugated(self) -> QQuaternion");

extern "C" {static PyObject *meth_QQuaternion_conjugated(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_conjugated(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion(sipCpp->conjugated());

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_conjugated, doc_QQuaternion_conjugated);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QQuaternion_toEulerAngles, "toEulerAngles(self) -> QVector3D");

extern "C" {static PyObject *meth_QQuaternion_toEulerAngles(PyObject *, PyObject *);}
static PyObject *meth_QQuaternion_toEulerAngles(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QQuaternion, &sipCpp))
        {
             ::QVector3D*sipRes;

            sipRes = new  ::QVector3D(sipCpp->toEulerAngles());

            return sipConvertFromNewType(sipRes,sipType_QVector3D,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QQuaternion, sipName_toEulerAngles, doc_QQuaternion_toEulerAngles);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QQuaternion___eq__(PyObject *,PyObject *);}
static PyObject *slot_QQuaternion___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QQuaternion *sipCpp = reinterpret_cast< ::QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QQuaternion, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, eq_slot, sipType_QQuaternion, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QQuaternion___ne__(PyObject *,PyObject *);}
static PyObject *slot_QQuaternion___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::QQuaternion *sipCpp = reinterpret_cast< ::QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QQuaternion, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, ne_slot, sipType_QQuaternion, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QQuaternion___truediv__(PyObject *,PyObject *);}
static PyObject *slot_QQuaternion___truediv__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion* a0;
        float a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QQuaternion, &a0, &a1))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion((*a0 / a1));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, truediv_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QQuaternion___add__(PyObject *,PyObject *);}
static PyObject *slot_QQuaternion___add__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion* a0;
        const  ::QQuaternion* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QQuaternion, &a0, sipType_QQuaternion, &a1))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion((*a0 + *a1));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QQuaternion___sub__(PyObject *,PyObject *);}
static PyObject *slot_QQuaternion___sub__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion* a0;
        const  ::QQuaternion* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QQuaternion, &a0, sipType_QQuaternion, &a1))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion((*a0 - *a1));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, sub_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QQuaternion___mul__(PyObject *,PyObject *);}
static PyObject *slot_QQuaternion___mul__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion* a0;
        const  ::QQuaternion* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QQuaternion, &a0, sipType_QQuaternion, &a1))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion((*a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    {
        float a0;
        const  ::QQuaternion* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "fJ9", &a0, sipType_QQuaternion, &a1))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion((a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    {
        const  ::QQuaternion* a0;
        float a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QQuaternion, &a0, &a1))
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion((*a0 * a1));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    {
        const  ::QQuaternion* a0;
        const  ::QVector3D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QQuaternion, &a0, sipType_QVector3D, &a1))
        {
             ::QVector3D*sipRes;

            sipRes = new  ::QVector3D((*a0 * *a1));

            return sipConvertFromNewType(sipRes,sipType_QVector3D,SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, mul_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QQuaternion___neg__(PyObject *);}
static PyObject *slot_QQuaternion___neg__(PyObject *sipSelf)
{
     ::QQuaternion *sipCpp = reinterpret_cast< ::QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
             ::QQuaternion*sipRes;

            sipRes = new  ::QQuaternion(-(*sipCpp));

            return sipConvertFromNewType(sipRes,sipType_QQuaternion,SIP_NULLPTR);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QQuaternion___itruediv__(PyObject *,PyObject *);}
static PyObject *slot_QQuaternion___itruediv__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QQuaternion)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QQuaternion *sipCpp = reinterpret_cast< ::QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            sipCpp-> ::QQuaternion::operator/=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QQuaternion___imul__(PyObject *,PyObject *);}
static PyObject *slot_QQuaternion___imul__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QQuaternion)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QQuaternion *sipCpp = reinterpret_cast< ::QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            sipCpp-> ::QQuaternion::operator*=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const  ::QQuaternion* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QQuaternion, &a0))
        {
            sipCpp-> ::QQuaternion::operator*=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QQuaternion___isub__(PyObject *,PyObject *);}
static PyObject *slot_QQuaternion___isub__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QQuaternion)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QQuaternion *sipCpp = reinterpret_cast< ::QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QQuaternion, &a0))
        {
            sipCpp-> ::QQuaternion::operator-=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QQuaternion___iadd__(PyObject *,PyObject *);}
static PyObject *slot_QQuaternion___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QQuaternion)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

     ::QQuaternion *sipCpp = reinterpret_cast< ::QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::QQuaternion* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QQuaternion, &a0))
        {
            sipCpp-> ::QQuaternion::operator+=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QQuaternion___repr__(PyObject *);}
static PyObject *slot_QQuaternion___repr__(PyObject *sipSelf)
{
     ::QQuaternion *sipCpp = reinterpret_cast< ::QQuaternion *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QQuaternion));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 45 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qquaternion.sip"
        PyObject *scalar = PyFloat_FromDouble(sipCpp->scalar());
        PyObject *x = PyFloat_FromDouble(sipCpp->x());
        PyObject *y = PyFloat_FromDouble(sipCpp->y());
        PyObject *z = PyFloat_FromDouble(sipCpp->z());
        
        if (scalar && x && y && z)
        {
        #if PY_MAJOR_VERSION >= 3
            sipRes = PyUnicode_FromFormat("PyQt5.QtGui.QQuaternion(%R, %R, %R, %R)",
                    scalar, x, y, z);
        #else
            sipRes = PyString_FromString("PyQt5.QtGui.QQuaternion(");
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(scalar));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(x));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(y));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(z));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
        #endif
        }
        
        Py_XDECREF(scalar);
        Py_XDECREF(x);
        Py_XDECREF(y);
        Py_XDECREF(z);
#line 1511 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQQuaternion.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QQuaternion(void *, int);}
static void release_QQuaternion(void *sipCppV, int)
{
    delete reinterpret_cast< ::QQuaternion *>(sipCppV);
}


extern "C" {static PyObject *pickle_QQuaternion(void *);}
static PyObject *pickle_QQuaternion(void *sipCppV)
{
     ::QQuaternion *sipCpp = reinterpret_cast< ::QQuaternion *>(sipCppV);
    PyObject *sipRes;

#line 34 "/build/pyqt5/src/PyQt5-5.15.7/sip/QtGui/qquaternion.sip"
    sipRes = Py_BuildValue((char *)"dddd", (double)sipCpp->scalar(),
            (double)sipCpp->x(), (double)sipCpp->y(), (double)sipCpp->z());
#line 1538 "/build/pyqt5/src/PyQt5-5.15.7/build/QtGui/sipQtGuiQQuaternion.cpp"

    return sipRes;
}


extern "C" {static void *array_QQuaternion(Py_ssize_t);}
static void *array_QQuaternion(Py_ssize_t sipNrElem)
{
    return new  ::QQuaternion[sipNrElem];
}


extern "C" {static void array_delete_QQuaternion(void *);}
static void array_delete_QQuaternion(void *sipCpp)
{
    delete[] reinterpret_cast< ::QQuaternion *>(sipCpp);
}


extern "C" {static void assign_QQuaternion(void *, Py_ssize_t, void *);}
static void assign_QQuaternion(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QQuaternion *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QQuaternion *>(sipSrc);
}


extern "C" {static void *copy_QQuaternion(const void *, Py_ssize_t);}
static void *copy_QQuaternion(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::QQuaternion(reinterpret_cast<const  ::QQuaternion *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QQuaternion(sipSimpleWrapper *);}
static void dealloc_QQuaternion(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QQuaternion(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QQuaternion(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QQuaternion(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::QQuaternion *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new  ::QQuaternion();

            return sipCpp;
        }
    }

    {
        float a0;
        float a1;
        float a2;
        float a3;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "ffff", &a0, &a1, &a2, &a3))
        {
            sipCpp = new  ::QQuaternion(a0,a1,a2,a3);

            return sipCpp;
        }
    }

    {
        float a0;
        const  ::QVector3D* a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "fJ9", &a0, sipType_QVector3D, &a1))
        {
            sipCpp = new  ::QQuaternion(a0,*a1);

            return sipCpp;
        }
    }

    {
        const  ::QVector4D* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVector4D, &a0))
        {
            sipCpp = new  ::QQuaternion(*a0);

            return sipCpp;
        }
    }

    {
        const  ::QQuaternion* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QQuaternion, &a0))
        {
            sipCpp = new  ::QQuaternion(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QQuaternion[] = {
    {(void *)slot_QQuaternion___eq__, eq_slot},
    {(void *)slot_QQuaternion___ne__, ne_slot},
    {(void *)slot_QQuaternion___truediv__, truediv_slot},
    {(void *)slot_QQuaternion___add__, add_slot},
    {(void *)slot_QQuaternion___sub__, sub_slot},
    {(void *)slot_QQuaternion___mul__, mul_slot},
    {(void *)slot_QQuaternion___neg__, neg_slot},
    {(void *)slot_QQuaternion___itruediv__, itruediv_slot},
    {(void *)slot_QQuaternion___imul__, imul_slot},
    {(void *)slot_QQuaternion___isub__, isub_slot},
    {(void *)slot_QQuaternion___iadd__, iadd_slot},
    {(void *)slot_QQuaternion___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QQuaternion[] = {
    {sipName_conjugate, meth_QQuaternion_conjugate, METH_VARARGS, doc_QQuaternion_conjugate},
    {sipName_conjugated, meth_QQuaternion_conjugated, METH_VARARGS, doc_QQuaternion_conjugated},
    {sipName_dotProduct, meth_QQuaternion_dotProduct, METH_VARARGS, doc_QQuaternion_dotProduct},
    {sipName_fromAxes, meth_QQuaternion_fromAxes, METH_VARARGS, doc_QQuaternion_fromAxes},
    {sipName_fromAxisAndAngle, meth_QQuaternion_fromAxisAndAngle, METH_VARARGS, doc_QQuaternion_fromAxisAndAngle},
    {sipName_fromDirection, meth_QQuaternion_fromDirection, METH_VARARGS, doc_QQuaternion_fromDirection},
    {sipName_fromEulerAngles, meth_QQuaternion_fromEulerAngles, METH_VARARGS, doc_QQuaternion_fromEulerAngles},
    {sipName_fromRotationMatrix, meth_QQuaternion_fromRotationMatrix, METH_VARARGS, doc_QQuaternion_fromRotationMatrix},
    {sipName_getAxes, meth_QQuaternion_getAxes, METH_VARARGS, doc_QQuaternion_getAxes},
    {sipName_getAxisAndAngle, meth_QQuaternion_getAxisAndAngle, METH_VARARGS, doc_QQuaternion_getAxisAndAngle},
    {sipName_getEulerAngles, meth_QQuaternion_getEulerAngles, METH_VARARGS, doc_QQuaternion_getEulerAngles},
    {sipName_inverted, meth_QQuaternion_inverted, METH_VARARGS, doc_QQuaternion_inverted},
    {sipName_isIdentity, meth_QQuaternion_isIdentity, METH_VARARGS, doc_QQuaternion_isIdentity},
    {sipName_isNull, meth_QQuaternion_isNull, METH_VARARGS, doc_QQuaternion_isNull},
    {sipName_length, meth_QQuaternion_length, METH_VARARGS, doc_QQuaternion_length},
    {sipName_lengthSquared, meth_QQuaternion_lengthSquared, METH_VARARGS, doc_QQuaternion_lengthSquared},
    {sipName_nlerp, meth_QQuaternion_nlerp, METH_VARARGS, doc_QQuaternion_nlerp},
    {sipName_normalize, meth_QQuaternion_normalize, METH_VARARGS, doc_QQuaternion_normalize},
    {sipName_normalized, meth_QQuaternion_normalized, METH_VARARGS, doc_QQuaternion_normalized},
    {sipName_rotatedVector, meth_QQuaternion_rotatedVector, METH_VARARGS, doc_QQuaternion_rotatedVector},
    {sipName_rotationTo, meth_QQuaternion_rotationTo, METH_VARARGS, doc_QQuaternion_rotationTo},
    {sipName_scalar, meth_QQuaternion_scalar, METH_VARARGS, doc_QQuaternion_scalar},
    {sipName_setScalar, meth_QQuaternion_setScalar, METH_VARARGS, doc_QQuaternion_setScalar},
    {sipName_setVector, meth_QQuaternion_setVector, METH_VARARGS, doc_QQuaternion_setVector},
    {sipName_setX, meth_QQuaternion_setX, METH_VARARGS, doc_QQuaternion_setX},
    {sipName_setY, meth_QQuaternion_setY, METH_VARARGS, doc_QQuaternion_setY},
    {sipName_setZ, meth_QQuaternion_setZ, METH_VARARGS, doc_QQuaternion_setZ},
    {sipName_slerp, meth_QQuaternion_slerp, METH_VARARGS, doc_QQuaternion_slerp},
    {sipName_toEulerAngles, meth_QQuaternion_toEulerAngles, METH_VARARGS, doc_QQuaternion_toEulerAngles},
    {sipName_toRotationMatrix, meth_QQuaternion_toRotationMatrix, METH_VARARGS, doc_QQuaternion_toRotationMatrix},
    {sipName_toVector4D, meth_QQuaternion_toVector4D, METH_VARARGS, doc_QQuaternion_toVector4D},
    {sipName_vector, meth_QQuaternion_vector, METH_VARARGS, doc_QQuaternion_vector},
    {sipName_x, meth_QQuaternion_x, METH_VARARGS, doc_QQuaternion_x},
    {sipName_y, meth_QQuaternion_y, METH_VARARGS, doc_QQuaternion_y},
    {sipName_z, meth_QQuaternion_z, METH_VARARGS, doc_QQuaternion_z}
};

PyDoc_STRVAR(doc_QQuaternion, "\1QQuaternion()\n"
"QQuaternion(float, float, float, float)\n"
"QQuaternion(float, QVector3D)\n"
"QQuaternion(QVector4D)\n"
"QQuaternion(QQuaternion)");


static pyqt5ClassPluginDef plugin_QQuaternion = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtGui_QQuaternion = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QQuaternion,
        SIP_NULLPTR,
        &plugin_QQuaternion
    },
    {
        sipNameNr_QQuaternion,
        {0, 0, 1},
        35, methods_QQuaternion,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QQuaternion,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QQuaternion,
    init_type_QQuaternion,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QQuaternion,
    assign_QQuaternion,
    array_QQuaternion,
    copy_QQuaternion,
    release_QQuaternion,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    pickle_QQuaternion,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QQuaternion,
    sizeof ( ::QQuaternion),
};
