/* rygel-http-time-seek-response.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-http-time-seek-response.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 * Contact: http://www.cablelabs.com/
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <locale.h>
#include <float.h>
#include <math.h>

enum  {
	RYGEL_HTTP_TIME_SEEK_RESPONSE_0_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_NUM_PROPERTIES
};
static GParamSpec* rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_NUM_PROPERTIES];
#define __vala_SoupMessageHeaders_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMessageHeaders_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelHTTPTimeSeekResponsePrivate {
	gint64 _start_time;
	gint64 _end_time;
	gint64 _range_duration;
	gint64 _total_duration;
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _response_length;
	gint64 _total_size;
};

static gint RygelHTTPTimeSeekResponse_private_offset;
static gpointer rygel_http_time_seek_response_parent_class = NULL;

static void rygel_http_time_seek_response_set_start_time (RygelHTTPTimeSeekResponse* self,
                                                   gint64 value);
static void rygel_http_time_seek_response_set_end_time (RygelHTTPTimeSeekResponse* self,
                                                 gint64 value);
static void rygel_http_time_seek_response_set_total_duration (RygelHTTPTimeSeekResponse* self,
                                                       gint64 value);
static void rygel_http_time_seek_response_set_start_byte (RygelHTTPTimeSeekResponse* self,
                                                   gint64 value);
static void rygel_http_time_seek_response_set_end_byte (RygelHTTPTimeSeekResponse* self,
                                                 gint64 value);
static void rygel_http_time_seek_response_set_response_length (RygelHTTPTimeSeekResponse* self,
                                                        gint64 value);
static void rygel_http_time_seek_response_set_total_size (RygelHTTPTimeSeekResponse* self,
                                                   gint64 value);
static void rygel_http_time_seek_response_real_add_response_headers (RygelHTTPResponseElement* base,
                                                              RygelHTTPRequest* request);
static gchar* rygel_http_time_seek_response_get_response_string (RygelHTTPTimeSeekResponse* self);
static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self);
static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self);
static gchar* rygel_http_time_seek_response_real_to_string (RygelHTTPResponseElement* base);
static void rygel_http_time_seek_response_set_range_duration (RygelHTTPTimeSeekResponse* self,
                                                       gint64 value);
static void rygel_http_time_seek_response_finalize (GObject * obj);
static GType rygel_http_time_seek_response_get_type_once (void);
static void _vala_rygel_http_time_seek_response_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_rygel_http_time_seek_response_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_http_time_seek_response_get_instance_private (RygelHTTPTimeSeekResponse* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPTimeSeekResponse_private_offset);
}

/**
     * Construct a HTTPTimeSeekResponse with time and byte range
     *
     * start_time and start_byte must be specified.
     *
     * if total_duration and total_size are UNSPECIFIED, then the content
     * duration/size will be signaled as unknown ("*")
     *
     * if end_time is UNSPECIFIED, then the time range end will be omitted
     * from the response. If the end_byte is UNSPECIFIED, the entire byte
     * range response will be omitted. (see DLNA 7.5.4.3.2.24.3)
     */
RygelHTTPTimeSeekResponse*
rygel_http_time_seek_response_construct (GType object_type,
                                         gint64 start_time,
                                         gint64 end_time,
                                         gint64 total_duration,
                                         gint64 start_byte,
                                         gint64 end_byte,
                                         gint64 total_size)
{
	RygelHTTPTimeSeekResponse * self = NULL;
	gint64 _tmp0_;
	self = (RygelHTTPTimeSeekResponse*) rygel_http_response_element_construct (object_type);
	rygel_http_time_seek_response_set_start_time (self, start_time);
	rygel_http_time_seek_response_set_end_time (self, end_time);
	rygel_http_time_seek_response_set_total_duration (self, total_duration);
	rygel_http_time_seek_response_set_start_byte (self, start_byte);
	rygel_http_time_seek_response_set_end_byte (self, end_byte);
	rygel_http_time_seek_response_set_response_length (self, end_byte);
	_tmp0_ = self->priv->_response_length;
	if (_tmp0_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		gint64 _tmp1_;
		_tmp1_ = self->priv->_response_length;
		rygel_http_time_seek_response_set_response_length (self, _tmp1_ - (start_byte - 1));
	}
	rygel_http_time_seek_response_set_total_size (self, total_size);
	return self;
}

RygelHTTPTimeSeekResponse*
rygel_http_time_seek_response_new (gint64 start_time,
                                   gint64 end_time,
                                   gint64 total_duration,
                                   gint64 start_byte,
                                   gint64 end_byte,
                                   gint64 total_size)
{
	return rygel_http_time_seek_response_construct (RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, start_time, end_time, total_duration, start_byte, end_byte, total_size);
}

/**
     * Create a HTTPTimeSeekResponse only containing a time range
     *
     * Note: This form is only valid when byte-seek is not supported,
     * according to the associated resource's ProtocolInfo (see DLNA
     * 7.5.4.3.2.24.5)
     */
RygelHTTPTimeSeekResponse*
rygel_http_time_seek_response_construct_time_only (GType object_type,
                                                   gint64 start_time,
                                                   gint64 end_time,
                                                   gint64 total_duration)
{
	RygelHTTPTimeSeekResponse * self = NULL;
	self = (RygelHTTPTimeSeekResponse*) rygel_http_response_element_construct (object_type);
	rygel_http_time_seek_response_set_start_time (self, start_time);
	rygel_http_time_seek_response_set_end_time (self, end_time);
	rygel_http_time_seek_response_set_total_duration (self, total_duration);
	rygel_http_time_seek_response_set_start_byte (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
	rygel_http_time_seek_response_set_end_byte (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
	rygel_http_time_seek_response_set_response_length (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
	rygel_http_time_seek_response_set_total_size (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
	return self;
}

RygelHTTPTimeSeekResponse*
rygel_http_time_seek_response_new_time_only (gint64 start_time,
                                             gint64 end_time,
                                             gint64 total_duration)
{
	return rygel_http_time_seek_response_construct_time_only (RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, start_time, end_time, total_duration);
}

/**
     * Construct a HTTPTimeSeekResponse with time and byte range and allowing
     * for a response length override. This is useful when the response body
     * is larger than the specified byte range from the original content
     * binary.
     *
     * start_time and start_byte must be specified.
     *
     * If total_duration and total_size are UNSPECIFIED, then the content
     * duration/size will be signaled as unknown ("*")
     *
     * if end_time is UNSPECIFIED, then the time range end will be omitted
     * from the response. If the end_byte is UNSPECIFIED, the entire byte
     * range response will be omitted. (see DLNA 7.5.4.3.2.24.3)
     */
RygelHTTPTimeSeekResponse*
rygel_http_time_seek_response_construct_with_length (GType object_type,
                                                     gint64 start_time,
                                                     gint64 end_time,
                                                     gint64 total_duration,
                                                     gint64 start_byte,
                                                     gint64 end_byte,
                                                     gint64 total_size,
                                                     gint64 response_length)
{
	RygelHTTPTimeSeekResponse * self = NULL;
	self = (RygelHTTPTimeSeekResponse*) rygel_http_response_element_construct (object_type);
	rygel_http_time_seek_response_set_start_time (self, start_time);
	rygel_http_time_seek_response_set_end_time (self, end_time);
	rygel_http_time_seek_response_set_total_duration (self, total_duration);
	rygel_http_time_seek_response_set_start_byte (self, start_byte);
	rygel_http_time_seek_response_set_end_byte (self, end_byte);
	rygel_http_time_seek_response_set_response_length (self, response_length);
	rygel_http_time_seek_response_set_total_size (self, total_size);
	return self;
}

RygelHTTPTimeSeekResponse*
rygel_http_time_seek_response_new_with_length (gint64 start_time,
                                               gint64 end_time,
                                               gint64 total_duration,
                                               gint64 start_byte,
                                               gint64 end_byte,
                                               gint64 total_size,
                                               gint64 response_length)
{
	return rygel_http_time_seek_response_construct_with_length (RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, start_time, end_time, total_duration, start_byte, end_byte, total_size, response_length);
}

/**
     * Create a HTTPTimeSeekResponse from a HTTPTimeSeekRequest
     *
     * Note: This form is only valid when byte-seek is not supported,
     * according to the associated resource's ProtocolInfo (see DLNA
     * 7.5.4.3.2.24.5)
     */
RygelHTTPTimeSeekResponse*
rygel_http_time_seek_response_construct_from_request (GType object_type,
                                                      RygelHTTPTimeSeekRequest* time_seek_request,
                                                      gint64 total_duration)
{
	RygelHTTPTimeSeekResponse * self = NULL;
	g_return_val_if_fail (time_seek_request != NULL, NULL);
	self = (RygelHTTPTimeSeekResponse*) rygel_http_time_seek_response_construct_time_only (object_type, time_seek_request->start_time, time_seek_request->end_time, total_duration);
	return self;
}

RygelHTTPTimeSeekResponse*
rygel_http_time_seek_response_new_from_request (RygelHTTPTimeSeekRequest* time_seek_request,
                                                gint64 total_duration)
{
	return rygel_http_time_seek_response_construct_from_request (RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, time_seek_request, total_duration);
}

static SoupMessageHeaders*
_vala_SoupMessageHeaders_copy (SoupMessageHeaders* self)
{
	return g_boxed_copy (soup_message_headers_get_type (), self);
}

static gpointer
__vala_SoupMessageHeaders_copy0 (gpointer self)
{
	return self ? _vala_SoupMessageHeaders_copy (self) : NULL;
}

static void
_vala_SoupMessageHeaders_free (SoupMessageHeaders* self)
{
	g_boxed_free (soup_message_headers_get_type (), self);
}

static void
rygel_http_time_seek_response_real_add_response_headers (RygelHTTPResponseElement* base,
                                                         RygelHTTPRequest* request)
{
	RygelHTTPTimeSeekResponse * self;
	gchar* response = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (RygelHTTPTimeSeekResponse*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = rygel_http_time_seek_response_get_response_string (self);
	response = _tmp0_;
	_tmp1_ = response;
	if (_tmp1_ != NULL) {
		SoupMessageHeaders* headers = NULL;
		SoupMessage* _tmp2_;
		SoupMessageHeaders* _tmp3_;
		SoupMessageHeaders* _tmp4_;
		SoupMessageHeaders* _tmp5_;
		const gchar* _tmp6_;
		gint64 _tmp7_;
		SoupMessage* _tmp10_;
		_tmp2_ = request->msg;
		_tmp3_ = _tmp2_->response_headers;
		_tmp4_ = __vala_SoupMessageHeaders_copy0 (_tmp3_);
		headers = _tmp4_;
		_tmp5_ = headers;
		_tmp6_ = response;
		soup_message_headers_append (_tmp5_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp6_);
		_tmp7_ = self->priv->_response_length;
		if (_tmp7_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
			SoupMessageHeaders* _tmp8_;
			gint64 _tmp9_;
			_tmp8_ = headers;
			_tmp9_ = self->priv->_response_length;
			soup_message_headers_set_content_length (_tmp8_, _tmp9_);
		}
		_tmp10_ = request->msg;
		if (soup_message_get_http_version (_tmp10_) == SOUP_HTTP_1_0) {
			SoupMessageHeaders* _tmp11_;
			_tmp11_ = headers;
			soup_message_headers_replace (_tmp11_, "Pragma", "no-cache");
		}
		__vala_SoupMessageHeaders_free0 (headers);
	}
	_g_free0 (response);
}

static gchar*
rygel_http_time_seek_response_get_response_string (RygelHTTPTimeSeekResponse* self)
{
	gint64 _tmp0_;
	GString* response = NULL;
	GString* _tmp1_;
	gchar* locale = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GString* _tmp4_;
	GString* _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp10_;
	const gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	gint64 _tmp16_;
	GString* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_start_time;
	if (_tmp0_ == RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		result = NULL;
		return result;
	}
	_tmp1_ = g_string_new ("");
	response = _tmp1_;
	_tmp2_ = setlocale (LC_NUMERIC, "C");
	_tmp3_ = g_strdup (_tmp2_);
	locale = _tmp3_;
	_tmp4_ = response;
	g_string_append (_tmp4_, "npt=");
	_tmp5_ = response;
	_tmp6_ = self->priv->_start_time;
	g_string_append_printf (_tmp5_, "%.3f-", ((gdouble) _tmp6_) / G_TIME_SPAN_SECOND);
	_tmp7_ = self->priv->_end_time;
	if (_tmp7_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		GString* _tmp8_;
		gint64 _tmp9_;
		_tmp8_ = response;
		_tmp9_ = self->priv->_end_time;
		g_string_append_printf (_tmp8_, "%.3f", ((gdouble) _tmp9_) / G_TIME_SPAN_SECOND);
	}
	_tmp10_ = self->priv->_total_duration;
	if (_tmp10_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		gdouble total = 0.0;
		gint64 _tmp11_;
		GString* _tmp12_;
		_tmp11_ = self->priv->_total_duration;
		total = ((gdouble) _tmp11_) / G_TIME_SPAN_SECOND;
		_tmp12_ = response;
		g_string_append_printf (_tmp12_, "/%.3f", total);
	} else {
		GString* _tmp13_;
		_tmp13_ = response;
		g_string_append (_tmp13_, "/*");
	}
	_tmp14_ = locale;
	setlocale (LC_NUMERIC, _tmp14_);
	_tmp16_ = self->priv->_start_byte;
	if (_tmp16_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
		gint64 _tmp17_;
		_tmp17_ = self->priv->_end_byte;
		_tmp15_ = _tmp17_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GString* _tmp18_;
		GString* _tmp19_;
		gint64 _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		GString* _tmp23_;
		GString* _tmp24_;
		gint64 _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GString* _tmp28_;
		gint64 _tmp29_;
		_tmp18_ = response;
		g_string_append (_tmp18_, " bytes=");
		_tmp19_ = response;
		_tmp20_ = self->priv->_start_byte;
		_tmp21_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp20_);
		_tmp22_ = _tmp21_;
		g_string_append (_tmp19_, _tmp22_);
		_g_free0 (_tmp22_);
		_tmp23_ = response;
		g_string_append (_tmp23_, "-");
		_tmp24_ = response;
		_tmp25_ = self->priv->_end_byte;
		_tmp26_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp25_);
		_tmp27_ = _tmp26_;
		g_string_append (_tmp24_, _tmp27_);
		_g_free0 (_tmp27_);
		_tmp28_ = response;
		g_string_append (_tmp28_, "/");
		_tmp29_ = self->priv->_total_size;
		if (_tmp29_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
			GString* _tmp30_;
			gint64 _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp30_ = response;
			_tmp31_ = self->priv->_total_size;
			_tmp32_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp31_);
			_tmp33_ = _tmp32_;
			g_string_append (_tmp30_, _tmp33_);
			_g_free0 (_tmp33_);
		} else {
			GString* _tmp34_;
			_tmp34_ = response;
			g_string_append (_tmp34_, "*");
		}
	}
	_tmp35_ = response;
	_tmp36_ = _tmp35_->str;
	_tmp37_ = g_strdup (_tmp36_);
	result = _tmp37_;
	_g_free0 (locale);
	_g_string_free0 (response);
	return result;
}

static gchar*
rygel_http_time_seek_response_real_to_string (RygelHTTPResponseElement* base)
{
	RygelHTTPTimeSeekResponse * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = (RygelHTTPTimeSeekResponse*) base;
	_tmp0_ = rygel_http_time_seek_response_get_response_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("HTTPTimeSeekResponse (%s)", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gint64
rygel_http_time_seek_response_get_start_time (RygelHTTPTimeSeekResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_start_time;
	return result;
}

static void
rygel_http_time_seek_response_set_start_time (RygelHTTPTimeSeekResponse* self,
                                              gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_time_seek_response_get_start_time (self);
	if (old_value != value) {
		self->priv->_start_time = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME_PROPERTY]);
	}
}

gint64
rygel_http_time_seek_response_get_end_time (RygelHTTPTimeSeekResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_end_time;
	return result;
}

static void
rygel_http_time_seek_response_set_end_time (RygelHTTPTimeSeekResponse* self,
                                            gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_time_seek_response_get_end_time (self);
	if (old_value != value) {
		self->priv->_end_time = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME_PROPERTY]);
	}
}

gint64
rygel_http_time_seek_response_get_range_duration (RygelHTTPTimeSeekResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_range_duration;
	return result;
}

static void
rygel_http_time_seek_response_set_range_duration (RygelHTTPTimeSeekResponse* self,
                                                  gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_time_seek_response_get_range_duration (self);
	if (old_value != value) {
		self->priv->_range_duration = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION_PROPERTY]);
	}
}

gint64
rygel_http_time_seek_response_get_total_duration (RygelHTTPTimeSeekResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_total_duration;
	return result;
}

static void
rygel_http_time_seek_response_set_total_duration (RygelHTTPTimeSeekResponse* self,
                                                  gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_time_seek_response_get_total_duration (self);
	if (old_value != value) {
		self->priv->_total_duration = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION_PROPERTY]);
	}
}

gint64
rygel_http_time_seek_response_get_start_byte (RygelHTTPTimeSeekResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_start_byte;
	return result;
}

static void
rygel_http_time_seek_response_set_start_byte (RygelHTTPTimeSeekResponse* self,
                                              gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_time_seek_response_get_start_byte (self);
	if (old_value != value) {
		self->priv->_start_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE_PROPERTY]);
	}
}

gint64
rygel_http_time_seek_response_get_end_byte (RygelHTTPTimeSeekResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_end_byte;
	return result;
}

static void
rygel_http_time_seek_response_set_end_byte (RygelHTTPTimeSeekResponse* self,
                                            gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_time_seek_response_get_end_byte (self);
	if (old_value != value) {
		self->priv->_end_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE_PROPERTY]);
	}
}

gint64
rygel_http_time_seek_response_get_response_length (RygelHTTPTimeSeekResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_response_length;
	return result;
}

static void
rygel_http_time_seek_response_set_response_length (RygelHTTPTimeSeekResponse* self,
                                                   gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_time_seek_response_get_response_length (self);
	if (old_value != value) {
		self->priv->_response_length = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH_PROPERTY]);
	}
}

gint64
rygel_http_time_seek_response_get_total_size (RygelHTTPTimeSeekResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_total_size;
	return result;
}

static void
rygel_http_time_seek_response_set_total_size (RygelHTTPTimeSeekResponse* self,
                                              gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_time_seek_response_get_total_size (self);
	if (old_value != value) {
		self->priv->_total_size = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE_PROPERTY]);
	}
}

static void
rygel_http_time_seek_response_class_init (RygelHTTPTimeSeekResponseClass * klass,
                                          gpointer klass_data)
{
	rygel_http_time_seek_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPTimeSeekResponse_private_offset);
	((RygelHTTPResponseElementClass *) klass)->add_response_headers = (void (*) (RygelHTTPResponseElement*, RygelHTTPRequest*)) rygel_http_time_seek_response_real_add_response_headers;
	((RygelHTTPResponseElementClass *) klass)->to_string = (gchar* (*) (RygelHTTPResponseElement*)) rygel_http_time_seek_response_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_time_seek_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_time_seek_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_time_seek_response_finalize;
	/**
	     * Effective range start time, in microseconds
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME_PROPERTY, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME_PROPERTY] = g_param_spec_int64 ("start-time", "start-time", "start-time", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Effective range end time, in microseconds
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME_PROPERTY, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME_PROPERTY] = g_param_spec_int64 ("end-time", "end-time", "end-time", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Effective range duration, in microseconds
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION_PROPERTY, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION_PROPERTY] = g_param_spec_int64 ("range-duration", "range-duration", "range-duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The total duration of the resource, in microseconds
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION_PROPERTY, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION_PROPERTY] = g_param_spec_int64 ("total-duration", "total-duration", "total-duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The start of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE_PROPERTY, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE_PROPERTY] = g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The end of the range in bytes (inclusive)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE_PROPERTY, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE_PROPERTY] = g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The response length in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH_PROPERTY, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH_PROPERTY] = g_param_spec_int64 ("response-length", "response-length", "response-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The length of the resource in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE_PROPERTY, rygel_http_time_seek_response_properties[RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE_PROPERTY] = g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_http_time_seek_response_instance_init (RygelHTTPTimeSeekResponse * self,
                                             gpointer klass)
{
	self->priv = rygel_http_time_seek_response_get_instance_private (self);
}

static void
rygel_http_time_seek_response_finalize (GObject * obj)
{
	RygelHTTPTimeSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponse);
	G_OBJECT_CLASS (rygel_http_time_seek_response_parent_class)->finalize (obj);
}

static GType
rygel_http_time_seek_response_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeekResponse), 0, (GInstanceInitFunc) rygel_http_time_seek_response_instance_init, NULL };
	GType rygel_http_time_seek_response_type_id;
	rygel_http_time_seek_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, "RygelHTTPTimeSeekResponse", &g_define_type_info, 0);
	RygelHTTPTimeSeekResponse_private_offset = g_type_add_instance_private (rygel_http_time_seek_response_type_id, sizeof (RygelHTTPTimeSeekResponsePrivate));
	return rygel_http_time_seek_response_type_id;
}

GType
rygel_http_time_seek_response_get_type (void)
{
	static volatile gsize rygel_http_time_seek_response_type_id__once = 0;
	if (g_once_init_enter (&rygel_http_time_seek_response_type_id__once)) {
		GType rygel_http_time_seek_response_type_id;
		rygel_http_time_seek_response_type_id = rygel_http_time_seek_response_get_type_once ();
		g_once_init_leave (&rygel_http_time_seek_response_type_id__once, rygel_http_time_seek_response_type_id);
	}
	return rygel_http_time_seek_response_type_id__once;
}

static void
_vala_rygel_http_time_seek_response_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	RygelHTTPTimeSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponse);
	switch (property_id) {
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME_PROPERTY:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_start_time (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME_PROPERTY:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_end_time (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION_PROPERTY:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_range_duration (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION_PROPERTY:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_total_duration (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_start_byte (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_end_byte (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH_PROPERTY:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_response_length (self));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_http_time_seek_response_get_total_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_http_time_seek_response_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	RygelHTTPTimeSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponse);
	switch (property_id) {
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME_PROPERTY:
		rygel_http_time_seek_response_set_start_time (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME_PROPERTY:
		rygel_http_time_seek_response_set_end_time (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION_PROPERTY:
		rygel_http_time_seek_response_set_range_duration (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION_PROPERTY:
		rygel_http_time_seek_response_set_total_duration (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE_PROPERTY:
		rygel_http_time_seek_response_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE_PROPERTY:
		rygel_http_time_seek_response_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH_PROPERTY:
		rygel_http_time_seek_response_set_response_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE_PROPERTY:
		rygel_http_time_seek_response_set_total_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

