/* rygel-lg-tv-hacks.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-lg-tv-hacks.vala, do not modify */

/*
 * Copyright (C) 2014 Jens Georg
 *
 * Authors: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "rygel-server.h"
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <gee.h>

#define RYGEL_LGTV_HACKS_AGENT ".*LGE_DLNA_SDK.*"

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_LGTV_HACKS (rygel_lgtv_hacks_get_type ())
#define RYGEL_LGTV_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LGTV_HACKS, RygelLGTVHacks))
#define RYGEL_LGTV_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LGTV_HACKS, RygelLGTVHacksClass))
#define RYGEL_IS_LGTV_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LGTV_HACKS))
#define RYGEL_IS_LGTV_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LGTV_HACKS))
#define RYGEL_LGTV_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LGTV_HACKS, RygelLGTVHacksClass))

typedef struct _RygelLGTVHacks RygelLGTVHacks;
typedef struct _RygelLGTVHacksClass RygelLGTVHacksClass;
typedef struct _RygelLGTVHacksPrivate RygelLGTVHacksPrivate;
enum  {
	RYGEL_LGTV_HACKS_0_PROPERTY,
	RYGEL_LGTV_HACKS_NUM_PROPERTIES
};
static GParamSpec* rygel_lgtv_hacks_properties[RYGEL_LGTV_HACKS_NUM_PROPERTIES];

#define RYGEL_TYPE_CLIENT_HACKS_ERROR (rygel_client_hacks_error_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
	GRegex* agent_regex;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
	void (*translate_container_id) (RygelClientHacks* self, RygelMediaQueryAction* action, gchar** container_id);
	void (*apply) (RygelClientHacks* self, RygelMediaObject* object);
	void (*filter_sort_criteria) (RygelClientHacks* self, gchar** sort_criteria);
	gboolean (*force_seek) (RygelClientHacks* self);
	void (*modify_headers) (RygelClientHacks* self, RygelHTTPRequest* request);
	void (*search) (RygelClientHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelClientHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelLGTVHacks {
	RygelClientHacks parent_instance;
	RygelLGTVHacksPrivate * priv;
};

struct _RygelLGTVHacksClass {
	RygelClientHacksClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_lgtv_hacks_parent_class = NULL;

VALA_EXTERN GType rygel_client_hacks_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_media_query_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_lgtv_hacks_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void rygel_client_hacks_apply (RygelClientHacks* self,
                               RygelMediaObject* object);
VALA_EXTERN GQuark rygel_client_hacks_error_quark (void);
GType rygel_client_hacks_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelLGTVHacks* rygel_lgtv_hacks_new (SoupMessage* message,
                                      GError** error);
VALA_EXTERN RygelLGTVHacks* rygel_lgtv_hacks_construct (GType object_type,
                                            SoupMessage* message,
                                            GError** error);
VALA_EXTERN RygelClientHacks* rygel_client_hacks_construct (GType object_type,
                                                const gchar* agent,
                                                SoupMessage* message,
                                                GError** error);
static void rygel_lgtv_hacks_real_apply (RygelClientHacks* base,
                                  RygelMediaObject* object);
static GType rygel_lgtv_hacks_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

RygelLGTVHacks*
rygel_lgtv_hacks_construct (GType object_type,
                            SoupMessage* message,
                            GError** error)
{
	RygelLGTVHacks * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (RygelLGTVHacks*) rygel_client_hacks_construct (object_type, RYGEL_LGTV_HACKS_AGENT, message, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_CLIENT_HACKS_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

RygelLGTVHacks*
rygel_lgtv_hacks_new (SoupMessage* message,
                      GError** error)
{
	return rygel_lgtv_hacks_construct (RYGEL_TYPE_LGTV_HACKS, message, error);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_lgtv_hacks_real_apply (RygelClientHacks* base,
                             RygelMediaObject* object)
{
	RygelLGTVHacks * self;
	RygelVideoItem* item = NULL;
	RygelVideoItem* _tmp57_;
	self = (RygelLGTVHacks*) base;
	g_return_if_fail (object != NULL);
	{
		GeeList* _resource_list = NULL;
		GeeList* _tmp0_;
		gint _resource_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _resource_index = 0;
		_tmp0_ = rygel_media_object_get_resource_list (object);
		_resource_list = _tmp0_;
		_tmp1_ = _resource_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_resource_size = _tmp3_;
		_resource_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelMediaResource* resource = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			RygelMediaResource* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_resource_index = _resource_index + 1;
			_tmp4_ = _resource_index;
			_tmp5_ = _resource_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _resource_list;
			_tmp7_ = gee_list_get (_tmp6_, _resource_index);
			resource = (RygelMediaResource*) _tmp7_;
			_tmp9_ = resource;
			_tmp10_ = rygel_media_resource_get_mime_type (_tmp9_);
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, "audio/x-vorbis+ogg") == 0) {
				_tmp8_ = TRUE;
			} else {
				RygelMediaResource* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp12_ = resource;
				_tmp13_ = rygel_media_resource_get_mime_type (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = g_strcmp0 (_tmp14_, "audio/x-flac+ogg") == 0;
			}
			if (_tmp8_) {
				RygelMediaResource* _tmp15_;
				_tmp15_ = resource;
				rygel_media_resource_set_mime_type (_tmp15_, "application/ogg");
			} else {
				RygelMediaResource* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp16_ = resource;
				_tmp17_ = rygel_media_resource_get_mime_type (_tmp16_);
				_tmp18_ = _tmp17_;
				if (g_strcmp0 (_tmp18_, "video/x-matroska") == 0) {
					RygelMediaResource* _tmp19_;
					_tmp19_ = resource;
					rygel_media_resource_set_dlna_profile (_tmp19_, NULL);
				} else {
					RygelMediaResource* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					_tmp20_ = resource;
					_tmp21_ = rygel_media_resource_get_mime_type (_tmp20_);
					_tmp22_ = _tmp21_;
					if (g_strcmp0 (_tmp22_, "video/x-msvideo") == 0) {
						RygelMediaResource* _tmp23_;
						_tmp23_ = resource;
						rygel_media_resource_set_mime_type (_tmp23_, "video/avi");
					} else {
						RygelMediaResource* _tmp24_;
						const gchar* _tmp25_;
						const gchar* _tmp26_;
						_tmp24_ = resource;
						_tmp25_ = rygel_media_resource_get_mime_type (_tmp24_);
						_tmp26_ = _tmp25_;
						if (g_strcmp0 (_tmp26_, "video/mp4") == 0) {
							RygelMediaResource* _tmp27_;
							_tmp27_ = resource;
							rygel_media_resource_set_dlna_profile (_tmp27_, NULL);
						} else {
							RygelMediaResource* _tmp28_;
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							_tmp28_ = resource;
							_tmp29_ = rygel_media_resource_get_mime_type (_tmp28_);
							_tmp30_ = _tmp29_;
							if (g_strcmp0 (_tmp30_, "application/x-subrip") == 0) {
								RygelMediaResource* _tmp31_;
								_tmp31_ = resource;
								rygel_media_resource_set_mime_type (_tmp31_, "text/srt");
							}
						}
					}
				}
			}
			_g_object_unref0 (resource);
		}
		_g_object_unref0 (_resource_list);
	}
	if (!RYGEL_IS_MEDIA_FILE_ITEM (object)) {
		return;
	}
	if (RYGEL_IS_MUSIC_ITEM (object)) {
		GeeList* resources = NULL;
		GeeList* _tmp32_;
		gint i = 0;
		gboolean _tmp49_ = FALSE;
		_tmp32_ = rygel_media_object_get_resource_list (object);
		resources = _tmp32_;
		i = 0;
		{
			GeeList* _resource_list = NULL;
			GeeList* _tmp33_;
			gint _resource_size = 0;
			GeeList* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			gint _resource_index = 0;
			_tmp33_ = resources;
			_resource_list = _tmp33_;
			_tmp34_ = _resource_list;
			_tmp35_ = gee_collection_get_size ((GeeCollection*) _tmp34_);
			_tmp36_ = _tmp35_;
			_resource_size = _tmp36_;
			_resource_index = -1;
			while (TRUE) {
				gint _tmp37_;
				gint _tmp38_;
				RygelMediaResource* resource = NULL;
				GeeList* _tmp39_;
				gpointer _tmp40_;
				gboolean _tmp41_ = FALSE;
				RygelMediaResource* _tmp42_;
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				gint _tmp48_;
				_resource_index = _resource_index + 1;
				_tmp37_ = _resource_index;
				_tmp38_ = _resource_size;
				if (!(_tmp37_ < _tmp38_)) {
					break;
				}
				_tmp39_ = _resource_list;
				_tmp40_ = gee_list_get (_tmp39_, _resource_index);
				resource = (RygelMediaResource*) _tmp40_;
				_tmp42_ = resource;
				_tmp43_ = rygel_media_resource_get_dlna_profile (_tmp42_);
				_tmp44_ = _tmp43_;
				if (_tmp44_ != NULL) {
					RygelMediaResource* _tmp45_;
					const gchar* _tmp46_;
					const gchar* _tmp47_;
					_tmp45_ = resource;
					_tmp46_ = rygel_media_resource_get_dlna_profile (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp41_ = g_str_has_prefix (_tmp47_, "MP3");
				} else {
					_tmp41_ = FALSE;
				}
				if (_tmp41_) {
					_g_object_unref0 (resource);
					break;
				}
				_tmp48_ = i;
				i = _tmp48_ + 1;
				_g_object_unref0 (resource);
			}
		}
		if (i > 0) {
			GeeList* _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			_tmp50_ = resources;
			_tmp51_ = gee_collection_get_size ((GeeCollection*) _tmp50_);
			_tmp52_ = _tmp51_;
			_tmp49_ = i < _tmp52_;
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			RygelMediaResource* resource = NULL;
			GeeList* _tmp53_;
			gpointer _tmp54_;
			GeeList* _tmp55_;
			RygelMediaResource* _tmp56_;
			_tmp53_ = resources;
			_tmp54_ = gee_list_remove_at (_tmp53_, i);
			resource = (RygelMediaResource*) _tmp54_;
			_tmp55_ = resources;
			_tmp56_ = resource;
			gee_list_insert (_tmp55_, 0, _tmp56_);
			_g_object_unref0 (resource);
		}
		_g_object_unref0 (resources);
	}
	if (!RYGEL_IS_VIDEO_ITEM (object)) {
		return;
	}
	_tmp57_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (object) ? ((RygelVideoItem*) object) : NULL);
	item = _tmp57_;
	{
		GeeArrayList* _subtitle_list = NULL;
		RygelVideoItem* _tmp58_;
		GeeArrayList* _tmp59_;
		GeeArrayList* _tmp60_;
		gint _subtitle_size = 0;
		GeeArrayList* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		gint _subtitle_index = 0;
		_tmp58_ = item;
		_tmp59_ = rygel_video_item_get_subtitles (_tmp58_);
		_tmp60_ = _tmp59_;
		_subtitle_list = _tmp60_;
		_tmp61_ = _subtitle_list;
		_tmp62_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp61_);
		_tmp63_ = _tmp62_;
		_subtitle_size = _tmp63_;
		_subtitle_index = -1;
		while (TRUE) {
			gint _tmp64_;
			gint _tmp65_;
			RygelSubtitle* subtitle = NULL;
			GeeArrayList* _tmp66_;
			gpointer _tmp67_;
			RygelSubtitle* _tmp68_;
			const gchar* _tmp69_;
			_subtitle_index = _subtitle_index + 1;
			_tmp64_ = _subtitle_index;
			_tmp65_ = _subtitle_size;
			if (!(_tmp64_ < _tmp65_)) {
				break;
			}
			_tmp66_ = _subtitle_list;
			_tmp67_ = gee_abstract_list_get ((GeeAbstractList*) _tmp66_, _subtitle_index);
			subtitle = (RygelSubtitle*) _tmp67_;
			_tmp68_ = subtitle;
			_tmp69_ = _tmp68_->mime_type;
			if (g_strcmp0 (_tmp69_, "application/x-subrip") == 0) {
				RygelSubtitle* _tmp70_;
				gchar* _tmp71_;
				_tmp70_ = subtitle;
				_tmp71_ = g_strdup ("text/srt");
				_g_free0 (_tmp70_->mime_type);
				_tmp70_->mime_type = _tmp71_;
			}
			_rygel_subtitle_unref0 (subtitle);
		}
	}
	_g_object_unref0 (item);
}

static void
rygel_lgtv_hacks_class_init (RygelLGTVHacksClass * klass,
                             gpointer klass_data)
{
	rygel_lgtv_hacks_parent_class = g_type_class_peek_parent (klass);
	((RygelClientHacksClass *) klass)->apply = (void (*) (RygelClientHacks*, RygelMediaObject*)) rygel_lgtv_hacks_real_apply;
}

static void
rygel_lgtv_hacks_instance_init (RygelLGTVHacks * self,
                                gpointer klass)
{
}

static GType
rygel_lgtv_hacks_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLGTVHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lgtv_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLGTVHacks), 0, (GInstanceInitFunc) rygel_lgtv_hacks_instance_init, NULL };
	GType rygel_lgtv_hacks_type_id;
	rygel_lgtv_hacks_type_id = g_type_register_static (RYGEL_TYPE_CLIENT_HACKS, "RygelLGTVHacks", &g_define_type_info, 0);
	return rygel_lgtv_hacks_type_id;
}

GType
rygel_lgtv_hacks_get_type (void)
{
	static volatile gsize rygel_lgtv_hacks_type_id__once = 0;
	if (g_once_init_enter (&rygel_lgtv_hacks_type_id__once)) {
		GType rygel_lgtv_hacks_type_id;
		rygel_lgtv_hacks_type_id = rygel_lgtv_hacks_get_type_once ();
		g_once_init_leave (&rygel_lgtv_hacks_type_id__once, rygel_lgtv_hacks_type_id);
	}
	return rygel_lgtv_hacks_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

