/* rygel-playspeed.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-playspeed.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#define _rygel_play_speed_unref0(var) ((var == NULL) ? NULL : (var = (rygel_play_speed_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelParamSpecPlaySpeed RygelParamSpecPlaySpeed;

struct _RygelParamSpecPlaySpeed {
	GParamSpec parent_instance;
};

static gpointer rygel_play_speed_parent_class = NULL;

static void rygel_play_speed_parse (RygelPlaySpeed* self,
                             const gchar* speed,
                             GError** error);
static void rygel_play_speed_finalize (RygelPlaySpeed * obj);
static GType rygel_play_speed_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

RygelPlaySpeed*
rygel_play_speed_construct (GType object_type,
                            gint numerator,
                            guint denominator)
{
	RygelPlaySpeed* self = NULL;
	self = (RygelPlaySpeed*) g_type_create_instance (object_type);
	self->numerator = numerator;
	self->denominator = denominator;
	return self;
}

RygelPlaySpeed*
rygel_play_speed_new (gint numerator,
                      guint denominator)
{
	return rygel_play_speed_construct (RYGEL_TYPE_PLAY_SPEED, numerator, denominator);
}

RygelPlaySpeed*
rygel_play_speed_construct_from_string (GType object_type,
                                        const gchar* speed,
                                        GError** error)
{
	RygelPlaySpeed* self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (speed != NULL, NULL);
	self = (RygelPlaySpeed*) g_type_create_instance (object_type);
	rygel_play_speed_parse (self, speed, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_rygel_play_speed_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

RygelPlaySpeed*
rygel_play_speed_new_from_string (const gchar* speed,
                                  GError** error)
{
	return rygel_play_speed_construct_from_string (RYGEL_TYPE_PLAY_SPEED, speed, error);
}

gboolean
rygel_play_speed_equals (RygelPlaySpeed* self,
                         RygelPlaySpeed* that)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (that != NULL, FALSE);
	if (that == NULL) {
		result = FALSE;
		return result;
	}
	if (self->numerator == that->numerator) {
		_tmp0_ = self->denominator == that->denominator;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
rygel_play_speed_is_positive (RygelPlaySpeed* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->numerator > 0;
	return result;
}

gboolean
rygel_play_speed_is_normal_rate (RygelPlaySpeed* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->numerator == 1) {
		_tmp0_ = self->denominator == ((guint) 1);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
rygel_play_speed_to_string (RygelPlaySpeed* self)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->denominator == ((guint) 1)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup_printf ("%i", self->numerator);
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf ("%d/%u", self->numerator, self->denominator);
		result = _tmp1_;
		return result;
	}
}

gfloat
rygel_play_speed_to_float (RygelPlaySpeed* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = ((gfloat) self->numerator) / self->denominator;
	return result;
}

gdouble
rygel_play_speed_to_double (RygelPlaySpeed* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = ((gdouble) self->numerator) / self->denominator;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
rygel_play_speed_parse (RygelPlaySpeed* self,
                        const gchar* speed,
                        GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (speed != NULL);
	if (!string_contains (speed, "/")) {
		self->numerator = atoi (speed);
		self->denominator = (guint) 1;
	} else {
		gchar** elements = NULL;
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint elements_length1;
		gint _elements_size_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		_tmp1_ = _tmp0_ = g_strsplit (speed, "/", 0);
		elements = _tmp1_;
		elements_length1 = _vala_array_length (_tmp0_);
		_elements_size_ = elements_length1;
		_tmp2_ = elements;
		_tmp2__length1 = elements_length1;
		if (_tmp2__length1 != 2) {
			gchar* msg = NULL;
			gchar* _tmp3_;
			const gchar* _tmp4_;
			GError* _tmp5_;
			_tmp3_ = g_strdup ("Missing/extra numerator/denominator in fraction %s");
			msg = _tmp3_;
			_tmp4_ = msg;
			_tmp5_ = g_error_new (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT, _tmp4_, speed);
			_inner_error0_ = _tmp5_;
			if (_inner_error0_->domain == RYGEL_PLAY_SPEED_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
				return;
			} else {
				_g_free0 (msg);
				elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_free0 (msg);
		}
		_tmp6_ = elements;
		_tmp6__length1 = elements_length1;
		_tmp7_ = _tmp6_[0];
		self->numerator = atoi (_tmp7_);
		_tmp8_ = elements;
		_tmp8__length1 = elements_length1;
		_tmp9_ = _tmp8_[1];
		self->denominator = (guint) atoi (_tmp9_);
		elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
	}
	if (self->numerator == 0) {
		gchar* msg = NULL;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		GError* _tmp15_;
		_tmp10_ = g_strdup ("Invalid numerator in speed %s");
		msg = _tmp10_;
		_tmp11_ = msg;
		_tmp12_ = g_strdup_printf (_tmp11_, speed);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_error_new_literal (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT, _tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		_inner_error0_ = _tmp15_;
		if (_inner_error0_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			return;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (msg);
	}
	if (self->denominator <= ((guint) 0)) {
		gchar* msg = NULL;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GError* _tmp20_;
		GError* _tmp21_;
		_tmp16_ = g_strdup ("Invalid numerator in speed %s");
		msg = _tmp16_;
		_tmp17_ = msg;
		_tmp18_ = g_strdup_printf (_tmp17_, speed);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_error_new_literal (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT, _tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp19_);
		_inner_error0_ = _tmp21_;
		if (_inner_error0_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			return;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (msg);
	}
}

static void
rygel_value_play_speed_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
rygel_value_play_speed_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_play_speed_unref (value->data[0].v_pointer);
	}
}

static void
rygel_value_play_speed_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_play_speed_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
rygel_value_play_speed_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
rygel_value_play_speed_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelPlaySpeed * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_play_speed_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
rygel_value_play_speed_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	RygelPlaySpeed ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_play_speed_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
rygel_param_spec_play_speed (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	RygelParamSpecPlaySpeed* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_PLAY_SPEED), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
rygel_value_get_play_speed (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_PLAY_SPEED), NULL);
	return value->data[0].v_pointer;
}

void
rygel_value_set_play_speed (GValue* value,
                            gpointer v_object)
{
	RygelPlaySpeed * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_PLAY_SPEED));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_PLAY_SPEED));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_play_speed_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_play_speed_unref (old);
	}
}

void
rygel_value_take_play_speed (GValue* value,
                             gpointer v_object)
{
	RygelPlaySpeed * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_PLAY_SPEED));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_PLAY_SPEED));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_play_speed_unref (old);
	}
}

static void
rygel_play_speed_class_init (RygelPlaySpeedClass * klass,
                             gpointer klass_data)
{
	rygel_play_speed_parent_class = g_type_class_peek_parent (klass);
	((RygelPlaySpeedClass *) klass)->finalize = rygel_play_speed_finalize;
}

static void
rygel_play_speed_instance_init (RygelPlaySpeed * self,
                                gpointer klass)
{
	self->ref_count = 1;
}

static void
rygel_play_speed_finalize (RygelPlaySpeed * obj)
{
	RygelPlaySpeed * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed);
	g_signal_handlers_destroy (self);
}

/**
 * This is a container for a PlaySpeed value.
 *
 * A Playspeed can be positive or negative whole numbers or fractions.
 * e.g. "2". "1/2", "-1/4"
 */
static GType
rygel_play_speed_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { rygel_value_play_speed_init, rygel_value_play_speed_free_value, rygel_value_play_speed_copy_value, rygel_value_play_speed_peek_pointer, "p", rygel_value_play_speed_collect_value, "p", rygel_value_play_speed_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (RygelPlaySpeedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_play_speed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaySpeed), 0, (GInstanceInitFunc) rygel_play_speed_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType rygel_play_speed_type_id;
	rygel_play_speed_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelPlaySpeed", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return rygel_play_speed_type_id;
}

GType
rygel_play_speed_get_type (void)
{
	static volatile gsize rygel_play_speed_type_id__once = 0;
	if (g_once_init_enter (&rygel_play_speed_type_id__once)) {
		GType rygel_play_speed_type_id;
		rygel_play_speed_type_id = rygel_play_speed_get_type_once ();
		g_once_init_leave (&rygel_play_speed_type_id__once, rygel_play_speed_type_id);
	}
	return rygel_play_speed_type_id__once;
}

gpointer
rygel_play_speed_ref (gpointer instance)
{
	RygelPlaySpeed * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
rygel_play_speed_unref (gpointer instance)
{
	RygelPlaySpeed * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_PLAY_SPEED_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

