/* rygel-lms-all-music.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-lms-all-music.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-lms.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sqlite3.h>
#include "rygel-server.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define RYGEL_LMS_ALL_MUSIC_SQL_ALL_TEMPLATE "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name as artist, " "audio_albums.name, " "files.mtime, " "audio_genres.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "LEFT JOIN audio_genres " "ON audios.genre_id = audio_genres.id " "WHERE dtime = 0 AND audios.id = files.id %s " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_ALL_MUSIC_SQL_COUNT "SELECT COUNT(audios.id) " "FROM audios, files " "WHERE dtime = 0 AND audios.id = files.id;"
#define RYGEL_LMS_ALL_MUSIC_SQL_COUNT_WITH_FILTER_TEMPLATE "SELECT COUNT(audios.id), audios.title as title, " "audio_artists.name as artist " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "WHERE dtime = 0 AND audios.id = files.id %s;"
#define RYGEL_LMS_ALL_MUSIC_SQL_FIND_OBJECT "SELECT files.id, files.path, files.size, " "audios.title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name, " "audio_albums.name, " "files.mtime, " "audio_genres.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "LEFT JOIN audio_genres " "ON audios.genre_id = audio_genres.id " "WHERE dtime = 0 AND files.id = ? AND audios.id = files.id;"
#define RYGEL_LMS_ALL_MUSIC_SQL_ADDED "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name as artist, " "audio_albums.name, " "files.mtime, " "audio_genres.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "LEFT JOIN audio_genres " "ON audios.genre_id = audio_genres.id " "WHERE dtime = 0 AND audios.id = files.id " "AND update_id > ? AND update_id <= ?;"
#define RYGEL_LMS_ALL_MUSIC_SQL_REMOVED "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name as artist, " "audio_albums.name, " "files.mtime, " "audio_genres.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "LEFT JOIN audio_genres " "ON audios.genre_id = audio_genres.id " "WHERE dtime <> 0 AND audios.id = files.id " "AND update_id > ? AND update_id <= ?;"

enum  {
	RYGEL_LMS_ALL_MUSIC_0_PROPERTY,
	RYGEL_LMS_ALL_MUSIC_NUM_PROPERTIES
};
static GParamSpec* rygel_lms_all_music_properties[RYGEL_LMS_ALL_MUSIC_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

static gpointer rygel_lms_all_music_parent_class = NULL;

static gchar* rygel_lms_all_music_real_get_sql_all_with_filter (RygelLMSCategoryContainer* base,
                                                         const gchar* filter);
static gchar* rygel_lms_all_music_real_get_sql_count_with_filter (RygelLMSCategoryContainer* base,
                                                           const gchar* filter);
static RygelMediaObject* rygel_lms_all_music_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                                  sqlite3_stmt* statement);
static GType rygel_lms_all_music_get_type_once (void);

static gchar*
rygel_lms_all_music_real_get_sql_all_with_filter (RygelLMSCategoryContainer* base,
                                                  const gchar* filter)
{
	RygelLMSAllMusic * self;
	gint _tmp0_;
	gint _tmp1_;
	gchar* filter_str = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	self = (RygelLMSAllMusic*) base;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = strlen (filter);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = rygel_lms_category_container_get_sql_all ((RygelLMSCategoryContainer*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = g_strdup_printf ("AND %s", filter);
	filter_str = _tmp5_;
	_tmp6_ = filter_str;
	_tmp7_ = g_strdup_printf (RYGEL_LMS_ALL_MUSIC_SQL_ALL_TEMPLATE, _tmp6_);
	result = _tmp7_;
	_g_free0 (filter_str);
	return result;
}

static gchar*
rygel_lms_all_music_real_get_sql_count_with_filter (RygelLMSCategoryContainer* base,
                                                    const gchar* filter)
{
	RygelLMSAllMusic * self;
	gint _tmp0_;
	gint _tmp1_;
	gchar* filter_str = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	self = (RygelLMSAllMusic*) base;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = strlen (filter);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = rygel_lms_category_container_get_sql_count ((RygelLMSCategoryContainer*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = g_strdup_printf ("AND %s", filter);
	filter_str = _tmp5_;
	_tmp6_ = filter_str;
	_tmp7_ = g_strdup_printf (RYGEL_LMS_ALL_MUSIC_SQL_COUNT_WITH_FILTER_TEMPLATE, _tmp6_);
	result = _tmp7_;
	_g_free0 (filter_str);
	return result;
}

static RygelMediaObject*
rygel_lms_all_music_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                sqlite3_stmt* statement)
{
	RygelLMSAllMusic * self;
	gint id = 0;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* mime_type = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gchar* title = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* song_id = NULL;
	gchar* _tmp12_;
	RygelMusicItem* song = NULL;
	RygelMusicItem* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GDateTime* dt = NULL;
	GDateTime* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	GFile* file = NULL;
	const gchar* _tmp24_;
	GFile* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	RygelMediaObject* result;
	self = (RygelLMSAllMusic*) base;
	g_return_val_if_fail (statement != NULL, NULL);
	id = sqlite3_column_int (statement, 0);
	_tmp0_ = (const gchar*) sqlite3_column_text (statement, 1);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp2_ = (const gchar*) sqlite3_column_text (statement, 10);
	_tmp3_ = g_strdup (_tmp2_);
	mime_type = _tmp3_;
	_tmp5_ = mime_type;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = mime_type;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ == 0;
	}
	if (_tmp4_) {
		const gchar* _tmp9_;
		_tmp9_ = path;
		g_debug ("rygel-lms-all-music.vala:143: Music item %d (%s) has no MIME type", id, _tmp9_);
	}
	_tmp10_ = (const gchar*) sqlite3_column_text (statement, 3);
	_tmp11_ = g_strdup (_tmp10_);
	title = _tmp11_;
	_tmp12_ = rygel_lms_category_container_build_child_id ((RygelLMSCategoryContainer*) self, id);
	song_id = _tmp12_;
	_tmp13_ = rygel_music_item_new (song_id, (RygelMediaContainer*) self, title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
	song = _tmp13_;
	rygel_media_file_item_set_size ((RygelMediaFileItem*) song, (gint64) sqlite3_column_int (statement, 2));
	rygel_music_item_set_track_number (song, sqlite3_column_int (statement, 4));
	rygel_audio_item_set_duration ((RygelAudioItem*) song, (glong) sqlite3_column_int (statement, 5));
	rygel_audio_item_set_channels ((RygelAudioItem*) song, sqlite3_column_int (statement, 6));
	rygel_audio_item_set_sample_freq ((RygelAudioItem*) song, sqlite3_column_int (statement, 7));
	rygel_audio_item_set_bitrate ((RygelAudioItem*) song, sqlite3_column_int (statement, 8));
	_tmp14_ = (const gchar*) sqlite3_column_text (statement, 9);
	rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) song, _tmp14_);
	_tmp15_ = mime_type;
	rygel_media_file_item_set_mime_type ((RygelMediaFileItem*) song, _tmp15_);
	_tmp16_ = (const gchar*) sqlite3_column_text (statement, 11);
	rygel_media_object_set_artist ((RygelMediaObject*) song, _tmp16_);
	_tmp17_ = (const gchar*) sqlite3_column_text (statement, 12);
	rygel_audio_item_set_album ((RygelAudioItem*) song, _tmp17_);
	_tmp18_ = g_date_time_new_from_unix_utc ((gint64) ((glong) sqlite3_column_int (statement, 13)));
	dt = _tmp18_;
	_tmp19_ = g_date_time_format (dt, "%Y-%m-%dT%H:%M:%S");
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup_printf ("%sZ", _tmp20_);
	_tmp22_ = _tmp21_;
	rygel_media_object_set_date ((RygelMediaObject*) song, _tmp22_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_tmp23_ = (const gchar*) sqlite3_column_text (statement, 14);
	rygel_media_object_set_genre ((RygelMediaObject*) song, _tmp23_);
	_tmp24_ = path;
	_tmp25_ = g_file_new_for_path (_tmp24_);
	file = _tmp25_;
	_tmp26_ = g_file_get_uri (file);
	_tmp27_ = _tmp26_;
	rygel_media_object_add_uri ((RygelMediaObject*) song, _tmp27_);
	_g_free0 (_tmp27_);
	result = (RygelMediaObject*) song;
	_g_object_unref0 (file);
	_g_date_time_unref0 (dt);
	_g_free0 (song_id);
	_g_free0 (title);
	_g_free0 (mime_type);
	_g_free0 (path);
	return result;
}

RygelLMSAllMusic*
rygel_lms_all_music_construct (GType object_type,
                               RygelMediaContainer* parent,
                               RygelLMSDatabase* lms_db)
{
	RygelLMSAllMusic * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_ALL_MUSIC_SQL_ALL_TEMPLATE, "");
	_tmp1_ = _tmp0_;
	self = (RygelLMSAllMusic*) rygel_lms_category_container_construct (object_type, "all", parent, _ ("All"), lms_db, _tmp1_, RYGEL_LMS_ALL_MUSIC_SQL_FIND_OBJECT, RYGEL_LMS_ALL_MUSIC_SQL_COUNT, RYGEL_LMS_ALL_MUSIC_SQL_ADDED, RYGEL_LMS_ALL_MUSIC_SQL_REMOVED);
	_g_free0 (_tmp1_);
	return self;
}

RygelLMSAllMusic*
rygel_lms_all_music_new (RygelMediaContainer* parent,
                         RygelLMSDatabase* lms_db)
{
	return rygel_lms_all_music_construct (RYGEL_LMS_TYPE_ALL_MUSIC, parent, lms_db);
}

static void
rygel_lms_all_music_class_init (RygelLMSAllMusicClass * klass,
                                gpointer klass_data)
{
	rygel_lms_all_music_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSCategoryContainerClass *) klass)->get_sql_all_with_filter = (gchar* (*) (RygelLMSCategoryContainer*, const gchar*)) rygel_lms_all_music_real_get_sql_all_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_sql_count_with_filter = (gchar* (*) (RygelLMSCategoryContainer*, const gchar*)) rygel_lms_all_music_real_get_sql_count_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = (RygelMediaObject* (*) (RygelLMSCategoryContainer*, sqlite3_stmt*)) rygel_lms_all_music_real_object_from_statement;
}

static void
rygel_lms_all_music_instance_init (RygelLMSAllMusic * self,
                                   gpointer klass)
{
}

static GType
rygel_lms_all_music_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLMSAllMusicClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_all_music_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSAllMusic), 0, (GInstanceInitFunc) rygel_lms_all_music_instance_init, NULL };
	GType rygel_lms_all_music_type_id;
	rygel_lms_all_music_type_id = g_type_register_static (RYGEL_LMS_TYPE_CATEGORY_CONTAINER, "RygelLMSAllMusic", &g_define_type_info, 0);
	return rygel_lms_all_music_type_id;
}

GType
rygel_lms_all_music_get_type (void)
{
	static volatile gsize rygel_lms_all_music_type_id__once = 0;
	if (g_once_init_enter (&rygel_lms_all_music_type_id__once)) {
		GType rygel_lms_all_music_type_id;
		rygel_lms_all_music_type_id = rygel_lms_all_music_get_type_once ();
		g_once_init_leave (&rygel_lms_all_music_type_id__once, rygel_lms_all_music_type_id);
	}
	return rygel_lms_all_music_type_id__once;
}

